"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionProductionReporting = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        accessCode: {
            access: 'accessCode',
        },
        group: {
            group: 'group',
        },
        automaticJournal: {
            code: 'automaticJournal',
        },
    },
};
let TransactionProductionReporting = class TransactionProductionReporting extends xtrem_core_1.Node {
};
exports.TransactionProductionReporting = TransactionProductionReporting;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BTSTYP',
    })
], TransactionProductionReporting.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BTSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TransactionProductionReporting.prototype, "transaction", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], TransactionProductionReporting.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BTSDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TransactionProductionReporting.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        provides: ['accessCode'],
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], TransactionProductionReporting.prototype, "accessCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], TransactionProductionReporting.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GFY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], TransactionProductionReporting.prototype, "group", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OFFLG',
    })
], TransactionProductionReporting.prototype, "isWorkOrderTracking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GAMFLG',
    })
], TransactionProductionReporting.prototype, "isRoutingTracking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DIVFLG',
    })
], TransactionProductionReporting.prototype, "isWorkCenterTracking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMFLG',
    })
], TransactionProductionReporting.prototype, "isBomTracking", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATRICULE',
        dataType: () => sageX3ManufacturingData.enums.enterMeasurementDatatype,
    })
], TransactionProductionReporting.prototype, "employeeEntry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMFLG',
    })
], TransactionProductionReporting.prototype, "isProductionReporting", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MATFLG',
    })
], TransactionProductionReporting.prototype, "isMaterialConsumption", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOCODDEF',
        dataType: () => sageX3MasterData.enums.stockWithdrawalModeDatatype,
    })
], TransactionProductionReporting.prototype, "stockWithdrawalMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRIT1',
        dataType: () => sageX3ManufacturingData.enums.operationSortCriteriaDatatype,
    })
], TransactionProductionReporting.prototype, "sortCriteria1", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRIT2',
        dataType: () => sageX3ManufacturingData.enums.operationSortCriteriaDatatype,
    })
], TransactionProductionReporting.prototype, "sortCriteria2", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CONSMAT',
        dataType: () => sageX3ManufacturingData.enums.materialConsumptionModeDatatype,
    })
], TransactionProductionReporting.prototype, "materialConsumption", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOCODMAN',
    })
], TransactionProductionReporting.prototype, "isManualOnly", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSAI',
        dataType: () => sageX3ManufacturingData.enums.defaultQuantityDatatype,
    })
], TransactionProductionReporting.prototype, "releaseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEUOMMOD',
    })
], TransactionProductionReporting.prototype, "isUnitCanBeModified", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEUOMTYP',
        dataType: () => sageX3ManufacturingData.enums.entryUnitDatatype,
    })
], TransactionProductionReporting.prototype, "defaultUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPLUPDFLG',
    })
], TransactionProductionReporting.prototype, "isPreloading", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], TransactionProductionReporting.prototype, "automaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOMSAIFLG',
    })
], TransactionProductionReporting.prototype, "isUOMEntry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOMSAIFLG1',
    })
], TransactionProductionReporting.prototype, "isEnterPac", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRNCOD1',
        dataType: () => sageX3StockData.enums.labelPrintingDatatype,
    })
], TransactionProductionReporting.prototype, "labelPrinting", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRNSCR1',
        dataType: () => sageX3System.enums.formOrTableEntryModeDatatype,
    })
], TransactionProductionReporting.prototype, "formTableEntryModePrinting", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRNNBFLG1',
    })
], TransactionProductionReporting.prototype, "isNumberOfPrints", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRNNBSCR1',
        dataType: () => sageX3System.enums.formOrTableEntryModeDatatype,
    })
], TransactionProductionReporting.prototype, "formTableEntryModeNumberOfPrints", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AVSTOCOD1',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], TransactionProductionReporting.prototype, "entryModeAvailableStock", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AVSTOSCR1',
        dataType: () => sageX3System.enums.formOrTableEntryModeDatatype,
    })
], TransactionProductionReporting.prototype, "formTableEntryModeAvailableStock", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPERFLG',
    })
], TransactionProductionReporting.prototype, "isExpiration", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPOTFLG',
    })
], TransactionProductionReporting.prototype, "isPotency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB1FLG',
    })
], TransactionProductionReporting.prototype, "isLotCustomText1", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB2FLG',
    })
], TransactionProductionReporting.prototype, "isLotCustomText2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB3FLG',
    })
], TransactionProductionReporting.prototype, "isLotCustomNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB4FLG',
    })
], TransactionProductionReporting.prototype, "isLotCustomDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCECODS',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], TransactionProductionReporting.prototype, "entryModeAnalyticalDimension", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKFLG',
    })
], TransactionProductionReporting.prototype, "isAutomaticIssue", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRGWAIFLG',
    })
], TransactionProductionReporting.prototype, "isReceiptAtDock", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATFLTFLG',
        dataType: () => sageX3ManufacturingData.enums.filterOperationsDatatype,
    })
], TransactionProductionReporting.prototype, "materialFilterOperation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMFLTFLG',
        dataType: () => sageX3ManufacturingData.enums.filterOperationsDatatype,
    })
], TransactionProductionReporting.prototype, "productFilterOperation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHCOD',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], TransactionProductionReporting.prototype, "entryModeWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WRHOBY',
    })
], TransactionProductionReporting.prototype, "isSingleWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNPMAT',
    })
], TransactionProductionReporting.prototype, "unplannedMaterials", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNPOPE',
    })
], TransactionProductionReporting.prototype, "unplannedOperations", void 0);
exports.TransactionProductionReporting = TransactionProductionReporting = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BENCHTRS',
        keyPropertyNames: ['type', 'transaction'],
        indexes: [
            {
                orderBy: {
                    type: 1,
                    transaction: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['type', 'transaction'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TransactionProductionReporting);
//# sourceMappingURL=transaction-production-reporting.js.map