"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardOperations = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        mainWorkCenter: {
            code: 'mainWorkCenter',
            manufacturingSite: 'site',
        },
        workCenterGroup: {
            code: 'workCenterGroup',
        },
        laborWorkCenter: {
            code: 'laborWorkCenter',
            manufacturingSite: 'site',
        },
        laborWorkCenterGroup: {
            code: 'laborWorkCenterGroup',
        },
        operationUom: {
            code: 'operationUom',
        },
        technicalSheet: {
            technicalSheet: 'technicalSheet',
            lineNumber() {
                return 1;
            },
        },
        tools: {
            code: 'tools',
        },
        subcontractedProducts: {
            code: 'subcontractedProducts',
        },
        subcontractWorkCenter: {
            code: 'subcontractWorkCenter',
            manufacturingSite: 'site',
        },
        subcontractWorkCenterGroup: {
            code: 'subcontractWorkCenterGroup',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        businessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            entityNumber: 'businessPartner',
            code: 'businessPartnerAddress',
        },
    },
};
let StandardOperations = class StandardOperations extends xtrem_core_1.Node {
};
exports.StandardOperations = StandardOperations;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STDOPENUM',
    })
], StandardOperations.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StandardOperations.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STDOPEDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], StandardOperations.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], StandardOperations.prototype, "mainWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WCR',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenterGroup,
    })
], StandardOperations.prototype, "workCenterGroup", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WSTTYP',
        dataType: () => sageX3ManufacturingData.enums.workCenterTypeDatatype,
    })
], StandardOperations.prototype, "mainWorkCenterType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LABWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], StandardOperations.prototype, "laborWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LABWCR',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenterGroup,
    })
], StandardOperations.prototype, "laborWorkCenterGroup", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LABWSTTYP',
        dataType: () => sageX3ManufacturingData.enums.workCenterTypeDatatype,
    })
], StandardOperations.prototype, "laborWorkCenterType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SETLABCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "laborTimeSetupFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPELABCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "laborRunTimeFactor", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TIMUOMCOD',
        dataType: () => sageX3ManufacturingData.enums.timeUnitCodeDatatype,
    })
], StandardOperations.prototype, "timeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TIMCOD',
        dataType: () => sageX3ManufacturingData.enums.operationTimeCodesDatatype,
    })
], StandardOperations.prototype, "managementUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "baseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StandardOperations.prototype, "operationUom", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEPLNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "operationPlan", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEROUPCT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "operationImage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPETEXNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "operationText", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TECCRD',
        columnType: 'string',
        filters: {
            lookup: {
                lineNumber: 1,
            },
            control: {
                lineNumber: 1,
            },
        },
        node: () => sageX3MasterData.nodes.TechnicalSheet,
    })
], StandardOperations.prototype, "technicalSheet", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EQUNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StandardOperations.prototype, "tools", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FXGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "fixture", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "program", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WSTNBR',
    })
], StandardOperations.prototype, "numberOfRessources", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LABNBR',
    })
], StandardOperations.prototype, "numberLaborRessources", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EFF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "efficiencyPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "shrinkagePercentage", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROOTIMCOD',
        dataType: () => sageX3ManufacturingData.enums.runTimeTypeDatatype,
    })
], StandardOperations.prototype, "runTimeType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRPTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "preparationTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SETTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "setupTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPETIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "runTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CAD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "rate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WAITIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "waitingTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PSPTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "postRunTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOCOD',
        dataType: () => sageX3ManufacturingData.enums.subcontractingDatatype,
    })
], StandardOperations.prototype, "subcontractCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StandardOperations.prototype, "subcontractedProducts", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], StandardOperations.prototype, "subcontractWorkCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOWCR',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenterGroup,
    })
], StandardOperations.prototype, "subcontractWorkCenterGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], StandardOperations.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.Address,
    })
], StandardOperations.prototype, "businessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "referencePrice", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPLCOD',
        dataType: () => sageX3ManufacturingData.enums.splittingDatatype,
    })
], StandardOperations.prototype, "splitting", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPLMAXNBR',
    })
], StandardOperations.prototype, "maximumSplits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSTMAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "machineRestriction", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCHGRP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "groupingCriterion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCHGRPFOR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StandardOperations.prototype, "groupingFormula", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRPSETTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StandardOperations.prototype, "groupSetupTime", void 0);
exports.StandardOperations = StandardOperations = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ROUOPESTD',
        keyPropertyNames: ['code', 'site'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    site: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StandardOperations);
//# sourceMappingURL=standard-operations.js.map