import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
export declare class StandardOperations extends Node {
    readonly code: Promise<integer>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly description: Promise<string>;
    readonly mainWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup>;
    readonly mainWorkCenterType: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly laborWorkCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
    readonly laborWorkCenterType: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
    readonly laborTimeSetupFactor: Promise<decimal | null>;
    readonly laborRunTimeFactor: Promise<decimal | null>;
    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
    readonly managementUnit: Promise<sageX3ManufacturingData.enums.OperationTimeCodes | null>;
    readonly baseQuantity: Promise<decimal | null>;
    readonly operationUom: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly operationPlan: Promise<string>;
    readonly operationImage: Promise<string>;
    readonly operationText: Promise<string>;
    readonly technicalSheet: Reference<sageX3MasterData.nodes.TechnicalSheet | null>;
    readonly tools: Reference<sageX3MasterData.nodes.Product | null>;
    readonly fixture: Promise<string>;
    readonly program: Promise<string>;
    readonly numberOfRessources: Promise<integer | null>;
    readonly numberLaborRessources: Promise<integer | null>;
    readonly efficiencyPercentage: Promise<decimal | null>;
    readonly shrinkagePercentage: Promise<decimal | null>;
    readonly runTimeType: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
    readonly preparationTime: Promise<decimal | null>;
    readonly setupTime: Promise<decimal | null>;
    readonly runTime: Promise<decimal | null>;
    readonly rate: Promise<decimal | null>;
    readonly waitingTime: Promise<decimal | null>;
    readonly postRunTime: Promise<decimal | null>;
    readonly subcontractCode: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
    readonly subcontractedProducts: Reference<sageX3MasterData.nodes.Product | null>;
    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly subcontractWorkCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly businessPartnerAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly referencePrice: Promise<decimal | null>;
    readonly splitting: Promise<sageX3ManufacturingData.enums.Splitting | null>;
    readonly maximumSplits: Promise<integer | null>;
    readonly machineRestriction: Promise<string>;
    readonly groupingCriterion: Promise<string>;
    readonly groupingFormula: Promise<string>;
    readonly groupSetupTime: Promise<decimal | null>;
}
//# sourceMappingURL=standard-operations.d.ts.map