"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoutingHeader = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        routing: {
            code: 'routing',
        },
        routingCode: {
            code: 'routingCode',
        },
        site: {
            code: 'site',
        },
        accessCode: {
            access: 'accessCode',
        },
    },
    localizedStrings: {
        description: {
            tableName() {
                return 'ROUTING';
            },
            columnName() {
                return 'ROUDESAXX';
            },
            key1: ['routing', 'routingCode'],
            key2: ['site'],
        },
    },
};
let RoutingHeader = class RoutingHeader extends xtrem_core_1.Node {
};
exports.RoutingHeader = RoutingHeader;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], RoutingHeader.prototype, "routing", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROUALT',
        columnType: 'integer',
        node: () => sageX3MasterData.nodes.BomRouting,
    })
], RoutingHeader.prototype, "routingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], RoutingHeader.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROUDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], RoutingHeader.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USESTA',
        dataType: () => sageX3MasterData.enums.useStatusDatatype,
    })
], RoutingHeader.prototype, "useStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFMFLG',
    })
], RoutingHeader.prototype, "isValidated", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROUSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], RoutingHeader.prototype, "validityStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROUENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], RoutingHeader.prototype, "validityEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TIMUOMCOD',
        dataType: () => sageX3ManufacturingData.enums.timeUnitCodeDatatype,
    })
], RoutingHeader.prototype, "timeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WORTYP',
        dataType: () => sageX3ManufacturingData.enums.workOrderManagementModeDatatype,
    })
], RoutingHeader.prototype, "workOrderManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RoutingHeader.prototype, "routingHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RoutingHeader.prototype, "routingHeaderPlan", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROUPCT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RoutingHeader.prototype, "routingHeaderImage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WORMINQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], RoutingHeader.prototype, "minimumReleaseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WORMAXQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], RoutingHeader.prototype, "maximumReleaseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASWORQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], RoutingHeader.prototype, "lastReleaseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASWORDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], RoutingHeader.prototype, "lastReleaseDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFGVCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CfgActivityCode],
    })
], RoutingHeader.prototype, "journalNumberConfig", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], RoutingHeader.prototype, "accessCode", void 0);
exports.RoutingHeader = RoutingHeader = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ROUTING',
        keyPropertyNames: ['routing', 'routingCode', 'site'],
        indexes: [
            {
                orderBy: {
                    routing: 1,
                    routingCode: 1,
                    site: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], RoutingHeader);
//# sourceMappingURL=routing-header.js.map