"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductSiteAttribute = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        product: {
            product: 'product',
            stockSite: 'stockSite',
        },
        stockSite: {
            code: 'stockSite',
        },
        attributeCode: {
            attributeCode: 'attributeCode',
        },
        attributeValue: {
            attributeCode: 'attributeCode',
            attributeValue: 'attributeValue',
        },
    },
};
let ProductSiteAttribute = class ProductSiteAttribute extends xtrem_core_1.Node {
};
exports.ProductSiteAttribute = ProductSiteAttribute;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductSite,
    })
], ProductSiteAttribute.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], ProductSiteAttribute.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ATTCOD',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.Attribute,
    })
], ProductSiteAttribute.prototype, "attributeCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ATTVALCOD',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.AttributeLine,
    })
], ProductSiteAttribute.prototype, "attributeValue", void 0);
exports.ProductSiteAttribute = ProductSiteAttribute = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GFSITFATTV',
        keyPropertyNames: ['product', 'stockSite', 'attributeCode'],
        indexes: [
            {
                orderBy: {
                    product: 1,
                    stockSite: 1,
                    attributeCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['product', 'stockSite'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.GfsaActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProductSiteAttribute);
//# sourceMappingURL=product-site-attribute.js.map