"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OptimizationLine = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        optimizationCode: {
            optimizationCode: 'optimizationCode',
        },
        setupTimeCode: {
            setupTimeCode: 'setupTimeCode',
        },
    },
};
let OptimizationLine = class OptimizationLine extends xtrem_core_1.Node {
};
exports.OptimizationLine = OptimizationLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPTCOD',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.Optimization,
    })
], OptimizationLine.prototype, "optimizationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OPTSEQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OptimizationLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MATCOD',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.SetupTime,
    })
], OptimizationLine.prototype, "setupTimeCode", void 0);
exports.OptimizationLine = OptimizationLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GFSOPTLIN',
        keyPropertyNames: ['optimizationCode', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    optimizationCode: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.GfsaActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OptimizationLine);
//# sourceMappingURL=optimization-line.js.map