"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FiniteSchedulerObject = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
    },
};
let FiniteSchedulerObject = class FiniteSchedulerObject extends xtrem_core_1.Node {
    static maintainFiniteSchedulerObject(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'FiniteSchedulerObject', 'maintainFiniteSchedulerObject', parameters);
    }
};
exports.FiniteSchedulerObject = FiniteSchedulerObject;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], FiniteSchedulerObject.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "object", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "identifier1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "identifier2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INF1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "information1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INF2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "information2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INF3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "information3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INF4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FiniteSchedulerObject.prototype, "information4", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CREDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], FiniteSchedulerObject.prototype, "createDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DELFLG',
    })
], FiniteSchedulerObject.prototype, "deletionFlag", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: MaintainFiniteSchedulerObject */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    object: {
                        isMandatory: true,
                        type: 'string',
                    },
                    site: {
                        isMandatory: true,
                        type: 'string',
                    },
                    timestamp: {
                        isMandatory: true,
                        type: 'string',
                    },
                    oStatus: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    oMessage: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                oStatus: {
                    isMandatory: true,
                    type: 'integer',
                },
                oMessage: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], FiniteSchedulerObject, "maintainFiniteSchedulerObject", null);
exports.FiniteSchedulerObject = FiniteSchedulerObject = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GFSOBJ',
        keyPropertyNames: ['site', 'object', 'identifier1', 'identifier2'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    object: 1,
                    identifier1: 1,
                    identifier2: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['identifier1', 'identifier2'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], FiniteSchedulerObject);
//# sourceMappingURL=finite-scheduler-object.js.map