"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Attribute = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    collectionJoins: {
        attributeLines: {
            attributeCode: 'attributeCode',
        },
    },
};
let Attribute = class Attribute extends xtrem_core_1.Node {
};
exports.Attribute = Attribute;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ATTCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Attribute.prototype, "attributeCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ATTDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Attribute.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.AttributeLine,
        isMutable: true,
        dependsOn: ['attributeCode'],
    })
], Attribute.prototype, "attributeLines", void 0);
exports.Attribute = Attribute = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GFSATT',
        keyPropertyNames: ['attributeCode'],
        indexes: [
            {
                orderBy: {
                    attributeCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.GfsaActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Attribute);
//# sourceMappingURL=attribute.js.map