"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateWithDetails = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const ui = require("@sage/xtrem-ui");
//TODO: not a fan of passing "this" in argument as the execution context. Class constructor, bind?
async function validateWithDetails(pageInstance) {
    await pageInstance.$.commitValueAndPropertyChanges(); // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field
    const errors = await pageInstance.$.page.validateWithDetails();
    if (typesLib.strictEq(errors.length, 0)) {
        return true;
    }
    pageInstance.$.removeToasts();
    pageInstance.$.showToast(ui.localize('@sage/x3-manufacturing/pages__utils__notification__invalid_inputs_error', `Please check your inputs for {{#each fieldNames}}\n - {{this}}{{/each}}`, {
        fieldNames: errors.map((error) => 
        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type
        `${pageInstance[error.elementId]?.title ?? error.elementId}`),
    }), { type: 'error', timeout: 5000 });
    return false;
}
exports.validateWithDetails = validateWithDetails;
//# sourceMappingURL=validation.js.map