"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUOMNumberOfDecimalPlaces = void 0;
const ui = require("@sage/xtrem-ui");
// Get Unit of measure decimal places
async function GetUOMNumberOfDecimalPlaces(pageInstance, uom) {
    try {
        const NumberofDecimals = await pageInstance.$.graph
            .node('@sage/x3-master-data/UnitOfMeasure')
            .read({
            code: true,
            numberOfDecimals: true,
        }, `${uom}`)
            .execute();
        return NumberofDecimals.numberOfDecimals;
    }
    catch (e) {
        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__utils__get_unit_decimal_places_error', 'Error loading unit'), String(e));
        return 0;
    }
}
exports.GetUOMNumberOfDecimalPlaces = GetUOMNumberOfDecimalPlaces;
//# sourceMappingURL=get-unit-decimal-places.js.map