"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable @typescript-eslint/no-unused-expressions */
const chai_1 = require("chai");
const fs = require("fs");
const path = require("path");
const sinon = require("sinon");
const transformers_1 = require("../lib/transformers");
const test_helper_1 = require("./test-helper");
const FIXTURE_PAGE = path.resolve('./test/fixtures/test-app/lib/pages/action-buttons.ts');
const FIXTURE_NODE = path.resolve('./test/fixtures/test-app/lib/nodes/address.ts');
function removeFolder(p) {
    if (fs.existsSync(p)) {
        fs.readdirSync(p).forEach(file => {
            const curPath = `${p}/${file}`;
            if (fs.lstatSync(curPath).isDirectory()) {
                removeFolder(curPath);
            }
            else {
                fs.unlinkSync(curPath);
            }
        });
        fs.rmdirSync(p);
    }
}
describe('Transformers', () => {
    let writeFileStub;
    beforeEach(() => {
        removeFolder(path.join(__dirname, 'fixtures/test-app/build/lib/pages'));
        removeFolder(path.join(__dirname, 'fixtures/test-app/build/lib/nodes'));
        removeFolder(path.join(__dirname, 'fixtures/test-app/lib/i18n'));
        writeFileStub = (() => {
            const original = fs.writeFileSync;
            return sinon
                .stub(fs, 'writeFileSync')
                .callsFake((filePath, data, options) => {
                if (typeof filePath !== 'string' || /platform[\\/]shared[\\/]xtrem-i18n/.test(filePath)) {
                    original(filePath, data, options);
                }
            });
        })();
    });
    afterEach(() => {
        writeFileStub.restore();
    });
    after(() => {
        removeFolder(path.join(__dirname, 'fixtures/test-app/build/lib/pages'));
        removeFolder(path.join(__dirname, 'fixtures/test-app/build/lib/nodes'));
        removeFolder(path.join(__dirname, 'fixtures/test-app/lib/i18n'));
    });
    it('should transpile page with decorator & message transformer', () => {
        (0, test_helper_1.transpileFixtures)([FIXTURE_PAGE], [transformers_1.decoratorTransformer, transformers_1.messageTransformer]);
        (0, chai_1.expect)(fs.existsSync(path.join(__dirname, 'fixtures/test-app/build/shared/xtrem-i18n/test/fixtures/test-app/lib/pages/action-buttons.js'))).to.be.true;
    });
    xit('should generate dictionary containing entries from both pages and nodes', () => {
        (0, test_helper_1.transpileFixtures)([FIXTURE_PAGE, FIXTURE_NODE], [transformers_1.decoratorTransformer, transformers_1.messageTransformer]);
        (0, chai_1.expect)(fs.existsSync(path.join(__dirname, 'fixtures/test-app/build/shared/xtrem-i18n/test/fixtures/test-app/lib/pages/action-buttons.js'))).to.be.true;
        (0, chai_1.expect)(fs.existsSync(path.join(__dirname, 'fixtures/test-app/build/shared/xtrem-i18n/test/fixtures/test-app/lib/nodes/address.js'))).to.be.true;
        const baseDictionary = JSON.parse(fs.readFileSync(path.join(__dirname, 'fixtures/test-app/lib/i18n/base.json'), 'utf8'));
        (0, chai_1.expect)(baseDictionary).to.include({ '@sage/test-i18n-app/customKey': 'custom value' });
    });
});
//# sourceMappingURL=transformer-test.js.map