"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transpileFixtures = exports.transpileFixture = void 0;
/* eslint-disable no-console */
const fs = require("fs");
const path = require("path");
const ts = require("typescript");
const transpileFixture = (fileName, beforeTransformers) => {
    const source = fs.readFileSync(fileName, 'utf-8');
    const result = ts.transpileModule(source, {
        fileName,
        compilerOptions: { module: ts.ModuleKind.CommonJS },
        transformers: { before: beforeTransformers },
    });
    return result.outputText;
};
exports.transpileFixture = transpileFixture;
const transpileFixtures = (files, beforeTransformers) => {
    const program = ts.createProgram([path.join(__dirname, '../../../front-end/xtrem-ui/lib/module-types.d.ts'), ...files], {
        baseUrl: path.join(__dirname, '..'),
        outDir: path.join(__dirname, './fixtures/test-app/build'),
        module: ts.ModuleKind.ESNext,
        moduleResolution: ts.ModuleResolutionKind.NodeJs,
        experimentalDecorators: true,
        paths: {
            '@sage/xtrem-ui': ['../../front-end/xtrem-ui/lib'],
            '@sage/xtrem-core': ['../../back-end/xtrem-core'],
        },
        lib: ['lib.es2020.d.ts', 'lib.esnext.d.ts', 'lib.dom.d.ts'],
        target: ts.ScriptTarget.ES2020,
        esModuleInterop: true,
        resolveJsonModule: true,
        jsx: ts.JsxEmit.React,
        ignoreDeprecations: '5.0',
        suppressImplicitAnyIndexErrors: true,
        allowSyntheticDefaultImports: true,
        skipDefaultLibCheck: true,
    });
    const emitResult = program.emit(undefined, undefined, undefined, undefined, {
        before: beforeTransformers,
    });
    const allDiagnostics = ts.getPreEmitDiagnostics(program).concat(emitResult.diagnostics);
    allDiagnostics.forEach(printCompilerError);
    return emitResult.emittedFiles;
};
exports.transpileFixtures = transpileFixtures;
const printCompilerError = (diagnostic) => {
    if (diagnostic.file && diagnostic.start) {
        const { line, character } = diagnostic.file.getLineAndCharacterOfPosition(diagnostic.start);
        const message = ts.flattenDiagnosticMessageText(diagnostic.messageText, '\n').trim();
        console.log(`${diagnostic.file.fileName} (${line + 1},${character + 1}): ${message}`);
    }
    else {
        console.log(`${ts.flattenDiagnosticMessageText(diagnostic.messageText, '\n').trim()}`);
    }
};
//# sourceMappingURL=test-helper.js.map