"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const path = require("path");
const sinon = require("sinon");
const mi = require("../lib/transformers/menu-item-transformer");
const test_helper_1 = require("./test-helper");
const FIXTURE_PAGE = path.resolve('./test/fixtures/test-app/lib/pages/action-buttons.ts');
const FIXTURE_MENU_ITEMS = path.resolve('./test/fixtures/test-app/lib/menu-items/show-case.ts');
describe('Menu Item Transformer', () => {
    let visitorSpy;
    beforeEach(() => {
        visitorSpy = sinon.spy(mi, 'visitor');
    });
    afterEach(() => {
        visitorSpy.restore();
    });
    describe('test menuItemTransformer', () => {
        it('make sure visitor spy is not null when visiting action-buttons.ts', () => {
            (0, test_helper_1.transpileFixtures)([FIXTURE_PAGE], [mi.menuItemTransformer]);
            (0, chai_1.expect)(visitorSpy.getCalls().length).to.be.equal(0);
        });
        it('make sure visitor spy is not null when visiting show-case.ts', () => {
            (0, test_helper_1.transpileFixtures)([FIXTURE_MENU_ITEMS], [mi.menuItemTransformer]);
            (0, chai_1.expect)(visitorSpy.getCalls().length).to.be.equal(28);
        });
    });
});
//# sourceMappingURL=menu-item-transformer-test.js.map