"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const path = require("path");
const sinon = require("sinon");
const dt = require("../lib/transformers/data-type-name-extractor");
const transformerUtils = require("../lib/transformers/transformer-utils");
const test_helper_1 = require("./test-helper");
const FIXTURE_DATA_TYPE = path.resolve('./test/fixtures/test-app/lib/data-types/test-data-type.ts');
const FIXTURE_ENUM = path.resolve('./test/fixtures/test-app/lib/enums/saleable-product-line-origin.ts');
describe('DataTypes Transformer', () => {
    let writeLiteralsStub;
    beforeEach(() => {
        writeLiteralsStub = sinon.stub(transformerUtils, 'writeStringLiteralsToBase');
    });
    afterEach(() => {
        writeLiteralsStub.restore();
    });
    describe('data-types', () => {
        it('should extract data types from /data-types', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_DATA_TYPE, [dt.dataTypesNameExtractor]);
            const call = writeLiteralsStub.getCall(0);
            const dictionary = call.args[0];
            (0, chai_1.expect)(Object.keys(dictionary).length).to.eq(2);
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/data_types__string_data_type__name']).to.be.eq('String data type');
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/data_types__decimal_data_type__name']).to.be.eq('Decimal data type');
        });
        it('should extract enums data types from /enums', () => {
            (0, test_helper_1.transpileFixture)(FIXTURE_ENUM, [dt.dataTypesNameExtractor]);
            const call = writeLiteralsStub.getCall(0);
            const dictionary = call.args[0];
            (0, chai_1.expect)(Object.keys(dictionary).length).to.eq(1);
            (0, chai_1.expect)(dictionary['@sage/test-i18n-app/data_types__saleable_product_line_origin_enum__name']).to.be.eq('Saleable product line origin enum');
        });
    });
});
//# sourceMappingURL=data-type-transformer-test.js.map