import { Dict } from '@sage/xtrem-shared';
import * as ts from 'typescript';
export declare const literalsCache: Dict<any>;
/**
 * Turn nested bind property reference object to dot-notion reference. For example, it converts `{this:{is:{a:{nested:{bind:true}}}}}`
 * to `this__is__a__nested__bind`.
 * @param bind string or deep bind object
 * @returns dot notion deep reference string
 */
export declare const convertDeepBindToPath: (bind?: any) => string | null;
/**
 * Creates a dictionary key
 * @param prefix prefix for the generated key
 * @param key translation key
 * @returns dictionary key
 */
export declare const createDictionaryKey: (prefix: string, key: string, decoratorContext?: Dict<any>) => string;
/**
 * Determines whether the given file is a page or a sticker
 * @param file
 * @returns true if file is a page or a sticker
 */
export declare function isClientArtifactFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is a node or node-extension
 * @param file
 * @returns true if file is a node or node-extension
 */
export declare function isNodeLikeArtifactFile(file: ts.SourceFile): boolean;
export declare function isNodeArtifactFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is a service option
 * @param file
 * @returns true if file is a service option
 */
export declare function isServiceOptionFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is an activity
 * @param file
 * @returns true if file is an activity
 */
export declare function isActivityFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is a dataType
 * @param file
 * @returns true if file is an dataType
 */
export declare function isDataTypeFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is a test file
 * @param file
 * @returns true if file is a test file
 */
export declare function isTestFile(file: ts.SourceFile): boolean;
/**
 * Determines whether the given file is an enum file
 * @param file
 * @returns true if file is an enum file
 */
export declare function isEnumFile(file: ts.SourceFile): boolean;
/**
 * Returns a copy of the target without the properties received as second parameter
 * @returns a copy of target without the given properties
 */
export declare const excludeProperties: (target: Dict<string>, properties: string[]) => Dict<string>;
export declare const sortByKey: (dict: Dict<string>) => Dict<string>;
export declare const getLocaleFilePath: (dir: string, locale: string, isBuild?: boolean) => string;
export declare function merge(target: Dict<string>, source: Dict<string>): Dict<string>;
export declare function writeStringLiteralsToBase(currentLiterals: Dict<string>, dir: string): void;
export interface ClientArtifactUsedLiterals {
    strings: string[];
    enums: string[];
}
/**
 * Adds dictionary entry
 * @param key the translation key
 * @param value the translation value
 * @returns the newly created key
 */
export declare function addDictionaryEntry(dictionary: Dict<string>, key: string, value: string): string;
//# sourceMappingURL=transformer-utils.d.ts.map