import { Dict } from '@sage/xtrem-shared';
import * as ts from 'typescript';
/**
 * Typescript visitor
 * @param ctx the transformation context
 */
export declare const visitor: (dictionary: Dict<string>, pkgName: string, fileName: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
/**
 * This transformer is meant to be run AFTER the 'decorator-transformer' for pages/stickers &
 * for every source file of an em-core package
 * @param ctx the transformation context
 * @returns the transformed file
 */
export declare function messageTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
export declare function tsPatchMessageTransformer(): typeof messageTransformer;
//# sourceMappingURL=message-transformer.d.ts.map