import { Dict } from '@sage/xtrem-shared';
import * as ts from 'typescript';
/**
 * Top-level TS visitor
 * @param prefix prefix for translation keys
 */
export declare const visitor: (dictionary: Dict<string>, prefix: string, ctx: ts.TransformationContext) => (node: ts.Node) => ts.Node;
/**
 * This transformer is meant to be run BEFORE the 'message-transformer' and its purpose is
 * to wrap some page/sticker decorator properties (see 'includedProperties') with a call to the 'ui.localize' function.
 *
 * @param ctx transformation context
 * @returns the transformed file
 */
export declare function decoratorTransformer(ctx: ts.TransformationContext): ts.Transformer<ts.SourceFile>;
//# sourceMappingURL=decorator-transformer.d.ts.map