import { Dict, LocalizeLocale } from '@sage/xtrem-shared';
export interface LocalizedLiteral {
    key: string;
    content: string;
}
export declare function getKey(param: {
    isExtension?: boolean;
    packageName: string;
    nodeName: string;
    operation?: {
        kind: string;
        name: string;
    };
}): string;
export declare function resetDictionary(): void;
export declare function getLocaleFromString(stringLocale?: string): LocalizeLocale;
/**
 * Reads all i18n JSON files of the current Etna application and puts them to the memory.
 * */
export declare function initializeLocalizationResolver(loadedPackages: {
    dir: string;
    name: string;
}[], dir: string): void;
export declare function addBundleLocalizationKeys(bundleStrings: Dict<Dict<string>>): void;
/**
 * Resolves a single key to a string literal
 *
 * @param key key to lookup, requires exact match
 * @param locale optional, if not provided it will use f-stream's context
 */
export declare function getLiteral(key: string, locale: LocalizeLocale): LocalizedLiteral;
/**
 * Resolves a set of to a string literals
 *
 * @param keyStartsWith used to match
 * @param locale optional, if not provided it will use f-stream's context
 */
export declare function getLiterals(keyStartsWith: string, locale: LocalizeLocale): LocalizedLiteral[];
/**
 * Resolves a set of to a string literals
 *
 * @param keyStartsWith used to match
 * @param locale locale used to collect lirarals
 * @param literals array to push literals
 */
export declare function appendLiterals(keyStartsWith: string, locale: LocalizeLocale, literals: LocalizedLiteral[]): LocalizedLiteral[];
//# sourceMappingURL=resolver.d.ts.map