// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/index.d.ts
declare module '@sage/xtrem-core/index' {
	/** @packageDocumentation @module index */
	import type * as TestFixtures from '@sage/xtrem-core/test/fixtures/index';
	export * from '@sage/xtrem-core/lib/index';
	export * from '@sage/xtrem-core/lib/sql/sql-context/index';
	export * from '@sage/xtrem-core/lib/test/manager-mocks/index';
	export function getTestFixtures(): typeof TestFixtures;
	/**
	 * Interface hook for context module augmentation
	 * Other system packages can add their own API to the Context class by extending this interface
	 * @sage/xtrem-communication uses this to add the `send` and `notify` methods.
	 *
	 * Note: this interface must be defined *here*. Do not move it to lib/runtime/context.ts because
	 * external modules cannot reference modules like @sage/xtrem-core/lib/...
	 */
	export interface ContextAugmentation {
	}
	declare module '@sage/xtrem-core/lib/runtime/context' {
	    interface Context extends ContextAugmentation {
	    }
	}
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/index.d.ts
declare module '@sage/xtrem-core/test/index' {
	import * as fixtures from '@sage/xtrem-core/test/fixtures/index';
	export * from '@sage/xtrem-core/test/fixtures/applications';
	export { fixtures };
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/test/test-with-context-test.d.ts
declare module '@sage/xtrem-core/test/test/test-with-context-test' {
	export {};
	//# sourceMappingURL=test-with-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/test/test-options-test.d.ts
declare module '@sage/xtrem-core/test/test/test-options-test' {
	export {};
	//# sourceMappingURL=test-options-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/test/mocker-test.d.ts
declare module '@sage/xtrem-core/test/test/mocker-test' {
	export {};
	//# sourceMappingURL=mocker-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/test/assert-utils-test.d.ts
declare module '@sage/xtrem-core/test/test/assert-utils-test' {
	export {};
	//# sourceMappingURL=assert-utils-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/synchronization/synchronization-target-test.d.ts
declare module '@sage/xtrem-core/test/synchronization/synchronization-target-test' {
	export {};
	//# sourceMappingURL=synchronization-target-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/synchronization/synchronization-source-test.d.ts
declare module '@sage/xtrem-core/test/synchronization/synchronization-source-test' {
	export {};
	//# sourceMappingURL=synchronization-source-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/table-sql-context-test.d.ts
declare module '@sage/xtrem-core/test/sql/table-sql-context-test' {
	export {};
	//# sourceMappingURL=table-sql-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/sql-value-converter-test.d.ts
declare module '@sage/xtrem-core/test/sql/sql-value-converter-test' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestSimpleNode extends Node {
	    readonly jsonVal: Promise<boolean | null>;
	}
	//# sourceMappingURL=sql-value-converter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/sql-converter-test.d.ts
declare module '@sage/xtrem-core/test/sql/sql-converter-test' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestSimpleNode extends Node {
	    readonly booleanVal: Promise<boolean | null>;
	    readonly stringVal: Promise<string>;
	}
	//# sourceMappingURL=sql-converter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/sequence-sql-context-test.d.ts
declare module '@sage/xtrem-core/test/sql/sequence-sql-context-test' {
	export {};
	//# sourceMappingURL=sequence-sql-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/select-test.d.ts
declare module '@sage/xtrem-core/test/sql/select-test' {
	export {};
	//# sourceMappingURL=select-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/read-table-sql-context-test.d.ts
declare module '@sage/xtrem-core/test/sql/read-table-sql-context-test' {
	export {};
	//# sourceMappingURL=read-table-sql-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/pubsub-test.d.ts
declare module '@sage/xtrem-core/test/sql/pubsub-test' {
	export {};
	//# sourceMappingURL=pubsub-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/modify-table-sql-context-test.d.ts
declare module '@sage/xtrem-core/test/sql/modify-table-sql-context-test' {
	export {};
	//# sourceMappingURL=modify-table-sql-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/enum-sql-context-test.d.ts
declare module '@sage/xtrem-core/test/sql/enum-sql-context-test' {
	export const nodeEnums: {
	    enumTypeName: string;
	    enumValues: string;
	}[];
	//# sourceMappingURL=enum-sql-context-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/fixtures/setup.d.ts
declare module '@sage/xtrem-core/test/sql/fixtures/setup' {
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	export const newEnums: {
	    name: string;
	    values: {
	        value1: number;
	        value2: number;
	    };
	}[];
	export function cleanEnums(options?: {
	    names?: string[];
	    cascade?: boolean;
	}): Promise<void>;
	export function checkSchemaExists(sqlContext: SchemaSqlContext, schema: string): Promise<boolean>;
	export function checkTableExists(table: string): Promise<void>;
	export function dropTable(table: string): Promise<void>;
	//# sourceMappingURL=setup.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/sql/fixtures/index.d.ts
declare module '@sage/xtrem-core/test/sql/fixtures/index' {
	export * from '@sage/xtrem-core/test/sql/fixtures/setup';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/security/xss-test.d.ts
declare module '@sage/xtrem-core/test/security/xss-test' {
	export {};
	//# sourceMappingURL=xss-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/security/tls-test.d.ts
declare module '@sage/xtrem-core/test/security/tls-test' {
	export {};
	//# sourceMappingURL=tls-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/security/secret-placeholder-test.d.ts
declare module '@sage/xtrem-core/test/security/secret-placeholder-test' {
	export {};
	//# sourceMappingURL=secret-placeholder-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/security/fixtures/test-certificate-generator.d.ts
declare module '@sage/xtrem-core/test/security/fixtures/test-certificate-generator' {
	/// <reference types="node" />
	import { SecureContextOptions } from 'tls';
	type CertificateOptions = Pick<SecureContextOptions, 'cert' | 'ca' | 'key'>;
	export class TestCertificateGenerator {
	    readonly targetDir: string;
	    readonly caKeyFile: string;
	    readonly caCertFile: string;
	    readonly serverKeyFile: string;
	    readonly serverCertFile: string;
	    readonly errors: string[];
	    constructor(targetDir: string, passphrase: string);
	    static getOpenSslVersion(): Promise<string | null>;
	    get certificateOptions(): CertificateOptions;
	    createCaCert(): Promise<boolean>;
	    createServerCert(): Promise<boolean>;
	    cleanup(): Promise<void>;
	}
	export function generateCertificates(dir: string): Promise<TestCertificateGenerator>;
	export {};
	//# sourceMappingURL=test-certificate-generator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/vital-reference-test.d.ts
declare module '@sage/xtrem-core/test/runtime/vital-reference-test' {
	export {};
	//# sourceMappingURL=vital-reference-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/vital-default-value-test.d.ts
declare module '@sage/xtrem-core/test/runtime/vital-default-value-test' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Collection, Node, integer } from '@sage/xtrem-core/lib/index';
	export class TestVitalDefValueParent extends Node {
	    readonly code: Promise<string>;
	    readonly vitalRef: Reference<TestVitalDefValueReferenced>;
	    readonly vitalCollection: Collection<TestVitalDefValueChild>;
	}
	export class TestVitalDefValueReferenced extends Node {
	    readonly parent: Reference<TestVitalDefValueParent>;
	    readonly value: Promise<integer>;
	}
	export class TestVitalDefValueChild extends Node {
	    readonly parent: Reference<TestVitalDefValueParent>;
	    readonly value: Promise<integer>;
	}
	//# sourceMappingURL=vital-default-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/vital-collection-test.d.ts
declare module '@sage/xtrem-core/test/runtime/vital-collection-test' {
	export {};
	//# sourceMappingURL=vital-collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/vital-collection-sub-node-test.d.ts
declare module '@sage/xtrem-core/test/runtime/vital-collection-sub-node-test' {
	export {};
	//# sourceMappingURL=vital-collection-sub-node-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/validation-test.d.ts
declare module '@sage/xtrem-core/test/runtime/validation-test' {
	export {};
	//# sourceMappingURL=validation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/utilities-test.d.ts
declare module '@sage/xtrem-core/test/runtime/utilities-test' {
	export {};
	//# sourceMappingURL=utilities-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/upsert-test.d.ts
declare module '@sage/xtrem-core/test/runtime/upsert-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestInsertWithRetry extends Node {
	    readonly setupId: Promise<string>;
	    readonly description: Promise<string>;
	    readonly code1: Promise<string>;
	}
	//# sourceMappingURL=upsert-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/transient-test.d.ts
declare module '@sage/xtrem-core/test/runtime/transient-test' {
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	import { TestTransientLines } from '@sage/xtrem-core/test/fixtures/nodes/index';
	export class TestTransientBad1 extends Node {
	    readonly stringValue: Promise<string>;
	}
	export class TestTransientBad2 extends Node {
	    readonly stringValue: Promise<string>;
	}
	export class TestTransientBad4 extends Node {
	    readonly transientLines: Collection<TestTransientLines>;
	}
	//# sourceMappingURL=transient-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/transaction-test.d.ts
declare module '@sage/xtrem-core/test/runtime/transaction-test' {
	export {};
	//# sourceMappingURL=transaction-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/system-properties-user-fields-test.d.ts
declare module '@sage/xtrem-core/test/runtime/system-properties-user-fields-test' {
	export {};
	//# sourceMappingURL=system-properties-user-fields-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/system-properties-test.d.ts
declare module '@sage/xtrem-core/test/runtime/system-properties-test' {
	export {};
	//# sourceMappingURL=system-properties-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/subclassing-test.d.ts
declare module '@sage/xtrem-core/test/runtime/subclassing-test' {
	export {};
	//# sourceMappingURL=subclassing-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/stream-test.d.ts
declare module '@sage/xtrem-core/test/runtime/stream-test' {
	export {};
	//# sourceMappingURL=stream-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-null-filters-with-functions-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-null-filters-with-functions-test' {
	export {};
	//# sourceMappingURL=sql-null-filters-with-functions-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-null-filters-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-null-filters-test' {
	export {};
	//# sourceMappingURL=sql-null-filters-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-joins-with-functions-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-joins-with-functions-test' {
	export {};
	//# sourceMappingURL=sql-joins-with-functions-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-joins-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-joins-test' {
	export {};
	//# sourceMappingURL=sql-joins-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-function-filter-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-function-filter-test' {
	export {};
	//# sourceMappingURL=sql-function-filter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sql-converter-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sql-converter-test' {
	export {};
	//# sourceMappingURL=sql-converter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/sort-factories-test.d.ts
declare module '@sage/xtrem-core/test/runtime/sort-factories-test' {
	export {};
	//# sourceMappingURL=sort-factories-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/signal-test.d.ts
declare module '@sage/xtrem-core/test/runtime/signal-test' {
	export {};
	//# sourceMappingURL=signal-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/shared-table-test.d.ts
declare module '@sage/xtrem-core/test/runtime/shared-table-test' {
	export {};
	//# sourceMappingURL=shared-table-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/retry.d.ts
declare module '@sage/xtrem-core/test/runtime/retry' {
	export {};
	//# sourceMappingURL=retry.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/required-property-test.d.ts
declare module '@sage/xtrem-core/test/runtime/required-property-test' {
	export {};
	//# sourceMappingURL=required-property-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/reference-test.d.ts
declare module '@sage/xtrem-core/test/runtime/reference-test' {
	export {};
	//# sourceMappingURL=reference-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/reference-data-type-test.d.ts
declare module '@sage/xtrem-core/test/runtime/reference-data-type-test' {
	export {};
	//# sourceMappingURL=reference-data-type-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/reader-test.d.ts
declare module '@sage/xtrem-core/test/runtime/reader-test' {
	export {};
	//# sourceMappingURL=reader-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/property-dependencies-test.d.ts
declare module '@sage/xtrem-core/test/runtime/property-dependencies-test' {
	export {};
	//# sourceMappingURL=property-dependencies-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/prepare-test.d.ts
declare module '@sage/xtrem-core/test/runtime/prepare-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class BasicTest extends Node {
	    readonly s1: Promise<string>;
	    readonly s2: Promise<string>;
	    readonly s3: Promise<string>;
	    readonly s4: Promise<string>;
	}
	export class StopTest extends Node {
	    readonly s1: Promise<string>;
	    readonly s2: Promise<string>;
	}
	//# sourceMappingURL=prepare-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/persistency-test.d.ts
declare module '@sage/xtrem-core/test/runtime/persistency-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestSqlNode extends Node {
	    readonly field: Promise<string>;
	}
	export class TestJsonNode extends Node {
	    readonly field: Promise<string>;
	}
	//# sourceMappingURL=persistency-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/paging-with-nullable-test.d.ts
declare module '@sage/xtrem-core/test/runtime/paging-with-nullable-test' {
	export {};
	//# sourceMappingURL=paging-with-nullable-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/paging-test.d.ts
declare module '@sage/xtrem-core/test/runtime/paging-test' {
	export {};
	//# sourceMappingURL=paging-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/order-by-test.d.ts
declare module '@sage/xtrem-core/test/runtime/order-by-test' {
	export const documentLineData: ({
	    _id: number;
	    document: number;
	    lineNumber: number;
	    description: string;
	    optionalReference?: undefined;
	} | {
	    _id: number;
	    document: number;
	    lineNumber: number;
	    description: string;
	    optionalReference: number;
	})[];
	//# sourceMappingURL=order-by-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/old-state-test.d.ts
declare module '@sage/xtrem-core/test/runtime/old-state-test' {
	export {};
	//# sourceMappingURL=old-state-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/nullable-unique-index-test.d.ts
declare module '@sage/xtrem-core/test/runtime/nullable-unique-index-test' {
	export {};
	//# sourceMappingURL=nullable-unique-index-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/null-values-test.d.ts
declare module '@sage/xtrem-core/test/runtime/null-values-test' {
	/// <reference types="@sage/xtrem-decimal" />
	import { BinaryStream, date, dateRange, datetime, datetimeRange, decimal, integer, Node, short } from '@sage/xtrem-core/index';
	export enum TheEnumEnum {
	    val1 = 1,
	    val2 = 2,
	    val3 = 3,
	    val4 = 4,
	    val5 = 5
	}
	export type TheEnum = keyof typeof TheEnumEnum;
	export class TestNullValues extends Node {
	    readonly booleanVal: Promise<boolean | null>;
	    readonly shortVal: Promise<short | null>;
	    readonly integerVal: Promise<integer | null>;
	    readonly enumVal: Promise<TheEnum | null>;
	    readonly decimalVal: Promise<decimal | null>;
	    readonly floatVal: Promise<number | null>;
	    readonly doubleVal: Promise<number | null>;
	    readonly dateVal: Promise<date | null>;
	    readonly dateRangeVal: Promise<dateRange | null>;
	    readonly datetimeRangeVal: Promise<datetimeRange | null>;
	    readonly datetimeVal: Promise<datetime | null>;
	    readonly binaryStreamVal: Promise<BinaryStream | null>;
	}
	//# sourceMappingURL=null-values-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/null-default-values-test.d.ts
declare module '@sage/xtrem-core/test/runtime/null-default-values-test' {
	export {};
	//# sourceMappingURL=null-default-values-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/node-state-test.d.ts
declare module '@sage/xtrem-core/test/runtime/node-state-test' {
	export {};
	//# sourceMappingURL=node-state-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/node-get-test.d.ts
declare module '@sage/xtrem-core/test/runtime/node-get-test' {
	export {};
	//# sourceMappingURL=node-get-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/node-filter-test.d.ts
declare module '@sage/xtrem-core/test/runtime/node-filter-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestNodeFilter extends Node {
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=node-filter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/node-factory-cache-test.d.ts
declare module '@sage/xtrem-core/test/runtime/node-factory-cache-test' {
	export {};
	//# sourceMappingURL=node-factory-cache-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/no-default-values-test.d.ts
declare module '@sage/xtrem-core/test/runtime/no-default-values-test' {
	export {};
	//# sourceMappingURL=no-default-values-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/nested-diagnoses-test.d.ts
declare module '@sage/xtrem-core/test/runtime/nested-diagnoses-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestPrimaryNestedDiagnose extends Node {
	    readonly code: Promise<string>;
	}
	export class TestSecondaryNestedDiagnose extends Node {
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=nested-diagnoses-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/natural-key-test.d.ts
declare module '@sage/xtrem-core/test/runtime/natural-key-test' {
	export {};
	//# sourceMappingURL=natural-key-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/mutation-test.d.ts
declare module '@sage/xtrem-core/test/runtime/mutation-test' {
	export {};
	//# sourceMappingURL=mutation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/mutability-test.d.ts
declare module '@sage/xtrem-core/test/runtime/mutability-test' {
	export {};
	//# sourceMappingURL=mutability-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/mime-type-helper-test.d.ts
declare module '@sage/xtrem-core/test/runtime/mime-type-helper-test' {
	export {};
	//# sourceMappingURL=mime-type-helper-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/lookup-access-decorator-test.d.ts
declare module '@sage/xtrem-core/test/runtime/lookup-access-decorator-test' {
	export {};
	//# sourceMappingURL=lookup-access-decorator-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/localized-data-test.d.ts
declare module '@sage/xtrem-core/test/runtime/localized-data-test' {
	/// <reference types="@sage/xtrem-decimal" />
	import { date, decimal, Node } from '@sage/xtrem-core/index';
	export class TestLocalizedData extends Node {
	    readonly id: Promise<string>;
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class TestLocalizedDataInvalid extends Node {
	    readonly id: Promise<string>;
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class TestDummyNode extends Node {
	    readonly id: Promise<string>;
	    readonly code: Promise<string>;
	}
	export class TestLocalizedData2 extends Node {
	    readonly id: Promise<string>;
	    readonly code: Promise<string>;
	    readonly strProp?: Promise<string>;
	    readonly dateProp?: Promise<date>;
	    readonly decimalProp: Promise<decimal>;
	    readonly text: Promise<string>;
	    readonly text2: Promise<string>;
	}
	export class TestIsNotEmpty extends Node {
	    readonly id: Promise<string>;
	    readonly code: Promise<string>;
	    readonly notEmptyLocalizedText: Promise<string>;
	}
	//# sourceMappingURL=localized-data-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/lazy-loading-test.d.ts
declare module '@sage/xtrem-core/test/runtime/lazy-loading-test' {
	export {};
	//# sourceMappingURL=lazy-loading-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/json-node-test.d.ts
declare module '@sage/xtrem-core/test/runtime/json-node-test' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { integer } from '@sage/xtrem-core/lib/index';
	import { TestExtensionReference } from '@sage/xtrem-core/test/fixtures/nodes/index';
	export class TestPerson extends Node {
	    readonly name: Promise<string>;
	    readonly address: Reference<TestJsonAddress | null>;
	}
	export class TestJsonAddress extends Node {
	    readonly streetAddress: Promise<string>;
	    readonly postalCode: Promise<integer>;
	    readonly city: Promise<string>;
	}
	export class TestPersonMissingVital extends Node {
	    readonly address: Reference<TestJsonAddress | null>;
	}
	export class TestPersonIllegalReference extends Node {
	    readonly address: Reference<TestJsonAddressIllegalReference | null>;
	}
	export class TestJsonAddressIllegalReference extends Node {
	    readonly illegalReference: Reference<TestExtensionReference>;
	}
	//# sourceMappingURL=json-node-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/isolation-anomaly-2-test.d.ts
declare module '@sage/xtrem-core/test/runtime/isolation-anomaly-2-test' {
	import { integer } from '@sage/xtrem-shared';
	import { IsolationOptions } from '@sage/xtrem-core/lib/index';
	const tsTasks: {
	    addReceipt(options: IsolationOptions): Promise<boolean>;
	    closeBatch(options: IsolationOptions): Promise<number>;
	    report(options: IsolationOptions): Promise<{
	        batchNumber: integer;
	        batchAmount: integer;
	    }>;
	    getCurrentBatchNumber(): Promise<number>;
	    getBatchTotalAmount(batchNumber: integer): Promise<number>;
	};
	export type Tasks = typeof tsTasks;
	export {};
	//# sourceMappingURL=isolation-anomaly-2-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/isolation-anomaly-1-test.d.ts
declare module '@sage/xtrem-core/test/runtime/isolation-anomaly-1-test' {
	export {};
	//# sourceMappingURL=isolation-anomaly-1-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/is-stored-output-test.d.ts
declare module '@sage/xtrem-core/test/runtime/is-stored-output-test' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestIsStoredOutputBad extends Node {
	    readonly outputOnlyString: Promise<string>;
	}
	export class TestIsStoredOutputNode extends Node {
	    readonly code: Promise<string>;
	    readonly isStoredOutputTrue: Promise<string>;
	}
	//# sourceMappingURL=is-stored-output-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/is-active-test.d.ts
declare module '@sage/xtrem-core/test/runtime/is-active-test' {
	export {};
	//# sourceMappingURL=is-active-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/introspection-test.d.ts
declare module '@sage/xtrem-core/test/runtime/introspection-test' {
	export {};
	//# sourceMappingURL=introspection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/inherited-reverse-property-test.d.ts
declare module '@sage/xtrem-core/test/runtime/inherited-reverse-property-test' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	export class TestIrpBusinessEntity extends Node {
	    readonly id: Promise<string>;
	    readonly customer: Reference<TestIrpCustomer | null>;
	    readonly isCustomer: Promise<boolean>;
	    readonly supplier: Reference<TestIrpSupplier | null>;
	}
	export class TestIrpBusinessRelation extends Node {
	    readonly businessEntity: Promise<TestIrpBusinessEntity>;
	}
	export class TestIrpCustomer extends TestIrpBusinessRelation {
	    readonly customerName: Promise<string>;
	}
	export class TestIrpSupplier extends TestIrpBusinessRelation {
	    readonly supplierName: Promise<string>;
	}
	//# sourceMappingURL=inherited-reverse-property-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/global-lock-test.d.ts
declare module '@sage/xtrem-core/test/runtime/global-lock-test' {
	export {};
	//# sourceMappingURL=global-lock-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/global-cache-test.d.ts
declare module '@sage/xtrem-core/test/runtime/global-cache-test' {
	export {};
	//# sourceMappingURL=global-cache-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/get-reference-from-state-cache-test.d.ts
declare module '@sage/xtrem-core/test/runtime/get-reference-from-state-cache-test' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestStateCacheParentNode extends Node {
	    readonly code: Promise<string>;
	    readonly reference: Reference<TestStateCacheVitalCollectionChild | null>;
	    readonly refArr: Promise<TestStateCacheVitalCollectionChild[]>;
	    readonly collection: Collection<TestStateCacheVitalCollectionChild>;
	}
	export class TestStateCacheVitalCollectionChild extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestStateCacheParentNode>;
	}
	//# sourceMappingURL=get-reference-from-state-cache-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/get-payload-test.d.ts
declare module '@sage/xtrem-core/test/runtime/get-payload-test' {
	export {};
	//# sourceMappingURL=get-payload-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/frozen-test.d.ts
declare module '@sage/xtrem-core/test/runtime/frozen-test' {
	export {};
	//# sourceMappingURL=frozen-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/foreign-keys-test.d.ts
declare module '@sage/xtrem-core/test/runtime/foreign-keys-test' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	export class TestForeign1 extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	export class TestForeignReffering1 extends Node {
	    readonly code: Promise<string>;
	    readonly reference: Reference<TestForeign1 | null>;
	}
	export class TestForeignReffering2 extends Node {
	    readonly code: Promise<string>;
	    readonly reference: Reference<TestForeignReffering1 | null>;
	}
	export class TestForeignReffering3 extends Node {
	    readonly code: Promise<string>;
	    readonly reference1: Reference<TestForeignReffering1 | null>;
	    readonly reference2: Reference<TestForeignReffering2 | null>;
	    readonly reference3: Reference<TestForeign1 | null>;
	}
	export class TestForeignNullable1 extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestForeignNullable1>;
	}
	export class TestForeignNullable2 extends Node {
	    readonly code: Promise<string>;
	    readonly reference2: Reference<TestForeignNullable3>;
	}
	export class TestForeignNullable3 extends Node {
	    readonly code: Promise<string>;
	    readonly reference3: Reference<TestForeignNullable4>;
	}
	export class TestForeignNullable4 extends Node {
	    readonly code: Promise<string>;
	    readonly reference4: Reference<TestForeignNullable2>;
	}
	export class TestCyclic1 extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestCyclic2>;
	}
	export class TestCyclic2 extends Node {
	    readonly code: Promise<string>;
	    readonly reference2: Reference<TestCyclic3>;
	}
	export class TestCyclic3 extends Node {
	    readonly code: Promise<string>;
	    readonly reference3: Reference<TestCyclic1>;
	}
	//# sourceMappingURL=foreign-keys-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/filter-nested-collection-test.d.ts
declare module '@sage/xtrem-core/test/runtime/filter-nested-collection-test' {
	export {};
	//# sourceMappingURL=filter-nested-collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/external-storage-test.d.ts
declare module '@sage/xtrem-core/test/runtime/external-storage-test' {
	import { DateValue } from '@sage/xtrem-date-time';
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { Collection } from '@sage/xtrem-core/lib/index';
	import { integer } from '@sage/xtrem-core/lib/ts-api/index';
	export class TestExternalLineNode extends Node {
	    readonly code: Promise<string>;
	    readonly num: Promise<integer>;
	    readonly description: Promise<string>;
	    readonly header: Reference<TestExternalHeaderNode>;
	}
	export class TestExternalHeaderNode extends Node {
	    readonly headerCode: Promise<string>;
	    readonly deferred: Promise<integer>;
	    readonly description: Promise<string>;
	    readonly date: Promise<DateValue>;
	    readonly lines: Collection<TestExternalLineNode>;
	    readonly mutableLines: Collection<TestExternalLineNode>;
	}
	export class TestExternalUser extends Node {
	    readonly code: Promise<string>;
	    readonly name: Promise<string>;
	}
	//# sourceMappingURL=external-storage-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/external-factory-test.d.ts
declare module '@sage/xtrem-core/test/runtime/external-factory-test' {
	export {};
	//# sourceMappingURL=external-factory-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/extension-test.d.ts
declare module '@sage/xtrem-core/test/runtime/extension-test' {
	export {};
	//# sourceMappingURL=extension-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/events-test.d.ts
declare module '@sage/xtrem-core/test/runtime/events-test' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	import { NodeExtension } from '@sage/xtrem-core/lib/index';
	class TestEventGrandParent extends Node {
	    readonly name: Promise<string>;
	    readonly parents: Collection<TestEventParent>;
	}
	class TestEventParent extends Node {
	    readonly name: Promise<string>;
	    readonly value: Promise<string>;
	    readonly children: Collection<TestEventChild>;
	    readonly ref: Reference<TestEventReference>;
	    readonly grandParent: Reference<TestEventGrandParent>;
	}
	class TestEventChild extends Node {
	    readonly name: Promise<string>;
	    readonly value: Promise<string>;
	    readonly parent: Reference<TestEventParent>;
	}
	class TestEventReference extends Node {
	    readonly name: Promise<string>;
	    readonly value: Promise<string>;
	}
	export class TestEventExtendedChild extends NodeExtension<TestEventChild> {
	}
	interface TestEventChild extends TestEventExtendedChild {
	}
	export class TestEventExtendedParent extends NodeExtension<TestEventParent> {
	}
	interface TestEventParent extends TestEventExtendedParent {
	}
	export {};
	//# sourceMappingURL=events-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/duplicated-value-test.d.ts
declare module '@sage/xtrem-core/test/runtime/duplicated-value-test' {
	export {};
	//# sourceMappingURL=duplicated-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/delete-on-cascade-test.d.ts
declare module '@sage/xtrem-core/test/runtime/delete-on-cascade-test' {
	export {};
	//# sourceMappingURL=delete-on-cascade-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/delegates-to-test.d.ts
declare module '@sage/xtrem-core/test/runtime/delegates-to-test' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	class TestDelegatedTo extends Node {
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	}
	export class TestDelegatesTo extends Node {
	    readonly code: Promise<string>;
	    readonly delegate: Reference<TestDelegatedTo>;
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	}
	export {};
	//# sourceMappingURL=delegates-to-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/delegates-to-metadata-test.d.ts
declare module '@sage/xtrem-core/test/runtime/delegates-to-metadata-test' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	class TestMetaDataDelegatedTo extends Node {
	    readonly text: Promise<string>;
	    readonly localizedText: Promise<string>;
	    readonly inputOnlyProperty: Promise<string>;
	    readonly outputOnlyString: Promise<string>;
	    readonly bool: Promise<boolean>;
	    readonly requiredNumber: Promise<number>;
	    readonly number: Promise<number>;
	}
	export class TestMetadataDelegatesTo extends Node {
	    readonly code: Promise<string>;
	    readonly delegate: Reference<TestMetaDataDelegatedTo>;
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	    readonly localizedText: Promise<string>;
	    readonly inputOnlyProperty: Promise<string>;
	    readonly outputOnlyString: Promise<string>;
	    readonly requiredNumber: Promise<number>;
	    readonly number: Promise<number>;
	}
	export {};
	//# sourceMappingURL=delegates-to-metadata-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/deferred-save-test.d.ts
declare module '@sage/xtrem-core/test/runtime/deferred-save-test' {
	import { Node, integer } from '@sage/xtrem-core/index';
	export class TestDeferredSave1 extends Node {
	    readonly id: Promise<integer>;
	    readonly val: Promise<integer>;
	}
	export class TestDeferredSave2 extends Node {
	    readonly id: Promise<integer>;
	    readonly forInfiniteLoop: Promise<boolean>;
	    readonly val: Promise<integer>;
	}
	//# sourceMappingURL=deferred-save-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/deferred-default-value-test.d.ts
declare module '@sage/xtrem-core/test/runtime/deferred-default-value-test' {
	import { integer, Node } from '@sage/xtrem-core/index';
	export class TestDeferredDefaultValue extends Node {
	    readonly deferredValue: Promise<integer>;
	}
	//# sourceMappingURL=deferred-default-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/default-value-test.d.ts
declare module '@sage/xtrem-core/test/runtime/default-value-test' {
	export {};
	//# sourceMappingURL=default-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/datatypes-test.d.ts
declare module '@sage/xtrem-core/test/runtime/datatypes-test' {
	export {};
	//# sourceMappingURL=datatypes-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/data-type-events-test.d.ts
declare module '@sage/xtrem-core/test/runtime/data-type-events-test' {
	export {};
	//# sourceMappingURL=data-type-events-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/control-delete-test.d.ts
declare module '@sage/xtrem-core/test/runtime/control-delete-test' {
	export {};
	//# sourceMappingURL=control-delete-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-vault-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-vault-test' {
	export {};
	//# sourceMappingURL=context-vault-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-user-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-user-test' {
	export {};
	//# sourceMappingURL=context-user-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-user-ip-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-user-ip-test' {
	export {};
	//# sourceMappingURL=context-user-ip-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-tenant-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-tenant-test' {
	export {};
	//# sourceMappingURL=context-tenant-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-lookup-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-lookup-test' {
	export {};
	//# sourceMappingURL=context-lookup-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/context-configuration-test.d.ts
declare module '@sage/xtrem-core/test/runtime/context-configuration-test' {
	export {};
	//# sourceMappingURL=context-configuration-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/content-addressable-test.d.ts
declare module '@sage/xtrem-core/test/runtime/content-addressable-test' {
	export {};
	//# sourceMappingURL=content-addressable-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/collection-volatile-test.d.ts
declare module '@sage/xtrem-core/test/runtime/collection-volatile-test' {
	import { Collection, integer, Node } from '@sage/xtrem-core/index';
	export class TestVolatile extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly lines: Collection<TestVolatileLine>;
	}
	export class TestVolatileLine extends Node {
	    readonly description: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	}
	//# sourceMappingURL=collection-volatile-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/collection-test.d.ts
declare module '@sage/xtrem-core/test/runtime/collection-test' {
	import { Collection, integer, Node, Reference } from '@sage/xtrem-core/index';
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/index';
	export class TestDocumentRequiredCollection extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly mandatoryReference: Reference<TestReferred>;
	    readonly lines: Collection<TestDocumentLineRequiredCollection>;
	}
	export class TestDocumentLineRequiredCollection extends Node {
	    readonly description: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly optionalReference: Reference<TestReferred | null>;
	    readonly document: Reference<TestDocumentRequiredCollection>;
	}
	export class TestDocumentRequiredCollectionNonVital extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly mandatoryReference: Reference<TestReferred>;
	    readonly lines: Collection<TestDocumentLineRequiredCollection>;
	}
	//# sourceMappingURL=collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/collection-reload-test.d.ts
declare module '@sage/xtrem-core/test/runtime/collection-reload-test' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Collection, integer, Node } from '@sage/xtrem-core/lib/index';
	export class TestDocumentWithNonVitalCollection extends Node {
	    readonly code: Promise<string>;
	    readonly items: Collection<TestNonVitalCollectionItem>;
	}
	export class TestNonVitalCollectionItem extends Node {
	    readonly number: Promise<integer>;
	    readonly document: Reference<TestDocumentWithNonVitalCollection>;
	}
	//# sourceMappingURL=collection-reload-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/cleared-by-reset-test.d.ts
declare module '@sage/xtrem-core/test/runtime/cleared-by-reset-test' {
	import { Collection, integer, Node, Reference } from '@sage/xtrem-core/index';
	export class TestVitalChildWithIsClearedByReset extends Node {
	    readonly document: Reference<TestVitalChildWithIsClearedByResetCollection>;
	}
	export class TestVitalChildWithIsClearedByResetCollection extends Node {
	    readonly lines: Collection<TestVitalChildWithIsClearedByReset>;
	}
	export class TestNodeWithIsClearedByResetInReferenceNode extends Node {
	    readonly isClearedByResetReference: Reference<TestNodeWithIsClearedByResetInReferenceNodeTarget | null>;
	}
	export class TestNodeWithIsClearedByResetInReferenceNodeTarget extends Node {
	    readonly code: Promise<string>;
	}
	export class TestNodeWithIsClearedByResetInDecoratorAndProperty extends Node {
	    readonly code: Promise<string>;
	}
	export class TestSubNodeInParent extends Node {
	    readonly code: Promise<string>;
	}
	export class TestSubNode extends TestSubNodeInParent {
	    readonly description: Promise<string>;
	}
	export class TestSetupNode extends Node {
	    readonly description: Promise<string>;
	}
	export class TestNonStoredProperty extends Node {
	    readonly description: Promise<string>;
	}
	export class TestOnUniqueIndex extends Node {
	    readonly description: Promise<string>;
	}
	export class TestOnDefaultValueFunction extends Node {
	    readonly description: Promise<string>;
	}
	export class TestIsClearedByResetNodeA extends Node {
	    readonly code: Promise<integer>;
	}
	export class TestIsClearedByResetNodeB extends Node {
	    readonly codeRefA: Reference<TestIsClearedByResetNodeA>;
	}
	export class TestIsClearedByResetSharedNode extends Node {
	    readonly code: Promise<integer>;
	}
	//# sourceMappingURL=cleared-by-reset-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/association-test.d.ts
declare module '@sage/xtrem-core/test/runtime/association-test' {
	export {};
	//# sourceMappingURL=association-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/association-invalid-test.d.ts
declare module '@sage/xtrem-core/test/runtime/association-invalid-test' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestAssociationNoReverseRef extends Node {
	    readonly name: Promise<string>;
	    readonly refs: Collection<TestAssociationInvalid>;
	}
	export class TestAssociationInvalid extends Node {
	    readonly noReverseRef: Reference<TestAssociationNoReverseRef>;
	}
	export class TestAssociationRefInvalidNoChild extends Node {
	    readonly name: Promise<string>;
	    readonly refs: Collection<TestAssociationInvalidNoChild>;
	}
	export class TestAssociationInvalidNoChild extends Node {
	    readonly ref: Reference<TestAssociationRefInvalidNoChild>;
	}
	export class TestAssociationRef extends Node {
	    readonly name: Promise<string>;
	    readonly refs: Collection<TestAssociation>;
	}
	export class TestAssociationRef2 extends Node {
	    readonly name: Promise<string>;
	    readonly refs: Collection<TestAssociation>;
	}
	export class TestAssociationRef3 extends Node {
	    readonly name: Promise<string>;
	    readonly refs: Collection<TestAssociationInvalid3>;
	}
	export class TestAssociation extends Node {
	    readonly ref: Reference<TestAssociationRef>;
	    readonly ref2: Reference<TestAssociationRef2>;
	}
	export class TestAssociationInvalid2 extends Node {
	    readonly ref: Reference<TestAssociationRef>;
	    readonly ref2: Reference<TestAssociationRef2>;
	}
	export class TestAssociationInvalid3 extends Node {
	    readonly ref: Reference<TestAssociationRef>;
	    readonly ref3: Reference<TestAssociationRef3>;
	}
	//# sourceMappingURL=association-invalid-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/anonymize-method-decorator-test.d.ts
declare module '@sage/xtrem-core/test/runtime/anonymize-method-decorator-test' {
	export {};
	//# sourceMappingURL=anonymize-method-decorator-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/aggregation-test.d.ts
declare module '@sage/xtrem-core/test/runtime/aggregation-test' {
	export {};
	//# sourceMappingURL=aggregation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/adapt-values-test.d.ts
declare module '@sage/xtrem-core/test/runtime/adapt-values-test' {
	export {};
	//# sourceMappingURL=adapt-values-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/activity-test.d.ts
declare module '@sage/xtrem-core/test/runtime/activity-test' {
	export {};
	//# sourceMappingURL=activity-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/active-default-value-test.d.ts
declare module '@sage/xtrem-core/test/runtime/active-default-value-test' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node, integer } from '@sage/xtrem-core/lib/index';
	export class TestParent extends Node {
	    readonly code: Promise<string>;
	    readonly ref: Reference<TestReferenced>;
	    readonly vitalRef: Reference<TestReferencedVital>;
	}
	export class TestReferenced extends Node {
	    readonly value: Promise<integer>;
	    readonly isActive: Promise<boolean>;
	}
	export class TestReferencedVital extends Node {
	    readonly parent: Reference<TestParent>;
	    readonly value: Promise<integer>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=active-default-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/runtime/abstract-vital-parent-test.d.ts
declare module '@sage/xtrem-core/test/runtime/abstract-vital-parent-test' {
	export {};
	//# sourceMappingURL=abstract-vital-parent-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/interop/notification-topic-test.d.ts
declare module '@sage/xtrem-core/test/interop/notification-topic-test' {
	export {};
	//# sourceMappingURL=notification-topic-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/web-transaction-name-test.d.ts
declare module '@sage/xtrem-core/test/graphql/web-transaction-name-test' {
	export {};
	//# sourceMappingURL=web-transaction-name-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/vital-reference-test.d.ts
declare module '@sage/xtrem-core/test/graphql/vital-reference-test' {
	export interface QueryResult {
	    _id: string;
	    code: string;
	    mandatoryVitalRef: {
	        code: string;
	        text: string;
	    };
	    optionalVitalRef: {
	        code: string;
	        text: string;
	        nonVitalRef: {
	            code: string;
	            text: string;
	        };
	    } | null;
	}
	//# sourceMappingURL=vital-reference-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/vital-collection-test.d.ts
declare module '@sage/xtrem-core/test/graphql/vital-collection-test' {
	export interface QueryResult {
	    _id: string;
	    children: {
	        _sortValue: number;
	        code: string;
	        _id: string;
	    }[];
	}
	//# sourceMappingURL=vital-collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/validation-test.d.ts
declare module '@sage/xtrem-core/test/graphql/validation-test' {
	export {};
	//# sourceMappingURL=validation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/transient-test.d.ts
declare module '@sage/xtrem-core/test/graphql/transient-test' {
	export {};
	//# sourceMappingURL=transient-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/system-properties-test.d.ts
declare module '@sage/xtrem-core/test/graphql/system-properties-test' {
	export {};
	//# sourceMappingURL=system-properties-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/subclassing-test.d.ts
declare module '@sage/xtrem-core/test/graphql/subclassing-test' {
	export {};
	//# sourceMappingURL=subclassing-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/subclassing-override-test.d.ts
declare module '@sage/xtrem-core/test/graphql/subclassing-override-test' {
	export {};
	//# sourceMappingURL=subclassing-override-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/subclassing-json-override-test.d.ts
declare module '@sage/xtrem-core/test/graphql/subclassing-json-override-test' {
	export {};
	//# sourceMappingURL=subclassing-json-override-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/sensitivity-log-test.d.ts
declare module '@sage/xtrem-core/test/graphql/sensitivity-log-test' {
	export {};
	//# sourceMappingURL=sensitivity-log-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/schema-queries-test.d.ts
declare module '@sage/xtrem-core/test/graphql/schema-queries-test' {
	export {};
	//# sourceMappingURL=schema-queries-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/reference-test.d.ts
declare module '@sage/xtrem-core/test/graphql/reference-test' {
	export {};
	//# sourceMappingURL=reference-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/readonly-config-test.d.ts
declare module '@sage/xtrem-core/test/graphql/readonly-config-test' {
	export {};
	//# sourceMappingURL=readonly-config-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/read-test.d.ts
declare module '@sage/xtrem-core/test/graphql/read-test' {
	export {};
	//# sourceMappingURL=read-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/query-sorting-test.d.ts
declare module '@sage/xtrem-core/test/graphql/query-sorting-test' {
	export {};
	//# sourceMappingURL=query-sorting-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/query-paging-test.d.ts
declare module '@sage/xtrem-core/test/graphql/query-paging-test' {
	export {};
	//# sourceMappingURL=query-paging-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/query-filter-test.d.ts
declare module '@sage/xtrem-core/test/graphql/query-filter-test' {
	export {};
	//# sourceMappingURL=query-filter-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/published-properties-test.d.ts
declare module '@sage/xtrem-core/test/graphql/published-properties-test' {
	export {};
	//# sourceMappingURL=published-properties-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/pages-metadata-test.d.ts
declare module '@sage/xtrem-core/test/graphql/pages-metadata-test' {
	export {};
	//# sourceMappingURL=pages-metadata-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/order-by-test.d.ts
declare module '@sage/xtrem-core/test/graphql/order-by-test' {
	export {};
	//# sourceMappingURL=order-by-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/operation-test.d.ts
declare module '@sage/xtrem-core/test/graphql/operation-test' {
	export {};
	//# sourceMappingURL=operation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/null-decimal-mutation-test.d.ts
declare module '@sage/xtrem-core/test/graphql/null-decimal-mutation-test' {
	export {};
	//# sourceMappingURL=null-decimal-mutation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/node-details-test.d.ts
declare module '@sage/xtrem-core/test/graphql/node-details-test' {
	export {};
	//# sourceMappingURL=node-details-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/node-data-type-metadata-test.d.ts
declare module '@sage/xtrem-core/test/graphql/node-data-type-metadata-test' {
	export {};
	//# sourceMappingURL=node-data-type-metadata-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/nested-collection-test.d.ts
declare module '@sage/xtrem-core/test/graphql/nested-collection-test' {
	export {};
	//# sourceMappingURL=nested-collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/mutation-optional-parameters-test.d.ts
declare module '@sage/xtrem-core/test/graphql/mutation-optional-parameters-test' {
	export {};
	//# sourceMappingURL=mutation-optional-parameters-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/mutation-on-nullable-property-test.d.ts
declare module '@sage/xtrem-core/test/graphql/mutation-on-nullable-property-test' {
	export {};
	//# sourceMappingURL=mutation-on-nullable-property-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/mutation-long-delay-test.d.ts
declare module '@sage/xtrem-core/test/graphql/mutation-long-delay-test' {
	export {};
	//# sourceMappingURL=mutation-long-delay-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/multi-level-vital-crud-test.d.ts
declare module '@sage/xtrem-core/test/graphql/multi-level-vital-crud-test' {
	export {};
	//# sourceMappingURL=multi-level-vital-crud-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/json-selector-test.d.ts
declare module '@sage/xtrem-core/test/graphql/json-selector-test' {
	export {};
	//# sourceMappingURL=json-selector-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/graphql-lookups-test.d.ts
declare module '@sage/xtrem-core/test/graphql/graphql-lookups-test' {
	export {};
	//# sourceMappingURL=graphql-lookups-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/global-cache-test.d.ts
declare module '@sage/xtrem-core/test/graphql/global-cache-test' {
	export {};
	//# sourceMappingURL=global-cache-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/get-duplicate-test.d.ts
declare module '@sage/xtrem-core/test/graphql/get-duplicate-test' {
	export {};
	//# sourceMappingURL=get-duplicate-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/get-default-values-test.d.ts
declare module '@sage/xtrem-core/test/graphql/get-default-values-test' {
	export {};
	//# sourceMappingURL=get-default-values-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/filter-nested-collection-test.d.ts
declare module '@sage/xtrem-core/test/graphql/filter-nested-collection-test' {
	export {};
	//# sourceMappingURL=filter-nested-collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/extension-test.d.ts
declare module '@sage/xtrem-core/test/graphql/extension-test' {
	export {};
	//# sourceMappingURL=extension-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/errors-test.d.ts
declare module '@sage/xtrem-core/test/graphql/errors-test' {
	export {};
	//# sourceMappingURL=errors-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/duplicate-mutation-test.d.ts
declare module '@sage/xtrem-core/test/graphql/duplicate-mutation-test' {
	export {};
	//# sourceMappingURL=duplicate-mutation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/defer-stream-test.d.ts
declare module '@sage/xtrem-core/test/graphql/defer-stream-test' {
	export {};
	//# sourceMappingURL=defer-stream-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/datatypes-test.d.ts
declare module '@sage/xtrem-core/test/graphql/datatypes-test' {
	export {};
	//# sourceMappingURL=datatypes-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/cross-references-test.d.ts
declare module '@sage/xtrem-core/test/graphql/cross-references-test' {
	import { ClientCollection, ClientNode, ClientNodeInput, CreateOperation, QueryOperation, UpdateOperation } from '@sage/xtrem-client';
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestAddress extends Node {
	    readonly customer: Reference<TestCustomer>;
	    readonly street: Promise<string>;
	    readonly city: Promise<string>;
	}
	export class TestCustomer extends Node {
	    readonly addresses: Collection<TestAddress>;
	    readonly name: Promise<string>;
	    readonly billingAddress: Reference<TestAddress | null>;
	}
	interface ClientTestAddress extends ClientNode {
	    customer: ClientTestCustomer;
	    street: string;
	    city: string;
	}
	interface ClientTestAddressInput extends ClientNodeInput {
	    customer?: string;
	    street?: string;
	    city?: string;
	}
	interface ClientTestCustomer extends ClientNode {
	    addresses: ClientCollection<ClientTestAddress>;
	    name: string;
	    billingAddress: ClientTestAddress | null;
	}
	interface ClientTestCustomerInput extends ClientNodeInput {
	    addresses?: ClientTestAddressInput[];
	    name?: string;
	    billingAddress?: string | null;
	}
	export interface TestCustomer$Operations {
	    query: QueryOperation<ClientTestCustomer>;
	    create: CreateOperation<ClientTestCustomerInput, ClientTestCustomer>;
	    update: UpdateOperation<ClientTestCustomerInput, ClientTestCustomer>;
	}
	export {};
	//# sourceMappingURL=cross-references-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/context-vault-test.d.ts
declare module '@sage/xtrem-core/test/graphql/context-vault-test' {
	export {};
	//# sourceMappingURL=context-vault-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/collection-test.d.ts
declare module '@sage/xtrem-core/test/graphql/collection-test' {
	export {};
	//# sourceMappingURL=collection-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/collection-aggregation-test.d.ts
declare module '@sage/xtrem-core/test/graphql/collection-aggregation-test' {
	export {};
	//# sourceMappingURL=collection-aggregation-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/aggregations-test.d.ts
declare module '@sage/xtrem-core/test/graphql/aggregations-test' {
	export {};
	//# sourceMappingURL=aggregations-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/aggregations-groupby-test.d.ts
declare module '@sage/xtrem-core/test/graphql/aggregations-groupby-test' {
	export {};
	//# sourceMappingURL=aggregations-groupby-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/aggregations-client-test.d.ts
declare module '@sage/xtrem-core/test/graphql/aggregations-client-test' {
	import { date } from '@sage/xtrem-core/lib/index';
	export const documentData: {
	    _id: number;
	    code: string;
	    linesCount: number;
	    totalAmount1: number;
	    totalAmount2: number;
	    totalAmount3: number;
	    totalAmount4: number;
	    totalAmount5: number;
	}[];
	export const documentLineData: {
	    document: number;
	    lineNumber: number;
	    quantity: number;
	    amount1: number;
	    amount2: number;
	    amount3: number;
	    amount4: number;
	    amount5: number;
	    date: date;
	}[];
	//# sourceMappingURL=aggregations-client-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/aggregations-access-test.d.ts
declare module '@sage/xtrem-core/test/graphql/aggregations-access-test' {
	export {};
	//# sourceMappingURL=aggregations-access-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/access-rights-filters-test.d.ts
declare module '@sage/xtrem-core/test/graphql/access-rights-filters-test' {
	export {};
	//# sourceMappingURL=access-rights-filters-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/access-property-test.d.ts
declare module '@sage/xtrem-core/test/graphql/access-property-test' {
	export {};
	//# sourceMappingURL=access-property-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/graphql/accept-null-value-test.d.ts
declare module '@sage/xtrem-core/test/graphql/accept-null-value-test' {
	export {};
	//# sourceMappingURL=accept-null-value-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/util.d.ts
declare module '@sage/xtrem-core/test/fixtures/util' {
	import { Dict } from '@sage/xtrem-shared';
	import { QueryAggregateEdge, QueryAggregateNode, QueryNode, QueryPage } from '@sage/xtrem-core/lib/graphql/paging/paging';
	import { Application, datetime, Node, NodeCreateData } from '@sage/xtrem-core/lib/index';
	export { QueryNode, QueryAggregateNode, QueryAggregateEdge };
	export type TestInitData<T extends Node> = NodeCreateData<T>;
	export function readSampleFile(type: string, length?: number): string;
	export function sortByKey(unordered: any): any;
	export function dropTestSchema(application: Application): Promise<void>;
	export function restoreApplication(api: any, schemaName?: string): Promise<void>;
	export function fixDatetimes(...args: (datetime | null | undefined)[]): void;
	export function stripSysColumns(obj: Dict<any>): Dict<any>;
	export function graphqlPageNodes<T>(page: QueryPage<T>): T[];
	//# sourceMappingURL=util.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/setup.d.ts
declare module '@sage/xtrem-core/test/fixtures/setup' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Graph } from '@sage/xtrem-client';
	import { ConfigManager } from '@sage/xtrem-config';
	import { Config } from '@sage/xtrem-shared';
	import { AsyncExecutionResult, ExecutionResult, GraphQLSchema } from 'graphql';
	import { Application, Context, IsolationOptions, PackageApi } from '@sage/xtrem-core/lib/index';
	import { GraphApi } from '@sage/xtrem-core/test/fixtures/client-nodes/index';
	export function stubResetTablesWithoutContext(): void;
	export function restoreResetTablesWithoutContext(): void;
	export function createApplicationWithApi(api: PackageApi, schemaName?: string): Promise<Application>;
	interface SetupOptions {
	    stubResetTables?: boolean;
	    application: Application;
	    activatesPackages?: string[];
	}
	export function updateContext(): void;
	export function setup(setupOptions: SetupOptions): Promise<void>;
	export interface GraphQlSetupOptions {
	    userEmail?: string;
	    rootQueryType?: string;
	    isolationOptions?: IsolationOptions;
	    context?: Context;
	    withDiagnoses?: boolean;
	    dontThrow?: boolean;
	    timeLimitAsTimestamp?: number;
	}
	export interface GraphQlResponse<T> {
	    data: {
	        [key: string]: T;
	    };
	}
	export class GraphQlHelper {
	    private schema;
	    constructor(schema: GraphQLSchema);
	    execute<T extends AnyValue>(q: string, options?: GraphQlSetupOptions): Promise<ExecutionResult<T>>;
	    /**
	     * Executes a request containing `@stream` and/or `@defer` directives.
	     * This method waits for all the chunks and returns a single result.
	     * It is only meant for testing. A real client should process the chunks as they arrive,
	     * to get the real benefits of these directives.
	     */
	    executeChunked(q: string, options?: GraphQlSetupOptions): Promise<AsyncExecutionResult[]>;
	    /**
	     * Merges chunks returned by a graphql request containing `@stream` and/or `@defer` directives.
	     */
	    static mergeChunks<T extends AnyValue>(chunks: AsyncExecutionResult[]): T;
	    private static unwrap;
	    query<T extends AnyValue>(q: string, options?: GraphQlSetupOptions): Promise<T>;
	    mutation<T extends AnyValue>(q: string, options?: GraphQlSetupOptions): Promise<T>;
	}
	interface GraphqlSetupOptions extends SetupOptions {
	    context?: Context;
	}
	export function graphqlSetup(graphqlSetupOptions: GraphqlSetupOptions): Promise<GraphQlHelper>;
	export function graphqlMetadataSetup(setupOptions: SetupOptions): Promise<GraphQlHelper>;
	export function clientSetup(setupOptions: SetupOptions): Promise<Graph<GraphApi> & {
	    testUser?: string;
	}>;
	export { ConfigManager };
	export function stubConfigManager(stubbedConfig: Config): void;
	export function restoreConfigManager(): void;
	//# sourceMappingURL=setup.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/index' {
	import { SysGlobalLock } from '@sage/xtrem-core/lib/index';
	import * as activities from '@sage/xtrem-core/test/fixtures/activities/_index';
	import * as activityExtensions from '@sage/xtrem-core/test/fixtures/activity-extensions/_index';
	import * as dataTypes from '@sage/xtrem-core/test/fixtures/data-types/_index';
	import * as enumExtensions from '@sage/xtrem-core/test/fixtures/enum-extensions/index';
	import * as enums from '@sage/xtrem-core/test/fixtures/enums/index';
	import * as importedExtension from '@sage/xtrem-core/test/fixtures/node-extensions/index';
	import * as importedNodes from '@sage/xtrem-core/test/fixtures/nodes/index';
	import * as serviceOptions from '@sage/xtrem-core/test/fixtures/service-options/index';
	export { dropTables, dropTestTable, initTables, restoreTables } from '@sage/xtrem-core/lib/test/tables';
	export * as applications from '@sage/xtrem-core/test/fixtures/applications';
	export * from '@sage/xtrem-core/test/fixtures/data/index';
	export * from '@sage/xtrem-core/test/fixtures/setup';
	export * from '@sage/xtrem-core/test/fixtures/util';
	export { activities, activityExtensions, dataTypes, enumExtensions, enums, importedNodes, serviceOptions };
	export const nodes: {
	    SysGlobalLock: typeof SysGlobalLock;
	    TestSysVendor: typeof importedNodes.TestSysVendor;
	    TestUser: typeof importedNodes.TestUser;
	    TestNaturalKey: typeof importedNodes.TestNaturalKey;
	    AdaptValuesStringDataType: typeof importedNodes.AdaptValuesStringDataType;
	    TestAdaptValues: typeof importedNodes.TestAdaptValues;
	    TestAggDocument: typeof importedNodes.TestAggDocument;
	    TestAggDocumentBaseLine: typeof importedNodes.TestAggDocumentBaseLine;
	    TestAggDocumentExtendedLine: typeof importedNodes.TestAggDocumentExtendedLine;
	    TestAggDocumentLine: typeof importedNodes.TestAggDocumentLine;
	    TestAggDocumentReverseRef: typeof importedNodes.TestAggDocumentReverseRef;
	    TestAssociationAssociated: typeof importedNodes.TestAssociationAssociated;
	    TestAssociationItem: typeof importedNodes.TestAssociationItem;
	    TestStudent: typeof importedNodes.TestStudent;
	    TestCourse: typeof importedNodes.TestCourse;
	    TestStudentCourse: typeof importedNodes.TestStudentCourse;
	    TestCampus: typeof importedNodes.TestCampus;
	    TestStudentCourseCampus: typeof importedNodes.TestStudentCourseCampus;
	    TestReference: typeof importedNodes.TestReference;
	    TestCollection: typeof importedNodes.TestCollection;
	    TestReferenceCollection: typeof importedNodes.TestReferenceCollection;
	    TestAssociationVitalParent: typeof importedNodes.TestAssociationVitalParent;
	    TestBaseReference: typeof importedNodes.TestBaseReference;
	    TestBaseCollectionElement: typeof importedNodes.TestBaseCollectionElement;
	    TestBaseVitalChild: typeof importedNodes.TestBaseVitalChild;
	    TestBase: typeof importedNodes.TestBase;
	    TestBaseJson: typeof importedNodes.TestBaseJson;
	    TestCachedEncryptedValues: typeof importedNodes.TestCachedEncryptedValues;
	    TestCreateUpdateStamp: typeof importedNodes.TestCreateUpdateStamp;
	    AdvancedStringDataType: typeof importedNodes.AdvancedStringDataType;
	    TestDataTypeEvents: typeof importedNodes.TestDataTypeEvents;
	    testTextStreamType: import("../../lib/index").TextStreamDataType<import("../../lib/index").TextStream, unknown>;
	    mailTemplateType: import("../../lib/index").TextStreamDataType<import("../../lib/index").TextStream, unknown>;
	    testJsonDataType: import("../../lib/index").JsonDataType<unknown, importedNodes.TestDatatypesJson>;
	    TestDatatypes: typeof importedNodes.TestDatatypes;
	    TestDocument: typeof importedNodes.TestDocument;
	    TestDocumentLine: typeof importedNodes.TestDocumentLine;
	    ComputedDocumentLine: typeof importedNodes.ComputedDocumentLine;
	    TestDocumentLookup: typeof importedNodes.TestDocumentLookup;
	    TestEncryptedValues: typeof importedNodes.TestEncryptedValues;
	    TestFrozen: typeof importedNodes.TestFrozen;
	    TestNotFrozenBase: typeof importedNodes.TestNotFrozenBase;
	    TestOverrideNotFrozen: typeof importedNodes.TestOverrideNotFrozen;
	    TestOverrideFrozen: typeof importedNodes.TestOverrideFrozen;
	    TestGraphQlOperation: typeof importedNodes.TestGraphQlOperation;
	    TestIoProperties: typeof importedNodes.TestIoProperties;
	    TestIsClearedByResetDatatypes: typeof importedNodes.TestIsClearedByResetDatatypes;
	    TestIsClearedByResetInClassDecorator: typeof importedNodes.TestIsClearedByResetInClassDecorator;
	    TestIsClearedByResetTooComplex: typeof importedNodes.TestIsClearedByResetTooComplex;
	    TestIsClearedByResetWithRef: typeof importedNodes.TestIsClearedByResetWithRef;
	    TestIsClearedByResetFunctionInNode: typeof importedNodes.TestIsClearedByResetFunctionInNode;
	    TestIsClearedByResetRefNode: typeof importedNodes.TestIsClearedByResetRefNode;
	    TestLookupAccess: typeof importedNodes.TestLookupAccess;
	    TestMultiUniqueIndexes: typeof importedNodes.TestMultiUniqueIndexes;
	    TestMutationLongDelay: typeof importedNodes.TestMutationLongDelay;
	    MutationOptionalParameters: typeof importedNodes.MutationOptionalParameters;
	    TestFilterNestedGrandParent: typeof importedNodes.TestFilterNestedGrandParent;
	    TestFilterNestedParent: typeof importedNodes.TestFilterNestedParent;
	    TestFilterNestedChild: typeof importedNodes.TestFilterNestedChild;
	    TestNullable: typeof importedNodes.TestNullable;
	    TestNullableUniqueIndex: typeof importedNodes.TestNullableUniqueIndex;
	    TestOperationReference: typeof importedNodes.TestOperationReference;
	    TestOperation: typeof importedNodes.TestOperation;
	    descriptionDataType: import("../../lib/index").StringDataType<unknown, string>;
	    defaultDecimalDataType: import("../../lib/index").DecimalDataType<unknown, number>;
	    TestProduct: typeof importedNodes.TestProduct;
	    TestProductCollection: typeof importedNodes.TestProductCollection;
	    TestProductCollectionReference: typeof importedNodes.TestProductCollectionReference;
	    TestReferencedByCollection: typeof importedNodes.TestReferencedByCollection;
	    TestRefToDoc: typeof importedNodes.TestRefToDoc;
	    TestRefToNodeWithLazyLoading: typeof importedNodes.TestRefToNodeWithLazyLoading;
	    TestReferencedDocument: typeof importedNodes.TestReferencedDocument;
	    TestReferencedDocumentDetails: typeof importedNodes.TestReferencedDocumentDetails;
	    TestReferencedDocumentOther: typeof importedNodes.TestReferencedDocumentOther;
	    TestBaseCertificate: typeof importedNodes.TestBaseCertificate;
	    TestSupplierCertificate: typeof importedNodes.TestSupplierCertificate;
	    TestSupplier: typeof importedNodes.TestSupplier;
	    TestReferred: typeof importedNodes.TestReferred;
	    TestReferring: typeof importedNodes.TestReferring;
	    TestMandatoryReferring: typeof importedNodes.TestMandatoryReferring;
	    TestReferringWithJoin: typeof importedNodes.TestReferringWithJoin;
	    TestRequiredProperty: typeof importedNodes.TestRequiredProperty;
	    TestSite: typeof importedNodes.TestSite;
	    TestSecure: typeof importedNodes.TestSecure;
	    TestItem: typeof importedNodes.TestItem;
	    TestStock: typeof importedNodes.TestStock;
	    TestAnimal: typeof importedNodes.TestAnimal;
	    TestAnimalLine: typeof importedNodes.TestAnimalLine;
	    TestMammal: typeof importedNodes.TestMammal;
	    TestDog: typeof importedNodes.TestDog;
	    TestCat: typeof importedNodes.TestCat;
	    TestFish: typeof importedNodes.TestFish;
	    TestBird: typeof importedNodes.TestBird;
	    TestPetOwner: typeof importedNodes.TestPetOwner;
	    TestFlyBehavior: typeof importedNodes.TestFlyBehavior;
	    TestSleepBehavior: typeof importedNodes.TestSleepBehavior;
	    TestAnimalJsonOverride: typeof importedNodes.TestAnimalJsonOverride;
	    TestHorse: typeof importedNodes.TestHorse;
	    TestOverrideAnimal: typeof importedNodes.TestOverrideAnimal;
	    TestOverrideAnimalOwner: typeof importedNodes.TestOverrideAnimalOwner;
	    TestOverrideHorse: typeof importedNodes.TestOverrideHorse;
	    TestOverrideHorseOwner: typeof importedNodes.TestOverrideHorseOwner;
	    TestOverrideCow: typeof importedNodes.TestOverrideCow;
	    TestOverrideCowOwner: typeof importedNodes.TestOverrideCowOwner;
	    TestOverrideBaseDocument: typeof importedNodes.TestOverrideBaseDocument;
	    TestOverrideBaseDocumentLine: typeof importedNodes.TestOverrideBaseDocumentLine;
	    TestOverrideInvoice: typeof importedNodes.TestOverrideInvoice;
	    TestOverrideInvoiceLine: typeof importedNodes.TestOverrideInvoiceLine;
	    TestActivity: typeof importedNodes.TestActivity;
	    TestActiLine: typeof importedNodes.TestActiLine;
	    TestActiLineDetail: typeof importedNodes.TestActiLineDetail;
	    TestActivityRelated: typeof importedNodes.TestActivityRelated;
	    TestAnonymizeExport: typeof importedNodes.TestAnonymizeExport;
	    TestCachedNode: typeof importedNodes.TestCachedNode;
	    TestDataSensitivityLog: typeof importedNodes.TestDataSensitivityLog;
	    TestDelegatedTo: typeof importedNodes.TestDelegatedTo;
	    TestDelegatedToReference: typeof importedNodes.TestDelegatedToReference;
	    TestDefaultValue: typeof importedNodes.TestDefaultValue;
	    TestDefaultValuesAdvanced: typeof importedNodes.TestDefaultValuesAdvanced;
	    TestDefaultValuesReference: typeof importedNodes.TestDefaultValuesReference;
	    TestDownload: typeof importedNodes.TestDownload;
	    TestDuplicatedValue: typeof importedNodes.TestDuplicatedValue;
	    TestDuplicatedVitalReference: typeof importedNodes.TestDuplicatedVitalReference;
	    TestDuplicatedNonVitalReference: typeof importedNodes.TestDuplicatedNonVitalReference;
	    TestDuplicatedReferenceForNull: typeof importedNodes.TestDuplicatedReferenceForNull;
	    TestDuplicatedParent: typeof importedNodes.TestDuplicatedParent;
	    TestDuplicatedChild: typeof importedNodes.TestDuplicatedChild;
	    TestDuplicatedSecondChild: typeof importedNodes.TestDuplicatedSecondChild;
	    TestDuplicatedGrandChild: typeof importedNodes.TestDuplicatedGrandChild;
	    TestComplexDuplicatedValue: typeof importedNodes.TestComplexDuplicatedValue;
	    TestDuplicatedBaseNode: typeof importedNodes.TestDuplicatedBaseNode;
	    TestDuplicatedOverride: typeof importedNodes.TestDuplicatedOverride;
	    TestDuplicatedOverride2: typeof importedNodes.TestDuplicatedOverride2;
	    duplicatedValueData: {
	        _id: number;
	        booleanVal: boolean;
	        booleanDuplicateDefault: boolean;
	        booleanDuplicateTrueFunction: boolean;
	        stringDuplicateFunction: string;
	        testReference: number;
	        testReferenceNotNullable: number;
	        stringIndicator: string;
	    }[];
	    duplicatedVitalReferenceData: {
	        testDuplicatedValue: number;
	        code: string;
	    }[];
	    duplicatedNonVitalReferenceData: {
	        _id: number;
	        code: string;
	    }[];
	    duplicatedReferenceForNull: {
	        code: string;
	    }[];
	    duplicatedValueParentData: {
	        _id: number;
	        code: string;
	        stringDuplicateFunction: string;
	    }[];
	    duplicatedValueChildData: {
	        _id: number;
	        duplicatedParent: number;
	        code: string;
	        stringDuplicateFunction: string;
	        _sortValue: number;
	        duplicatedReferenceWithNullDuplicate: number;
	    }[];
	    duplicatedValueSecondChildData: {
	        _id: number;
	        duplicatedParent: number;
	        _sortValue: number;
	    }[];
	    duplicatedValueGrandChildData: {
	        _id: number;
	        duplicatedChildParent: number;
	        code: string;
	        stringDuplicateFunction: string;
	        _sortValue: number;
	    }[];
	    complexDuplicatedValueData: {
	        _id: number;
	        stringOldValue: string;
	        stringNewValue: string;
	    }[];
	    duplicatedOverrideData: {
	        _id: number;
	        stringValue: string;
	    }[];
	    duplicatedOverrideData2: {
	        _id: number;
	        stringValue: string;
	    }[];
	    TestExportValue: typeof importedNodes.TestExportValue;
	    TestExtensionReference: typeof importedNodes.TestExtensionReference;
	    TestMutationOnNullableProperty: typeof importedNodes.TestMutationOnNullableProperty;
	    TestNodeDetails: typeof importedNodes.TestNodeDetails;
	    TestGrandChildReferenceDataType: typeof importedNodes.TestGrandChildReferenceDataType;
	    TestChildReferenceDataType: typeof importedNodes.TestChildReferenceDataType;
	    TestReferenceDataType: typeof importedNodes.TestReferenceDataType;
	    TestNoReferenceDataType: typeof importedNodes.TestNoReferenceDataType;
	    TestReferenceDataTypeParent: typeof importedNodes.TestReferenceDataTypeParent;
	    testReferenceDataTypeCyclic: import("../../lib/index").ReferenceDataType<importedNodes.TestReferenceDataTypeCyclic, import("../../lib/index").Node>;
	    TestReferenceDataTypeCyclic: typeof importedNodes.TestReferenceDataTypeCyclic;
	    TestSignal: typeof importedNodes.TestSignal;
	    TestSystemComputed: typeof importedNodes.TestSystemComputed;
	    TestUserFields: typeof importedNodes.TestUserFields;
	    TestTransient: typeof importedNodes.TestTransient;
	    TestTransientLines: typeof importedNodes.TestTransientLines;
	    TestReferringValidIsActive: typeof importedNodes.TestReferringValidIsActive;
	    TestValidIsActive: typeof importedNodes.TestValidIsActive;
	    TestReferringValidIsActiveFunc: typeof importedNodes.TestReferringValidIsActiveFunc;
	    TestParentIsActive: typeof importedNodes.TestParentIsActive;
	    TestChildIsActive: typeof importedNodes.TestChildIsActive;
	    TestValidationBasic: typeof importedNodes.TestValidationBasic;
	    TestValidationPersistent: typeof importedNodes.TestValidationPersistent;
	    TestValidationSeverity: typeof importedNodes.TestValidationSeverity;
	    TestValidationBoolean: typeof importedNodes.TestValidationBoolean;
	    TestValidationNumber: typeof importedNodes.TestValidationNumber;
	    TestValidationString: typeof importedNodes.TestValidationString;
	    TestControlFlow: typeof importedNodes.TestControlFlow;
	    TestValidationDate: typeof importedNodes.TestValidationDate;
	    TestValidationReturns: typeof importedNodes.TestValidationReturns;
	    TestVitalCollectionChild: typeof importedNodes.TestVitalCollectionChild;
	    TestVitalCollectionParent: typeof importedNodes.TestVitalCollectionParent;
	    TestVitalCollectionSubChild: typeof importedNodes.TestVitalCollectionSubChild;
	    TestBaseAddress: typeof importedNodes.TestBaseAddress;
	    TestSupplierAddress: typeof importedNodes.TestSupplierAddress;
	    TestAddressContact: typeof importedNodes.TestAddressContact;
	    TestSupplierWithSubNodeCollection: typeof importedNodes.TestSupplierWithSubNodeCollection;
	    TestVitalReferenceExtensionParent: typeof importedNodes.TestVitalReferenceExtensionParent;
	    TestVitalReferenceChildMandatory: typeof importedNodes.TestVitalReferenceChildMandatory;
	    TestVitalReferenceChildOptional: typeof importedNodes.TestVitalReferenceChildOptional;
	    TestNonVitalReference: typeof importedNodes.TestNonVitalReference;
	    TestVitalReferenceParent: typeof importedNodes.TestVitalReferenceParent;
	    TestVitalReferenceParentLowLevel: typeof importedNodes.TestVitalReferenceParentLowLevel;
	    TestVitalReferenceParentMidLevel: typeof importedNodes.TestVitalReferenceParentMidLevel;
	    TestVitalReferenceParentTopLevel: typeof importedNodes.TestVitalReferenceParentTopLevel;
	    TestVitalReferenceParentWithTwoChildrenSameTypeParent: typeof importedNodes.TestVitalReferenceParentWithTwoChildrenSameTypeParent;
	    TestVitalReferenceParentWithTwoChildrenSameTypeChild: typeof importedNodes.TestVitalReferenceParentWithTwoChildrenSameTypeChild;
	};
	export const nodeExtensions: typeof importedExtension;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/applications.d.ts
declare module '@sage/xtrem-core/test/fixtures/applications' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/** MiniTestApplicationGenerator and TestApplication are used to generate minimal applications for xtrem-core tests. */
	/** TestApplication is a wrapper that returns an application for a given api.
	 * We cannot return directly an application because at the time this file is executed, fixtures.nodes is still
	 * undefined. Defining global constants such as:
	 *
	 * "export const testLookupsApplication = new Application({ api: { nodes: { fixtures.nodes.TestDocumentLookup } } })"
	 *
	 * thus causes an error. Solution: store the actual application in an internal _application attribute, that will
	 * be instantiated in a before(() => { ... }) function. */
	class TestApplication {
	    private _contents;
	    private _application;
	    constructor(_contents: {
	        nodes?: string[];
	        nodeExtensions?: string[];
	    });
	    get application(): Promise<Application>;
	}
	/** MiniApplicationGenerator keeps track of the TestApplication instances that were already created by a previously
	 * executed test. If a TestApplication was already created for the same api, then the cached TestApplication instance
	 * is returned. */
	class MiniTestApplicationGenerator {
	    private _testApplications;
	    getMiniTestApplication(contents: {
	        nodes?: string[];
	        nodeExtensions?: string[];
	    }): TestApplication;
	}
	export const testApplicationGenerator: MiniTestApplicationGenerator;
	export const testAggregationApplication: TestApplication;
	export const testExtensionApplication: TestApplication;
	export const testVitalChildExtensionApplication: TestApplication;
	export const testBasicDocumentApplication: TestApplication;
	export const testEmptyApplication: TestApplication;
	export const testDocumentWithTransientApplication: TestApplication;
	export const testTransientApplication: TestApplication;
	export const testDatatypesApplication: TestApplication;
	export const testLazyLoadingApplication: TestApplication;
	export const testEncryptedValuesApplication: TestApplication;
	export const testTenantApplication: TestApplication;
	export const testIsFrozenApplication: TestApplication;
	export const testSubclassingApplication: TestApplication;
	export const testSubclassingOverrideApplication: TestApplication;
	export const testSubclassingDataExtractionApplication: TestApplication;
	export const testDefaultValueApplication: TestApplication;
	export const testDuplicatedValueApplication: TestApplication;
	export const testLookupsApplication: TestApplication;
	export const testValidationApplication: TestApplication;
	export const testValidIsActiveApplication: TestApplication;
	export const testVitalReferenceApplication: TestApplication;
	export const testAssociationReferenceApplication: TestApplication;
	export const testVitalCollectionApplication: TestApplication;
	export const testNotificationApplication: TestApplication;
	export const testMutationsApplication: TestApplication;
	export const testCachedNodeApplication: TestApplication;
	export const testDataSensitivityLogApplication: TestApplication;
	export const testMultiLevelVitalApplication: TestApplication;
	export const testMultiLevelVitalApplicationWithTwoChildrenSameType: TestApplication;
	export const dirname: string;
	export {};
	//# sourceMappingURL=applications.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/option4.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/option4' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const serviceOption4: ServiceOption;
	//# sourceMappingURL=option4.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/option3.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/option3' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const serviceOption3: ServiceOption;
	//# sourceMappingURL=option3.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/option2.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/option2' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const serviceOption2: ServiceOption;
	//# sourceMappingURL=option2.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/option1.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/option1' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const serviceOption1: ServiceOption;
	//# sourceMappingURL=option1.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/is-demo-tenant.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/is-demo-tenant' {
	export { isDemoTenant } from '@sage/xtrem-core/lib/test/service-options/index';
	//# sourceMappingURL=is-demo-tenant.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/index' {
	export * from '@sage/xtrem-core/test/fixtures/service-options/hidden-options1';
	export * from '@sage/xtrem-core/test/fixtures/service-options/hidden-options2';
	export * from '@sage/xtrem-core/test/fixtures/service-options/high-level-options';
	export * from '@sage/xtrem-core/test/fixtures/service-options/is-demo-tenant';
	export * from '@sage/xtrem-core/test/fixtures/service-options/option1';
	export * from '@sage/xtrem-core/test/fixtures/service-options/option2';
	export * from '@sage/xtrem-core/test/fixtures/service-options/option3';
	export * from '@sage/xtrem-core/test/fixtures/service-options/option4';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/high-level-options.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/high-level-options' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const highLevelServiceOption: ServiceOption;
	//# sourceMappingURL=high-level-options.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/hidden-options2.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/hidden-options2' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const hiddenServiceOption2: ServiceOption;
	//# sourceMappingURL=hidden-options2.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/service-options/hidden-options1.d.ts
declare module '@sage/xtrem-core/test/fixtures/service-options/hidden-options1' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const hiddenServiceOption1: ServiceOption;
	//# sourceMappingURL=hidden-options1.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-reference-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-reference-parent' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	import { TestNonVitalReference, TestVitalReferenceChildMandatory, TestVitalReferenceChildOptional } from '@sage/xtrem-core/test/fixtures/nodes/vital-reference-child';
	export class TestVitalReferenceParent extends Node {
	    readonly code: Promise<string>;
	    readonly mandatoryVitalRef: Reference<TestVitalReferenceChildMandatory>;
	    readonly optionalVitalRef: Reference<TestVitalReferenceChildOptional | null>;
	    readonly nonVitalRef: Reference<TestNonVitalReference | null>;
	}
	//# sourceMappingURL=vital-reference-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-reference-parent-multi-level.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-reference-parent-multi-level' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestVitalReferenceParentLowLevel extends Node {
	    readonly code: Promise<string>;
	    readonly parentMidLevel: Reference<TestVitalReferenceParentMidLevel>;
	    readonly selfRef: Reference<TestVitalReferenceParentLowLevel>;
	}
	export class TestVitalReferenceParentMidLevel extends Node {
	    readonly code: Promise<string>;
	    readonly lowLevelRef: Reference<TestVitalReferenceParentLowLevel>;
	    readonly parentTopLevel: Reference<TestVitalReferenceParentTopLevel>;
	    readonly selfRef: Reference<TestVitalReferenceParentMidLevel>;
	}
	export class TestVitalReferenceParentTopLevel extends Node {
	    readonly code: Promise<string>;
	    readonly midLevelRef: Reference<TestVitalReferenceParentMidLevel>;
	    readonly selfRef: Reference<TestVitalReferenceParentTopLevel>;
	}
	export class TestVitalReferenceParentWithTwoChildrenSameTypeParent extends Node {
	    readonly code: Promise<string>;
	    readonly childRef: Reference<TestVitalReferenceParentWithTwoChildrenSameTypeChild>;
	    readonly anotherRef: Reference<TestVitalReferenceParentWithTwoChildrenSameTypeChild | null>;
	}
	export class TestVitalReferenceParentWithTwoChildrenSameTypeChild extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestVitalReferenceParentWithTwoChildrenSameTypeParent>;
	}
	//# sourceMappingURL=vital-reference-parent-multi-level.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-reference-child.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-reference-child' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	import { TestVitalReferenceParent } from '@sage/xtrem-core/test/fixtures/nodes/vital-reference-parent';
	export class TestVitalReferenceChildMandatory extends Node {
	    readonly parent: Reference<TestVitalReferenceParent>;
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class TestVitalReferenceChildOptional extends Node {
	    readonly parent: Reference<TestVitalReferenceParent>;
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	    readonly nonVitalRef: Reference<TestNonVitalReference>;
	}
	export class TestNonVitalReference extends Node {
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	}
	//# sourceMappingURL=vital-reference-child.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-extension-reference-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-extension-reference-parent' {
	import { Node, Reference } from '@sage/xtrem-core/lib/index';
	import { TestBaseVitalChild } from '@sage/xtrem-core/test/fixtures/nodes/base';
	export class TestVitalReferenceExtensionParent extends Node {
	    readonly code: Promise<string>;
	    readonly child: Reference<TestBaseVitalChild>;
	}
	//# sourceMappingURL=vital-extension-reference-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-collection-sub-node.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-collection-sub-node' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestBaseAddress extends Node {
	    readonly code: Promise<string>;
	    readonly contacts: Collection<TestAddressContact>;
	}
	export class TestSupplierAddress extends TestBaseAddress {
	    readonly isPrimary: Promise<boolean>;
	    readonly supplier: Reference<TestSupplierWithSubNodeCollection>;
	}
	export class TestAddressContact extends Node {
	    readonly code: Promise<string>;
	    readonly address: Reference<TestBaseAddress>;
	}
	export class TestSupplierWithSubNodeCollection extends Node {
	    readonly code: Promise<string>;
	    readonly addresses: Collection<TestSupplierAddress>;
	}
	//# sourceMappingURL=vital-collection-sub-node.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-collection-sub-child.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-collection-sub-child' {
	import { TestVitalCollectionChild } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestVitalCollectionSubChild extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestVitalCollectionChild>;
	}
	//# sourceMappingURL=vital-collection-sub-child.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-collection-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-collection-parent' {
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	import { TestVitalCollectionChild } from '@sage/xtrem-core/test/fixtures/nodes/vital-collection-child';
	export class TestVitalCollectionParent extends Node {
	    readonly code: Promise<string>;
	    readonly computedLast: Promise<string>;
	    readonly children: Collection<TestVitalCollectionChild>;
	}
	//# sourceMappingURL=vital-collection-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/vital-collection-child.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/vital-collection-child' {
	import { TestVitalCollectionParent, TestVitalCollectionSubChild } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Reference } from '@sage/xtrem-core/index';
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	export class TestVitalCollectionChild extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestVitalCollectionParent>;
	    readonly children: Collection<TestVitalCollectionSubChild>;
	}
	//# sourceMappingURL=vital-collection-child.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/validation.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/validation' {
	import { date, integer, Node } from '@sage/xtrem-core/index';
	export class TestValidationBasic extends Node {
	    readonly s1: Promise<string>;
	    readonly s2: Promise<string>;
	    readonly s3: Promise<string>;
	    readonly i1: Promise<integer>;
	    readonly i2: Promise<integer>;
	}
	export class TestValidationPersistent extends Node {
	    readonly s1: Promise<string>;
	    readonly s2: Promise<string>;
	    readonly s3: Promise<string>;
	    readonly i1: Promise<integer>;
	    readonly i2: Promise<integer>;
	}
	export class TestValidationSeverity extends Node {
	    readonly value: Promise<string>;
	}
	export class TestValidationBoolean extends Node {
	    readonly mustBeTrue: Promise<boolean>;
	    readonly mustBeFalse: Promise<boolean>;
	}
	export class TestValidationNumber extends Node {
	    readonly mandatory: Promise<number>;
	    readonly mustBeZero: Promise<number>;
	    readonly mustBePositive: Promise<number>;
	    readonly mustBeNegative: Promise<number>;
	    readonly mustBeNegativeCustomMessage: Promise<number>;
	    readonly mustBePositiveCustomMessage: Promise<number>;
	    readonly mustBeA32BitSignedInteger: Promise<number>;
	}
	export class TestValidationString extends Node {
	    readonly mandatory: Promise<string>;
	    readonly mustBeEmpty: Promise<string>;
	    readonly mustBeA: Promise<string>;
	}
	export class TestControlFlow extends Node {
	    readonly v1: Promise<string>;
	    readonly v2: Promise<string>;
	}
	export class TestValidationDate extends Node {
	    readonly referenceDate: Promise<date>;
	    readonly testDate: Promise<date | null>;
	}
	export class TestValidationReturns extends Node {
	}
	//# sourceMappingURL=validation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/valid-is-active.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/valid-is-active' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestReferringValidIsActive extends Node {
	    readonly code: Promise<string>;
	    readonly reference: Reference<TestValidIsActive | null>;
	    readonly ignoringReference: Reference<TestValidIsActive | null>;
	}
	export class TestValidIsActive extends Node {
	    readonly code: Promise<string>;
	    readonly activeField: Promise<boolean>;
	}
	export class TestReferringValidIsActiveFunc extends Node {
	    readonly code: Promise<string>;
	    readonly reference: Reference<TestValidIsActive | null>;
	    readonly ignoringReference: Reference<TestValidIsActive | null>;
	}
	export class TestParentIsActive extends Node {
	    readonly code: Promise<string>;
	    readonly activeField: Promise<boolean>;
	    readonly children: Collection<TestChildIsActive>;
	}
	export class TestChildIsActive extends Node {
	    readonly parent: Reference<TestParentIsActive>;
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=valid-is-active.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/transient.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/transient' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	import { integer } from '@sage/xtrem-core/lib/ts-api/index';
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/referred';
	import { TestTransientLines } from '@sage/xtrem-core/test/fixtures/nodes/transient-lines';
	export class TestTransient extends Node {
	    readonly stringValue: Promise<string>;
	    readonly transientValue: Promise<string>;
	    readonly derivedValue: Promise<string>;
	    readonly transientRef: Reference<TestReferred | null>;
	    readonly derivedFromRef: Promise<string>;
	    readonly transientLines: Collection<TestTransientLines>;
	    readonly derivedCollection: Collection<TestTransientLines>;
	    readonly derivedFromCollection: Promise<integer>;
	}
	//# sourceMappingURL=transient.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/transient-lines.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/transient-lines' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	import { TestTransient } from '@sage/xtrem-core/test/fixtures/nodes/transient';
	export class TestTransientLines extends Node {
	    readonly stringValue: Promise<string>;
	    readonly parent: Reference<TestTransient>;
	}
	//# sourceMappingURL=transient-lines.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-user-fields.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-user-fields' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestUserFields extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=test-user-fields.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-system-computed.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-system-computed' {
	import { datetime, Node } from '@sage/xtrem-core/index';
	export class TestSystemComputed extends Node {
	    readonly id: Promise<string>;
	    readonly description: Promise<string>;
	    readonly createdBy: Promise<string>;
	    readonly updatedBy: Promise<string>;
	    readonly updateStamp: Promise<datetime>;
	    readonly createStamp: Promise<datetime>;
	}
	//# sourceMappingURL=test-system-computed.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-signal.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-signal' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestSignal extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=test-signal.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-reference-data-type.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-reference-data-type' {
	import { integer, Node, Reference, ReferenceDataType } from '@sage/xtrem-core/index';
	export class TestGrandChildReferenceDataType extends Node {
	    readonly grandChildCode: Promise<string>;
	}
	export class TestChildReferenceDataType extends Node {
	    readonly childCode: Promise<string>;
	    readonly grandChild: Reference<TestGrandChildReferenceDataType>;
	}
	export class TestReferenceDataType extends Node {
	    readonly code: Promise<string>;
	    readonly name: Promise<string>;
	    readonly noLookup: Promise<string>;
	    readonly child: Reference<TestChildReferenceDataType>;
	}
	export class TestNoReferenceDataType extends Node {
	    readonly code: Promise<string>;
	    readonly ref: Reference<TestReferenceDataType>;
	}
	export class TestReferenceDataTypeParent extends Node {
	    readonly id: Promise<integer>;
	    readonly stringVal: Promise<string>;
	    readonly referenceDataType: Reference<TestReferenceDataType>;
	    readonly nullableReferenceDataType: Reference<TestReferenceDataType | null>;
	}
	export const testReferenceDataTypeCyclic: ReferenceDataType<TestReferenceDataTypeCyclic, Node>;
	export class TestReferenceDataTypeCyclic extends Node {
	    readonly id: Promise<integer>;
	    readonly name: Promise<string>;
	    readonly selfReference: Reference<TestReferenceDataTypeCyclic | null>;
	}
	//# sourceMappingURL=test-reference-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-node-details.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-node-details' {
	import { BaseMutationDecorator, Context, Node, StaticThis } from '@sage/xtrem-core/index';
	import { TestEnum } from '@sage/xtrem-core/test/fixtures/enums/index';
	export interface AsyncMutationDecorator<This extends StaticThis<Node>, K extends keyof This> extends BaseMutationDecorator<This, K> {
	    /** Can the mutation be scheduled as a batch job */
	    isSchedulable?: boolean;
	}
	export class TestNodeDetails extends Node {
	    readonly name: Promise<string>;
	    readonly isLocalized: Promise<boolean>;
	    readonly isLocalizedComputed: Promise<boolean>;
	    readonly isLocalizedGetValue: Promise<boolean>;
	    readonly testBaseEnum: Promise<TestEnum | null>;
	    static testCreate(context: Context, name: string, isLocalized: boolean): Promise<TestNodeDetails>;
	    static testQuery(context: Context, name: string): Promise<TestNodeDetails>;
	}
	//# sourceMappingURL=test-node-details.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-mutation-on-nullable-property.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-mutation-on-nullable-property' {
	import { integer } from '@sage/xtrem-shared';
	import { date, Node } from '@sage/xtrem-core/lib/index';
	export class TestMutationOnNullableProperty extends Node {
	    readonly dateVal: Promise<date | null>;
	    readonly intVal: Promise<integer>;
	}
	//# sourceMappingURL=test-mutation-on-nullable-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-extension-reference.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-extension-reference' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestExtensionReference extends Node {
	    readonly refCode: Promise<string>;
	    readonly refExtensionCode: Promise<string>;
	}
	//# sourceMappingURL=test-extension-reference.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-export-value.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-export-value' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestExportValue extends Node {
	    readonly code: Promise<string>;
	    readonly sensitive: Promise<string>;
	}
	//# sourceMappingURL=test-export-value.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-duplicated-value.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-duplicated-value' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/lib/index';
	export class TestDuplicatedValue extends Node {
	    readonly booleanVal: Promise<boolean>;
	    readonly booleanDuplicateDefault: Promise<boolean>;
	    readonly booleanDuplicateTrueFunction: Promise<boolean>;
	    readonly stringDuplicateFunction: Promise<string>;
	    readonly stringIndicator: Promise<string>;
	    readonly testVitalReference: Reference<TestDuplicatedVitalReference | null>;
	    readonly testReference: Reference<TestDuplicatedNonVitalReference | null>;
	    readonly testReferenceNotNullable: Reference<TestDuplicatedNonVitalReference>;
	}
	export class TestDuplicatedVitalReference extends Node {
	    readonly testDuplicatedValue: Reference<TestDuplicatedValue>;
	    readonly code: Promise<string>;
	}
	export class TestDuplicatedNonVitalReference extends Node {
	    readonly code: Promise<string>;
	}
	export class TestDuplicatedReferenceForNull extends Node {
	    readonly code: Promise<string>;
	}
	export class TestDuplicatedParent extends Node {
	    readonly code: Promise<string>;
	    readonly stringDuplicateFunction: Promise<string>;
	    readonly lines: Collection<TestDuplicatedChild>;
	    readonly linesWithDuplicatedValue: Collection<TestDuplicatedSecondChild>;
	}
	export class TestDuplicatedChild extends Node {
	    readonly duplicatedParent: Reference<TestDuplicatedParent>;
	    readonly code: Promise<string>;
	    readonly stringDuplicateFunction: Promise<string>;
	    readonly childLines: Collection<TestDuplicatedGrandChild>;
	    readonly duplicatedReferenceWithNullDuplicate: Reference<TestDuplicatedReferenceForNull>;
	}
	export class TestDuplicatedSecondChild extends Node {
	    readonly duplicatedParent: Reference<TestDuplicatedParent>;
	}
	export class TestDuplicatedGrandChild extends Node {
	    readonly duplicatedChildParent: Reference<TestDuplicatedChild>;
	    readonly code: Promise<string>;
	    readonly stringDuplicateFunction: Promise<string>;
	}
	export class TestComplexDuplicatedValue extends Node {
	    readonly stringOldValue: Promise<string>;
	    readonly stringNewValue: Promise<string>;
	}
	export class TestDuplicatedBaseNode extends Node {
	    readonly code: Promise<string>;
	    readonly stringValue: Promise<string>;
	}
	export class TestDuplicatedOverride extends TestDuplicatedBaseNode {
	    readonly stringValue: Promise<string>;
	}
	export class TestDuplicatedOverride2 extends TestDuplicatedBaseNode {
	    readonly stringValue: Promise<string>;
	}
	export const duplicatedValueData: {
	    _id: number;
	    booleanVal: boolean;
	    booleanDuplicateDefault: boolean;
	    booleanDuplicateTrueFunction: boolean;
	    stringDuplicateFunction: string;
	    testReference: number;
	    testReferenceNotNullable: number;
	    stringIndicator: string;
	}[];
	export const duplicatedVitalReferenceData: {
	    testDuplicatedValue: number;
	    code: string;
	}[];
	export const duplicatedNonVitalReferenceData: {
	    _id: number;
	    code: string;
	}[];
	export const duplicatedReferenceForNull: {
	    code: string;
	}[];
	export const duplicatedValueParentData: {
	    _id: number;
	    code: string;
	    stringDuplicateFunction: string;
	}[];
	export const duplicatedValueChildData: {
	    _id: number;
	    duplicatedParent: number;
	    code: string;
	    stringDuplicateFunction: string;
	    _sortValue: number;
	    duplicatedReferenceWithNullDuplicate: number;
	}[];
	export const duplicatedValueSecondChildData: {
	    _id: number;
	    duplicatedParent: number;
	    _sortValue: number;
	}[];
	export const duplicatedValueGrandChildData: {
	    _id: number;
	    duplicatedChildParent: number;
	    code: string;
	    stringDuplicateFunction: string;
	    _sortValue: number;
	}[];
	export const complexDuplicatedValueData: {
	    _id: number;
	    stringOldValue: string;
	    stringNewValue: string;
	}[];
	export const duplicatedOverrideData: {
	    _id: number;
	    stringValue: string;
	}[];
	export const duplicatedOverrideData2: {
	    _id: number;
	    stringValue: string;
	}[];
	//# sourceMappingURL=test-duplicated-value.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-download.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-download' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestDownload extends Node {
	    readonly key: Promise<string>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly downloadUrl: Promise<string>;
	}
	//# sourceMappingURL=test-download.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-default-values-reference.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-default-values-reference' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestDefaultValuesReference extends Node {
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=test-default-values-reference.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-default-values-advanced.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-default-values-advanced' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	import { TestDefaultValuesReference } from '@sage/xtrem-core/test/fixtures/nodes/test-default-values-reference';
	export class TestDefaultValuesAdvanced extends Node {
	    readonly reference1: Reference<TestDefaultValuesReference>;
	    readonly reference2: Reference<TestDefaultValuesReference>;
	    readonly text1: Promise<string>;
	    readonly text2: Promise<string>;
	}
	//# sourceMappingURL=test-default-values-advanced.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-default-value.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-default-value' {
	import { TestDefaultValuesReference } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Reference } from '@sage/xtrem-core/index';
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	export class TestDefaultValue extends Node {
	    readonly booleanNoDefault: Promise<boolean>;
	    readonly booleanDefaultTrueLiteral: Promise<boolean>;
	    readonly booleanDefaultTrueFunction: Promise<boolean>;
	    readonly stringDefaultFunction: Promise<string>;
	    readonly booleanNullDefault: Promise<boolean>;
	    readonly dateNullDefault: Promise<boolean>;
	    readonly referenceNullDefault: Reference<TestDefaultValuesReference>;
	    readonly referenceNotNullDefault: Reference<TestDefaultValuesReference | null>;
	    readonly failingComputedCollection: Collection<TestDefaultValuesReference>;
	}
	//# sourceMappingURL=test-default-value.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-data-sensitivity-log.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-data-sensitivity-log' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Collection, Context, Node, Reference, decimal } from '@sage/xtrem-core/lib/index';
	export class TestDataSensitivityLog extends Node {
	    readonly code: Promise<string>;
	    readonly stringRegular: Promise<string>;
	    readonly stringNotSensitive: Promise<string>;
	    readonly stringSensitive: Promise<string>;
	    readonly delegate: Reference<TestDelegatedToReference>;
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	    readonly textSensitive: Promise<string>;
	    readonly boolSensitive: Promise<boolean>;
	    readonly lines: Collection<TestDelegatedTo>;
	    static customQuery(context: Context, searchCriteria: {
	        item: Reference<TestDataSensitivityLog>;
	        itemList?: {
	            status: number;
	        }[];
	    }): decimal;
	    static customMutation(context: Context, searchCriteria: {
	        item: Reference<TestDataSensitivityLog>;
	        itemList?: {
	            status: number;
	        }[];
	    }): decimal;
	}
	export class TestDelegatedTo extends Node {
	    readonly testDelegatedToReference: Reference<TestDelegatedToReference>;
	    readonly testDataSensitivityLog: Reference<TestDataSensitivityLog>;
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	    readonly textSensitive: Promise<string>;
	    readonly boolSensitive: Promise<boolean>;
	}
	export class TestDelegatedToReference extends Node {
	    readonly text: Promise<string>;
	    readonly bool: Promise<boolean>;
	    readonly textSensitive: Promise<string>;
	    readonly boolSensitive: Promise<boolean>;
	}
	//# sourceMappingURL=test-data-sensitivity-log.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-cached-node.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-cached-node' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestCachedNode extends Node {
	    readonly value: Promise<string>;
	    readonly value2: Promise<string>;
	}
	//# sourceMappingURL=test-cached-node.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-anonymized-export.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-anonymized-export' {
	import { BinaryStream, integer, Node, short, TextStream } from '@sage/xtrem-core/lib/index';
	export class TestAnonymizeExport extends Node {
	    readonly code: Promise<string>;
	    readonly stringRegular: Promise<string>;
	    readonly stringFixed: Promise<string>;
	    readonly stringHash: Promise<string>;
	    readonly stringShortHash: Promise<string>;
	    readonly stringHashLimit: Promise<string>;
	    readonly integerRandom: Promise<integer>;
	    readonly integerLimitRandom: Promise<integer>;
	    readonly shortRandom: Promise<short>;
	    readonly stringCustom: Promise<string>;
	    readonly stringPerCharacter: Promise<string>;
	    readonly urlToAnonymize: Promise<string>;
	    readonly pdf: Promise<BinaryStream> | null;
	    readonly image: Promise<BinaryStream> | null;
	    readonly textStream: Promise<TextStream> | null;
	}
	//# sourceMappingURL=test-anonymized-export.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-activity.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-activity' {
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Collection, Context, Node, Reference } from '@sage/xtrem-core/index';
	export class TestActivity extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly lines: Collection<TestActiLine>;
	    readonly reference: Reference<TestReferred | null>;
	    static testMutation(context: Context, something: string): string;
	    static report(context: Context, test: string): string;
	}
	export class TestActiLine extends Node {
	    readonly testActivity: Reference<TestActivity>;
	    readonly details: Collection<TestActiLineDetail>;
	}
	export class TestActiLineDetail extends Node {
	    readonly testActiLine: Reference<TestActiLine>;
	}
	//# sourceMappingURL=test-activity.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/test-activity-related.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/test-activity-related' {
	import { Context, Node, Reference } from '@sage/xtrem-core/index';
	import { TestCat } from '@sage/xtrem-core/test/fixtures/nodes/subclassing';
	export class TestActivityRelated extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly cat: Reference<TestCat>;
	    static reportA(context: Context, test: string): string;
	    static reportB(context: Context, test: string): string;
	    static reportAExt(context: Context, test: string): string;
	}
	//# sourceMappingURL=test-activity-related.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/subclassing.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/subclassing' {
	import { integer } from '@sage/xtrem-shared';
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { Collection, Context } from '@sage/xtrem-core/lib/index';
	import { TestAnimalFlyBehaviorEnum, TestAnimalSleepBehaviorEnum } from '@sage/xtrem-core/test/fixtures/enums/index';
	export class TestAnimal extends Node {
	    readonly strFromAnimal: Promise<string>;
	    readonly owner: Reference<TestPetOwner | null>;
	    readonly flyBehavior: Reference<TestFlyBehavior | null>;
	    readonly sleepBehavior: Reference<TestSleepBehavior | null>;
	    readonly lines: Collection<TestAnimalLine>;
	    nonStaticMethod(param: integer): Promise<string>;
	    static staticOperation(_context: Context, param: integer): string;
	}
	export class TestAnimalLine extends Node {
	    readonly testAnimal: Reference<TestAnimal>;
	}
	export class TestMammal extends TestAnimal {
	    readonly strFromMammal: Promise<string>;
	    readonly flyBehavior: Reference<TestFlyBehavior | null>;
	}
	export class TestDog extends TestMammal {
	    readonly strFromDog: Promise<string>;
	    readonly sleepBehavior: Reference<TestSleepBehavior>;
	}
	export class TestCat extends TestMammal {
	    readonly strFromCat: Promise<string>;
	    readonly sleepBehavior: Reference<TestSleepBehavior>;
	}
	export class TestFish extends TestAnimal {
	    readonly strFromFish: Promise<string>;
	    readonly flyBehavior: Reference<TestFlyBehavior | null>;
	    readonly sleepBehavior: Reference<TestSleepBehavior>;
	}
	export class TestBird extends TestAnimal {
	    readonly strFromBird: Promise<string>;
	    readonly flyBehavior: Reference<TestFlyBehavior | null>;
	    readonly sleepBehavior: Reference<TestSleepBehavior>;
	}
	export class TestPetOwner extends Node {
	    readonly pets: Collection<TestAnimal>;
	    readonly favoritePet: Reference<TestAnimal | null>;
	}
	export class TestFlyBehavior extends Node {
	    readonly flyBehavior: Promise<TestAnimalFlyBehaviorEnum>;
	}
	export class TestSleepBehavior extends Node {
	    readonly sleepBehavior: Promise<TestAnimalSleepBehaviorEnum>;
	}
	//# sourceMappingURL=subclassing.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/subclassing-override.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/subclassing-override' {
	import { Collection, date, integer, Node, Reference } from '@sage/xtrem-core/index';
	export class TestOverrideAnimal extends Node {
	    readonly name: Promise<string>;
	    readonly owner: Reference<TestOverrideAnimalOwner | null>;
	}
	export class TestOverrideAnimalOwner extends Node {
	    readonly animals: Collection<TestOverrideAnimal>;
	    readonly favoriteAnimal: Reference<TestOverrideAnimal | null>;
	}
	export class TestOverrideHorse extends TestOverrideAnimal {
	    readonly owner: Reference<TestOverrideHorseOwner | null>;
	    readonly bestRaceResult: integer;
	}
	export class TestOverrideHorseOwner extends TestOverrideAnimalOwner {
	    readonly animals: Collection<TestOverrideHorse>;
	    readonly racesWon: Promise<integer>;
	}
	export class TestOverrideCow extends TestOverrideAnimal {
	}
	export class TestOverrideCowOwner extends TestOverrideAnimalOwner {
	}
	export class TestOverrideBaseDocument extends Node {
	    readonly id: Promise<string>;
	    readonly lines: Collection<TestOverrideBaseDocumentLine>;
	}
	export class TestOverrideBaseDocumentLine extends Node {
	    readonly quantity: Promise<integer>;
	    readonly document: Reference<TestOverrideBaseDocument>;
	}
	export class TestOverrideInvoice extends TestOverrideBaseDocument {
	    readonly lines: Collection<TestOverrideInvoiceLine>;
	    readonly isClosed: Promise<boolean>;
	}
	export class TestOverrideInvoiceLine extends TestOverrideBaseDocumentLine {
	    readonly document: Reference<TestOverrideInvoice>;
	    readonly date: Promise<date>;
	}
	//# sourceMappingURL=subclassing-override.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/subclassing-json-override.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/subclassing-json-override' {
	import { Node } from '@sage/xtrem-core/index';
	export interface HorseDatatypesJson {
	    name?: string;
	    size?: number;
	}
	export class TestAnimalJsonOverride extends Node {
	    readonly jsonAnimal: Promise<HorseDatatypesJson>;
	}
	export class TestHorse extends TestAnimalJsonOverride {
	    readonly jsonAnimal: Promise<HorseDatatypesJson>;
	}
	//# sourceMappingURL=subclassing-json-override.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/stock.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/stock' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Reference } from '@sage/xtrem-core/index';
	import { decimal, integer, Node } from '@sage/xtrem-core/lib/index';
	export class TestItem extends Node {
	    readonly code: Promise<string>;
	}
	export class TestStock extends Node {
	    readonly stockSite: Promise<string>;
	    readonly location: Promise<string>;
	    readonly product: Reference<TestItem>;
	    readonly sublot: Promise<integer | null>;
	    readonly quantityInStockUnit: Promise<decimal>;
	}
	//# sourceMappingURL=stock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/secure.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/secure' {
	import { Context, Node, Reference } from '@sage/xtrem-core/index';
	export class TestSite extends Node {
	    readonly code: Promise<string>;
	}
	export class TestSecure extends Node {
	    readonly code: Promise<string>;
	    readonly site: Reference<TestSite | null>;
	    readonly access: Promise<string>;
	    static lookupQueryWithoutGrant(context: Context, param1: string): string;
	    static lookupQueryWithGrant(context: Context, param1: string): string;
	}
	//# sourceMappingURL=secure.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/required-property.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/required-property' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { integer } from '@sage/xtrem-core/lib/index';
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/referred';
	export class TestRequiredProperty extends Node {
	    readonly notRequiredNullable: Promise<integer | null>;
	    readonly notRequiredNullable2: Promise<integer | null>;
	    readonly notRequiredNotNullable: Promise<integer>;
	    readonly requiredReference: Reference<TestReferred>;
	    readonly requiredReferenceArray: Promise<TestReferred[]>;
	    readonly requiredComputed: Promise<integer | null>;
	}
	//# sourceMappingURL=required-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referring.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referring' {
	import { integer, Node, Reference } from '@sage/xtrem-core/index';
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/referred';
	export class TestReferring extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly restricted: Promise<string>;
	    readonly reference: Reference<TestReferred | null>;
	    readonly referenceArray: Promise<TestReferred[] | null>;
	    readonly nestedComputedVal: Promise<integer>;
	}
	export class TestMandatoryReferring extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly restricted: Promise<string>;
	    readonly reference: Reference<TestReferred>;
	}
	export class TestReferringWithJoin extends Node {
	    readonly code: Promise<string>;
	    readonly referenceCode: Promise<string>;
	    readonly reference: Reference<TestReferred | null>;
	    readonly propertyJoinReference: Reference<TestReferred | null>;
	    readonly joinLiteralReference: Reference<TestReferred | null>;
	    readonly deepJoinReference: Reference<TestReferring | null>;
	}
	//# sourceMappingURL=referring.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referred.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referred' {
	import { integer, Node } from '@sage/xtrem-core/index';
	export class TestReferred extends Node {
	    readonly code: Promise<string>;
	    readonly details: Promise<string>;
	    readonly restricted: Promise<string>;
	    readonly integerVal: Promise<integer | null>;
	    readonly computedVal: Promise<integer>;
	}
	//# sourceMappingURL=referred.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referenced-sub-node.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referenced-sub-node' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestBaseCertificate extends Node {
	    readonly code: Promise<string>;
	}
	export class TestSupplierCertificate extends TestBaseCertificate {
	    readonly supplier: Reference<TestSupplier>;
	}
	export class TestSupplier extends Node {
	    readonly code: Promise<string>;
	    readonly certificates: Collection<TestSupplierCertificate>;
	}
	//# sourceMappingURL=referenced-sub-node.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referenced-document.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referenced-document' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { integer } from '@sage/xtrem-core/lib/index';
	import { TestReferencedDocumentDetails } from '@sage/xtrem-core/test/fixtures/nodes/referenced-document-details';
	export class TestReferencedDocument extends Node {
	    readonly lookupString: Promise<string>;
	    readonly controlInteger: Promise<integer>;
	    readonly controlDetails: Reference<TestReferencedDocumentDetails | null>;
	}
	//# sourceMappingURL=referenced-document.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referenced-document-other.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referenced-document-other' {
	import { Node } from '@sage/xtrem-core/index';
	import { integer } from '@sage/xtrem-core/lib/index';
	export class TestReferencedDocumentOther extends Node {
	    readonly lookupString: Promise<string>;
	    readonly controlInteger: Promise<integer>;
	}
	//# sourceMappingURL=referenced-document-other.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/referenced-document-details.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/referenced-document-details' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestReferencedDocumentDetails extends Node {
	    readonly text: Promise<string>;
	}
	//# sourceMappingURL=referenced-document-details.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/ref-to-node-with-lazy-load.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/ref-to-node-with-lazy-load' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { TestDatatypes } from '@sage/xtrem-core/test/fixtures/nodes/datatypes';
	export class TestRefToNodeWithLazyLoading extends Node {
	    readonly reference: Reference<TestDatatypes>;
	}
	//# sourceMappingURL=ref-to-node-with-lazy-load.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/ref-to-doc.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/ref-to-doc' {
	import { TestDocument } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Node, Reference } from '@sage/xtrem-core/index';
	export class TestRefToDoc extends Node {
	    readonly code: Promise<string>;
	    readonly vitalDoc: Reference<TestDocument>;
	    readonly forbidDoc: Reference<TestDocument | null>;
	}
	//# sourceMappingURL=ref-to-doc.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/product.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/product' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Collection, Reference } from '@sage/xtrem-core/index';
	import { decimal, DecimalDataType, integer, Node, StringDataType } from '@sage/xtrem-core/lib/index';
	export const descriptionDataType: StringDataType<unknown, string>;
	export const defaultDecimalDataType: DecimalDataType<unknown, number>;
	export class TestProduct extends Node {
	    readonly product: Promise<string>;
	    readonly description: Promise<string>;
	    readonly hotProduct: Promise<boolean>;
	    readonly qty: Promise<integer>;
	    readonly st: Promise<integer>;
	    readonly listPrice: Promise<decimal>;
	    readonly progress: Promise<integer>;
	    readonly netPrice: Promise<decimal>;
	    readonly tax: Promise<decimal>;
	    readonly amount: Promise<decimal>;
	    readonly collection: Reference<TestProductCollection>;
	}
	export class TestProductCollection extends Node {
	    readonly description: Promise<string>;
	    readonly products: Collection<TestProduct>;
	    readonly reference: Reference<TestReferencedByCollection>;
	}
	export class TestProductCollectionReference extends Node {
	    readonly description: Promise<string>;
	    readonly collection: Reference<TestProductCollection>;
	}
	export class TestReferencedByCollection extends Node {
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=product.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/operation.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/operation' {
	import { BinaryStream, Context, integer, Node, TextStream } from '@sage/xtrem-core/lib/index';
	import * as fixtures from '@sage/xtrem-core/test/fixtures/index';
	type ComplexParameters = {
	    object: {
	        simple?: boolean;
	        mandatory: string;
	        nullable?: integer | null;
	    };
	    optionalObjects?: {
	        nestedStrings?: string[] | null;
	        flag?: boolean;
	    }[];
	};
	type ObjectWithArrayOfEnums = {
	    statusList: fixtures.enums.TestEnumEnum[];
	};
	export class TestOperationReference extends Node {
	    readonly code: Promise<string>;
	    readonly quantity: Promise<integer>;
	}
	export class TestOperation extends Node {
	    readonly code: Promise<string>;
	    readonly value: Promise<integer>;
	    static mutationReturningString(context: Context, code: string, stringVal: string, intVal: integer): Promise<string>;
	    static queryReturningString(context: Context, code: string, stringVal: string, intVal: integer, enumVal: fixtures.enums.TestEnum): string;
	    static mutationReturningNode(context: Context, code: string, intVal: integer): Promise<TestOperation>;
	    static mutationWithNodeParameter(context: Context, arg: TestOperation): TestOperation;
	    static queryWithComplexInput(context: Context, object: ComplexParameters['object'], optionalObjects?: ComplexParameters['optionalObjects']): string;
	    static queryWithComplexOutput(context: Context, object: ComplexParameters['object'], optionalObjects?: ComplexParameters['optionalObjects']): ComplexParameters;
	    static queryWithReferences(context: Context, reference: TestOperationReference, nullableReference: TestOperationReference | null, arrayOfReferences: TestOperationReference[], arrayOfNullableReferences: (TestOperationReference | null)[], nested: {
	        reference: TestOperationReference;
	        nullableReference: TestOperationReference | null;
	        arrayOfReferences: TestOperationReference[];
	        arrayOfNullableReferences: (TestOperationReference | null)[];
	    }): {
	        reference: fixtures.importedNodes.TestOperationReference;
	        nullableReference: fixtures.importedNodes.TestOperationReference | null;
	        arrayOfReferences: fixtures.importedNodes.TestOperationReference[];
	        arrayOfNullableReferences: (fixtures.importedNodes.TestOperationReference | null)[];
	        nested: {
	            reference: TestOperationReference;
	            nullableReference: TestOperationReference | null;
	            arrayOfReferences: TestOperationReference[];
	            arrayOfNullableReferences: (TestOperationReference | null)[];
	        };
	    };
	    static queryReturningSimpleArray(context: Context, len: integer): string[];
	    static queryReturningArrayOfObjects(context: Context, len: integer): {
	        index: number;
	        text: string;
	    }[];
	    static mutationArrayOfInstanceReturningString(context: Context, instanceArray: TestOperation[]): Promise<string>;
	    static mutationWithBinaryStreamAsResult(context: Context, base64Data: string): BinaryStream;
	    static mutationWithTextStreamAsResult(context: Context, textContent: string): TextStream;
	    static queryWithOptionalArgs(context: Context, option1?: string, option2?: string, option3?: string): string;
	    static mutationWithNonWritableReferenceParameter(context: Context, reference: TestOperationReference): Promise<string>;
	    static mutationWithWritableReferenceParameter(context: Context, reference: TestOperationReference): Promise<string>;
	    static mutationStartedReadonlyRunningWithWritable(context: Context, reference: TestOperationReference): Promise<string>;
	    static mutationArrayOfEnums(context: Context, objectWithArrayOfEnums: ObjectWithArrayOfEnums): string;
	    static mutationWithoutParameters(context: Context): string;
	}
	export {};
	//# sourceMappingURL=operation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/nullable-unique-index.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/nullable-unique-index' {
	import { date, integer, Node, Reference } from '@sage/xtrem-core/index';
	import { TestEnumNullableEnum } from '@sage/xtrem-core/test/fixtures/enums/index';
	import { TestDatatypes } from '@sage/xtrem-core/test/fixtures/nodes/datatypes';
	export class TestNullableUniqueIndex extends Node {
	    readonly id: Promise<integer>;
	    readonly reference: Reference<TestDatatypes | null>;
	    readonly integerVal: Promise<integer | null>;
	    readonly enumVal: Promise<TestEnumNullableEnum | null>;
	    readonly dateVal: Promise<date | null>;
	}
	//# sourceMappingURL=nullable-unique-index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/nullable-decimal-node.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/nullable-decimal-node' {
	/// <reference types="@sage/xtrem-decimal" />
	import { integer, Node } from '@sage/xtrem-core/index';
	import { decimal } from '@sage/xtrem-core/lib/index';
	export class TestNullable extends Node {
	    readonly id: Promise<integer>;
	    readonly nullableDecimal: Promise<decimal>;
	}
	//# sourceMappingURL=nullable-decimal-node.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/non-boolean-is-active.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/non-boolean-is-active' {
	import { Node } from '@sage/xtrem-core/index';
	export class NonBooleanIsActive extends Node {
	    readonly code: Promise<string>;
	    readonly isActive: Promise<string>;
	}
	//# sourceMappingURL=non-boolean-is-active.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/nested-collections.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/nested-collections' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestFilterNestedGrandParent extends Node {
	    readonly text: Promise<string>;
	    readonly children: Collection<TestFilterNestedParent>;
	}
	export class TestFilterNestedParent extends Node {
	    readonly intVal: Promise<number>;
	    readonly text: Promise<string>;
	    readonly parent: Reference<TestFilterNestedGrandParent>;
	    readonly children: Collection<TestFilterNestedChild>;
	}
	export class TestFilterNestedChild extends Node {
	    readonly intVal: Promise<number>;
	    readonly intVal2: Promise<number>;
	    readonly text: Promise<string>;
	    readonly parent: Reference<TestFilterNestedParent>;
	}
	//# sourceMappingURL=nested-collections.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/natural-key-nodes.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/natural-key-nodes' {
	import { integer } from '@sage/xtrem-shared';
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	import { TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/referred';
	export class TestNaturalKey extends Node {
	    readonly key: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class TestNaturalKeyComposite extends Node {
	    readonly key: Promise<string>;
	    readonly key2: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class TestNaturalKeyCompositePartialNullableParent extends Node {
	    readonly key: Promise<string>;
	    readonly keyReference: Promise<TestNaturalKeyCompositePartialNullable>;
	    readonly text: Promise<string>;
	}
	export class TestNaturalKeyCompositePartialNullable extends Node {
	    readonly key: Promise<string>;
	    readonly keyInteger: Promise<integer | null>;
	    readonly keyReference: Reference<TestNaturalKey | null>;
	    readonly text: Promise<string>;
	}
	export class TestNaturalKeyParent extends Node {
	    readonly key: Promise<string>;
	    readonly text: Promise<string>;
	    readonly lines: Collection<TestNaturalKeyVitalChild>;
	}
	export class TestNaturalKeyVitalChild extends Node {
	    readonly parent: Reference<TestNaturalKeyParent>;
	    readonly code1: Promise<string>;
	    readonly code2: Promise<string>;
	}
	export class TestReferenceOnVitalChild extends Node {
	    readonly vitalChildRef: Reference<TestNaturalKeyVitalChild>;
	}
	export class TestReferenceToNaturalKey extends Node {
	    readonly id: Promise<string>;
	    readonly ref: Reference<TestNaturalKey>;
	}
	export class InvalidNaturalKeyNotUnique extends Node {
	    readonly key: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class InvalidNaturalKeyNotPublished extends Node {
	    readonly key: Promise<string>;
	    readonly key2: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class InvalidNaturalKeyString extends Node {
	    readonly key: Promise<string>;
	    readonly key2: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class InvalidNaturalKeyMultiple extends Node {
	    readonly key: Promise<string>;
	    readonly key2: Promise<string>;
	    readonly text: Promise<string>;
	}
	export class InvalidNaturalKeyParent extends Node {
	    readonly key: Promise<string>;
	    readonly text: Promise<string>;
	    readonly lines: Collection<InvalidNaturalKeyVitalChild>;
	}
	export class InvalidNaturalKeyVitalChild extends Node {
	    readonly parent: Reference<InvalidNaturalKeyParent>;
	    readonly keyChild: Promise<string>;
	    readonly textChild: Promise<string>;
	}
	export class InvalidNaturalKeyNonNullableReference extends Node {
	    readonly parent: Reference<TestReferred>;
	}
	export class SetupNodeNoNaturalKey extends Node {
	    readonly key: Promise<string>;
	}
	//# sourceMappingURL=natural-key-nodes.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/mutation-optional-parameters.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/mutation-optional-parameters' {
	import { Context, Node } from '@sage/xtrem-core/lib/index';
	export class MutationOptionalParameters extends Node {
	    readonly name: Promise<string>;
	    static testMutationOptional(context: Context, parm1Mandatory?: string, parm2Optional?: string, parm3Optional?: string, parm4Optional?: string): {
	        parm1: string;
	        parm2: string;
	        parm3: string;
	        parm4: string;
	    };
	}
	//# sourceMappingURL=mutation-optional-parameters.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/mutation-long-delay.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/mutation-long-delay' {
	import { Node, Reference } from '@sage/xtrem-core/lib/index';
	export class TestMutationLongDelay extends Node {
	    readonly name: Promise<string>;
	    readonly reference: Reference<TestMutationLongDelay | null>;
	}
	//# sourceMappingURL=mutation-long-delay.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/multiple-is-active.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/multiple-is-active' {
	import { Node } from '@sage/xtrem-core/index';
	export class MultipleIsActive extends Node {
	    readonly code: Promise<string>;
	    readonly isActive1: Promise<boolean>;
	    readonly isActive2: Promise<boolean>;
	}
	//# sourceMappingURL=multiple-is-active.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/multi-unique-indexes.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/multi-unique-indexes' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestMultiUniqueIndexes extends Node {
	    readonly code: Promise<string>;
	    readonly alt1: Promise<string>;
	    readonly alt2: Promise<string>;
	    readonly details: Promise<string>;
	}
	//# sourceMappingURL=multi-unique-indexes.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/lookup-access.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/lookup-access' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestLookupAccess extends Node {
	    readonly code: Promise<string>;
	    readonly noLookup: Promise<string>;
	}
	//# sourceMappingURL=lookup-access.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/is-cleared-by-reset.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/is-cleared-by-reset' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Time } from '@sage/xtrem-date-time';
	import { BinaryStream, date, dateRange, datetime, datetimeRange, decimal, decimalRange, integer, integerRange, Node, Reference, short, TextStream, Uuid } from '@sage/xtrem-core/index';
	import { TestEnum, TestEnumForArray } from '@sage/xtrem-core/test/fixtures/enums/index';
	import { TestDatatypesJson } from '@sage/xtrem-core/test/fixtures/nodes/datatypes';
	export class TestIsClearedByResetDatatypes extends Node {
	    readonly id: Promise<integer>;
	    readonly booleanVal: Promise<boolean | null>;
	    readonly shortVal: Promise<short>;
	    readonly integerVal: Promise<integer>;
	    readonly integerRangeVal: Promise<integerRange | null>;
	    readonly decimalRangeVal: Promise<decimalRange | null>;
	    readonly enumVal: Promise<TestEnum | null>;
	    readonly stringVal: Promise<string>;
	    readonly decimalVal: Promise<decimal>;
	    readonly floatVal: Promise<number>;
	    readonly doubleVal: Promise<number>;
	    readonly dateVal: Promise<date | null>;
	    readonly dateRangeVal: Promise<dateRange | null>;
	    readonly datetimeRangeVal: Promise<datetimeRange | null>;
	    readonly timeVal: Promise<Time | null>;
	    readonly datetimeVal: Promise<datetime | null>;
	    readonly binaryStream: Promise<BinaryStream | null>;
	    readonly textStream: Promise<TextStream>;
	    readonly mailTemplate: Promise<TextStream>;
	    readonly uuidVal: Promise<Uuid>;
	    readonly computed: Promise<integer>;
	    readonly complexComputed: Promise<integer>;
	    readonly jsonVal: Promise<TestDatatypesJson>;
	    readonly integerArrayVal: Promise<integer[] | null>;
	    readonly enumArrayVal: Promise<TestEnumForArray[] | null>;
	    readonly stringArrayVal: Promise<string[] | null>;
	}
	export class TestIsClearedByResetInClassDecorator extends Node {
	    readonly id: Promise<integer>;
	    readonly integerVal: Promise<integer>;
	}
	export class TestIsClearedByResetTooComplex extends Node {
	    readonly id: Promise<integer>;
	    readonly integerVal: Promise<integer>;
	}
	export class TestIsClearedByResetWithRef extends Node {
	    readonly sequenceNumber: Promise<integer>;
	    readonly ref: Reference<TestIsClearedByResetDatatypes>;
	}
	export class TestIsClearedByResetFunctionInNode extends Node {
	    readonly code: Promise<integer>;
	    readonly ref: Reference<TestIsClearedByResetRefNode>;
	}
	export class TestIsClearedByResetRefNode extends Node {
	    readonly codeRef: Promise<integer>;
	}
	//# sourceMappingURL=is-cleared-by-reset.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/input-output-properties.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/input-output-properties' {
	import { Node } from '@sage/xtrem-core/lib/index';
	export class TestIoProperties extends Node {
	    readonly inputAndOutputProperty: Promise<string>;
	    readonly inputOnlyProperty: Promise<string>;
	    readonly outputOnlyPropertyGet: Promise<string>;
	    readonly outputOnlyPropertyCompute: Promise<string>;
	}
	//# sourceMappingURL=input-output-properties.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/index' {
	export { TestSysVendor, TestUser } from '@sage/xtrem-core/lib/test/manager-mocks/index';
	export * from '@sage/xtrem-core/test/fixtures/nodes/adapt-values';
	export * from '@sage/xtrem-core/test/fixtures/nodes/agg-document';
	export * from '@sage/xtrem-core/test/fixtures/nodes/agg-document-base-line';
	export * from '@sage/xtrem-core/test/fixtures/nodes/agg-document-extended-line';
	export * from '@sage/xtrem-core/test/fixtures/nodes/agg-document-line';
	export * from '@sage/xtrem-core/test/fixtures/nodes/agg-document-reverse-ref';
	export * from '@sage/xtrem-core/test/fixtures/nodes/association-associated';
	export * from '@sage/xtrem-core/test/fixtures/nodes/association-item';
	export * from '@sage/xtrem-core/test/fixtures/nodes/association-nodes';
	export * from '@sage/xtrem-core/test/fixtures/nodes/association-vital-parent';
	export * from '@sage/xtrem-core/test/fixtures/nodes/base';
	export * from '@sage/xtrem-core/test/fixtures/nodes/base-json';
	export * from '@sage/xtrem-core/test/fixtures/nodes/cached-encrypted-values';
	export * from '@sage/xtrem-core/test/fixtures/nodes/create-update-stamp';
	export * from '@sage/xtrem-core/test/fixtures/nodes/data-type-events';
	export * from '@sage/xtrem-core/test/fixtures/nodes/datatypes';
	export * from '@sage/xtrem-core/test/fixtures/nodes/document';
	export * from '@sage/xtrem-core/test/fixtures/nodes/document-line';
	export * from '@sage/xtrem-core/test/fixtures/nodes/document-lookup';
	export * from '@sage/xtrem-core/test/fixtures/nodes/encrypted-values';
	export * from '@sage/xtrem-core/test/fixtures/nodes/frozen';
	export * from '@sage/xtrem-core/test/fixtures/nodes/graphql-access-rights';
	export * from '@sage/xtrem-core/test/fixtures/nodes/input-output-properties';
	export * from '@sage/xtrem-core/test/fixtures/nodes/is-cleared-by-reset';
	export * from '@sage/xtrem-core/test/fixtures/nodes/lookup-access';
	export * from '@sage/xtrem-core/test/fixtures/nodes/multi-unique-indexes';
	export * from '@sage/xtrem-core/test/fixtures/nodes/mutation-long-delay';
	export * from '@sage/xtrem-core/test/fixtures/nodes/mutation-optional-parameters';
	export { TestNaturalKey } from '@sage/xtrem-core/test/fixtures/nodes/natural-key-nodes';
	export * from '@sage/xtrem-core/test/fixtures/nodes/nested-collections';
	export * from '@sage/xtrem-core/test/fixtures/nodes/nullable-decimal-node';
	export * from '@sage/xtrem-core/test/fixtures/nodes/nullable-unique-index';
	export * from '@sage/xtrem-core/test/fixtures/nodes/operation';
	export * from '@sage/xtrem-core/test/fixtures/nodes/product';
	export * from '@sage/xtrem-core/test/fixtures/nodes/ref-to-doc';
	export * from '@sage/xtrem-core/test/fixtures/nodes/ref-to-node-with-lazy-load';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referenced-document';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referenced-document-details';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referenced-document-other';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referenced-sub-node';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referred';
	export * from '@sage/xtrem-core/test/fixtures/nodes/referring';
	export * from '@sage/xtrem-core/test/fixtures/nodes/required-property';
	export * from '@sage/xtrem-core/test/fixtures/nodes/secure';
	export * from '@sage/xtrem-core/test/fixtures/nodes/stock';
	export * from '@sage/xtrem-core/test/fixtures/nodes/subclassing';
	export * from '@sage/xtrem-core/test/fixtures/nodes/subclassing-json-override';
	export * from '@sage/xtrem-core/test/fixtures/nodes/subclassing-override';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-activity';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-activity-related';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-anonymized-export';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-cached-node';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-data-sensitivity-log';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-default-value';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-default-values-advanced';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-default-values-reference';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-download';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-duplicated-value';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-export-value';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-extension-reference';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-mutation-on-nullable-property';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-node-details';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-reference-data-type';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-signal';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-system-computed';
	export * from '@sage/xtrem-core/test/fixtures/nodes/test-user-fields';
	export * from '@sage/xtrem-core/test/fixtures/nodes/transient';
	export * from '@sage/xtrem-core/test/fixtures/nodes/transient-lines';
	export * from '@sage/xtrem-core/test/fixtures/nodes/valid-is-active';
	export * from '@sage/xtrem-core/test/fixtures/nodes/validation';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-collection-child';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-collection-parent';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-collection-sub-child';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-collection-sub-node';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-extension-reference-parent';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-reference-child';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-reference-parent';
	export * from '@sage/xtrem-core/test/fixtures/nodes/vital-reference-parent-multi-level';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/graphql-access-rights.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/graphql-access-rights' {
	import { Context, Node } from '@sage/xtrem-core/lib/index';
	export class TestGraphQlOperation extends Node {
	    readonly code: Promise<string>;
	    static createOperation(context: Context, param1: string): string;
	    static updateOperation(context: Context, param1: string): string;
	    static deleteOperation(context: Context, param1: string): string;
	    static lookupQueryWithGrant(context: Context, param1: string): string;
	    static lookupQueryWithoutGrant(context: Context, param1: string): string;
	}
	//# sourceMappingURL=graphql-access-rights.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/frozen.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/frozen' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestFrozen extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	export class TestNotFrozenBase extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	export class TestOverrideNotFrozen extends TestNotFrozenBase {
	    readonly strFromOverrideNotFrozen: Promise<string>;
	    readonly description: Promise<string>;
	}
	export class TestOverrideFrozen extends TestNotFrozenBase {
	    readonly strFromOverrideFrozen: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=frozen.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/encrypted-values.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/encrypted-values' {
	import { integer, Node } from '@sage/xtrem-core/index';
	export class TestEncryptedValues extends Node {
	    readonly id: Promise<integer>;
	    readonly passwordValue: Promise<string>;
	}
	//# sourceMappingURL=encrypted-values.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/document.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/document' {
	import { TestDocumentLine, TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Collection, Node, Reference } from '@sage/xtrem-core/index';
	export class TestDocument extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly mandatoryReference: Reference<TestReferred>;
	    readonly lines: Collection<TestDocumentLine>;
	    readonly computedLines: Collection<TestDocumentLine>;
	    readonly filteredLines: Collection<TestDocumentLine>;
	    readonly filteredLinesWithReverseReference: Collection<TestDocumentLine>;
	}
	//# sourceMappingURL=document.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/document-lookup.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/document-lookup' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { integer } from '@sage/xtrem-core/lib/index';
	import { TestReferencedDocument } from '@sage/xtrem-core/test/fixtures/nodes/referenced-document';
	import { TestReferencedDocumentDetails } from '@sage/xtrem-core/test/fixtures/nodes/referenced-document-details';
	import { TestReferencedDocumentOther } from '@sage/xtrem-core/test/fixtures/nodes/referenced-document-other';
	export class TestDocumentLookup extends Node {
	    readonly parentControlInteger: Promise<integer>;
	    readonly reference: Reference<TestReferencedDocument | null>;
	    readonly noLookupReference: Reference<TestReferencedDocument>;
	    readonly noControlReference: Reference<TestReferencedDocument>;
	    readonly noFiltersReference: Reference<TestReferencedDocument>;
	    readonly otherReference: Reference<TestReferencedDocumentOther>;
	    readonly dynamicReference: Reference<TestReferencedDocumentOther>;
	    readonly details: Reference<TestReferencedDocumentDetails | null>;
	    readonly controlledByDetailsReference: Reference<TestReferencedDocument | null>;
	    readonly controlledByDetailsId: Reference<TestReferencedDocument | null>;
	    readonly referenceArrayLookup: Promise<TestReferencedDocument[] | null>;
	    readonly referenceArrayControl: Promise<TestReferencedDocument[] | null>;
	}
	//# sourceMappingURL=document-lookup.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/document-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/document-line' {
	import { TestDocument, TestReferred } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { Node, Reference, integer } from '@sage/xtrem-core/index';
	export class TestDocumentLine extends Node {
	    readonly description: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly optionalReference: Reference<TestReferred | null>;
	    readonly document: Reference<TestDocument>;
	    readonly getDescription: Promise<string>;
	}
	export class ComputedDocumentLine extends Node {
	    readonly lineNumber: Promise<integer>;
	    readonly text: Promise<string>;
	}
	//# sourceMappingURL=document-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/datatypes.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/datatypes' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Time } from '@sage/xtrem-date-time';
	import { BinaryStream, JsonDataType, Node, TextStream, TextStreamDataType, Uuid, date, dateRange, datetime, datetimeRange, decimal, decimalRange, integer, integerRange, short } from '@sage/xtrem-core/index';
	import { TestEnum, TestEnumForArray } from '@sage/xtrem-core/test/fixtures/enums/index';
	export const testTextStreamType: TextStreamDataType<TextStream, unknown>;
	export const mailTemplateType: TextStreamDataType<TextStream, unknown>;
	export interface TestDatatypesJson {
	    id?: number;
	    code?: string;
	    isValidated?: boolean;
	    text?: {
	        fr?: string;
	        en?: string;
	        es?: string;
	    };
	    authors?: Array<string>;
	}
	export const testJsonDataType: JsonDataType<unknown, TestDatatypesJson>;
	export class TestDatatypes extends Node {
	    readonly id: Promise<integer>;
	    readonly booleanVal: Promise<boolean | null>;
	    readonly shortVal: Promise<short | null>;
	    readonly integerVal: Promise<integer>;
	    readonly integerRangeVal: Promise<integerRange | null>;
	    readonly decimalRangeVal: Promise<decimalRange | null>;
	    readonly enumVal: Promise<TestEnum | null>;
	    readonly stringVal: Promise<string>;
	    readonly decimalVal: Promise<decimal>;
	    readonly floatVal: Promise<number>;
	    readonly doubleVal: Promise<number>;
	    readonly dateVal: Promise<date | null>;
	    readonly dateRangeVal: Promise<dateRange | null>;
	    readonly datetimeRangeVal: Promise<datetimeRange | null>;
	    readonly timeVal: Promise<Time | null>;
	    readonly datetimeVal: Promise<datetime | null>;
	    readonly binaryStream: Promise<BinaryStream | null>;
	    readonly textStream: Promise<TextStream>;
	    readonly mailTemplate: Promise<TextStream>;
	    readonly unsafeMailTemplate: Promise<TextStream>;
	    readonly uuidVal: Promise<Uuid>;
	    readonly computed: Promise<integer>;
	    readonly complexComputed: Promise<integer>;
	    readonly jsonVal: Promise<TestDatatypesJson>;
	    readonly integerArrayVal: Promise<integer[] | null>;
	    readonly enumArrayVal: Promise<TestEnumForArray[] | null>;
	    readonly stringArrayVal: Promise<string[] | null>;
	}
	//# sourceMappingURL=datatypes.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/data-type-events.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/data-type-events' {
	/// <reference types="@sage/xtrem-decimal" />
	import { BinaryStream, Node, StringDataType, ValidationContext, decimal, integer } from '@sage/xtrem-core/index';
	import * as fixtures from '@sage/xtrem-core/test/fixtures/index';
	interface HasAdaptableColumns {
	    adaptableLength: Promise<number>;
	    adaptableDefault: Promise<string>;
	}
	export class AdvancedStringDataType<T extends HasAdaptableColumns> extends StringDataType<T> {
	    defaultValue(node: T): Promise<string>;
	    controlValue(node: T, cx: ValidationContext, val: string): Promise<void>;
	}
	export class TestDataTypeEvents extends Node {
	    readonly id: Promise<integer>;
	    readonly enumVal: Promise<fixtures.enums.TestEnum | null>;
	    readonly stringVal: Promise<string>;
	    readonly adaptableLength: Promise<integer>;
	    readonly adaptableDefault: Promise<string>;
	    readonly stringValAdvancedControls: Promise<string>;
	    readonly stringValDefaultValue: Promise<string>;
	    readonly decimalVal: Promise<decimal>;
	    readonly binaryVal: Promise<BinaryStream | null>;
	    readonly binary1024Val: Promise<BinaryStream | null>;
	}
	export {};
	//# sourceMappingURL=data-type-events.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/create-update-stamp.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/create-update-stamp' {
	import { integer, Node } from '@sage/xtrem-core/index';
	export class TestCreateUpdateStamp extends Node {
	    readonly val: Promise<integer>;
	}
	//# sourceMappingURL=create-update-stamp.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/cached-encrypted-values.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/cached-encrypted-values' {
	import { integer, Node } from '@sage/xtrem-core/index';
	export class TestCachedEncryptedValues extends Node {
	    readonly id: Promise<integer>;
	    readonly passwordValue: Promise<string>;
	}
	//# sourceMappingURL=cached-encrypted-values.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/base.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/base' {
	import { Collection, Context, Node, Reference } from '@sage/xtrem-core/index';
	import { TestEnum } from '@sage/xtrem-core/test/fixtures/enums/index';
	export class TestBaseReference extends Node {
	    readonly code: Promise<string>;
	}
	export class TestBaseCollectionElement extends Node {
	    readonly code: Promise<string>;
	    readonly base: Reference<TestBase>;
	}
	export class TestBaseVitalChild extends Node {
	    readonly code: Promise<string>;
	}
	export class TestBase extends Node {
	    readonly code: Promise<string>;
	    readonly controlled: Promise<string>;
	    readonly dependsOn: Promise<string>;
	    readonly dependsOn2: Promise<string>;
	    readonly testBaseReference: Reference<TestBaseReference | null>;
	    readonly testBaseEnum: Promise<TestEnum | null>;
	    readonly testBaseCollection: Collection<TestBaseCollectionElement>;
	    static testCreate(context: Context, code: string): Promise<TestBase>;
	}
	//# sourceMappingURL=base.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/base-json.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/base-json' {
	import { Context, Node } from '@sage/xtrem-core/index';
	export class TestBaseJson extends Node {
	    readonly code: Promise<string>;
	    static testCreate(context: Context, code: string): Promise<TestBaseJson>;
	}
	//# sourceMappingURL=base-json.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/association-vital-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/association-vital-parent' {
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	import { TestAssociationItem } from '@sage/xtrem-core/test/fixtures/nodes/association-item';
	export class TestAssociationVitalParent extends Node {
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	    readonly associationItems: Collection<TestAssociationItem>;
	}
	//# sourceMappingURL=association-vital-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/association-nodes.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/association-nodes' {
	import { Collection, Node, Reference } from '@sage/xtrem-core/lib/index';
	export class TestStudent extends Node {
	    readonly name: Promise<string>;
	    readonly courses: Collection<TestStudentCourse>;
	}
	export class TestCourse extends Node {
	    readonly name: Promise<string>;
	    readonly students: Collection<TestStudentCourse>;
	}
	export class TestStudentCourse extends Node {
	    readonly student: Reference<TestStudent>;
	    readonly course: Reference<TestCourse>;
	    readonly someText: Promise<string>;
	}
	export class TestCampus extends Node {
	    readonly name: Promise<string>;
	    readonly studentCourses: Collection<TestStudentCourseCampus>;
	}
	export class TestStudentCourseCampus extends Node {
	    readonly student: Reference<TestStudent>;
	    readonly course: Reference<TestCourse>;
	    readonly campus: Reference<TestCampus>;
	    readonly someText: Promise<string>;
	}
	export class TestReference extends Node {
	    readonly name: Promise<string>;
	    readonly reference: Reference<TestReferenceCollection>;
	}
	export class TestCollection extends Node {
	    readonly name: Promise<string>;
	    readonly collection: Collection<TestReferenceCollection>;
	}
	export class TestReferenceCollection extends Node {
	    readonly reference: Reference<TestReference>;
	    readonly collection: Reference<TestCollection>;
	    readonly someText: Promise<string>;
	}
	//# sourceMappingURL=association-nodes.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/association-item.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/association-item' {
	import { Reference } from '@sage/xtrem-core/index';
	import { Node } from '@sage/xtrem-core/lib/index';
	import { TestAssociationAssociated } from '@sage/xtrem-core/test/fixtures/nodes/association-associated';
	import { TestAssociationVitalParent } from '@sage/xtrem-core/test/fixtures/nodes/association-vital-parent';
	export class TestAssociationItem extends Node {
	    readonly code: Promise<string>;
	    readonly parent: Reference<TestAssociationVitalParent>;
	    readonly associated: Reference<TestAssociationAssociated>;
	}
	//# sourceMappingURL=association-item.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/association-associated.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/association-associated' {
	import { Collection, Node } from '@sage/xtrem-core/lib/index';
	import { TestAssociationItem } from '@sage/xtrem-core/test/fixtures/nodes/association-item';
	export class TestAssociationAssociated extends Node {
	    readonly code: Promise<string>;
	    readonly text: Promise<string>;
	    readonly associationItems: Collection<TestAssociationItem>;
	}
	//# sourceMappingURL=association-associated.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/anonymous-data-type.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/anonymous-data-type' {
	import { Node } from '@sage/xtrem-core/index';
	export class TestAnonymousDataType extends Node {
	    readonly type: Promise<string>;
	}
	//# sourceMappingURL=anonymous-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/agg-document.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/agg-document' {
	/// <reference types="@sage/xtrem-decimal" />
	import { Collection, decimal, integer, Node, Reference } from '@sage/xtrem-core/index';
	import { TestAggDocumentExtendedLine } from '@sage/xtrem-core/test/fixtures/nodes/agg-document-extended-line';
	import { TestAggDocumentLine } from '@sage/xtrem-core/test/fixtures/nodes/agg-document-line';
	import { TestAggDocumentReverseRef } from '@sage/xtrem-core/test/fixtures/nodes/agg-document-reverse-ref';
	export class TestAggDocument extends Node {
	    readonly code: Promise<string>;
	    readonly totalAmount1: Promise<decimal>;
	    readonly totalAmount2: Promise<decimal>;
	    readonly totalAmount3: Promise<decimal>;
	    readonly totalAmount4: Promise<decimal>;
	    readonly totalAmount5: Promise<decimal>;
	    readonly linesCount: Promise<integer>;
	    readonly lines: Collection<TestAggDocumentLine>;
	    readonly extendedLines: Collection<TestAggDocumentExtendedLine>;
	    readonly documentReverseRef: Reference<TestAggDocumentReverseRef | null>;
	}
	//# sourceMappingURL=agg-document.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/agg-document-reverse-ref.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/agg-document-reverse-ref' {
	import { Node, Reference } from '@sage/xtrem-core/index';
	import { TestAggDocument } from '@sage/xtrem-core/test/fixtures/nodes/agg-document';
	export class TestAggDocumentReverseRef extends Node {
	    readonly document: Reference<TestAggDocument>;
	    readonly code: Promise<string>;
	}
	//# sourceMappingURL=agg-document-reverse-ref.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/agg-document-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/agg-document-line' {
	/// <reference types="@sage/xtrem-decimal" />
	import { date, decimal, integer, Node, Reference } from '@sage/xtrem-core/index';
	import { TestAggDocument } from '@sage/xtrem-core/test/fixtures/nodes/agg-document';
	export class TestAggDocumentLine extends Node {
	    readonly lineNumber: Promise<integer>;
	    readonly document: Reference<TestAggDocument>;
	    readonly quantity: Promise<integer>;
	    readonly amount1: Promise<decimal>;
	    readonly amount2: Promise<decimal>;
	    readonly amount3: Promise<decimal>;
	    readonly amount4: Promise<decimal>;
	    readonly amount5: Promise<decimal>;
	    readonly date: Promise<date>;
	}
	//# sourceMappingURL=agg-document-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/agg-document-extended-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/agg-document-extended-line' {
	/// <reference types="@sage/xtrem-decimal" />
	import { decimal, Reference } from '@sage/xtrem-core/index';
	import { TestAggDocument } from '@sage/xtrem-core/test/fixtures/nodes/agg-document';
	import { TestAggDocumentBaseLine } from '@sage/xtrem-core/test/fixtures/nodes/agg-document-base-line';
	export class TestAggDocumentExtendedLine extends TestAggDocumentBaseLine {
	    readonly document: Reference<TestAggDocument>;
	    readonly amount2: Promise<decimal>;
	}
	//# sourceMappingURL=agg-document-extended-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/agg-document-base-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/agg-document-base-line' {
	/// <reference types="@sage/xtrem-decimal" />
	import { date, decimal, integer, Node } from '@sage/xtrem-core/index';
	export class TestAggDocumentBaseLine extends Node {
	    readonly lineNumber: Promise<integer>;
	    readonly quantity: Promise<integer>;
	    readonly amount1: Promise<decimal>;
	    readonly date: Promise<date>;
	}
	//# sourceMappingURL=agg-document-base-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/nodes/adapt-values.d.ts
declare module '@sage/xtrem-core/test/fixtures/nodes/adapt-values' {
	import { integer, Node, StringDataType } from '@sage/xtrem-core/index';
	export class AdaptValuesStringDataType<T> extends StringDataType<T> {
	    adaptValue(_node: any, val: string): string;
	}
	export class TestAdaptValues extends Node {
	    readonly id: Promise<integer>;
	    readonly dataTypeAdaptValue: Promise<string>;
	    readonly propertyAdaptValue: Promise<string>;
	    readonly bothAdaptValue: Promise<string>;
	    readonly bothAdaptValue2: Promise<string>;
	    readonly extendedAdaptValue: Promise<string>;
	    readonly trimAdaptValue: Promise<string>;
	    readonly doNotTrimAdaptValue: Promise<string>;
	    readonly truncateAdaptValue: Promise<string>;
	}
	//# sourceMappingURL=adapt-values.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/index' {
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/adapt-values-extension';
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/base-extension-1';
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/base-extension-2';
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/base-json-extension-1';
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/base-json-extension-2';
	export * from '@sage/xtrem-core/test/fixtures/node-extensions/base-vital-child-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-vital-child-extension.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-vital-child-extension' {
	import { NodeExtension, Reference } from '@sage/xtrem-core/index';
	import { TestBaseVitalChild } from '@sage/xtrem-core/test/fixtures/nodes/base';
	import { TestVitalReferenceExtensionParent } from '@sage/xtrem-core/test/fixtures/nodes/vital-extension-reference-parent';
	export class TestBaseVitalChildExtension extends NodeExtension<TestBaseVitalChild> {
	    readonly parent: Reference<TestVitalReferenceExtensionParent>;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base' {
	    interface TestBaseVitalChild extends TestBaseVitalChildExtension {
	    }
	}
	//# sourceMappingURL=base-vital-child-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-json-extension-2.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-json-extension-2' {
	import { integer, NodeExtension } from '@sage/xtrem-core/index';
	import { TestBaseJson } from '@sage/xtrem-core/test/fixtures/nodes/base-json';
	export class TestBaseJsonExtension2 extends NodeExtension<TestBaseJson> {
	    readonly extensionCode2: Promise<string>;
	    extensionMethod2(this: TestBaseJson, param: integer): Promise<string>;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base-json' {
	    interface TestBaseJson extends TestBaseJsonExtension2 {
	    }
	}
	//# sourceMappingURL=base-json-extension-2.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-json-extension-1.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-json-extension-1' {
	import { Context, integer, NodeExtension } from '@sage/xtrem-core/index';
	import { TestBaseJson } from '@sage/xtrem-core/test/fixtures/nodes/base-json';
	export class BaseJsonExtension1 extends NodeExtension<TestBaseJson> {
	    readonly extensionCode1: Promise<string>;
	    static extensionOperation1(context: Context, param: integer): string;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base-json' {
	    interface TestBaseJson extends BaseJsonExtension1 {
	    }
	}
	//# sourceMappingURL=base-json-extension-1.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-extension-duplicate-mutation.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-extension-duplicate-mutation' {
	import { Context, NodeExtension } from '@sage/xtrem-core/index';
	import { TestBase } from '@sage/xtrem-core/test/fixtures/nodes/base';
	export class BaseExtensionDuplicateMutation extends NodeExtension<TestBase> {
	    static testCreate(context: Context, code: string): Promise<TestBase>;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base' {
	    interface TestBase extends BaseExtensionDuplicateMutation {
	    }
	}
	//# sourceMappingURL=base-extension-duplicate-mutation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-extension-2.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-extension-2' {
	import { Collection, integer, NodeExtension, Reference } from '@sage/xtrem-core/index';
	import { TestBase, TestBaseCollectionElement, TestBaseReference } from '@sage/xtrem-core/test/fixtures/nodes/base';
	export class TestBaseExtension2 extends NodeExtension<TestBase> {
	    readonly controlled: Promise<string>;
	    readonly dependsOn: Promise<string>;
	    readonly dependsOn2: Promise<string>;
	    readonly dependedUpon: Promise<string>;
	    readonly extensionCode2: Promise<string>;
	    readonly testBaseReference: Reference<TestBaseReference | null>;
	    readonly testBaseCollection: Collection<TestBaseCollectionElement>;
	    extensionMethod2(this: TestBase, param: integer): Promise<string>;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base' {
	    interface TestBase extends TestBaseExtension2 {
	    }
	}
	//# sourceMappingURL=base-extension-2.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/base-extension-1.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/base-extension-1' {
	import { Context, integer, NodeExtension, Reference } from '@sage/xtrem-core/index';
	import { TestBase } from '@sage/xtrem-core/test/fixtures/nodes/base';
	import { TestExtensionReference } from '@sage/xtrem-core/test/fixtures/nodes/test-extension-reference';
	export class BaseExtension1 extends NodeExtension<TestBase> {
	    readonly extensionCode1: Promise<string>;
	    readonly extensionReference1: Reference<TestExtensionReference>;
	    extensionMethod1(this: TestBase, param: integer): Promise<string>;
	    static extensionOperation1(_context: Context, param: integer): string;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/base' {
	    interface TestBase extends BaseExtension1 {
	    }
	}
	//# sourceMappingURL=base-extension-1.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/node-extensions/adapt-values-extension.d.ts
declare module '@sage/xtrem-core/test/fixtures/node-extensions/adapt-values-extension' {
	import { NodeExtension } from '@sage/xtrem-core/index';
	import { TestAdaptValues } from '@sage/xtrem-core/test/fixtures/nodes/adapt-values';
	export class TestAdaptValuesExtension extends NodeExtension<TestAdaptValues> {
	    readonly extendedAdaptValue: Promise<string>;
	}
	declare module '@sage/xtrem-core/test/fixtures/nodes/adapt-values' {
	    interface TestAdaptValues extends TestAdaptValuesExtension {
	    }
	}
	//# sourceMappingURL=adapt-values-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-enum.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-enum' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestEnumEnum {
	    value1 = 1,
	    value2 = 2,
	    value3 = 3
	}
	export interface TestEnumInterface {
	    value1: 1;
	    value2: 2;
	    value3: 3;
	}
	export type TestEnum = keyof TestEnumInterface;
	export const testEnumDataType: EnumDataType<keyof TestEnumInterface, unknown>;
	//# sourceMappingURL=test-enum.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-enum-nullable.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-enum-nullable' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestEnumNullableEnumEnum {
	    value1 = 1,
	    value2 = 2,
	    value3 = 3
	}
	export type TestEnumNullableEnum = keyof typeof TestEnumNullableEnumEnum;
	export const testEnumNullableDataType: EnumDataType<"value1" | "value3" | "value2", unknown>;
	//# sourceMappingURL=test-enum-nullable.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-enum-for-array.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-enum-for-array' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestEnumForArrayEnum {
	    arrayVal1 = 1,
	    arrayVal2 = 2,
	    arrayVal3 = 3
	}
	export type TestEnumForArray = keyof typeof TestEnumForArrayEnum;
	export const testEnumForArrayDataType: EnumDataType<"arrayVal1" | "arrayVal2" | "arrayVal3", unknown>;
	//# sourceMappingURL=test-enum-for-array.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-enum-extension.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-enum-extension' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestEnumExtensionEnum {
	    value4 = 4
	}
	export const testEnumExtensionDataType: EnumDataType<keyof import("./test-enum").TestEnumInterface, unknown>;
	//# sourceMappingURL=test-enum-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-animal-sleep-behavior.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-animal-sleep-behavior' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestAnimalSleepBehavior {
	    sleepOnTheGround = 1,
	    sleepInATree = 2,
	    sleepInTheAir = 3,
	    neverSleep = 4
	}
	export type TestAnimalSleepBehaviorEnum = keyof typeof TestAnimalSleepBehavior;
	export const testAnimalSleepBehaviorDataType: EnumDataType<"sleepOnTheGround" | "sleepInATree" | "sleepInTheAir" | "neverSleep", unknown>;
	//# sourceMappingURL=test-animal-sleep-behavior.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/test-animal-fly-behavior.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/test-animal-fly-behavior' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum TestAnimalFlyBehavior {
	    flyWithWings = 1,
	    cannotFly = 2
	}
	export type TestAnimalFlyBehaviorEnum = keyof typeof TestAnimalFlyBehavior;
	export const testAnimalFlyBehaviorDataType: EnumDataType<"flyWithWings" | "cannotFly", unknown>;
	//# sourceMappingURL=test-animal-fly-behavior.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/modified-test-enum.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/modified-test-enum' {
	import { EnumDataType } from '@sage/xtrem-core/lib/index';
	export enum ModifiedTestEnum {
	    value1 = 1,
	    value2Modified = 2,
	    value3 = 3
	}
	export type ModifiedTest = keyof typeof ModifiedTestEnum;
	export const modifiedTestEnumDataType: EnumDataType<"value1" | "value2Modified" | "value3", unknown>;
	//# sourceMappingURL=modified-test-enum.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enums/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/enums/index' {
	export * from '@sage/xtrem-core/test/fixtures/enums/modified-test-enum';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-animal-fly-behavior';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-animal-sleep-behavior';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-enum';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-enum-extension';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-enum-for-array';
	export * from '@sage/xtrem-core/test/fixtures/enums/test-enum-nullable';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enum-extensions/test-enum-extension.d.ts
declare module '@sage/xtrem-core/test/fixtures/enum-extensions/test-enum-extension' {
	export const _dummy = 1;
	declare module '@sage/xtrem-core/test/fixtures/enums/test-enum' {
	    interface TestEnumInterface {
	        value4: 4;
	    }
	}
	//# sourceMappingURL=test-enum-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/enum-extensions/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/enum-extensions/index' {
	export * from '@sage/xtrem-core/test/fixtures/enum-extensions/test-enum-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data-types/data-types.d.ts
declare module '@sage/xtrem-core/test/fixtures/data-types/data-types' {
	/// <reference types="@sage/xtrem-shared" />
	import { Node } from '@sage/xtrem-core/index';
	import { DecimalDataType, JsonDataType, StringArrayDataType, StringDataType } from '@sage/xtrem-core/lib/types/index';
	import { ReferenceDataType } from '@sage/xtrem-core/lib/types/reference-data-type';
	import { BinaryStreamDataType } from '@sage/xtrem-core/lib/types/stream-data-type';
	import { TestDocument } from '@sage/xtrem-core/test/fixtures/nodes/document';
	import { TestDocumentLine } from '@sage/xtrem-core/test/fixtures/nodes/document-line';
	import { TestNodeDetails } from '@sage/xtrem-core/test/fixtures/nodes/test-node-details';
	import { TestReferenceDataType } from '@sage/xtrem-core/test/fixtures/nodes/test-reference-data-type';
	export const codeDataType: StringDataType<unknown, string>;
	export const descriptionDataType: StringDataType<unknown, string>;
	export const descriptionArrayDataType: StringArrayDataType<unknown, string[]>;
	export const defaultDecimalDataType: DecimalDataType<unknown, number>;
	export const bundleIdDataType: StringDataType<unknown, string>;
	export const bundlePathType: StringDataType<unknown, string>;
	export const bundleVersionDataType: StringDataType<unknown, string>;
	export const notificationDataDataType: BinaryStreamDataType<import("../../../index").BinaryStream, unknown>;
	export const name: StringDataType<unknown, string>;
	export const email: StringDataType<unknown, string>;
	export const jsonDataType1: JsonDataType<unknown, import("@sage/xtrem-shared/lib/set-sort-values").AnyValue>;
	export const id: StringDataType<unknown, string>;
	export const decimalDataType: DecimalDataType<unknown, number>;
	export const localizedCodeDataType: StringDataType<unknown, string>;
	export const localizedDescriptionDataType: StringDataType<unknown, string>;
	export const urlDataType: StringDataType<unknown, string>;
	export interface LikeTestDataTypes extends Node {
	    readonly stringVal: Promise<string>;
	}
	export const testReferenceDataType: ReferenceDataType<TestReferenceDataType, LikeTestDataTypes>;
	export const testDocumentLineDataType: ReferenceDataType<TestDocumentLine, LikeTestDataTypes>;
	export const testDocumentDataType: ReferenceDataType<TestDocument, LikeTestDataTypes>;
	export const testNodeDetailsDataType: ReferenceDataType<TestNodeDetails, LikeTestDataTypes>;
	//# sourceMappingURL=data-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data-types/_index.d.ts
declare module '@sage/xtrem-core/test/fixtures/data-types/_index' {
	export * from '@sage/xtrem-core/test/fixtures/data-types/data-types';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/vital-reference-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/vital-reference-data' {
	export interface NonVitalReferenceData {
	    _id: number;
	    code: string;
	    text: string;
	}
	export const nonVitalReferenceData: NonVitalReferenceData[];
	//# sourceMappingURL=vital-reference-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/text-stream.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/text-stream' {
	export const htmlMailTemplate = "<!DOCTYPE html\n  PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\"\n  xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n  <title>Xtrem</title>\n  <!-- Brand_EmailTemplate_V5.7.2 -->\n\n  <!--<link rel=\"icon\" type=\"image/x-icon\" href=\"https://www.sage.com/favicon.ico\">\n  <link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"https://www.sage.com/favicon.ico\">-->\n\n  <!--[if gte mso 9]>\n  <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n  </xml>\n  <style>\n    li {\n      text-indent: -1em; /* Normalise space between bullets and text */\n    }\n  </style>\n  <![endif]-->\n\n  <!--[if (gte mso 9)|(IE)]>\n  <style type=\"text/css\">\n    table {\n      border-collapse: collapse;\n      border-spacing: 0;\n      mso-line-height-rule: exactly;\n      mso-margin-bottom-alt: 0;\n      mso-margin-top-alt: 0;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n    }\n  </style>\n  <![endif]-->\n\n  <!--[if gte mso 9]>\n  <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n  </xml>\n  <![endif]-->\n  <!--[if gt mso 15]>\n  <style type=\"text/css\" media=\"all\">\n    /* Outlook 2016 Height Fix */\n    table, tr, td {\n      border-collapse: collapse;\n    }\n\n    tr {\n      font-size: 0px;\n      line-height: 0px;\n      border-collapse: collapse;\n    }\n  </style>\n  <![endif]-->\n\n  <style type=\"text/css\">\n    /* Client-specific styles */\n    .ExternalClass {\n      width: 100%;\n    }\n\n    .ExternalClass,\n    .ExternalClass p,\n    .ExternalClass span,\n    .ExternalClass font,\n    .ExternalClass td,\n    .ExternalClass div {\n      line-height: 100%;\n    }\n\n    body {\n      background-image: none;\n      background-repeat: repeat;\n      background-position: top left;\n      background-attachment: scroll;\n      -ms-text-size-adjust: none;\n      -webkit-text-size-adjust: none;\n      -webkit-font-smoothing: antialiased;\n      margin-top: 0;\n      margin-bottom: 0;\n      margin-right: 0;\n      margin-left: 0;\n      padding-top: 0;\n      padding-bottom: 0;\n      padding-right: 0;\n      padding-left: 0;\n      color: rgb(0, 0, 0, .9);\n    }\n\n    a[href^=tel] {\n      color: #FFFFFF;\n      text-decoration: none;\n    }\n\n    img {\n      display: block;\n      border: none;\n      outline: none;\n      text-decoration: none;\n      -ms-interpolation-mode: bicubic;\n    }\n\n    table td,\n    table th {\n      border-collapse: collapse;\n    }\n\n    table {\n      border-collapse: collapse;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n      table-layout: fixed;\n    }\n\n    tr {\n      font-size: 0px;\n      line-height: 0px;\n      border-collapse: collapse;\n    }\n\n    table table {\n      table-layout: auto;\n    }\n\n    a {\n      color: #008200;\n    }\n\n    a:hover {\n      color: #009000 !important;\n    }\n\n    a img {\n      border: none;\n    }\n\n    @media print {\n      body {\n        -webkit-print-color-adjust: exact;\n      }\n    }\n\n    body,\n    table,\n    td,\n    a {\n      -webkit-text-size-adjust: 100%;\n      -ms-text-size-adjust: 100%;\n    }\n\n    img {\n      -ms-interpolation-mode: bicubic;\n    }\n\n    /* Reset styles */\n\n    img {\n      border: 0 !important;\n      line-height: 100%;\n      outline: none;\n      text-decoration: none;\n    }\n\n    table td {\n      border-collapse: collapse !important;\n    }\n\n    body {\n      height: 100% !important;\n      margin: 0 !important;\n      padding: 0 !important;\n      width: 100% !important;\n    }\n\n    /* iOS blue links */\n\n    a[x-apple-data-detectors] {\n      color: inherit !important;\n      text-decoration: none !important;\n      font-size: inherit !important;\n      font-family: inherit !important;\n      font-weight: inherit !important;\n      line-height: inherit !important;\n    }\n\n    .content-calendar {\n      padding: 15px 0 30px 4%;\n\n    }\n\n    /* Global styles */\n\n    body,\n    table,\n    td {\n      font-family: AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue;\n      font-size: 16px;\n      font-weight: 300;\n      line-height: 1.5;\n      color: #191919\n    }\n\n\n    /* Button style */\n\n    .sage-button {\n      background-color: #009000;\n      display: inline-block;\n      cursor: pointer;\n      color: #ffffff;\n      text-decoration: none;\n      width: 232px;\n    }\n\n    .sage-button a {\n      color: #ffffff;\n    }\n\n    .sage-button:hover {\n      background-color: #008000;\n\n    }\n\n    .sage-button a:hover {\n      color: #ffffff !important;\n\n    }\n\n    .sage-button-white {\n      background-color: #ffffff;\n      display: inline-block;\n      cursor: pointer;\n      color: #191919;\n      text-decoration: none;\n      width: 232px;\n    }\n\n    .sage-button-white a {\n\n      color: #191919;\n\n    }\n\n    .sage-button-white:hover {\n      background-color: #eeeeee;\n\n    }\n\n    .sage-button-white a:hover {\n\n      color: #191919 !important;\n\n    }\n\n    .sage-trans-button {\n      background-color: transparent;\n      display: inline-block;\n      cursor: pointer;\n      color: #008200;\n      text-decoration: none;\n      border-color: #008200;\n      border-style: solid;\n      border-width: 1px;\n      width: 232px;\n\n    }\n\n    .sage-trans-button a {\n      color: #008200;\n    }\n\n    .sage-button:active,\n    .sage-button-white:active {\n      position: relative;\n      top: 1px;\n    }\n\n    .SBC-icons {\n\n      /*height:170px;*/\n      height: 125px;\n      display: block !important;\n      padding: 0px !important;\n\n    }\n\n    a.SBC-icon-title:link {\n\n      text-align: center;\n      color: #004b87;\n      font-size: 20px;\n      font-weight: 300;\n\n    }\n\n    .SBC-icon-title {\n\n      text-align: center;\n      color: #004b87;\n      font-size: 20px;\n      font-weight: 300;\n\n    }\n\n    /* Media query: scale from 600px to 480px break point */\n\n    @media screen and (max-width: 600px) {\n      h1 {\n        font-size: 32px;\n        font-family: 'AdelleSansSAGE-Bold', Arial, Roboto, Segoe UI, Helvetica Neue;\n        line-height: 1.25 !important;\n\n      }\n\n      h2 {\n        font-size: 24px;\n        font-family: 'AdelleSansSAGE-Bold', Arial, Roboto, Segoe UI, Helvetica Neue;\n        line-height: 1.25 !important;\n      }\n\n      h3 {\n        font-size: 16px;\n        font-family: 'AdelleSansSAGE-Bold', Arial, Roboto, Segoe UI, Helvetica Neue;\n      }\n\n      .img-max {\n        width: 100% !important;\n        max-width: 100% !important;\n        height: auto !important;\n        min-width: 100px !important;\n      }\n\n      .img-max-center {\n        width: 100% !important;\n        max-width: 100% !important;\n        height: auto !important;\n        min-width: 100px !important;\n        text-align: center !important;\n        float: none !important;\n        margin: 0 auto !important;\n        padding: 0 !important;\n      }\n\n      .img-max-pad-top {\n        width: 100% !important;\n        max-width: 100% !important;\n        height: auto !important;\n        min-width: 100px !important;\n        padding-top: 10px !important;\n      }\n\n      .container {\n        width: 100% !important;\n        max-width: 600px !important;\n        height: auto !important;\n        min-width: 0 !important;\n      }\n\n      .img-pad-top {\n        padding-top: 10px;\n      }\n\n      .pad-bottom {\n        padding-bottom: 20px;\n      }\n\n      .pad-bottom-center {\n        padding-bottom: 20px;\n        margin-left: auto !important;\n        margin-right: auto !important;\n      }\n\n      .extra-marg-bottom {\n        margin-bottom: 30px !important;\n      }\n\n      .no-pad-bottom {\n        padding-bottom: 0px !important;\n\n      }\n\n      .no-pad-bottom-center {\n        padding-bottom: 0px !important;\n        margin-left: auto !important;\n        margin-right: auto !important;\n        float: none !important;\n      }\n\n      .text-center-right {\n        text-align: center !important;\n        padding-right: 20px !important;\n        padding-left: 0px !important;\n      }\n\n      .text-center-right-pad {\n        text-align: center !important;\n        padding-left: 0px !important;\n      }\n\n      .center-table {\n        text-align: center !important;\n      }\n\n      .text-center {\n        text-align: center !important;\n      }\n\n      .text-center-75 {\n        text-align: center !important;\n        max-width: 75% !important;\n      }\n\n      .ul-style {\n        padding-left: 20px !important;\n      }\n\n      .max-width {\n        max-width: 100% !important;\n        width: 100% !important;\n\n      }\n\n      .max-width-remove-height {\n        max-width: 100% !important;\n        width: 100% !important;\n        ;\n        height: auto !important;\n      }\n\n      .max-width-center {\n        max-width: 100% !important;\n        width: 100% !important;\n\n        text-align: center !important;\n        margin: 0 !important;\n        padding: 0 !important;\n      }\n\n      .max-width-pad {\n        max-width: 100% !important;\n        width: 100% !important;\n        margin-bottom: 12px !important;\n      }\n\n      .max-width-top-pad {\n        max-width: 100% !important;\n        width: 100% !important;\n\n        margin-top: 20px !important;\n      }\n\n\n      .max-width-no-pad {\n        max-width: 100% !important;\n        width: 100% !important;\n\n      }\n\n      .max-width-no-pad-l {\n        max-width: 100% !important;\n        width: 100% !important;\n        padding-left: 0 !important;\n      }\n\n      .max-width-no-pad-a {\n        max-width: 100% !important;\n        width: 100% !important;\n        padding-left: 0 !important;\n        padding-right: 0 !important;\n        padding-bottom: 0 !important;\n        padding-top: 0 !important;\n      }\n\n      .max-width-center-pad {\n        max-width: 100% !important;\n        width: 100% !important;\n\n        text-align: center !important;\n        margin: 0 auto !important;\n        margin-bottom: 30px !important;\n      }\n\n      .mobile-wrapper {\n        width: 90% !important;\n        max-width: 90% !important;\n      }\n\n      .mobile-padding {\n        padding-left: 5% !important;\n        padding-right: 5% !important;\n      }\n\n      .fix-margin {\n        margin-top: 0px;\n        padding-top: 0px;\n      }\n\n      .mobile-center {\n        text-align: center !important;\n        padding-bottom: 5px !important;\n      }\n\n      .mobile-stacked {\n        padding-top: 12px !important;\n        padding-bottom: 12px !important;\n      }\n\n\n      .remove-height {\n        height: auto !important;\n      }\n\n      .remove-pad {\n        padding: 0px !important;\n      }\n\n      .content {\n        padding-left: 25px !important;\n        padding-right: 25px !important;\n      }\n\n      .sage_logo {\n        width: auto !important;\n        height: 32px !important;\n      }\n\n\n      .desktop-masthead {\n        width: 100% !important;\n        height: auto !important;\n      }\n\n      .img-center {\n        margin-left: auto !important;\n        margin-right: auto !important;\n      }\n\n      .two-col-icons {\n        width: 50% !important;\n        height: 50% !important;\n        display: block;\n      }\n\n      .quote-signature {\n        padding-left: 10px !important;\n      }\n\n      .SBC-icons {\n        width: 138px !important;\n        height: auto !important;\n      }\n\n      .content-SBC-icons {\n        padding-left: 40px !important;\n        padding-right: 40px !important;\n      }\n\n      .content-calendar {\n        padding: 15px 0 30px 14%;\n      }\n\n\n      /* Media query for mobile viewport\n       * Developer:  hero graphics should be 2 x width for HD rendering.\n       */\n      @media only screen and (max-width: 480px) {\n\n        h1 {\n\n          font-size: 24px !important;\n          font-weight: bold;\n        }\n\n        h2 {\n          font-size: 20px !important;\n          font-weight: bold;\n        }\n\n        h3 {\n          font-size: 16px;\n          font-weight: bold;\n        }\n\n        table[class=max-width-pad] {\n          max-width: 100% !important;\n          width: 100% !important;\n          padding-top: 15px !important;\n          height: auto !important;\n        }\n\n        table[class=max-width] {\n          max-width: 100% !important;\n          width: 100% !important;\n          height: auto !important;\n        }\n\n        table[class=container] {\n          margin: 0 auto !important;\n        }\n\n        .desktop-masthead {\n          display: none !important;\n        }\n\n        *[class].hidden. *[class=desktop-masthead] {\n          display: none !important;\n        }\n\n        *[class].elastic {\n          width: 100% !important;\n          height: auto !important;\n        }\n\n        *[class].centered {\n          text-align: center !important;\n        }\n\n        *[class].fluid,\n        [class=fluid-mob] {\n          width: 100% !important;\n        }\n\n        [class=fluid-mob] {\n          position: relative;\n        }\n\n        .mobile-show {\n          display: table-cell !important;\n          width: auto !important;\n          height: auto !important;\n          max-height: none !important;\n          overflow: visible !important;\n          visibility: visible !important;\n          position: relative !important;\n          text-align: center !important;\n        }\n\n        .show-mob {\n          display: block !important;\n          max-height: none !important;\n          width: auto !important;\n          visibility: visible !important;\n        }\n\n        *[class].mob-masthead {\n          width: 100% !important;\n          display: block !important;\n          height: auto !important;\n          max-height: none !important;\n          padding: 0 !important;\n        }\n\n        *[class].mob-masthead-img {\n          position: absolute !important;\n          top: 0px !important;\n          display: block !important;\n          height: auto !important;\n          max-height: none !important;\n          padding: 0 !important;\n          width: auto !important;\n        }\n\n        [class=fluid-mob] {\n          display: table-cell !important;\n          width: auto !important;\n          height: auto !important;\n          max-height: none !important;\n          overflow: visible !important;\n          visibility: visible !important;\n          position: relative !important;\n          text-align: center !important;\n        }\n\n        .SBC-icons {\n          margin: 2px;\n          height: auto !important;\n        }\n\n        .content-quote {\n          margin-top: 20px\n        }\n\n        .quote-signature {\n          padding-left: 0px !important;\n        }\n\n      }\n\n      @media only screen and (max-width: 410px) {\n        .SBC-icons {\n\n          height: auto !important;\n          clear: none;\n\n        }\n\n        .content-SBC-icons {\n          padding-left: 35px !important;\n          padding-right: 15px !important;\n          margin: 4px;\n\n        }\n\n        .content-calendar {\n          padding: 15px 7% 30px;\n        }\n      }\n  </style>\n</head>\n\n<body bgcolor=\"#dddddb\"\n  style=\"margin: 0 auto !important; padding: 0 !important; background-color: #F2F5F6; font-family: AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue; color: #191919; font-size: 16px\">\n\n  <table class=\"ab_section\" data-description=\"Body\" border=\"0\" bgcolor=\"#F2F5F6\" cellpadding=\"0\" cellspacing=\"0\"\n    width=\"100%\"\n    style=\"padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt; background-color: #F2F5F6\">\n    <tr>\n      <td align=\"center\" style=\"text-align: center\">\n        <table bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" width=\"600\"\n          style=\"display: table; width: 600px; background-color: #ffffff; margin: 0 auto !important; padding: 0px; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse:collapse; border-style: solid; border-width: 1px; border-color: #cccccc\"\n          class=\"container\">\n          <!-- Start: A1 Top logo -->\n          <!-- Instructions: After changing the logo image and adjusting the \"height\" and both \"width\" values below, review the .sage_logo class in the media query CSS -->\n          <!-- <tr class=\"ab_cloneable\" data-description=\"A1 Top Logo\"> -->\n          <!-- <td align=\"center\" valign=\"top\" style=\"background-color:#FFFFFF; padding: 17px 30px 17px 30px\"> -->\n          <!-- <table cellspacing=\"0\" border=\"0\" align=\"center\" -->\n          <!-- style=\"\" padding: 0; margin: 0; padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0\"> -->\n          <!-- <tr> -->\n          <!-- <td align=\"center\" valign=\"top\"><a class=\"ab_editable\" href=\"http://sage.com\" -->\n          <!-- data-description=\"Sage Logo Link\"> -->\n          <!-- <img -->\n          <!-- src=\"cid:logo-sage.png\" -->\n          <!-- class=\"ab_editable sage_logo\" data-description=\"Sage Logo Image\" width=\"80\" -->\n          <!-- border=\"0\" alt=\"Sage\" -->\n          <!-- style=\"width: 100%; max-width: 80px; margin-left: auto !important; margin-right: auto !important\"> -->\n          <!-- </a> -->\n          <!-- </td> -->\n          <!-- </tr> -->\n          <!-- </table> -->\n          <!-- </td> -->\n          <!-- </tr> -->\n          <!-- End: A1 Top logo -->\n\n          <!-- Start: B1 Hero banner image 1 1200px (2 x 600px for HD); breakpoint at 480px -->\n          <tr>\n            <td align=\"center\" valign=\"top\" class=\"ab_cloneable\" data-description=\"B1 Hero banner image 1\"\n              style=\"margin:0;padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt\">\n              <!-- B1 Mobile email header -->\n              <!--[if !mso]><!-->\n              <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"fluid\"\n                style=\"display:table; padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt\">\n                <tbody>\n                  <tr>\n                    <td\n                      style=\"margin:0;padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt\">\n                      <div class=\"show-mob\"\n                        style=\"font-size: 0; max-height: 0; overflow: hidden; display: none; line-height:0; visibility:hidden;\">\n                        <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n                          <tr>\n                            <th width=\"600\" align=\"center\" valign=\"top\" bgcolor=\"#51534a\"\n                              class=\"fluid\"\n                              style=\"width: 600px; padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt;\">\n                              <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"\n                                border=\"0\" bgcolor=\"#51534A\" class=\"fluid-mob\"\n                                style=\"mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt; font-size: 0; max-height: 0; overflow: hidden; display: none; line-height:0; visibility:hidden;\">\n                                <tr>\n                                  <td align=\"left\" bgcolor=\"#51534A\"\n                                    class=\"mobile-show\"\n                                    style=\"font-size: 0; max-height: 0; overflow: hidden; display: none; line-height:0; visibility:hidden;\">\n                                    <table width=\"100%\" border=\"0\" cellpadding=\"0\"\n                                      cellspacing=\"0\">\n                                      <tr>\n                                        <td align=\"center\"\n                                          style=\"background-color: #ffffff\"\n                                          class=\"mobile-show\">\n                                          <a class=\"ab_editable\"\n                                            href=\"http://place-holder.com\">\n                                            <h1\n                                              style=\"margin-top:20px; margin-left:10px;\">\n                                              Request for {{approvalType}}\n                                              approval</h1>\n                                          </a>\n                                        </td>\n                                      </tr>\n                                    </table>\n                                  </td>\n                                </tr>\n                              </table>\n                            </th>\n                          </tr>\n                        </table>\n                      </div>\n                    </td>\n                  </tr>\n                </tbody>\n              </table>\n              <!--<![endif]-->\n              <!-- End B1 Mobile email header -->\n\n              <!-- Desktop B1 email header -->\n              <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"fluid\"\n                style=\"margin: 0;padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt; background-color:#f2f5f6;\">\n                <tr>\n                  <td align=\"center\"\n                    style=\"margin: 0;padding-top:0;padding-right:0px;padding-bottom:0px;padding-left:0px; mso-cellspacing: 0px; mso-padding-alt: 0px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt;background-color:#ffffff;\">\n                    <h1 style=\"margin-top:20px; margin-left:10px;\">Request for {{approvalType}}\n                      approval</h1>\n                  </td>\n                </tr>\n                <tr>\n                  <td align=\"center\"\n                    style=\"margin: 0; mso-cellspacing: 0px; mso-padding-alt: 20px 0px 0px 0px; border-collapse:collapse; mso-table-lspace:0pt;mso-table-rspace:0pt\">\n                  </td>\n                </tr>\n              </table>\n            </td>\n          </tr>\n\n          <!-- Start: C1 Single column copy -->\n          <tr class=\"ab_cloneable\" data-description=\"C1 Single column copy\">\n            <td align=\"center\" valign=\"top\"\n              style=\"background-color: #f2f5f6; padding: 32px 32px 32px 32px; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse:collapse\"\n              class=\"content\">\n              <table align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"\n                style=\"mso-cellspacing: 0px; mso-padding-alt: 0px; border-collapse:collapse\">\n                <tr>\n                  <td valign=\"top\" align=\"left\"\n                    style=\"font-family:AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue; font-weight: 300; color: #191919; font-size: 16px; line-height: 1.5\">\n                    <span class=\"ab_editable\" data-rawhtml=\"true\">\n                      Hello,\n                      <br />\n                      <br />\n                      You have a pending {{approvalType}} approval for : <h3\n                        style=\"font-size: 16px; font-weight: bold; margin: 12px 0; line-height: 1.25\"\n                        class=\"ab_editable\">Formula {{code}} version {{version}} -\n                        {{description}} </h3>\n                      <br />\n                      You can find details on this formula by following this link :\n                      <a href=\"{{urlFormula}}\" target=\"_blank\"\n                        style=\"font-size: 16px; font-family:AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue; display: inline-block; font-weight: bold;  text-decoration: underline; color:#008200;\"\n                        class=\"red ab_editable\"><span class=\"ab_editable\"\n                          data-rawhtml=\"true\">Click here</span></a>\n                      <br />\n                      <br />\n                      Please use the following buttons to approve or reject the formula.\n                    </span>\n                    <br><br>\n                  </td>\n                </tr>\n                <tr>\n                  <td align=\"center\" valign=\"top\" class=\"max-width\" width=\"100%\"\n                    style=\"font-size:0;  padding-bottom: 30px; mso-padding-alt: 20px 0px 30px 0px;\">\n                    <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"260\"\n                      style=\"width: 260px; text-align: center\" class=\"max-width\">\n                      <tr>\n                        <td align=\"center\">\n                          <table width=\"296\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"\n                            style=\"mso-cellspacing: 0px; mso-padding-alt: 0px; width: 296px; height: 36px; text-align: center; -webkit-text-size-adjust:none\"\n                            class=\"no-pad-bottom-center\">\n                            <tr>\n                              <td bgcolor=\"#009900\" style=\"width: 300px;\" align=\"center\">\n                                <a class=\"ab_editable\" href=\"{{urlApprove}}\"\n                                  target=\"_blank\"\n                                  style=\"font-size: 16px; font-family:AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue; font-weight: bold !important; color: #ffffff; text-decoration: none; display: inline-block\">\n                                  Approve</a></td>\n                              <td style=\"width: 232px;\"></td>\n                              <td bgcolor=\"#99001c\" style=\"width: 350px;\" align=\"center\">\n                                <a class=\"ab_editable\" href=\"{{urlReject}}\"\n                                  target=\"_blank\"\n                                  style=\"font-size: 16px; font-family:AdelleSansSAGE, Arial, Roboto, Segoe UI, Helvetica Neue; font-weight: bold !important; color: #ffffff; text-decoration: none; display: inline-block\">\n                                  Reject</a></td>\n                            </tr>\n                          </table>\n                        </td>\n                      </tr>\n                    </table>\n                  </td>\n                </tr>\n              </table>\n            </td>\n          </tr>\n          <!-- End: C1 Single column copy -->\n\n        </table>\n        <br><br>\n      </td>\n    </tr>\n  </table>\n</body>\n\n</html>\n";
	export const reportTemplates: string[];
	//# sourceMappingURL=text-stream.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/secure-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/secure-data' {
	import { NodeCreateData } from '@sage/xtrem-core/lib/ts-api/create-data';
	import { TestSecure, TestSite } from '@sage/xtrem-core/test/fixtures/nodes/index';
	export type SecureData = NodeCreateData<TestSecure>;
	export type SiteData = NodeCreateData<TestSite>;
	export const siteData: SiteData[];
	export const secureData: SecureData[];
	//# sourceMappingURL=secure-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/required-property-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/required-property-data' {
	import { TestRequiredProperty } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { TestInitData } from '@sage/xtrem-core/test/fixtures/util';
	export type RequiredPropertyData = Pick<TestInitData<TestRequiredProperty>, Exclude<keyof TestRequiredProperty, 'computed' | '$' | 'state' | 'requiredReference' | 'requiredReferenceArray' | '_sourceId' | '_customData' | '_sortValue'>> & {
	    requiredReference: number;
	    requiredReferenceArray: number[];
	};
	export const requiredPropertyData: RequiredPropertyData[];
	//# sourceMappingURL=required-property-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/reference-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/reference-data' {
	import { NodeCreateData } from '@sage/xtrem-core/lib/index';
	import { TestReferred, TestReferring, TestReferringWithJoin } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { TestInitData } from '@sage/xtrem-core/test/fixtures/util';
	export type ReferredData = TestInitData<TestReferred>;
	export type ReferringData = TestInitData<TestReferring>;
	export type ReferringWithJoinData = TestInitData<TestReferringWithJoin>;
	export const referringData: ReferringData[];
	export const referredData: NodeCreateData<TestReferred>[];
	export const referringWithJoinData: ReferringWithJoinData[];
	//# sourceMappingURL=reference-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/reference-data-type-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/reference-data-type-data' {
	import { TestChildReferenceDataType, TestGrandChildReferenceDataType, TestReferenceDataType } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { TestInitData } from '@sage/xtrem-core/test/fixtures/util';
	export type GrandChildRefData = TestInitData<TestGrandChildReferenceDataType>;
	export type ChildRefData = TestInitData<TestChildReferenceDataType>;
	export type ParentRefData = TestInitData<TestReferenceDataType>;
	export const grandChildRefData: GrandChildRefData[];
	export const childRefData: ChildRefData[];
	export const parentRefData: ParentRefData[];
	//# sourceMappingURL=reference-data-type-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/nested-collections.data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/nested-collections.data' {
	export const grandParentData: {
	    _id: number;
	    text: string;
	}[];
	export const parentData: {
	    _id: number;
	    parent: number;
	    intVal: number;
	    text: string;
	}[];
	export const childData: {
	    _id: number;
	    parent: number;
	    intVal: number;
	    intVal2: number;
	    text: string;
	}[];
	//# sourceMappingURL=nested-collections.data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/input-output-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/input-output-data' {
	import { TestIoProperties } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { TestInitData } from '@sage/xtrem-core/test/fixtures/util';
	export type IoData = Pick<TestInitData<TestIoProperties>, Exclude<keyof TestIoProperties, 'computed' | '$' | 'state' | '_sourceId' | '_customData' | '_sortValue'>>;
	export const testIoData: IoData[];
	//# sourceMappingURL=input-output-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/index' {
	export * from '@sage/xtrem-core/test/fixtures/data/aggregation-data';
	export * from '@sage/xtrem-core/test/fixtures/data/arrays-data';
	export * from '@sage/xtrem-core/test/fixtures/data/collection-data';
	export * from '@sage/xtrem-core/test/fixtures/data/data-type-events-data';
	export * from '@sage/xtrem-core/test/fixtures/data/datatypes-data';
	export * from '@sage/xtrem-core/test/fixtures/data/group-by-data';
	export * from '@sage/xtrem-core/test/fixtures/data/input-output-data';
	export * from '@sage/xtrem-core/test/fixtures/data/nested-collections.data';
	export * from '@sage/xtrem-core/test/fixtures/data/reference-data';
	export * from '@sage/xtrem-core/test/fixtures/data/reference-data-type-data';
	export * from '@sage/xtrem-core/test/fixtures/data/required-property-data';
	export * from '@sage/xtrem-core/test/fixtures/data/secure-data';
	export * from '@sage/xtrem-core/test/fixtures/data/vital-reference-data';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/group-by-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/group-by-data' {
	export const itemData: {
	    _id: number;
	    code: string;
	}[];
	export const stockData: ({
	    _id: number;
	    stockSite: string;
	    location: string;
	    product: number;
	    quantityInStockUnit: number;
	    sublot?: undefined;
	} | {
	    _id: number;
	    stockSite: string;
	    location: string;
	    product: number;
	    sublot: number;
	    quantityInStockUnit: number;
	})[];
	//# sourceMappingURL=group-by-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/datatypes-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/datatypes-data' {
	import { DateRange, Datetime, DatetimeRange, DateValue, DecimalRange, IntegerRange, Time } from '@sage/xtrem-date-time';
	import { integer } from '@sage/xtrem-shared';
	import { BinaryStream, TextStream, Uuid } from '@sage/xtrem-core/index';
	import { TestEnum, TestEnumForArray } from '@sage/xtrem-core/test/fixtures/enums/index';
	export interface DatatypesData {
	    _id: integer;
	    _sourceId: string;
	    booleanVal: boolean | null;
	    id: integer;
	    shortVal: integer | null;
	    integerVal: integer;
	    integerRangeVal: IntegerRange | null;
	    decimalRangeVal: DecimalRange | null;
	    decimalVal: number;
	    floatVal: number;
	    doubleVal: number;
	    stringVal: string;
	    stringArrayVal: string[];
	    datetimeVal: Datetime | null;
	    dateVal: DateValue | null;
	    dateRangeVal: DateRange | null;
	    datetimeRangeVal: DatetimeRange | null;
	    timeVal: Time | null;
	    enumVal: TestEnum | null;
	    textStream: TextStream;
	    mailTemplate: TextStream;
	    unsafeMailTemplate: TextStream;
	    binaryStream: BinaryStream | null;
	    uuidVal: Uuid;
	    jsonVal: object;
	    enumArrayVal: TestEnumForArray[];
	    integerArrayVal: integer[];
	}
	export const datatypesData: DatatypesData[];
	export const allIds: number[];
	export const allIdsExcept: (...ids: number[]) => number[];
	//# sourceMappingURL=datatypes-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/data-type-events-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/data-type-events-data' {
	import { TestDataTypeEvents } from '@sage/xtrem-core/test/fixtures/nodes/index';
	import { TestInitData } from '@sage/xtrem-core/test/fixtures/util';
	export type DataTypesEventsData = TestInitData<TestDataTypeEvents>;
	export const dataTypeEventsData: DataTypesEventsData[];
	export function makeNewRecord(id: number): DataTypesEventsData;
	//# sourceMappingURL=data-type-events-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/collection-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/collection-data' {
	export const documentData: {
	    _id: number;
	    code: string;
	    description: string;
	    mandatoryReference: number;
	}[];
	export const documentLineData: ({
	    _id: number;
	    _sortValue: number;
	    document: number;
	    lineNumber: number;
	    description: string;
	    optionalReference?: undefined;
	} | {
	    _id: number;
	    _sortValue: number;
	    document: number;
	    lineNumber: number;
	    description: string;
	    optionalReference: number;
	})[];
	//# sourceMappingURL=collection-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/binary-stream.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/binary-stream' {
	/// <reference types="node" />
	/// <reference types="node" />
	export const binaryStreamBuffer: Buffer;
	//# sourceMappingURL=binary-stream.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/association-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/association-data' {
	export interface TestStudentData {
	    _id: number;
	    name: string;
	}
	export const testStudentData: TestStudentData[];
	export interface TestCourseData {
	    _id: number;
	    name: string;
	}
	export const testCourseData: TestCourseData[];
	export interface TestCampusData {
	    _id: number;
	    name: string;
	}
	export const testCampusData: TestCampusData[];
	export interface AssociationVitalParentData {
	    _id: number;
	    code: string;
	    text: string;
	}
	export const associationVitalParentData: AssociationVitalParentData[];
	export interface AssociationAssociatedData {
	    _id: number;
	    code: string;
	    text: string;
	}
	export const associationAssociatedData: AssociationAssociatedData[];
	export interface TestReferenceData {
	    _id: number;
	    name: string;
	}
	export const testReferenceData: TestReferenceData[];
	export interface TestCollectionData {
	    _id: number;
	    name: string;
	}
	export const testCollectionData: TestCollectionData[];
	//# sourceMappingURL=association-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/arrays-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/arrays-data' {
	import { Decimal } from '@sage/xtrem-decimal';
	import { date, datetime, Uuid } from '@sage/xtrem-core/index';
	export const arraysData: {
	    id: number;
	    booleanValues: (boolean | null)[];
	    integerValues: number[];
	    decimalValues: Decimal[];
	    floatValues: number[];
	    doubleValues: number[];
	    stringValues: string[];
	    datetimeValues: (datetime | null)[];
	    dateValues: (date | null)[];
	    enumValues: (string | null)[];
	    uuidValues: (Uuid | null)[];
	}[];
	//# sourceMappingURL=arrays-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/data/aggregation-data.d.ts
declare module '@sage/xtrem-core/test/fixtures/data/aggregation-data' {
	import { Dict } from '@sage/xtrem-shared';
	export const aggDocumentData: Dict<any>[];
	export const aggDocumentReverseRefData: Dict<any>[];
	export const aggDocumentLineData: Dict<any>[];
	export const aggDocumentExtendedLineData: Dict<any>[];
	//# sourceMappingURL=aggregation-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/vital-reference-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/vital-reference-parent' {
	import { ClientNode, CreateOperation, QueryOperation, ReadOperation, UpdateByIdOperation, UpdateOperation } from '@sage/xtrem-client';
	import { ClientVitalReferenceChildMandatory, ClientVitalReferenceChildMandatoryInput, ClientVitalReferenceChildOptional, ClientVitalReferenceChildOptionalInput } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-reference-child';
	export interface ClientVitalReferenceParent extends ClientNode {
	    code: string;
	    mandatoryVitalRef: ClientVitalReferenceChildMandatory;
	    optionalVitalRef: ClientVitalReferenceChildOptional | null;
	}
	export interface ClientVitalReferenceParentInput {
	    _id?: string;
	    code?: string;
	    mandatoryVitalRef?: ClientVitalReferenceChildMandatoryInput;
	    optionalVitalRef?: ClientVitalReferenceChildOptionalInput | null;
	}
	export interface ClientVitalReferenceParent$Operations {
	    query: QueryOperation<ClientVitalReferenceParent>;
	    read: ReadOperation<ClientVitalReferenceParent>;
	    create: CreateOperation<ClientVitalReferenceParentInput, ClientVitalReferenceParent>;
	    update: UpdateOperation<ClientVitalReferenceParentInput, ClientVitalReferenceParent>;
	    updateById: UpdateByIdOperation<ClientVitalReferenceParentInput, ClientVitalReferenceParent>;
	}
	//# sourceMappingURL=vital-reference-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/vital-reference-child.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/vital-reference-child' {
	import { ClientNode, VitalClientNode, VitalClientNodeInput } from '@sage/xtrem-client';
	import { ClientVitalReferenceParent } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-reference-parent';
	export interface ClientVitalReferenceChildMandatory extends VitalClientNode {
	    parent: ClientVitalReferenceParent;
	    code: string;
	    text: string;
	}
	export interface ClientVitalReferenceChildMandatoryInput extends VitalClientNodeInput {
	    code?: string;
	    text?: string;
	}
	export interface ClientNonVitalReference extends ClientNode {
	    code: string;
	    text: string;
	}
	export interface ClientVitalReferenceChildOptional extends VitalClientNode {
	    parent: ClientVitalReferenceParent;
	    code: string;
	    text: string;
	    nonVitalRef: ClientNonVitalReference;
	}
	export interface ClientVitalReferenceChildOptionalInput extends VitalClientNodeInput {
	    code?: string;
	    text?: string;
	    nonVitalRef?: number | string;
	}
	//# sourceMappingURL=vital-reference-child.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/vital-collection-parent.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/vital-collection-parent' {
	import { ClientCollection, ClientNode, CreateOperation, QueryOperation, ReadOperation, UpdateByIdOperation } from '@sage/xtrem-client';
	import { ClientVitalCollectionChild, ClientVitalCollectionChildInput } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-collection-child';
	export interface ClientVitalCollectionParent extends ClientNode {
	    code: string;
	    children: ClientCollection<ClientVitalCollectionChild>;
	}
	export interface ClientVitalCollectionParentInput {
	    _id?: string;
	    code?: string;
	    children?: Partial<ClientVitalCollectionChildInput>[];
	}
	export interface ClientVitalCollectionParent$Operations {
	    query: QueryOperation<ClientVitalCollectionParent>;
	    read: ReadOperation<ClientVitalCollectionParent>;
	    create: CreateOperation<ClientVitalCollectionParentInput, ClientVitalCollectionParent>;
	    update: UpdateByIdOperation<ClientVitalCollectionParentInput, ClientVitalCollectionParent>;
	}
	//# sourceMappingURL=vital-collection-parent.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/vital-collection-child.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/vital-collection-child' {
	import { VitalClientNode, VitalClientNodeInput } from '@sage/xtrem-client';
	import { ClientVitalCollectionParent } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-collection-parent';
	export interface ClientVitalCollectionChild extends VitalClientNode {
	    code: string;
	    parent: ClientVitalCollectionParent;
	}
	export interface ClientVitalCollectionChildInput extends VitalClientNodeInput {
	    code?: string;
	}
	//# sourceMappingURL=vital-collection-child.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/transient.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/transient' {
	import { ClientNode, CreateOperation, DeleteOperation, integer, Query, QueryOperation, ReadOperation, UpdateByIdOperation } from '@sage/xtrem-client';
	export interface TestTransient extends ClientNode {
	    stringValue: string;
	    derivedValue: string;
	    derivedFromRef: string;
	    derivedFromCollection: integer;
	    derivedCollection: Query<TestTransientLines>[];
	}
	export interface TestTransientKey {
	}
	export interface TestTransientInput extends TestTransientKey {
	    stringValue: string;
	    transientValue?: string;
	    derivedValue?: string;
	    derivedFromRef?: string;
	    derivedFromCollection?: integer;
	    derivedCollection?: Partial<TransientLinesInput>[];
	    transientRef?: integer | string;
	    transientLines?: Partial<TransientLinesInput>[];
	}
	export interface TestTransientIdInput extends TestTransientInput {
	    _id: string;
	}
	export interface TestTransient$Operations {
	    query: QueryOperation<TestTransient>;
	    read: ReadOperation<TestTransient>;
	    create: CreateOperation<TestTransientInput, TestTransient>;
	    updateById: UpdateByIdOperation<TestTransientInput, TestTransient>;
	    deleteById: DeleteOperation<string>;
	}
	export interface TestTransientLines extends ClientNode {
	    stringValue: string;
	    parent: TestTransient;
	}
	export interface TransientLinesKey {
	    _id: string;
	}
	export interface TransientLinesInput extends TransientLinesKey {
	    stringValue: string;
	    parent: integer | string;
	}
	export interface TestTransientLines$Operations {
	    query: QueryOperation<TestTransientLines>;
	    read: ReadOperation<TestTransientLines>;
	    create: CreateOperation<TransientLinesInput, TestTransientLines>;
	    updateById: UpdateByIdOperation<TransientLinesInput, TestTransientLines>;
	    deleteById: DeleteOperation<string>;
	}
	//# sourceMappingURL=transient.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/secure.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/secure' {
	import { ClientNode, QueryOperation, ReadOperation } from '@sage/xtrem-client';
	export interface TestSite extends ClientNode {
	    code: string;
	}
	export interface TestSecure extends ClientNode {
	    code: string;
	    site: TestSite | null;
	    access: string;
	}
	export interface SecureKey {
	    code: string;
	}
	export interface SecureInput extends SecureKey {
	    site?: string | null;
	}
	export interface TestSecure$Operations {
	    query: QueryOperation<TestSecure>;
	    read: ReadOperation<TestSecure>;
	}
	export interface TestSite$Operations {
	    query: QueryOperation<TestSite>;
	    read: ReadOperation<TestSite>;
	}
	//# sourceMappingURL=secure.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/referring.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/referring' {
	import { ClientNode, CreateOperation, DeleteOperation, QueryOperation } from '@sage/xtrem-client';
	import { TestReferredInterface } from '@sage/xtrem-core/test/fixtures/client-nodes/referred';
	export interface TestReferringInterface extends ClientNode {
	    code: string;
	    description: string;
	    reference?: TestReferredInterface | null;
	    restricted?: string;
	    referenceArray?: TestReferredInterface[] | null;
	}
	export interface TestReferringInput {
	    code?: string;
	    description?: string;
	    reference?: string | null;
	    restricted?: string;
	    referenceArray?: string[] | null;
	}
	export interface TestMandatoryReferring extends ClientNode {
	    code: string;
	    description: string;
	    reference: TestReferredInterface;
	}
	export interface TestReferringInterface$Operations {
	    query: QueryOperation<TestReferringInterface>;
	    create: CreateOperation<TestReferringInput, TestReferringInterface>;
	    delete: DeleteOperation<{}>;
	}
	//# sourceMappingURL=referring.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/referred.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/referred' {
	import { ClientNode } from '@sage/xtrem-client';
	export interface TestReferredInterface extends ClientNode {
	    code: string;
	    details: string;
	    restricted?: string;
	}
	//# sourceMappingURL=referred.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/operation.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/operation' {
	import { BinaryStream, ClientNode, ClientNodeInput, GetDefaultsOperation, GetDuplicateOperation, integer, Operation, TextStream } from '@sage/xtrem-client';
	import { TestEnum } from '@sage/xtrem-core/test/fixtures/client-nodes/datatypes';
	export interface TestOperationReference extends ClientNode {
	    code: string;
	    quantity: integer;
	}
	export interface TestOperationReferenceInput extends ClientNodeInput {
	    code?: string;
	    quantity?: integer | string;
	}
	export interface TestOperation extends ClientNode {
	    code: string;
	    value: integer;
	}
	export interface TestOperationInput extends ClientNodeInput {
	    code?: string;
	    value?: integer | string;
	}
	export interface TestOperation$Queries {
	    queryReturningString: Operation<{
	        code?: string;
	        stringVal?: string;
	        intVal?: integer;
	        enumVal?: TestEnum;
	    }, string>;
	    queryWithComplexInput: Operation<{
	        object: {
	            simple?: boolean;
	            mandatory: string;
	            nullable?: string | null;
	        };
	        optionalObjects?: {
	            nestedStrings?: string[];
	            flag?: boolean;
	        }[];
	    }, string>;
	    queryWithComplexOutput: Operation<{
	        object: {
	            simple?: boolean;
	            mandatory: string;
	            nullable?: string | null;
	        };
	        optionalObjects?: {
	            nestedStrings?: string[];
	            flag?: boolean;
	        }[];
	    }, {
	        object: {
	            simple: boolean;
	            mandatory: string;
	            nullable: string | null;
	        };
	        optionalObjects: {
	            nestedStrings: string[];
	            flag: boolean;
	        }[];
	    }>;
	    queryWithReferences: Operation<{
	        reference?: string;
	        nullableReference?: string | null;
	        arrayOfReferences?: string[];
	        arrayOfNullableReferences?: (string | null)[];
	        nested?: {
	            reference?: integer | string;
	            nullableReference?: (integer | string) | null;
	            arrayOfReferences?: string[];
	            arrayOfNullableReferences?: (string | null)[];
	        };
	    }, {
	        reference: TestOperationReference;
	        nullableReference: TestOperationReference | null;
	        arrayOfReferences: TestOperationReference[];
	        arrayOfNullableReferences: (TestOperationReference | null)[];
	        nested: {
	            reference: TestOperationReference;
	            nullableReference: TestOperationReference | null;
	            arrayOfReferences: TestOperationReference[];
	            arrayOfNullableReferences: (TestOperationReference | null)[];
	        };
	    }>;
	    queryReturningSimpleArray: Operation<{
	        len?: integer | string;
	    }, string[]>;
	    queryReturningArrayOfObjects: Operation<{
	        len?: integer | string;
	    }, {
	        index: integer;
	        text: string;
	    }[]>;
	    queryWithOptionalArgs: Operation<{
	        option1?: string;
	        option2?: string;
	        option3?: string;
	    }, string>;
	}
	export interface TestOperation$Mutations {
	    mutationReturningString: Operation<{
	        code?: string;
	        stringVal?: string;
	        intVal?: integer;
	    }, string>;
	    mutationReturningNode: Operation<{
	        code: string;
	        intVal?: integer;
	    }, TestOperation>;
	    mutationWithNodeParameter: Operation<{
	        arg: TestOperationInput;
	    }, TestOperation>;
	    mutationArrayOfInstanceReturningString: Operation<{
	        instanceArray?: TestOperationInput[];
	    }, string>;
	    mutationWithBinaryStreamAsResult: Operation<{
	        binaryContent: string;
	    }, BinaryStream>;
	    mutationWithTextStreamAsResult: Operation<{
	        textContent: string;
	    }, TextStream>;
	    mutationWithNonWritableReferenceParameter: Operation<{
	        reference: string;
	    }, string>;
	    mutationWithWritableReferenceParameter: Operation<{
	        reference: string;
	    }, string>;
	    mutationStartedReadonlyRunningWithWritable: Operation<{
	        reference: string;
	    }, string>;
	    mutationWithoutParameters: Operation<{}, string>;
	}
	export interface TestOperation$Operations {
	    queries: TestOperation$Queries;
	    mutations: TestOperation$Mutations;
	    getDefaults: GetDefaultsOperation<TestOperation>;
	    getDuplicate: GetDuplicateOperation<TestOperation>;
	}
	//# sourceMappingURL=operation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/index.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/index' {
	/// <reference path="document-lookup.d.ts" />
	import { TestDocumentLookup$Operations } from '@sage/test-app-api';
	import { ClientAggDocument$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document';
	import { ClientAggDocumentLine$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document-line';
	import { TestDatatypesInterface$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/datatypes';
	import { ClientDocument$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/document';
	import { ClientDocumentLine$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/document-line';
	import { TestEncryptedValues$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/encrypted-values';
	import { TestFrozen$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/frozen';
	import { TestOperation$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/operation';
	import { TestReferringInterface$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/referring';
	import { TestSecure$Operations, TestSite$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/secure';
	import { TestTransient$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/transient';
	import { ClientVitalCollectionParent$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-collection-parent';
	import { ClientVitalReferenceParent$Operations } from '@sage/xtrem-core/test/fixtures/client-nodes/vital-reference-parent';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document-line';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/datatypes';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/document';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/document-line';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/encrypted-values';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/frozen';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/operation';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/referred';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/referring';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/secure';
	export * from '@sage/xtrem-core/test/fixtures/client-nodes/transient';
	export interface Test$Package {
	    '@sage/xtrem-core/testDatatypes': TestDatatypesInterface$Operations;
	    '@sage/xtrem-core/testDocument': ClientDocument$Operations;
	    '@sage/xtrem-core/testDocumentLine': ClientDocumentLine$Operations;
	    '@sage/xtrem-core/testAggDocument': ClientAggDocument$Operations;
	    '@sage/xtrem-core/testAggDocumentLine': ClientAggDocumentLine$Operations;
	    '@sage/xtrem-core/testEncryptedValues': TestEncryptedValues$Operations;
	    '@sage/xtrem-core/testFrozen': TestFrozen$Operations;
	    '@sage/xtrem-core/testOperation': TestOperation$Operations;
	    '@sage/xtrem-core/testReferring': TestReferringInterface$Operations;
	    '@sage/xtrem-core/testSite': TestSite$Operations;
	    '@sage/xtrem-core/testSecure': TestSecure$Operations;
	    '@sage/xtrem-core/testDocumentLookup': TestDocumentLookup$Operations;
	    '@sage/xtrem-core/testTransient': TestTransient$Operations;
	    '@sage/xtrem-core/testVitalCollectionParent': ClientVitalCollectionParent$Operations;
	    '@sage/xtrem-core/testVitalReferenceParent': ClientVitalReferenceParent$Operations;
	}
	export interface GraphApi extends Test$Package {
	}
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/frozen.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/frozen' {
	import { ClientNode, QueryOperation, ReadOperation } from '@sage/xtrem-client';
	export interface TestFrozen extends ClientNode {
	    code: string;
	    description: string;
	}
	export interface TestFrozen$Operations {
	    query: QueryOperation<TestFrozen>;
	    read: ReadOperation<TestFrozen>;
	}
	//# sourceMappingURL=frozen.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/encrypted-values.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/encrypted-values' {
	import { ClientNode, ClientNodeInput, CreateOperation, QueryOperation, UpdateOperation } from '@sage/xtrem-client';
	export interface TestEncryptedValues extends ClientNode {
	    id: number;
	    passwordValue: string;
	}
	export interface TestEncryptedValuesInput extends ClientNodeInput {
	    id?: number;
	    passwordValue?: string;
	}
	export interface TestEncryptedValues$Operations {
	    query: QueryOperation<TestEncryptedValues>;
	    create: CreateOperation<TestEncryptedValuesInput, TestEncryptedValues>;
	    update: UpdateOperation<TestEncryptedValuesInput, TestEncryptedValues>;
	}
	//# sourceMappingURL=encrypted-values.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/document.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/document' {
	import { ClientCollection, ClientNode, CreateOperation, QueryOperation, UpdateByIdOperation } from '@sage/xtrem-client';
	import { ClientDocumentLine, DocumentLineInput } from '@sage/xtrem-core/test/fixtures/client-nodes/document-line';
	import { TestReferredInterface } from '@sage/xtrem-core/test/fixtures/client-nodes/referred';
	export interface ClientDocument extends ClientNode {
	    code: string;
	    description: string;
	    mandatoryReference: TestReferredInterface;
	    lines: ClientCollection<ClientDocumentLine>;
	}
	export interface DocumentKey {
	    code: string;
	}
	export interface DocumentInput extends DocumentKey {
	    description?: string;
	    mandatoryReference?: number;
	    lines?: Partial<DocumentLineInput>[];
	}
	export interface ClientDocument$Operations {
	    query: QueryOperation<ClientDocument>;
	    create: CreateOperation<DocumentInput, ClientDocument>;
	    updateById: UpdateByIdOperation<DocumentInput, ClientDocument>;
	}
	//# sourceMappingURL=document.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/document-lookup.d.ts
declare module '@sage/test-app-api' {
    import { ClientNode, CreateOperation, integer, QueryOperation } from '@sage/xtrem-client';
    type StatusEnum = 'draft' | 'reviewed' | 'accepted';
    interface TestReferencedDocument extends ClientNode {
        lookupString: string;
        controlInteger: integer;
        controlDetails: TestReferencedDocumentDetails | null;
    }
    interface TestReferencedDocumentKey {
    }
    interface TestReferencedDocumentInput extends TestReferencedDocumentKey {
        lookupString?: string;
        controlInteger?: integer;
        controlDetails?: TestReferencedDocumentDetails | string | null;
    }
    interface TestReferencedDocumentOther extends ClientNode {
        lookupString: string;
        controlInteger: integer;
    }
    interface TestReferencedDocumentOtherKey {
    }
    interface TestReferencedDocumentOtherInput extends TestReferencedDocumentOtherKey {
        lookupString?: string;
        controlInteger?: integer;
    }
    interface TestReferencedDocumentDetails extends ClientNode {
        text: string;
    }
    interface TestReferencedDocumentDetailsKey {
    }
    interface TestReferencedDocumentDetailsInput extends TestReferencedDocumentDetailsKey {
        text?: string;
    }
    interface TestDocumentLookup extends ClientNode {
        lookupString: string;
        parentControlInteger: integer;
        reference: TestReferencedDocument;
        noControlReference: TestReferencedDocument;
        noLookupReference: TestReferencedDocument;
        noFiltersReference: TestReferencedDocument;
        otherReference: TestReferencedDocumentOther;
        details: TestReferencedDocumentDetails | null;
        controlledByDetailsReference: TestReferencedDocument | null;
        referenceArrayLookup: TestReferencedDocument[];
        referenceArrayControl: TestReferencedDocument[];
    }
    interface TestDocumentLookupKey {
    }
    interface TestDocumentLookupInput extends TestDocumentLookupKey {
        lookupString?: string;
        parentControlInteger?: integer;
        reference?: TestReferencedDocument;
        noControlReference?: TestReferencedDocument;
        noLookupReference?: TestReferencedDocument;
        noFiltersReference?: TestReferencedDocument;
        otherReference?: TestReferencedDocumentOther;
        details?: TestReferencedDocumentDetails | string | null;
        controlledByDetailsReference?: TestReferencedDocument | string | null;
        referenceArrayLookup?: (integer | string)[];
        referenceArrayControl?: (integer | string)[];
    }
    interface TestDocumentLookup$Lookups {
        reference: QueryOperation<TestReferencedDocument>;
        noControlReference: QueryOperation<TestReferencedDocument>;
        noLookupReference: QueryOperation<TestReferencedDocument>;
        noFiltersReference: QueryOperation<TestReferencedDocument>;
        otherReference: QueryOperation<TestReferencedDocumentOther>;
    }
    interface TestDocumentLookup$Operations {
        create: CreateOperation<TestDocumentLookupInput, TestDocumentLookup>;
        lookups(dataOrId: string | {
            data: TestDocumentLookupInput;
        }): TestDocumentLookup$Lookups;
    }
    interface Package {
        '@sage/test-app/TestDocumentLookup': TestDocumentLookup$Operations;
    }
    interface GraphApi extends Package {
    }
}
//# sourceMappingURL=document-lookup.d.ts.map
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/document-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/document-line' {
	import { ClientNode, integer, QueryOperation } from '@sage/xtrem-client';
	import { ClientDocument } from '@sage/xtrem-core/test/fixtures/client-nodes/document';
	import { TestReferredInterface } from '@sage/xtrem-core/test/fixtures/client-nodes/referred';
	export interface ClientDocumentLine extends ClientNode {
	    document: ClientDocument;
	    lineNumber: integer;
	    description: string;
	    getDescription: string;
	    optionalReference?: TestReferredInterface | null;
	}
	export interface DocumentLineKey {
	    document: string;
	    lineNumber: integer | string;
	}
	export interface DocumentLineInput extends DocumentLineKey {
	    description?: string;
	    optionalReference?: string | null;
	}
	export interface ClientDocumentLine$Operations {
	    query: QueryOperation<ClientDocumentLine>;
	}
	//# sourceMappingURL=document-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/datatypes.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/datatypes' {
	import { BinaryStream, ClientNode, CreateOperation, DeleteOperation, integer, QueryOperation, ReadOperation, short, TextStream, UpdateByIdOperation } from '@sage/xtrem-client';
	export type TestEnum = 'value1' | 'value2' | 'value3';
	export type TestEnumForArray = 'arrayVal1' | 'arrayVal2' | 'arrayVal3';
	export interface TestDatatypesInterface extends ClientNode {
	    id: integer;
	    booleanVal: boolean | null;
	    shortVal: short;
	    integerVal: integer;
	    integerRangeVal: string | null;
	    decimalRangeVal: string | null;
	    enumVal: TestEnum | null;
	    stringVal: string;
	    stringArrayVal: string[] | null;
	    decimalVal: string;
	    floatVal: number;
	    doubleVal: number;
	    dateVal: string | null;
	    dateRangeVal: string | null;
	    datetimeRangeVal: string | null;
	    timeVal: string | null;
	    datetimeVal: string | null;
	    binaryStream: BinaryStream | null;
	    textStream: TextStream | null;
	    uuidVal: string;
	    computed: integer;
	    complexComputed: integer;
	    jsonVal: any;
	    integerArrayVal: integer[] | null;
	    enumArrayVal: TestEnumForArray[] | null;
	}
	export interface DatatypesKey {
	    id: integer;
	}
	export interface DatatypesInput extends DatatypesKey {
	    booleanVal?: boolean;
	    shortVal?: short | string;
	    integerVal?: integer | string;
	    integerRangeVal?: string | null;
	    decimalRangeVal?: string | null;
	    enumVal?: TestEnum;
	    stringVal?: string;
	    stringArrayVal?: string[];
	    decimalVal?: number | string;
	    floatVal?: number | string;
	    doubleVal?: number | string;
	    dateVal?: string | null;
	    timeVal?: string | null;
	    datetimeVal?: string | null;
	    binaryStream?: BinaryStream | null;
	    textStream?: TextStream | null;
	    uuidVal?: string;
	    integerArrayVal?: (integer | string)[];
	    enumArrayVal?: TestEnumForArray[];
	}
	export interface DatatypesIdInput extends DatatypesInput {
	    _id: string;
	}
	export interface TestDatatypesInterface$Operations {
	    query: QueryOperation<TestDatatypesInterface>;
	    read: ReadOperation<TestDatatypesInterface>;
	    create: CreateOperation<DatatypesInput, TestDatatypesInterface>;
	    updateById: UpdateByIdOperation<DatatypesInput, TestDatatypesInterface>;
	    deleteById: DeleteOperation<string>;
	}
	//# sourceMappingURL=datatypes.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/arrays.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/arrays' {
	import { ClientNode, CreateOperation, DeleteOperation, integer, QueryOperation, ReadOperation, UpdateByIdOperation, UpdateOperation } from '@sage/xtrem-client';
	export type TestEnum = 'value1' | 'value2' | 'value3';
	export interface ArraysClientNode extends ClientNode {
	    id: integer;
	    booleanValues: (boolean | null)[];
	    integerValues: integer[];
	    enumValues: (TestEnum | null)[];
	    stringValues: string[];
	    decimalValues: string[];
	    floatValues: number[];
	    doubleValues: number[];
	    dateValues: (string | null)[];
	    datetimeValues: (string | null)[];
	    uuidValues: (string | null)[];
	}
	export interface ArraysClientKey {
	    id: integer;
	}
	export interface ArraysClientInput extends ArraysClientKey {
	    booleanValues: (boolean | null)[];
	    integerValues: (integer | string)[];
	    enumValues: (TestEnum | null)[];
	    stringValues: string[];
	    decimalValues: (number | string)[];
	    floatValues: (number | string)[];
	    doubleValues: (number | string)[];
	    dateValues: (string | null)[];
	    datetimeValues: (string | null)[];
	    uuidValues: (string | null)[];
	}
	export interface ArraysClientIdInput extends ArraysClientInput {
	    _id: string;
	}
	export interface Arrays$Operations {
	    query: QueryOperation<ArraysClientNode>;
	    read: ReadOperation<ArraysClientNode>;
	    create: CreateOperation<ArraysClientInput, ArraysClientNode>;
	    update: UpdateOperation<ArraysClientInput, ArraysClientNode>;
	    updateById: UpdateByIdOperation<ArraysClientInput, ArraysClientNode>;
	    delete: DeleteOperation<ArraysClientKey>;
	    deleteById: DeleteOperation<string>;
	}
	//# sourceMappingURL=arrays.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/agg-document.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/agg-document' {
	import { ClientCollection, ClientNode, QueryOperation } from '@sage/xtrem-client';
	import { ClientAggDocumentLine } from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document-line';
	export interface ClientAggDocument extends ClientNode {
	    code: string;
	    lines: ClientCollection<ClientAggDocumentLine>;
	}
	export interface AggDocumentKey {
	    code: string;
	}
	export interface ClientAggDocument$Operations {
	    query: QueryOperation<ClientAggDocument>;
	}
	//# sourceMappingURL=agg-document.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/client-nodes/agg-document-line.d.ts
declare module '@sage/xtrem-core/test/fixtures/client-nodes/agg-document-line' {
	import { AggregateQueryOperation, AggregateReadOperation, ClientNode, integer, QueryOperation } from '@sage/xtrem-client';
	import { ClientAggDocument } from '@sage/xtrem-core/test/fixtures/client-nodes/agg-document';
	export interface ClientAggDocumentLine extends ClientNode {
	    document: ClientAggDocument;
	    date: string;
	    lineNumber: integer;
	    quantity: integer;
	    amount1: string;
	}
	export interface ClientAggDocumentLine$Operations {
	    query: QueryOperation<ClientAggDocumentLine>;
	    aggregate: {
	        read: AggregateReadOperation<ClientAggDocumentLine>;
	        query: AggregateQueryOperation<ClientAggDocumentLine>;
	    };
	}
	//# sourceMappingURL=agg-document-line.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/activity-extensions/test-activity-extension.d.ts
declare module '@sage/xtrem-core/test/fixtures/activity-extensions/test-activity-extension' {
	import { ActivityExtension } from '@sage/xtrem-core/index';
	export const testActivityExtension: ActivityExtension;
	//# sourceMappingURL=test-activity-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/activity-extensions/_index.d.ts
declare module '@sage/xtrem-core/test/fixtures/activity-extensions/_index' {
	export * from '@sage/xtrem-core/test/fixtures/activity-extensions/test-activity-extension';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/activities/test-activity.d.ts
declare module '@sage/xtrem-core/test/fixtures/activities/test-activity' {
	import { Activity } from '@sage/xtrem-core/index';
	export const testActivity: Activity;
	//# sourceMappingURL=test-activity.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/activities/test-activity-related.d.ts
declare module '@sage/xtrem-core/test/fixtures/activities/test-activity-related' {
	import { Activity } from '@sage/xtrem-core/index';
	export const testActivityRelated: Activity;
	//# sourceMappingURL=test-activity-related.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/fixtures/activities/_index.d.ts
declare module '@sage/xtrem-core/test/fixtures/activities/_index' {
	export * from '@sage/xtrem-core/test/fixtures/activities/test-activity';
	export * from '@sage/xtrem-core/test/fixtures/activities/test-activity-related';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/file-storage/download-url-test.d.ts
declare module '@sage/xtrem-core/test/file-storage/download-url-test' {
	export {};
	//# sourceMappingURL=download-url-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/add-ons/add-ons-test.d.ts
declare module '@sage/xtrem-core/test/add-ons/add-ons-test' {
	export {};
	//# sourceMappingURL=add-ons-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/test/access-rights/graphql-access-rights-test.d.ts
declare module '@sage/xtrem-core/test/access-rights/graphql-access-rights-test' {
	export {};
	//# sourceMappingURL=graphql-access-rights-test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/system-exports.d.ts
declare module '@sage/xtrem-core/lib/system-exports' {
	export { Compress, Decompress } from '@sage/xtrem-core/lib/archive/index';
	export { BaseCollection } from '@sage/xtrem-core/lib/collections/base-collection';
	export { getDecorators } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	export { ObjectType } from '@sage/xtrem-core/lib/graphql/types/object-type';
	export { OperationType } from '@sage/xtrem-core/lib/graphql/types/operation-type';
	export { TypeCache } from '@sage/xtrem-core/lib/graphql/utils/type-cache';
	export { StateDependency } from '@sage/xtrem-core/lib/node-state/state-dependency';
	export { ForeignNodeProperty, Property, ReferenceProperty, isPropertyInputOnly, isPropertyOutputOnly, } from '@sage/xtrem-core/lib/properties/index';
	export { ContextOptions, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	export { basicProfiler, convertDataKey, getDefaultableReferenceProperties, getFactoryDependsOn, sortFactories, } from '@sage/xtrem-core/lib/runtime/index';
	export { _syncTickDataType } from '@sage/xtrem-core/lib/runtime/system-data-types';
	export { SystemProperties } from '@sage/xtrem-core/lib/runtime/system-properties';
	export { logSecurityAlert } from '@sage/xtrem-core/lib/security/index';
	export { SqlConverter } from '@sage/xtrem-core/lib/sql/mapper/index';
	export { PubSub, PubSubEnvelope, PubSubPayload } from '@sage/xtrem-core/lib/sql/pubsub/index';
	export { BroadcastHandler } from '@sage/xtrem-core/lib/sql/pubsub/broadcast-handler';
	export { ContainerHeartbeatMonitor } from '@sage/xtrem-core/lib/sql/pubsub/container-heartbeat-monitor';
	export { FixSchema, Table, TestStatus } from '@sage/xtrem-core/lib/sql/schema/index';
	export { parseIndexDefinition } from '@sage/xtrem-core/lib/sql/schema/utils';
	export { createExtensions } from '@sage/xtrem-core/lib/sql/statements/extensions';
	export { createFunctions } from '@sage/xtrem-core/lib/sql/statements/functions';
	export { makeName63 } from '@sage/xtrem-core/lib/sql/statements/naming';
	export { getEncryptedStringStorageSize } from '@sage/xtrem-core/lib/sql/statements/types-conversion';
	export { getArtifactDataType } from '@sage/xtrem-core/lib/system/artifact-manager';
	export { initTables, restoreTables } from '@sage/xtrem-core/lib/test/tables';
	//# sourceMappingURL=system-exports.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/index.d.ts
declare module '@sage/xtrem-core/lib/index' {
	/// <reference types="@sage/xtrem-decimal" />
	/// <reference types="@sage/xtrem-config" />
	/// <reference types="@sage/xtrem-date-time" />
	/// <reference types="@sage/xtrem-i18n" />
	/// <reference types="@sage/xtrem-log" />
	/// <reference types="@sage/xtrem-postgres" />
	/// <reference types="@sage/xtrem-shared" />
	import { registerSqlFunction } from '@sage/xtrem-ts-to-sql';
	export * from '@sage/xtrem-async-helper';
	export { ConfigManager } from '@sage/xtrem-config';
	export { DateValue, Datetime, DatetimeRange, time } from '@sage/xtrem-date-time';
	export { toDecimal, toInteger, toNumber } from '@sage/xtrem-decimal';
	export { localize, localizeEnumMember } from '@sage/xtrem-i18n';
	export { Logger } from '@sage/xtrem-log';
	export { DatabaseError } from '@sage/xtrem-postgres';
	export { AuthorizationError, BusinessRuleError, DataInputError, Dict, LocalizeLocale, LogicError, MAX_INT_32, MIN_INT_32, SystemError, ValidationSeverity, titleCase, } from '@sage/xtrem-shared';
	export { Application, ApplicationCreateOptions, ApplicationCreateSqlSchema, ApplicationManager, ApplicationStartServicesOptions, ApplicationType, AttachmentAssociationData, AttachmentData, AttachmentManager, ClientSettings, ClientSettingsManager, ClientUserSettings, CsvChecksumManager, DashboardManager, HotUpgradeManager, NotificationManager, Package, PackageApi, PackageJsonFile, PrintingManager, ServiceOption, StartChannel, UpgradeMetricsType, allowedStartChannels, getPackageName, getPackageQueueName, gracefulShutdown, unhandledErrorMonitor, } from '@sage/xtrem-core/lib/application/index';
	export { AuditManagerInterface } from '@sage/xtrem-core/lib/hooks/auditing/index';
	export { WorkflowError, WorkflowManagerInterface, WorkflowMock, WorkflowMockOptions, WorkflowResult, WorkflowRunOptions, WorkflowStartEvent, WorkflowStepDescriptor, WorkflowStepInterface, WorkflowStepUiDescriptor, WorkflowStepUiOptions, } from '@sage/xtrem-core/lib/workflow/index';
	export { S3Bucket, S3ConfigurationType, S3Helper, S3Manager, S3ObjectInfo, getRegion } from '@sage/xtrem-core/lib/aws/index';
	export { withDetachedClsContext } from '@sage/xtrem-core/lib/concurrency-utils';
	export * from '@sage/xtrem-core/lib/decorators/index';
	export { fileExists } from '@sage/xtrem-core/lib/file-utils';
	export * from '@sage/xtrem-core/lib/graphql/index';
	export { AccessBinding } from '@sage/xtrem-core/lib/graphql/security/access-bindings';
	export * from '@sage/xtrem-core/lib/html/index';
	export { AppConstructOptions as AppOptions, GraphQlRequestOptions, GraphQlResponse, InteropAppHealthMonitor, InteropAppInfo, InteropAuthConfig, InteropGraphqlClient, NotificationTopic, NotificationTopicConstructOptions as NotificationTopicOptions, interopApp, } from '@sage/xtrem-core/lib/interop/index';
	export * from '@sage/xtrem-core/lib/metrics/index';
	export { lazyLoadedMarker } from '@sage/xtrem-core/lib/node-state/index';
	export * from '@sage/xtrem-core/lib/properties/enum-property';
	export * from '@sage/xtrem-core/lib/properties/string-property';
	export * from '@sage/xtrem-core/lib/runtime/core-hooks';
	export { AccessRightsManager, ActivityInfo, BulkUpdateOptions, ContainerManager, Context, ContextInternal, CreateAdminUserOptions, CustomRecordInterface, CustomerInfo, DataSettingsManager, FriendlyParameter, LocalizationManager, NodeIndex, PackAllocationInterface, PackVersionInterface, PackVersionInterfaceWithId, PackVersionOptions, PropertyAndValue, StandardOperation, SysGlobalLock, TenantInfo, TenantInfoBase, TenantManager, UpdateSetFunctionSet, UserAccess, UserData, UserInfo, UserNavigationInfo, adminDemoPersona, applyFilter, friendlyJsonParse, friendlyOperationSignature, getLanguageFromLocale, getServerUrl, globalRunningContext, isCompound, isScalar, monitoredFunnel, nanoIdDataType, personaCookieDefinition, retry, rootUserEmail, supportReadonlyUserEmail, supportUserEmail, valueComparator, withAdvisoryLock, } from '@sage/xtrem-core/lib/runtime/index';
	export { JwtClaims, htmlSanitizer, registerTlsChangeListener, setup as setupSecurity } from '@sage/xtrem-core/lib/security/index';
	export { DataDiagnosis, DataDiagnosisCategory, DataDiagnosisSeverity, OrderByClause, SqlNaturalKeyUtils, SqlValueConverter, TriggerBuilder, garbageCollectContentAddressableTable, garbageCollectContentAddressableTables, tenantIdColumnName, } from '@sage/xtrem-core/lib/sql/index';
	export { SyncInfo } from '@sage/xtrem-core/lib/synchronization/sync-info';
	export * from '@sage/xtrem-core/lib/system-exports';
	export { ArtifactDataType, ArtifactDataTypeEnum, ArtifactManager, PackArtifactInterface, } from '@sage/xtrem-core/lib/system/artifact-manager';
	export { ApplicationArtifact, ClientArtifactMetadata, ClientArtifactType, JsPackArtifact, MetaPackArtifact, } from '@sage/xtrem-core/lib/system/pages/client-service';
	export * from '@sage/xtrem-core/lib/test/index';
	export * from '@sage/xtrem-core/lib/ts-api/index';
	export { BinaryStreamDataType, DataType, DecimalDataType, DecimalDataTypeOptions, Enum, EnumDataType, EnumDataTypeOptions, EnumType, InternalPropertyJoin, JoinMember, JsonDataType, JsonDataTypeOptions, MimeTypeHelper, ReferenceDataType, ReferenceDataTypeOptions, RoundingMode, StreamDataTypeOptions, StringArrayDataType, StringDataType, StringDataTypeOptions, TextStreamDataType, notNull, } from '@sage/xtrem-core/lib/types/index';
	export { BinaryStream, ColumnMetadata, FactoryMetadata, SqlFileDataRow, SqlFileDataSet, SqlFileDataSets, Stream, TextStream, Uuid, customFieldTypeDefaultValue, typeDefaultValue, } from '@sage/xtrem-core/lib/types/index';
	export { getNameWithoutPackage, parseCursor } from '@sage/xtrem-core/lib/types/util';
	export * from '@sage/xtrem-core/lib/utils/anonymize';
	export * from '@sage/xtrem-core/lib/utils/check-recompute-values-hash';
	export * from '@sage/xtrem-core/lib/utils/record-paging';
	export { registerSqlFunction };
	export { FileStorageManager } from '@sage/xtrem-core/lib/file-storage/index';
	export { bodyLoggerMiddleware, loggerAllowsCompress, requestLoggerMiddleware } from '@sage/xtrem-core/lib/http/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/file-utils.d.ts
declare module '@sage/xtrem-core/lib/file-utils' {
	export function fileExists(filename: string): Promise<boolean>;
	//# sourceMappingURL=file-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/concurrency-utils.d.ts
declare module '@sage/xtrem-core/lib/concurrency-utils' {
	/** @ignore */ /** */
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { ApplicationError } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	export const wrapError: (context: Context, err: Error) => ApplicationError;
	export function withDetachedClsContext<T extends AnyValue>(context: Context, body: (context: Context) => AsyncResponse<T>): Promise<T>;
	//# sourceMappingURL=concurrency-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/workflow/workflow-step-descriptor.d.ts
declare module '@sage/xtrem-core/lib/workflow/workflow-step-descriptor' {
	export type WorkflowStepIcon = 'addons' | 'bright' | 'trash-bin' | 'clock' | 'print' | 'mail' | 'megaphone' | 'accounting' | 'binocular' | 'database' | 'pencil' | 'connected' | 'hourglass';
	export type WorkflowStepShape = 'oval' | 'diamond';
	export interface WorkflowStepUiOptions {
	    icon: WorkflowStepIcon;
	    shape: WorkflowStepShape;
	    color: string;
	    configurationPage: string;
	}
	export interface WorkflowStepUiDescriptor extends WorkflowStepUiOptions {
	    type: 'event' | 'action' | 'condition';
	    key: string;
	    title: string;
	    description: string;
	}
	export interface WorkflowStepDescriptor {
	    type: 'event' | 'action' | 'condition';
	    key: string;
	    title: string;
	    description: string;
	    startTopics?: string;
	    resumeTopics?: string;
	    minOutputs?: number;
	    maxOutputs?: number;
	    ui: WorkflowStepUiOptions;
	}
	export interface WorkflowStepInterface {
	    descriptor: WorkflowStepDescriptor;
	}
	//# sourceMappingURL=workflow-step-descriptor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/workflow/workflow-mock.d.ts
declare module '@sage/xtrem-core/lib/workflow/workflow-mock' {
	/** Mock options provided by a workflow scenario */
	export interface WorkflowMockOptions {
	    path: string;
	    calls: {
	        input: any;
	        output: any;
	    }[];
	}
	export abstract class WorkflowMock {
	    readonly options: WorkflowMockOptions;
	    constructor(options: WorkflowMockOptions);
	    abstract execute<T>(body: () => Promise<T>): Promise<T>;
	    static loadMock(options: WorkflowMockOptions): Promise<WorkflowMock>;
	    static run<T>(mocks: WorkflowMockOptions[] | undefined, body: () => Promise<T>): Promise<T>;
	}
	//# sourceMappingURL=workflow-mock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/workflow/workflow-manager-stub.d.ts
declare module '@sage/xtrem-core/lib/workflow/workflow-manager-stub' {
	import { WorkflowManagerInterface } from '@sage/xtrem-core/lib/workflow/workflow-manager-interface';
	import { WorkflowStepDescriptor, WorkflowStepInterface } from '@sage/xtrem-core/lib/workflow/workflow-step-descriptor';
	export class WorkflowManagerStub implements WorkflowManagerInterface {
	    registerWorkflowStep(packageName: string, workflowStep: WorkflowStepInterface): never;
	    getWorkflowStepDescriptors(): WorkflowStepDescriptor[];
	    getWorkflowStepDescriptor(key: string): never;
	    getWorkflowTopics(): string[];
	    run(): never;
	    start(): never;
	}
	//# sourceMappingURL=workflow-manager-stub.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/workflow/workflow-manager-interface.d.ts
declare module '@sage/xtrem-core/lib/workflow/workflow-manager-interface' {
	import { Dict, WorkflowVariable } from '@sage/xtrem-shared';
	import { WorkflowMockOptions } from '@sage/xtrem-core/lib/workflow/workflow-mock';
	import { WorkflowStepDescriptor, WorkflowStepInterface } from '@sage/xtrem-core/lib/workflow/workflow-step-descriptor';
	export interface WorkflowRunOptions {
	    tenantId: string;
	    userId: string;
	    mocks?: WorkflowMockOptions[];
	}
	export interface WorkflowStartEvent<PayloadT = unknown> {
	    topic: string;
	    payload: PayloadT;
	}
	export interface WorkflowError {
	    stepId: string;
	    message: string;
	}
	export interface WorkflowResult {
	    status: string;
	    variables?: Dict<WorkflowVariable>;
	    errors?: WorkflowError[];
	}
	export interface WorkflowManagerInterface {
	    registerWorkflowStep(packageName: string, workflowStep: WorkflowStepInterface): void;
	    getWorkflowStepDescriptors(): WorkflowStepDescriptor[];
	    getWorkflowStepDescriptor(key: string): WorkflowStepDescriptor;
	    getWorkflowTopics(): string[];
	    run(startEvent: WorkflowStartEvent, options: WorkflowRunOptions): Promise<WorkflowResult>;
	    start(): Promise<void>;
	}
	//# sourceMappingURL=workflow-manager-interface.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/workflow/index.d.ts
declare module '@sage/xtrem-core/lib/workflow/index' {
	export * from '@sage/xtrem-core/lib/workflow/workflow-manager-interface';
	export * from '@sage/xtrem-core/lib/workflow/workflow-manager-stub';
	export * from '@sage/xtrem-core/lib/workflow/workflow-mock';
	export * from '@sage/xtrem-core/lib/workflow/workflow-step-descriptor';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/utils/record-paging.d.ts
declare module '@sage/xtrem-core/lib/utils/record-paging' {
	import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { Context, NodeFactory, PropertyAndValue } from '@sage/xtrem-core/lib/runtime/index';
	import { OrderByClause } from '@sage/xtrem-core/lib/sql/index';
	import { AnyFilterValue, NodeQueryOptions } from '@sage/xtrem-core/lib/ts-api/index';
	type Comparator = (val1: AnyValue, val2: AnyValue) => AsyncResponse<number>;
	type GetPropertyValue = (context: Context, property: Property, parent: AnyRecord) => AsyncResponse<AnyValue>;
	type Predicate = (val: AnyValue) => boolean;
	export class RecordPaging {
	    /**
	     * Compose two comparators into a new comparator
	     * @param f
	     * @param g
	     * @returns
	     */
	    static composeComparators(f: Comparator, g: Comparator): Comparator;
	    /**
	     * Compile the orderBy clause into a comparator
	     * @param context
	     * @param factory
	     * @param orderBy
	     * @param getPropertyValue
	     * @returns
	     */
	    static compileOrderBy(context: Context, factory: NodeFactory, orderBy: AnyRecord, getPropertyValue: GetPropertyValue): Promise<Comparator>;
	    /**
	     * Convert a filter object into a predicate function that can be used to filter an array of objects.
	     * The filter object can contain the following operators:
	     * - _eq: equal
	     * - _ne: not equal
	     * - _gt: greater than
	     * - _gte: greater than or equal
	     * - _lt: less than
	     * - _lte: less than or equal
	     * - _in: in
	     * - _nin: not in
	     * - _and: and
	     * - _or: or
	     * - _nor: nor
	     * - _not: not
	     * - _mod: mod
	     * - _regex: regex
	     * And the follow quantifiers:
	     * - _atLeast: at least
	     * - _atMost: at most
	     * - _none: none
	     * - _every: every
	     *
	     * @param locales
	     * @returns
	     */
	    static converter(locales?: string[]): (val: AnyValue) => Predicate;
	    /**
	     * We will receive the data object with the references, collections and referencesArrays filled with the _id
	     * We will fill the data with the actual data from the data store, so that the Predicate can be applied.
	     * We will only fill the data that is needed for the filter.
	     * @param context
	     * @param factory
	     * @param getPropertyValue
	     * @param items
	     * @param filter
	     * @returns
	     */
	    static fillData(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], obj: AnyFilterValue): Promise<AnyRecord[]>;
	    /**
	     * Apply the filter to a list of items
	     * @param context
	     * @param factory
	     * @param getPropertyValue
	     * @param items
	     * @param filter
	     * @param locales
	     * @returns
	     */
	    static applyFilter(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], filter: AnyFilterValue, locales?: string[]): Promise<AnyRecord[]>;
	    /**
	     * Apply the orderBy clause to a list of items
	     * @param context
	     * @param factory
	     * @param items
	     * @param orderBy
	     * @param getPropertyValue
	     * @returns
	     */
	    static applyOrderBy(context: Context, factory: NodeFactory, items: AnyRecord[], orderBy: AnyRecord, getPropertyValue: GetPropertyValue): Promise<AnyRecord[]>;
	    /**
	     * Apply the paging operation (before, after) to a list of items
	     * @param context
	     * @param factory
	     * @param getPropertyValue
	     * @param items
	     * @param orderByClauses
	     * @param values
	     * @param op
	     * @returns
	     */
	    static applyPagingOperation(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], orderByClauses: OrderByClause[], values: PropertyAndValue[], op: 'after' | 'before'): Promise<AnyRecord[]>;
	    /**
	     * Convert the filter object into a format that can be used by the query
	     * @param context
	     * @param factory
	     * @param filter
	     * @param parentPath
	     * @param property
	     * @returns
	     */
	    static convertFilter(context: Context, factory: NodeFactory, filter: AnyFilterValue | undefined, parentPath?: string[], property?: Property): AnyFilterValue | any[] | undefined;
	    /**
	     * Parse the filter object
	     * @param context
	     * @param factory
	     * @param filter
	     * @returns
	     */
	    static parseFilter(context: Context, factory: NodeFactory, filter: AnyFilterValue | undefined): AnyFilterValue | undefined;
	    /**
	     * Apply the paging options to a list of records (filter, order by, first, last, after, before)
	     * @param factory
	     * @param context
	     * @param records
	     * @param getPropertyValue
	     * @param options
	     * @returns
	     */
	    static applyPagingOptions(factory: NodeFactory, context: Context, records: AnyRecord[], getPropertyValue: GetPropertyValue, options?: NodeQueryOptions): Promise<{
	        items: AnyRecord[];
	        totalCount: number;
	    }>;
	}
	export {};
	//# sourceMappingURL=record-paging.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/utils/index.d.ts
declare module '@sage/xtrem-core/lib/utils/index' {
	/**
	 * List of packages to exclude from certain checks for unit tests
	 */
	export const testPackageExclusions: string[];
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/utils/check-recompute-values-hash.d.ts
declare module '@sage/xtrem-core/lib/utils/check-recompute-values-hash' {
	import { Logger } from '@sage/xtrem-log';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/**
	 * Given a specific tenantId, this function will ensure that the _valuesHash of all content addressable nodes
	 * in the tenant is correct. This is useful when importing/restoring anonymized data, where the _valuesHash is not updated.
	 * @param application
	 * @param tenantId
	 * @param logger
	 */
	export function checkAndSyncValuesHash(application: Application, tenantId: string, logger: Logger): Promise<void>;
	//# sourceMappingURL=check-recompute-values-hash.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/utils/anonymize.d.ts
declare module '@sage/xtrem-core/lib/utils/anonymize' {
	/**
	 * Default list of characters to preserve from the original string when randomizing the string
	 */
	export const defaultPreserveList = "'\\ \"@!#$%^&*()-=_+,.?<>/|:;{}[]\u00AB\u00BB\u00BA\u00AA~\u20AC\u00A8\u00A3\u00A7";
	/**
	 * Randomize a string to have a similar structure as the original by replacing each character with a random
	 * character of the same type (uppercase, lowercase or digit) and preserving a specific list of characters.
	 * Other characters from the original, like non ASCII Unicode characters are not supported at this stage and
	 * will be replaced with random lowercase letters.
	 *
	 * Because we translate the byte value to a number using the modulus of the required range, the random characters
	 * will have a slight bias, so do not use this for any security related functions.
	 *
	 * Please see here for more information:
	 * https://codeql.github.com/codeql-query-help/javascript/js-biased-cryptographic-random/
	 *
	 * @param original String to use as a structure template
	 * @returns Randomized string
	 */
	export function unsafeRandomizeCharacters(original: string, preserveList?: string): string;
	/**
	 * Randomize a URL
	 *
	 * @returns URL that satisfies the URL regex
	 */
	export function randomizeUrl(original: string): string;
	/**
	 * Performs a loose comparison of strings.
	 * Characters are considered equal when they belong to the same class (digit, lowercase letter, uppercase letter, etc.)
	 */
	export function compareAnonymizedStrings(strOriginalIn: string, strCompare: string, preserveList?: string): boolean;
	//# sourceMappingURL=anonymize.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/uuid.d.ts
declare module '@sage/xtrem-core/lib/types/uuid' {
	/// <reference types="node" />
	/// <reference types="node" />
	export class Uuid {
	    private readonly data;
	    toHexString(): string;
	    toString(sep?: string): string;
	    static isZero(val: Buffer): boolean;
	    static generate(): Uuid;
	    static fromBytes(bytes: Buffer): Uuid;
	    static fromString(str: string): Uuid;
	    static zero: Uuid;
	}
	//# sourceMappingURL=uuid.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/util.d.ts
declare module '@sage/xtrem-core/lib/types/util' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { NodeStorage, TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { PropertyAndValue } from '@sage/xtrem-core/lib/runtime/index';
	/**
	 * `notNull(x)` is equivalent to `x!` but keeps sonar quiet
	 *
	 * We use it to deal with nullable properties inside functions that must be convertible to SQL
	 * because the ts-to-sql converter does not (yet) support local variables inside functions.
	 */
	export const notNull: <T extends AnyValue>(x: T) => NonNullable<T>;
	export function typeDefaultValue(type: TypeName | undefined, isNullable?: boolean, isLocalized?: boolean, storage?: NodeStorage): any;
	/**
	 * Returns the default value for a custom field, based on its type and isMandatory attribute.
	 * We cannot use getTypeDefaultValue() for this because custom fields do not have an isNullable attribute.
	 * This function only returns `null` if the field is not mandatory and the type does not have an _obvious_ default value.
	 * 0 is an obvious default value for numbers but null is a more obvious default value than date.today() for non mandatory dates.
	 */
	export function customFieldTypeDefaultValue(type: TypeName | undefined, isMandatory?: boolean): any;
	export function safeParseInt(value: unknown, propertyName?: string): number;
	export function fastHash(str: string): number;
	export function getNameWithoutPackage(fullName: string): string;
	/** @disabled_internal */
	export function parseCursor(orderByProperties: Property[], value: string): PropertyAndValue[];
	//# sourceMappingURL=util.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/text-stream.d.ts
declare module '@sage/xtrem-core/lib/types/text-stream' {
	import { Stream } from '@sage/xtrem-core/lib/types/stream';
	/** @packageDocumentation @module types */
	export class TextStream extends Stream {
	    value: string;
	    constructor(value: string, contentType?: string);
	    static fromString(value: string, contentType?: string): TextStream;
	    private static fromSanitizedString;
	    static fromJsonObject(value: any): TextStream;
	    static isTextStream(obj: any): obj is TextStream;
	    static readonly empty: TextStream;
	    private verifyContentType;
	    get contentType(): Promise<string>;
	    sanitized(): Promise<TextStream>;
	    toString(): string;
	    compareTo(arg: any): number;
	}
	//# sourceMappingURL=text-stream.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/string-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/string-data-type' {
	import { AsyncResponse, integer, type Dict } from '@sage/xtrem-shared';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	export interface StringDataTypeOptions<T = unknown, ValT extends string | null = string> extends DataTypeOptions {
	    maxLength?: number;
	    isLocalized?: true;
	    doNotTrim?: boolean;
	    truncate?: boolean;
	    defaultValue?: (this: T) => AsyncResponse<ValT | undefined>;
	}
	export interface StringDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	    maxLength: number | null;
	    isLocalized: boolean;
	    doNotTrim: boolean;
	    truncate: boolean;
	}
	export interface StringArrayDataTypeMetadata<TitleT> extends StringDataTypeMetadata<TitleT> {
	}
	export class StringDataType<T = unknown, ValT extends string | null = string> extends DataType<ValT, T, StringDataTypeOptions<T, ValT>> {
	    constructor(options: StringDataTypeOptions<T, ValT>);
	    get maxLength(): integer;
	    get isLocalized(): boolean;
	    controlValue(node: T, cx: ValidationContext, val: string): Promise<void>;
	    adaptValue(_node: T, val: ValT): AsyncResponse<ValT>;
	    defaultValue(node: T): AsyncResponse<ValT | undefined>;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): StringDataTypeMetadata<TitleT>;
	}
	export class StringArrayDataType<T = unknown, ValT extends string[] | null = string[]> extends DataType<ValT, T, StringDataTypeOptions> {
	    constructor(options: StringDataTypeOptions);
	    get maxLength(): integer;
	    controlValue(node: T, cx: ValidationContext, val: string[]): Promise<void>;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): StringArrayDataTypeMetadata<TitleT>;
	}
	//# sourceMappingURL=string-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/stream.d.ts
declare module '@sage/xtrem-core/lib/types/stream' {
	/** @packageDocumentation @module types */
	export abstract class Stream {
	    abstract compareTo(val: any): number;
	    static isStream(val: any): val is Stream;
	}
	//# sourceMappingURL=stream.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/stream-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/stream-data-type' {
	import { ColumnTypeName, Dict } from '@sage/xtrem-shared';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	import { BinaryStream } from '@sage/xtrem-core/lib/types/binary-stream';
	import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	import { Stream } from '@sage/xtrem-core/lib/types/stream';
	import { TextStream } from '@sage/xtrem-core/lib/types/text-stream';
	export interface StreamDataTypeOptions extends DataTypeOptions {
	    maxLength?: number;
	    allowedContentTypes?: string[];
	    dangerouslyUnsafe?: boolean;
	}
	export interface StreamDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	    maxLength: number | null;
	    allowedContentTypes: string[];
	}
	abstract class StreamDataType<ValT extends Stream | null, T = unknown> extends DataType<ValT, T, StreamDataTypeOptions> {
	    private readonly unit;
	    constructor(type: ColumnTypeName, options: StreamDataTypeOptions, unit: string);
	    get maxLength(): number;
	    get allowedContentTypes(): string[];
	    get dangerouslyUnsafe(): boolean;
	    abstract checkLength(val: ValT): boolean;
	    abstract getByteLength(val: ValT): number;
	    abstract validateContent(node: T, name: string, val: ValT): Promise<void>;
	    controlValue(node: T, cx: ValidationContext, val: ValT): Promise<void>;
	}
	export class BinaryStreamDataType<ValT extends BinaryStream | null = BinaryStream, T = unknown> extends StreamDataType<ValT, T> {
	    constructor(options: StreamDataTypeOptions);
	    getByteLength(val: BinaryStream | null): number;
	    checkLength(val: BinaryStream | null): boolean;
	    validateContent(node: T, name: string, val: BinaryStream | null): Promise<void>;
	    validateContentType(name: string, val: BinaryStream): Promise<void>;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): StreamDataTypeMetadata<TitleT>;
	}
	export class TextStreamDataType<ValT extends TextStream = TextStream, T = unknown> extends StreamDataType<ValT, T> {
	    constructor(options: StreamDataTypeOptions);
	    static default: TextStreamDataType<TextStream, unknown>;
	    getByteLength(val: TextStream | null): number;
	    checkLength(val: TextStream): boolean;
	    validateContent(node: T, name: string, val: TextStream): Promise<void>;
	    validateContentType(name: string, val: TextStream): Promise<void>;
	    static validateXmlAgainstXXE(value: string): void;
	    adaptValue(node: T, val: ValT): Promise<ValT>;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): StreamDataTypeMetadata<TitleT>;
	}
	export {};
	//# sourceMappingURL=stream-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/sql-file-data.d.ts
declare module '@sage/xtrem-core/lib/types/sql-file-data' {
	import { Dict } from '@sage/xtrem-shared';
	import { TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	/**
	 * A data row to be reloaded for a factory
	 * Will be used when replaying SQL files with data inside
	 */
	export type SqlFileDataRow = Dict<any>;
	/**
	 * Description of a column to be reloaded
	 * Will be used when replaying SQL files with data inside
	 */
	export type ColumnMetadata = {
	    /**
	     * The name of the column
	     */
	    name: string;
	    /**
	     * The type of the column (more precisely is equal to colum.property.type)
	     */
	    type: TypeName;
	    /**
	     * Is the column nullable ?
	     * Note: only set when true
	     */
	    isNullable?: true;
	    /**
	     * Is the column encrypted (when type==='string') ?
	     * Note: only set when true
	     */
	    isEncrypted?: true;
	    /**
	     * Is the column localized (when type==='string') ?
	     * Note: only set when true
	     */
	    isLocalized?: true;
	    /**
	     * Is the column owned by customer ?
	     * Note: only set when true
	     */
	    isOwnedByCustomer?: true;
	    /**
	     * The factory that contains the property of the column
	     * Only set when it differs from the factory the column is bound to
	     */
	    definingFactory?: string;
	    /**
	     * When type is 'reference' : the name of the target factory
	     */
	    targetFactoryName?: string;
	    /**
	     * When type is 'reference' : the root name of the target factory
	     * Only set when differs from targetFactoryName
	     */
	    targetRootFactoryName?: string;
	    /**
	     * When type is 'enum', the list of possible members
	     */
	    enumMembers?: string[];
	};
	/**
	 * Metadata for a factory
	 * Will mainly be used when replaying SQL files
	 */
	export type FactoryMetadata = {
	    /**
	     * The name of the factory
	     */
	    name: string;
	    /**
	     * The name of the root factory
	     */
	    rootFactoryName: string;
	    /**
	     * Is the factory abstract ?
	     * Note: only set when true
	     */
	    isAbstract?: true;
	    /**
	     * Name of the base factory (if any)
	     */
	    baseFactoryName?: string;
	    /**
	     * Is the factory a vital collection child ?
	     * Note: only set when true
	     */
	    isVitalCollectionChild?: true;
	    /**
	     * Is the factory a vital child ?
	     * Note: only set when true
	     */
	    isVitalChild?: true;
	    /**
	     * Is the factory shared by all the tenants ?
	     * Note: only set when true
	     */
	    isSharedByAllTenants?: true;
	    /**
	     * The columns of the table
	     */
	    columns: ColumnMetadata[];
	    /**
	     * The natural keys (column names) to be used to reload rows
	     */
	    naturalKeyColumns: string[];
	    vitalParentColumn?: ColumnMetadata;
	};
	/**
	 * A data set (headers + rows) to be reloaded for a factory
	 * Will be used when replaying SQL files with data inside
	 */
	export type SqlFileDataSet = {
	    /**
	     * The metadata of the factory
	     */
	    metadata: FactoryMetadata;
	    /**
	     * The rows to reload
	     */
	    rows: SqlFileDataRow[];
	};
	/**
	 * A list of data, indexed by factory name
	 */
	export type SqlFileDataSets = Dict<SqlFileDataSet>;
	//# sourceMappingURL=sql-file-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/reference-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/reference-data-type' {
	import { UnPromised } from '@sage/xtrem-async-helper';
	import { AsyncResponse, Dict } from '@sage/xtrem-shared';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Extend, Node, NodeQueryFilter, PropertyQueryFilter } from '@sage/xtrem-core/lib/ts-api/index';
	import { JoinLiteralValue } from '@sage/xtrem-core/lib/ts-api/join';
	import { DataType, DataTypeMetadata, DataTypeOptions, FieldBinding, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	/** Type for property paths in dot notation, like 'address.city' */
	export type PropertyPath<ValT extends Node | null, SeenT = never, Depth extends unknown[] = [unknown], K extends keyof ValT = keyof ValT> = K extends string ? K extends '$' | `_${infer Unused}` ? never : ValT[K] extends Promise<infer RefT extends Node | null> ? RefT extends SeenT ? never : Depth['length'] extends 3 ? never : `${K}.${PropertyPath<RefT, SeenT | ValT, [...Depth, unknown]>}` : K : never;
	export interface LookupDefinition<ValT extends Node> {
	    readonly valuePath: PropertyPath<ValT>;
	    readonly helperTextPath?: PropertyPath<ValT>;
	    readonly imageFieldPath?: PropertyPath<ValT>;
	    readonly tunnelPageIdPath?: PropertyPath<ValT>;
	    readonly tunnelPage?: string;
	    columnPaths: readonly PropertyPath<ValT>[];
	}
	export interface ReferenceDataTypeOptions<ValT extends Node | null, NodeT extends Node> extends DataTypeOptions {
	    reference: () => {
	        new (): ValT;
	    };
	    filters?: {
	        lookup?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<NodeT>>;
	        control?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<NodeT>>;
	    };
	    isNullable?: boolean;
	    ignoreIsActive?: boolean;
	    isDefault?: boolean;
	    lookup: LookupDefinition<NonNullable<ValT>>;
	}
	export interface ReferenceDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	    node: string;
	    value: FieldBinding<TitleT>;
	    helperText?: FieldBinding<TitleT>;
	    imageField?: FieldBinding<TitleT>;
	    columns: FieldBinding<TitleT>[];
	    tunnelPage?: string;
	    tunnelPageId?: FieldBinding<TitleT>;
	}
	export class ReferenceDataType<ValT extends Node, NodeT extends Node = Node> extends DataType<ValT, NodeT, ReferenceDataTypeOptions<ValT, NodeT>> {
	    constructor(options: ReferenceDataTypeOptions<ValT, NodeT>);
	    get isNullable(): boolean;
	    get ignoreIsActive(): boolean;
	    get isDefault(): boolean;
	    get node(): string;
	    /**
	     * Returns the metadata of the data type.
	     * This is called from 2 places:
	     * - from the graphql metadata endpoint in xtrem-core, to provide the data type fragment of the response.
	     * - from the metadata upgrader in xtrem-metadata, to provide the _attributes_ of reference data types.
	     * In the first case the titles are returned as strings because we only need the titles for the user's locale.
	     * In the second case the titles are returned as Dict<string> because we need the values for all the locales.
	     * The TitleT generic type allows us to handle these two scenarios with a type-safe implementation.
	     */
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): ReferenceDataTypeMetadata<TitleT>;
	    static getNodeDefaultDataType(application: Application, factory: NodeFactory): ReferenceDataType<Node> | undefined;
	}
	export type JoinMember<T extends Node, This extends Node, K extends Exclude<keyof T, '$'>> = string | JoinLiteralValue | ((this: Extend<This>) => AsyncResponse<PropertyQueryFilter<This, UnPromised<T[K]>>>) | (T[K] extends Promise<infer U> ? (U extends Node ? PropertyJoin<U, This> : never) : never);
	export type PropertyJoin<T extends Node, This extends Node = T> = Partial<{
	    [K in Exclude<keyof T, '$'>]: JoinMember<T, This, K>;
	}>;
	export type InternalPropertyJoin<T extends Node, This extends Node = T> = Dict<JoinMember<T, This, any>>;
	//# sourceMappingURL=reference-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/mime-type-helper.d.ts
declare module '@sage/xtrem-core/lib/types/mime-type-helper' {
	export {};
	//# sourceMappingURL=mime-type-helper.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/json-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/json-data-type' {
	import { AnyValue, type Dict } from '@sage/xtrem-shared';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/validation';
	import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	export interface JsonDataTypeOptions extends DataTypeOptions {
	}
	export interface JsonDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	}
	export class JsonDataType<T = unknown, ValT extends AnyValue = AnyValue> extends DataType<ValT, T, JsonDataTypeOptions> {
	    constructor(options?: JsonDataTypeOptions);
	    controlValue(node: T, cx: ValidationContext, val: object): Promise<void>;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): JsonDataTypeMetadata<TitleT>;
	}
	//# sourceMappingURL=json-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/index.d.ts
declare module '@sage/xtrem-core/lib/types/index' {
	export * from '@sage/xtrem-core/lib/types/arrays';
	export * from '@sage/xtrem-core/lib/types/binary-stream';
	export * from '@sage/xtrem-core/lib/types/data-type';
	export * from '@sage/xtrem-core/lib/types/decimal-data-type';
	export * from '@sage/xtrem-core/lib/types/enum-data-type';
	export * from '@sage/xtrem-core/lib/types/json-data-type';
	export * from '@sage/xtrem-core/lib/types/mime-type-helper';
	export * from '@sage/xtrem-core/lib/types/reference-data-type';
	export * from '@sage/xtrem-core/lib/types/sql-file-data';
	export * from '@sage/xtrem-core/lib/types/stream';
	export * from '@sage/xtrem-core/lib/types/stream-data-type';
	export * from '@sage/xtrem-core/lib/types/string-data-type';
	export * from '@sage/xtrem-core/lib/types/text-stream';
	export * from '@sage/xtrem-core/lib/types/util';
	export * from '@sage/xtrem-core/lib/types/uuid';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/enum-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/enum-data-type' {
	import { Dict } from '@sage/xtrem-shared';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/validation';
	import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	export interface Enum {
	    [id: number]: string;
	}
	export interface EnumDataTypeOptions extends DataTypeOptions {
	    enum: Enum;
	    filename: string;
	    extends?: EnumDataType;
	}
	export interface EnumType {
	    name: string;
	    values: Dict<number>;
	}
	export interface EnumDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	    values: {
	        value: string;
	        title: string | TitleT;
	    }[];
	    enumName: string;
	}
	export class EnumDataType<ValueT extends string | null = string, T = unknown> extends DataType<ValueT extends string ? ValueT : never, T, EnumDataTypeOptions> {
	    options: EnumDataTypeOptions;
	    private _packageName;
	    private _values;
	    private _extendedMemberInfo;
	    constructor(options: EnumDataTypeOptions);
	    get enum(): Enum;
	    get filename(): string;
	    get instanceValues(): Dict<number>;
	    get enumValues(): Dict<number>;
	    controlValue(node: T, cx: ValidationContext, val?: string | string[]): Promise<void>;
	    numberValue(memberValue: string): number;
	    stringValue(keyValue: number): ValueT;
	    validateMemberValue(memberValue: string): void;
	    getLocalizedValue(context: Context, memberValue: string): string;
	    getLocalizedValues(context: Context): string[];
	    enumName(): string;
	    get packageName(): string;
	    enumFullName(): string;
	    get values(): ValueT[];
	    compareValues(val1: string | number | null, val2: string | number | null): number;
	    getEnumType(): EnumType;
	    get baseDataType(): EnumDataType | undefined;
	    get rootDataType(): EnumDataType | undefined;
	    getLocalizedTitleKey(): string;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): EnumDataTypeMetadata<TitleT>;
	}
	//# sourceMappingURL=enum-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/decimal-data-type.d.ts
declare module '@sage/xtrem-core/lib/types/decimal-data-type' {
	/// <reference types="@sage/xtrem-decimal" />
	import { integer } from '@sage/xtrem-client';
	import { AsyncResponse, type Dict } from '@sage/xtrem-shared';
	import { decimal } from '@sage/xtrem-core/lib/ts-api/index';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/validation';
	import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from '@sage/xtrem-core/lib/types/data-type';
	export enum RoundingMode {
	    roundUp = 0,
	    roundDown = 1,
	    roundCeil = 2,
	    roundFloor = 3,
	    roundHalfUp = 4,
	    roundHalfDown = 5,
	    roundHalfEven = 6,
	    roundHalfCeil = 7,
	    roundHalfFloor = 8
	}
	export interface DecimalDataTypeOptions extends DataTypeOptions {
	    precision?: number;
	    scale?: number;
	    roundingMode?: RoundingMode;
	}
	export interface DecimalDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
	    precision: number;
	    scale: number;
	    roundingMode: keyof RoundingMode;
	}
	export class DecimalDataType<T = unknown, ValT extends decimal | null = decimal> extends DataType<ValT, T, DecimalDataTypeOptions> {
	    protected options: DecimalDataTypeOptions;
	    static defaultRoundingMode: RoundingMode;
	    static defaultPrecision: number;
	    static defaultScale: number;
	    constructor(options: DecimalDataTypeOptions);
	    get roundingMode(): RoundingMode;
	    get precision(): integer;
	    get scale(): integer;
	    private static toImplementation;
	    private static fromImplementation;
	    adaptValue(_node: T, val: ValT): AsyncResponse<ValT>;
	    controlValue(node: T, cx: ValidationContext, val?: decimal): Promise<void>;
	    static toDecimalPlaces(val: number, scale: number, roundingMode?: RoundingMode): decimal;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): DecimalDataTypeMetadata<TitleT>;
	}
	//# sourceMappingURL=decimal-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/data-type.d.ts
declare module '@sage/xtrem-core/lib/types/data-type' {
	import { AnyValue, AsyncResponse, ColumnTypeName, type Dict } from '@sage/xtrem-shared';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { ValidationContext } from '@sage/xtrem-core/lib/ts-api/validation';
	export interface DataTypeOptions {
	    serviceOptions?: () => ServiceOption[];
	}
	export type DataTypeLocalize<TitleT> = (localizationKey: string, name: string) => TitleT;
	export interface FieldBinding<TitleT> {
	    bind: string;
	    title?: TitleT;
	    type?: string;
	    enumType?: string | null;
	}
	export interface DataTypeMetadata<TitleT> {
	    name: string;
	    title: TitleT;
	    type: string;
	    isDefault: boolean;
	}
	export interface MetaDataOptions<TitleT, ApplicationT extends any, ContextT extends any> {
	    localize: DataTypeLocalize<TitleT>;
	    application: ApplicationT;
	    context?: ContextT;
	}
	export abstract class DataType<ValT extends AnyValue, T, OptionsT extends DataTypeOptions = DataTypeOptions> {
	    readonly type: ColumnTypeName;
	    protected readonly options: OptionsT;
	    name?: string;
	    pack?: string;
	    constructor(type: ColumnTypeName, options: OptionsT);
	    get serviceOptions(): ServiceOption[];
	    defaultValue<FullT extends T>(_node: FullT): AsyncResponse<ValT | undefined>;
	    controlValue<FullT extends T>(_node: FullT, _cx: ValidationContext, _val: any): AsyncResponse<void>;
	    adaptValue<FullT extends T>(_node: FullT, _val: ValT): AsyncResponse<ValT>;
	    dataTypeOptions(): OptionsT;
	    getLocalizedTitleKey(): string;
	    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): DataTypeMetadata<TitleT>;
	}
	export const isInt32: (val: any) => boolean;
	//# sourceMappingURL=data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/binary-stream.d.ts
declare module '@sage/xtrem-core/lib/types/binary-stream' {
	/// <reference types="node" />
	/// <reference types="node" />
	import { Stream } from '@sage/xtrem-core/lib/types/stream';
	/** @packageDocumentation @module types */
	export class BinaryStream extends Stream {
	    value: Buffer;
	    constructor(value: Buffer);
	    static fromBuffer(value: Buffer): BinaryStream;
	    static isBinaryStream(obj: any): boolean;
	    toString(): string;
	    compareTo(arg: any): number;
	}
	//# sourceMappingURL=binary-stream.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/types/arrays.d.ts
declare module '@sage/xtrem-core/lib/types/arrays' {
	import { TypeName } from '@sage/xtrem-core/lib/index';
	export const arrayTypes: (TypeName | '')[];
	export function stringToArray(value: string): string[];
	export type ArrayType<This, T> = This extends (infer ElementT)[] | null ? ElementT extends T ? ElementT : never : never;
	//# sourceMappingURL=arrays.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/validation.d.ts
declare module '@sage/xtrem-core/lib/ts-api/validation' {
	/** @packageDocumentation @module runtime */
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { DateValue } from '@sage/xtrem-date-time';
	import { BusinessRuleError, ValidationSeverity } from '@sage/xtrem-shared';
	import { Diagnose } from '@sage/xtrem-core/lib/ts-api/diagnose';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	interface ForSeverity {
	    if: <T>(arg: T) => {
	        is: ContextValidators<T>;
	    };
	    add: (message: string) => void;
	    addLocalized: (key: string, template: string, data?: object | any[]) => void;
	    withMessage: (key: string, template: string, data?: () => AsyncResponse<object | any[]>) => ForSeverity;
	}
	interface Expect<T> {
	    to: {
	        be: ContextValidators<T>;
	    };
	    withMessage: (key: string, template: string, data?: () => AsyncResponse<object | any[]>) => Expect<T>;
	}
	interface LocalizedMessage {
	    key: string;
	    template: string;
	    data?: () => AsyncResponse<object | any[]>;
	}
	interface ValidatorsEqual<T> {
	    to: (v2: T) => AsyncResponse<boolean>;
	}
	interface ValidatorsComparison<T> {
	    than: (v2: T) => AsyncResponse<boolean>;
	}
	interface ValidatorsAt<T> {
	    least: (v2: T) => AsyncResponse<boolean>;
	    most: (v2: T) => AsyncResponse<boolean>;
	}
	export class ContextValidators<T> {
	    private readonly messageContext;
	    private readonly arg;
	    private readonly negated;
	    private get context();
	    private get severity();
	    get not(): ContextValidators<T>;
	    empty(this: ContextValidators<string | null>): Promise<boolean>;
	    get equal(): ValidatorsEqual<T>;
	    get greater(): ValidatorsComparison<T>;
	    get less(): ValidatorsComparison<T>;
	    get at(): ValidatorsAt<T>;
	    in(this: ContextValidators<T>, set: T[]): Promise<boolean>;
	    true(this: ContextValidators<boolean>): Promise<boolean>;
	    false(this: ContextValidators<boolean>): Promise<boolean>;
	    matching(this: ContextValidators<string | null>, re: RegExp): Promise<boolean>;
	    zero(this: ContextValidators<number | null>): Promise<boolean>;
	    positive(this: ContextValidators<number | null>): Promise<boolean>;
	    negative(this: ContextValidators<number | null>): Promise<boolean>;
	    before(this: ContextValidators<DateValue | null>, v2: DateValue): Promise<boolean>;
	    after(this: ContextValidators<DateValue | null>, v2: DateValue): Promise<boolean>;
	}
	export class ValidationContext {
	    node: Node;
	    path: string[];
	    localize(key: string, template: string, data?: object | any[]): string;
	    addDiagnose(severity: ValidationSeverity, message: string): void;
	    addError(message: string): void;
	    addWarning(message: string): void;
	    addInfo(message: string): void;
	    get severity(): ValidationSeverity;
	    at(...keys: string[]): ValidationContext;
	    get info(): ForSeverity;
	    get warn(): ForSeverity;
	    get error(): ForSeverity;
	    get throw(): ForSeverity;
	    forExpect<T>(arg: T, localizedMessage?: LocalizedMessage): Expect<T>;
	    expect<T>(arg: T): Expect<T>;
	}
	interface Diagnoses {
	    diagnoses: Diagnose[];
	    code: string;
	}
	export class ValidationError extends BusinessRuleError {
	    readonly node: Node;
	    /** This attribute will be used to propagate this diagnoses to the GraphQL response */
	    extensions: Diagnoses;
	    constructor(node: Node, message?: string, innerError?: Error);
	}
	export type Validator<This extends Node, ValT = void> = (this: This, cx: ValidationContext, val: ValT) => AsyncResponse<ValT extends never ? never : void>;
	export {};
	//# sourceMappingURL=validation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/reference.d.ts
declare module '@sage/xtrem-core/lib/ts-api/reference' {
	/**
	 * This module defines the Reference<T> type.
	 */
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	/**
	 * Type for reference properties.
	 * All properties with a referenceProperty decorator should be typed as Reference<T>
	 * where T is the referenced node class.
	 */
	export type Reference<T extends Node | null> = Promise<T>;
	//# sourceMappingURL=reference.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/query-order-by.d.ts
declare module '@sage/xtrem-core/lib/ts-api/query-order-by' {
	import { UnPromised } from '@sage/xtrem-async-helper';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	export type OrderBy<T extends Node | null> = {
	    [K in keyof T]?: K extends '$' ? never : T[K] extends infer U ? UnPromised<U> extends Node | null ? OrderBy<UnPromised<U>> | 1 | -1 : 1 | -1 : 1 | -1;
	} & {
	    _sortValue?: 1 | -1;
	};
	export type FlatOrderBy<T extends Node | null> = {
	    [K in Exclude<keyof T, '$'> | '_sortValue' | '_constructor']?: 1 | -1;
	};
	//# sourceMappingURL=query-order-by.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/query-options.d.ts
declare module '@sage/xtrem-core/lib/ts-api/query-options' {
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	import { Aggregate } from '@sage/xtrem-core/lib/ts-api/query-aggregate';
	import { NodeQueryFilter } from '@sage/xtrem-core/lib/ts-api/query-filter';
	import { OrderBy } from '@sage/xtrem-core/lib/ts-api/query-order-by';
	export interface NodeQueryOptions<T extends Node = Node> {
	    forUpdate?: boolean;
	    skipLocked?: boolean;
	    filter?: NodeQueryFilter<T>;
	    orderBy?: OrderBy<T>;
	    first?: number;
	    after?: string;
	    last?: number;
	    before?: string;
	    aggregate?: Aggregate;
	    locale?: string;
	    count?: boolean;
	    collection?: BaseCollection;
	}
	//# sourceMappingURL=query-options.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/query-filter.d.ts
declare module '@sage/xtrem-core/lib/ts-api/query-filter' {
	import { AnyValue, AsyncResponse, UnPromised } from '@sage/xtrem-async-helper';
	import { DateRange, DateValue, Datetime, DatetimeRange, DecimalRange, IntegerRange } from '@sage/xtrem-date-time';
	import { Decimal } from '@sage/xtrem-decimal';
	import { Dict, integer } from '@sage/xtrem-shared';
	import { SyncInfo } from '@sage/xtrem-core/lib/synchronization/sync-info';
	import { Uuid } from '@sage/xtrem-core/lib/types/uuid';
	import { Collection } from '@sage/xtrem-core/lib/ts-api/collection';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	type QuantifiedFilter<T> = (T & {
	    _atLeast: number;
	}) | (T & {
	    _atMost: number;
	}) | (T & {
	    _every: boolean;
	}) | (T & {
	    _none: boolean;
	});
	export type PropertyQueryFilter<This extends Node, V> = Exclude<V, null> extends infer U ? U extends Collection<infer ElementNode> ? ElementNode extends Node ? QuantifiedFilter<NodeFilter<This, ElementNode>> : never : U extends Node ? NodeFilter<This, U> | ValueQueryFilter<This, V extends null ? string | null : string> : U extends any[] ? (U[number] extends Node ? U | string[] | number[] : U) | ValueQueryFilter<This, V> : ValueQueryFilter<This, V> : never;
	type PropertyOpFilter<This extends Node, V> = {
	    _and?: ValueQueryFilter<This, V>[];
	    _or?: ValueQueryFilter<This, V>[];
	    _nor?: ValueQueryFilter<This, V>[];
	    _not?: ValueQueryFilter<This, V>;
	    _eq?: ValueQueryFilter<This, V>;
	    _ne?: ValueQueryFilter<This, V>;
	    _lt?: ValueQueryFilter<This, V>;
	    _lte?: ValueQueryFilter<This, V>;
	    _gt?: ValueQueryFilter<This, V>;
	    _gte?: ValueQueryFilter<This, V>;
	    _contains?: V extends any[] ? V[number] extends Node ? V[number] | string | number : V[number] : ValueQueryFilter<This, V>;
	    _containsRange?: V extends any[] ? V[number] extends Node ? V[number] | string | number : V[number] : ValueQueryFilter<This, V>;
	    _containedBy?: V extends any[] ? V[number] extends Node ? V[number] | string[] | number[] : V[number][] : ValueQueryFilter<This, V>;
	    _in?: ValueQueryFilter<This, V>[];
	    _nin?: ValueQueryFilter<This, V>[];
	    _mod?: number[];
	    _fn?: string;
	    text?: never;
	};
	export type FilterOp = Omit<keyof PropertyOpFilter<Node, any>, 'text'>;
	type RangeType<This extends Node> = {
	    start?: ValueQueryFilter<This, DateValue>;
	    end?: ValueQueryFilter<This, DateValue>;
	} | DateRange | DatetimeRange | Datetime | IntegerRange | DecimalRange | Decimal | DateValue | string | number | null;
	export type QueryFilterBasicValue = boolean | number | DateValue | Datetime | Uuid | null;
	type DateFilter<This extends Node> = {
	    value?: ValueQueryFilter<This, integer>;
	    epoch?: ValueQueryFilter<This, integer>;
	    year?: ValueQueryFilter<This, integer>;
	    month?: ValueQueryFilter<This, integer>;
	    day?: ValueQueryFilter<This, integer>;
	    week?: ValueQueryFilter<This, integer>;
	    weekDay?: ValueQueryFilter<This, integer>;
	    yearDay?: ValueQueryFilter<This, integer>;
	};
	type ValueQueryFilter<This extends Node, V> = PropertyOpFilter<This, V> | (V extends string ? RegExp | number | string | {
	    _regex: string;
	    _options?: string;
	} | ((this: This) => AsyncResponse<string>) : V extends QueryFilterBasicValue ? V | ((this: This) => AsyncResponse<V>) : never) | RangeType<This> | (V extends DateValue ? DateFilter<This> : never);
	type NodeOpFilter<This extends Node, T extends Node> = {
	    _and?: NodeFilter<This, T>[];
	    _or?: NodeFilter<This, T>[];
	    _nor?: NodeFilter<This, T>[];
	    _not?: NodeFilter<This, T>;
	    _fn?: string;
	    _id?: number | PropertyOpFilter<This, number>;
	    _createStamp?: Datetime | PropertyOpFilter<This, Datetime>;
	    _updateStamp?: Datetime | PropertyOpFilter<This, Datetime>;
	    _syncTick?: Decimal | PropertyOpFilter<This, Decimal>;
	    _syncInfo?: PropertyOpFilter<This, SyncInfo>;
	};
	type NodeFilter<This extends Node, T extends Node> = Partial<T> | ((this: This) => AsyncResponse<boolean>) | (NodeOpFilter<This, T> & {
	    -readonly [K in keyof T]?: K extends '$' ? never : PropertyQueryFilter<This, UnPromised<T[K]>> | ((this: This) => AsyncResponse<PropertyQueryFilter<This, UnPromised<T[K]>>>);
	});
	/**
	 * Type for query filters
	 *
	 * `T` is the node we are querying
	 * `This` is the type of the _this_ parameter in the filter functions.
	 *
	 * On the control/lookup filters of a reference proeprty, `This` is different from `T`:
	 * - `T` is the referenced node (Customer if the property is the SalesOrder.customer)
	 * - `This` is the referencing node (SalesOrder if the property is the SalesOrder.customer)
	 */
	export type NodeQueryFilter<T extends Node, This extends Node = T> = NodeFilter<This, T>;
	export type AnyFilterValue = AnyValue | ((this: Node) => AsyncResponse<AnyFilterValue>) | AnyFilterObject;
	export type AnyFilterObject = Dict<AnyFilterValue>;
	export {};
	//# sourceMappingURL=query-filter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/query-aggregate.d.ts
declare module '@sage/xtrem-core/lib/ts-api/query-aggregate' {
	import { UnPromised } from '@sage/xtrem-async-helper';
	import { DateValue } from '@sage/xtrem-date-time';
	import { EnumDataType } from '@sage/xtrem-core/lib/types/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	import { NodeQueryFilter } from '@sage/xtrem-core/lib/ts-api/query-filter';
	import { NodeQueryOptions } from '@sage/xtrem-core/lib/ts-api/query-options';
	export enum ValuesOperatorEnum {
	    min = 0,
	    max = 1,
	    avg = 2,
	    sum = 3,
	    distinctCount = 4,
	    hasNull = 5
	}
	export type ValuesOperator = keyof typeof ValuesOperatorEnum;
	export enum GroupBySelectorEnum {
	    value = 0,
	    month = 1,
	    year = 2,
	    day = 3
	}
	export type GroupBySelector = keyof typeof GroupBySelectorEnum;
	export const GroupBySelectorDataType: EnumDataType<"value" | "year" | "month" | "day", unknown>;
	export interface AggregateGroup {
	    path: string[];
	    groupedBy?: GroupBySelector;
	}
	export type AggregateGroupResult<T> = T;
	export interface AggregateValue {
	    path: string[];
	    operator?: ValuesOperator;
	    resolve?: (val: any) => any;
	}
	export interface Aggregate {
	    groups: AggregateGroup[];
	    values: AggregateValue[];
	}
	export type AggregateGroupItem<V> = V extends Node ? AggregateGroups<V> : {
	    _by: V extends DateValue ? GroupBySelector : 'value';
	};
	export type AggregateGroups<T extends Node> = {
	    [K in keyof T]?: AggregateGroupItem<UnPromised<T[K]>>;
	};
	export type AggregateValueItem<V> = V extends Node ? AggregateValues<V> : {
	    [K in ValuesOperator]?: boolean;
	};
	export type AggregateValues<T extends Node> = {
	    [K in keyof T]?: AggregateValueItem<UnPromised<T[K]>>;
	};
	export interface QueryAggregateOptions<T extends Node, GroupsT extends AggregateGroups<T>, ValuesT extends AggregateValues<T>> extends NodeQueryOptions<T> {
	    group: GroupsT;
	    values: ValuesT;
	}
	export interface ReadAggregateOptions<T extends Node, ValuesT extends AggregateValues<T>> {
	    filter?: NodeQueryFilter<T>;
	    locale?: string;
	    values: ValuesT;
	}
	export type AggregateGroupReturn<T extends Node, GroupT> = {
	    [K in keyof GroupT]-?: K extends keyof T ? UnPromised<T[K]> extends infer U ? U extends Node ? AggregateGroupReturn<U, GroupT[K]> : U : never : never;
	};
	export type AggregateValuesReturn<T extends Node, ValuesT> = {
	    [K in keyof ValuesT]-?: K extends keyof T ? UnPromised<T[K]> extends infer U ? U extends Node ? AggregateValuesReturn<U, ValuesT[K]> : {
	        [KK in keyof ValuesT[K]]: U;
	    } : never : never;
	};
	export type QueryAggregateReturn<T extends Node, GroupT, ValuesT> = {
	    group: AggregateGroupReturn<T, GroupT>;
	    values: AggregateValuesReturn<T, ValuesT>;
	};
	export type ReadAggregateReturn<T extends Node, ValuesT> = AggregateValuesReturn<T, ValuesT>;
	//# sourceMappingURL=query-aggregate.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/node.d.ts
declare module '@sage/xtrem-core/lib/ts-api/node' {
	/** @packageDocumentation @module runtime */
	import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
	import { Decimal } from '@sage/xtrem-decimal';
	import { Dict, integer } from '@sage/xtrem-shared';
	import { datetime } from '@sage/xtrem-core/lib/ts-api/index';
	import { InternalAttachmentAssociationData } from '@sage/xtrem-core/lib/application/attachment-manager';
	import { Decorated } from '@sage/xtrem-core/lib/decorators/index';
	import { SyncInfo } from '@sage/xtrem-core/lib/synchronization/sync-info';
	import { Collection } from '@sage/xtrem-core/lib/ts-api/collection';
	import { Node$ } from '@sage/xtrem-core/lib/ts-api/node-$';
	/**
	 * The root `Node` class
	 *
	 * All  node classes will derive from this class.
	 */
	export class Node extends Decorated {
	    /**
	     * Reference to an object that carries system methods and properties related to the node.
	     *
	     * For example, you can retrieve the node's status with `node.$.status`, or its context with
	     * `node.$.context`.
	     * You also use this special reference to save a modified node to the database with `node.$.save()`.
	     */
	    get $(): Node$<this>;
	    /**
	     * The internal id of the node.
	     * This id is unique within the node's factory.
	     * Node : id are negative for newly created nodes that were not saved yet.
	     */
	    get _id(): number;
	    /**
	     * The node's source ID, an ID that relates the record to the source system.
	     */
	    get _sourceId(): Promise<string>;
	    /**
	     * The node's sort value, only valid on collection child nodes.
	     */
	    get _sortValue(): Promise<integer>;
	    /**
	     * The node's sort value, only valid on collection child nodes.
	     */
	    get _vendor(): Promise<Node | null>;
	    /**
	     * The node's etag value.
	     */
	    get _etag(): Promise<string>;
	    /**
	     * The node's creation timestamp.
	     */
	    get _createStamp(): Promise<datetime>;
	    /**
	     * The node's update timestamp
	     */
	    get _updateStamp(): Promise<datetime>;
	    /**
	     * The node's synchronization tick
	     */
	    get _syncTick(): Promise<Decimal>;
	    /**
	     * The node's synchronization tick
	     */
	    get _syncInfo(): Promise<SyncInfo>;
	    /**
	     * The node's custom data value.
	     */
	    get _customData(): Promise<object>;
	    /**
	     * The node's values hash, only valid on content addressable nodes.
	     */
	    get _valuesHash(): Promise<string>;
	    /**
	     * attachments collection.
	     */
	    get _attachments(): Collection<InternalAttachmentAssociationData & Node>;
	    protected toJSON(): AnyRecord;
	}
	export type AnyNode = Node & Dict<Promise<AnyValue>>;
	export type NodeFromInterface<I extends AnyRecord> = Node & {
	    [K in keyof I]: I[K] extends Array<infer EltT> ? EltT extends AnyRecord ? Collection<NodeFromInterface<EltT>> : Promise<I[K]> : Promise<I[K] extends AnyRecord ? NodeFromInterface<I[K]> : I[K]>;
	};
	//# sourceMappingURL=node.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/node-status.d.ts
declare module '@sage/xtrem-core/lib/ts-api/node-status' {
	/** Node status, as returned by `node.$.status` */
	export enum NodeStatus {
	    /** node has been read from database and not changed since */
	    unchanged = "unchanged",
	    /** node is a new node which has not been persisted yet. */
	    added = "added",
	    /** node has been read from database and then modified */
	    modified = "modified",
	    /** node has been deleted */
	    deleted = "deleted",
	    /** node pointer was set in a transaction that does not exist any more - do not use it */
	    invalid = "invalid"
	}
	//# sourceMappingURL=node-status.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/node-select-types.d.ts
declare module '@sage/xtrem-core/lib/ts-api/node-select-types' {
	import { Collection } from '@sage/xtrem-core/lib/ts-api/collection';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	import { NodeQueryFilter } from '@sage/xtrem-core/lib/ts-api/query-filter';
	import { OrderBy } from '@sage/xtrem-core/lib/ts-api/query-order-by';
	export type NodeSelector<NodeT extends Node | null> = boolean | {
	    [K in keyof NodeT]?: NodeT[K] extends Collection<infer ItemT> ? NodeSelector<ItemT> : NodeT[K] extends Promise<infer ValT> ? ValT extends Node | null ? NodeSelector<ValT> : boolean : K extends '_id' ? boolean : never;
	} | {
	    [K in string]: (this: NodeT, ...args: any[]) => any;
	};
	export interface NodeSelectOptions<NodeT extends Node> {
	    filter: NodeQueryFilter<NodeT>;
	    orderBy?: OrderBy<NodeT>;
	    first?: number;
	    after?: string;
	    last?: number;
	    before?: string;
	    locale?: string;
	    forUpdate?: boolean;
	    returnReferencesAsNaturalKey?: boolean;
	}
	export type NodeSelectResult<NodeT extends Node | null, SelectorT extends NodeSelector<NodeT>> = SelectorT extends boolean ? number | string : {
	    [K in keyof SelectorT]: K extends keyof NodeT ? NodeT[K] extends Collection<infer ItemT extends Node> ? SelectorT[K] extends NodeSelector<ItemT> ? NodeSelectResult<ItemT, SelectorT[K]>[] : never : NodeT[K] extends Promise<infer RefT> ? RefT extends null ? RefT extends Node ? SelectorT[K] extends NodeSelector<RefT> ? NodeSelectResult<RefT, SelectorT[K]> | null : SelectorT[K] extends boolean ? string | number | null : never : RefT | null : RefT extends Node ? SelectorT[K] extends NodeSelector<RefT> ? NodeSelectResult<RefT, SelectorT[K]> : SelectorT[K] extends boolean ? string | number : never : RefT : K extends '_id' ? NodeT[K] : never : SelectorT[K] extends (...args: any[]) => Promise<infer R> ? R : never;
	};
	//# sourceMappingURL=node-select-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/node-extension.d.ts
declare module '@sage/xtrem-core/lib/ts-api/node-extension' {
	/** @packageDocumentation @module runtime */
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	export type DummmyKeys = '_dummy' | '_dummy1' | '_dummy2' | '_dummy3' | '_dummy4' | '_dummy5';
	export type ExtensionMembers<T> = Omit<T, DummmyKeys>;
	export abstract class NodeExtensionBase extends Node {
	    constructor();
	}
	/**
	 * Base class for node extensions.
	 */
	export abstract class NodeExtension<Base extends Node> extends NodeExtensionBase {
	    protected _dummy: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Base class for extensions of sub-node classes at the first level of a subclass hierarchy.
	 * For example, extending Mammal in an Animal -> Mammal hierachy
	 */
	export abstract class SubNodeExtension1<Base extends Node> extends NodeExtensionBase {
	    protected _dummy1: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Base class for extensions of sub-node classes at the second level of a subclass hierarchy.
	 * For example, extending Dog in an Animal -> Mammal -> Dog hierachy
	 */
	export abstract class SubNodeExtension2<Base extends Node> extends NodeExtensionBase {
	    protected _dummy2: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Base class for extensions of sub-node classes at the third level of a subclass hierarchy.
	 * For example, extending CompanionDog in an Animal -> Mammal -> Dog -> CompanionDog hierachy
	 */
	export abstract class SubNodeExtension3<Base extends Node> extends NodeExtensionBase {
	    protected _dummy3: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Base class for extensions of sub-node classes at the fourth level of a subclass hierarchy.
	 * For example, extending Spaniel in an Animal -> Mammal -> Dog -> CompanionDog -> Spaniel hierachy
	 */
	export abstract class SubNodeExtension4<Base extends Node> extends NodeExtensionBase {
	    protected _dummy4: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Base class for extensions of sub-node classes at the fith level of a subclass hierarchy.
	 * For example, extending CavalierKingCharles in an Animal -> Mammal -> Dog -> CompanionDog -> Spaniel -> CavalierKingCharles hierachy
	 */
	export abstract class SubNodeExtension5<Base extends Node> extends NodeExtensionBase {
	    protected _dummy5: Base;
	    protected static _extensionDepth: number;
	}
	/**
	 * Maximum depth of subclassing currently allowed.
	 */
	export const maxNodeSubclassingDepth = 5;
	export type Extend<This extends Node | null> = This extends NodeExtension<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension1<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension2<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension3<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension4<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension5<infer Base> ? ExtensionMembers<This & Base> & This : This;
	//# sourceMappingURL=node-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/node-$.d.ts
declare module '@sage/xtrem-core/lib/ts-api/node-$' {
	/** @packageDocumentation @module runtime */
	import { AnyRecord, AnyValue, UnPromised } from '@sage/xtrem-async-helper';
	import { Decimal } from '@sage/xtrem-decimal';
	import { AsyncResponse, Dict, integer } from '@sage/xtrem-shared';
	import { Collection, datetime, OrderBy } from '@sage/xtrem-core/lib/ts-api/index';
	import { InternalAttachmentAssociationData } from '@sage/xtrem-core/lib/application/attachment-manager';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	import { Context, NodeDeleteOptions } from '@sage/xtrem-core/lib/runtime/context';
	import type { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { SyncInfo } from '@sage/xtrem-core/lib/synchronization/sync-info';
	import { NodePayloadData, NodeUpdateData } from '@sage/xtrem-core/lib/ts-api/create-data';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	import { NodeStatus } from '@sage/xtrem-core/lib/ts-api/node-status';
	export interface NodeSaveOptions {
	    controlOnly?: boolean;
	    useUpsert?: boolean;
	    /**
	     * Should the save be deferred at the end of the transaction ?
	     */
	    deferred?: boolean;
	    /**
	     * Flushes the deferred actions at the end of the save
	     * @see context.flushDeferredActions()
	     */
	    flushDeferredActions?: boolean;
	}
	export interface NodePayloadOptions<T> {
	    omitDefaultValues?: boolean;
	    inputValuesOnly?: boolean;
	    withIds?: boolean;
	    withoutCustomData?: boolean;
	    thunkOnly?: boolean;
	    propertyNames?: PayloadSelector<T>;
	    returnEnumsAsNumber?: boolean;
	    convertScalarValue?: (value: AnyValue) => AnyValue;
	    withLayer?: boolean;
	    withTimeStamps?: boolean;
	    withNaturalKeyWhenThunk?: boolean;
	    limitCollections?: number;
	}
	export type PayloadSelector<T> = {
	    [K in keyof T]?: T[K] extends Promise<infer U> ? (U extends Node | null ? PayloadSelector<U> : boolean) : T[K];
	};
	export type PropertyName<T extends Node> = Exclude<keyof T, Symbol | number>;
	/** System properties and methods accessible from `node.$` */
	export class Node$<NodeT extends Node> {
	    /** returns the node's status */
	    get status(): NodeStatus;
	    /** Is the node readonly? */
	    get isReadonly(): boolean;
	    /**
	     * Is the node effectively readonly?
	     *
	     * Writable states are put in readonly mode during the execution of some rules
	     * (defaultValue, updatedValue, control, controlDelete).
	     * This accessor returns true while these rules are executed, even if the node is writable.
	     */
	    get isEffectivelyReadonly(): boolean;
	    /** Is the node writable? (opposite of isReadonly) */
	    get isWritable(): boolean;
	    /** Was the node created (rather than read)  */
	    get isNew(): boolean;
	    get isOnlyForDefaultValues(): boolean;
	    /** return the decrypted value */
	    decryptValue<K extends keyof NodeT>(propertyName: K): Promise<string>;
	    /** the _context_ in which the node was created. */
	    get context(): Context;
	    /** The state of the object at the beginning of the transaction, before any changes made to it */
	    get old(): Promise<NodeT>;
	    /** The factory that provides metadata for the node instance */
	    get factory(): NodeFactory;
	    /**
	     * The node's ID, a unique integer for all nodes of the same node class.
	     *
	     * Same as `node._id`
	     */
	    get id(): number;
	    /**
	     * The node's source ID, an ID that relates the record to the source system.
	     *
	     * Same as `node._sourceId`
	     */
	    get sourceId(): Promise<string>;
	    /**
	     * The node's layer.
	     *
	     * Same as `node._layer`
	     */
	    get layer(): Promise<number>;
	    /**
	     * The node's sort value. Only valid on vital child nodes
	     */
	    get sortValue(): Promise<integer>;
	    setSortValue(value: integer): Promise<void>;
	    /** The _createUser of the node */
	    get createdBy(): Promise<Node | number>;
	    /** The _updateUser of the node */
	    get updatedBy(): Promise<Node | number>;
	    /** The _createStamp of the node */
	    get createStamp(): Promise<datetime>;
	    /** The _updateStamp of the node */
	    get updateStamp(): Promise<datetime>;
	    /** The _syncTick of the node */
	    get syncTick(): Promise<Decimal>;
	    /** The _syncInfo of the node */
	    get syncInfo(): Promise<SyncInfo>;
	    /**
	     * The vendor. Only valid if the node has a _vendor property
	     */
	    get vendor(): Promise<Node | null>;
	    get etag(): Promise<string>;
	    get customData(): Promise<object>;
	    get valuesHash(): Promise<string>;
	    get attachments(): Collection<InternalAttachmentAssociationData & Node>;
	    getCursorValue(orderBy: OrderBy<NodeT>): Promise<string>;
	    /** Controls the node before saving it. */
	    control(): Promise<boolean>;
	    /** @deprecated Use node.$.control instead. */
	    validate(): Promise<boolean>;
	    /**
	     * Saves a newly created node or an updated node to the database.
	     * If the nodes has vital children, they are also saved.
	     * This method executes all the validation rules before saving.
	     * It throws a ValidationError and does not modify the database if some validation rules raise an error.
	     */
	    save(options?: NodeSaveOptions): Promise<void>;
	    /**
	     * `node.$.save` with a boolean return value.
	     * Returns true if node has been saved, false if some validation rules failed.
	     */
	    trySave(options?: NodeSaveOptions): Promise<boolean>;
	    /**
	     * Deletes the node.
	     *
	     * All the nodes that are related via _vital_ references or collections will also be deleted.
	     *
	     * This call triggers the `delete` rules on the node decorators and throws an error if any
	     * rule forbids the deletion.
	     * An error will also be thrown if the deletion violates foreign key constraints in the database
	     * (for example an attempt to delete a product which is referenced from sales documents).
	     */
	    delete(options?: NodeDeleteOptions): Promise<void>;
	    /**
	     * Tries to delete the node.
	     *
	     * Similar to `delete()` but returns a true value in case of success and a false value otherwise,
	     * instead of throwing an exception.
	     */
	    tryDelete(options?: NodeDeleteOptions): Promise<boolean>;
	    /**
	     * Sets multiple property values in a single call.
	     * @param data the values, as a plain object. `data` may contain values for collection properties, as arrays of plain objects
	     *
	     * Note: `node.$.set(data)` only assigns the values. It does not save the node to the database.
	     * To save the node, call `node.$.save()`.
	     *
	     * @example
	     * ```
	     * user.$.set({ lastName: 'Smith', children: [{name: 'Mary' }, {name: 'Tim'}] })
	     * ```
	     */
	    set(data: NodeUpdateData<NodeT>): Promise<void>;
	    /**
	     * Gets the value of a property, given the property name
	     */
	    getValue<ValT extends AnyValue = AnyValue, K extends PropertyName<NodeT> | '' = '', ResultT = K extends PropertyName<NodeT> ? UnPromised<NodeT[K]> & ValT : ValT>(propertyName: K | string): Promise<(ResultT & ValT) | undefined>;
	    getRawPropertyValue(propertyName: string): AnyValue;
	    getRawPropertyValues(): Dict<AnyValue>;
	    isValueDeferred(propertyName: string): boolean;
	    /**
	     * Get the natural key value as a string (concatenated with '|' if composite).
	     * Throws if the node factory does not have a natural key.
	     */
	    getNaturalKeyValue(): Promise<string>;
	    /** The key token, a string that uniquely identifies a node within its factory */
	    get keyToken(): string;
	    /**
	     * Does the node have a property with a given name
	     */
	    hasProperty(propertyName: string): boolean;
	    /**
	     * Returns whether the property is frozen
	     */
	    isPropertyFrozen(property: Property): AsyncResponse<boolean>;
	    /**
	     * The node's property values as a plain TypeScript object which may be serialized
	     * with JSON.stringify().
	     */
	    payload(options?: NodePayloadOptions<NodeT>): Promise<NodePayloadData<NodeT>>;
	    /**
	     * Untyped variant of this.payload(options?). For compat with exising code.
	     */
	    payloadAsAny<V extends Dict<any> = Dict<any>>(options?: NodePayloadOptions<NodeT>): Promise<V>;
	    isPropertyEnabled<K extends keyof NodeT>(propertyName: K): Promise<boolean>;
	    /**
	     * Return a duplicate of the node with negative _id values to create a copy
	     * Where the node is a vitalCollectionChild, remove sort value and keep parent _id
	     */
	    duplicate(data?: AnyRecord): Promise<NodeT>;
	    /**
	     * Return the value of a property from a path
	     */
	    get(path: string): Promise<AnyValue>;
	    /**
	     * Special method for x3-gateway to clear the caches
	     */
	    clearCaches(): void;
	    /**
	     * Special method used only by ItemSite.
	     * TODO: investigate why applicative code really needs this and remove if possible.
	     */
	    get isInsideCollection(): boolean;
	}
	//# sourceMappingURL=node-$.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/json-type.d.ts
declare module '@sage/xtrem-core/lib/ts-api/json-type' {
	import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
	export type JsonType<T extends AnyValue> = T extends boolean | null ? T : T extends number | null ? T : T extends Array<infer ElementT> ? ElementT extends AnyValue ? Array<JsonType<ElementT>> : never : T extends AnyRecord ? {
	    [K in keyof T]: T[K] extends AnyValue ? JsonType<T[K]> : never;
	} : string;
	//# sourceMappingURL=json-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/join.d.ts
declare module '@sage/xtrem-core/lib/ts-api/join' {
	import { AnyValue } from '@sage/xtrem-shared';
	export class JoinLiteralValue {
	    readonly value: AnyValue;
	    constructor(value: AnyValue);
	}
	//# sourceMappingURL=join.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/isolation-options.d.ts
declare module '@sage/xtrem-core/lib/ts-api/isolation-options' {
	import { IsolationLevel } from '@sage/xtrem-core/lib/decorators/index';
	/**
	 * Options for transaction isolation
	 */
	export interface IsolationOptions {
	    /** the SQL isolation level */
	    isolationLevel?: IsolationLevel;
	    /** is the transaction readonly? */
	    isReadonly?: boolean;
	    /** is the transaction deferrable? Only applies to serializable readonly transactions  */
	    isDeferrable?: boolean;
	}
	//# sourceMappingURL=isolation-options.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/index.d.ts
declare module '@sage/xtrem-core/lib/ts-api/index' {
	/// <reference types="@sage/xtrem-decimal" />
	/// <reference types="@sage/xtrem-date-time" />
	export { Time, DateValue as date, DateRange as dateRange, Datetime as datetime, DatetimeRange as datetimeRange, DecimalRange as decimalRange, IntegerRange as integerRange, } from '@sage/xtrem-date-time';
	export { Decimal, decimal } from '@sage/xtrem-decimal';
	export * from '@sage/xtrem-core/lib/ts-api/activity';
	export * from '@sage/xtrem-core/lib/ts-api/activity-extension';
	export * from '@sage/xtrem-core/lib/ts-api/collection';
	export * from '@sage/xtrem-core/lib/ts-api/create-data';
	export * from '@sage/xtrem-core/lib/ts-api/diagnose';
	export * from '@sage/xtrem-core/lib/ts-api/external-decorators';
	export * from '@sage/xtrem-core/lib/ts-api/isolation-options';
	export * from '@sage/xtrem-core/lib/ts-api/join';
	export * from '@sage/xtrem-core/lib/ts-api/json-type';
	export * from '@sage/xtrem-core/lib/ts-api/node';
	export * from '@sage/xtrem-core/lib/ts-api/node-$';
	export * from '@sage/xtrem-core/lib/ts-api/node-extension';
	export * from '@sage/xtrem-core/lib/ts-api/node-select-types';
	export * from '@sage/xtrem-core/lib/ts-api/node-status';
	export * from '@sage/xtrem-core/lib/ts-api/query-aggregate';
	export * from '@sage/xtrem-core/lib/ts-api/query-filter';
	export * from '@sage/xtrem-core/lib/ts-api/query-options';
	export * from '@sage/xtrem-core/lib/ts-api/query-order-by';
	export * from '@sage/xtrem-core/lib/ts-api/reference';
	export * from '@sage/xtrem-core/lib/ts-api/validation';
	export type integer = number;
	export type short = number;
	export type double = number;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/external-decorators.d.ts
declare module '@sage/xtrem-core/lib/ts-api/external-decorators' {
	import { Dict } from '@sage/xtrem-shared';
	import { CollectionPropertyDecorator, ColumnTypeName, NodeDecorator, NodeExtensionDecorator, PlainOperationDecorator, ReferencePropertyDecorator, TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { DataType } from '@sage/xtrem-core/lib/types/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	export interface ExternalPropertyDecorator extends TypedPropertyDescriptor<Node> {
	    name: string;
	    type: TypeName;
	    isNullable?: boolean;
	    isMandatory?: boolean;
	    isPublished?: boolean;
	    isStored?: boolean;
	    isSystemProperty?: boolean;
	    columnName?: string;
	    columnType?: ColumnTypeName;
	    dataType?: DataType<any, any>;
	}
	export type ExternalReferencePropertyDecorator = ExternalPropertyDecorator & ReferencePropertyDecorator<Node, any>;
	export type ExternalCollectionPropertyDecorator = ExternalPropertyDecorator & CollectionPropertyDecorator;
	export type ExternalOperationDecorator = PlainOperationDecorator;
	export interface ExternalNodeDecorator extends NodeDecorator {
	    name: string;
	    super?: string;
	    isVitalReferenceChild?: boolean;
	    isVitalCollectionChild?: boolean;
	    isVitalChild?: boolean;
	    properties: ExternalPropertyDecorator[];
	    queries: ExternalOperationDecorator[];
	    mutations: ExternalOperationDecorator[];
	}
	export interface ExternalNodeExtensionDecorator extends NodeExtensionDecorator<Node> {
	    name: string;
	    properties: ExternalPropertyDecorator[];
	    queries: ExternalOperationDecorator[];
	    mutations: ExternalOperationDecorator[];
	}
	export interface ExternalEnumDecorator {
	    name: string;
	    values: Dict<number>;
	}
	//# sourceMappingURL=external-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/diagnose.d.ts
declare module '@sage/xtrem-core/lib/ts-api/diagnose' {
	/** @packageDocumentation @module runtime */
	import { ValidationSeverity } from '@sage/xtrem-shared';
	export class Diagnose {
	    severity: ValidationSeverity;
	    path: string[];
	    message: string;
	    constructor(severity: ValidationSeverity, path: string[], message: string);
	    toString(): string;
	    static areEqual(d1: Diagnose, d2: Diagnose): boolean;
	}
	//# sourceMappingURL=diagnose.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/create-data.d.ts
declare module '@sage/xtrem-core/lib/ts-api/create-data' {
	import { UnPromised } from '@sage/xtrem-async-helper';
	import { integer } from '@sage/xtrem-shared';
	import { Collection } from '@sage/xtrem-core/lib/ts-api/collection';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	export enum UpdateActionEnum {
	    create = 1,
	    update = 2,
	    delete = 3
	}
	export type UpdateAction = keyof typeof UpdateActionEnum;
	export type PropertyCreateData<V> = V extends Promise<infer U> ? PropertyCreateData<U> : V extends Node ? NodeCreateData<V> | V | number | string | null : V extends Collection<infer U> ? NodeCreateData<U & {
	    _sortValue?: integer;
	    _action: UpdateAction;
	    _constructor?: string;
	}>[] : V extends any[] ? V[number] extends Node ? PropertyCreateData<V[number]>[] : V : UnPromised<V>;
	export type NodeCreateData<T extends Node> = {
	    [K in Exclude<keyof T, '$'>]?: PropertyCreateData<T[K]>;
	};
	export type NodeUpdateData<T extends Node> = NodeCreateData<T> & {
	    _action?: UpdateAction;
	};
	export type PropertyPayloadData<V> = V extends Promise<infer U> ? PropertyPayloadData<U> : V extends Node ? NodePayloadData<V> : V extends Collection<infer U> ? NodePayloadData<U & {
	    _sortValue?: integer;
	    _action: UpdateAction;
	}>[] : V extends any[] ? V[number] extends Node ? PropertyPayloadData<V[number]>[] : V : UnPromised<V extends number ? number : V>;
	export type NodePayloadData<T extends Node> = {
	    [K in Exclude<keyof T, '$'>]?: PropertyPayloadData<T[K]>;
	};
	//# sourceMappingURL=create-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/collection.d.ts
declare module '@sage/xtrem-core/lib/ts-api/collection' {
	/** @packageDocumentation @module runtime */
	import { AnyValue, AsyncArray, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
	import { NodeCreateData } from '@sage/xtrem-core/lib/ts-api/create-data';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	import { NodeQueryFilter } from '@sage/xtrem-core/lib/ts-api/query-filter';
	import { NodeQueryOptions } from '@sage/xtrem-core/lib/ts-api/query-options';
	export interface SqlWhereInterface<NodeT extends Node> {
	    sum: (callback: (node: NodeT) => AsyncResponse<number>) => AsyncResponse<number>;
	}
	export interface Collection<T extends Node> extends AsyncArray<T> {
	    joinValues: AsyncResponse<NodeQueryFilter<T>>;
	    name: string;
	    withReader<R extends AnyValue>(body: (reader: AsyncReader<T>) => R): Promise<R>;
	    fullName: string;
	    reset(): Promise<void>;
	    fill(array: NodeCreateData<T>[]): Promise<void>;
	    insert(i: number, data: NodeCreateData<T>): Promise<void>;
	    append(data: NodeCreateData<T>): Promise<void>;
	    delete(start: number, deleteCount?: number): Promise<void>;
	    query(options: NodeQueryOptions<T>): AsyncArray<T>;
	    where(condition?: (node: T) => AsyncResponse<boolean>): SqlWhereInterface<T>;
	    takeOne(condition: (node: T) => AsyncResponse<boolean>): AsyncResponse<T | null>;
	}
	//# sourceMappingURL=collection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/activity.d.ts
declare module '@sage/xtrem-core/lib/ts-api/activity' {
	import { Dict } from '@sage/xtrem-shared';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { ActivityExtension } from '@sage/xtrem-core/lib/ts-api/activity-extension';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	/**
	 * Grant the permissions on a set of activities
	 */
	export interface PermissionGrant {
	    permissions: string[];
	    on: (() => Activity)[];
	}
	/**
	 * Grant the operations from a set of nodes
	 */
	export interface OperationGrant {
	    operations: string[];
	    on?: (() => {
	        new (): Node;
	    })[];
	}
	export class InternalBaseGrant {
	    readonly type: string;
	    constructor(type: string);
	    /**
	     * Key that uniquely identifies the grant
	     */
	    get key(): string;
	    /**
	     * This is an instance of a InternalOperationGrant
	     * @returns
	     */
	    isOperationGrant(): this is InternalOperationGrant;
	    /**
	     * This is an instance of a InternalPermissionGrant
	     * @returns
	     */
	    isPermissionGrant(): this is InternalPermissionGrant;
	}
	export class InternalOperationGrant extends InternalBaseGrant {
	    readonly operation: string;
	    readonly node: string;
	    constructor(operation: string, node: string);
	    /**
	     * Key that uniquely identifies the grant
	     */
	    get key(): string;
	}
	export class InternalPermissionGrant extends InternalBaseGrant {
	    readonly permission: string;
	    readonly activity: string;
	    constructor(permission: string, activity: string);
	    /**
	     * Key that uniquely identifies the grant
	     */
	    get key(): string;
	}
	/**
	 * Represents the structure of a flattened permission
	 * {read: ['SalesOrder','SalesOrderLine']}
	 */
	export type FlattenedPermission = Dict<string[]>;
	/**
	 * Base of the definition passed into the Activity and activity extension constructors
	 */
	export interface BaseActivityDefinition {
	    permissions: string[];
	    operationGrants?: Dict<OperationGrant[]>;
	    permissionGrants?: Dict<PermissionGrant[]>;
	}
	/**
	 * definition passed into the Activity constructor
	 */
	export interface ActivityDefinition extends BaseActivityDefinition {
	    description: string;
	    node: () => {
	        new (): Node;
	    };
	    __filename: string;
	}
	export class Activity {
	    private readonly definition;
	    constructor(definition: ActivityDefinition);
	    /**
	     * Description of activity
	     */
	    get description(): string;
	    /**
	     * Node related to the activity
	     */
	    get node(): StaticThis<Node>;
	    /**
	     * Activity name derived from the file name
	     */
	    get name(): string;
	    /**
	     * list of permission of the activity
	     */
	    get permissions(): string[];
	    /**
	     * list of operationGrants of the activity
	     */
	    get operationGrants(): Dict<OperationGrant[]> | undefined;
	    /**
	     * list of operationGrants of the activity
	     */
	    get permissionGrants(): Dict<PermissionGrant[]> | undefined;
	    /**
	     * The root package of the activity
	     */
	    get package(): string;
	    /** Returns a flattened version of the permissions. For instance, in the following example:
	     *  - lookup grants lookup on the current node, but also on Sales and Purchases.
	     *  - read grants read on the current node, but also on Journal, and grants lookup on Journal and Sales.
	     * {
	     *       lookup: {
	     *           lookup: [Sales, Purchases]
	     *       },
	     *       read: {
	     *           read: [Journal],
	     *           lookup: [Journal, Sales],
	     *       }
	     * },
	     */
	    get flattenedPermissions(): Dict<FlattenedPermission>;
	    mergeExtension(activityExtension: ActivityExtension): void;
	    get internalGrants(): Dict<Dict<InternalOperationGrant | InternalPermissionGrant>>;
	    private addNodeOperation;
	    private fillFactoryGrants;
	    private addOperationGrants;
	    /**
	     * Adds grants from all children node on the vital graph
	     * @param factory
	     * @param grant
	     * @param permission
	     * @returns `true` if the grants were already added
	     */
	    private addExtendedVitalFactoriesGrants;
	    getLocalizedTitleKey(): string;
	    getPermissionLocalizedTitleKey(permission: string): string;
	}
	//# sourceMappingURL=activity.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/ts-api/activity-extension.d.ts
declare module '@sage/xtrem-core/lib/ts-api/activity-extension' {
	import { Dict } from '@sage/xtrem-shared';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { Activity, BaseActivityDefinition, OperationGrant, PermissionGrant } from '@sage/xtrem-core/lib/ts-api/activity';
	import { Node } from '@sage/xtrem-core/lib/ts-api/node';
	export interface ActivityExtensionDefinition extends BaseActivityDefinition {
	    extends: Activity;
	    __filename: string;
	}
	export class ActivityExtension {
	    private readonly definition;
	    constructor(definition: ActivityExtensionDefinition);
	    get extends(): Activity;
	    get description(): string;
	    get node(): StaticThis<Node>;
	    get permissions(): string[];
	    get operationGrants(): Dict<OperationGrant[]> | undefined;
	    get permissionGrants(): Dict<PermissionGrant[]> | undefined;
	    get filename(): string;
	}
	//# sourceMappingURL=activity-extension.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/test.d.ts
declare module '@sage/xtrem-core/lib/test/test' {
	/** @packageDocumentation @module test */
	import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { AuthConfig, Config, Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import { CookieOptions, NextFunction, Request, Response } from 'express';
	import { ExecutionResult, FormattedExecutionResult } from 'graphql';
	import { Application, ApplicationCreateOptions, ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Context, ContextOptions, ContextSource } from '@sage/xtrem-core/lib/runtime/context';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { ConditionVariable } from '@sage/xtrem-core/lib/test/condition-variable';
	import { Plugin } from '@sage/xtrem-core/lib/test/mocker';
	export { CookieOptions } from 'express';
	interface TestContextOptions extends ContextOptions {
	    /**
	     * The (optional) tenantId to use for the context
	     */
	    tenantId?: string;
	}
	/**
	 * Single interface used to populate and propagate test options
	 */
	export interface TestOptions {
	    /**
	     * The tenantId to use for the context. If not set, Test.defaultTenantId will be used
	     */
	    tenantId?: string;
	    config?: any;
	    source?: ContextSource;
	    mocks?: string[];
	    directory?: string;
	    scenario?: string;
	    today?: string;
	    now?: string;
	    user?: {
	        email: string;
	        userName?: string;
	    };
	    auth?: AuthConfig;
	    locale?: LocalizeLocale;
	    currentLegislationCode?: string;
	    skipMocks?: boolean;
	    plugins?: Plugin[];
	    testAttributes?: AnyRecord;
	    /**
	     * the list of service options required for tests
	     */
	    testActiveServiceOptions?: ServiceOption[];
	    /**
	     * Disable all CRUD notifications from triggers
	     */
	    disableAllCrudNotifications?: boolean;
	    /**
	     * Disable tenant CRUD notifications from triggers
	     */
	    disableTenantCrudNotifications?: boolean;
	    /** Do not use lazy loading of property values */
	    noLazyLoading?: boolean;
	    /** **DANGER**: This marks that the context will run SQL commands without a tenant filter regardless if they are shared tables or not. */
	    unsafeApplyToAllTenants?: boolean;
	    timeLimitAsTimestamp?: number;
	    /**
	     * An optional description for the context
	     */
	    description?: () => string;
	}
	export interface TestConfig {
	    mocks?: string[];
	    directory?: string;
	    scenario?: string;
	    testAttributes?: AnyRecord;
	}
	export interface UserTestOptions {
	    user?: string;
	    cookie?: boolean | ((name: string, val: string, options: CookieOptions) => void);
	    tenantId?: string;
	    auth?: AuthConfig;
	}
	export interface Cookie {
	    value: string;
	    options: CookieOptions;
	}
	interface ApiRouter {
	    use(cb: (req: Request, res: Response, next: NextFunction) => void): void;
	}
	type State = {
	    layers?: string[];
	    nowMock?: string;
	    application?: string;
	};
	export class Test {
	    private static _application;
	    private static _config;
	    private static _timeStubs;
	    static _schemaExists: Dict<boolean>;
	    /**
	     * The id of the default tenant used for tests
	     */
	    static readonly defaultTenantId: string;
	    static readonly defaultEmail = "unit.test@acme.com";
	    /**
	     * The name of the default tenant used for tests
	     */
	    static readonly defaultTenantName = "Tenant for tests (automatic creation)";
	    static get application(): Application;
	    static set application(application: Application);
	    /**
	     * Creates the 777...777 tenant for tests if it does not exist.
	     */
	    static ensureTestTenantExists(context: Context): Promise<void>;
	    /**
	     * Creates a committed context, bound to the tenantId used for tests, unless a specific tenantId is provided in the options.
	     */
	    static withCommittedContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestContextOptions): Promise<T>;
	    /**
	     * Creates a uncommitted context, bound to the tenantId used for tests, unless a specific tenantId is provided in the options.
	     */
	    static withUncommittedContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestContextOptions): Promise<T>;
	    /**
	     * Creates a read-only context, bound to the tenantId used for tests, unless a specific tenantId is provided in the options.
	     */
	    static withReadonlyContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestContextOptions): Promise<T>;
	    static get state(): State;
	    private static get options();
	    static cliActiveServiceOptions: ServiceOption[];
	    static isAllocationLoaded: boolean;
	    /**
	     * Update config with passed parameter
	     * @param patch
	     */
	    static patchConfig(patch: AnyRecord): void;
	    static configForTest(): Config;
	    static fixRequestMiddleWare(req: Request, res: Response, next: NextFunction): void;
	    /**
	     * Convert the passed TestOptions to ContextOptions
	     * @param options
	     */
	    static convertOptions(options: TestOptions | undefined): TestContextOptions;
	    /**
	     * Returns whether the status of a service option is enabled or not by the config.
	     * It uses the test config which may be have been patched by Test.patchConfig.
	     */
	    static isServiceOptionEnabledByTestConfig(serviceOption: ServiceOption): boolean;
	    /**
	     * Returns the list of service options which should be activated by the test.
	     *
	     * If the testActiveServiceOptions option was not set and storage is external, we return undefined.
	     * The serviceOptionManager will get the service option states from the external storage in this case.
	     *
	     * This is called by the Context constructor. The options returned by this call are set in the
	     * context but are not persisted in the database. This is an efficient way to manage the service options
	     * in all tests that use uncommitted contexts.
	     */
	    static getTestActiveServiceOptions(options?: TestOptions): ServiceOption[] | undefined;
	    /**
	     * set plugins from the passed TestOptions
	     * @param options
	     */
	    static createPlugins(options: TestOptions): TestOptions;
	    /** Preliminary steps */
	    private static preliminarySteps;
	    /**
	     * Execute the passed body with a readonly transaction
	     *  converting the passed test options to context options and applying any mocks passed
	     * @param body
	     * @param opts
	     */
	    static withContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestOptions): Promise<T>;
	    private static withMocks;
	    /**
	     * This method activates a list of service options, executes the test body, and then restores the service options
	     * to their prior state.
	     *
	     * Unlike the service options returns by Test.getTestActiveServiceOptions(options), the changes of service option
	     * states are persisted into the database.
	     * This is used by test which query the database from other contexts to get the state of service options,
	     * typically tests that activate the isDemoTenant service option.
	     */
	    static withCommittedServiceOptions<T extends AnyValue>(tenantId: string, body: () => AsyncResponse<T>, serviceOptions: ServiceOption[]): Promise<T>;
	    static withUserContext<T extends AnyValue>(body: (context: Context) => AsyncResponse<T>, options: UserTestOptions, serviceOptions?: ServiceOption[]): Promise<T>;
	    /**
	     * Execute the passed body with a readonly transaction
	     *  converting the passed test options to context options and applying any mocks passed
	     * @param body
	     * @param opts
	     */
	    /** @deprecated */
	    static readonly<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestOptions): Promise<T>;
	    /**
	     * Execute the passed body with a committed transaction
	     *  converting the passed test options to context options and applying any mocks passed
	     * @param body
	     * @param opts
	     */
	    /** @deprecated */
	    static committed<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestOptions): Promise<T>;
	    /**
	     * Execute the passed body with a uncommitted transaction
	     *  converting the passed test options to context options and applying any mocks passed
	     * @param body
	     * @param opts
	     */
	    /** @deprecated */
	    static uncommitted<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: TestOptions): Promise<T>;
	    static setup(application: Application): Promise<void>;
	    static getTestSchemaName: (dir: string) => string;
	    static getDirectory: (dir: string, fileName: string) => string;
	    static createCliApplication(options: ApplicationCreateOptions): Application;
	    static createTestApplication(options: ApplicationCreateOptions): Promise<Application>;
	    static setupApi(application: Application, apiApp: ApiRouter): Promise<Application>;
	    static initializeManagers(context: Context): void;
	    static cleanUp(application: Application): Promise<void>;
	    static applyDateMocks(options: TestOptions): void;
	    static restoreDateMocks: () => void;
	    private static withContextMocks;
	    /**
	     * Creates a condition variable.
	     * @param name the name of the condition variable (for logs)
	     * @returns the condition variable.
	     */
	    static createConditionVariable(name: string): ConditionVariable;
	    /**
	     * **WARNING:**
	     * This rolls back the transaction state cache and makes all previously cached node states stale. Please use wisely
	     *
	     * @param context
	     */
	    static rollbackCache(context: Context): Promise<void>;
	    /**
	     * Sends a graphql request to the test application.
	     */
	    static graphql<ResultT extends AnyValue>(context: Context, request: string): Promise<{
	        data: ResultT;
	    }>;
	    /** Test hacks that we should eliminate */
	    static hacks: {
	        isNodeStateUpdatable(node: Node): boolean;
	        setNodeStateUpdatable(node: Node): void;
	    };
	}
	/**
	 * graphql 16.1 preserves the error objects instead of converting them to plain objects.
	 * We convert them here to get the same result in direct in-memory calls as with HTTP transport.
	 * This facilitates error checking in unit tests.
	 */
	export function mapGraphQlResult<T extends AnyValue>(result: ExecutionResult<T>): FormattedExecutionResult<T>;
	//# sourceMappingURL=test.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/test-reset-tables.d.ts
declare module '@sage/xtrem-core/lib/test/test-reset-tables' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { ContextOptions } from '@sage/xtrem-core/lib/runtime/index';
	export abstract class TestResetTables {
	    /**
	     * This method is called at the beginning of Test.withContext.
	     * Its goal is to make sure the database is the exact mirror of the csv files contained in the layers
	     * selected for the test.
	     *
	     * CAUTION: if needed, the schema will be dropped and re-created. Nothing must be written
	     * to the database before calling this function otherwise it will be LOST.
	     *
	     * First we determine if the layers have changed since the previous test.
	     *
	     *  - If the current package, the layers or the now mock have changed, it is necessary to fully
	     *    reload the entire database.
	     *
	     *  - If not, as all the applicative tests are supposed to be enclosed within a Test.withContext block,
	     *    they are executed in uncommitted mode, so previous transactions have been rolled back.
	     *    In that case, the only step is to reset the sequences of each table dirtied by a previous test.
	     * @param contextOptions
	     */
	    static resetTestTables(application: Application, contextOptions: ContextOptions, options?: {
	        force?: boolean;
	    }): Promise<void>;
	    /**
	     * Reset the sequences for all the tables
	     * @param application
	     * @param contextOptions
	     */
	    static resetTestTableSequences(application: Application, contextOptions: ContextOptions): Promise<void>;
	    private static resetNeeded;
	    private static _resetTables;
	}
	//# sourceMappingURL=test-reset-tables.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/tables.d.ts
declare module '@sage/xtrem-core/lib/test/tables' {
	import { Node } from '@sage/xtrem-core/lib/index';
	/**
	 * Initialized constrained tables
	 * tables should be ordered entered so that the most constrained should be the last.
	 * ex. document->documentLine
	 * @param tables
	 */
	export function initTables(tables: {
	    nodeConstructor: typeof Node;
	    data: any[];
	    forceDelete?: boolean;
	}[], options?: {
	    skipUsers?: boolean;
	}): Promise<void>;
	/**
	 * Restores the db by dropping all the tables that were created by the initTables function
	 */
	export function restoreTables(): Promise<void>;
	//# sourceMappingURL=tables.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/mocker.d.ts
declare module '@sage/xtrem-core/lib/test/mocker' {
	/** @ignore */ /** */
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { AnyValue, Dict } from '@sage/xtrem-shared';
	export abstract class Plugin {
	    readonly name: string;
	    readonly path: string;
	    readonly scenario: string;
	    constructor(name: string, path: string, scenario: string);
	    mock(): any;
	}
	export class Mocker {
	    /**
	     * static attribute that stores a set of all the active mock plugins
	     */
	    private static plugins;
	    /**
	     * Add plugin to static plugin set
	     * @param plugin
	     */
	    private static addPlugin;
	    /**
	     * Execute body with passed plugins in enabled
	     * @param body
	     * @param mockerPlugins
	     */
	    static withMocks<T extends AnyValue | void>(body: () => AsyncResponse<T>, mockerPlugins?: Plugin[]): Promise<T>;
	    /**
	     * return the mock for passed module or execute the standard require of the calling module (moduleRequire)
	     * @param module
	     * @param moduleRequire
	     */
	    static get(module: string, moduleRequire: any): any;
	}
	export class AxiosPlugin extends Plugin {
	    private arrayCounter;
	    private entries;
	    /**
	     * Return the mock for the axios module
	     */
	    mock(): any;
	}
	export const mockPlugins: Dict<any>;
	//# sourceMappingURL=mocker.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/index.d.ts
declare module '@sage/xtrem-core/lib/test/index' {
	export * from '@sage/xtrem-core/lib/test/assert-utils';
	export * from '@sage/xtrem-core/lib/test/condition-variable';
	export * from '@sage/xtrem-core/lib/test/mocker';
	export * from '@sage/xtrem-core/lib/test/test';
	export * from '@sage/xtrem-core/lib/test/test-reset-tables';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/condition-variable.d.ts
declare module '@sage/xtrem-core/lib/test/condition-variable' {
	/**
	 * Utility class for tests that need synchronization between concurrent tasks
	 *
	 * See https://en.wikipedia.org/wiki/Monitor_(synchronization)#Condition_variables
	 *
	 * This is a simplistic implementation with promises.
	 * Provides only `notifyAll`, not `notify`.
	 */
	export class ConditionVariable {
	    readonly name: string;
	    /**
	     * Waits on the condition to be notified
	     */
	    wait(): Promise<void>;
	    /**
	     * Notifies all the waiters on this condition
	     */
	    notifyAll(): void;
	}
	//# sourceMappingURL=condition-variable.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/assert-utils.d.ts
declare module '@sage/xtrem-core/lib/test/assert-utils' {
	/**
	 * Special assert function to compare actual and expected values in tests.
	 *
	 * It checks if `expected` is a subset of `actual` and throws an error if not.
	 *
	 * It does not check all the members of `actual`.
	 * It only checks the ones that are present in `expected`.
	 *
	 * It supports some special syntaxes:
	 * -    if `expected` is a string starting with a tilde (`~`), it is interpreted as a regular expression
	 *      and the actual value is matched against it.
	 * -    if `expected` is the string `<<undefined>>`, it checks if the actual value is `undefined`.
	 *
	 * Note: if you want strict equality with a string starting with a tilde use ~^your_string$.
	 *
	 * Examples:
	 *  - `assertDeepPartialMatch({ a: 1, b: { c: 2, d: 3 }, e: 4  }, { a: 1, b: { d: 3 } })` passes
	 *  - `assertDeepPartialMatch({ a: 1, b: { c: 2, d: 3 }, e: 4  }, { a: 1, b: { d: 3 }, f: 5 })` does not pass.
	 *  - `assertDeepPartialMatch({ a: 'hello', b: 'world' }, { a: 'hello' , b: '~orl' })` passes
	 *  - `assertDeepPartialMatch({ a: 'hello', b: 'world' }, { a: 'hello' , b: 'orl' })` does not pass
	 *  - `assertDeepPartialMatch({ a: 'hello' }, { a: 'hello' , b: '<<undefined>>' })` passes
	 */
	export function assertDeepPartialMatch(actual: any, expected: any, message?: string): void;
	//# sourceMappingURL=assert-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/service-options/is-demo-tenant.d.ts
declare module '@sage/xtrem-core/lib/test/service-options/is-demo-tenant' {
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	export const isDemoTenant: ServiceOption;
	//# sourceMappingURL=is-demo-tenant.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/service-options/index.d.ts
declare module '@sage/xtrem-core/lib/test/service-options/index' {
	export * from '@sage/xtrem-core/lib/test/service-options/is-demo-tenant';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/user-data.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/user-data' {
	import { UserInfo } from '@sage/xtrem-core/lib/runtime/context';
	export const userData: UserInfo[];
	//# sourceMappingURL=user-data.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/tenant-manager-mock.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/tenant-manager-mock' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context, TenantInfo, TenantManager } from '@sage/xtrem-core/lib/runtime/context';
	/**
	 * A mock for TenantManager: should only be used for unit-tests
	 */
	class TenantManagerMock implements TenantManager {
	    private _tenantId;
	    private _additionalTenants;
	    set additionalTenants(tenants: TenantInfo[]);
	    ensureTenantExists(context: Context, options: {
	        customer: {
	            id: string;
	            name: string;
	        };
	        tenant: {
	            id: string;
	            name: string;
	        };
	    }): Promise<void>;
	    listTenantsIds(): string[];
	    getTenantsInfo(context: Context, tenantId?: string): TenantInfo[];
	    initializeManager(context: Context): void;
	    deleteTenant(application: Application, tenantId: string): Promise<void>;
	}
	export const tenantManagerMock: TenantManagerMock;
	export {};
	//# sourceMappingURL=tenant-manager-mock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/localization-manager-mock.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/localization-manager-mock' {
	import { LocalizationManager } from '@sage/xtrem-core/lib/runtime/context';
	/**
	 * A mock for LocalizationManager: should only be used for unit-tests
	 */
	export const localizationManagerMock: LocalizationManager;
	//# sourceMappingURL=localization-manager-mock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/index.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/index' {
	export * from '@sage/xtrem-core/lib/test/manager-mocks/access-rights-manager-mock';
	export * from '@sage/xtrem-core/lib/test/manager-mocks/data-settings-manager-mock';
	export * from '@sage/xtrem-core/lib/test/manager-mocks/localization-manager-mock';
	export * from '@sage/xtrem-core/lib/test/manager-mocks/tenant-manager-mock';
	export { userData } from '@sage/xtrem-core/lib/test/manager-mocks/user-data';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/data-settings-manager-mock.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/data-settings-manager-mock' {
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { Context, DataSettingsManager } from '@sage/xtrem-core/lib/runtime/context';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export class TestSysVendor extends Node {
	    /**
	     * the vendor's name
	     */
	    readonly name: Promise<string>;
	    /**
	     * the vendor's description
	     */
	    readonly description: Promise<string>;
	}
	/**
	 * A mock for DataSettingsManager: should only be used for unit-tests
	 */
	class DataSettingsManagerMock implements DataSettingsManager {
	    getSysVendorNode(): StaticThis<Node>;
	    sageVendorId(context: Context): number;
	    initializeManager(_context: Context): void;
	}
	export const dataSettingsManagerMock: DataSettingsManagerMock;
	export {};
	//# sourceMappingURL=data-settings-manager-mock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/test/manager-mocks/access-rights-manager-mock.d.ts
declare module '@sage/xtrem-core/lib/test/manager-mocks/access-rights-manager-mock' {
	import { Dict } from '@sage/xtrem-shared';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { AccessRightsManager, UserInfo } from '@sage/xtrem-core/lib/runtime/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export const serviceOptionsMock: Dict<ServiceOption>;
	export class TestUser extends Node {
	    readonly email: Promise<string>;
	    readonly isFirstAdminUser: Promise<boolean>;
	    readonly firstName: Promise<string>;
	    readonly lastName: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly displayName: Promise<string>;
	    readonly isAdministrator: Promise<boolean>;
	    readonly isDemoPersona: Promise<boolean>;
	    readonly isApiUser: Promise<boolean>;
	    toUserInfo(): Promise<UserInfo>;
	}
	export class TestActivity extends Node {
	    readonly name: Promise<string>;
	}
	/**
	 * A mock for AccessRightsManager: should only be used for unit-tests
	 */
	export const accessRightsManagerMock: AccessRightsManager;
	//# sourceMappingURL=access-rights-manager-mock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/system/artifact-manager.d.ts
declare module '@sage/xtrem-core/lib/system/artifact-manager' {
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { ClientArtifactUsedLiterals, LocalizedLiteral } from '@sage/xtrem-i18n';
	import { AccessStatus, Dict, MetaCustomFieldsArray, MetaCustomizableNodesArray } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeExportTemplate } from '@sage/xtrem-core/lib/runtime/core-hooks';
	import { TextStream } from '@sage/xtrem-core/lib/types/index';
	import { ApplicationArtifact, ClientArtifactMetadata, ClientArtifactType, NodeAccess, PageArtifact } from '@sage/xtrem-core/lib/system/pages/client-service';
	enum StorageStatus {
	    notStarted = 0,
	    done = 1
	}
	export enum ArtifactDataTypeEnum {
	    json = 1,
	    js = 2,
	    csv = 3,
	    ts = 4,
	    meta = 5
	}
	export type ArtifactDataType = keyof typeof ArtifactDataTypeEnum;
	export interface PackArtifactInterface {
	    packageName: string;
	    path: string;
	    content: TextStream | ClientArtifactMetadata;
	    dataType: ArtifactDataType;
	    condition: (pack: PackArtifactInterface) => boolean;
	    type?: string;
	}
	export const generateEnumKey: (e: string) => string;
	export function getArtifactDataType(fileName: string): ArtifactDataType | undefined;
	export interface ArtifactFilter {
	    packageOrPage: string;
	    exactMatch: boolean;
	    pageNode?: string;
	}
	export class ArtifactManager {
	    static progress: StorageStatus;
	    private static _applicationArtifactsByType;
	    private static _packArtifactByKey;
	    private static ensureArtifactsCachedFunnel;
	    static clearStored(): void;
	    /**
	     * Ensure that all pack artifacts of the application are cached in memory prior to retrieval
	     * This is fired once per container with an adivisory lock to avoid the artifact being inserted twice into cache.
	     *
	     * @param application
	     */
	    private static ensureArtifactsCached;
	    /**
	     * Cache a specific artifact type of the application from the file system to memory
	     * @param context
	     * @param artifactType
	     */
	    private static cacheArtifacts;
	    private static cacheArtifact;
	    private static getPackArtifactInterface;
	    static getArtifactTitle(context: Context, artifactType: ClientArtifactType, artifactEntry: ApplicationArtifact): string;
	    static getArtifactDescription(context: Context, artifactType: ClientArtifactType, artifactEntry: ApplicationArtifact): string;
	    static addUsedStringsKey(literals: ClientArtifactUsedLiterals | undefined, usedStringKeys: string[]): void;
	    /**
	     * Resolve the literals for the artifact, including the literals from the extensions and fragments
	     * @param context
	     * @param artifactType
	     * @param artifact
	     * @returns
	     */
	    static resolveArtifactStrings(context: Context, artifactType: ClientArtifactType, artifact: ApplicationArtifact): Promise<LocalizedLiteral[]>;
	    private static getArtifacts;
	    private static getJsBundles;
	    private static completeWithJsonMeta;
	    static getParsedContent(packArtifact: PackArtifactInterface): ClientArtifactMetadata;
	    /**
	     * Resolves to the customizable nodes based on the vital tree of the page node.
	     * Used by the client side to have the list of customizable nodes relevant to the page.
	     * @param context
	     * @param artifact
	     * @returns
	     */
	    static resolvePageCustomizableNodesWizard(context: Context, artifact: ApplicationArtifact): MetaCustomizableNodesArray | undefined;
	    /**
	     * A list of customizable nodes for the page, constructed from ALL the nodes used on the page.
	     * @param context
	     * @param artifact
	     * @returns
	     */
	    static resolvePageCustomizableNodes(context: Context, artifact: ApplicationArtifact): Promise<MetaCustomizableNodesArray>;
	    /**
	     * Get a dictionary of custom fields for the page, based on ALL the nodes used on the page.
	     * @param context
	     * @param artifact
	     * @returns
	     */
	    static resolvePageCustomFields(context: Context, artifact: ApplicationArtifact): Promise<MetaCustomFieldsArray | undefined>;
	    /**
	     * Get the export templates for the page, based on ALL the nodes used on the page.
	     * @param context
	     * @param artifact
	     * @returns
	     */
	    static resolvePageExportTemplatesByNode(context: Context, artifact: ApplicationArtifact): Promise<NodeExportTemplate[]>;
	    static resolvePageAccess(context: Context, artifact: ApplicationArtifact): AsyncResponse<AccessStatus>;
	    static resolveAccess(context: Context, artifact: ApplicationArtifact): Promise<NodeAccess[]>;
	    /**
	     * Convert the pack artifact to a meta pack artifact.
	     * @param context
	     * @param packArtifact
	     * @param artifactType
	     * @returns
	     */
	    private static convertToPackArtifact;
	    private static getMetaBundles;
	    /**
	     * Retrieves the artifact information for the specified key
	     * The key is the <package name>/<artifact name>
	     * Example: `@sage/xtrem-sales/SalesOrder`
	     * @param context
	     * @param key
	     * @param locale
	     * @returns
	     */
	    static getPageArtifact(context: Context, key: string): Promise<PageArtifact | null>;
	    /**
	     * Retrieves the artifact information for the specified key
	     * The key is the <package name>/<artifact name>
	     * Example: `@sage/xtrem-sales/SalesOrder`
	     * @param context
	     * @param key
	     * @param locale
	     * @returns
	     */
	    private static getArtifact;
	    /**
	     * This list search in the file system
	     * @param key
	     * @param artifactType
	     */
	    static listAllClientArtifactsFromStorage(context: Context, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
	    /**
	     * Find the artifacts for the packages that are active for the current tenant.
	     */
	    private static getPackArtifacts;
	    /**
	     * Read from file system
	     * @param key
	     * @param artifactType
	     */
	    static readClientArtifact(context: Context, artifactType: ClientArtifactType, filter: ArtifactFilter): Promise<ApplicationArtifact | null>;
	    /**
	     * Get extensions by page key
	     * @param key
	     * @param artifactType
	     */
	    static getExtensionsForPage(context: Context, key: string, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
	    static getArtifactExtensions(context: Context, key: string, artifactType: ClientArtifactType): Promise<ApplicationArtifact[]>;
	    /**
	     * Get the page fragments for the page
	     * @param context
	     * @param artifact
	     * @returns
	     */
	    static getArtifactPageFragments(context: Context, artifact: ApplicationArtifact): Promise<Dict<ApplicationArtifact>>;
	    static getArtifactNodes(context: Context, artifact: ApplicationArtifact): Promise<string[]>;
	    static queryPackArtifacts(context: Context, filter: Partial<PackArtifactInterface>): Promise<PackArtifactInterface[]>;
	    /**
	     * In the ui config there can be inclusion and exclusion globs provided,
	     *  we can use these checks to see if the artifact path conforms to the inclusion/exclusion rules
	     * Exclusions will take precedence over inclusions
	     * @param artifactPath
	     * @returns
	     */
	    private static checkArtifactWithConfig;
	    /**
	     * Iterate through all xtrem application packages and read their client artifacts.
	     * @param applications
	     * @param artifactType
	     */
	    private static readClientArtifactsFromFiles;
	}
	export {};
	//# sourceMappingURL=artifact-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/system/pages/client-service.d.ts
declare module '@sage/xtrem-core/lib/system/pages/client-service' {
	import { ClientArtifactUsedLiterals, LocalizedLiteral } from '@sage/xtrem-i18n';
	import { MetaCustomFieldsArray, MetaCustomizableNodesArray } from '@sage/xtrem-shared';
	import { AccessBinding, NodeAccessBindingStatus } from '@sage/xtrem-core/lib/graphql/security/access-bindings';
	import { ExportTemplate } from '@sage/xtrem-core/lib/runtime/core-hooks';
	import { TextStream } from '@sage/xtrem-core/lib/types/index';
	export interface ClientArtifactMetadata extends MetaPackArtifact {
	    className: string;
	    md5?: string;
	}
	interface PackageArtifact {
	    key: string;
	    packageName: string;
	    content: TextStream;
	    artifactFilePath: string;
	}
	export interface ApplicationArtifact extends ClientArtifactMetadata, PackageArtifact {
	    extensions?: string[];
	    plugins?: string[];
	    menuItem?: string;
	    priority?: number;
	    strings?: LocalizedLiteral[];
	}
	export interface JsPackArtifact extends PackageArtifact {
	    className: string;
	    plugins?: string[];
	    menuItem?: string;
	    priority?: number;
	    literals?: ClientArtifactUsedLiterals;
	    type?: string;
	}
	export interface MetaPackArtifact {
	    title?: string;
	    authorizationCode?: string;
	    pageAccess?: AccessBinding;
	    pageNode?: string;
	    extensionAccess?: AccessBinding;
	    category?: string;
	    group?: string;
	    categoryLabel?: string;
	    type?: string;
	    extends?: string;
	    plugins?: string[];
	    fragments?: string[];
	    menuItem?: string;
	    parentMenuItem?: string;
	    priority?: number;
	    listIcon?: string;
	    description?: string;
	    duplicateBindings?: string[];
	    literals?: ClientArtifactUsedLiterals;
	    nodes?: string[];
	}
	export interface MetaCustomFields {
	    customizableNodesWizard?: MetaCustomizableNodesArray;
	    customizableNodes?: MetaCustomizableNodesArray;
	    customFields?: MetaCustomFieldsArray;
	}
	export enum ClientArtifactType {
	    pages = "pages",
	    widgets = "widgets",
	    stickers = "stickers",
	    strings = "strings",
	    pageExtensions = "page-extensions",
	    pageFragments = "page-fragments"
	}
	export interface NodeAccess {
	    node: string;
	    bindings: NodeAccessBindingStatus[];
	}
	export interface PageArtifact {
	    pageNode?: string;
	    pageAccess?: AccessBinding;
	    authorizationCode?: string;
	    exportTemplates?: ExportTemplate[];
	}
	export type ArtifactType = ApplicationArtifact | PageArtifact | null;
	export {};
	//# sourceMappingURL=client-service.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/synchronization/sync-info.d.ts
declare module '@sage/xtrem-core/lib/synchronization/sync-info' {
	/// <reference types="@sage/xtrem-decimal" />
	import { decimal } from '@sage/xtrem-shared';
	/**
	 * Data which is stored in the _syncInfo property of a sync target record.
	 */
	export interface SyncInfo {
	    /** _syncTick of the source record */
	    sourceSyncTick: decimal;
	    /** _updateStamp of the source record (as a string as is comes from JSON) */
	    sourceUpdateStamp: string;
	}
	//# sourceMappingURL=sync-info.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/index.d.ts
declare module '@sage/xtrem-core/lib/sql/index' {
	export * from '@sage/xtrem-core/lib/sql/chores/index';
	export * from '@sage/xtrem-core/lib/sql/mapper/index';
	export * from '@sage/xtrem-core/lib/sql/schema/index';
	export * from '@sage/xtrem-core/lib/sql/sql-context/index';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/types-conversion.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/types-conversion' {
	import { ColumnDefinition, SqlCreateTableOptions } from '@sage/xtrem-postgres';
	import { ParseColumnDefinitionResult, PostgreSqlColumnType, PostgreSqlTypes, PostgreSqlTypesToXtrem, XtremToPostgreSqlType } from '@sage/xtrem-core/lib/sql/sql-context/types';
	export const xtremToPostgreSql: XtremToPostgreSqlType;
	export const postgreSqlToXtrem: PostgreSqlTypesToXtrem;
	/**
	 * Returns the storage size needed to store a string in encrypted mode
	 * (encrypted strings are longer than decrypted string)
	 */
	export function getEncryptedStringStorageSize(maxLength: number): number;
	/**
	 * Returns the SQL default value to apply to non nullable self references
	 * currval(pg_get_serial_sequence('<schemaName>.<rootTablename>'::text, '_id'::text)::regclass)
	 */
	export function getSqlCurrvalOfIdSequence(rootTableFullName: string): string;
	/**
	 * Get the SQL clause (WITHOUT the 'DEFAULT' keyword) to apply to a column to create it's default value.
	 * Will return undefined if the column does not need any SQL default value.
	 * @param tableName
	 * @param column
	 * @param type
	 * @returns
	 */
	export function getColumnSqlDefaultClause(column: ColumnDefinition, type?: PostgreSqlColumnType): string | undefined;
	/**
	 * Parses a columnDefinition into easy to use informations
	 * @param tableName
	 * @param column
	 * @param options
	 * @returns
	 */
	export function parseColumnDefinition(schemaName: string, tableName: string, column: ColumnDefinition, options?: SqlCreateTableOptions): ParseColumnDefinitionResult;
	export function getPostgreSqlType(colDef: ColumnDefinition): PostgreSqlColumnType;
	export function getColumnDefaultValue(columnType: PostgreSqlTypes): any;
	//# sourceMappingURL=types-conversion.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/naming.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/naming' {
	/**
	 * Ensure that the passed string, name, is at most 63 characters long
	 * When the string is longer, return a new string with the following structure:
	 *      First 5 characters of original string + _ +
	 *      MD5 hash of original string (32 characters) + _ +
	 *      The last 24 characters of the original string
	 * @param name
	 * @returns Original name, or new string with maximum 63 characters when longer than 63
	 */
	export function makeName63(name: string): string;
	/**
	 * Ensure that the passed string, name, is within the maxLength limit
	 * When the string is longer than the limit, return a new string with an MD5 hash (32 characters) at the end
	 * of the string and the original content as the start of the string, concatenated to the maxLength limit
	 * @param name
	 * @param maxLength
	 * @returns Original or new string within the maxLength limit
	 */
	export function makeNameLimit(name: string, maxLength: number): string;
	//# sourceMappingURL=naming.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/keywords.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/keywords' {
	export const keywords: string[];
	export const keywordsRegExp: RegExp;
	//# sourceMappingURL=keywords.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/functions.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/functions' {
	export function createFunctions(schemaName: string, createFromSql: (sql: string) => Promise<void>): Promise<void>;
	//# sourceMappingURL=functions.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/extensions.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/extensions' {
	export function createExtensions(createFromSql: (sql: string) => Promise<void>): Promise<void>;
	//# sourceMappingURL=extensions.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/update-table-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/update-table-trigger-builder' {
	export {};
	//# sourceMappingURL=update-table-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/update-shared-table-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/update-shared-table-trigger-builder' {
	export {};
	//# sourceMappingURL=update-shared-table-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/trigger-builder' {
	import { TableDefinition, TriggerDefinition, TriggerEventType, TriggerTimingType } from '@sage/xtrem-postgres';
	export interface TriggerBuilderParams {
	    when: TriggerTimingType;
	    event: TriggerEventType;
	    options?: string;
	    functionParametersProvider?: (tableDef: TableDefinition) => string;
	}
	/**
	 * A trigger builder is used to manage triggers in database (create/drop).
	 */
	export class TriggerBuilder {
	    protected readonly name: string;
	    private static _builders;
	    protected readonly when: TriggerTimingType;
	    protected readonly event: TriggerEventType;
	    protected readonly options?: string;
	    protected readonly functionParametersProvider?: (tableDef: TableDefinition) => string;
	    protected constructor(name: string, params: TriggerBuilderParams);
	    private static _getKey;
	    get key(): string;
	    /**
	     * Create (and register) a table trigger (insert/update/delete base/...)
	     */
	    static createTableTriggerBuilder(name: string, params: TriggerBuilderParams): TriggerBuilder;
	    /**
	     * Register a trigger builder
	     */
	    static registerBuilder(triggerBuilder: TriggerBuilder): TriggerBuilder;
	    /**
	     * Get a trigger builder (already registered with registerBuilder() function)
	     */
	    static getBuilder(name: string, when: TriggerTimingType, event: TriggerEventType, options?: string): TriggerBuilder;
	    /**
	     * Returns the registered builder that can manage the provided trigger definition
	     */
	    static getBuilderForTrigger(trigger: TriggerDefinition): TriggerBuilder;
	    /**
	     * Returns the SQL command to execute to create the trigger.
	     */
	    getSqlToCreateTrigger(tableDef: TableDefinition): string;
	    getFunctionParameters(tableDef: TableDefinition): string;
	    /**
	     * Return the definition of the trigger
	     */
	    getDefinition(tableDef: TableDefinition): TriggerDefinition;
	    /**
	     * Returns the full name (including the schema name) of the function that will be executed by the trigger.
	     */
	    getFunctionFullname(tableDef: TableDefinition): string;
	    /**
	     * Indicates whether the trigger uses a dedicated function (that should be created
	     * when the trigger is created and dropped when the trigger is dropped).
	     * Should return false if the trigger uses a common function (insert_table, ...)
	     */
	    get useDedicatedFunction(): boolean;
	    /**
	     * Returns the SQL command to execute to create the dedicated function that will be called by the trigger (if any)
	     * Will return undefined when the trigger is using a common function (insert_table, ...).
	     * Must be in sync with useDedicatedFunction.
	     */
	    getSqlToCreateDedicatedFunction(tableDef: TableDefinition): string | undefined;
	    /**
	     * The SQL command to drop the trigger and its dedicated function (if any)
	     * @param tableDef
	     * @returns
	     */
	    getSqlToDrop(tableDef: TableDefinition): string;
	}
	//# sourceMappingURL=trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/set-sync-tick-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/set-sync-tick-trigger-builder' {
	export {};
	//# sourceMappingURL=set-sync-tick-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/notify-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/notify-trigger-builder' {
	export {};
	//# sourceMappingURL=notify-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/insert-table-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/insert-table-trigger-builder' {
	export {};
	//# sourceMappingURL=insert-table-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/insert-shared-table-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/insert-shared-table-trigger-builder' {
	export {};
	//# sourceMappingURL=insert-shared-table-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/index.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/index' {
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/delete-attachments-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/delete-base-node-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/insert-shared-table-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/insert-table-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/notify-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/update-shared-table-trigger-builder';
	export * from '@sage/xtrem-core/lib/sql/statements/triggers/update-table-trigger-builder';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/delete-base-node-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/delete-base-node-trigger-builder' {
	import { TriggerBuilder } from '@sage/xtrem-core/lib/sql/statements/triggers/trigger-builder';
	export const deleteBaseNodeTriggerBuilder: TriggerBuilder;
	//# sourceMappingURL=delete-base-node-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/statements/triggers/delete-attachments-trigger-builder.d.ts
declare module '@sage/xtrem-core/lib/sql/statements/triggers/delete-attachments-trigger-builder' {
	export {};
	//# sourceMappingURL=delete-attachments-trigger-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/update-table-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/update-table-context' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	interface TableOptions {
	    errorsAsWarnings: boolean;
	    isShared?: boolean;
	}
	interface SqlResult {
	    success: boolean;
	    rowCount: number;
	}
	export class UpdateSqlContext extends SchemaSqlContext {
	    protected application: Application;
	    constructor(application: Application);
	    /**
	     * Tries to update a table and returns whether the update succeeded
	     */
	    updateTable(context: Context, name: string, dataToUpdate: {
	        columnName: string;
	        value: any;
	    }[], options?: TableOptions): Promise<SqlResult>;
	    /**
	     * Tries to delete a table and returns whether the drop succeeded
	     */
	    deleteFromTable(context: Context, name: string, options?: TableOptions): Promise<SqlResult>;
	    deleteFromTables(context: Context, tablesToDelete: string[], options?: TableOptions): Promise<SqlResult>;
	}
	export {};
	//# sourceMappingURL=update-table-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/types.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/types' {
	export abstract class ColumnInconsistency {
	    private readonly _description;
	    constructor(_description: string);
	    get description(): string;
	}
	export class ColumnInconsistencyNullable extends ColumnInconsistency {
	    constructor(oldNullableFlag: boolean, newNullableFlag: boolean);
	}
	/**
	 * The SQL default value (int the database) differs to what it should be from the decorators
	 */
	export class ColumnInconsistencyDefaultValue extends ColumnInconsistency {
	    constructor(oldDefaultValue?: string, newDefaultValue?: string);
	}
	export class ColumnInconsistencyType extends ColumnInconsistency {
	    readonly options: {
	        fromType: string;
	        toType: string;
	        conversionType: string;
	    };
	    constructor(description: string, options: {
	        fromType: string;
	        toType: string;
	        conversionType: string;
	    });
	}
	//# sourceMappingURL=types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/sql-context' {
	/** @module @sage/xtrem-postgres */
	import { AnyValue, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Connection, ConnectionPool, PoolClient, PoolConfig, PoolLoggerInterface, PostgresPoolReaderOptions, PostgresSqlExecuteOptions, TableDefinition } from '@sage/xtrem-postgres';
	import { SqlErrorMessageType } from '@sage/xtrem-core/lib/sql/sql-context/types';
	interface ExecuteSqlParameters {
	    cnx?: Connection;
	    sql: string;
	    args?: any[];
	    opts?: PostgresSqlExecuteOptions;
	}
	type ContextConnectionPoolType = 'user' | 'sys';
	export class SqlContext {
	    protected lockId?: number | undefined;
	    readonly config: PoolConfig;
	    /**
	     * Creates a new instance of the SqlContext
	     * @param lockId the lock number (must be unique and randomly generated)
	     * @param poolType the pool type: 'sys' or 'user'
	     */
	    constructor(lockId?: number | undefined, poolType?: ContextConnectionPoolType);
	    static get logger(): PoolLoggerInterface;
	    protected withAdvisoryLock<T extends AnyValue>(body: (cnx: Connection) => AsyncResponse<T>, client?: Connection): Promise<T>;
	    private withAdvisoryLockCnx;
	    get connectionPool(): ConnectionPool;
	    execute<T extends AnyValue | void>(cnx: Connection, sql: string, args?: any[], opts?: PostgresSqlExecuteOptions): Promise<T>;
	    withConnection<T extends AnyValue | void>(body: (cnx: Connection) => AsyncResponse<T>, connection?: PoolClient): Promise<T>;
	    createReader<T extends AnyValue>(cnx: Connection, sql: string, args: any[], opts?: PostgresPoolReaderOptions): AsyncReader<T>;
	    executeSqlStatement<T extends AnyValue | void>(params: ExecuteSqlParameters): Promise<T>;
	    get user(): string;
	    /**
	     * Returns string containing parameter with passed index i
	     * @param i
	     */
	    static param(i: number): string;
	    /**
	     * Formats a column name with double quotes
	     *
	     * @see https://www.postgresql.org/docs/13/sql-syntax-lexical.html
	     *
	     * @param name
	     */
	    static escape(name: string): string;
	    /**
	     * Checks if passed error is an index not found error
	     * @param err
	     */
	    static isIndexNotFound(ex: Error): boolean;
	    /**
	     * Checks if passed error is a table not found error
	     * @param err
	     */
	    static isTableNotFound(ex: Error): boolean;
	    /**
	     * Checks if passed error is a unique contraint violation
	     * @param err
	     */
	    static isUniqueViolated(ex: Error): boolean;
	    /**
	     * Checks if passed error is a locked record error
	     * @param err
	     */
	    static isLocked(ex: Error): boolean;
	    /**
	     * Checks if passed error is a no data found error
	     * @param err
	     */
	    static isNoRecord(ex: Error): boolean;
	    /**
	     * Return the full qualified table name based on the passed table definition
	     * @param def
	     */
	    static getFullTableDefName(tableDef: TableDefinition): string;
	    /**
	     *  Return the full qualified table name based on the passed schema, table name and alias
	     * @param schemaName
	     * @param tableName
	     * @param alias
	     */
	    static getFullTableName(schemaName: string, tableName: string, alias?: string): string;
	    /**
	     * Returning message error according to the type.
	     * The type as will as its options should be defined in SqlErrorMessageType
	     * @param type
	     * @param options
	     */
	    static sqlErrorMessage(type: keyof SqlErrorMessageType, options: SqlErrorMessageType[keyof SqlErrorMessageType]): string;
	}
	export {};
	//# sourceMappingURL=sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/sequence-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/sequence-sql-context' {
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/index';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/**
	 * Options for fixing a sequence
	 */
	interface FixAutoIncrementSequenceOptions {
	    /**
	     * Max value that we have inserted
	     */
	    newMaxValue?: number;
	}
	export class SequenceSqlContext extends SchemaSqlContext {
	    readonly tableName: string;
	    /** @disabled_internal */
	    constructor(application: Application, tableName: string);
	    private getSequenceName;
	    private alterSequence;
	    nextSequence(columnName: string): Promise<number>;
	    private getNextSequence;
	    private getNextSequenceByColumnName;
	    /**
	     * Fix the sequence used by an auto-increment column
	     * @param column The auto-increment
	     * @param options
	     */
	    fixAutoIncrementSequence(tenantId: string | null, column: string, options?: FixAutoIncrementSequenceOptions): Promise<void>;
	    /**
	     * Fix the sequences of the bound table
	     * @param columns list of auto-increment columns
	     * @param options
	     */
	    fixAutoIncrementSequences(tenantId: string | null, columns: string[], options?: FixAutoIncrementSequenceOptions): Promise<void>;
	    private dropSequence;
	    /**
	     * Drop the sequence used by an auto-increment column
	     * @param column The auto-increment
	     * @param options
	     */
	    dropAutoIncrementSequence(column: string): Promise<void>;
	    /**
	     * Fix the sequences of the bound table
	     * @param columns list of auto-increment columns
	     * @param options
	     */
	    dropAutoIncrementSequences(columns: string[]): Promise<void>;
	}
	export {};
	//# sourceMappingURL=sequence-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/schema-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context' {
	import { ColumnJsonComment } from '@sage/xtrem-postgres';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { SqlContext } from '@sage/xtrem-core/lib/sql/sql-context/sql-context';
	interface DropTableOptions {
	    isCascade: boolean;
	    errorsAsWarnings: boolean;
	}
	export class SchemaSqlContext extends SqlContext {
	    protected application: Application;
	    constructor(application: Application);
	    get schemaName(): string;
	    createSchema(): Promise<void>;
	    dropSchema(schemaName?: string): Promise<void>;
	    renameSchema(oldName: string, newName: string): Promise<void>;
	    createFunctions(): Promise<void>;
	    createExtensions(): Promise<void>;
	    /**
	     * Verifies that the supplied table name exists in the supplied schema
	     * @param name
	     */
	    tableExists(tableName: string): Promise<boolean>;
	    /**
	     * Tries to drop a table and returns whether the drop succeeded
	     */
	    dropTable(name: string, options?: DropTableOptions): Promise<boolean>;
	    dropTables(tablesToDrop: string[], options?: DropTableOptions): Promise<boolean>;
	    updateColumnType(tableName: string, columnName: string, typeName: string, columnComment: ColumnJsonComment, options: {
	        using?: string;
	        dropDefault?: boolean;
	    }): Promise<void>;
	}
	export {};
	//# sourceMappingURL=schema-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/read-table-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/read-table-sql-context' {
	import { SqlReadTableSchemaOptions, TableDefinition } from '@sage/xtrem-postgres';
	import { Dict } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/index';
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	/**
	 * Returns whether a column name matches a system column
	 * @param colName
	 */
	export function isSystemColumn(colName: string): boolean;
	/**
	 * Returns the table definition of a table (from its name)
	 */
	export function readTableSchema(context: Context, tableName: string, options: SqlReadTableSchemaOptions): Promise<TableDefinition>;
	/**
	 * Returns the table definitions of all the provided tables (from thier name) or all the table if no name is provided
	 */
	export function readTableSchemas(context: Context, tableNames: string[], options: SqlReadTableSchemaOptions): Promise<Dict<TableDefinition>>;
	/**
	 * Returns the tables in the database for the application schema
	 */
	export function readTablesForSchema(context: Context): Promise<string[]>;
	export class ReadTableSqlContext extends SchemaSqlContext {
	    readSchema(tableName: string, options?: SqlReadTableSchemaOptions): Promise<TableDefinition>;
	    private _getOrInitTableDef;
	    /**
	     * Read all the tables of the schema
	     * @returns list of tables
	     */
	    readTablesForSchema(): Promise<string[]>;
	    /**
	     *
	     * @param tableNames if [], will return the table definitions for all the tables, in a row
	     * @param options
	     * @returns
	     */
	    readTableDefinitions(tableNames: string[], options?: SqlReadTableSchemaOptions): Promise<Dict<TableDefinition>>;
	    /**
	     * Completes a set of tableDef with their comments (table, columns, ...)
	     * @param tableDef
	     */
	    private _fillComments;
	    private _fillUpColumnDefinitionForEnums;
	    /**
	     * Parses a SQL row to a columnDefinition (refer to fillColumnInfos to get the format of the SQL row)
	     * @param rrow
	     * @returns
	     */
	    private _sqlRowToColumnDefinition;
	    private fillColumnInfos;
	    private static _transformSqlArgs;
	    private fillIndexInfos;
	    private _fillForeignKeyInfo;
	    private fillTableTriggers;
	}
	//# sourceMappingURL=read-table-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/modify-table-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/modify-table-sql-context' {
	import { PoolClient, SqlCreateTableOptions, SqlObjectJsonComment, TableDefinition, TriggerDefinition } from '@sage/xtrem-postgres';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	export class ModifyTableSqlContext extends SchemaSqlContext {
	    readonly tableDef: TableDefinition;
	    /** @disabled_internal */
	    constructor(application: Application, tableDef: TableDefinition);
	    private createTableFromTableDefinitionWithConnection;
	    createTableFromTableDefinition(options?: SqlCreateTableOptions): Promise<void>;
	    createTemporaryTable(context: Context): Promise<void>;
	    /**
	     *  Give a user the 'select/update/insert/delete' rights to a table
	     */
	    giveUserRightsToTable(login: string): Promise<void>;
	    /**
	     * Create a bunch of triggers from their definition
	     */
	    createTriggers(triggers: TriggerDefinition[], client?: PoolClient): Promise<void>;
	    /**
	     * Drop a bunch of triggers from their definition
	     */
	    dropTriggers(triggers: TriggerDefinition[], client?: PoolClient): Promise<void>;
	    private get tableName();
	    private createTableColumns;
	    private createPrimaryKey;
	    /**
	     * Returns the SQL query to execute to add/update a comment on a table or a column
	     */
	    static getSqlToComment(objectType: 'table' | 'column' | 'foreignKey', objectInfo: {
	        schemaName: string;
	        tableName: string;
	        columnName?: string;
	        fkName?: string;
	    }, comment: SqlObjectJsonComment): string;
	    private getSqlToRenameForeignKey;
	    private getSqlToCreateForeignKey;
	    private getSqlToCreateForeignKeys;
	    private createTableIndexes;
	    private getSqlToCreateIndexFunctions;
	    /**
	     * Returns the SQL statement that must be executed to add a column
	     */
	    private getSqlToAddColumn;
	    private computeDeferredDefaultSql;
	    /**
	     * Returns the SQL statement that must be executed to alter a column
	     */
	    private getSqlToAlterColumn;
	    /**
	     * Returns the SQL query to execute to update a set of columns
	     */
	    private getSqlToAlterColumns;
	    private getSqlToDropColumns;
	    private getSqlToDropForeignKey;
	    private getSqlToCreateIndex;
	    private getSqlToDropIndex;
	}
	//# sourceMappingURL=modify-table-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/index.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/index' {
	export { getColumnSqlDefaultClause, getSqlCurrvalOfIdSequence, parseColumnDefinition, } from '@sage/xtrem-core/lib/sql/statements/types-conversion';
	export * from '@sage/xtrem-core/lib/sql/sql-context/database-manager';
	export { DatabaseSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/database-sql-context';
	export { EnumSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/enum-sql-context';
	export { ModifyTableSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/modify-table-sql-context';
	export { ReadTableSqlContext, isSystemColumn, readTableSchema, readTableSchemas, readTablesForSchema, } from '@sage/xtrem-core/lib/sql/sql-context/read-table-sql-context';
	export { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	export { SequenceSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/sequence-sql-context';
	export { SqlContext } from '@sage/xtrem-core/lib/sql/sql-context/sql-context';
	export * from '@sage/xtrem-core/lib/sql/sql-context/types';
	export { UpdateSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/update-table-context';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/enum-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/enum-sql-context' {
	import { EnumType } from '@sage/xtrem-core/lib/types/index';
	import { SchemaSqlContext } from '@sage/xtrem-core/lib/sql/sql-context/schema-sql-context';
	export class EnumSqlContext extends SchemaSqlContext {
	    /**
	     * create new enum datatypes
	     */
	    createEnumTypes(types: EnumType[]): Promise<void>;
	    /**
	     * create a new enum datatype
	     */
	    private createEnumTypeSql;
	    /**
	     * get list of all enum types in the schema
	     */
	    listAllEnumTypes(): Promise<{
	        enumTypeName: string;
	        enumValues: string;
	    }[]>;
	    /**
	     * get in which table and column enum type is used.
	     * @returns
	     */
	    listEnumTypesUsage(enumTypeName?: string): Promise<{
	        enumTypeName: string;
	        tableName: string;
	        columnName: string;
	    }[]>;
	    enumTypeExists(typeName: string): Promise<boolean>;
	    /**
	     *
	     * @param options
	     *  restrict: Refuse to drop the type if any objects depend on it. This is the default.
	     *  cascade: Automatically drop objects that depend on the type (such as table columns, functions, and operators), and in turn all objects that depend on those objects (see Section 5.14).
	     */
	    dropEnum(typeName: string, options?: {
	        cascade?: boolean;
	        restrict?: boolean;
	    }): Promise<void>;
	    /**
	     * rename attribute value of an enum type
	     * @param options
	     */
	    renameEnumAttributes(typeName: string, options: {
	        oldValue: string;
	        newValue: string;
	    }): Promise<void>;
	    /**
	     * add attribute to an existing enum type
	     * @param options
	     */
	    addAttributesToEnum(typeName: string, options: {
	        newValue: string;
	        position?: {
	            after?: string;
	            before?: string;
	        };
	    }): Promise<void>;
	    /**
	     * rename enum type name
	     * @param newTypeName
	     */
	    renameEnumType(typeName: string, newTypeName: string): Promise<void>;
	    /**
	     * Drop enum attribute
	     * https://stackoverflow.com/questions/25811017/how-to-delete-an-enum-type-value-in-postgres
	     
	     * @param options
	     */
	    dropEnumAttributes(typeName: string, attributesToRemove: {
	        memberName: string;
	        replacement: string | null;
	    }[]): Promise<void>;
	    /**
	     * get enum attributes values
	     */
	    getEnumAttributes(typeName: string): Promise<string>;
	    static getEnumCoalesceFunctionName(enumName: string): string;
	    private doesEnumCoalesceFunctionExist;
	    static getSqlToCreateEnumCoalesceFunction(schemaName: string, enumName: string, paramEnumName?: string): string;
	    static getSqlToDropEnumCoalesceFunction(schemaName: string, enumName: string, paramEnumName?: string): string;
	}
	//# sourceMappingURL=enum-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/database-sql-context.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/database-sql-context' {
	import { SqlContext } from '@sage/xtrem-core/lib/sql/sql-context/sql-context';
	export class DatabaseSqlContext extends SqlContext {
	    private databaseService;
	    /**
	     * @param force force reset database user and schema if they exist
	     */
	    constructor();
	    /**
	     * Drops the database if it exists
	     * Note: it won't drop the database if it is the sys database (we should never drop the sys database)
	     */
	    dropDatabaseIfExists(): Promise<void>;
	    /**
	     * Create database
	     * @param force force reset database user and schema if they exist
	     */
	    createDatabaseIfNotExists(): Promise<void>;
	    /**
	     * Rename a schema
	     */
	    renameSchema(oldName: string, newName: string): Promise<void>;
	    /**
	     * Create schema
	     */
	    createSchemaIfNotExists(schemaName: string): Promise<void>;
	    /**
	     * Create schema
	     * @param schemaName
	     */
	    dropSchemaIfExists(schemaName: string): Promise<void>;
	}
	//# sourceMappingURL=database-sql-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/sql-context/database-manager.d.ts
declare module '@sage/xtrem-core/lib/sql/sql-context/database-manager' {
	import { ConnectionPool, DatabaseService, PoolConfig } from '@sage/xtrem-postgres';
	export abstract class DatabaseManager {
	    static getDatabaseService(config: PoolConfig): DatabaseService;
	    static getSysPool(config: PoolConfig): ConnectionPool;
	    static getPool(config: PoolConfig): ConnectionPool;
	}
	//# sourceMappingURL=database-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/utils.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/utils' {
	import { IndexColumn } from '@sage/xtrem-postgres';
	export type DataDiagnosisSeverity = 'info' | 'warn' | 'error';
	export type DataDiagnosisCategory = 'autofix';
	export interface DataDiagnosis {
	    severity: DataDiagnosisSeverity;
	    category: DataDiagnosisCategory;
	    message: string;
	}
	/**
	 * @disabled_internal
	 *
	 * Note: indexDefinition is sth like
	 *  CREATE INDEX delete_columns_node__tenant_id_idx ON xtrem_core_test.delete_columns_node USING btree (_tenant_id, name_1 DESC, name_2, name_3 DESC)
	 *  or
	 *  CREATE UNIQUE INDEX table_1_ind0 ON xtrem.table_1 USING btree (name, xtrem.col_1_enum_coalesce(col_1))
	 *  or
	 *  CREATE UNIQUE INDEX table_1_ind1 ON xtrem.table_1 USING btree (name, coalesce(col_ref_1, (0)::bigint)))
	 */
	export function parseIndexDefinition(indexName: string, indexDefinition: string): IndexColumn[];
	//# sourceMappingURL=utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/table.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/table' {
	/** @ignore */ /** */
	import { AnyRecord } from '@sage/xtrem-async-helper';
	import { ColumnDefinition, ForeignKeyDefinition, ForeignKeyOptions, IndexDefinition, SqlCreateTableOptions, TableDefinition, TableJsonComment, TriggerDefinition } from '@sage/xtrem-postgres';
	import { Dict } from '@sage/xtrem-shared';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context, ContextOptions, NodeFactory, NodeIndex } from '@sage/xtrem-core/lib/runtime/index';
	import { EnumType } from '@sage/xtrem-core/lib/types/index';
	import { SqlInsertOptions } from '@sage/xtrem-core/lib/sql/mapper/sql-insert';
	import { RecordUpdateOptions } from '@sage/xtrem-core/lib/sql/mapper/sql-update';
	import { ColumnInconsistency, DropTableOptions, SqlAddColumnsOptions } from '@sage/xtrem-core/lib/sql/sql-context/types';
	import { Column } from '@sage/xtrem-core/lib/sql/schema/column';
	import { ForeignKey } from '@sage/xtrem-core/lib/sql/schema/foreign-key';
	import { PrimaryKey } from '@sage/xtrem-core/lib/sql/schema/primary-key';
	export enum TestStatus {
	    loaded = 0,
	    modified = 1
	}
	/**
	 * The result of a call to fixForeignKeys
	 */
	export type FixForeignKeysResult = {
	    /** The number of created FKs */
	    createdFks: number;
	    /** The number of renamed FKs */
	    renamedFks: number;
	    /** The number of re-created FKs */
	    recreatedFks: number;
	};
	/** @disabled_internal */
	export class Table {
	    factory: NodeFactory;
	    columns: Column[];
	    foreignKeys: ForeignKey[];
	    columnsByPropertyName: Dict<Column>;
	    columnsByColumnName: Dict<Column>;
	    verified: boolean;
	    isSharedByAllTenants: boolean;
	    testStatus: TestStatus;
	    testLayers: string[];
	    testNowMock: string;
	    testDir: string;
	    constructor(decorators: TableDecorators);
	    /** The name of the table, provided by its factory */
	    get name(): string;
	    /** The name of the SQL table */
	    get sqlTableName(): string;
	    getFullTableName(context: Context, alias?: string): string;
	    /**
	     * Returns the table of the baseClass (if any)
	     */
	    get baseTable(): Table | undefined;
	    /**
	     * Returns the table of the rootClass
	     * The rootClass is the lowest level subNode
	     * cat->mammal->animal
	     * mammal will be the base table of cat
	     * animal will be the root table of cat
	     */
	    get rootTable(): Table;
	    get primaryKey(): PrimaryKey;
	    get uniqueIndexes(): PrimaryKey[];
	    get databaseComputedColumnNames(): readonly string[];
	    getColumns(options?: {
	        inherit?: boolean;
	        includeSystemColumns?: boolean;
	        skipLazyLoadableColumns?: boolean;
	    }): Column[];
	    /**
	     * Returns the JSON comment that must be put on the table (in the database)
	     */
	    getJsonComment(): TableJsonComment;
	    /**
	     * Returns the tableDefinition that matches the metadata of this table.
	     * WARNING: it may not return the same result as the SQL metadata if the table in the database
	     * is not in sync with the definition of the table.
	     * @param context
	     */
	    getTableDefinition(context: Context): TableDefinition;
	    private getNotifyOptions;
	    private getSqlExpressionTemplateForPayloadValue;
	    dropTable(context: Context, options?: DropTableOptions): Promise<void>;
	    createTable(context: Context, options?: SqlCreateTableOptions): Promise<void>;
	    private getModifyTableSqlContext;
	    /**
	     * Create a bunch of triggers from their definition
	     */
	    createTriggers(context: Context, triggers: TriggerDefinition[]): Promise<void>;
	    /**
	     * Drop a bunch of triggers from their definition
	     */
	    dropTriggers(context: Context, triggers: TriggerDefinition[]): Promise<void>;
	    ensureTableExists(context: Context, options?: SqlCreateTableOptions): Promise<void>;
	    ensureAllTableColumnsExists(context: Context): Promise<void>;
	    getColumnDefinition(column: Column): ColumnDefinition;
	    /**
	     * Maps a ForeignKey to an ForeignKeyDefinition
	     */
	    static getForeignKeyDefinition(foreignKey: ForeignKey): ForeignKeyDefinition;
	    /**
	     * Maps a NodeIndex to an IndexDefinition
	     */
	    getIndexDefinition(schemaName: string, index: NodeIndex, tenantIdColumn: Column): IndexDefinition;
	    private static setCoalesceExpressionForNullableInUniqueIndex;
	    /** @disabled_internal */
	    createIndex(context: Context, index: IndexDefinition): Promise<void>;
	    /** @disabled_internal */
	    dropIndex(context: Context, indexName: string): Promise<void>;
	    /**
	     * @disabled_internal
	     *
	     * Adds some columns from their column definition
	     */
	    addColumns(context: Context, colDefs: ColumnDefinition[], options?: SqlAddColumnsOptions): Promise<void>;
	    /**
	     * @disabled_internal
	     *
	     * Alters some columns from their new column definition
	     */
	    alterColumns(context: Context, columns: {
	        definition: ColumnDefinition;
	        inconsistencies: ColumnInconsistency[];
	    }[]): Promise<void>;
	    /**
	     * @disabled_internal
	     */
	    dropColumns(context: Context, columnNames: string[]): Promise<void>;
	    /**
	     * Returns the existing foreignKeyDefinition that matches the fk provided as a parameter.
	     * This function will return either the existing fkDef with the same name or the existing fkDef with the same columns.
	     *
	     * @param currentTableDef The current table schema (the one that matches the current state of the db)
	     */
	    getMatchingForeignKeyDefinition(context: Context, foreignKey: ForeignKey, currentTableDef?: TableDefinition): Promise<ForeignKeyDefinition | undefined>;
	    /** @disabled_internal */
	    dropForeignKey(context: Context, foreignKeyName: string): Promise<void>;
	    /**
	     * Renames (in DB) a foreign key
	     */
	    renameForeignKey(context: Context, oldFkName: string, newFkName: string): Promise<void>;
	    /**
	     * Make sure all the foreign keys defined in the model exist and that they have the right name
	     *
	     * @param currentTableDef The current table schema (the one that matches the current state of the db)
	     */
	    fixForeignKeys(context: Context, currentTableDef: TableDefinition, options: ForeignKeyOptions): Promise<FixForeignKeysResult>;
	    /**
	     * Creates (in DB) a foreign key
	     *
	     * @param context
	     * @param foreignKey
	     * @param options
	     * @param currentTableSchema The (optional) current table schema (for optimization purpose: reading the schema is very expensive)
	     */
	    addForeignKey(context: Context, foreignKey: ForeignKey, currentTableSchema?: TableDefinition, options?: ForeignKeyOptions): Promise<void>;
	    getForeignKeyByName(name: string): ForeignKey | undefined;
	    dropAllForeignKeys(context: Context): Promise<void>;
	    tableExists(context: Context): Promise<boolean>;
	    createEnumTypes(context: Context, enumTypes: EnumType[]): Promise<void>;
	    getColumnValues(data: AnyRecord): AnyRecord;
	    private getSqlColumnByPropertyName;
	    getSqlColumnNameByPropertyName(propertyName: string): string;
	    private getSqlColumnByColumnName;
	    getSqlColumnNameByColumnName(columnName: string): string;
	    insert(context: Context, initialData: AnyRecord, options?: SqlInsertOptions): Promise<AnyRecord & {
	        _id?: number;
	    }>;
	    insertFromSqlFile(context: Context, initialData: AnyRecord, options?: SqlInsertOptions): Promise<AnyRecord & {
	        _id?: number;
	    }>;
	    static dropUpsertSqlFunction(context: Context): Promise<void>;
	    update(context: Context, data: AnyRecord, options?: RecordUpdateOptions): Promise<AnyRecord[]>;
	    delete(context: Context, filter: AnyRecord): Promise<number>;
	    findColumnByPropertyName(name: string): Column;
	    findColumnByColumnName(name: string): Column;
	    tableError(message: string): Error;
	    markAsLoadedForTests(application: Application, contextOptions: ContextOptions): void;
	    markAsModifiedForTests(): void;
	    /**
	     * Fix the sequences of the table
	     */
	    fixAutoIncrementSequences(tenantId: string | null): Promise<void>;
	}
	//# sourceMappingURL=table.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/primary-key.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/primary-key' {
	export {};
	//# sourceMappingURL=primary-key.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/index.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/index' {
	export * from '@sage/xtrem-core/lib/sql/schema/column';
	export * from '@sage/xtrem-core/lib/sql/schema/fix-schema';
	export * from '@sage/xtrem-core/lib/sql/schema/foreign-key';
	export * from '@sage/xtrem-core/lib/sql/schema/primary-key';
	export * from '@sage/xtrem-core/lib/sql/schema/table';
	export * from '@sage/xtrem-core/lib/sql/schema/utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/foreign-key.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/foreign-key' {
	/** @ignore */ /** */
	import { ForeignKeyDeleteBehaviour, ForeignKeyJsonComment } from '@sage/xtrem-postgres';
	/** @disabled_internal */
	export class ForeignKey {
	    private readonly options;
	    constructor(options: {
	        name: string;
	        /**
	         * The name of the target table
	         */
	        targetTable: string;
	        /**
	         * The name of the target columns (columns from target table)
	         */
	        targetColumnNames: string[];
	        /**
	         * The column names (columns from the current table)
	         */
	        columnNames: string[];
	        /**
	         * The behaviour of the foreign key on 'delete' operation
	         */
	        onDeleteBehaviour: ForeignKeyDeleteBehaviour;
	        /**
	         * Is the foreignKey deferrable ?
	         */
	        isDeferrable: boolean;
	    });
	    get name(): string;
	    /**
	     * The name of the target table
	     */
	    get targetTable(): string;
	    /**
	     * The name of the target columns (columns from target table)
	     */
	    get targetColumnNames(): string[];
	    /**
	     * The column names (columns from the curren table)
	     */
	    get columnNames(): string[];
	    /**
	     * The behaviour of the foreign key on 'delete' operation
	     */
	    get onDeleteBehaviour(): ForeignKeyDeleteBehaviour;
	    /**
	     * Is the foreignKey deferrable ?
	     */
	    get isDeferrable(): boolean;
	    /**
	     * Returns the JSON comment that must be put on the foreignKey (in the database)
	     */
	    getJsonComment(): ForeignKeyJsonComment;
	}
	//# sourceMappingURL=foreign-key.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/fix-schema.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/fix-schema' {
	export class FixSchema {
	    private static writeline;
	    /**
	     * Sort the buffered column definition lines and print them to the output dump.
	     * @param output
	     * @param bufferedLines
	     */
	    private static flushLines;
	    /**
	     * Process the read line of the dump
	     * @param output
	     * @param line
	     * @param buffering
	     * @param bufferedLines
	     * @returns
	     */
	    private static processLine;
	    /**
	     * Correct the order of columns in the supplied dump file
	     * @param directory directory of the dump file
	     * @param fileName the name of the dump file to be fixed
	     * @param outFilename the name of the output file to spool the corrected dump file
	     */
	    static fixColumnOrder(directory: string, fileName: string, outFilename: string): Promise<void>;
	}
	//# sourceMappingURL=fix-schema.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/schema/column.d.ts
declare module '@sage/xtrem-core/lib/sql/schema/column' {
	/** @ignore */ /** */
	import { ColumnJsonComment } from '@sage/xtrem-postgres';
	import { ColumnTypeName } from '@sage/xtrem-shared';
	import { TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { Table } from '@sage/xtrem-core/lib/sql/schema/table';
	/** @disabled_internal */
	export class Column {
	    readonly property: Property;
	    constructor(property: Property);
	    get isSystem(): boolean;
	    get table(): Table;
	    /** Property name */
	    get propertyName(): string;
	    /** Column name - may be different from property name */
	    get columnName(): string;
	    /** Column type - may be different from property type */
	    get type(): TypeName;
	    /**
	     * Returns whether this column should be lazy loaded
	     */
	    get shouldLazyLoad(): boolean;
	    /** Is property value nullable ? (must not be used for string properties : use isNotEmpty instead for strings) */
	    get isNullable(): boolean;
	    /** Is property value an encrypted string ? (only applies to string properties) */
	    get isEncryptedString(): boolean;
	    getColumnType(): ColumnTypeName;
	    columnError(message: string): Error;
	    /**
	     * Returns the JSON comment that must be put on the column (in the database)
	     */
	    getJsonComment(): ColumnJsonComment;
	    /**
	     * The SQL default of this column
	     */
	    get default(): string | undefined | null;
	    /**
	     * Is this column set to be auto incremented
	     */
	    get isAutoIncrement(): boolean;
	    /**
	     * The SQL default of this column
	     */
	    get excludeFromInsertIfNull(): boolean;
	    /**
	     * The column is a system column that is only on the table but not on the factory
	     */
	    get isInternalSystemProperty(): boolean;
	}
	//# sourceMappingURL=column.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/pubsub/subscriber.d.ts
declare module '@sage/xtrem-core/lib/sql/pubsub/subscriber' {
	import { StorageConfig } from '@sage/xtrem-shared';
	import { Subscriber } from 'pg-listen';
	export class NotificationSubscriptionManager {
	    private static subscriber;
	    /**
	     * create a subscriber instance
	     * @param sqlConfig
	     */
	    private static createPostgresSubscriber;
	    /**
	     * gets the subscriber instance if it is cached for the process, or creates a new one
	     * @param storageConfig
	     */
	    static getSubscriber(storageConfig: StorageConfig): Promise<Subscriber>;
	    /**
	     * Closed the subscriber instance
	     * @param subscriber
	     */
	    private static closeSubscriber;
	}
	//# sourceMappingURL=subscriber.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/pubsub/pubsub.d.ts
declare module '@sage/xtrem-core/lib/sql/pubsub/pubsub' {
	import { AnyRecord, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	export interface PublishOptions {
	    excludeSelf?: boolean;
	}
	export type PubSubPayload = AnyRecord & {
	    tenantId: string | null;
	};
	export interface PubSubEnvelope {
	    data: string;
	    containerId: string;
	    excludeSelf: boolean;
	}
	/**
	 * Static class to support pubsub of topics with postgres NOTIFY / LISTEN.
	 * This mechanism is used by the framework to synchronize operations across containers.
	 * This API is reserved to system components. Applicative modules should not use it.
	 */
	export abstract class PubSub {
	    /**
	     * Gets the channel name based on the topic
	     */
	    static getChannelName(topic: string): string;
	    /**
	     * Publish notification for topic, if this is a broadcast we need to use a prefix on channel name
	     */
	    static publish(context: Context, topic: string, data: PubSubPayload, options?: PublishOptions): Promise<void>;
	    /**
	     * Subscribe to a topic
	     */
	    static subscribe(topic: string, listener: (data: PubSubPayload, containerId?: string) => AsyncResponse<void>): Promise<void>;
	    /**
	     * Returns whether topic has been subscribed or not
	     */
	    static isSubscribed(topic: string): Promise<boolean>;
	    /**
	     * Unsubscribe from notifications on channel
	     */
	    private static unsubscribeChannel;
	    /**
	     * Unsubscribe from notifications on topic
	     */
	    static unsubscribe(topic: string): Promise<void>;
	    /**
	     * Unsubscribe from all channels
	     */
	    static unsubscribeAll(): Promise<void>;
	}
	//# sourceMappingURL=pubsub.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/pubsub/index.d.ts
declare module '@sage/xtrem-core/lib/sql/pubsub/index' {
	export * from '@sage/xtrem-core/lib/sql/pubsub/pubsub';
	export * from '@sage/xtrem-core/lib/sql/pubsub/subscriber';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/pubsub/container-heartbeat-monitor.d.ts
declare module '@sage/xtrem-core/lib/sql/pubsub/container-heartbeat-monitor' {
	/**
	 * This class manages heartbeats between containers.
	 *
	 * Every container periodically publishes a heartbeat and listen to the heartbeats from the other containers.
	 */
	export {};
	//# sourceMappingURL=container-heartbeat-monitor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/pubsub/broadcast-handler.d.ts
declare module '@sage/xtrem-core/lib/sql/pubsub/broadcast-handler' {
	/**
	 * This class handles broadcasts
	 */
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { PubSubPayload } from '@sage/xtrem-core/lib/sql/pubsub/pubsub';
	export type BroadcastPayload = PubSubPayload & {
	    $broadcastId: string;
	    $fromContainerId: string;
	};
	export abstract class BroadcastHandler {
	    private static _makeAckTopic;
	    /**
	     *
	     * Broadcast a message and wait_ for an acknowledgement from all the alive containers
	     * @param payload
	     */
	    static broadcast(application: Application, topic: string, payload: PubSubPayload, options?: {
	        timeout?: number;
	    }): Promise<void>;
	    /**
	     * Send the acknowledgement for a received broadcast
	     */
	    static acknowledge(application: Application, topic: string, payload: BroadcastPayload): Promise<void>;
	    /**
	     * Send an error as acknowledgement for a received broadcast
	     */
	    static acknowledgeWithError(application: Application, topic: string, payload: BroadcastPayload, error: string): Promise<void>;
	}
	//# sourceMappingURL=broadcast-handler.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-value-converter.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-value-converter' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { Column } from '@sage/xtrem-core/lib/sql/schema/column';
	import { OutputColumn } from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	export type TransformationForSqlValue = TypeName | 'encryptedString';
	export class SqlValueConverter {
	    static fromSql(context: Context, outputColumn: OutputColumn, val: AnyValue): Promise<AnyValue>;
	    /**
	     * Performs a check on a value
	     */
	    private static _checkValue;
	    /**
	     * Ensures a value has the right type
	     * @param val
	     * @param expectedType
	     * @param column
	     */
	    private static _checkValueType;
	    /**
	     * Ensures a value has the right type
	     * @param val
	     * @param expectedType
	     * @param column
	     */
	    private static _checkValueIsInstanceOf;
	    /**
	     * Convert a value to its SQL representation
	     */
	    static toSql(context: Context, column: Column, value: AnyValue): AnyValue;
	    static parseIntegerColumnValue(context: Context, column: Column, val: AnyValue): AsyncResponse<number | null>;
	    /**
	     * Applies a TransformationForSqlValue to a value
	     * @param context
	     * @param value the value to transform
	     * @param transformation the transformation to apply
	     * @param column the (optional) column that will be used to check the consistency of the value
	     * @returns
	     */
	    static applyTransformationToValue(context: Context, value: AnyValue, transformation: TransformationForSqlValue, column?: Column): AnyValue;
	    /**
	     * Returns the TransformationForSqlValue to apply to a value
	     */
	    static getSqlTransformation(context: Context, column: Column): TransformationForSqlValue;
	}
	//# sourceMappingURL=sql-value-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-util.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-util' {
	import { AnyRecord } from '@sage/xtrem-async-helper';
	import { AnyValue } from '@sage/xtrem-shared';
	import { Table } from '@sage/xtrem-core/lib/sql/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { Column } from '@sage/xtrem-core/lib/sql/schema/column';
	import { SqlConverter } from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	/** Static utility methods shared by SqlInsert and SqlUpdate */
	export abstract class SqlUtil {
	    static pushColumnArg(sqlConverter: SqlConverter, column: Column): string;
	    /**
	     * function to build update/insert sql statements
	     *
	     * @param context the context
	     * @param column the column to process
	     * @param val the value (TypeScript value, not a sql value)
	     * @param columnNames the name of the columns in the statement
	     * @param parameterNames the list of sqlParameters ($1, $2, ...)
	     * @param parameterValues the values of the sqlParameters (values of $1, $2, ...)
	     */
	    static pushValuesForUpdateOrInsert(table: Table, sqlConverter: SqlConverter, column: Column, val: AnyValue, columnNames: string[], parameterNames: string[]): void;
	    /**
	     * Set the localized properties to json format { locale: 'text value', languageCode: 'text value' }
	     * The language code will be used as fallback for other locales in the same language
	     * For Inserts we also set { defaultLanguage: 'text value' } as fallback value for any other language/locale
	     *
	     * @param context
	     * @param data
	     * @param property
	     * @param mode
	     */
	    static setLocalizedValue(context: Context, data: AnyRecord, propertyName: string, mode: 'insert' | 'update'): void;
	}
	export const tenantIdColumnName = "_tenant_id";
	export const idColumnName = "_id";
	//# sourceMappingURL=sql-util.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-update.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-update' {
	export {};
	//# sourceMappingURL=sql-update.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-statement-cache.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-statement-cache' {
	import { CachedInsert } from '@sage/xtrem-core/lib/sql/mapper/sql-insert';
	import { CachedQuery } from '@sage/xtrem-core/lib/sql/mapper/sql-query';
	/** Union of all the statement types that may be cached */
	export type CachedStatement = CachedQuery | CachedInsert;
	/** The kind of statement that we are caching */
	export type SqlStatementKind = 'select' | 'insert' | 'upsert';
	/** The data that we use to compute the key */
	export interface SqlStatementCacheKeyData {
	    /** The kind of statement */
	    kind: SqlStatementKind;
	    /** The schema name */
	    schemaName: string;
	    /** The name of the node factory */
	    factoryName: string;
	    /** Options that are specific to the statement kind */
	    options: object;
	}
	/**
	 * Options passed to statementCache.fetch.
	 */
	export interface SqlStatementCacheFetchOptions<T> {
	    /** Returns the key */
	    getKeyData: () => SqlStatementCacheKeyData;
	    /** Builds the statement. Only called if key is not found in the cache */
	    buildStatement: () => T;
	}
	//# sourceMappingURL=sql-statement-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-select.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-select' {
	import { AsyncReader } from '@sage/xtrem-async-helper';
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { NodeSelectOptions, NodeSelectResult, NodeSelector } from '@sage/xtrem-core/lib/ts-api/node-select-types';
	export class SqlSelect {
	    static select(context: Context, factory: NodeFactory, selector: NodeSelector<Node>, options: NodeSelectOptions<Node>): Promise<NodeSelectResult<Node, NodeSelector<Node>>[]>;
	    static getSelectReader(context: Context, factory: NodeFactory, selector: NodeSelector<Node>, options: NodeSelectOptions<Node>): Promise<AsyncReader<NodeSelectResult<Node, NodeSelector<Node>>>>;
	}
	//# sourceMappingURL=sql-select.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-resolver.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-resolver' {
	import { ConversionResultType } from '@sage/xtrem-ts-to-sql';
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { ConversionResult, OutputColumn, SqlConverter } from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	export class SqlResolver {
	    private static checkDateOrDatetimeType;
	    private static dateAggregateFormats;
	    private static castIfBoolean;
	    private static aggregateSql;
	    private static castFromJson;
	    private static getNumericAggregateValueType;
	    private static getAggregateValueType;
	    static resolveAggregate(sqlConverter: SqlConverter, result: OutputColumn, name: string | undefined): OutputColumn;
	    static makeColumnAlias(sql: string): string;
	    static resolveCustomData(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
	    static resolveJson(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
	    static resolveDate(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
	    static resolveRange(result: ConversionResult, name: string, type: ConversionResultType): ConversionResult;
	    static resolveArray(result: ConversionResult, type: ConversionResultType): ConversionResult;
	    static resolveTextStream(result: ConversionResult): ConversionResult;
	    static resolve(sqlConverter: SqlConverter, context: Context, parent: ConversionResult, name: string, rootFactory: NodeFactory): ConversionResult;
	}
	//# sourceMappingURL=sql-resolver.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-query.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-query' {
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { OutputColumn, SqlParameter } from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	/**
	 * Structure of a cache entry for a generated SELECT statement
	 *
	 * This structure should be kept reasonably small.
	 * It may reference metadata objects (Property instances) because this only costs a pointer
	 * but it should not duplicate metadata.
	 */
	export interface CachedQuery {
	    /** SQL statement string */
	    sql: string;
	    /** Descriptors of the statement parameters */
	    sqlParameters: SqlParameter[];
	    /** The properties of the paging cursor, if any */
	    cursorProperties: Property[];
	    /**
	     * List of table names that are joined by the query.
	     * This information is used to invalidate the cache of query results (NodeFactoryCache)
	     */
	    allTableNames: string[];
	    /**
	     * Descriptors of the selected columns (non-aggregate queries).
	     * This is used to map column aliases to the property names and to convert the SQL values to property values.
	     */
	    outputColumns: OutputColumn[] | undefined;
	    /** Descriptors of the groups returned by the query (aggregate queries only) */
	    groupColumns: OutputColumn[] | undefined;
	    /** Descriptors of values returned by the query (aggregate queries only) */
	    valueColumns: OutputColumn[] | undefined;
	}
	/**
	 * An output path describes an element which is returned by a query, before it gets processed by the SQL converter.
	 * It only contains path information.
	 * The SQL converter will transform it into an OutputColumn which contains a SQL expression, an alias, ...
	 */
	export type OutputPath = {
	    /** The path from the root factory of the query or subquery, as an array of property names */
	    path: string[];
	    /** The output paths of the subquery, if path points to a collection property  */
	    subPaths?: OutputPath[];
	    /** The function that provides the result (after being converted to SQL) */
	    compute?: (this: Node) => any;
	};
	//# sourceMappingURL=sql-query.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-natural-key-utils.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-natural-key-utils' {
	import { Dict } from '@sage/xtrem-shared';
	import { Table } from '@sage/xtrem-core/lib/sql/schema/table';
	export class SqlNaturalKeyUtils {
	    /**
	     * Builds all the parts needed to build a SELECT query where all the natural keys will be returned as 'foo|bar'.
	     * This function will take care of base tables (joins and aliases will be created).
	     * Returns:
	     *   - aliasedColumnNames: the name of all the columns, with aliases (t1.a AS a, t2.b AS b, t1.c || '|' || t2.d AS c, ...)
	     *   - aliases: list of created aliases, indexed by table name
	     *   - joins: list of joins required to follow the references / base relations
	     *   - args: args to be used by the query (will by used to store the constructor names when dealing with base tables)
	     * @param schemaName
	     * @param table
	     * @param columnNamesToQuery the columns to query from the table (a column can be either from the table or from its base tables)
	     * @param options
	     */
	    static getSqlQueryPartsWithNaturalKeys(schemaName: string, table: Table, columnNamesToQuery: string[], options?: {
	        /**
	         * The alias already assigned to the table
	         */
	        tableAlias?: string;
	        /**
	         * When dealing with base tables, should the name of the constructor be inserted in
	         * the LEFT JOIN clause (true) or inserted in the args array (false) ?
	         */
	        doNotUseArgsForConstructors?: boolean;
	        /**
	         * When chaining many calls to the function in the same context, you can pass the aliases, joins, args returned by the previous
	         * calls.
	         */
	        aliases?: Dict<string>;
	        /**
	         * When chaining many calls to the function in the same context, you can pass the aliases, joins, args returned by the previous
	         * calls.
	         */
	        joins?: string[];
	        /**
	         * When chaining many calls to the function in the same context, you can pass the aliases, joins, args returned by the previous
	         * calls.
	         */
	        args?: any[];
	    }): {
	        columns: {
	            /**
	             * The column with the 'AS'. Something like "t2.name || '|' || t1.name || '|' || t1.action AS operation"
	             */
	            aliased: string;
	            /**
	             * The 'simple' column name (something like 'operation')
	             */
	            unaliased: string;
	        }[];
	        aliases: Dict<string>;
	        joins: string[];
	        args: any[];
	    };
	    /**
	     * Returns the column name (with its alias) that should be used to in a SQL query.
	     * If needed (column belongs to a base table, references, ...), some joins will be generated and some new aliases will be created
	     */
	    private static _getAliasedColumnForSqlQuery;
	}
	//# sourceMappingURL=sql-natural-key-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-insert.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-insert' {
	import { FactoryMetadata } from '@sage/xtrem-core/lib/types/sql-file-data';
	import { SqlParameter } from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	/**
	 * table.insert options
	 */
	export interface SqlInsertOptions {
	    /**
	     * Options constructor name - used by subclassing
	     */
	    constructorName?: string;
	    /**
	     * Try update if insert fails because of conflict on primary key
	     */
	    useUpsert?: boolean;
	    /**
	     * When useUpsert is true: columns that upsert should not update (flagged with isOwnedByCustomer)
	     */
	    upsertColumnsToIgnore?: string[];
	    /**
	     * Option to execute insert with ON CONFLICT DO NOTHING
	     * This will override useUpsert flag
	     */
	    onConflictDoNothing?: boolean;
	    /**
	     * When upsert is true: should errors on upsert (mainly unique index violation) be ignored ?
	     */
	    ignoreUpsertErrors?: boolean;
	    /**
	     * Specific metadata to use to insert the value (when not set, it will be extracted from the current table definition)
	     */
	    metadata?: FactoryMetadata;
	    /**
	     * insert values in audit columns (_create_user, _create_stamp, _update_user, _update_stamp, _update_tick)
	     * instead of letting the database triggers compute them.
	     */
	    preserveAuditColumns?: boolean;
	}
	/**
	 * Structure of a cache entry for a generated INSERT statement
	 *
	 * This structure should be kept reasonably small.
	 * It may reference metadata objects (Property instances) because this only costs a pointer
	 * but it should not duplicate metadata.
	 */
	export interface CachedInsert {
	    sql: string;
	    sqlParameters: SqlParameter[];
	    upsertFunctionSql: string;
	}
	//# sourceMappingURL=sql-insert.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-delete.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-delete' {
	export {};
	//# sourceMappingURL=sql-delete.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-converter.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-converter' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { ConversionResultType, GenericConversionResult } from '@sage/xtrem-ts-to-sql';
	import { Column } from '@sage/xtrem-core/lib/sql/index';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	export type ConversionResult = GenericConversionResult<NodeFactory, Property>;
	/**
	 * OutputColumn is a conversion result for an element which is returned by a SQL query.
	 * It may be an element of the select list, or a group or value returned by an aggregate query.
	 */
	export interface OutputColumn extends ConversionResult {
	    /** Path (array of property names) in the result payload */
	    payloadPath?: string[];
	    /** Output columns of this column's value (only if this is a collection output column) */
	    subColumns?: OutputColumn[];
	}
	export interface AggregateResult {
	    groups?: OutputColumn[];
	    values?: OutputColumn[];
	}
	/**
	 * Describes a SQL statement parameter
	 */
	export interface SqlParameter {
	    /** The path to the parameter's value */
	    valuePath: string;
	    /** The type of the parameter's value */
	    type: ConversionResultType | 'encryptedString';
	    /** Optional factory name, if the value is a reference */
	    factoryName?: string;
	    /** The column, if the value is a column value */
	    column?: Column;
	    /** Sub-path for composite value like regex */
	    subPath?: string;
	    /** Is the value an array ? */
	    isArray?: boolean;
	    /** Value, only for literals */
	    literalValue?: AnyValue;
	}
	export interface SqlConverterOptions {
	    quiet?: boolean;
	}
	//# sourceMappingURL=sql-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/sql-bulk.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/sql-bulk' {
	export {};
	//# sourceMappingURL=sql-bulk.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/mapper/index.d.ts
declare module '@sage/xtrem-core/lib/sql/mapper/index' {
	export * from '@sage/xtrem-core/lib/sql/mapper/sql-bulk';
	export * from '@sage/xtrem-core/lib/sql/mapper/sql-converter';
	export * from '@sage/xtrem-core/lib/sql/mapper/sql-natural-key-utils';
	export * from '@sage/xtrem-core/lib/sql/mapper/sql-query';
	export { idColumnName, tenantIdColumnName } from '@sage/xtrem-core/lib/sql/mapper/sql-util';
	export * from '@sage/xtrem-core/lib/sql/mapper/sql-value-converter';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/chores/index.d.ts
declare module '@sage/xtrem-core/lib/sql/chores/index' {
	export * from '@sage/xtrem-core/lib/sql/chores/gc-content-addressable-tables';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/sql/chores/gc-content-addressable-tables.d.ts
declare module '@sage/xtrem-core/lib/sql/chores/gc-content-addressable-tables' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	export function garbageCollectContentAddressableTable(context: Context, factory: NodeFactory): Promise<number>;
	export function garbageCollectContentAddressableTables(context: Context): Promise<void>;
	//# sourceMappingURL=gc-content-addressable-tables.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/xss.d.ts
declare module '@sage/xtrem-core/lib/security/xss' {
	export interface HtmlSanitizerOptions {
	    changes?: {
	        records?: MutationRecord[];
	        removed?: any[];
	    };
	    throwIfModified?: boolean;
	    ignoreTemplating?: boolean;
	}
	export interface SanitizeResult {
	    html?: string;
	    error?: string;
	    details?: string[];
	}
	/**
	 * Async function to sanitize an html content.
	 * The underlying code is not async so the function use a worker thread to make it async
	 * @param html
	 * @param options
	 * @returns
	 */
	export function htmlSanitizer(html: string, options?: HtmlSanitizerOptions): Promise<string>;
	//# sourceMappingURL=xss.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/tls.d.ts
declare module '@sage/xtrem-core/lib/security/tls' {
	/// <reference types="node" />
	/// <reference types="node" />
	import { ServerConfig } from '@sage/xtrem-shared';
	import { Request } from 'express';
	import * as https from 'node:https';
	import * as tls from 'tls';
	export interface InternalServerConfig extends ServerConfig {
	    sslShallowCopy?: tls.TlsOptions;
	}
	export function initTlsLayer(): void;
	export function loadExtraConfig(): Promise<void>;
	export function registerTlsChangeListener(server: tls.Server, configPath: string, name: string): void;
	export function getInteropHttpsAgent(): https.Agent | null;
	export function getTlsConfig(): tls.ConnectionOptions;
	export function getPeerCertificate(req: Request): tls.PeerCertificate | null;
	//# sourceMappingURL=tls.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/loggers.d.ts
declare module '@sage/xtrem-core/lib/security/loggers' {
	import { Logger } from '@sage/xtrem-log';
	import { Request } from 'express';
	export const logger: Logger;
	export function logSecurityAlert(req: Request, category: string, reason: string): void;
	//# sourceMappingURL=loggers.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/loader.d.ts
declare module '@sage/xtrem-core/lib/security/loader' {
	export function setup(): Promise<void>;
	//# sourceMappingURL=loader.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/jwt.d.ts
declare module '@sage/xtrem-core/lib/security/jwt' {
	export interface JwtClaims {
	    /**
	     * "5f0b9648-bc74-4fe7-adbf-184fc7efc44a"
	     */
	    jti?: string;
	    /**
	     * "auth0|cd3..........."
	     */
	    auth0?: string;
	    /**
	     * "user.name@domain.com"
	     */
	    sub?: string;
	    /**
	     * "<tenant-nanoid>"
	     */
	    tenantId?: string;
	    /**
	     * "<domain-of-the-cluster>"
	     * example: "cluster-a.dev-sagextrem.com" or "*-ci-v2.eu.dev-sagextrem.com" when using bizapps"
	     */
	    aud?: string;
	    /**
	     * "<domain-of-authentication-service>"
	     * example: login.dev-sagextrem.com
	     */
	    iss?: string;
	    iat?: number;
	    exp?: number;
	    /**
	     * OneTrust preferences https://jira.sage.com/browse/XT-10838
	     */
	    pref?: number;
	    /**
	     * Initial app the access token was created for
	     */
	    app?: string;
	    /**
	     * What are the apps for this tenant/user the access token is valid for (ex SDMO and SHOWCASE)
	     */
	    apps?: string[];
	}
	//# sourceMappingURL=jwt.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/security/index.d.ts
declare module '@sage/xtrem-core/lib/security/index' {
	export * from '@sage/xtrem-core/lib/security/jwt';
	export * from '@sage/xtrem-core/lib/security/loader';
	export * from '@sage/xtrem-core/lib/security/loggers';
	export * from '@sage/xtrem-core/lib/security/tls';
	export * from '@sage/xtrem-core/lib/security/xss';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/utils.d.ts
declare module '@sage/xtrem-core/lib/runtime/utils' {
	/** @ignore */ /** */
	import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Maybe } from '@sage/xtrem-shared';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { SqlConverter, Table } from '@sage/xtrem-core/lib/sql/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	export interface RetryOptions {
	    maxTries: number;
	    delayBeforeRetry: number;
	    message?: string;
	    onError?: (error: Error) => void;
	}
	export function isCompound(val: AnyValue): val is AnyRecord;
	export function tenantCondition(sqlConverter: SqlConverter, table: Table, alias: string, clauses: (string | undefined)[]): string;
	/**
	 * Returns the dependencies (as factory names) of a factory
	 * @param factory the factory to analyze
	 * @param allAvailableFactories the full list of available factories. This function will only return factories that belong to this list
	 */
	export function getFactoryDependsOn(factory: NodeFactory, allAvailableFactories: NodeFactory[]): string[];
	/**
	 * Use topoSort to order passed in factories based on their dependencies
	 *
	 * @param factories
	 */
	export function sortFactories(factories: NodeFactory[]): NodeFactory[];
	/**
	 * Returns the list of defaultable reference properties.
	 * Reference properties are defaultable if they are either nullable or self-referencing.
	 */
	export function getDefaultableReferenceProperties(factory: NodeFactory, propertiesToUpdate?: Maybe<string[]>): Property[];
	/**
	 * Converts the data key to either snakeCase or camelCase
	 * This function is used on the application when data is read from CSV files
	 * and need to be loaded into postgres or if data is written into CSV
	 *
	 * @param data
	 * @param conversion
	 */
	export function convertDataKey(data: AnyRecord[], conversion: 'snakeCase' | 'camelCase'): AnyRecord[];
	/**
	 * Returns the language code based on the locale supplied
	 * @param locale
	 */
	export function getLanguageFromLocale(locale: string): string;
	export const defaultAlphabet = " !\"#$%&()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_abcdefghijklmnopqrstuvwxyz{|}~";
	export function randomString(maxLength?: number, alphabet?: string): string;
	/**
	 * Re-tries the given function until it succeeds or a maximum number of tries are reached.
	 * @param action - The action to be retried.
	 * @param maxTries - The maximum number of tries to make. This includes the first try. Values less than 1 will try 1 time.
	 * @param delayBeforeRetry - The delay in milliseconds between each successive retry.
	 */
	export function retry<T extends AnyValue>(action: () => AsyncResponse<T>, options?: RetryOptions): Promise<T>;
	export function getServerUrl(path: string, params?: URLSearchParams): string;
	//# sourceMappingURL=utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/transaction.d.ts
declare module '@sage/xtrem-core/lib/runtime/transaction' {
	import { IsolationOptions } from '@sage/xtrem-core/lib/ts-api/isolation-options';
	export interface TransactionOptions extends IsolationOptions {
	    noCommit?: boolean;
	    /** is the transaction in autocommit mode - overrides other transaction options  */
	    isAutoCommit?: boolean;
	}
	//# sourceMappingURL=transaction.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/system-properties.d.ts
declare module '@sage/xtrem-core/lib/runtime/system-properties' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { Column } from '@sage/xtrem-core/lib/sql/schema/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { PropertyDecorator } from '@sage/xtrem-core/lib/runtime/property';
	export const defaultCodeLength = 32;
	/** @disabled_internal */
	export class SystemProperties {
	    private static readonly publishedSystemProperties;
	    private static readonly systemProperties;
	    private static readonly idProperties;
	    private static readonly idColumns;
	    private static readonly updateTickColumns;
	    private static readonly syncTickColumns;
	    private static readonly syncInfoColumns;
	    private static readonly customDataProperties;
	    private static readonly customDataColumns;
	    private static readonly tenantIdProperties;
	    private static readonly tenantIdColumns;
	    private static readonly sourceIdProperties;
	    private static readonly sourceIdColumns;
	    private static readonly sortValueProperties;
	    private static readonly sortValueColumns;
	    private static readonly updateActionProperties;
	    private static readonly updateActionColumns;
	    private static readonly constructorProperties;
	    private static readonly constructorColumns;
	    private static readonly createUserProperties;
	    private static readonly updateUserProperties;
	    private static readonly vendorProperties;
	    private static readonly updateTickProperties;
	    private static readonly syncTickProperties;
	    private static readonly syncInfoProperties;
	    private static readonly etagProperties;
	    private static readonly valuesHashProperties;
	    private static readonly valuesHashColumns;
	    private static readonly attachmentsProperties;
	    private static readonly factoryProperties;
	    /** @disabled_internal */
	    static getSystemProperties(factory: NodeFactory): Property[];
	    static getSystemProperty(factory: NodeFactory, name: string): Property | undefined;
	    /** @disabled_internal */
	    static isSystemOrTechnicalColumn(factory: NodeFactory, columnName: string): boolean;
	    private static getProperty;
	    private static getColumn;
	    /** @disabled_internal */
	    static idProperty(factory: NodeFactory): Property;
	    /** @disabled_internal */
	    static idColumn(factory: NodeFactory): Column;
	    /** @disabled_internal */
	    static sourceIdProperty(factory: NodeFactory): Property;
	    /** @disabled_internal */
	    static sourceIdColumn(factory: NodeFactory): Column;
	    /** @disabled_internal */
	    static tenantIdColumn(factory: NodeFactory): Column;
	    static getReferencedFactory(application: Application, referenceDecorator: PropertyDecorator): NodeFactory | null;
	    static isReferencedFactory(factory: NodeFactory, referenceFactoryName: string, referenceDecorator: PropertyDecorator): boolean;
	    static getInternalSystemProperties(factory: NodeFactory): Property[];
	}
	export const sharedDatabaseComputedColumnNames: readonly string[];
	export const nonSharedDatabaseComputedColumnNames: readonly string[];
	export const databaseComputedColumnNames: (isSharedByAllTenants: boolean) => readonly string[];
	export const orderedSystemColumns: readonly string[];
	//# sourceMappingURL=system-properties.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/system-data-types.d.ts
declare module '@sage/xtrem-core/lib/runtime/system-data-types' {
	/// <reference types="@sage/xtrem-shared" />
	import { DecimalDataType, EnumDataType, JsonDataType, StringDataType } from '@sage/xtrem-core/lib/types/index';
	export const _updateActionDataType: EnumDataType<string, unknown>;
	export const _constructorDataType: StringDataType<unknown, string>;
	export const nanoIdDataType: StringDataType<unknown, string>;
	export const _jsonDataType: JsonDataType<unknown, import("@sage/xtrem-shared/lib/set-sort-values").AnyValue>;
	export const _etagDataType: StringDataType<unknown, string>;
	export const _sourceIdDataType: StringDataType<unknown, string>;
	export const _valuesHashDataType: StringDataType<unknown, string>;
	export const _syncTickDataType: DecimalDataType<unknown, number>;
	//# sourceMappingURL=system-data-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/secret-manager.d.ts
declare module '@sage/xtrem-core/lib/runtime/secret-manager' {
	import { SecretConfig } from '@sage/xtrem-secret';
	export class SecretManager {
	    static getTenantEncryptionKey(config: SecretConfig, tenantId: string): Promise<string>;
	    static getConfigSecretValue(config: SecretConfig, name: string): Promise<string>;
	}
	//# sourceMappingURL=secret-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/running-context.d.ts
declare module '@sage/xtrem-core/lib/runtime/running-context' {
	import { ApplicationType } from '@sage/xtrem-core/lib/application/index';
	interface Argv {
	    _: string[];
	    $cli?: {
	        plugins?: {
	            name?: string;
	        }[];
	    };
	}
	export interface RunningContextInitOptions {
	    argv: Argv;
	}
	export class RunningContext {
	    static readonly defaultNatIpAddresses = "0.0.0.0";
	    get isServicesMode(): boolean;
	    get inceptionCommand(): string;
	    get natIpAddress(): string;
	    init(options: RunningContextInitOptions): void;
	    configure(applicationType?: ApplicationType): void;
	    private setServicesMode;
	    private initNatIpAddresses;
	}
	export const globalRunningContext: RunningContext;
	export {};
	//# sourceMappingURL=running-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/property.d.ts
declare module '@sage/xtrem-core/lib/runtime/property' {
	export interface Enum {
	    [id: number]: string;
	}
	//# sourceMappingURL=property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/profiler.d.ts
declare module '@sage/xtrem-core/lib/runtime/profiler' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	export interface BasicProfilerItem {
	    name?: string;
	    hits?: number;
	    duration?: number;
	    children: BasicProfilerItem[];
	}
	class BasicProfiler {
	    private _items;
	    private _stack;
	    measure<T extends AnyValue | void>(name: string, cb: () => AsyncResponse<T>): Promise<T>;
	    walk(cb: (path: string[], item: BasicProfilerItem) => AsyncResponse<void>): Promise<void>;
	}
	export const basicProfiler: BasicProfiler;
	export {};
	//# sourceMappingURL=profiler.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/node-factory.d.ts
declare module '@sage/xtrem-core/lib/runtime/node-factory' {
	/** @ignore */ /** */
	import { AnyRecord, AnyValue, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
	import { SqlCreateTableOptions } from '@sage/xtrem-postgres';
	import { Dict, LogicError, SystemError } from '@sage/xtrem-shared';
	import { Application, ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Package, PackageValidationContext } from '@sage/xtrem-core/lib/application/package';
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/base-collection';
	import { Decorated, ExternalStorageManager, IsolationLevel, IsolationLevels, MessageListener, NodeKey, NodeStorage, NotificationListener, NotifyOperation, PlainOperationDecorator, PropertyFilterTag, StaticThis, StringOrNumberOrNull } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFilterTag } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { NodeEvents, NodeRuleName } from '@sage/xtrem-core/lib/decorators/node-decorators/node-events';
	import { NodeState } from '@sage/xtrem-core/lib/node-state/index';
	import { ForeignNodeProperty, ReferenceProperty, StringProperty } from '@sage/xtrem-core/lib/properties/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	import { DropTableOptions } from '@sage/xtrem-core/lib/sql/index';
	import { OrderByClause, SqlQuery } from '@sage/xtrem-core/lib/sql/mapper/index';
	import { Column, ForeignKey, Table } from '@sage/xtrem-core/lib/sql/schema/index';
	import { AnyFilterObject, Node, NodeQueryFilter, NodeQueryOptions, OrderBy } from '@sage/xtrem-core/lib/ts-api/index';
	import { NodeSelector } from '@sage/xtrem-core/lib/ts-api/node-select-types';
	import { Context, NodeDeleteOptions, StandardOperation } from '@sage/xtrem-core/lib/runtime/context';
	import { ErrorParameters, FactoryDecorators, FactoryLinkedList, FactoryNodeDecorator, FindPropertyOptions, NodeIndex, ReferringProperty } from '@sage/xtrem-core/lib/runtime/node-factory-types';
	import { PropertyDecorator } from '@sage/xtrem-core/lib/runtime/property';
	/** @disabled_internal */
	export class NodeFactory {
	    nodeConstructor: typeof Node;
	    /**
	     * Cached value for the natural key
	     * 'null' means the cache is not computed yet
	     */
	    private _naturalKey;
	    readonly nodeDecorator: FactoryNodeDecorator;
	    private decoratorWarnings;
	    properties: Property[];
	    /**
	     * The list of properties that will be lazy-loaded, i.e. not loaded when loading the node but only when explicitly read from the code.
	     */
	    lazyLoadedProperties: Property[];
	    storedEncryptedProperties: StringProperty[];
	    mutableProperties: ForeignNodeProperty[];
	    propertiesByName: Dict<Property>;
	    keyProperties: Property[];
	    mutations: PlainOperationDecorator[];
	    queries: PlainOperationDecorator[];
	    notificationListeners: NotificationListener[];
	    messageListeners: MessageListener[];
	    events: NodeEvents<Node>;
	    private _table;
	    initialized: boolean;
	    publishedSystemProperties: Dict<Property>;
	    publishedInputSystemProperties: string[];
	    referringProperties: ReferringProperty[];
	    dependsOn?: string[];
	    storage?: NodeStorage;
	    indexes?: NodeIndex[];
	    impactingServiceOptions: string[];
	    decorators: FactoryDecorators;
	    extensions?: any[];
	    private _extendedVitalFactories?;
	    private readonly _package;
	    private readonly _taggedProperties;
	    private _baseFactory;
	    private _subFactories;
	    private staticMethods;
	    private nonStaticMethods;
	    constructor(pack: Package, clas: StaticThis<Node>, decorators: FactoryDecorators);
	    private registerEvents;
	    private cloneDecoratorsAttributes;
	    private verifyNaturalKey;
	    /**
	     * Raise an error if a factory has multiple unique indexes
	     */
	    private ensureNoMultipleUniqueIndexes;
	    private verifyIndex;
	    invalidateCache(context: Context): Promise<void>;
	    get defaultOrderByClauses(): OrderByClause[];
	    get table(): Table;
	    set table(table: Table);
	    get externalStorageManager(): ExternalStorageManager<Node> | undefined;
	    get serviceOptions(): ServiceOption[];
	    get isAbstract(): boolean;
	    /**
	     * Returns whether the factory is the root factory of a hierarchy.
	     * It will return false when the factory does not belong to a hierarchy (not a base factory)
	     */
	    get isRootAbstractFactory(): boolean;
	    get isVitalReferenceChild(): boolean;
	    get isVitalCollectionChild(): boolean;
	    get isAssociationCollectionChild(): boolean;
	    get isVitalChild(): boolean;
	    get isAssociationChild(): boolean;
	    get isPublished(): boolean;
	    get isCached(): boolean;
	    get canRead(): boolean;
	    get canCreate(): boolean;
	    get canUpdate(): boolean;
	    get canDelete(): boolean;
	    get canDuplicate(): boolean;
	    get notifies(): NotifyOperation[];
	    get canAudit(): boolean;
	    /**
	     * Can the node be duplicated,
	     * eventually because one of its vital ancestors can be duplicated,
	     * or because one of its subclasses can be duplicated
	     */
	    get canBeDuplicated(): boolean;
	    get canBulkDelete(): boolean;
	    get canDeleteMany(): boolean;
	    /**
	     * Can this node be exported?
	     */
	    get canExport(): boolean;
	    get isSetupNode(): boolean;
	    get hasVendorProperty(): boolean;
	    get hasAttachments(): boolean;
	    get hasLookupAccess(): boolean;
	    get isPlatformNode(): boolean;
	    get isPlatformNodeExportable(): boolean;
	    get isSkippedByLayerExtract(): boolean;
	    get isContentAddressable(): boolean;
	    get keyPropertyNames(): string[];
	    /**
	     * Returns a consolidated list of unique indexes of the factory of the state.
	     * The primary key will always be the first entry in the list (_id for services but may be a composite for X3)
	     */
	    get uniqueKeyProperties(): string[][];
	    get vitalParentProperty(): ReferenceProperty;
	    get associationParentProperties(): ReferenceProperty[];
	    get vitalParentFactory(): NodeFactory;
	    /**
	     * Is the factory a vital child, were the parent node is a setup node
	     */
	    get isSetupNodeVitalChild(): boolean;
	    get isClearedByReset(): boolean | undefined | ((this: Node) => AsyncResponse<boolean>);
	    private _retrieveNaturalKey;
	    /**
	     * Returns the natural key for the factory
	     * Note: the natural key decorator may come from the factory itself, from its baseFactory or from a vital parent.
	     */
	    get naturalKey(): string[] | undefined;
	    get delegatedProperties(): Property[];
	    get vitalProperties(): ForeignNodeProperty[];
	    get prepareBegin(): NodeEvents['prepareBegin'];
	    get prepareEnd(): NodeEvents['prepareEnd'];
	    /**
	     * If `this` is abstract, returns the concrete factories that extend `this`.
	     * Otherwise returns `[this]`, as `this` is a concrete factory.
	     */
	    getConcreteFactories(result?: NodeFactory[]): NodeFactory[];
	    isSubNodeOf(name: string): boolean;
	    isAssignableTo(factory: NodeFactory): boolean;
	    isEnabledByServiceOptions(context: Context): Promise<boolean>;
	    private getInternalSystemProperties;
	    private addProperty;
	    createMainNodeProperties(definingPackage: Package): void;
	    addExtensionDecorator(extension: any): void;
	    private createProperties;
	    private getExtensionDepth;
	    private checkExtensionDepth;
	    /**
	     * Returns the package that defines an extension
	     */
	    static getExtensionPackage(extension: any): Package;
	    /** Merge all the extension decorators.*/
	    mergeExtensions(pack: Package): void;
	    /** Merge static and non static methods from an extension. */
	    mergeExtensionMethods(extension: typeof Decorated): void;
	    /** Merge static and non static methods from superNode into subNode. */
	    mergeSubNodeMethods(extension: typeof Decorated): void;
	    /** Merge static and non static methods. */
	    private mergeMethods;
	    private mergeOperationKind;
	    private mergeOperations;
	    private mergeListeners;
	    /** Merge the superNode's header characteristics into the subNode. */
	    private mergeSubNodeHeader;
	    private mergeExtensionHeader;
	    private subclassDepth;
	    checkSubclassDepth(): void;
	    /** - add to the current subNode the queries, mutations, attributes and methods
	     * brought by the superclasses. */
	    mergeSubNodes(): void;
	    createSuperNodeProperties(definingPackage: Package): void;
	    createSubNodeProperties(definingPackage: Package): void;
	    createSubNodeOverrides(): void;
	    private verifyIsContentsAddressable;
	    private verifyIsSynchronizable;
	    private verifyIsSynchronized;
	    private verifyDefaultsToSingleMatch;
	    verify(): void;
	    /**
	     * Verify a factory with isVitalChild decorator
	     */
	    private _verifyVitalChildFactory;
	    /**
	     * Verify a factory with isClearByReset decorator
	     */
	    private _verifyClearedByResetFactory;
	    /**
	     * return the indexes defined (not inherited) by this factory.
	     */
	    getSelfIndexes(): NodeIndex[];
	    verifyJoins(): void;
	    /**
	     * Verifies that the table is compliant with the factory definition
	     */
	    verifyTable(context: Context, options?: {
	        doNotRecurseOnReferences?: boolean;
	        factoryLinkedList?: FactoryLinkedList;
	        foreignFactories?: NodeFactory[];
	        compareToSqlSchema?: boolean;
	    }): Promise<void>;
	    computeDependencyIndex(): void;
	    setSubFactories(): void;
	    private fillVitalProperties;
	    private fillDelegatedProperties;
	    private fillMutableProperties;
	    get strictMutableProperties(): ForeignNodeProperty[];
	    addUpdateActionProperty(): void;
	    complement(packageValidationContext?: PackageValidationContext): void;
	    private complementFactoryIndexes;
	    private addSystemProperties;
	    private computePropagationPaths;
	    private createNewTableColumns;
	    get defaultOrderBy(): OrderBy<Node>;
	    get package(): Package;
	    get application(): Application;
	    get name(): string;
	    get fullName(): string;
	    get baseFactory(): NodeFactory | undefined;
	    get rootFactory(): NodeFactory;
	    get rootCollectionFactory(): NodeFactory | undefined;
	    get rootVendorFactory(): NodeFactory | undefined;
	    get isSharedByAllTenants(): boolean;
	    get tableName(): string | undefined;
	    get fullTableName(): string | undefined;
	    resolveReferenceId(context: Context, value: StringOrNumberOrNull | Node): Promise<number | null>;
	    /**
	     * Get all node factories in the vital tree of a given node factory, including itself
	     */
	    getVitalTree(): NodeFactory[];
	    /**
	     * Returns all the table names in the factory's hierarchy tree, from the root to the leaves.
	     */
	    getAllTableNames(): string[];
	    get authorizationCode(): string | undefined;
	    getIsolationLevel(key: keyof IsolationLevels): IsolationLevel;
	    get provides(): NodeFilterTag[] | undefined;
	    /**
	     * Returns the list of sub-classing factories
	     */
	    get subFactories(): NodeFactory[];
	    private checkDecorators;
	    private checkExternalDecorator;
	    private checkIncompatibleAttributes;
	    private setTaggedProperty;
	    getTaggedProperty(tag: PropertyFilterTag): Property | undefined;
	    private findReverseProperty;
	    private warnDecorator;
	    private checkPropagatesTo;
	    private addPropagatePaths;
	    systemError(message: string): SystemError;
	    authorizationError(context: Context, params: ErrorParameters): SystemError;
	    logicError(message: string, innerError?: Error): LogicError;
	    propertySystemError(property: PropertyDecorator | Property, message: string): SystemError;
	    checkCanMutate(context: Context, verb: string): void;
	    checkCanCreate(context: Context): void;
	    checkCanDelete(context: Context): void;
	    checkCanUpdate(context: Context): void;
	    checkCanDeleteMany(context: Context): void;
	    addPropertyAccessors(property: Property): void;
	    getAllIndexes(): NodeIndex[];
	    getKeyValues(context: Context, data: AnyRecord, options?: {
	        allocateTransient: boolean;
	        isTransient?: boolean;
	        isOnlyForDefaultValues?: boolean;
	        isOnlyForDuplicate?: boolean;
	        writable?: boolean;
	        isOnlyForLookup?: boolean;
	        collection?: BaseCollection;
	    }): Dict<AnyValue>;
	    getLocalizedTitleKey(): string;
	    getLocalizedTitle(context: Context): string;
	    delete(context: Context, key: AnyRecord): Promise<void>;
	    deleteMany(context: Context, keyOrFilter: NodeQueryFilter<Node>, options?: NodeDeleteOptions): Promise<number>;
	    query(context: Context, options?: NodeQueryOptions): Promise<AsyncReader<Node>>;
	    private getAllowedAccessCodes;
	    private getPropertyFilter;
	    private getNodeFilter;
	    getAccessRightsFilter(context: Context): Promise<AnyFilterObject | undefined>;
	    /**
	     * Lazy load the value of some properties.
	     * This function should only be used when a node has already been loaded but some of its
	     * properties were not loaded (mainly stream properties)
	     * @param idValue the '_id' of the record we want to lazy load the properties for.
	     * @param properties the list of property to load
	     * @returns
	     */
	    createLazyLoadedValueQuery(context: Context, idValue: number, properties: Property[]): Promise<SqlQuery>;
	    createNodeQuery(context: Context, options: NodeQueryOptions, selector?: NodeSelector<Node>): Promise<SqlQuery>;
	    queryCount(context: Context, options: NodeQueryOptions): Promise<number>;
	    exists(context: Context, key: NodeKey<Node>): Promise<boolean>;
	    /**
	     * Returns a token that uniquely identifies a Node (based on its PK) WITHIN ITS FACTORY.
	     * @param values
	     */
	    getToken(values: Dict<AnyValue>): string;
	    findProperty(name: string, options?: FindPropertyOptions): Property;
	    parseOrderBy(context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
	    getValuesHash(values: Dict<AnyValue>): string;
	    getTableColumns(): Column[];
	    private static getOnDeleteBehavior;
	    /**
	     * Creates a foreignKey
	     */
	    createForeignKey(referenceFactory: NodeFactory, property: ReferenceProperty, isBase?: boolean): ForeignKey | null;
	    getForeignKeys(): ForeignKey[];
	    private makeTable;
	    missingClassDecorator(memberName: keyof FactoryNodeDecorator): SystemError;
	    missingPropertyDecorator(propertyName: string, memberName: keyof PropertyDecorator): SystemError;
	    getNodeSchemaDescription(): string;
	    /**
	     * Fixes the sequences for the list of provided factories
	     * @param application
	     * @param factories the list of factories to process (will process all the factories if not provided)
	     * @returns the factories where the sequences were fixed
	     */
	    static fixSequences(application: Application, tenantId: string | null): Promise<NodeFactory[]>;
	    /**
	     * Fix the sequences of the table of the factory
	     */
	    fixAutoIncrementSequences(tenantId: string | null): Promise<void>;
	    ensureTableExists(context: Context, options?: SqlCreateTableOptions): Promise<void>;
	    ensureAllTableColumnsExists(context: Context): Promise<void>;
	    dropTable(context: Context, options?: DropTableOptions): Promise<void>;
	    /**
	     * Walk the value for the natural key of the factory, parsing the _id  filter value to a filter object consisting of
	     * the natural key properties.
	     * Example:
	     *  MainFactory natural key: [code, reference]
	     *  ReferenceFactory natural key: [code, innerReference]
	     *  InnerRefenceFactory natural key: [code]
	     *  Therefore the value can be passed as follows: '#mainCode|referenceCode|innerReferenceCode'
	     *  This will resolve to {code:'mainCode',reference:{code:'referenceCode',innerReference:{code:'innerReferenceCode'}}}
	     * @param value
	     * @param path
	     * @returns
	     */
	    private resolveKeyFilter;
	    /**
	     * Parse the node id passed returning an object value representing the a filter.
	     * If the factory has a natural key then the value can be passed as a string starting with a #.
	     * For the the # values we walk and resolve the factories natural key and recursively of any reference factories.
	     * @param val can be passed in as a number or string beginning with #.
	     * @returns
	     */
	    parseNodeId(val: string | number | undefined): Dict<AnyValue>;
	    /**
	     * Returns the natural key string value for the given data.
	     * If a property value is an object and a reference property, it recursively calls the target factory's getNaturalKeyStringValue method.
	     * @param data - The data object containing the property values.
	     * @returns The natural key string value.
	     * @throws LogicError - If the factory does not have a natural key.
	     */
	    getNaturalKeyStringValue(context: Context, data: Dict<AnyValue>): Promise<string>;
	    /**
	     * Returns the natural key value for the given node instance.
	     * If a property is a reference property, it recursively calls the target factory's getNaturalKeyValueFromNode method.
	     * @param node - The node instance.
	     * @returns The natural key as an object.
	     * @throws LogicError - If the factory does not have a natural key.
	     */
	    getNaturalKeyValueFromNode(node: Node): Promise<AnyRecord>;
	    /**
	     * Walks the natural key properties and returns the length of the natural key.
	     * If a property is a reference property, it recursively calls the target factory's getNaturalKeyValueLength method.
	     * This will get us the true length of the natural key value that will be concatenated with `|`
	     * @returns The natural key length.
	     * @throws LogicError - If the factory does not have a natural key.
	     */
	    getNaturalKeyValueLength(): number;
	    /**
	     * Retrieves the reverse vital property associated with this node factory.
	     * A reverse vital property is a property that references this node factory as its target.
	     *
	     * @returns The reverse vital property, or undefined if it doesn't exist.
	     * @throws An error if the vital parent property doesn't have a unique child property with the same name as this factory.
	     */
	    getReverseVitalProperty(): Property | undefined;
	    /**
	     * Returns the list of operations that require admin privileges.
	     */
	    get adminOperations(): string | (keyof Node | StandardOperation)[] | undefined;
	    /** Can this node be customized with customFields
	     * In the case of sub nodes, if a value is set for the isCustomizable decorator on the sub node,
	     * it will override the value set on the base node, otherwise, if no value set on the sub node,
	     * the value of the base node will be inherited
	     */
	    get isCustomizable(): boolean;
	    /** Is this node a synchronization source */
	    get isSynchronizable(): boolean;
	    /** Is this node a synchronization target */
	    get isSynchronized(): boolean;
	    get defaultsToSingleMatch(): boolean;
	    get denyReadOnLookupOnlyAccess(): boolean;
	    executeRule<ResultT extends AnyValue>(state: NodeState, ruleName: NodeRuleName, ...args: AnyValue[]): Promise<ResultT>;
	}
	export { FactoryDecorators };
	//# sourceMappingURL=node-factory.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/node-factory-utils.d.ts
declare module '@sage/xtrem-core/lib/runtime/node-factory-utils' {
	/** @ignore */ /** */
	import { Dict } from '@sage/xtrem-shared';
	import { Parameter, PlainOperationDecorator, TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { Property } from '@sage/xtrem-core/lib/properties/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { NodeIndex } from '@sage/xtrem-core/lib/runtime/node-factory-types';
	export function sameIndexProperties(index1: NodeIndex, index2: NodeIndex): boolean;
	export function arraysAreEqual(a: any[], b: any[]): boolean;
	export function getSchemaDescription(name: string, code: string | undefined): string;
	export function getPropertySchemaDescription(property: Property): string;
	/**
	 * Ensures that a setup factory does not have more than one unique index.
	 */
	export function ensureNoMultipleUniqueIndexes(factory: NodeFactory): void;
	export type FriendlyParameter = (Omit<Omit<Omit<Omit<Parameter, 'node'>, 'dataType'>, 'item'>, 'properties'> & {
	    node?: string;
	    dataType?: string;
	    item?: FriendlyParameter;
	    properties?: Dict<FriendlyParameter>;
	}) | TypeName;
	export function friendlyOperationSignature(operation: PlainOperationDecorator): {
	    parameters: FriendlyParameter[];
	    return: FriendlyParameter;
	};
	//# sourceMappingURL=node-factory-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/node-factory-types.d.ts
declare module '@sage/xtrem-core/lib/runtime/node-factory-types' {
	/** @ignore */ /** */
	import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
	import { MessageListener, NodeDecorator, NodeExtensionDecorator, NotificationListener, PlainOperationDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { ForeignNodeProperty, ReferenceProperty } from '@sage/xtrem-core/lib/properties/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { PropertyDecorator } from '@sage/xtrem-core/lib/runtime/property';
	export interface ReversePropertyStruct {
	    prop: ForeignNodeProperty;
	    join: AnyRecord;
	}
	export interface FactoryLinkedList {
	    previousLink?: FactoryLinkedList;
	    targetFactory: NodeFactory;
	    property: ReferenceProperty;
	}
	export interface FactoryNodeDecorator extends NodeDecorator {
	    readonly name: string;
	    baseNode?: FactoryNodeDecorator;
	}
	export interface FactoryExtensionDecorator extends NodeDecorator {
	    readonly name: string;
	    baseNode?: FactoryNodeDecorator;
	}
	type FilterBase<Base, Condition> = {
	    [Key in keyof Base]: Base[Key] extends Condition ? Key : never;
	};
	type FilterKeys<Base, Condition> = NonNullable<FilterBase<Base, Condition>[keyof Base]>;
	export interface NodeNamedExtensionDecorator extends NodeExtensionDecorator<Node> {
	    name: string;
	}
	export interface FactoryExtensionDecorators {
	    nodeExtension: NodeNamedExtensionDecorator;
	    superDecorators?: FactoryDecorators;
	    properties: PropertyDecorator[];
	    mutations: PlainOperationDecorator[];
	    queries: PlainOperationDecorator[];
	    notificationListeners: NotificationListener[];
	    messageListeners: MessageListener[];
	}
	type FactoryDecoratorsArrayKeys = FilterKeys<FactoryDecorators, any[]>;
	type FactoryExtensionDecoratorsArrayKeys = FilterKeys<FactoryExtensionDecorators, any[]>;
	type NodeFactoryDecoratorsDictKeys = FilterKeys<NodeFactory, any[]>;
	export type FactoryDecoratorsDictArrayKeys = NonNullable<(FactoryDecoratorsArrayKeys | FactoryExtensionDecoratorsArrayKeys) & NodeFactoryDecoratorsDictKeys>;
	export interface ErrorParameters {
	    key: string;
	    message: string;
	    data?: object | AnyValue[];
	    innerError?: Error;
	}
	export {};
	//# sourceMappingURL=node-factory-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/node-factory-cache.d.ts
declare module '@sage/xtrem-core/lib/runtime/node-factory-cache' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { GetValueCallback } from '@sage/xtrem-core/lib/cache/global-cache';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	export class NodeFactoryCache {
	    readonly factory: NodeFactory;
	    constructor(factory: NodeFactory);
	    get cacheCategory(): string;
	    /** fetches data through the cache */
	    fetch<T extends AnyValue>(context: Context, options: {
	        getKey: () => string;
	        getValue: GetValueCallback<T>;
	        isolateInContext: boolean;
	    }): Promise<T>;
	    /**
	     * Invalidates the factory's category in the cache.
	     * This is called when records are inserted, updated and deleted in the factory's table
	     */
	    invalidate(context: Context): Promise<void>;
	    /** Returns the performance counters for the factory's cache */
	    get counters(): NodeFactoryCacheCounters & {
	        totalQueries: number;
	        totalMisses: number;
	        totalHitRate: string;
	        fetchHitRate: string;
	    };
	    postToNewRelic(): void;
	    get performanceSummary(): string;
	    incrementCountQueryCounter(): void;
	    incrementIgnoredCounter(): void;
	}
	//# sourceMappingURL=node-factory-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/monitored-funnel.d.ts
declare module '@sage/xtrem-core/lib/runtime/monitored-funnel' {
	import { Funnel } from '@sage/xtrem-async-helper';
	export function monitoredFunnel(funnelName: string, max?: number): Funnel;
	//# sourceMappingURL=monitored-funnel.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/loggers.d.ts
declare module '@sage/xtrem-core/lib/runtime/loggers' {
	/** @ignore */ /** */
	import { Logger } from '@sage/xtrem-log';
	export const loggers: {
	    application: Logger;
	    globalCache: Logger;
	    authorization: Logger;
	    graphQl: Logger;
	    sql: Logger;
	    sqlMapper: Logger;
	    runtime: Logger;
	    nodeFactory: Logger;
	    core: Logger;
	    globalLock: Logger;
	    property: Logger;
	    operation: Logger;
	    upgrade: Logger;
	    tenant: Logger;
	    queue: Logger;
	    pubsub: Logger;
	    packageManager: Logger;
	    test: Logger;
	    performance: Logger;
	    aws: Logger;
	    compress: Logger;
	    interop: Logger;
	    fileStorage: Logger;
	};
	//# sourceMappingURL=loggers.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/loaded-once.d.ts
declare module '@sage/xtrem-core/lib/runtime/loaded-once' {
	export {};
	//# sourceMappingURL=loaded-once.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/introspection.d.ts
declare module '@sage/xtrem-core/lib/runtime/introspection' {
	/** @packageDocumentation @module runtime */
	import { Application, Package } from '@sage/xtrem-core/lib/application/index';
	import { TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { AnyOrderBy, Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { Enum } from '@sage/xtrem-core/lib/runtime/property';
	export interface IntrospectionPropertyDescriptor {
	    name: string;
	    type: TypeName;
	    isNullable: boolean;
	    isPublished: boolean;
	    code: string | null;
	    isStored: boolean;
	    columnType: TypeName | null;
	    enum: Enum | null;
	    node: typeof Node | null;
	    isNotEmpty: boolean;
	    maxLength: number;
	    precision: number;
	    scale: number;
	    isRequired: boolean;
	}
	export interface IntrospectionIndexDescriptor {
	    isUnique: boolean;
	    orderBy: AnyOrderBy;
	}
	export interface IntrospectionNodeDescriptor {
	    application: Application;
	    package: Package;
	    name: string;
	    tableName?: string;
	    properties: IntrospectionPropertyDescriptor[];
	    indexes: IntrospectionIndexDescriptor[];
	}
	export class Introspection {
	    private readonly context;
	    constructor(context: Context);
	    getNodeFromTableName(tableName: string): typeof Node | undefined;
	    getPropertyNameFromColumnName(clas: typeof Node, columnName: string): string | null;
	    getNodeDescriptor(clas: typeof Node): IntrospectionNodeDescriptor;
	}
	//# sourceMappingURL=introspection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/index.d.ts
declare module '@sage/xtrem-core/lib/runtime/index' {
	export * from '@sage/xtrem-core/lib/runtime/advisory-lock';
	export * from '@sage/xtrem-core/lib/runtime/array-utils';
	export * from '@sage/xtrem-core/lib/runtime/container-manager';
	export * from '@sage/xtrem-core/lib/runtime/context';
	export * from '@sage/xtrem-core/lib/runtime/context-vault';
	export * from '@sage/xtrem-core/lib/runtime/global-lock';
	export * from '@sage/xtrem-core/lib/runtime/monitored-funnel';
	export * from '@sage/xtrem-core/lib/runtime/node-factory';
	export { NodeIndex } from '@sage/xtrem-core/lib/runtime/node-factory-types';
	export { FriendlyParameter, friendlyJsonParse, friendlyOperationSignature } from '@sage/xtrem-core/lib/runtime/node-factory-utils';
	export * from '@sage/xtrem-core/lib/runtime/profiler';
	export * from '@sage/xtrem-core/lib/runtime/running-context';
	export { nanoIdDataType } from '@sage/xtrem-core/lib/runtime/system-data-types';
	export * from '@sage/xtrem-core/lib/runtime/utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/global-lock.d.ts
declare module '@sage/xtrem-core/lib/runtime/global-lock' {
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export class SysGlobalLock extends Node {
	    readonly key: Promise<string>;
	}
	//# sourceMappingURL=global-lock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/debug.d.ts
declare module '@sage/xtrem-core/lib/runtime/debug' {
	/** @ignore */ /** */
	export class Debug {
	    private static lastId;
	    static newId(): number;
	}
	//# sourceMappingURL=debug.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/core-hooks.d.ts
declare module '@sage/xtrem-core/lib/runtime/core-hooks' {
	import { AnyRecord } from '@sage/xtrem-async-helper';
	import { AnyValue, AsyncResponse, Dict, MetaCustomFields, NotificationProgress } from '@sage/xtrem-shared';
	import { RequestHandler } from 'express';
	import { Application, HotUpgradeManager, PrintingManager } from '@sage/xtrem-core/lib/application/index';
	import { AttachmentManager } from '@sage/xtrem-core/lib/application/attachment-manager';
	import { ClientSettingsManager } from '@sage/xtrem-core/lib/application/client-settings-manager';
	import { CsvChecksumManager } from '@sage/xtrem-core/lib/application/csv-checksum-manager';
	import { DashboardManager } from '@sage/xtrem-core/lib/application/dashboard-manager';
	import { NotificationManager } from '@sage/xtrem-core/lib/application/notification-manager';
	import { PackageManager } from '@sage/xtrem-core/lib/application/package-manager';
	import { ServiceOptionManager } from '@sage/xtrem-core/lib/application/service-option-manager';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { AuditManagerInterface } from '@sage/xtrem-core/lib/hooks/auditing/index';
	import { InteropAppInfo } from '@sage/xtrem-core/lib/interop/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { WorkflowManagerInterface } from '@sage/xtrem-core/lib/workflow/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	export interface SourceCode {
	    content: string;
	    file: string;
	    contentToLint?: string;
	}
	export interface WebSocketMessageRequest {
	    tenantId: string;
	    developerId: string;
	    contextId: string;
	    attributes: Dict<AnyValue>;
	    type: string;
	    source: string;
	    request: string;
	    replyId: string;
	    replyTopic: string;
	    locale?: string;
	}
	export interface WebSocketMessageResponse extends WebSocketMessageRequest {
	    response: AnyValue;
	}
	/**
	 * A source code resolver is responsible for returning the response to a web socket request
	 */
	export interface WebSocketMessageHandler {
	    getResponse(application: Application, data: WebSocketMessageRequest): Promise<WebSocketMessageResponse>;
	}
	export interface ExportTemplate {
	    id: string;
	    name: string;
	    isDefault?: boolean;
	}
	export interface NodeExportTemplate {
	    name: string;
	    exportTemplates: ExportTemplate[];
	}
	export interface SecretConfig {
	    xtremEnv?: string;
	    clusterId?: string;
	    secretCacheTimeoutInMinutes?: number;
	}
	/**
	 * The Manager global object contain methods that other packages (like xtrem-system) will override to inject
	 * optional functionality into xtrem-core
	 *
	 * This API is currently very sketchy and will evolve soon.
	 *
	 * The other managers which are currently registered on Context (localizationManager, authorizationManager, ...)
	 * will be moved here.
	 *
	 * TODO: improve this API and suggest a better name.
	 * Maybe something like `InjectedDependencies`, or just 'Hooks'
	 */
	export abstract class CoreHooks {
	    static createPackageManager: (application: Application) => PackageManager;
	    static createServiceOptionManager: (application: Application) => ServiceOptionManager;
	    static createHotUpgradeManager: (_application: Application) => HotUpgradeManager;
	    static createDashboardManager: (_application: Application) => DashboardManager;
	    static createPrintingManager: (_application: Application) => PrintingManager | null;
	    static createClientSettingsManager: (_application: Application) => ClientSettingsManager;
	    static createNotificationManager: (_application: Application) => NotificationManager;
	    static createCsvChecksumManager: (_application: Application) => CsvChecksumManager;
	    static createWorkflowManager: (_application: Application) => WorkflowManagerInterface;
	    static auditManager: AuditManagerInterface;
	    static getAttachmentManager: () => AttachmentManager;
	    static testManager: {
	        loadTestData(_application: Application, _options: {
	            testLayers?: string[];
	        }, _tenantId: string): Promise<void>;
	        /**
	         * Initializes the pack allocation for system factories
	         */
	        initTestTenantActivePackages(_application: Application): Promise<void>;
	    };
	    static webSocketHandlers: Dict<WebSocketMessageHandler>;
	    /** API injected by xtrem-communication */
	    static communicationManager: {
	        /**
	         * Sends a notification
	         */
	        notify(_context: Context, topic: string, _payload: AnyRecord): Promise<string>;
	        /**
	         * Starts an async mutation
	         */
	        startAsyncMutation(_context: Context, factoryName: string, mutationName: string, _payload: AnyRecord): Promise<string>;
	        /**
	         * Tracks the progress of an async mutation
	         */
	        trackAsyncMutation(_context: Context, trackingId: string): Promise<{
	            status: string;
	            result?: AnyValue;
	            errorMessage?: string;
	        }>;
	        /**
	         * Sets ths status of an async mutation to stopRequested
	         */
	        requestStop(_context: Context, trackingId: string, _reason: string): Promise<void>;
	        /**
	         * Sets ths status of an async mutation to stopped
	         */
	        setStopped(_context: Context, trackingId: string): Promise<void>;
	        /**
	         * Tracks the progress of an async mutation
	         */
	        isStopRequested(_context: Context): Promise<boolean>;
	        extendClassDecorator(_factory: NodeFactory): void;
	        updateProgress(_context: Context, _partialProgress: Partial<NotificationProgress>): Promise<void>;
	        logErrorBatchMessage(_context: Context, _message: string): Promise<void>;
	    };
	    static interopManager: {
	        getInteropAppInfo(_context: Context, _app: string): Promise<InteropAppInfo>;
	        interopProxyMiddleware(_application: Application): RequestHandler;
	        getTenantApps(_tenantId: string): Promise<string[] | null>;
	    };
	    /** API injected by xtrem-metadata */
	    static metadataManager: {
	        /**
	         * Synchronize the metadata to the database
	         */
	        upgradeMetadata(_application: Application, _options?: {
	            fullReload?: boolean;
	        }): AsyncResponse<void>;
	        getMetaNodeFactoryConstructor(): StaticThis<Node> | null;
	    };
	    /** API injected by xtrem-system */
	    static sysManager: {
	        /**
	         * Gets the User node
	         */
	        getUserNode(): StaticThis<Node>;
	    };
	    /** API injected by xtrem-customization */
	    static customizationManager: {
	        getWizardUrl(): string;
	        /**
	         * Gets the metadata of the custom fields for a list of node names.
	         */
	        getCustomFields(_context: Context, _nodeNames: string[], _options?: {
	            includeMutableChildren: boolean;
	        }): Promise<MetaCustomFields | undefined>;
	    };
	    /** API injected for import-export data */
	    static importExportManager: {
	        executeExport(_context: Context, _id: string, _filter: string): Promise<string>;
	        getNodeExportTemplates(_context: Context, _nodeName: string): Promise<ExportTemplate[]>;
	        getExportPageUrl(): string;
	    };
	}
	export { PackageManager, ServiceOptionManager };
	//# sourceMappingURL=core-hooks.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/context.d.ts
declare module '@sage/xtrem-core/lib/runtime/context' {
	/// <reference types="node" />
	/** @packageDocumentation @module runtime */
	import { AnyRecord, AnyValue, AsyncArray, AsyncReader, AsyncResponse, UnPromised } from '@sage/xtrem-async-helper';
	import { Datetime } from '@sage/xtrem-date-time';
	import { Logger } from '@sage/xtrem-log';
	import { ConnectionPool, SqlExecuteOptions } from '@sage/xtrem-postgres';
	import { AccessStatus, AuthConfig, AuthorizationError, BusinessRuleError, Config, DataInputError, Diagnosis, Dict, InitialNotification, LocalizeLocale, MetaCustomFields, User, ValidationSeverity } from '@sage/xtrem-shared';
	import { EventEmitter } from 'events';
	import { CookieOptions, Response } from 'express';
	import { Application, NotificationManager, ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { ServiceOptionManager } from '@sage/xtrem-core/lib/application/service-option-manager';
	import { GlobalCacheOptions } from '@sage/xtrem-core/lib/cache/index';
	import { IsolationLevel, NodeKey, StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { LookupsArgs } from '@sage/xtrem-core/lib/graphql/queries/lookup-query';
	import { Property, ReferenceArrayProperty, ReferenceProperty } from '@sage/xtrem-core/lib/properties/index';
	import { TestConfig } from '@sage/xtrem-core/lib/test/index';
	import { Activity, AggregateGroups, AggregateValues, Diagnose, integer, Node, NodeCreateData, NodeQueryFilter, NodeQueryOptions, QueryAggregateOptions, QueryAggregateReturn, ReadAggregateOptions, ReadAggregateReturn } from '@sage/xtrem-core/lib/ts-api/index';
	import { NodeSelectOptions, NodeSelector, NodeSelectResult } from '@sage/xtrem-core/lib/ts-api/node-select-types';
	import { BinaryStream } from '@sage/xtrem-core/lib/types/index';
	import { ConfigurationService } from '@sage/xtrem-core/lib/runtime/configuration-service';
	import { ContextVault } from '@sage/xtrem-core/lib/runtime/context-vault';
	import { Introspection } from '@sage/xtrem-core/lib/runtime/introspection';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Transaction, TransactionOptions } from '@sage/xtrem-core/lib/runtime/transaction';
	export interface NodeReadOptions {
	    forUpdate?: boolean;
	    isTransient?: boolean;
	    isOnlyForLookup?: boolean;
	}
	export interface NodeCreateOptions {
	    isTransient?: boolean;
	    isOnlyForDefaultValues?: boolean;
	    isOnlyForDuplicate?: boolean;
	    isOnlyForLookup?: boolean;
	    writable?: boolean;
	}
	export interface NodeDeleteOptions {
	    skipControls?: boolean;
	    path?: string[];
	}
	export type UserAccess = {
	    status: AccessStatus;
	    sites: string[] | null;
	    accessCodes: string[] | null;
	};
	export const standardOperations: readonly ["create", "update", "delete", "read", "lookup", "import"];
	export type StandardOperation = (typeof standardOperations)[number];
	/**
	 * Extend AccessRightsManager to include Authorization functions from xtrem-authorization
	 */
	export interface AccessRightsManager {
	    /**
	     * getUserAccessFor
	     * Returns a list of Site ids to which a user has access for the specified operation on a Node
	     * Empty array means full access with no restriction on Site
	     * Undefined means no access
	     * @param context
	     * @param nodeName
	     * @param propertyOrOperation a graphQL operation or property name
	     * @param options optional authorizationCode added for external applications(X3)
	     */
	    getUserAccessFor(context: Context, nodeName: string, propertyOrOperation: string, options?: {
	        authorizationCode?: string;
	    }): AsyncResponse<UserAccess>;
	    isAccessCodeAvailable(context: Context, accessCode: string): AsyncResponse<boolean>;
	    createAdminUser(context: Context, data: UserData, options?: CreateAdminUserOptions): AsyncResponse<void>;
	    createRequiredUsers(context: Context): AsyncResponse<void>;
	    ensureAdminPersonaCreated(context: Context): AsyncResponse<UserInfo>;
	    getUser(context: Context, code: string): AsyncResponse<UserInfo>;
	    getCurrentUser(context: Context): AsyncResponse<UserInfo>;
	    getUserNode(): StaticThis<Node>;
	    getPermissions(context: Context, activity: string): AsyncResponse<string[]>;
	    createActivities(context: Context): AsyncResponse<void>;
	    updateActivities(context: Context): AsyncResponse<void>;
	    deleteActivities(context: Context): AsyncResponse<void>;
	    getActivityNode(): StaticThis<Node>;
	    getActivitiesInfo(context: Context): AsyncResponse<ActivityInfo[]>;
	    supportsPersona(context: Context): AsyncResponse<boolean>;
	    getPersonaUser(context: Context, email: string): AsyncResponse<UserInfo | null>;
	    getDemoPersonas(context: Context): AsyncResponse<UserInfo[]>;
	    getUserNavigation?(context: Context): AsyncResponse<UserNavigationInfo>;
	    invalidateAuthorizationCache(context: Context): Promise<void>;
	}
	export interface LocalizationManager extends BaseManager {
	    /**
	     * @param context
	     */
	    getDefaultTenantLocale(context: Context): AsyncResponse<string>;
	    isMasterLocale(context: Context): AsyncResponse<boolean>;
	    createTenantLocale(context: Context, locale: string): AsyncResponse<void>;
	}
	export interface UserData {
	    email: string;
	    firstName: string;
	    lastName: string;
	    locale: string;
	}
	export interface CreateAdminUserOptions {
	    skipWelcomeEmail?: boolean;
	}
	export interface UserNavigationInfo {
	    history?: string[];
	    bookmarks?: string[];
	}
	export interface UserInfo extends User<BinaryStream> {
	    _id: string | number;
	    email: string;
	    firstName?: string;
	    lastName?: string;
	    isActive?: boolean;
	    /** Is this an Admin user */
	    isAdministrator?: boolean;
	    /** Is this user required to be created per tenant */
	    isRequired?: boolean;
	    photo?: BinaryStream | null;
	    userName?: string;
	    isFirstAdminUser?: boolean;
	    isDemoPersona?: boolean;
	    isApiUser?: boolean;
	    locale?: string;
	    clientEncryptionKey?: string;
	}
	export interface ActivityInfo {
	    _id: string | number;
	    name: string;
	}
	export interface ApiApplication {
	    /** API application Id */
	    id: string | undefined;
	    /** API application name */
	    name: string | undefined;
	}
	export type TableExistsCallback = (folder: string, tableName: string) => boolean;
	export interface CustomRecordInterface {
	    bundleId: string;
	    factoryName: string;
	    _customData?: any;
	}
	export type PackVersionInterface = {
	    name: string;
	    version: string;
	    isHidden: boolean;
	    isReleased: boolean;
	    sqlSchemaVersion?: string;
	};
	export interface PackVersionInterfaceWithId extends PackVersionInterface {
	    _id: number;
	}
	export enum PackAllocationStatusEnum {
	    off = 1,
	    preparing = 2,
	    on = 3
	}
	export type PackAllocationStatus = keyof typeof PackAllocationStatusEnum;
	export type PackAllocationInterface = {
	    package: Partial<PackVersionInterface>;
	    isActive: boolean;
	    status: PackAllocationStatus;
	    isActivable: boolean;
	};
	export interface PackVersionOptions {
	    isActivable?: boolean;
	    isHidden?: boolean;
	    isReleased?: boolean;
	    sqlSchemaVersion?: string;
	}
	export type UpdateSetFunctionSet<This> = {
	    [K in Exclude<keyof This, '$' | '_id' | '_sourceId' | '_sortValue'>]?: UnPromised<This[K]> | ((this: This) => This[K] | UnPromised<This[K]>);
	};
	type BulkWhereFilter<This extends Node> = NodeQueryFilter<This>;
	/**
	
	 * Options for bulk updates
	 */
	export interface BulkUpdateOptions<This extends Node> {
	    /**
	     * The 'set' object that describes the properties to be updated with their new value (or functions that return a value).
	     *
	     * Example:
	     * ```
	     *       set {
	     *          description: 'new description',
	     *          value() { return this.otherProperty * 2},
	     *       }
	     * ```
	     */
	    set: UpdateSetFunctionSet<This>;
	    /**
	     * The optional 'where' function to filter the update
	     *
	     * Example:
	     * ```
	     *       where() {
	     *           return this.site === 'siteCode';
	     *       },
	     * ```
	     * or:
	     * ```
	     *       where: {
	     *           site: 'siteCode',
	     *       },
	     * ```
	     */
	    where?: BulkWhereFilter<This>;
	}
	export interface BulkDeleteOptions<This extends Node> {
	    /**
	     * The optional 'where' function to filter the update
	     *
	     * Example:
	     * ```
	     *       where() {
	     *           return this.site === 'siteCode';
	     *       },
	     * ```
	     * or:
	     * ```
	     *       where: {
	     *           site: 'siteCode',
	     *       },
	     * ```
	     */
	    where?: BulkWhereFilter<This>;
	}
	export interface BaseManager {
	    initializeManager(context: Context): void;
	}
	export interface CustomerInfo {
	    id: string;
	    name: string;
	}
	export interface TenantInfoBase {
	    id: string;
	    directoryName?: string;
	}
	export interface TenantInfo extends TenantInfoBase {
	    name: string;
	    directoryName: string;
	    customer: CustomerInfo;
	}
	/** @interface */
	export interface TenantManager extends BaseManager {
	    ensureTenantExists(context: Context, options: {
	        customer: {
	            id: string;
	            name: string;
	        };
	        tenant: {
	            id: string;
	            name: string;
	        };
	    }): AsyncResponse<void>;
	    listTenantsIds(context: Context): AsyncResponse<string[]>;
	    getTenantsInfo(context: Context, tenantId?: string): AsyncResponse<TenantInfo[]>;
	    deleteTenant(application: Application, tenantId: string): AsyncResponse<void>;
	}
	export interface DataSettingsManager extends BaseManager {
	    getSysVendorNode(): StaticThis<Node>;
	    sageVendorId(context: Context): AsyncResponse<number>;
	}
	export interface ContextCacheOptions<T extends AnyValue> extends GlobalCacheOptions<T> {
	}
	interface ErrorParameters {
	    key: string;
	    message: string;
	    data?: object | AnyValue[];
	    innerError?: Error;
	    diagnoses?: Diagnosis[];
	}
	interface CookieDefinition {
	    name: string;
	    options: CookieOptions;
	}
	export enum ContextGetConfigurationKeyEnum {
	    serviceOptionsLevel = 0
	}
	export type ContextGetConfigurationKeyType = keyof typeof ContextGetConfigurationKeyEnum;
	export const rootUserEmail = "root@localhost.domain";
	export const supportUserEmail = "support@localhost.domain";
	export const supportReadonlyUserEmail = "support.readonly@localhost.domain";
	export const adminDemoPersonaEmail = "admin.persona@localhost.domain";
	export const adminDemoPersona: UserInfo;
	export const personaCookieDefinition: (tenantId: string, secure: boolean) => CookieDefinition;
	export interface ContextInternal {
	    userIp: string;
	}
	/**
	 * The _context_
	 *
	 * The context carries important information about the request which is currently being executed,
	 * like the user name and the current locale.
	 *
	 * The context also provides method to initiate transactions, query and create nodes.
	 *
	 * The context is created by the framework when the framework receives a GraphQL request,
	 * and disposed just after the request completes and the response is sent.
	 * Applicative code does not create contexts directly, except to run unit tests (@see [Test](test) API).
	 */
	export class Context extends EventEmitter {
	    readonly application: Application;
	    private readonly options;
	    currentLegislationCode: string;
	    readonly globals: AnyRecord;
	    readonly constants: AnyRecord;
	    readonly customFields: MetaCustomFields;
	    /**
	     * The already logged messages.
	     * - index is the message itself.
	     * - value is the number of times the message should have been logged
	     */
	    private readonly _duplicatedLoggedMessages;
	    /**
	     * The nodes that were saved with the {deferred:true} option (node.$.save({deferred:true}))
	     */
	    private readonly _nodesWithDeferredSave;
	    get source(): ContextSource;
	    get isIsolated(): boolean;
	    get withoutTransactionUser(): boolean;
	    private _contextValues;
	    private _lastTransientId;
	    private _allocateExternalIds;
	    private _lastExternalTransientId;
	    testMode: boolean;
	    testLayers?: string[];
	    private _collectedDependencyPaths?;
	    readonly testConfig?: TestConfig;
	    testNowMock?: string;
	    /**
	     * Are we loading CSV files ?
	     */
	    private _inCsvLoading;
	    /**
	     * The child contexts
	     */
	    private children;
	    /**
	     * Context vault
	     */
	    readonly vault: ContextVault;
	    readonly logger: Logger;
	    readonly sqlFunctionCache: Dict<string>;
	    mappedIds: Dict<number>;
	    private init;
	    static create(application: Application, options: ContextOptions, tenantId: string | null): Promise<Context>;
	    close(): Promise<void>;
	    get schemaName(): string;
	    /**
	     * Register a node that was saved with the {deferred:true} option (node.$.save({deferred:true}))
	     * This node will only be saved to the database at the end of the transaction
	     */
	    queueDeferredSave(node: Node): void;
	    /**
	     * Returns the nodes that were saved with the {deferred:true} option (node.$.save({deferred:true}))
	     */
	    get nodesWithDeferredSave(): Readonly<Node[]>;
	    /**
	     * Log details for an expensive context
	     */
	    private _logDetailsForExpensiveContext;
	    businessRuleError(params: ErrorParameters): BusinessRuleError;
	    private integrityConstraintError;
	    /**
	     * Returns whether a message should be logged (only used when we want to avoid logging the same message multiple times)
	     * This callback will only be invoked when the logger is called with a ignoreCallback option set
	     */
	    shouldIgnoreDuplicateLogs(message: string): boolean;
	    authorizationError(params: ErrorParameters): AuthorizationError;
	    dataInputError(params: ErrorParameters): DataInputError;
	    isSecure(): boolean;
	    isHttp(): this is {
	        response: Response;
	    };
	    /**
	     * subscribeToCacheNotifications subscribes to cache notifications sent by other containers
	     */
	    static subscribeToCacheNotifications(application: Application): Promise<void>;
	    /**
	     * Gets the source of the request
	     */
	    get cloudflareRayID(): string;
	    /**
	     * Gets the source of the request
	     */
	    get requestSource(): string;
	    /**
	     * Gets the cloudflare id or an internal id if not available
	     */
	    get customerRequestId(): string;
	    get originId(): string;
	    get isAborted(): boolean;
	    private checkNotAborted;
	    /**
	     * Returns the current transaction
	     */
	    get transaction(): Transaction;
	    /**
	     * Returns the current tenantId
	     * When null, the context can only be used to access to sharedTables
	     */
	    get tenantId(): string | null;
	    /**
	     * Returns the unsafeApplyToAllTenants flag
	     */
	    get unsafeApplyToAllTenants(): boolean;
	    private resetUsers;
	    /**
	     * Set the current tenantId.
	     * This function should not be used, please set the tenantId when creating the context instead
	     */
	    setTenantId(tenantId: string | null): Promise<void>;
	    /** Returns the dependency paths for the specified property's rule (used by xtrem-cop) */
	    collectDependencyPaths(property: Property, ruleName: 'defaultValue' | 'updatedValue'): string[];
	    /**
	     * @disabled_internal
	     * The list of enabled package for the tenant
	     */
	    getActivePackageNames(): Promise<string[]>;
	    /**
	     * Check if current user has specified permission on an Activity
	     */
	    isAuthorized(activity: Activity, permission: string): Promise<boolean>;
	    getActivities(): Dict<Activity>;
	    isNodeAccessControlled(nodeName: string): boolean;
	    /**
	     * Indicates whether a package is enabled for the tenant
	     */
	    isPackageEnabled(packageName?: string): Promise<boolean>;
	    supportsPersona(): AsyncResponse<boolean>;
	    isDemoPersona(user: {
	        isDemoPersona?: boolean;
	    } | null): Promise<boolean>;
	    /**
	     * The list of active service options for the tenant
	     */
	    get activeServiceOptions(): Promise<ServiceOption[]>;
	    /**
	     * SYNC variant of the service options API
	     * The API is duplicated to avoid disruption but this will be resolved after migration to node 16.
	     * The Sync API is used by external storage. It will superseed the other one (and we will remove the Sync postfix)
	     */
	    /**
	     * Returns `true` if the given service option is available and active
	     * @param serviceOption
	     */
	    isServiceOptionActiveSync(serviceOption: ServiceOption): boolean;
	    /** @disabled_internal */
	    allocateTransientId(): number;
	    /** The current login user */
	    get loginUser(): Promise<UserInfo | null>;
	    /**
	     * The transaction user that will be used as createUser and updateUser in the DB transaction
	     * Note: this user will be null when the context was declared as to be used with sharedTables
	     */
	    get transactionUser(): Promise<Pick<UserInfo, '_id' | 'email'> | null>;
	    private resolveLoginUser;
	    private verifiedUser;
	    private resolvePersonaUser;
	    private setPersonaCookie;
	    setDemoPersona(email: string): Promise<boolean>;
	    get rootUser(): AsyncResponse<UserInfo>;
	    get userId(): string | number;
	    /**
	     * The current user
	     * Note: this user will be null when the context was declared as to be used with sharedTables
	     */
	    get user(): Promise<UserInfo | null>;
	    get currentLocaleLanguage(): string;
	    get currentLocale(): string;
	    setDefaultLocale(): Promise<void>;
	    get defaultLocale(): string;
	    get defaultLanguage(): string;
	    get locales(): string[];
	    get collation(): string | undefined;
	    private static getLocalizedFallback;
	    localize(key: string, template: string, data?: object | AnyValue[], locale?: LocalizeLocale): string;
	    localizeEnumMember(enumName: string, memberName: string): string;
	    getContextValue(key: string): string | undefined;
	    get sqlPool(): ConnectionPool;
	    private static addManager;
	    static get managers(): BaseManager[];
	    static get accessRightsManager(): AccessRightsManager;
	    static set accessRightsManager(value: AccessRightsManager);
	    static get localizationManager(): LocalizationManager;
	    static set localizationManager(value: LocalizationManager);
	    get serviceOptionManager(): ServiceOptionManager;
	    static get tenantManager(): TenantManager;
	    static set tenantManager(value: TenantManager);
	    static get dataSettingsManager(): DataSettingsManager;
	    static set dataSettingsManager(value: DataSettingsManager);
	    static get notificationManager(): NotificationManager;
	    static set notificationManager(value: NotificationManager);
	    /**
	     * Checks if the current user is authorized to perform an operation on a node.
	     * Throws an exception if the user is not authorized.
	     */
	    checkThatNodeOperationIsAuthorized(nodeName: string, operationName: StandardOperation | string): Promise<void>;
	    get isWritable(): boolean;
	    get isAutoCommit(): boolean;
	    private static overallSqlExecutionCount;
	    /**  */
	    private static canRelaxSqlInjectionTest;
	    private static stripRaiseStatements;
	    private static isSafe;
	    private static preventSqlInjections;
	    /**
	     * Utility method used to identify sql statements that are executed more that once for the current context
	     * The log will only be output if the log level of `sage/xtrem-core/performance` is set to `debug`
	     * but the logic will also be executed at verbose level, to update the counts.
	     */
	    private logSql;
	    /**
	     * Method that prints the sql execution count when the context is closed
	     * The log will be output if the log level of `sage/xtrem-core/performance` is set to `debug` or `verbose`
	     */
	    private logSqlSummary;
	    /**
	     * Log the previously ignored messages (duplicate messages)
	     */
	    private logIgnoredDuplicateMessages;
	    /** @disabled_internal */
	    executeSql<T extends AnyValue = AnyValue[]>(sql: string, args: AnyValue[], opts?: SqlExecuteOptions): Promise<T>;
	    /**
	     * Get the current database timestamp
	     * @returns the current timestamp
	     */
	    getSqlTimestamp(): Promise<Datetime>;
	    get mayCommit(): boolean;
	    /**
	     * Flushes the actions that have been queued for execution before the commit.
	     * Call this when you need to force the evaluation of deferredDefaultValue rules
	     * in the middle of a transaction, before the commit.
	     * Use this method with care as it may increase contention between concurrent transactions.
	     */
	    flushDeferredActions(): Promise<void>;
	    /** @disabled_internal */
	    /**
	     * DO NOT USE OUTSIDE OF FRAMEWORK
	     *
	     * executes `body` inside a new context.
	     *
	     * Important: this call leaves the context open because the SQL transaction may be needed
	     * after the body has been exited, for example to produce the response to a graphQl query or mutation.
	     * The child context will be closed when its parent is closed and the caller is responsible
	     * for closing the parent context.
	     * @param options
	     * isDetachedContext is passed as true from runInWritableContext, and flags that the context is detached from the parent, i.e. it will manage itself.
	     */
	    withChildContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options: TransactionOptions & {
	        isDetachedContext?: boolean;
	        source?: ContextSource;
	        isIsolated?: boolean;
	    }): Promise<T>;
	    /**
	     * Runs the provided function in an isolated context.
	     *
	     * @param body - The function to be executed in the isolated context.
	     * @param options - Optional configuration for the isolated context.
	     * @returns A promise that resolves to the result of the function execution.
	     */
	    runInIsolatedContext<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: {
	        isolationLevel?: IsolationLevel;
	        isReadonly?: boolean;
	        disableTenantCrudNotifications?: boolean;
	    }): Promise<T>;
	    /**
	     * executes a `body` passing it a new writable context.
	     * If the current context is writable or the source of the current context is not `listener` then an error is thrown
	     * @returns a promise resolving the result of `body` in a new writable context
	     */
	    runInWritableContext<T extends AnyValue>(body: (context: Context) => AsyncResponse<T>, options?: {
	        isolationLevel?: IsolationLevel;
	        noCommit?: boolean;
	        source?: ContextSource;
	    }): Promise<T>;
	    private diagnosesPrefixes;
	    private _diagnoses;
	    private _severity;
	    get isolationLevel(): IsolationLevel | undefined;
	    /** Returns the timestamp value from the context options. */
	    get timeLimitAsTimestamp(): number;
	    addDiagnoseAtPath(severity: ValidationSeverity, path: string[], message: string): void;
	    resetDiagnoses(): void;
	    get diagnoses(): Diagnose[];
	    get severity(): ValidationSeverity;
	    hasErrors(): boolean;
	    debugString(): string;
	    get introspection(): Introspection;
	    /** specialized API to read configuration data (coming from xtrem-config.yml) */
	    get configuration(): ConfigurationService;
	    /**
	     * Creates a node from given data.
	     * @param clas
	     * @param data
	     */
	    create<T extends Node>(clas: StaticThis<T>, data: NodeCreateData<T>, options?: NodeCreateOptions): Promise<T>;
	    private readNodeState;
	    tryRead<T extends Node>(clas: StaticThis<T>, key: NodeKey<T>, options?: NodeReadOptions): Promise<T | null>;
	    read<T extends Node>(clas: StaticThis<T>, key: NodeKey<T>, options?: NodeReadOptions): Promise<T>;
	    deleteMany<T extends Node>(clas: StaticThis<T>, filter: NodeQueryFilter<T>, options?: NodeDeleteOptions): Promise<number>;
	    delete<T extends Node>(clas: StaticThis<T>, key: AnyRecord): Promise<void>;
	    executeGraphql<T extends AnyValue>(query: string): Promise<T>;
	    executeGraphqlStream<T extends AnyValue>(query: string): Promise<T>;
	    query<T extends Node>(clas: StaticThis<T>, options?: NodeQueryOptions<T>): AsyncArray<T>;
	    /**
	     * Low level select
	     *
	     * Executes a query and returns an array of plain JavaScript objects.
	     * The `selector` parameter specifies the properties included in the response.
	     * The `options` are the same as for context.query.
	     */
	    select<NodeT extends Node, SelectorT extends NodeSelector<NodeT> = NodeSelector<NodeT>>(nodeConstructor: StaticThis<NodeT>, selector: SelectorT, options: NodeSelectOptions<NodeT>): Promise<NodeSelectResult<NodeT, SelectorT>[]>;
	    /**
	     * Low level select reader
	     *
	     * Executes a query and returns a reader of plain JavaScript objects.
	     * The `selector` parameter specifies the properties included in the response.
	     * The `options` are the same as for context.query.
	     */
	    getSelectReader<NodeT extends Node, SelectorT extends NodeSelector<NodeT> = NodeSelector<NodeT>>(nodeConstructor: StaticThis<NodeT>, selector: SelectorT, options: NodeSelectOptions<NodeT>): Promise<AsyncReader<NodeSelectResult<NodeT, SelectorT>>>;
	    /**
	     * Runs a bulk update. The options.set and options.where must be simple enough to be parsed into sql statement.
	     * If not, an error will be raised
	     * @param nodeConstructor
	     * @param options
	     */
	    bulkUpdate<This extends Node>(nodeConstructor: StaticThis<This>, options: BulkUpdateOptions<This>): Promise<number>;
	    /**
	     * Runs a bulk update. The options.set and options.where must be simple enough to be parsed into sql statement.
	     * If not, an error will be raised
	     * @param nodeConstructor
	     * @param options
	     */
	    bulkDeleteSql<This extends Node>(nodeConstructor: StaticThis<This>, options: BulkDeleteOptions<This>): Promise<number>;
	    queryWithReader<NodeT extends Node, ResultT extends AnyValue>(clas: StaticThis<NodeT>, options: NodeQueryOptions<NodeT>, body: (reader: AsyncReader<NodeT>) => AsyncResponse<ResultT>): Promise<ResultT>;
	    queryCount<T extends Node>(clas: StaticThis<T>, options?: NodeQueryOptions<T>): Promise<number>;
	    /**
	     * Queries an aggregate
	     *
	     * @param constructor the node constructor
	     * @param options the query options
	     *
	     * Example:
	     * ```
	     * const results = context.queryAggregates(Invoice, {
	     *     filter: { customer: { country: 'US' } },
	     *     group: { date: { _by:  'month' } },
	     *     values: { amount: { sum: true, avg: true } },
	     * })
	     * ```
	     *
	     * This query will return the monthly sum and average amounts of US invoices.
	     * Typical result will be:
	     *
	     * ```
	     * [{
	     *     group: { date: '01-01-2020' },
	     *     values: { amount: { sum: 5000, avg: 1250 } },
	     * }, {
	     *     group: { date: '01-02-2020' },
	     *     values: { amount: { sum: 3800, avg: 950 } },
	     * }, {
	     *     ...
	     * }]
	     * ```
	     */
	    queryAggregate<T extends Node, GroupT extends AggregateGroups<T>, ValuesT extends AggregateValues<T>>(constructor: StaticThis<T>, options: QueryAggregateOptions<T, GroupT, ValuesT>): AsyncArray<QueryAggregateReturn<T, GroupT, ValuesT>>;
	    /**
	     * Reads an aggregate
	     *
	     * @param constructor the node constructor
	     * @param options the read options
	     *
	     * Example:
	     * ```
	     * const results = context.readAggregates(Invoice, {
	     *     filter: { customer: { country: 'US' } },
	     *     values: { amount: { sum: true, avg: true } },
	     * })
	     * ```
	     *
	     * This query will return the sum and average amounts of all US invoices.
	     * Typical result will be:
	     *
	     * ```
	     * { amount: { sum: 385000, avg: 1439 } }
	     * ```
	     */
	    readAggregate<T extends Node, ValuesT extends AggregateValues<T>>(clas: StaticThis<T>, options: ReadAggregateOptions<T, ValuesT>): Promise<ReadAggregateReturn<T, ValuesT>>;
	    exists<T extends Node>(clas: StaticThis<T>, key: NodeKey<T>): Promise<boolean>;
	    /** wrapper to include reference data in data payloads when creating nodes */
	    static referenceData<T extends Node>(_clas: StaticThis<T>, data: Partial<T>): T;
	    /**
	     * Returns the cached value for a given key. If not found, the getValue callback will be invoked (if provided)
	     * @param category a string that will identify the category of the cached value
	     * @param key the key of the cached value
	     * @param options
	     */
	    getCachedValue<T extends AnyValue>(options: ContextCacheOptions<T>): Promise<T>;
	    /**
	     * Returns the cache category for a given node.
	     * Items that will be cached with this category will be automatically invalidated when the node's table changes.
	     */
	    getNodeCacheCategory(nodeConstructor: StaticThis<Node>): string;
	    /**
	     * Invalidates the cache entries for a given category.
	     * @param category a string that will identify the category of the cached values
	     * @param options
	     *
	     * This is called when records are inserted, updated or deleted in the database
	     * Transactions are isolated from each other so we don't propagate the change to the global cache.
	     * Instead, we just record the category in an array of modified categories, and we use this list
	     * to invalidate the global cache later, when the transaction is committed.
	     */
	    invalidateCachedCategory(category: string, options?: {
	        skipNotify?: boolean;
	    }): Promise<void>;
	    private buildFilter;
	    private lookupQuery;
	    private lookupQueryCount;
	    private makeLookupQueryFilters;
	    private makeLookupQueryParametersWithTransientScope;
	    makeLookupQueryParameters(nodeConstructor: StaticThis<Node>, propertyName: string, args: LookupsArgs): Promise<LookupQueryParameters<Node>>;
	    withLocalizedTextAsJson<T extends AnyValue | void>(body: () => AsyncResponse<T>): Promise<T>;
	    withoutLocalizedTextAsJson<T extends AnyValue | void>(body: () => AsyncResponse<T>): Promise<T>;
	    /**
	     * Scope a body with inCsvLoading set to true
	     * @param body
	     * @returns
	     */
	    withCsvLoading<T>(body: () => T): T;
	    /**
	     * Returns whether we are in a withCsvLoading scope
	     */
	    get inCsvLoading(): boolean;
	    /**
	     * Activates the conversion of references to natural keys during the execution of `body`.
	     * See context.convertReference.
	     */
	    withReferenceAsNaturalKey<T extends AnyValue | void>(body: () => AsyncResponse<T>): Promise<T>;
	    /**
	     * Converts a reference when mapping records returned by SQL queries.
	     * The id is converted if this is called from a context.withReferenceAsNaturalKey body.
	     * Otherwise the id is returned.
	     */
	    convertReference(factory: NodeFactory, id: integer): Promise<string | integer>;
	    private activateTestServiceOptions;
	    isServiceOptionEnabled(serviceOption: ServiceOption, options?: {
	        noCache: boolean;
	    }): Promise<boolean>;
	    setServiceOptionsEnabledFlag(serviceOption: ServiceOption, isEnabled: boolean): void;
	    initializeFactory<NodeT extends Node>(clas: StaticThis<NodeT> | undefined): Promise<void>;
	    static getConfigurationValue(name: ContextGetConfigurationKeyType): string;
	    /**
	     * To be used when getting a property value and you do not want the getPropertyValue error logger to print
	     */
	    withoutGetPropertyValueErrorLogger<T extends AnyValue | void>(body: () => AsyncResponse<T>): Promise<T>;
	    /**
	     * Send notification to the client
	     * @param category
	     * @param payload
	     */
	    notifyUser(notification: InitialNotification): Promise<void>;
	}
	interface LookupQueryParameters<T extends Node> {
	    node: T;
	    property: ReferenceProperty | ReferenceArrayProperty;
	}
	interface ResponseExtra {
	    [key: string]: any;
	}
	export type ContextSource = 'graphql' | 'workflow' | 'listener' | 'routing' | 'internal' | 'customMutation' | 'web-socket' | 'import' | 'rest';
	export interface ContextOptions extends TransactionOptions {
	    userEmail?: string;
	    auth?: AuthConfig;
	    parent?: Context;
	    config?: Config;
	    legislationCode?: string;
	    locale?: string;
	    source?: ContextSource;
	    request?: any;
	    response?: ResponseExtra | Response;
	    /**
	     * signal to abort this context and all its children, any transaction will be rolled back.
	     * This uses the AbortController API available in node.js.
	     * See https://nodejs.org/docs/latest-v20.x/api/all.html#all_globals_class-abortcontroller
	     */
	    signal?: AbortSignal;
	    testMode?: boolean;
	    testLayers?: string[];
	    testNowMock?: string;
	    testConfig?: TestConfig;
	    /**
	     * the list of service options required for the test
	     */
	    testActiveServiceOptions?: ServiceOption[];
	    /**
	     * the list of active package for tests
	     */
	    contextValues?: Dict<string>;
	    /**
	     * Disable all CRUD notifications from triggers
	     */
	    disableAllCrudNotifications?: boolean;
	    /**
	     * Disable tenant CRUD notifications from triggers
	     */
	    disableTenantCrudNotifications?: boolean;
	    /**
	     * Flag used by test contexts to force rollback instead of commit.
	     */
	    noCommit?: boolean;
	    /** is the transaction in auto commit mode - overrides other options  */
	    isAutoCommit?: boolean;
	    /** Do not use lazy loading of property values */
	    noLazyLoading?: boolean;
	    /** Flag to indicate we are creating the root user
	     * This will set transaction user to null to force the default self reference on user insert */
	    withoutTransactionUser?: boolean;
	    /** is this a system context */
	    isSystem?: boolean;
	    /** **DANGER**: This marks that the context will run SQL commands without a tenant filter regardless if they are shared tables or not. */
	    unsafeApplyToAllTenants?: boolean;
	    timeLimitAsTimestamp?: number;
	    skipManagedExternalInit?: boolean;
	    /** Bypass the isFrozen checks - only allowed in test */
	    bypassFrozen?: boolean;
	    /** SQL connection is not available - used to verify ts-to-sql conversions */
	    withoutSqlConnection?: true;
	    /** is this an isolated context */
	    isIsolated?: boolean;
	    /**
	     * An optional description for the context
	     */
	    description?: () => string;
	}
	export {};
	//# sourceMappingURL=context.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/context-vault.d.ts
declare module '@sage/xtrem-core/lib/runtime/context-vault' {
	export {};
	//# sourceMappingURL=context-vault.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/context-natural-key-converter.d.ts
declare module '@sage/xtrem-core/lib/runtime/context-natural-key-converter' {
	import { integer } from '@sage/xtrem-core/lib/ts-api/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	/**
	 * Converter that converts reference ids to natural keys.
	 * It is activated by context.withReferenceAsNaturalKey when running synchronization queries.
	 */
	export class ContextNaturalKeyConverter {
	    private readonly context;
	    constructor(context: Context);
	    /** Size of the cache */
	    static cacheSize: number;
	    /**
	     * Converts a reference when mapping records returned by SQL queries.
	     * It returns the
	     */
	    convertReference(factory: NodeFactory, id: integer): Promise<string | integer>;
	}
	//# sourceMappingURL=context-natural-key-converter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/container-manager.d.ts
declare module '@sage/xtrem-core/lib/runtime/container-manager' {
	export abstract class ContainerManager {
	    private static _containerId;
	    /**
	     * The id of the current container
	     */
	    static get containerId(): string;
	}
	//# sourceMappingURL=container-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/configuration-service.d.ts
declare module '@sage/xtrem-core/lib/runtime/configuration-service' {
	/** @packageDocumentation @module runtime */
	import { Config, DeploymentMode } from '@sage/xtrem-shared';
	export { DeploymentMode };
	export class ConfigurationService {
	    private readonly config;
	    constructor(config: Config);
	    /** deployment mode: allows applicative code to test if code is executing in production or development mode  */
	    get deploymentMode(): DeploymentMode;
	    /** return the configuration data for a given package
	     * @param name: the name of the package. For example '@sage/x3-sales'
	     * @param defaultValue: the default value if there is no data in the config file.
	     */
	    getPackageConfig<T, DefT extends T | undefined = T | undefined>(name: string, defaultValue?: DefT): DefT;
	    /** return the visible name of the product */
	    getProductName(): string;
	}
	//# sourceMappingURL=configuration-service.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/collation-cache.d.ts
declare module '@sage/xtrem-core/lib/runtime/collation-cache' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	export class CollationCache {
	    private static collations;
	    static initFunnel: import("@sage/xtrem-async-helper").Funnel;
	    static init(context: Context): Promise<void>;
	    private static loadCollation;
	    static getCollation(locale: string, localeLanguage: string): string | undefined;
	}
	//# sourceMappingURL=collation-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/array-utils.d.ts
declare module '@sage/xtrem-core/lib/runtime/array-utils' {
	/** @ignore */ /** */
	import { AsyncArray } from '@sage/xtrem-async-helper';
	import { AnyFilterValue, Node } from '@sage/xtrem-core/lib/ts-api/index';
	export function applyFilter<T extends Node = Node>(items: T[], filter: AnyFilterValue, locales?: string[]): AsyncArray<T>;
	//# sourceMappingURL=array-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/runtime/advisory-lock.d.ts
declare module '@sage/xtrem-core/lib/runtime/advisory-lock' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	export function withAdvisoryLock<T extends AnyValue>(context: Context, lockId: number, body: (context: Context) => AsyncResponse<T>): Promise<T>;
	//# sourceMappingURL=advisory-lock.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/uuid-property.d.ts
declare module '@sage/xtrem-core/lib/properties/uuid-property' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { UuidPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export class UuidProperty extends Property {
	    protected _decorator: UuidPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: UuidPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	//# sourceMappingURL=uuid-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/util.d.ts
declare module '@sage/xtrem-core/lib/properties/util' {
	export const isString: (value: any) => value is string;
	export const stringToArrayOfStrings: (value: any) => string[];
	export const isArrayOfStrings: (value: any) => value is string;
	//# sourceMappingURL=util.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/string-property.d.ts
declare module '@sage/xtrem-core/lib/properties/string-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { StringArrayPropertyDecorator, StringPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export class StringProperty extends Property {
	    protected _decorator: StringPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: StringPropertyDecorator, definingPackage: Package);
	    get isNotEmpty(): boolean;
	    get isLocalized(): boolean;
	    get isStoredEncrypted(): boolean;
	    /**
	     * Overrides Property.maxLength
	     */
	    get maxLength(): number;
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	    verify(): void;
	}
	export class StringArrayProperty extends Property {
	    protected _decorator: StringArrayPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: StringArrayPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	    verify(): void;
	}
	//# sourceMappingURL=string-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/stream-property.d.ts
declare module '@sage/xtrem-core/lib/properties/stream-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { BinaryStreamPropertyDecorator, StreamPropertyDecorator, TextStreamPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { BinaryStreamDataType, TextStreamDataType } from '@sage/xtrem-core/lib/types/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export abstract class StreamProperty extends Property {
	    protected _decorator: StreamPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: StreamPropertyDecorator, definingPackage: Package);
	    /**
	     * Returns whether this property should be lazy loaded
	     */
	    get shouldLazyLoad(): boolean;
	}
	export class BinaryStreamProperty extends StreamProperty {
	    protected _decorator: BinaryStreamPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: BinaryStreamPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	    get dataType(): BinaryStreamDataType;
	}
	export class TextStreamProperty extends StreamProperty {
	    protected _decorator: TextStreamPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: TextStreamPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	    verify(): void;
	    get dataType(): TextStreamDataType;
	}
	//# sourceMappingURL=stream-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/property.d.ts
declare module '@sage/xtrem-core/lib/properties/property' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { ColumnTypeName, integer, SystemError } from '@sage/xtrem-shared';
	import { BinaryStreamProperty, TextStreamProperty } from '@sage/xtrem-core/lib/properties/index';
	import { Package, ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { DelegatesTo, PropertyFilterTag, PropertySqlAttributes, TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { PropertyRuleName, SetValueData } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events';
	import { NodeState } from '@sage/xtrem-core/lib/node-state/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { FactoryDecorators, NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Column } from '@sage/xtrem-core/lib/sql/schema/index';
	import { AnyNode, Node, ValidationContext, Validator } from '@sage/xtrem-core/lib/ts-api/index';
	import { DataType, Enum, InternalPropertyJoin } from '@sage/xtrem-core/lib/types/index';
	import { BooleanProperty } from '@sage/xtrem-core/lib/properties/boolean-property';
	import { DateProperty, DateRangeProperty, DatetimeProperty, DatetimeRangeProperty, TimeProperty } from '@sage/xtrem-core/lib/properties/date-time-property';
	import { EnumArrayProperty, EnumProperty } from '@sage/xtrem-core/lib/properties/enum-property';
	import { CollectionProperty, ForeignNodeProperty, ReferenceArrayProperty, ReferenceProperty } from '@sage/xtrem-core/lib/properties/foreign-node-property';
	import { JsonProperty } from '@sage/xtrem-core/lib/properties/json-property';
	import { DecimalProperty, DoubleProperty, FloatProperty, IntegerProperty, NumberProperty } from '@sage/xtrem-core/lib/properties/numeric-property';
	import { StringArrayProperty, StringProperty } from '@sage/xtrem-core/lib/properties/string-property';
	export abstract class Property {
	    protected _decorator: TypedPropertyDecorator;
	    readonly definingPackage: Package;
	    private _dependencyIndex?;
	    private _propagatesTo?;
	    private _column?;
	    protected _columnName?: string;
	    protected _factory: NodeFactory;
	    private _columnType?;
	    private _isInherited?;
	    private _isAutoIncrement?;
	    private _isSystemProperty?;
	    private _isFrozen?;
	    private _defaultValue?;
	    private _deferredDefaultValue?;
	    private _duplicatedValue?;
	    private _updatedValue?;
	    private _adaptValue?;
	    private _getValue?;
	    private _computeValue?;
	    private _setValue?;
	    private _control?;
	    private _prepare?;
	    private _dependsOn?;
	    constructor(factory: NodeFactory, _decorator: TypedPropertyDecorator, definingPackage: Package);
	    get factory(): NodeFactory;
	    get _factoryDecorators(): FactoryDecorators;
	    /**
	     * Returns whether this property should be lazy loaded
	     */
	    get shouldLazyLoad(): boolean;
	    /**
	     * Returns the name of attributes that differ between 2 properties
	     */
	    static getDecoratorsDifferences(prop1: Property | TypedPropertyDecorator, prop2: Property | TypedPropertyDecorator): string[];
	    getLocalizedTitleKey(): string;
	    getLocalizedTitle(context: Context): string;
	    verifyDelegatedToProperty(toProperty: Property): void;
	    private verifyDelegatesTo;
	    private verifyDuplicatedValue;
	    private verifyClearByReset;
	    private verifyDefaultValue;
	    verify(): void;
	    private verifyAnonymizeMethod;
	    addExtension(extension: TypedPropertyDecorator): void;
	    protected verifyExtensionKeys(extensionKeys: string[], authorizedKeys: string[]): void;
	    protected overrideAttributes(extension: TypedPropertyDecorator): void;
	    getTypeDefaultValue(): AnyValue;
	    get decorator(): TypedPropertyDecorator;
	    get name(): string;
	    get fullName(): string;
	    get type(): TypeName;
	    get serviceOptions(): ServiceOption[];
	    get propagatesTo(): PropagatePropertyPath[] | undefined;
	    set propagatesTo(paths: PropagatePropertyPath[] | undefined);
	    get dependsOn(): any[] | undefined;
	    set dependsOn(dependsOn: any[] | undefined);
	    get dependencyIndex(): number | undefined;
	    set dependencyIndex(index: number | undefined);
	    get isOverride(): boolean;
	    get isInherited(): boolean;
	    set isInherited(isInherited: boolean);
	    get isClearedByReset(): InternalBooleanOrUndefined;
	    get duplicateRequiresPrompt(): InternalBooleanOrUndefined;
	    set isSystemProperty(isSystemProperty: boolean);
	    get isSystemProperty(): boolean;
	    get rootProperty(): this;
	    get delegatesTo(): DelegatesTo<AnyNode> | undefined;
	    getDelegatingInfo(): {
	        reference: ReferenceProperty;
	        childProperty: Property;
	    };
	    /** Returns an empty string if the property can be used in an index, otherwise the reason why
	     * the property cannot be used in an index */
	    get invalidForIndexReason(): string;
	    get accessCode(): string | undefined;
	    get isStored(): boolean;
	    get isTransientInput(): boolean;
	    get isStoredOutput(): boolean;
	    get columnType(): ColumnTypeName | undefined;
	    set columnType(columnType: ColumnTypeName | undefined);
	    get columnName(): string | undefined;
	    set columnName(name: string | undefined);
	    get requiredColumnName(): string;
	    get column(): Column | undefined;
	    set column(column: Column | undefined);
	    get isAutoIncrement(): boolean;
	    set isAutoIncrement(isAutoIncrement: boolean);
	    get provides(): PropertyFilterTag[] | undefined;
	    get isOwnedByCustomer(): boolean | undefined;
	    get canSearch(): boolean;
	    get searchCategory(): string | undefined;
	    get lookupAccess(): boolean;
	    get excludedFromPayload(): boolean;
	    get isPublished(): boolean;
	    get isRequired(): boolean;
	    get isFrozen(): InternalBooleanOrUndefined;
	    get dataType(): DataType<AnyValue, Node> | undefined;
	    get isVitalParent(): boolean;
	    get isAssociationParent(): boolean;
	    get isExtendedProperty(): boolean;
	    get max(): integer | undefined;
	    get defaultValue(): InternalDefaultValueRule;
	    set defaultValue(defaultValue: InternalDefaultValueRule);
	    get deferredDefaultValue(): InternalDefaultValueRule;
	    set deferredDefaultValue(deferredDefaultValue: InternalDefaultValueRule);
	    get duplicatedValue(): InternalDuplicatedValueRule;
	    set duplicatedValue(duplicatedValue: InternalDuplicatedValueRule);
	    get updatedValue(): InternalUpdatedValueRule;
	    set updatedValue(updatedValue: InternalUpdatedValueRule);
	    get adaptValue(): ((this: Node, val: AnyValue) => AsyncResponse<AnyValue>) | undefined;
	    set adaptValue(adaptValue: ((this: Node, val: AnyValue) => AsyncResponse<AnyValue>) | undefined);
	    get setValue(): ((this: Node, val: SetValueData<AnyValue>) => AsyncResponse<void>) | undefined;
	    set setValue(setValue: ((this: Node, val: SetValueData<AnyValue>) => AsyncResponse<void>) | undefined);
	    get control(): Validator<Node, AnyValue> | undefined;
	    set control(control: Validator<Node, AnyValue> | undefined);
	    get prepare(): ((this: Node, cx: ValidationContext, val: AnyValue) => AsyncResponse<void>) | undefined;
	    set prepare(prepare: ((this: Node, cx: ValidationContext, val: AnyValue) => AsyncResponse<void>) | undefined);
	    get getValue(): ((this: Node) => AsyncResponse<AnyValue>) | undefined;
	    set getValue(getValue: ((this: Node) => AsyncResponse<AnyValue>) | undefined);
	    get computeValue(): ((this: Node) => AsyncResponse<AnyValue>) | undefined;
	    set computeValue(computeValue: ((this: Node) => AsyncResponse<AnyValue>) | undefined);
	    get isNullable(): boolean;
	    get allowedInUniqueIndex(): boolean;
	    get isVital(): boolean;
	    get isMutable(): boolean;
	    get isNotEmpty(): boolean;
	    get isLocalized(): boolean;
	    get isNotZero(): boolean;
	    get enum(): Enum | undefined;
	    get maxLength(): number | undefined;
	    get countColumnName(): Enum | undefined;
	    get reverseReference(): string | undefined;
	    get join(): InternalPropertyJoin<Node> | undefined;
	    get isOutputOnly(): boolean;
	    get isOnOutputType(): boolean;
	    get isInputOnly(): boolean;
	    get isOnInputType(): boolean;
	    get canTranslateToSql(): boolean;
	    get canSort(): boolean;
	    get canFilter(): boolean;
	    /**
	     * Internal sql attributes used when we generate the column SQL definition.
	     * default - used on the column DEFAULT
	     */
	    get sqlAttributes(): PropertySqlAttributes | undefined;
	    isEnabledByServiceOptions(context: Context): Promise<boolean>;
	    isAuthorized(context: Context): Promise<boolean>;
	    isBooleanProperty(): this is BooleanProperty;
	    isIntegerProperty(): this is IntegerProperty;
	    isFloatingPointProperty(): this is FloatProperty | DoubleProperty;
	    isDecimalProperty(): this is DecimalProperty;
	    isNumberProperty(): this is NumberProperty;
	    isStringProperty(): this is StringProperty;
	    isStringArrayProperty(): this is StringArrayProperty;
	    isDateProperty(): this is DateProperty;
	    isDatetimeProperty(): this is DatetimeProperty;
	    isDatetimeRangeProperty(): this is DatetimeRangeProperty;
	    isDateRangeProperty(): this is DateRangeProperty;
	    isTimeProperty(): this is TimeProperty;
	    isForeignNodeProperty(): this is ForeignNodeProperty;
	    isReferenceProperty(): this is ReferenceProperty;
	    isReferenceArrayProperty(): this is ReferenceArrayProperty;
	    isCollectionProperty(): this is CollectionProperty;
	    isArrayProperty(): boolean;
	    isEnumProperty(): this is EnumProperty;
	    isEnumArrayProperty(): this is EnumArrayProperty;
	    isJsonProperty(): this is JsonProperty;
	    isTextStreamProperty(): this is TextStreamProperty;
	    isBinaryStreamProperty(): this is BinaryStreamProperty;
	    abstract isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(_value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	    executeRule<ResultT extends AnyValue>(state: NodeState, ruleName: PropertyRuleName, ...args: AnyValue[]): Promise<ResultT>;
	    testSqlConversion(fn: () => any): Promise<string | null>;
	    /** Test if getValue and computeValue are correctly configured - used by xtrem-cop  */
	    testSqlConversions(): Promise<integer>;
	    inputError(message: string): SystemError;
	    systemError(message: string): SystemError;
	    logicError(message: string): SystemError;
	}
	export function isPropertyOutputOnly(property: Property): boolean;
	export function isPropertyInputOnly(property: Property): boolean;
	//# sourceMappingURL=property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/numeric-property.d.ts
declare module '@sage/xtrem-core/lib/properties/numeric-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { DecimalPropertyDecorator, DecimalRangePropertyDecorator, DoublePropertyDecorator, FloatPropertyDecorator, IntegerArrayPropertyDecorator, IntegerPropertyDecorator, IntegerRangePropertyDecorator, NumberPropertyDecorator, ShortPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export abstract class NumberProperty extends Property {
	    protected _decorator: NumberPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: NumberPropertyDecorator, definingPackage: Package);
	    get isNotZero(): boolean;
	}
	export class IntegerProperty extends NumberProperty {
	    protected _decorator: IntegerPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: IntegerPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class IntegerArrayProperty extends Property {
	    protected _decorator: IntegerArrayPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: IntegerArrayPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class ShortProperty extends NumberProperty {
	    protected _decorator: ShortPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: ShortPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class FloatProperty extends NumberProperty {
	    protected _decorator: FloatPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: FloatPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	export class DoubleProperty extends NumberProperty {
	    protected _decorator: DoublePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DoublePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	export class DecimalProperty extends NumberProperty {
	    protected _decorator: DecimalPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DecimalPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class IntegerRangeProperty extends Property {
	    protected _decorator: IntegerRangePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: IntegerRangePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	export class DecimalRangeProperty extends Property {
	    protected _decorator: DecimalRangePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DecimalRangePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	//# sourceMappingURL=numeric-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/json-property.d.ts
declare module '@sage/xtrem-core/lib/properties/json-property' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { JsonPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	import { JsonDataType } from '@sage/xtrem-core/lib/types/index';
	export class JsonProperty extends Property {
	    protected _decorator: JsonPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: JsonPropertyDecorator, definingPackage: Package);
	    get dataType(): JsonDataType;
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	//# sourceMappingURL=json-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/index.d.ts
declare module '@sage/xtrem-core/lib/properties/index' {
	export * from '@sage/xtrem-core/lib/properties/boolean-property';
	export * from '@sage/xtrem-core/lib/properties/date-time-property';
	export * from '@sage/xtrem-core/lib/properties/enum-property';
	export * from '@sage/xtrem-core/lib/properties/foreign-node-property';
	export * from '@sage/xtrem-core/lib/properties/json-property';
	export * from '@sage/xtrem-core/lib/properties/numeric-property';
	export * from '@sage/xtrem-core/lib/properties/property';
	export * from '@sage/xtrem-core/lib/properties/stream-property';
	export * from '@sage/xtrem-core/lib/properties/string-property';
	export * from '@sage/xtrem-core/lib/properties/uuid-property';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/foreign-node-property.d.ts
declare module '@sage/xtrem-core/lib/properties/foreign-node-property' {
	import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { ColumnTypeName } from '@sage/xtrem-shared';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { CollectionPropertyDecorator, CollectionPropertyOverrideDecorator, ReferenceArrayPropertyDecorator, ReferencePropertyDecorator, ReferencePropertyOverrideDecorator, TypeName } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Node, NodeQueryFilter, ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	import { InternalPropertyJoin } from '@sage/xtrem-core/lib/types/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export abstract class ForeignNodeProperty extends Property {
	    protected _decorator: ReferencePropertyDecorator | CollectionPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator | CollectionPropertyDecorator, definingPackage: Package);
	    abstract get join(): InternalPropertyJoin<Node> | undefined;
	    get decorator(): ReferencePropertyDecorator | CollectionPropertyDecorator;
	    verify(): void;
	    needsJoin(): boolean;
	    verifyJoin(): void;
	    get reverseReference(): string | undefined;
	    get isVital(): boolean;
	    get isAssociation(): boolean;
	    get isMutable(): boolean;
	    get targetFactory(): NodeFactory;
	    get node(): any;
	    overrideAttributes(extension: ReferencePropertyOverrideDecorator | CollectionPropertyOverrideDecorator): void;
	    /**
	     * Creates a filter for the reverse reference and adds the constructor condition if needed.
	     * @returns
	     */
	    protected getReverseReferenceFilter(): InternalPropertyJoin<Node>;
	}
	export class ReferenceProperty extends ForeignNodeProperty {
	    protected _decorator: ReferencePropertyDecorator;
	    private _isSelfReference;
	    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator, definingPackage: Package);
	    get isVitalParent(): boolean;
	    get isVitalParentInput(): boolean;
	    get canLookup(): boolean;
	    get isAssociationParent(): boolean;
	    get isSelfReference(): boolean;
	    get isRequired(): boolean;
	    private verifyExternalStorage;
	    /**
	     * @returns `true` if this property is a reference that is not nullable or explicitly allowed in indexes
	     * by the `allowedInUniqueIndex` attribute and that is not a self reference
	     */
	    get isHardDependency(): boolean;
	    get isToposortDependency(): boolean;
	    get ignoreIsActive(): boolean | ((this: Node) => AsyncResponse<boolean>) | undefined;
	    verifyDelegatedToProperty(toProperty: Property): void;
	    verify(): void;
	    get join(): InternalPropertyJoin<Node> | undefined;
	    get canTranslateToSql(): boolean;
	    get columnType(): ColumnTypeName | undefined;
	    get filters(): any;
	    isValueTypeValid(value: AnyValue): boolean;
	    getTargetIsActivePropertyName(): string | undefined;
	    addExtension(extension: ReferencePropertyOverrideDecorator): void;
	    overrideAttributes(extension: ReferencePropertyOverrideDecorator): void;
	}
	export class JsonReferenceProperty extends ReferenceProperty {
	    protected _decorator: ReferencePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator, definingPackage: Package);
	    get type(): TypeName;
	    get columnType(): ColumnTypeName | undefined;
	}
	export class ReferenceArrayProperty extends ReferenceProperty {
	    protected _decorator: ReferenceArrayPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: ReferenceArrayPropertyDecorator, definingPackage: Package);
	    get type(): TypeName;
	    get columnType(): ColumnTypeName | undefined;
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class CollectionProperty extends ForeignNodeProperty {
	    protected _decorator: CollectionPropertyDecorator;
	    private _prepareBegin?;
	    private _prepareEnd?;
	    private _controlBegin?;
	    private _controlEnd?;
	    private _saveBegin?;
	    private _saveEnd?;
	    constructor(factory: NodeFactory, _decorator: CollectionPropertyDecorator, definingPackage: Package);
	    get decorator(): CollectionPropertyDecorator;
	    verify(): void;
	    addExtension(extension: CollectionPropertyOverrideDecorator): void;
	    overrideAttributes(extension: CollectionPropertyOverrideDecorator): void;
	    private verifyExternalStorage;
	    get join(): InternalPropertyJoin<Node> | undefined;
	    get orderBy(): AnyRecord | undefined;
	    get prepareBegin(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
	    set prepareBegin(prepareBegin: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
	    get prepareEnd(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
	    set prepareEnd(prepareEnd: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
	    get controlBegin(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
	    set controlBegin(controlBegin: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
	    get controlEnd(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
	    set controlEnd(controlEnd: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
	    get saveBegin(): ((this: Node) => void) | undefined;
	    set saveBegin(saveBegin: ((this: Node) => void) | undefined);
	    get saveEnd(): ((this: Node) => void) | undefined;
	    set saveEnd(saveEnd: ((this: Node) => void) | undefined);
	    get getFilter(): ((this: Node) => AsyncResponse<NodeQueryFilter<Node>>) | undefined;
	    needsJoin(): boolean;
	    get forceFullSave(): boolean;
	    isValueTypeValid(value: AnyValue): boolean;
	}
	//# sourceMappingURL=foreign-node-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/enum-property.d.ts
declare module '@sage/xtrem-core/lib/properties/enum-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { EnumArrayPropertyDecorator, EnumPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Enum, EnumDataType } from '@sage/xtrem-core/lib/types/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export class EnumProperty extends Property {
	    protected _decorator: EnumPropertyDecorator | EnumArrayPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: EnumPropertyDecorator | EnumArrayPropertyDecorator, definingPackage: Package);
	    get dataType(): EnumDataType;
	    get enum(): Enum;
	    isValueTypeValid(value: AnyValue): boolean;
	    getTypeDefaultValue(): AnyValue;
	}
	export class EnumArrayProperty extends EnumProperty {
	    protected _decorator: EnumArrayPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: EnumArrayPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	//# sourceMappingURL=enum-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/date-time-property.d.ts
declare module '@sage/xtrem-core/lib/properties/date-time-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { DatePropertyDecorator, DateRangePropertyDecorator, DatetimePropertyDecorator, DatetimeRangePropertyDecorator, TimePropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export class DateProperty extends Property {
	    protected _decorator: DatePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DatePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class DateRangeProperty extends Property {
	    protected _decorator: DateRangePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DateRangePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class DatetimeProperty extends Property {
	    protected _decorator: DatetimePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DatetimePropertyDecorator, definingPackage: Package);
	    needsTypeConversion(value: AnyValue): boolean;
	    isValueTypeValid(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class DatetimeRangeProperty extends Property {
	    protected _decorator: DatetimeRangePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: DatetimeRangePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	export class TimeProperty extends Property {
	    protected _decorator: TimePropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: TimePropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	}
	//# sourceMappingURL=date-time-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/create-property.d.ts
declare module '@sage/xtrem-core/lib/properties/create-property' {
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export function createProperty(factory: NodeFactory, propertyDecorator: TypedPropertyDecorator, definingPackage: Package): Property;
	//# sourceMappingURL=create-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/properties/boolean-property.d.ts
declare module '@sage/xtrem-core/lib/properties/boolean-property' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Package } from '@sage/xtrem-core/lib/application/index';
	import { BooleanPropertyDecorator } from '@sage/xtrem-core/lib/decorators/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Property } from '@sage/xtrem-core/lib/properties/property';
	export class BooleanProperty extends Property {
	    protected _decorator: BooleanPropertyDecorator;
	    constructor(factory: NodeFactory, _decorator: BooleanPropertyDecorator, definingPackage: Package);
	    isValueTypeValid(value: AnyValue): boolean;
	    needsTypeConversion(value: AnyValue): boolean;
	    mapInputValue(value: AnyValue): AnyValue;
	}
	//# sourceMappingURL=boolean-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-visit.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-visit' {
	export {};
	//# sourceMappingURL=state-visit.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-utils.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-utils' {
	export {};
	//# sourceMappingURL=state-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-update.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-update' {
	export {};
	//# sourceMappingURL=state-update.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-set-value.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-set-value' {
	export {};
	//# sourceMappingURL=state-set-value.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-save.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-save' {
	export {};
	//# sourceMappingURL=state-save.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-prepare.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-prepare' {
	export {};
	//# sourceMappingURL=state-prepare.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-payload.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-payload' {
	export {};
	//# sourceMappingURL=state-payload.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-old.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-old' {
	export {};
	//# sourceMappingURL=state-old.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-new.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-new' {
	export {};
	//# sourceMappingURL=state-new.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-load.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-load' {
	export {};
	//# sourceMappingURL=state-load.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-join.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-join' {
	export {};
	//# sourceMappingURL=state-join.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-invalidate.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-invalidate' {
	export {};
	//# sourceMappingURL=state-invalidate.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-intern.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-intern' {
	export {};
	//# sourceMappingURL=state-intern.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-init.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-init' {
	export {};
	//# sourceMappingURL=state-init.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-get-value.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-get-value' {
	export {};
	//# sourceMappingURL=state-get-value.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-duplicate.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-duplicate' {
	/** @packageDocumentation @module runtime */
	import { AnyRecord } from '@sage/xtrem-async-helper';
	import { NodeState } from '@sage/xtrem-core/lib/node-state/node-state';
	/** Method to duplicate a node */
	export class StateDuplicate {
	    /**
	     * Negate vital references on vital graph for new records to be inserted
	     * clear vendor values
	     * @param factory
	     * @param data
	     * @returns
	     */
	    private static convertVitalData;
	    /**
	     * Negate non-vital references on vital graph
	     * @param factory
	     * @param data
	     * @param mappedIds
	     * @returns
	     */
	    private static convertNonVitalReferenceData;
	    private static getForeignNodePropertyDuplicatedValue;
	    private static getPropertyDuplicatedValue;
	    /** Apply duplicatedValue */
	    private static setDuplicatedValuesInData;
	    private static duplicateState;
	    /**
	     * Duplicate the passed in node state. Returns the unsaved node state
	     */
	    static duplicate(state: NodeState, data?: AnyRecord): Promise<NodeState>;
	    /**
	     * Get a duplicated transient instance of the state passed in
	     * The vital collection tree branches loaded can be limited with using the option limitCollections
	     * This is to improve the performance of the getDuplicate query
	     * @param state
	     * @param options
	     * @returns
	     */
	    static getDuplicate(state: NodeState, options?: {
	        limitCollections?: number;
	    }): Promise<NodeState>;
	}
	//# sourceMappingURL=state-duplicate.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-dependency.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-dependency' {
	export {};
	//# sourceMappingURL=state-dependency.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-delete.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-delete' {
	export {};
	//# sourceMappingURL=state-delete.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-cursor.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-cursor' {
	export {};
	//# sourceMappingURL=state-cursor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-control.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-control' {
	export {};
	//# sourceMappingURL=state-control.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/state-access.d.ts
declare module '@sage/xtrem-core/lib/node-state/state-access' {
	export {};
	//# sourceMappingURL=state-access.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/node-state.d.ts
declare module '@sage/xtrem-core/lib/node-state/node-state' {
	/** @packageDocumentation @module runtime */
	import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Decimal } from '@sage/xtrem-decimal';
	import { DataInputError, Dict, LogicError, SystemError, ValidationSeverity } from '@sage/xtrem-shared';
	import { InternalAttachmentAssociationData } from '@sage/xtrem-core/lib/application/index';
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/index';
	import { CollectionProperty, Property } from '@sage/xtrem-core/lib/properties/index';
	import { Context, NodeDeleteOptions, NodeReadOptions } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { NodeConstructOptions } from '@sage/xtrem-core/lib/runtime/node-factory-types';
	import { SyncInfo } from '@sage/xtrem-core/lib/synchronization/sync-info';
	import { AnyNode, Collection, Node, NodePayloadOptions, NodeSaveOptions, NodeStatus, NodeUpdateData, OrderBy, datetime } from '@sage/xtrem-core/lib/ts-api/index';
	interface ErrorParameters {
	    key: string;
	    message: string;
	    data?: object | AnyValue[];
	    innerError?: Error;
	}
	/**
	 * NodeState instances manage the _state_ of a node instance.
	 *
	 * There is exactly one NodeState instance for each node instance, accessible with `node.$.state`.
	 * The entire state of the node instance is tracked in its `node.$.state` instance.
	 *
	 * @disabled_internal
	 */
	export class NodeState {
	    readonly factory: NodeFactory;
	    /** The node instance */
	    readonly node: Node;
	    /**
	     * Was the node read for update
	     */
	    readonly forUpdate: boolean;
	    /**
	     * The values of the properties.
	     */
	    values: AnyRecord;
	    statesToUpdate: [NodeState, string[]][];
	    /**
	     * The values of the reference properties, as node instances.
	     * For _stored_ reference properties, state.values contains the `_id` of the referenced node,
	     * whereas state.references contains the node instance.
	     */
	    readonly references: Map<string, Node | null>;
	    /**
	     * The values of the reference array properties, as node instance arrays.
	     * For _stored_ reference array properties, state.values contains the array of `_id` of the referenced nodes,
	     * whereas state.referenceArrays contains the node instance array.
	     */
	    readonly referenceArrays: Map<string, Node[] | null>;
	    /**
	     * The values of the collection properties, as collection instances.
	     * The state.values does not contain any value for collection properties.
	     */
	    readonly collections: Map<string, BaseCollection>;
	    /**
	     * The internal status of the node.
	     * This status is more detailed than the status returned by node.$.status (which is a NodeStatus, not a StateStatus)
	     */
	    status: StateStatus;
	    /**
	     * Is the state a thunk?
	     * A thunk is a partial state in which `state.values` does not have values for all the _stored_ properties.
	     * The missing values will be lazy loaded by reading the record from the database. This will reset the thunk flag.
	     */
	    isThunk: boolean;
	    /**
	     * Is the state for a transient node instance?
	     */
	    readonly isTransient: boolean;
	    /**
	     * Was this state created only to obtain default values?
	     */
	    readonly isOnlyForDefaultValues: boolean;
	    /**
	     * Is the state created only for a lookup query?
	     */
	    readonly isOnlyForLookup: boolean;
	    /**
	     * Is the state created only for a duplicate query?
	     */
	    readonly isOnlyForDuplicate: boolean;
	    /**
	     * Old state that we saved the first time this state was modified.
	     * This is used by `node.$.old`.
	     */
	    oldState: NodeState | undefined;
	    /**
	     * Is this the _old_ state of a node
	     */
	    readonly isOld: boolean;
	    /** Set of properties that have been invalidated because properties upon which they depend have been modified */
	    readonly invalidProperties: Set<string>;
	    /** Set of properties that have been invalidated because properties upon which they depend have been modified */
	    readonly deferredProperties: Dict<boolean>;
	    /** list of column names that have been modified and not saved yet */
	    dirtyColumnNames: Dict<true>;
	    /**
	     * Index of the last property that we are allowed to access while executing an event.
	     *
	     * This limit is used to verify that we only access properties that P _depends upon_
	     * when we execute rules attached to P (a property).
	     */
	    dependencyLimit: number;
	    /** Unique debug id allocated by incrementing `NodeState.nextDebugId` */
	    readonly debugId: number;
	    /** Will this state be skipped during control and save */
	    skipSave: boolean;
	    /** Global counter to allocate `state.debugId` */
	    private static nextDebugId;
	    /** The state's constructor */
	    constructor(context: Context, factory: NodeFactory, values: AnyRecord, status: StateStatus, options: NodeConstructOptions);
	    /**
	     * Unique key values for node interning
	     * Format: <Root factory name>:<key property1 name>:<key property1 value>,<key property2 name>:<key property2 value>, ...
	     * Examples:
	     *      Currency:_id:1
	     *      Currency:code:USD
	     *      BaseDocument:_id:1
	     *      BaseDocumentLine:_id:1
	     *      BaseDocumentLine:_sortValue:100,document:1
	     */
	    get interningKeys(): Dict<string>;
	    get interningKeyValues(): string[];
	    /** The collection to which the node belongs. Only set if the node is loaded from a collection */
	    private _collection?;
	    /**
	     * The collection to which the node belongs. Only set if the node is loaded from a collection
	     */
	    get collection(): BaseCollection | undefined;
	    get context(): Context;
	    /**
	     * The node status
	     *
	     * This accessor maps the internal StateStatus values to NodeStatus values.
	     * See node.$.status.
	     */
	    get nodeStatus(): NodeStatus;
	    /** Is the state readonly? */
	    get isReadonly(): boolean;
	    /** Is the state writable? (opposite of isReadonly) */
	    get isWritable(): boolean;
	    /** Checks if status of the current state is created/constructed */
	    get isNew(): boolean;
	    /**
	     * Is the state effectively readonly?
	     *
	     * Writable states are put in readonly mode during the execution of some rules
	     * (defaultValue, updatedValue, control, controlDelete).
	     * This accessor returns true while these rules are executed.
	     */
	    get isEffectivelyReadonly(): boolean;
	    /** Is the state stale? */
	    get isStale(): boolean;
	    /** Returns the value of a property */
	    getPropertyValue(property: Property): Promise<AnyValue>;
	    /** Returns the value of a property */
	    getPropertyValueSync(property: Property): AnyValue;
	    /** Returns the value of a property, given the property name */
	    getValue<T extends AnyValue>(propertyName: string): Promise<T>;
	    /** Returns the value of a property */
	    getValueSync<T extends AnyValue>(propertyName: string): T;
	    /** Set the value of a property */
	    setPropertyValue(property: Property, value: AnyValue): Promise<void>;
	    /** Set the value of a property, given the property name */
	    setValue(propertyName: string, value: AnyValue): Promise<void>;
	    /** Set new values into the state. See node.$.set */
	    set(data: NodeUpdateData<Node>, path?: string[]): Promise<void>;
	    isPropertyValueDeferred(property: Property): boolean;
	    /** The old state. See node.$.old */
	    get old(): Promise<Node>;
	    /** The _id of the node */
	    get id(): number;
	    /** The _sortValue of the node */
	    get sortValue(): Promise<number>;
	    /** The vendor of the node */
	    get vendor(): Promise<Node | null>;
	    /** Set the _sortValue of the node */
	    setSortValue(value: number): Promise<void>;
	    /** The _createUser of the node */
	    get createdBy(): Promise<Node | number>;
	    /** The _updateUser of the node */
	    get updatedBy(): Promise<Node | number>;
	    /** The _createStamp of the node */
	    get createStamp(): Promise<datetime>;
	    /** The _updateStamp of the node */
	    get updateStamp(): Promise<datetime>;
	    /** The _syncTick of the node (sync source only) */
	    get syncTick(): Promise<Decimal>;
	    /** The _syncInfo of the node (sync target only) */
	    get syncInfo(): Promise<SyncInfo>;
	    /** The _etag entity tag of the node (updateStamp as a string)  */
	    get etag(): Promise<string>;
	    /** The custom property data of the node */
	    get customData(): Promise<object>;
	    /** The custom property data of the node */
	    get valuesHash(): Promise<string>;
	    /** attachments collection */
	    get attachments(): Collection<InternalAttachmentAssociationData & Node>;
	    /** Adds a diagnose to the state's context */
	    addDiagnose(severity: ValidationSeverity, path: string[], message: string): void;
	    /** Validates the state. See node.$validate */
	    control(): Promise<boolean>;
	    /** Tries to save the state. See node.$.trySave */
	    trySave(options?: NodeSaveOptions): Promise<boolean>;
	    /** Saves the state. See node.$.save */
	    save(options?: NodeSaveOptions): Promise<void>;
	    /** Tries to delete the state. See node.$.tryDelete */
	    tryDelete(options?: NodeDeleteOptions): Promise<boolean>;
	    /** Deletes the state.  See node.$.delete */
	    delete(options?: NodeDeleteOptions): Promise<void>;
	    getKeyValues(): AnyRecord;
	    /** The key token, a string that uniquely identifies a node within its factory */
	    get keyToken(): string;
	    getNaturalKeyValue(): Promise<string>;
	    /** The cursor value for a given ordering. Used by paging API */
	    getCursorValue(orderBy: OrderBy<Node>): Promise<string>;
	    /** Returns the join values. Used by collections */
	    getJoinValues(property: CollectionProperty): AsyncResponse<AnyRecord>;
	    payload(options?: NodePayloadOptions<AnyNode>): Promise<AnyRecord>;
	    duplicate(data?: AnyRecord): Promise<NodeState>;
	    /** Returns an error prefixed by the factory and property name */
	    propertySystemError(property: Property, message: string): SystemError;
	    /** Returns an error prefixed by the factory and property name */
	    propertyDataInputError(property: Property, params: ErrorParameters): DataInputError;
	    /** Returns an error prefixed by the factory name */
	    systemError(message: string): SystemError;
	    /** Returns an error prefixed by the factory name */
	    logicError(message: string): LogicError;
	    /** Returns an error prefixed by the factory name */
	    dataInputError(params: ErrorParameters): DataInputError;
	    /** Returns a new NodeState for a record created with context.create */
	    static newFromContextCreate(context: Context, factory: NodeFactory, path: string[], data: AnyRecord, options?: {
	        isTransient?: boolean;
	        isOnlyForDefaultValues?: boolean;
	        isOnlyForDuplicate?: boolean;
	        writable?: boolean;
	        isOnlyForLookup?: boolean;
	        collection?: BaseCollection;
	    }): Promise<NodeState>;
	    /** Returns a new NodeState for a record read individually from the database */
	    static newFromRead(context: Context, factory: NodeFactory, key: AnyValue, options: NodeReadOptions & {
	        dontThrow?: boolean;
	    }): Promise<NodeState | null>;
	    /** Returns a new NodeState for a record read by a database query */
	    static newFromQuery(context: Context, factory: NodeFactory, record: AnyRecord, forUpdate: boolean): NodeState;
	    /** Returns whether the node is frozen
	     */
	    isNodeFrozen(): AsyncResponse<boolean>;
	    /**
	     * Returns whether the property is frozen
	     */
	    isPropertyFrozen(property: Property): AsyncResponse<boolean>;
	}
	export {};
	//# sourceMappingURL=node-state.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/lazy-loaded-marker.d.ts
declare module '@sage/xtrem-core/lib/node-state/lazy-loaded-marker' {
	export {};
	//# sourceMappingURL=lazy-loaded-marker.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/node-state/index.d.ts
declare module '@sage/xtrem-core/lib/node-state/index' {
	export { lazyLoadedMarker } from '@sage/xtrem-core/lib/node-state/lazy-loaded-marker';
	export * from '@sage/xtrem-core/lib/node-state/node-state';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/index.d.ts
declare module '@sage/xtrem-core/lib/metrics/index' {
	export { recordXtremEventToNewrelic } from '@sage/xtrem-core/lib/metrics/newrelic/custom-event-emiter';
	export { ThirdPartyRequestAuditor } from '@sage/xtrem-core/lib/metrics/newrelic/third-party-request-auditor';
	export { CustomMetrics } from '@sage/xtrem-core/lib/metrics/prometheus/custom-metrics';
	export { DebugMetrics } from '@sage/xtrem-core/lib/metrics/prometheus/debug-metrics';
	export { Gauge } from '@sage/xtrem-core/lib/metrics/prometheus/gauge';
	export { Histogram } from '@sage/xtrem-core/lib/metrics/prometheus/histogram';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/prometheus/histogram.d.ts
declare module '@sage/xtrem-core/lib/metrics/prometheus/histogram' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { HistogramConfiguration, LabelValues } from 'prom-client';
	export const allMetricsEnabled: boolean;
	export interface HistogramOptions<LabelNameT extends string> extends HistogramConfiguration<LabelNameT> {
	    enabledInProduction?: boolean;
	}
	export class Histogram<LabelNameT extends string> {
	    static createdCount: number;
	    constructor(options: HistogramOptions<LabelNameT>);
	    get isEnabled(): boolean;
	    withMetrics<ResultT extends AnyValue>(labelValues: LabelValues<LabelNameT>, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=histogram.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/prometheus/gauge.d.ts
declare module '@sage/xtrem-core/lib/metrics/prometheus/gauge' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	import { GaugeConfiguration, LabelValues } from 'prom-client';
	export const allMetricsEnabled: boolean;
	export interface GaugeOptions<LabelNameT extends string> extends GaugeConfiguration<LabelNameT> {
	    enabledInProduction?: boolean;
	}
	export class Gauge<LabelNameT extends string> {
	    static createdCount: number;
	    constructor(options: GaugeOptions<LabelNameT>);
	    get isEnabled(): boolean;
	    withMetrics<ResultT extends AnyValue>(labelValues: LabelValues<LabelNameT>, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=gauge.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/prometheus/debug-metrics.d.ts
declare module '@sage/xtrem-core/lib/metrics/prometheus/debug-metrics' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-shared';
	/**
	 * This class can be used to instrument some piece of code for debugging
	 *
	 * @example
	 * ```
	 * DebugMetrics.withMetrics('myDomain', 'myKey', () => ....)
	 * ```
	 *
	 * To enable the recording of metrics:
	 * - environment variable: set either XTREM_ALL_METRICS_ENABLED or XTREM_DEBUG_METRICS_ENABLED to 1
	 * - xtrem-config.yml file: set deploymentMode to 'development'
	 * - xtrem-config.yml file: enable the domain you want to use:
	 * ```
	debugMetrics:
	      myDomain: true
	 * ```
	 */
	export class DebugMetrics {
	    private static readonly counter;
	    private static _isEnabled;
	    static withMetrics<ResultT extends AnyValue>(domain: string, key: string, body: () => AsyncResponse<ResultT>): Promise<ResultT>;
	}
	//# sourceMappingURL=debug-metrics.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/prometheus/custom-metrics.d.ts
declare module '@sage/xtrem-core/lib/metrics/prometheus/custom-metrics' {
	/// <reference types="node" />
	import { Express } from 'express';
	import { OperationKind } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { NodeRuleName } from '@sage/xtrem-core/lib/decorators/node-decorators/node-events';
	import { PropertyRuleName } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events';
	import EventEmitter = require('node:events');
	export const allMetricsEnabled: boolean;
	export type StatementKind = 'select' | 'insert' | 'update' | 'upsert' | 'delete';
	export class CustomMetrics {
	    static readonly emitter: EventEmitter<[never]>;
	    static readonly rules: CustomCounters<{
	        nodeName: string;
	        propertyName: string;
	        ruleName: NodeRuleName | PropertyRuleName;
	    }>;
	    static readonly graphql: CustomCounters<{
	        nodeName: string;
	        operationName: string;
	        operationKind: OperationKind;
	    }>;
	    static readonly metadata: CustomCounters<{
	        nodeName: string;
	        operationName: string;
	        operationKind: OperationKind;
	    }>;
	    static readonly sql: CustomCounters<{
	        nodeName: string;
	        statementKind: StatementKind;
	    }>;
	    static get expressApp(): Express;
	}
	//# sourceMappingURL=custom-metrics.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/newrelic/web-transaction.d.ts
declare module '@sage/xtrem-core/lib/metrics/newrelic/web-transaction' {
	export function setWebTransactionName(callback: () => string | null): void;
	//# sourceMappingURL=web-transaction.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/newrelic/third-party-request-auditor.d.ts
declare module '@sage/xtrem-core/lib/metrics/newrelic/third-party-request-auditor' {
	import { RequestKind, ThirdParty } from '@sage/xtrem-core/lib/metrics/newrelic/custom-event-emiter';
	export interface NullableTenantId {
	    tenantId: string | null;
	}
	/**
	 * Aims at sending to newrelic some statistics related to 3rd party external calls
	 */
	export class ThirdPartyRequestAuditor {
	    private readonly thirdParty;
	    private readonly requestKind;
	    private readonly recordKind;
	    private readonly asyncRequest;
	    private readonly tenantId;
	    private readonly startedAt;
	    private recordCount?;
	    private customDurationInMs;
	    constructor(context: NullableTenantId, thirdParty: ThirdParty, requestKind: RequestKind, recordKind: string, async: boolean, recordCount?: number);
	    static newIntacctSingleRecordRead(context: {
	        tenantId: string | null;
	    }, recordKind?: string, async?: boolean): ThirdPartyRequestAuditor;
	    static newIntacctSingleRecordCreate(context: {
	        tenantId: string | null;
	    }, recordKind?: string, async?: boolean): ThirdPartyRequestAuditor;
	    static newAvalaraSingleRecordRead(context: {
	        tenantId: string | null;
	    }, recordKind?: string): ThirdPartyRequestAuditor;
	    recordSuccess(recordCount?: number): void;
	    recordFailure(recordCount?: number): void;
	    /**
	     * In async mode we can't rely on the object creation to calculate request duration, this allows you to manually set it
	     * When set it override the value sent to newrelic.
	     * @param durationInMs how long it took from request to response in millisecond
	     */
	    withCustomDuration(durationInMs: number): ThirdPartyRequestAuditor;
	    private recordResult;
	}
	//# sourceMappingURL=third-party-request-auditor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/metrics/newrelic/custom-event-emiter.d.ts
declare module '@sage/xtrem-core/lib/metrics/newrelic/custom-event-emiter' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	export enum ThirdParty {
	    intacct = "Intacct",
	    frp1000 = "FRP1000",
	    avalara = "Avalara",
	    taxServiceFabric = "TaxService"
	}
	export enum RequestKind {
	    read = "Read",
	    list = "List",
	    create = "Create",
	    delete = "Delete",
	    update = "Update",
	    execute = "Execute",// compute something not related to a given entity
	    unknown = "Unknown"
	}
	export interface ThirdPartyNewrelicEvent {
	    thirdParty: ThirdParty;
	    requestKind: RequestKind;
	    tenantId: string;
	    success: boolean;
	    durationMs: number;
	    recordKind: string;
	    recordCount: number;
	    async: boolean;
	}
	/**
	 * Send to newrelic a custom event related to a 3rd party integration event that can then be used to gather metrics and create dashboards
	 * @param event
	 */
	export function record3rdPartyEventToNewrelic(event: ThirdPartyNewrelicEvent): void;
	export interface NewrelicXtremEvent {
	    tenantId?: string;
	    durationMs?: number;
	    success: boolean;
	    eventKind: string;
	}
	/**
	 * Record execution of message, notification or async mutation to newrelic
	 * @param event
	 */
	export function recordXtremEventToNewrelic(event: NewrelicXtremEvent): void;
	/**
	 * Record an unhandled error in NewRelic
	 * @param context
	 * @param err
	 */
	export function recordXtremErrorToNewrelic(context: Context, err: Error): void;
	//# sourceMappingURL=custom-event-emiter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/interop/notification-topic.d.ts
declare module '@sage/xtrem-core/lib/interop/notification-topic' {
	import { LogicError } from '@sage/xtrem-shared';
	import { Application, Package } from '@sage/xtrem-core/lib/application/index';
	/** Options passed to the NotificationTopic constructor. */
	export interface NotificationTopicConstructOptions {
	    /**
	     * The app name. It is only set in inter-app notification topics.
	     * It identifies the app which produces the notifications.
	     *
	     * If the topic is internal to an application (intra-app), app must be empty.
	     */
	    appName: string;
	    /**
	     * The notification topic:
	     * - /appName/nodeName/eventName if inter-app
	     * - nodeName/eventName if intra-app
	     */
	    topic: string;
	}
	/**
	 * Class for notification topics
	 *
	 * A NotificationTopic describes a topic which may be listened to by this app or by other apps deployed in the cluster.
	 */
	export class NotificationTopic {
	    private readonly options;
	    /**
	     * const myNotificationTopic = new NotificationTopic({ app: myApp, topic: '/myApp/myNode/myEvent' })
	     */
	    constructor(options: NotificationTopicConstructOptions);
	    /**
	     * The app which produces the notification.
	     *
	     * This property must be:
	     * - non-null for inter-app notifications
	     * - null for intra-app notifications.
	     */
	    get appName(): string;
	    /** The name of the notification topic */
	    get name(): string;
	    /** The topic */
	    get topic(): string;
	    /** Friendly title for the topic */
	    get title(): string;
	    /** The package which defines the notification topic */
	    get definingPackage(): Package;
	    /** The application object */
	    get application(): Application;
	    /** Utility to create a LogicError. Prefixes the message with the topic name */
	    logicError(message: string): LogicError;
	    /** Throws an error if the verify method has not been called. */
	    checkVerified(): void;
	}
	//# sourceMappingURL=notification-topic.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/interop/interop-graphql-client.d.ts
declare module '@sage/xtrem-core/lib/interop/interop-graphql-client' {
	import { Datetime } from '@sage/xtrem-date-time';
	import { Logger } from '@sage/xtrem-log';
	import { AnyValue, AppConfig, Dict } from '@sage/xtrem-shared';
	import { AxiosRequestConfig, AxiosResponse } from 'axios';
	import { ExecutionPatchResult, ExecutionResult } from 'graphql';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	export const logger: Logger;
	/** Options passed to the App constructor. */
	export interface AppConstructOptions {
	    /** The name of the app */
	    name: string;
	    /** The version of the app (semver) */
	    version: string;
	}
	export interface AppInteropToken {
	    tenantId: string;
	    appName: string;
	    scope: string;
	    sourceUserEmail: string;
	}
	export interface AppInteropClaims extends AppInteropToken {
	    iat: number;
	    exp: number;
	}
	export interface GraphQlResponse<ResponseDataT = unknown, RequestDataT = {}> extends AxiosResponse<ResponseDataT, RequestDataT> {
	}
	export interface GraphQlRequestOptions {
	    appName: string;
	    scope: string;
	    query: string;
	    variables?: Dict<AnyValue>;
	    config?: AxiosRequestConfig;
	}
	export interface AppHealthInfo {
	    /** The timestamp of the health check */
	    timestamp: Datetime;
	    /** The duration of the health check */
	    duration: number;
	    /** The status of the health check */
	    status: number;
	    /** The status text of the health check */
	    statusText?: string;
	    /** Whether the app is alive or not */
	    isAlive: boolean;
	}
	/**
	 * InteropGraphqlClient is a client to send GraphQL (or ping) requests to other apps.
	 */
	export class InteropGraphqlClient {
	    private static getSignatureKey;
	    /**
	     * Returns a bearer jwt token for a tenant id
	     * @param payload the payload of the token
	     * @returns the bearer token
	     * @throws an error if the tenant id is missing
	     */
	    private static getBearerToken;
	    /**
	     * Parse a bearer token and return the claims
	     * @param token the bearer token
	     * @returns the claims
	     * @throws an error if the token is invalid
	     */
	    static parseBearerToken(token: string): Promise<AppInteropToken>;
	    /**
	     * Returns the email of the user for the given scope
	     * @param scope the scope
	     * @returns the email of the user
	     */
	    static getScopeUserEmail(scope: string): string;
	    /**
	     * Returns the url of the app for the given service url key (appUrl, interopUrl, metricsUrl)
	     * @param appName the name of the app
	     * @param key the service url key
	     * @returns the url of the app
	     */
	    static getUrl(appName: string, key: keyof AppConfig): string;
	    /**
	     * Returns the url of the app
	     * @param appName the name of the app
	     * @returns the url of the app
	     */
	    static getAppUrl(appName: string): string;
	    /**
	     * Returns the url of the app for interop
	     * @param appName the name of the app
	     * @returns the url of the app for interop
	     */
	    static getInteropUrl(appName: string): string;
	    private static getRequestConfig;
	    /**
	     * Sends a GraphQL request to this app.
	     * @param context the context which provides the tenant id and the user's email
	     * @param options a { query, variables } object
	     * @returns the GraphQl response
	     */
	    private static sendAnyGraphqlRequest;
	    private static interopError;
	    /**
	     * Sends a GraphQL request to this app.
	     * @param context the context which provides the tenant id and the user's email
	     * @param options the graphql request options
	     * @returns the GraphQl response
	     */
	    static sendGraphqlRequest<ResponseDataT>(context: Context, options: GraphQlRequestOptions): Promise<GraphQlResponse<ExecutionResult<ResponseDataT>>>;
	    /**
	     * Sends a GraphQL stream request to this app.
	     * @param context the context which provides the tenant id and the user's email
	     * @param options the graphql request options
	     * @returns the GraphQl response
	     */
	    static sendStreamGraphqlRequest<FirstResultT, PatchResultT>(context: Context, options: GraphQlRequestOptions): Promise<GraphQlResponse<AsyncGenerator<ExecutionResult<FirstResultT> | ExecutionPatchResult<PatchResultT>>>>;
	    /**
	     * Get the health info of an app
	     * @param appName the name of the app
	     * @returns the health info of the app
	     */
	    static getAppHealth(appName: string): Promise<AppHealthInfo>;
	}
	//# sourceMappingURL=interop-graphql-client.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/interop/interop-app.d.ts
declare module '@sage/xtrem-core/lib/interop/interop-app' {
	import { AuthConfig } from '@sage/xtrem-shared';
	import { Express } from 'express';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	export interface InteropAppInfo {
	    name: string;
	    title: string;
	    isConnector: boolean;
	    interopPackage: string;
	    isActive: boolean;
	}
	export interface InteropAuthConfig extends AuthConfig {
	    appName: string;
	    scope: string;
	    sourceUserEmail: string;
	    iat: number;
	    exp: number;
	}
	/**
	 * Creates an express app that serves the interop API.
	 * @param application The application to serve.
	 * @returns The express app.
	 */
	export function interopApp(application: Application): Express;
	//# sourceMappingURL=interop-app.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/interop/interop-app-health-monitor.d.ts
declare module '@sage/xtrem-core/lib/interop/interop-app-health-monitor' {
	/**
	 * This class manages the health monitoring of the apps.
	 *
	 * Periodically ping the apps to get their status.
	 */
	export {};
	//# sourceMappingURL=interop-app-health-monitor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/interop/index.d.ts
declare module '@sage/xtrem-core/lib/interop/index' {
	export * from '@sage/xtrem-core/lib/interop/interop-app';
	export * from '@sage/xtrem-core/lib/interop/interop-app-health-monitor';
	export * from '@sage/xtrem-core/lib/interop/interop-graphql-client';
	export * from '@sage/xtrem-core/lib/interop/notification-topic';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/http/request.d.ts
declare module '@sage/xtrem-core/lib/http/request' {
	import { Request, Response } from 'express';
	interface RequestWithId extends Request {
	    [requestIdSymbol]?: number | string;
	}
	const requestIdSymbol: unique symbol;
	export function setRequestId(request: RequestWithId, id: number | string): void;
	export function getRequestId(request: RequestWithId): number | string | undefined;
	export function getResponseId(response: Response): number | string | undefined;
	export {};
	//# sourceMappingURL=request.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/http/logger-middleware.d.ts
declare module '@sage/xtrem-core/lib/http/logger-middleware' {
	import { Logger } from '@sage/xtrem-log';
	import { Handler } from 'express';
	/**
	 * The compression middleware must be disabled in verbose and debug levels
	 * because we need the response body in clear text.
	 *
	 * @returns whether the compression middleware should be loaded or not.
	 */
	export function loggerAllowsCompress(logger: Logger): boolean;
	/**
	 * The request logger middleware.
	 * This middleware should be loaded first, so that we log all requests,
	 * even those which may contain invalid JSON
	 */
	export function requestLoggerMiddleware(logger: Logger): Handler;
	/**
	 * The body logger middleware.
	 * This middleware must be loaded after the middleware which parses the JSON body
	 */
	export function bodyLoggerMiddleware(logger: Logger): Handler;
	//# sourceMappingURL=logger-middleware.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/http/index.d.ts
declare module '@sage/xtrem-core/lib/http/index' {
	export * from '@sage/xtrem-core/lib/http/logger-middleware';
	export * from '@sage/xtrem-core/lib/http/request';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/html/utils.d.ts
declare module '@sage/xtrem-core/lib/html/utils' {
	export interface ToHtmlTextOptions {
	    shrinkEmptyLines?: boolean;
	}
	export function htmlFragment(html: string, options?: {
	    path?: string;
	    unChanged?: boolean;
	}): string;
	export function htmlBody(html: string, unChanged?: boolean): string;
	export function toHtmlText(html: string, options?: ToHtmlTextOptions): string;
	//# sourceMappingURL=utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/html/index.d.ts
declare module '@sage/xtrem-core/lib/html/index' {
	export * from '@sage/xtrem-core/lib/html/utils';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/hooks/auditing/index.d.ts
declare module '@sage/xtrem-core/lib/hooks/auditing/index' {
	export * from '@sage/xtrem-core/lib/hooks/auditing/audit-manager-interface';
	export * from '@sage/xtrem-core/lib/hooks/auditing/audit-manager-stub';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/hooks/auditing/audit-manager-stub.d.ts
declare module '@sage/xtrem-core/lib/hooks/auditing/audit-manager-stub' {
	import { AuditManagerInterface } from '@sage/xtrem-core/lib/hooks/auditing/audit-manager-interface';
	export const auditManagerStub: AuditManagerInterface;
	//# sourceMappingURL=audit-manager-stub.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/hooks/auditing/audit-manager-interface.d.ts
declare module '@sage/xtrem-core/lib/hooks/auditing/audit-manager-interface' {
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { TriggerBuilder } from '@sage/xtrem-core/lib/sql/index';
	export interface AuditManagerInterface {
	    getTriggerFunctionsSql(schemaName: string): string;
	    isAuditEnabled(context: Context): Promise<boolean>;
	    /**
	     * The trigger builder in charge of the 'audit_table' trigger
	     */
	    auditTriggerBuilder?: TriggerBuilder;
	}
	//# sourceMappingURL=audit-manager-interface.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/schema-builder.d.ts
declare module '@sage/xtrem-core/lib/graphql/schema-builder' {
	import { GraphQLSchema } from 'graphql';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { TypeCache } from '@sage/xtrem-core/lib/graphql/utils/type-cache';
	/**
	 * @disabled_internal
	 *
	 * Static class to generate the GraphQL schema for a given application
	 */
	export class SchemaBuilder {
	    private static createQueries;
	    private static createMutations;
	    private static createTypes;
	    private static getNamespace;
	    /** @disabled_internal */
	    static typeCache: TypeCache;
	    static getSchema(application: Application, context?: Context): Promise<GraphQLSchema>;
	}
	//# sourceMappingURL=schema-builder.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/index.d.ts
declare module '@sage/xtrem-core/lib/graphql/index' {
	export * from '@sage/xtrem-core/lib/graphql/graphql-express';
	export * from '@sage/xtrem-core/lib/graphql/metadata-schema/index';
	export { QueryPage } from '@sage/xtrem-core/lib/graphql/paging/paging';
	export { PagingFilter } from '@sage/xtrem-core/lib/graphql/paging/paging-filter';
	export * from '@sage/xtrem-core/lib/graphql/schema-builder';
	export { AccessRights } from '@sage/xtrem-core/lib/graphql/security/access-rights';
	export { executeBulkAction } from '@sage/xtrem-core/lib/graphql/utils/bulk-utils';
	export * from '@sage/xtrem-core/lib/graphql/utils/request';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/graphql-express.d.ts
declare module '@sage/xtrem-core/lib/graphql/graphql-express' {
	import { Config } from '@sage/xtrem-shared';
	import { Express } from 'express';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	export interface GraphQLAppOptions {
	    graphqlTimeLimitInSeconds?: number;
	}
	export const graphQlTimeLimitInSeconds: () => number;
	export function graphQlApp(application: Application, options?: GraphQLAppOptions): Express;
	export function getTenantId(application: Application, config: Config): string | null;
	export function graphQlMetadata(application: Application): Express;
	//# sourceMappingURL=graphql-express.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/utils/type-cache.d.ts
declare module '@sage/xtrem-core/lib/graphql/utils/type-cache' {
	import { GraphQLType } from 'graphql';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	/**
	 * @disabled_internal
	 *
	 * Static class to cache GraphQL types so that we don't generate two copies of the same type.
	 */
	export class TypeCache {
	    readonly application: Application;
	    /**
	     * typesCache is a dictionary such as:
	     *        - each key is the name of a GraphQl type
	     *        - each value is an actual GraphQl type.
	     */
	    private readonly typesCache;
	    constructor(application: Application);
	    /**
	     * Adds a type named `name` in the `this.typesCache` cache as the result of executing `body`, only if the type has not been added yet.
	     * Interning is a method of storing only one copy of each distinct string value (see https://en.wikipedia.org/wiki/String_interning)
	     * @param name The name of the type to be defined
	     * @param body The function that will be executed to define the new type
	     */
	    internType<T extends GraphQLType | undefined>(name: string, body: () => T): T;
	    getCached<T extends GraphQLType | undefined>(name: string): T;
	    /** @disabled_internal */
	    addCacheEntry<T extends GraphQLType | undefined>(name: string, body: () => T): void;
	}
	//# sourceMappingURL=type-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/utils/request.d.ts
declare module '@sage/xtrem-core/lib/graphql/utils/request' {
	import { Request } from 'express';
	/**
	 * Return a string representing a hint on the GraphQL query purpose
	 * @param request the HTTP request
	 * @returns the string hint or null
	 */
	export function getGraphQlHint(request: Request): string | null;
	//# sourceMappingURL=request.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/utils/bulk-utils.d.ts
declare module '@sage/xtrem-core/lib/graphql/utils/bulk-utils' {
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export const executeBulkAction: (context: Context, filter: string, nodeConstructor: typeof Node, { body, onComplete, }: {
	    body: (subContext: Context, instance: Node) => Promise<unknown>;
	    onComplete?: (context: Context, results: unknown[]) => Promise<void>;
	}) => Promise<number>;
	//# sourceMappingURL=bulk-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/property-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/property-type' {
	export {};
	//# sourceMappingURL=property-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/operation-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/operation-type' {
	export {};
	//# sourceMappingURL=operation-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/object-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/object-type' {
	import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
	import { AsyncResponse } from '@sage/xtrem-shared';
	import { GraphQLType } from 'graphql';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { TypeCache } from '@sage/xtrem-core/lib/graphql/utils/type-cache';
	import { GraphQlTypingMode } from '@sage/xtrem-core/lib/graphql/types/node-type';
	import { GraphQlFactory, GraphQlProperty } from '@sage/xtrem-core/lib/graphql/types/property-type';
	export class ObjectType {
	    static makeObjectType(typeCache: TypeCache, factory: GraphQlFactory, property: GraphQlProperty, typingMode: GraphQlTypingMode): GraphQLType;
	    static getInputValue(context: Context, val: AnyValue, factory: GraphQlFactory, property: GraphQlProperty): AsyncResponse<AnyValue>;
	    static getObjectInputValue(context: Context, val: AnyValue, factory: GraphQlFactory): AsyncResponse<AnyRecord | null>;
	}
	//# sourceMappingURL=object-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/node-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/node-type' {
	export type GraphQlTypingMode = 'nodeOutput' | 'nodeInput' | 'values' | 'group' | 'parameter' | 'return';
	//# sourceMappingURL=node-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/enum-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/enum-type' {
	export {};
	//# sourceMappingURL=enum-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/basic-types.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/basic-types' {
	import { DateRange, Datetime, DatetimeRange, DateValue, DecimalRange, IntegerRange, Time } from '@sage/xtrem-date-time';
	import { integer } from '@sage/xtrem-shared';
	import { GraphQLScalarType } from 'graphql';
	export const externalReferenceInputType: GraphQLScalarType<unknown, unknown>;
	export const booleanInputType: GraphQLScalarType<boolean, any>;
	export type ScalarObjectTypes = DateValue | DateRange | DatetimeRange | IntegerRange | Datetime | DecimalRange | Time | integer[] | string[] | string;
	export interface TenantContext {
	    tenantPackages: string[];
	}
	//# sourceMappingURL=basic-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/array-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/array-type' {
	import { AnyValue } from '@sage/xtrem-shared';
	import { GraphQLType } from 'graphql';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { TypeCache } from '@sage/xtrem-core/lib/graphql/utils/type-cache';
	import { GraphQlTypingMode } from '@sage/xtrem-core/lib/graphql/types/node-type';
	import { GraphQlFactory, GraphQlProperty } from '@sage/xtrem-core/lib/graphql/types/property-type';
	export class ArrayType {
	    static makeArrayType(typeCache: TypeCache, factory: GraphQlFactory, property: GraphQlProperty, typingMode: GraphQlTypingMode): GraphQLType;
	    static getArrayInputValue(context: Context, val: AnyValue[], factory: GraphQlFactory, property: GraphQlProperty): Promise<AnyValue[]>;
	}
	//# sourceMappingURL=array-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/types/access-type.d.ts
declare module '@sage/xtrem-core/lib/graphql/types/access-type' {
	export {};
	//# sourceMappingURL=access-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/security/access-rights.d.ts
declare module '@sage/xtrem-core/lib/graphql/security/access-rights' {
	import { Dict } from '@sage/xtrem-shared';
	import { StandardOperation } from '@sage/xtrem-core/lib/runtime/index';
	export interface AccessRightsOptions {
	    factory: {
	        name: string;
	    };
	    args?: Dict<any>;
	    operation?: StandardOperation | string;
	    /** Is this a mutation */
	    isMutation?: boolean;
	    /** Is this a property access operation */
	    isPropertyAccess?: boolean;
	}
	//# sourceMappingURL=access-rights.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/security/access-bindings.d.ts
declare module '@sage/xtrem-core/lib/graphql/security/access-bindings' {
	import { AccessStatus } from '@sage/xtrem-shared';
	export interface AccessBinding {
	    node?: string;
	    bind?: string;
	}
	/**
	 * Interface representing the access of node property or operation
	 */
	export interface NodeAccessBindingStatus {
	    /**
	     * name of the operation or property
	     */
	    name: string;
	    /**
	     * access status of the  operation or property
	     */
	    status: AccessStatus;
	}
	//# sourceMappingURL=access-bindings.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/node-read.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/node-read' {
	export {};
	//# sourceMappingURL=node-read.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/node-query.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/node-query' {
	export {};
	//# sourceMappingURL=node-query.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/node-queries.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/node-queries' {
	export {};
	//# sourceMappingURL=node-queries.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/lookups.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/lookups' {
	export {};
	//# sourceMappingURL=lookups.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/lookup-total-count.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/lookup-total-count' {
	export {};
	//# sourceMappingURL=lookup-total-count.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/lookup-query.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/lookup-query' {
	export {};
	//# sourceMappingURL=lookup-query.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/get-total-count.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/get-total-count' {
	export {};
	//# sourceMappingURL=get-total-count.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/get-duplicate.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/get-duplicate' {
	export {};
	//# sourceMappingURL=get-duplicate.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/get-defaults.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/get-defaults' {
	export {};
	//# sourceMappingURL=get-defaults.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/queries/collection-query.d.ts
declare module '@sage/xtrem-core/lib/graphql/queries/collection-query' {
	export {};
	//# sourceMappingURL=collection-query.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/paging/paging.d.ts
declare module '@sage/xtrem-core/lib/graphql/paging/paging' {
	import { AggregateGroups, AggregateValues, Node, QueryAggregateReturn } from '@sage/xtrem-core/lib/ts-api/index';
	export interface QueryPageInfo {
	    endCursor?: string;
	    hasNextPage: boolean;
	    startCursor?: string;
	    hasPreviousPage?: boolean;
	    totalCount?: number;
	}
	export interface QueryEdge<T = any> {
	    node: T;
	    cursor: string;
	}
	export interface QueryNode<T = any> {
	    query: QueryPage<T>;
	}
	export interface QueryPage<T = any> {
	    totalCount?: number;
	    edges?: QueryEdge<T>[];
	    pageInfo?: QueryPageInfo;
	}
	export interface QueryAggregateNode<T extends Node> {
	    queryAggregate: QueryAggregatePage<T>;
	}
	export interface QueryAggregatePage<T extends Node> {
	    totalCount?: number;
	    edges?: QueryAggregateEdge<T>[];
	    pageInfo?: QueryPageInfo;
	}
	export interface QueryAggregateEdge<T extends Node> {
	    node: QueryAggregateReturn<T, AggregateGroups<T>, AggregateValues<T>>;
	    cursor: string;
	}
	//# sourceMappingURL=paging.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/paging/paging-types.d.ts
declare module '@sage/xtrem-core/lib/graphql/paging/paging-types' {
	import { GraphQLObjectType } from 'graphql';
	export const pageInfoType: GraphQLObjectType<any, any>;
	//# sourceMappingURL=paging-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/paging/paging-order-by.d.ts
declare module '@sage/xtrem-core/lib/graphql/paging/paging-order-by' {
	export {};
	//# sourceMappingURL=paging-order-by.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/paging/paging-filter.d.ts
declare module '@sage/xtrem-core/lib/graphql/paging/paging-filter' {
	export {};
	//# sourceMappingURL=paging-filter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/mutations/node-mutations.d.ts
declare module '@sage/xtrem-core/lib/graphql/mutations/node-mutations' {
	export {};
	//# sourceMappingURL=node-mutations.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/mutations/duplicate-mutation.d.ts
declare module '@sage/xtrem-core/lib/graphql/mutations/duplicate-mutation' {
	export {};
	//# sourceMappingURL=duplicate-mutation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/mutations/delete-mutation.d.ts
declare module '@sage/xtrem-core/lib/graphql/mutations/delete-mutation' {
	export {};
	//# sourceMappingURL=delete-mutation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/mutations/create-update-mutations.d.ts
declare module '@sage/xtrem-core/lib/graphql/mutations/create-update-mutations' {
	export {};
	//# sourceMappingURL=create-update-mutations.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/mutations/bulk-update-mutation.d.ts
declare module '@sage/xtrem-core/lib/graphql/mutations/bulk-update-mutation' {
	import { Dict } from '@sage/xtrem-shared';
	import { GraphQLFieldConfig } from 'graphql';
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { TypeCache } from '@sage/xtrem-core/lib/graphql/utils/type-cache';
	export class BulkUpdateMutation {
	    /** Resolver for `mutation { xtremFoo { Bar { create/update/updateById(data/id: ...) { ... } } } }` mutations */
	    static makeResolver(typeCache: TypeCache, factory: NodeFactory): GraphQLFieldConfig<unknown, Context, {
	        filter: string;
	        data: Dict<any>;
	    }>;
	}
	//# sourceMappingURL=bulk-update-mutation.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/workflow-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/workflow-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getWorkflowSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=workflow-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/widgets-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/widgets-fragment' {
	import { GraphQLFieldConfigArgumentMap } from 'graphql';
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const artifactArgsWithFilterWithGroup: GraphQLFieldConfigArgumentMap;
	export const getWidgetsSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=widgets-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/user-info-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/user-info-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getUserInfoSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=user-info-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/strings-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/strings-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getStringsSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=strings-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/stickers-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/stickers-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getStickersSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=stickers-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/sitemap-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/sitemap-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getSitemapSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=sitemap-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/service-options-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/service-options-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getServiceOptionsSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=service-options-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/printing-settings-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/printing-settings-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getPrintingSettingsSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=printing-settings-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/pages-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/pages-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getPagesSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=pages-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/notification-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/notification-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getNotificationSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=notification-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/node-operations.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/node-operations' {
	import { PlainOperationDecorator, PlainParameter } from '@sage/xtrem-core/lib/decorators/index';
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	export class NodeOperations {
	    static getLocalizedTitle(context: Context, factory: NodeFactory, operation: PlainOperationDecorator): string;
	    static getLocalizedParameter(context: Context, factory: NodeFactory, operation: PlainOperationDecorator, parameter: PlainParameter): string;
	}
	//# sourceMappingURL=node-operations.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/node-names-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/node-names-fragment' {
	import { GraphQLObjectType } from 'graphql';
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const nodeDetailsFields: {
	    name: {
	        type: import("graphql").GraphQLScalarType<string, string>;
	    };
	    title: {
	        type: import("graphql").GraphQLScalarType<string, string>;
	    };
	};
	export const nodeDetailsNameType: GraphQLObjectType<any, any>;
	export const getNodeNamesSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=node-names-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/node-details-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/node-details-fragment' {
	import { GraphQLFieldConfigArgumentMap, GraphQLList, GraphQLObjectType } from 'graphql';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const nodeDetailsType: GraphQLObjectType;
	export const nodeDetailsFilter: GraphQLFieldConfigArgumentMap;
	export const nodeDetailsListType: GraphQLList<GraphQLObjectType<any, any>>;
	export interface NodeDetailsListArgs {
	    missingNodeNames: string[];
	    knownNodeNames: string[];
	    depth: number | null;
	}
	export const nodeDetailsListArgs: GraphQLFieldConfigArgumentMap;
	export const nodeCustomDetailsType: GraphQLObjectType;
	export const nodeCustomDetailsListType: GraphQLList<GraphQLObjectType<any, any>>;
	export const resolveNodeDetails: (context: Context, nodeName: string) => any;
	export const resolveNodeCustomDetails: (context: Context, nodeName: string) => Promise<any>;
	export const resolveNodeDetailsList: (context: Context, args: NodeDetailsListArgs) => Promise<any[]>;
	export const resolveNodeCustomDetailsList: (context: Context, args: NodeDetailsListArgs) => Promise<any[]>;
	export const getNodeDetailsSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=node-details-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/metadata-schema-utils.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils' {
	/// <reference types="@sage/xtrem-i18n" />
	import { GraphQLFieldConfig, GraphQLFieldConfigArgumentMap, GraphQLFieldConfigMap, GraphQLList, GraphQLObjectType } from 'graphql';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { ArtifactFilter } from '@sage/xtrem-core/lib/system/artifact-manager';
	import { ApplicationArtifact, ClientArtifactType } from '@sage/xtrem-core/lib/system/pages/client-service';
	export interface MetadataSchemaFragment {
	    queries?: GraphQLFieldConfigMap<any, any>;
	    mutations?: GraphQLFieldConfigMap<any, any>;
	}
	export const extensionsType: GraphQLList<import("graphql").GraphQLScalarType<string, string>>;
	export const fragmentsType: GraphQLList<GraphQLObjectType<any, any>>;
	export const pluginsType: GraphQLList<import("graphql").GraphQLScalarType<string, string>>;
	export const accessListType: GraphQLList<GraphQLObjectType<any, any>>;
	export const localizationsType: GraphQLList<GraphQLObjectType<any, any>>;
	export const getArtifactStringsConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
	export const getArtifactTitleConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
	export const getArtifactDescriptionConfig: (artifactType: ClientArtifactType) => GraphQLFieldConfig<ApplicationArtifact, Context>;
	export const artifactArgsWithFilter: GraphQLFieldConfigArgumentMap;
	export const pagesArgsWithFilter: GraphQLFieldConfigArgumentMap;
	export const resolveArtifact: (application: Application, artifactType: ClientArtifactType) => (_obj: unknown, args: {
	    filter: ArtifactFilter;
	}, context: Context) => Promise<{
	    extensions?: string[] | undefined;
	    plugins?: string[] | undefined;
	    menuItem?: string | undefined;
	    priority?: number | undefined;
	    strings?: import("@sage/xtrem-i18n").LocalizedLiteral[] | undefined;
	    className?: string | undefined;
	    md5?: string | undefined;
	    title?: string | undefined;
	    authorizationCode?: string | undefined;
	    pageAccess?: import("../..").AccessBinding | undefined;
	    pageNode?: string | undefined;
	    extensionAccess?: import("../..").AccessBinding | undefined;
	    category?: string | undefined;
	    group?: string | undefined;
	    categoryLabel?: string | undefined;
	    type?: string | undefined;
	    extends?: string | undefined;
	    fragments?: string[] | undefined;
	    parentMenuItem?: string | undefined;
	    listIcon?: string | undefined;
	    description?: string | undefined;
	    duplicateBindings?: string[] | undefined;
	    literals?: import("@sage/xtrem-i18n").ClientArtifactUsedLiterals | undefined;
	    nodes?: string[] | undefined;
	    key?: string | undefined;
	    packageName?: string | undefined;
	    content?: import("../..").TextStream | undefined;
	    artifactFilePath?: string | undefined;
	}[]>;
	export type SchemaFragmentFunction = (application: Application) => MetadataSchemaFragment;
	export const expandNodeNames: (application: Application, nodeNames: string[], depth: number | null) => string[];
	//# sourceMappingURL=metadata-schema-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/installed-packages-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/installed-packages-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getInstalledPackagesSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=installed-packages-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/index.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/index' {
	/** @ignore */ /** */
	import { GraphQLSchema } from 'graphql';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/**
	 * Resolves various parts of the sitemap request. It returns the values from at the sitemap tree of the application and
	 * based on the GraphQL request's path it returns the right elements. In addition to that, it sets the entry titles
	 * based on the
	 *  */
	export function createMetadataSchema(application: Application): GraphQLSchema;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/data-type-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/data-type-fragment' {
	import { GraphQLFieldConfigArgumentMap, GraphQLList, GraphQLObjectType } from 'graphql';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const dataTypeGQType: GraphQLObjectType<any, any>;
	export const dataTypeFilter: GraphQLFieldConfigArgumentMap;
	export const dataTypesGQType: GraphQLList<GraphQLObjectType<any, any>>;
	export const resolveDataTypes: (context: Context, dataTypeNames: string[]) => any;
	export const getDataTypeSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=data-type-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/dashboard-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/dashboard-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getDashboardSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=dashboard-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/metadata-schema/about-fragment.d.ts
declare module '@sage/xtrem-core/lib/graphql/metadata-schema/about-fragment' {
	import { SchemaFragmentFunction } from '@sage/xtrem-core/lib/graphql/metadata-schema/metadata-schema-utils';
	export const getAboutSchemaFragment: SchemaFragmentFunction;
	//# sourceMappingURL=about-fragment.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/aggregates/aggregate-types.d.ts
declare module '@sage/xtrem-core/lib/graphql/aggregates/aggregate-types' {
	export const groupByVerbsEnumType: import("graphql").GraphQLEnumType;
	//# sourceMappingURL=aggregate-types.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/aggregates/aggregate-read.d.ts
declare module '@sage/xtrem-core/lib/graphql/aggregates/aggregate-read' {
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Dict } from '@sage/xtrem-shared';
	export interface ReadAggregateNode {
	    values: Dict<AnyValue>;
	}
	//# sourceMappingURL=aggregate-read.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/graphql/aggregates/aggregate-query.d.ts
declare module '@sage/xtrem-core/lib/graphql/aggregates/aggregate-query' {
	export {};
	//# sourceMappingURL=aggregate-query.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/file-storage/index.d.ts
declare module '@sage/xtrem-core/lib/file-storage/index' {
	export * from '@sage/xtrem-core/lib/file-storage/file-storage-manager';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/file-storage/file-storage-manager.d.ts
declare module '@sage/xtrem-core/lib/file-storage/file-storage-manager' {
	import { Express } from 'express';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export interface DownloadTargetInfo {
	    nodeName: string;
	    _id: string;
	}
	export type FileStorageInfo = Pick<Context, 'application' | 'tenantId'>;
	type DownloadHandler = (node: Node) => Promise<string>;
	/**
	 * Manages file storage operations and provides utility methods for handling file downloads.
	 */
	export abstract class FileStorageManager {
	    private static _downloadHandlersByNodeName;
	    /**
	     * Adds authenticated routes to the Express app for handling file downloads.
	     * @param app - The Express app.
	     * @param application - The application instance.
	     */
	    static addAuthenticatedRoutes(app: Express, application: Application): void;
	    /**
	     * Adds unauthenticated routes to the Express app for handling the dev upload.
	     * @param app - The Express app.
	     * @param application - The application instance.
	     */
	    static addUnauthenticatedRoutes(app: Express, application: Application): void;
	    /**
	     * Registers a download handler for a specific node class.
	     * @param clas - The node class.
	     * @param handler - The download handler function.
	     */
	    static registerDownloadHandler(clas: StaticThis<Node>, handler: DownloadHandler): void;
	    static getSandboxFilePath(storage: FileStorageInfo, objectKey: string): string;
	    static clearSandbox(storage: FileStorageInfo): Promise<void>;
	    /**
	     * Generates an on-demand download URL for a given node.
	     * @param node - The node to generate the download URL for.
	     * @returns A Promise that resolves to the on-demand download URL.
	     */
	    static getOnDemandDownloadUrl(node: Node): Promise<string>;
	    /**
	     * Retrieves the download URL for a given target.
	     * @param context - The context object.
	     * @param target - The target string.
	     * @returns A Promise that resolves to the download URL.
	     * @throws {SecurityError|SystemError} If the target data is invalid.
	     */
	    static getTargetDownloadUrl(context: Context, target: string): Promise<string>;
	}
	export {};
	//# sourceMappingURL=file-storage-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/file-storage/download-middleware.d.ts
declare module '@sage/xtrem-core/lib/file-storage/download-middleware' {
	import { Express } from 'express';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/**
	 * The base path for downloading files.
	 */
	export const downloadBasePath = "/download";
	/**
	 * Adds a download route to the Express app.
	 * This route handles the GET request for downloading a file.
	 *
	 * @param app - The Express app.
	 * @param application - The application instance.
	 */
	export function addDownloadRoute(app: Express, application: Application): void;
	//# sourceMappingURL=download-middleware.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/file-storage/dev-upload-middleware.d.ts
declare module '@sage/xtrem-core/lib/file-storage/dev-upload-middleware' {
	import { Express } from 'express';
	import { Application } from '@sage/xtrem-core/lib/application/index';
	/**
	 * Route that we will use to mock the async upload of files to S3 when we are in development mode
	 * @param app
	 * @param application
	 */
	export function addDevUploadRoute(app: Express, application: Application): void;
	//# sourceMappingURL=dev-upload-middleware.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/index.d.ts
declare module '@sage/xtrem-core/lib/decorators/index' {
	import { Package } from '@sage/xtrem-core/lib/application/package';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { node, nodeExtension, subNode, subNodeExtension1, subNodeExtension2, subNodeExtension3, subNodeExtension4, subNodeExtension5 } from '@sage/xtrem-core/lib/decorators/node-decorators/index';
	import { mutation, query } from '@sage/xtrem-core/lib/decorators/operation-decorators/index';
	import { binaryStreamProperty, binaryStreamPropertyOverride, booleanProperty, booleanPropertyOverride, collectionProperty, collectionPropertyOverride, dateProperty, datePropertyOverride, dateRangeProperty, dateRangePropertyOverride, datetimeProperty, datetimePropertyOverride, datetimeRangeProperty, datetimeRangePropertyOverride, decimalProperty, decimalPropertyOverride, decimalRangeProperty, decimalRangePropertyOverride, doubleProperty, doublePropertyOverride, enumArrayProperty, enumArrayPropertyOverride, enumProperty, enumPropertyOverride, floatProperty, floatPropertyOverride, integerArrayProperty, integerArrayPropertyOverride, integerProperty, integerPropertyOverride, integerRangeProperty, integerRangePropertyOverride, jsonProperty, jsonPropertyOverride, referenceArrayProperty, referenceArrayPropertyOverride, referenceProperty, referencePropertyOverride, shortProperty, shortPropertyOverride, stringArrayProperty, stringArrayPropertyOverride, stringProperty, stringPropertyOverride, textStreamProperty, textStreamPropertyOverride, timeProperty, timePropertyOverride, uuidProperty, uuidPropertyOverride } from '@sage/xtrem-core/lib/decorators/property-decorators/index';
	export { useDefaultValue } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events';
	export { ColumnTypeName, Decorated, FilterTag, StaticMemberDecoratorFunction, StaticThis, TypeName, staticMemberDecorator, } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	export * from '@sage/xtrem-core/lib/decorators/external-storage-manager';
	export * from '@sage/xtrem-core/lib/decorators/node-decorators/index';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/index';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/index';
	export interface NotificationListener {
	    name: string;
	    definingPackage: Package;
	    register(factory: NodeFactory): void;
	}
	export interface MessageListener {
	    name: string;
	    definingPackage: Package;
	    register(factory: NodeFactory): void;
	}
	export const coreDecorators: {
	    node: typeof node;
	    nodeExtension: typeof nodeExtension;
	    subNodeExtension1: typeof subNodeExtension1;
	    subNodeExtension2: typeof subNodeExtension2;
	    subNodeExtension3: typeof subNodeExtension3;
	    subNodeExtension4: typeof subNodeExtension4;
	    subNodeExtension5: typeof subNodeExtension5;
	    subNode: typeof subNode;
	    mutation: typeof mutation;
	    query: typeof query;
	    binaryStreamProperty: typeof binaryStreamProperty;
	    binaryStreamPropertyOverride: typeof binaryStreamPropertyOverride;
	    booleanProperty: typeof booleanProperty;
	    booleanPropertyOverride: typeof booleanPropertyOverride;
	    collectionProperty: typeof collectionProperty;
	    collectionPropertyOverride: typeof collectionPropertyOverride;
	    dateProperty: typeof dateProperty;
	    datePropertyOverride: typeof datePropertyOverride;
	    dateRangeProperty: typeof dateRangeProperty;
	    dateRangePropertyOverride: typeof dateRangePropertyOverride;
	    datetimeProperty: typeof datetimeProperty;
	    datetimePropertyOverride: typeof datetimePropertyOverride;
	    datetimeRangeProperty: typeof datetimeRangeProperty;
	    datetimeRangePropertyOverride: typeof datetimeRangePropertyOverride;
	    decimalProperty: typeof decimalProperty;
	    decimalPropertyOverride: typeof decimalPropertyOverride;
	    decimalRangeProperty: typeof decimalRangeProperty;
	    decimalRangePropertyOverride: typeof decimalRangePropertyOverride;
	    doubleProperty: typeof doubleProperty;
	    doublePropertyOverride: typeof doublePropertyOverride;
	    enumProperty: typeof enumProperty;
	    enumPropertyOverride: typeof enumPropertyOverride;
	    enumArrayProperty: typeof enumArrayProperty;
	    enumArrayPropertyOverride: typeof enumArrayPropertyOverride;
	    floatProperty: typeof floatProperty;
	    floatPropertyOverride: typeof floatPropertyOverride;
	    integerProperty: typeof integerProperty;
	    integerPropertyOverride: typeof integerPropertyOverride;
	    integerRangeProperty: typeof integerRangeProperty;
	    integerRangePropertyOverride: typeof integerRangePropertyOverride;
	    integerArrayProperty: typeof integerArrayProperty;
	    integerArrayPropertyOverride: typeof integerArrayPropertyOverride;
	    jsonProperty: typeof jsonProperty;
	    jsonPropertyOverride: typeof jsonPropertyOverride;
	    referenceProperty: typeof referenceProperty;
	    referencePropertyOverride: typeof referencePropertyOverride;
	    referenceArrayProperty: typeof referenceArrayProperty;
	    referenceArrayPropertyOverride: typeof referenceArrayPropertyOverride;
	    shortProperty: typeof shortProperty;
	    shortPropertyOverride: typeof shortPropertyOverride;
	    stringProperty: typeof stringProperty;
	    stringPropertyOverride: typeof stringPropertyOverride;
	    stringArrayProperty: typeof stringArrayProperty;
	    stringArrayPropertyOverride: typeof stringArrayPropertyOverride;
	    textStreamProperty: typeof textStreamProperty;
	    textStreamPropertyOverride: typeof textStreamPropertyOverride;
	    timeProperty: typeof timeProperty;
	    timePropertyOverride: typeof timePropertyOverride;
	    uuidProperty: typeof uuidProperty;
	    uuidPropertyOverride: typeof uuidPropertyOverride;
	};
	type CoreDecorators = typeof coreDecorators;
	export interface Decorators extends CoreDecorators {
	}
	export const decorators: Decorators;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/external-storage-manager.d.ts
declare module '@sage/xtrem-core/lib/decorators/external-storage-manager' {
	import { AnyRecord, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Dict } from '@sage/xtrem-shared';
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/base-collection';
	import { Context, NodeFactory, PropertyAndValue } from '@sage/xtrem-core/lib/runtime/index';
	import { OrderByClause } from '@sage/xtrem-core/lib/sql/index';
	import { Aggregate, Extend, Node, NodeQueryFilter, NodeSelector, OrderBy, ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	import { InternalPropertyJoin } from '@sage/xtrem-core/lib/types/index';
	import { FilterTag } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	export interface NodeExternalQueryOptions<T extends Node> {
	    filters: NodeQueryFilter<T>[];
	    orderBy?: OrderBy<T>;
	    first?: number;
	    after?: string;
	    last?: number;
	    before?: string;
	    locale?: string;
	    forUpdate?: boolean;
	    aggregate?: Aggregate;
	    count?: boolean;
	    /** The query expects a single record in the result */
	    singleResultRequest?: boolean;
	    /** Selector, for low level context.select(...) queries */
	    selector?: NodeSelector<T>;
	    collection?: BaseCollection;
	}
	export interface ExternalStorageManagerExtension<This extends Node = Node> {
	}
	export interface AnyRecordWithId extends AnyRecord {
	    _id: string;
	}
	export interface ExternalStorageManager<This extends Node> {
	    factory?: NodeFactory;
	    verifyFactory?: () => void;
	    /** insert hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    insert?: (node: Extend<This>, cx: ValidationContext) => AsyncResponse<AnyRecordWithId>;
	    /** update hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    update?: (node: Extend<This>, cx: ValidationContext) => AsyncResponse<AnyRecord[]>;
	    /**
	     *  delete hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    delete?: (node: Extend<This>, cx: ValidationContext) => AsyncResponse<number>;
	    canCreate?: (canCreate: boolean) => boolean;
	    canUpdate?: (canUpdate: boolean) => boolean;
	    canDelete?: (canDelete: boolean) => boolean;
	    canDeleteMany?: (canDeleteMany: boolean) => boolean;
	    getAllowedAccessCodes?: (context: Context, tag: FilterTag, allowedAccessCodes: string[] | null) => AsyncResponse<string[] | null>;
	    /**
	     * query and read - hooks getRawReader in SqlQuery
	     **/
	    query?: (context: Context, options: NodeExternalQueryOptions<This>) => AsyncReader<any>;
	    getCollectionJoin: (propertyName: string) => InternalPropertyJoin<This>;
	    getReferenceJoin: (propertyName: string) => InternalPropertyJoin<This>;
	    mapRecordIn?: (record: any) => any;
	    mapAggregateRecordIn?: (record: any) => any;
	    parseOrderBy(context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
	    parseCursor(orderByClauses: OrderByClause[], value: string): PropertyAndValue[];
	    getKeyValues(context: Context, values: any, options?: {
	        allocateTransient: boolean;
	        isTransient?: boolean;
	        isOnlyForDefaultValues?: boolean;
	        isOnlyForDuplicate?: boolean;
	        writable?: boolean;
	        isOnlyForLookup?: boolean;
	        collection?: BaseCollection;
	    }): AnyRecord;
	    getJoinValues(node: Extend<This>, data: any, propertyName: string, index?: number): AsyncResponse<Dict<any>>;
	    defaultOrderBy: OrderBy<Node>;
	    skipValidation?: boolean;
	    getId(context: Context, values: Dict<any>): string;
	    isKeyPropertyTransient(propertyName: string, value: any): boolean;
	    isReverseReferenceProperty(propertyName: string): boolean;
	}
	//# sourceMappingURL=external-storage-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/decorator-utils.d.ts
declare module '@sage/xtrem-core/lib/decorators/decorator-utils' {
	/** @ignore */ /** */
	import { UnPromised } from '@sage/xtrem-async-helper';
	import { ColumnTypeName } from '@sage/xtrem-shared';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export type StaticThis<T> = new () => T;
	export { ColumnTypeName };
	export type TypeName = ColumnTypeName | 'instance' | 'reference' | 'collection' | 'jsonReference';
	export class Decorated {
	}
	export interface DecoratorArg {
	}
	export type InferNonNullValT<PropType, ExpectedType> = PropType extends Promise<infer ValT> ? (ValT extends ExpectedType ? ValT : never) : never;
	export type InferValT<PropType, ExpectedType> = UnPromised<PropType> extends ExpectedType ? UnPromised<PropType> extends null ? UnPromised<PropType> | null : UnPromised<PropType> : never;
	export type NodeFilterTag = 'site';
	export type FilterTag = NodeFilterTag | 'accessCode' | 'isActive';
	/** When merging events from an extension, some events must be chained, meaning that the base event needs
	 * to be executed before the extension event. Both events will be executed. */
	export function chainEvents(baseEvent: any, extEvent: any, key: string): any;
	export function chainFilters(baseFilter: any, extFilter: any): any;
	/** Called when an extension extends a list attribute from the base class by adding entries to the list. */
	export function chainArrays(baseArray: any[] | undefined, extArray: any[] | undefined): any[] | undefined;
	export type MemberDecoratorFunction<This extends Decorated, K extends keyof This> = (proto: This, name: K) => void;
	export type OperationKind = 'query' | 'mutation' | 'asyncMutation' | 'asyncMutationListener' | 'asyncTrackerQuery' | 'notificationListener' | 'messageListener' | 'bulkMutation';
	export type StaticMemberDecoratorFunction<ConstructorType extends typeof Decorated> = (constructor: ConstructorType, name: string) => void;
	export function staticMemberDecorator<ConstructorType extends typeof Decorated, ArgType extends DecoratorArg>(decoratorName: string, kind: OperationKind): (arg: ArgType) => StaticMemberDecoratorFunction<ConstructorType>;
	export type ClassDecoratorFunction<ConstructorType extends typeof Decorated> = (constructor: ConstructorType) => void;
	export function extendProperty<This extends Node, K extends keyof This>(type: TypeName, arg: any): MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=decorator-utils.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/uuid-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/uuid-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { Uuid } from '@sage/xtrem-core/lib/types/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface UuidPropertyDecorator<This extends Node = Node, ValT extends Uuid | null = Uuid> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	/** &#064;decorators.uuidProperty(arg) property decorator */
	export function uuidProperty<This extends Node, K extends keyof This>(arg: UuidPropertyDecorator<This, InferValT<This[K], Uuid | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.uuidPropertyOverride(arg) property decorator */
	export function uuidPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], Uuid>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=uuid-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/string-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/string-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { StringArrayDataType, StringDataType } from '@sage/xtrem-core/lib/types/index';
	import { InferNonNullValT, InferValT, MemberDecoratorFunction } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface StringPropertyDecorator<This extends Node = Node, ValT extends string = string> extends TypedPropertyDecorator<This, ValT extends string ? ValT : never> {
	    /** Can the property be equal to empty string? */
	    isNotEmpty?: boolean;
	    isStoredEncrypted?: boolean;
	    dataType?: () => StringDataType<This, ValT extends string ? ValT : never>;
	}
	/** &#064;decorators.stringProperty(arg) property decorator */
	export function stringProperty<This extends Node, K extends keyof This>(arg: StringPropertyDecorator<This, InferNonNullValT<This[K], string>>): MemberDecoratorFunction<This, K>;
	/** &#064;decorators.stringPropertyOverride(arg) property decorator */
	export function stringPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferNonNullValT<This[K], string>>): MemberDecoratorFunction<This, K>;
	export interface StringArrayPropertyDecorator<This extends Node = Node, K extends keyof This = any> extends TypedPropertyDecorator<This, InferValT<This[K], string[] | null>> {
	    /** Can the property be equal to empty string? */
	    dataType?: () => StringArrayDataType<This, InferValT<This[K], string[] | null>>;
	}
	/** &#064;decorators.stringArrayProperty(arg) property decorator */
	export function stringArrayProperty<This extends Node, K extends keyof This>(arg: StringArrayPropertyDecorator<This, K>): MemberDecoratorFunction<This, K>;
	/** &#064;decorators.stringArrayPropertyOverride(arg) property decorator */
	export function stringArrayPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], string[]>>): MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=string-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/stream-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/stream-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { BinaryStream } from '@sage/xtrem-core/lib/types/binary-stream';
	import { BinaryStreamDataType, TextStreamDataType } from '@sage/xtrem-core/lib/types/stream-data-type';
	import { TextStream } from '@sage/xtrem-core/lib/types/text-stream';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface StreamPropertyDecorator<This extends Node = Node, ValT extends AnyValue = any> extends TypedPropertyDecorator<This, ValT> {
	    /**
	     * Should the lazy-loading on this column be skipped ? i.e. should this stream column be loaded when its
	     * node is read from the database ?
	     */
	    noLazyLoad?: boolean;
	}
	/** Parameter type for &#064;decorators.binaryStreamProperty decorator */
	export interface BinaryStreamPropertyDecorator<This extends Node = Node, ValT extends BinaryStream | null = BinaryStream> extends StreamPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    dataType?: () => BinaryStreamDataType<ValT, This>;
	}
	/** Parameter type for &#064;decorators.textStreamProperty decorator */
	export interface TextStreamPropertyDecorator<This extends Node = Node, ValT extends TextStream | null = TextStream> extends StreamPropertyDecorator<This, ValT> {
	    dataType?: () => TextStreamDataType<ValT extends null ? never : ValT, This>;
	}
	/** &#064;decorators.textStreamProperty(arg) property decorator */
	export function textStreamProperty<This extends Node, K extends keyof This>(arg: TextStreamPropertyDecorator<This, InferValT<This[K], TextStream>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.binaryStreamProperty(arg) property decorator */
	export function binaryStreamProperty<This extends Node, K extends keyof This>(arg: BinaryStreamPropertyDecorator<This, InferValT<This[K], BinaryStream | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.textStreamPropertyOverride(arg) property decorator */
	export function textStreamPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], TextStream>>): import("../decorator-utils").MemberDecoratorFunction<Node, keyof Node>;
	/** &#064;decorators.binaryStreamPropertyOverride(arg) property decorator */
	export function binaryStreamPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], BinaryStream>>): import("../decorator-utils").MemberDecoratorFunction<Node, keyof Node>;
	//# sourceMappingURL=stream-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/reference-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/reference-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { AnyValue, AsyncResponse, UnPromised } from '@sage/xtrem-async-helper';
	import { Extend, Node, NodeCreateData, NodeQueryFilter } from '@sage/xtrem-core/lib/ts-api/index';
	import { ArrayType, PropertyJoin, ReferenceDataTypeOptions } from '@sage/xtrem-core/lib/types/index';
	import { InferValT, MemberDecoratorFunction } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export type ReferenceElement<T> = T extends Node ? T : never;
	export type InferReferenceVal<PropType, ExpectedType> = UnPromised<PropType> extends ExpectedType ? UnPromised<PropType> : never;
	/** Intermediate type for reference property decorator */
	export interface BaseReferencePropertyDecorator<This extends Node, ValT extends Node | null, DefaultVal extends AnyValue> extends TypedPropertyDecorator<This, ValT, ValT, DefaultVal, ReferenceDataTypeOptions<ValT, This>> {
	    /** Target class */
	    node: () => {
	        new (): ValT;
	    };
	    reverseReference?: keyof ReferenceElement<ValT>;
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    /**
	     * Should this reference be ignored when toposorting factories (only valid when target factory is a setup node and reference is nullable)
	     */
	    ignoreInToposort?: boolean;
	    /** A nullable property is not allowed by default in unique index, set this attribute to allow it */
	    allowedInUniqueIndex?: boolean;
	    /** Is it a vital link ? */
	    isVital?: boolean;
	    /** Flags the reference property which points to the parent node in a vital relationship */
	    isVitalParent?: boolean;
	    /** Can the parent be created or updated by passing a payload in this property */
	    isVitalParentInput?: boolean;
	    /** Is it an association link ? */
	    isAssociation?: boolean;
	    /** Flags the property as an association */
	    isAssociationParent?: boolean;
	    /** Is it a mutable references? - Only relevant for references and collections on external storage nodes  */
	    isMutable?: boolean;
	    filters?: {
	        lookup?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<This>>;
	        control?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<This>>;
	    };
	    /** If true the isActive option of the provides attribute is ignored, when querying the target node */
	    ignoreIsActive?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /** can a lookup query be performed against the reference */
	    canLookup?: boolean;
	    /** Explicit join */
	    join?: PropertyJoin<ValT extends Node | null ? ValT & Node : never, Extend<This>>;
	}
	/** Intermediate type for non vital reference property decorator */
	export interface NonVitalReferencePropertyDecorator<This extends Node, ValT extends Node | null> extends BaseReferencePropertyDecorator<This, ValT, ValT> {
	    isVital?: false;
	}
	/** Intermediate type for vital reference property decorator */
	export interface VitalReferencePropertyDecorator<This extends Node, ValT extends Node | null> extends BaseReferencePropertyDecorator<This, ValT, NodeCreateData<NonNullable<ValT>>> {
	    isVital: true;
	}
	/** Parameter type for &#064;decorators.referenceProperty decorator */
	export type ReferencePropertyDecorator<This extends Node = Node, ValT extends Node | null = any> = NonVitalReferencePropertyDecorator<This, ValT> | VitalReferencePropertyDecorator<This, ValT>;
	/** &#064;decorators.referenceProperty(arg) property decorator */
	export function referenceProperty<This extends Node, K extends keyof This, ValT extends InferReferenceVal<This[K], Node | null> = InferReferenceVal<This[K], Node | null>>(arg: ReferencePropertyDecorator<This, ValT>): MemberDecoratorFunction<This, K>;
	export interface ReferencePropertyOverrideDecorator<This extends Node = Node, ValT extends AnyValue = Node> extends PropertyOverrideDecorator<This, ValT, ValT, ValT> {
	    node?: () => {
	        new (): ValT;
	    };
	    filters?: {
	        lookup?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<This>>;
	        control?: NodeQueryFilter<ValT extends Node | null ? ValT & Node : never, Extend<This>>;
	    };
	}
	/** &#064;decorators.referencePropertyOverride(arg) property decorator */
	export function referencePropertyOverride<This extends Node, K extends keyof This = any, ValT extends InferReferenceVal<This[K], Node | null> = InferReferenceVal<This[K], Node | null>>(arg: ReferencePropertyOverrideDecorator<This, ValT>): MemberDecoratorFunction<This, K>;
	/** &#064;decorators.referenceArrayProperty decorator */
	export interface ReferenceArrayPropertyDecorator<This extends Node = Node, K extends keyof This = any, RefT extends Node = Node, ValT extends InferValT<This[K], RefT[] | null> = any> extends TypedPropertyDecorator<This, ValT, ValT, ValT, ReferenceDataTypeOptions<RefT, This>> {
	    /** Target class */
	    node: () => {
	        new (): RefT;
	    };
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    filters?: {
	        lookup?: NodeQueryFilter<RefT, Extend<This>>;
	        control?: NodeQueryFilter<RefT, Extend<This>>;
	    };
	    /** If true the isActive option of the provides attribute is ignored, when querying the target node */
	    ignoreIsActive?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	}
	/** &#064;decorators.referenceArrayProperty(arg) property decorator */
	export function referenceArrayProperty<This extends Node, K extends keyof This, ValT extends AnyValue = This[K] extends AnyValue ? This[K] : never>(arg: ReferenceArrayPropertyDecorator<This, K, ArrayType<UnPromised<This[K]>, Node>>): MemberDecoratorFunction<This, K>;
	/** &#064;decorators.referenceArrayPropertyOverride(arg) property decorator */
	export function referenceArrayPropertyOverride<This extends Node, K extends keyof This = any>(arg: PropertyOverrideDecorator<This, InferValT<This[K], Node | null>>): MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=reference-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/numeric-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/numeric-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { DecimalRange, IntegerRange } from '@sage/xtrem-date-time';
	import { Node, integer } from '@sage/xtrem-core/lib/ts-api/index';
	import { DecimalDataType } from '@sage/xtrem-core/lib/types/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface NumberPropertyDecorator<This extends Node = Node, ValT extends number | null = number> extends TypedPropertyDecorator<This, ValT> {
	    /** Can the property be equal to zero? */
	    isNotZero?: boolean;
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface IntegerPropertyDecorator<This extends Node = Node, ValT extends integer | null = integer> extends NumberPropertyDecorator<This, ValT> {
	    /** A nullable property is not allowed by default in unique index, set this attribute to allow it */
	    allowedInUniqueIndex?: boolean;
	}
	export interface ShortPropertyDecorator<This extends Node = Node, ValT extends integer | null = integer> extends NumberPropertyDecorator<This, ValT> {
	}
	export interface FloatPropertyDecorator<This extends Node = Node, ValT extends number | null = number> extends NumberPropertyDecorator<This, ValT> {
	}
	export interface DoublePropertyDecorator<This extends Node = Node, ValT extends number | null = number> extends NumberPropertyDecorator<This, ValT> {
	}
	export interface DecimalPropertyDecorator<This extends Node = Node, ValT extends number | null = number> extends NumberPropertyDecorator<This, ValT> {
	    dataType: () => DecimalDataType<This, ValT>;
	}
	export interface IntegerRangePropertyDecorator<This extends Node = Node, ValT extends IntegerRange | null = IntegerRange> extends TypedPropertyDecorator<This, ValT extends IntegerRange | null ? ValT : never> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface DecimalRangePropertyDecorator<This extends Node = Node, ValT extends DecimalRange | null = DecimalRange> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface IntegerArrayPropertyDecorator<This extends Node = Node, ValT extends integer[] | null = integer[]> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	/** &#064;decorators.integerProperty(arg) property decorator */
	export function integerProperty<This extends Node, K extends keyof This>(arg: IntegerPropertyDecorator<This, InferValT<This[K], integer | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.floatProperty(arg) property decorator */
	export function floatProperty<This extends Node, K extends keyof This>(arg: FloatPropertyDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.decimalProperty(arg) property decorator */
	export function decimalProperty<This extends Node, K extends keyof This>(arg: DecimalPropertyDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.doubleProperty(arg) property decorator */
	export function doubleProperty<This extends Node, K extends keyof This>(arg: DoublePropertyDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.shortProperty(arg) property decorator */
	export function shortProperty<This extends Node, K extends keyof This>(arg: ShortPropertyDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.integerRangeProperty(arg) property decorator */
	export function integerRangeProperty<This extends Node, K extends keyof This>(arg: IntegerRangePropertyDecorator<This, InferValT<This[K], IntegerRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.integerArrayProperty(arg) property decorator */
	export function integerArrayProperty<This extends Node, K extends keyof This>(arg: IntegerArrayPropertyDecorator<This, InferValT<This[K], integer[] | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.decimalRangeProperty(arg) property decorator */
	export function decimalRangeProperty<This extends Node, K extends keyof This>(arg: DecimalRangePropertyDecorator<This, InferValT<This[K], DecimalRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.integerPropertyOverride(arg) property decorator */
	export function integerPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], integer | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.integerRangePropertyOverride(arg) property decorator */
	export function integerRangePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], IntegerRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.decimalRangePropertyOverride(arg) property decorator */
	export function decimalRangePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], DecimalRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.floatPropertyOverride(arg) property decorator */
	export function floatPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.decimalPropertyOverride(arg) property decorator */
	export function decimalPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.doublePropertyOverride(arg) property decorator */
	export function doublePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], number | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.shortPropertyOverride(arg) property decorator */
	export function shortPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], integer | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.integerArrayPropertyOverride(arg) property decorator */
	export function integerArrayPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], integer[] | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=numeric-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/json-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/json-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { JsonDataType } from '@sage/xtrem-core/lib/types/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface JsonPropertyDecorator<This extends Node = Node, ValT extends AnyValue = object> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    dataType?: () => JsonDataType<This, ValT>;
	}
	/** &#064;decorators.jsonProperty(arg) property decorator */
	export function jsonProperty<This extends Node, K extends keyof This>(arg: JsonPropertyDecorator<This, InferValT<This[K], object | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	export function jsonPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], object | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=json-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/index.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/index' {
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/boolean-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/collection-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/date-time-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/enum-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/json-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/numeric-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/reference-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/stream-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/string-property-decorators';
	export * from '@sage/xtrem-core/lib/decorators/property-decorators/uuid-property-decorators';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/enum-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/enum-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { ArrayType, EnumDataType } from '@sage/xtrem-core/lib/types/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	/** Parameter type for &#064;decorators.enumProperty decorator */
	export interface EnumPropertyDecorator<This extends Node = Node, ValT extends string | null = string> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    /** A nullable property is not allowed by default in unique index, set this attribute to allow it */
	    allowedInUniqueIndex?: boolean;
	    dataType: () => EnumDataType<ValT, This>;
	}
	/** &#064;decorators.enumProperty(arg) property decorator */
	export function enumProperty<This extends Node, K extends keyof This>(arg: EnumPropertyDecorator<This, InferValT<This[K], string | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.enumPropertyOverride(arg) property decorator */
	export function enumPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], string | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** Parameter type for &#064;decorators.enumArrayProperty decorator */
	export interface EnumArrayPropertyDecorator<This extends Node = Node, ValT extends string[] | null = string[]> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    dataType: () => EnumDataType<ArrayType<ValT, string>, This>;
	}
	/** &#064;decorators.enumArrayProperty(arg) property decorator */
	export function enumArrayProperty<This extends Node, K extends keyof This>(arg: EnumArrayPropertyDecorator<This, InferValT<This[K], string[] | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.enumArrayPropertyOverride(arg) property decorator */
	export function enumArrayPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], string[] | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=enum-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/date-time-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/date-time-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { DateRange, Datetime, DatetimeRange, DateValue, Time } from '@sage/xtrem-date-time';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface DatePropertyDecorator<This extends Node = Node, ValT extends DateValue | null = DateValue> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	    /** A nullable property is not allowed by default in unique index, set this attribute to allow it */
	    allowedInUniqueIndex?: boolean;
	}
	export interface DateRangePropertyDecorator<This extends Node = Node, ValT extends DateRange | null = DateRange> extends TypedPropertyDecorator<This, ValT extends DateRange | null ? ValT : never> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface DatetimePropertyDecorator<This extends Node = Node, ValT extends Datetime | null = Datetime> extends TypedPropertyDecorator<This, ValT extends Datetime | null ? ValT : never> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface DatetimeRangePropertyDecorator<This extends Node = Node, ValT extends DatetimeRange | null = DatetimeRange> extends TypedPropertyDecorator<This, ValT extends DatetimeRange | null ? ValT : never> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	export interface TimePropertyDecorator<This extends Node = Node, ValT extends Time | null = Time> extends TypedPropertyDecorator<This, ValT extends Time | null ? ValT : never> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	/** &#064;decorators.dateProperty(arg) property decorator */
	export function dateProperty<This extends Node, K extends keyof This>(arg: DatePropertyDecorator<This, InferValT<This[K], DateValue | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.dateRangeProperty(arg) property decorator */
	export function dateRangeProperty<This extends Node, K extends keyof This>(arg: DateRangePropertyDecorator<This, InferValT<This[K], DateRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.dateRangeProperty(arg) property decorator */
	export function datetimeRangeProperty<This extends Node, K extends keyof This>(arg: DatetimeRangePropertyDecorator<This, InferValT<This[K], DatetimeRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.datetimeProperty(arg) property decorator */
	export function datetimeProperty<This extends Node, K extends keyof This>(arg: DatetimePropertyDecorator<This, InferValT<This[K], Datetime | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.timeProperty(arg) property decorator */
	export function timeProperty<This extends Node, K extends keyof This>(arg: TimePropertyDecorator<This, InferValT<This[K], Time | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.datePropertyOverride(arg) property decorator */
	export function datePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], DateValue | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.datePropertyOverride(arg) property decorator */
	export function dateRangePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], DateRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.datePropertyOverride(arg) property decorator */
	export function datetimeRangePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], DatetimeRange | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.timePropertyOverride(arg) property decorator */
	export function timePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], Time | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.datetimePropertyOverride(arg) property decorator */
	export function datetimePropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], Datetime | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=date-time-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/collection-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/collection-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { AsyncResponse } from '@sage/xtrem-shared';
	import { Collection, Extend, Node, NodeCreateData, NodeQueryFilter, OrderBy, Validator } from '@sage/xtrem-core/lib/ts-api/index';
	import { PropertyJoin } from '@sage/xtrem-core/lib/types/index';
	import { MemberDecoratorFunction } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface CollectionPropertyEvents<This extends Node = Node> {
	    /** event before individual prepare on nodes */
	    prepareBegin?: Validator<Extend<This>>;
	    /** event after individual prepare on nodes */
	    prepareEnd?: Validator<Extend<This>>;
	    /** event before individual control on nodes */
	    controlBegin?: Validator<Extend<This>>;
	    /** event after individual control on nodes */
	    controlEnd?: Validator<Extend<This>>;
	    /** event before saving nodes */
	    saveBegin?: (this: Extend<This>) => void;
	    /** event after saving nodes */
	    saveEnd?: (this: Extend<This>) => void;
	}
	export type CollectionElement<T> = T extends Collection<infer U extends Node> ? U : never;
	/** Intermediate type for collection property decorator */
	export interface BaseCollectionPropertyDecorator<This extends Node = Node, ElementT extends Node = Node, DefaultVal extends NodeCreateData<ElementT>[] = NodeCreateData<ElementT>[]> extends TypedPropertyDecorator<This, ElementT[], never, DefaultVal>, CollectionPropertyEvents<This> {
	    /** Target class */
	    node: () => {
	        new (): ElementT;
	    };
	    /** orderBy criteria (collection property only) */
	    orderBy?: OrderBy<ElementT>;
	    /** Name of the property of the target node that references back to this node */
	    reverseReference?: keyof ElementT;
	    /**
	     * Filter on the target node, that expresses the join condition
	     * Only necessary if `reverseReference` is absent.
	     */
	    getFilter?: (this: Extend<This>) => AsyncResponse<NodeQueryFilter<ElementT>>;
	    /** ensure the collection contains at least one element */
	    isRequired?: boolean;
	    /** Is it a vital link ? */
	    isVital?: boolean;
	    /** Flags the collection as an additional vital relationship */
	    isAssociation?: boolean;
	    /** Is it a mutable collection? - Only relevant for references and collections on external storage nodes */
	    isMutable?: boolean;
	    /** Explicit join */
	    join?: PropertyJoin<ElementT, Extend<This>>;
	    /** Always save all the collection elements, instead of saving only the modified ones */
	    forceFullSave?: boolean;
	}
	/** Intermediate type for non vital collection property decorator */
	export interface NonVitalCollectionPropertyDecorator<This extends Node = Node, ElementT extends Node = Node> extends BaseCollectionPropertyDecorator<This, ElementT> {
	    isVital?: false;
	}
	/** Intermediate type for vital collection property decorator */
	export interface VitalCollectionPropertyDecorator<This extends Node = Node, ElementT extends Node = Node> extends BaseCollectionPropertyDecorator<This, ElementT, NodeCreateData<ElementT>[]> {
	    isVital: true;
	}
	/** Parameter type for &#064;decorators.collectionProperty decorator */
	export type CollectionPropertyDecorator<This extends Node = Node, ElementT extends Node = Node> = NonVitalCollectionPropertyDecorator<This, ElementT> | VitalCollectionPropertyDecorator<This, ElementT>;
	export interface CollectionPropertyOverrideDecorator<This extends Node = Node, ValT extends Node = Node> extends PropertyOverrideDecorator<This, ValT, never, NodeCreateData<ValT>[]>, CollectionPropertyEvents<This> {
	    node?: () => {
	        new (): ValT;
	    };
	}
	/** &#064;decorators.collectionProperty(arg) property decorator */
	export function collectionProperty<This extends Node, K extends keyof This = any>(arg: CollectionPropertyDecorator<This, CollectionElement<This[K]>>): MemberDecoratorFunction<This, K>;
	/** &#064;decorators.collectionPropertyOverride(arg) property decorator */
	export function collectionPropertyOverride<This extends Node, K extends keyof This = any>(arg: CollectionPropertyOverrideDecorator<This, CollectionElement<This[K]>>): MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=collection-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/boolean-property-decorators.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/boolean-property-decorators' {
	/** @packageDocumentation @module decorators */
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { InferValT } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { TypedPropertyDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator';
	import { PropertyOverrideDecorator } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator';
	export interface BooleanPropertyDecorator<This extends Node = Node, ValT extends boolean | null = boolean | null> extends TypedPropertyDecorator<This, ValT> {
	    /** Is property value nullable? */
	    isNullable?: boolean;
	}
	/** &#064;decorators.booleanProperty(arg) property decorator */
	export function booleanProperty<This extends Node, K extends keyof This>(arg: BooleanPropertyDecorator<This, InferValT<This[K], boolean | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	/** &#064;decorators.booleanPropertyOverride(arg) property decorator */
	export function booleanPropertyOverride<This extends Node, K extends keyof This>(arg: PropertyOverrideDecorator<This, InferValT<This[K], boolean | null>>): import("../decorator-utils").MemberDecoratorFunction<This, K>;
	//# sourceMappingURL=boolean-property-decorators.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/base-property-extension-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/base-property-extension-decorator' {
	/** @packageDocumentation @module decorators */
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { PropertyEvents } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events';
	export interface PropertyOverrideDecorator<This extends Node, ValT extends AnyValue, ControlVal extends AnyValue = ValT, DefaultVal extends AnyValue = ValT> extends PropertyEvents<This, ValT, ControlVal, DefaultVal> {
	    serviceOptions?: () => ServiceOption[];
	}
	//# sourceMappingURL=base-property-extension-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/base-property-events.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events' {
	/** @packageDocumentation @module decorators */
	import { AnyValue, AsyncArray, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Dict } from '@sage/xtrem-shared';
	import { Extend, Node, NodeCreateData, ValidationContext, Validator } from '@sage/xtrem-core/lib/ts-api/index';
	import { CollectionPropertyEvents } from '@sage/xtrem-core/lib/decorators/property-decorators/collection-property-decorators';
	export type PropertyPaths<This extends Node> = (string | Dict<PropertyPaths<This>>)[];
	export type SetValueData<ValT> = ValT extends (infer U)[] ? (U extends Node ? NodeCreateData<U>[] : ValT) : ValT;
	export type MatchingKey<This, ValT> = keyof This extends infer K ? K extends keyof This ? This[K] extends ValT ? K : never : never : never;
	export type DefaultValueRule<This extends Node, DefaultVal extends AnyValue> = DefaultVal | null | ((this: Extend<This>) => AsyncResponse<DefaultVal | null>);
	export type DuplicatedValueRule<This extends Node, DefaultVal extends AnyValue> = typeof useDefaultValue | DefaultVal | null | ((this: Extend<This>) => AsyncResponse<DefaultVal | null>);
	export type UpdatedValueRule<This extends Node, DefaultVal extends AnyValue> = typeof useDefaultValue | DefaultVal | ((this: Extend<This>) => AsyncResponse<DefaultVal | typeof useDefaultValue>);
	export interface PropertyEvents<This extends Node = Node, ValT extends AnyValue = AnyValue, ControlVal extends AnyValue = ValT, DefaultVal extends AnyValue = ValT> {
	    /**
	     * Event to obtain default value
	     * Note: even non-nullable properties are allowed to return 'null'. The user will have to provide
	     * a valid value for this property when editing it (saving a node with a 'null' value for a non-nullable
	     * property would raise an error).
	     */
	    defaultValue?: DefaultValueRule<This, DefaultVal>;
	    /** event to prepare value before control */
	    prepare?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event to control value */
	    control?: Validator<Extend<This>, ControlVal>;
	    /** Return "ts-to-sql compliant" the value of a computed property */
	    getValue?: (this: Extend<This>) => AsyncResponse<ValT>;
	    /** Return "ts-to-sql **NOT** compliant" the value of a computed property */
	    computeValue?: (this: Extend<This>) => AsyncResponse<ValT extends AsyncArray<infer EltT> ? EltT[] : ValT>;
	    /**  Event to set value */
	    setValue?: (this: Extend<This>, val: SetValueData<ValT>) => AsyncResponse<void>;
	    /** Event to adapt value when setting it*/
	    adaptValue?: (this: Extend<This>, val: ValT) => AsyncResponse<ValT>;
	    /** Dependencies on other properties */
	    dependsOn?: PropertyPaths<This>;
	    /** event to update the value when a dependency is modified */
	    updatedValue?: UpdatedValueRule<This, DefaultVal>;
	    /** Event to obtain value to use when the node is duplicated */
	    duplicatedValue?: DuplicatedValueRule<This, ValT>;
	    /** Is the property frozen */
	    isFrozen?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /** Event to provide a deferred value which will be set at commit time */
	    deferredDefaultValue?: DefaultValueRule<This, DefaultVal>;
	}
	export type PropertyRuleName = keyof PropertyEvents | keyof CollectionPropertyEvents;
	/**
	 * Special value for the `updatedValue` and `duplicatedValue` rules.
	 * It indicates that the value should be obtained with the `defaultValue` rule.
	 */
	export const useDefaultValue: unique symbol;
	//# sourceMappingURL=base-property-events.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/property-decorators/base-property-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/property-decorators/base-property-decorator' {
	/** @packageDocumentation @module decorators */
	import { AnyValue, AsyncResponse, UnPromised } from '@sage/xtrem-async-helper';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Extend, Node, integer } from '@sage/xtrem-core/lib/ts-api/index';
	import { DataType, DataTypeOptions, TextStream } from '@sage/xtrem-core/lib/types/index';
	import { ColumnTypeName, FilterTag } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { PropertyEvents } from '@sage/xtrem-core/lib/decorators/property-decorators/base-property-events';
	export type PropertyFilterTag = FilterTag | 'key' | 'company' | 'legislation' | 'title' | 'shortTitle' | 'sequenceNumber' | 'documentDate';
	export type DataSensitivityLevel = 'notSensitive' | 'businessSensitive' | 'personal' | 'personalSensitive' | 'highlySensitive';
	export type AnonymizeMethod = 'fixed' | 'random' | 'hash' | 'hashLimit' | 'perCharRandom' | 'custom' | 'binary' | 'url';
	export type AnonymizeBinary = 'pdf' | 'image';
	type AnonymizeValueType = AnonymizeBinary | TextStream | number | null;
	export type DelegatesTo<This extends Node | null = Node> = {
	    [K in Exclude<keyof This, '$' | '_id' | '_action'>]?: This[K] extends infer U ? UnPromised<U> extends Node | null ? keyof Exclude<UnPromised<U>, null> : never : never;
	};
	export type DelegatePath<NodeT extends Node | null> = DelegatesTo<Extend<NodeT>>;
	export interface BasePropertyDecorator<This extends Node = Node> {
	    /** Access code that may restrict access to property value */
	    accessCode?: string;
	    /** Is the property mapped to a table column */
	    isStored?: boolean;
	    /** Is the property a transient input value to mutations */
	    isTransientInput?: boolean;
	    /** Is the property a stored output value */
	    isStoredOutput?: boolean;
	    /** Column name if property is mapped to a column with a different name */
	    columnType?: ColumnTypeName;
	    /** Column name that may be used by external storage node */
	    columnName?: string;
	    /** Is this property auto-increment ? (i.e.: the value is assigned by the database engine when inserting) */
	    isAutoIncrement?: boolean;
	    /** Does property provide one or more standard attributes (company, site, legislation, ...) for the node */
	    provides?: PropertyFilterTag[];
	    /** Is this property searchable? */
	    canSearch?: boolean;
	    /** Search category for search engine */
	    searchCategory?: string;
	    /**
	     * Is this property available for lookup queries
	     *
	     * Note: _id and _customData defaults to true
	     */
	    lookupAccess?: boolean;
	    /** Excluded from payload (used to hide technical properties) */
	    excludedFromPayload?: boolean;
	    /** Setup data for the property can be modified */
	    isOwnedByCustomer?: boolean;
	}
	/**
	 * Additional information we can use to create a column SQL definitions
	 */
	export interface PropertySqlAttributes {
	    /**
	     * the SQL default that will be used on property column
	     */
	    default?: string | null;
	    /**
	     * Use attribute to flag that a column should be excluded from an insert statement if the value passed to it is null
	     * If the column has a default defined the default will be utilized (NULL does not work)
	     */
	    excludeFromInsertIfNull?: boolean;
	}
	/** Parameter type for all property decorators */
	export interface TypedPropertyDecorator<This extends Node = Node, ValT extends AnyValue = AnyValue, ControlVal extends AnyValue = ValT, DefaultVal extends AnyValue = ValT, DataTypeOptionsT extends DataTypeOptions = DataTypeOptions> extends BasePropertyDecorator<This>, PropertyEvents<This, ValT, ControlVal, DefaultVal> {
	    /** Property's service option */
	    serviceOptions?: () => ServiceOption[];
	    /** published in graphql API? */
	    isPublished?: boolean;
	    /** property is required */
	    isRequired?: boolean;
	    dataType?: () => DataType<ValT, This, DataTypeOptionsT>;
	    max?: integer;
	    /** Name of a reference property to which the property delegates */
	    delegatesTo?: DelegatePath<This>;
	    /**
	     * Indicates if the property should be cleared to its default value when we do a reset
	     */
	    isClearedByReset?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /** Is user input required on the duplicated value */
	    duplicateRequiresPrompt?: boolean;
	    /** Alternate value to export instead of excluding the property (used to hide sensitive information) */
	    exportValue?: ValT;
	    /** Data sensitivity level for GDPR related functionality */
	    dataSensitivityLevel?: DataSensitivityLevel;
	    /** Anonymize the value of the property for export (used to hide sensitive customer information when
	     * tenant data is exported with anonymize flag) */
	    anonymizeMethod?: AnonymizeMethod;
	    /** When anonymizeMethod is fixed (fixed value), hashLimit (hash limited to specified length) or
	     * custom (callback function) define the relevant detail with anonymizeValue */
	    anonymizeValue?: ValT | ((value: string) => string | null) | AnonymizeValueType;
	}
	export {};
	//# sourceMappingURL=base-property-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/parameter.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/parameter' {
	import { AnyRecord } from '@sage/xtrem-async-helper';
	import { DateRange, Datetime, DatetimeRange, DateValue, Time } from '@sage/xtrem-date-time';
	import { Decimal } from '@sage/xtrem-decimal';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { BinaryStream, DataType, TextStream } from '@sage/xtrem-core/lib/types/index';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { ArrayParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/array-parameter';
	import { BaseParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter';
	import { InstanceParameter, ReferenceParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/foreign-node-parameter';
	import { ObjectParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/object-parameter';
	export type NamesOfType<ValT> = ValT extends boolean ? 'boolean' : ValT extends string ? 'string' | 'enum' : ValT extends number ? 'integer' | 'decimal' : ValT extends Decimal ? 'decimal' : ValT extends DateValue ? 'date' : ValT extends DateRange ? 'dateRange' : ValT extends Datetime ? 'datetime' : ValT extends DatetimeRange ? 'datetimeRange' : ValT extends Time ? 'time' : ValT extends TextStream ? 'textStream' : ValT extends BinaryStream ? 'binaryStream' : ValT extends AnyRecord ? 'json' : never;
	export interface ScalarParameter<This extends StaticThis<Node> = typeof Node, ValT = any> extends BaseParameter<This> {
	    type: Exclude<NamesOfType<ValT>, 'collection' | 'reference' | 'instance'>;
	    dataType?: () => DataType<any, InstanceType<This>>;
	}
	export type Parameter<This extends StaticThis<Node> = typeof Node, NameT = any> = ReferenceParameter<This> | InstanceParameter<This> | ObjectParameter<This> | ArrayParameter<This> | ScalarParameter<This, NameT>;
	//# sourceMappingURL=parameter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/operation-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/operation-decorator' {
	/** @packageDocumentation @module decorators */
	import { IsolationLevel, Package, UnPromised } from '@sage/xtrem-core/lib/index';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { OperationKind, StaticMemberDecoratorFunction, StaticThis, TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { NamesOfType, Parameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/parameter';
	export type ParameterTypeName = TypeName | 'object' | 'array';
	export type OperationReturn<This extends StaticThis<Node>, ReturnT> = Parameter<This, ReturnT> | NamesOfType<ReturnT>;
	export type MappedParameters<Params> = {
	    [K in keyof Params]-?: {
	        readonly name: string;
	    } & Parameter<typeof Node, Params[K]>;
	};
	export interface BaseOperationDecorator {
	    isPublished?: boolean;
	    /** The service options */
	    serviceOptions?: () => ServiceOption[];
	    /** code for access rights (X3 _function_ code) */
	    authorizationCode?: string;
	}
	/** Argument for &#064;decorators.query or &#064;decorators.mutation decorators */
	export interface OperationDecorator<This extends StaticThis<Node>, K extends keyof This> extends BaseOperationDecorator {
	    isPublished?: boolean;
	    /**
	     * Is the operation an interop call?
	     * Note that it may still have a body, which will then be executed as a local fallback.
	     */
	    isInterop?: true;
	    parameters: This[K] extends (context: Context, ...args: any[]) => any ? MappedParameters<Parameters<This[K]> extends [Context, ...infer R1] ? R1 : never> : never;
	    return: OperationReturn<This, This[K] extends (...args: any[]) => infer ReturnT ? UnPromised<ReturnT> : never>;
	}
	export interface QueryDecorator<This extends StaticThis<Node>, K extends keyof This> extends OperationDecorator<This, K> {
	    /** The isolation level */
	    isolationLevel?: IsolationLevel;
	    /** Can the query be deferred - advanced option reserved to 'high' isolation level */
	    isDeferrable?: boolean;
	    /** If set to true access to execute this query will be based on access to this operation or lookup */
	    isGrantedByLookup?: boolean;
	}
	export interface BaseMutationDecorator<This extends StaticThis<Node>, K extends keyof This> extends OperationDecorator<This, K> {
	    /** The isolation level */
	    isolationLevel?: IsolationLevel;
	    /**
	     * startsReadOnly is used to determine whether the static method of a custom mutation is called with a readonly or writable context.
	     * It can be set as a boolean or a callback that returns a boolean.
	     */
	    startsReadOnly?: boolean | ((this: This, context: Context) => boolean);
	}
	export interface MutationDecorator<This extends StaticThis<Node>, K extends keyof This> extends BaseMutationDecorator<This, K> {
	}
	export type PlainParameter = Parameter<typeof Node, any> & {
	    name: string;
	};
	export interface PlainOperationDecorator extends BaseOperationDecorator {
	    readonly name: string;
	    action?: string;
	    definingPackage?: Package;
	    isolationLevel?: IsolationLevel;
	    isDeferrable?: boolean;
	    isSchedulable?: boolean;
	    isInterop?: boolean;
	    operationKind: OperationKind;
	    parameters: PlainParameter[];
	    return: OperationReturn<typeof Node, any>;
	    className?: string;
	    /**
	     * startsReadOnly is used to determine whether the static method of a custom mutation is called with a readonly or writable context.
	     * It can be set as a boolean or a callback that returns a boolean.
	     */
	    startsReadOnly?: boolean | ((this: typeof Node, context: Context) => boolean);
	    /** If set to true, access to execute this query will be granted if the user is authorized for the query or `lookup` operation */
	    isGrantedByLookup?: boolean;
	}
	/** &#064;decorators.mutation(arg) static method decorator */
	export function mutation<This extends StaticThis<Node>, K extends keyof This>(arg: MutationDecorator<This, K>): StaticMemberDecoratorFunction<typeof Node>;
	/** &#064;decorators.query(arg) static method decorator */
	export function query<This extends StaticThis<Node>, K extends keyof This>(arg: QueryDecorator<This, K>): StaticMemberDecoratorFunction<typeof Node>;
	//# sourceMappingURL=operation-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/object-parameter.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/object-parameter' {
	import { Dict } from '@sage/xtrem-shared';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { StaticThis, TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { BaseParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter';
	import { Parameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/parameter';
	export interface ObjectParameter<This extends StaticThis<Node> = typeof Node> extends BaseParameter<This> {
	    type: 'object';
	    properties: Dict<Parameter<This> | TypeName>;
	}
	//# sourceMappingURL=object-parameter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/index.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/index' {
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/array-parameter';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/foreign-node-parameter';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/object-parameter';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/operation-decorator';
	export * from '@sage/xtrem-core/lib/decorators/operation-decorators/parameter';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/foreign-node-parameter.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/foreign-node-parameter' {
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { BaseParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter';
	export interface ForeignNodeParameter<This extends StaticThis<Node>> extends BaseParameter<This> {
	    node: () => {
	        new (): Node;
	    };
	}
	export interface ReferenceParameter<This extends StaticThis<Node>> extends ForeignNodeParameter<This> {
	    type: 'reference';
	    isWritable?: boolean;
	}
	export interface InstanceParameter<This extends StaticThis<Node>> extends ForeignNodeParameter<This> {
	    type: 'instance';
	}
	//# sourceMappingURL=foreign-node-parameter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/base-parameter.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter' {
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { ParameterTypeName } from '@sage/xtrem-core/lib/decorators/operation-decorators/operation-decorator';
	/** Parameter descriptor for &#064;decorators.query or &#064;decorators.mutation decorators */
	export interface BaseParameter<This extends StaticThis<Node> = typeof Node> {
	    name?: string;
	    type: ParameterTypeName;
	    isMandatory?: boolean;
	    isNullable?: boolean;
	    isTransientInput?: boolean;
	}
	//# sourceMappingURL=base-parameter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/operation-decorators/array-parameter.d.ts
declare module '@sage/xtrem-core/lib/decorators/operation-decorators/array-parameter' {
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { StaticThis, TypeName } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { BaseParameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/base-parameter';
	import { Parameter } from '@sage/xtrem-core/lib/decorators/operation-decorators/parameter';
	export interface ArrayParameter<This extends StaticThis<Node> = typeof Node> extends BaseParameter<This> {
	    type: 'array';
	    item: Parameter<This> | TypeName;
	}
	//# sourceMappingURL=array-parameter.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/node-decorators/sub-node-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/node-decorators/sub-node-decorator' {
	/** @packageDocumentation @module decorators */
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Extend, Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { ClassDecoratorFunction } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { NodeIndexDecorator } from '@sage/xtrem-core/lib/decorators/node-decorators/node-decorator';
	import { NodeEvents } from '@sage/xtrem-core/lib/decorators/node-decorators/node-events';
	export interface SubNodeDecorator<This extends Node> extends NodeEvents<This> {
	    extends: () => typeof Node;
	    isPublished?: boolean;
	    isAbstract?: boolean;
	    canDeleteMany?: boolean;
	    isSetupNode?: boolean;
	    isVitalReferenceChild?: boolean;
	    isVitalCollectionChild?: boolean;
	    isAssociationReferenceChild?: boolean;
	    isAssociationCollectionChild?: boolean;
	    isFrozen?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    canRead?: boolean;
	    canCreate?: boolean;
	    canUpdate?: boolean;
	    canDelete?: boolean;
	    canDuplicate?: true;
	    canBulkDelete?: boolean;
	    canSearch?: boolean;
	    /** can override if false on base node */
	    hasAttachments?: boolean;
	    serviceOptions?: () => ServiceOption[];
	    isClearedByReset?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /** Indexes */
	    indexes?: NodeIndexDecorator<This>[];
	    /** Can this node be customized with customFields */
	    isCustomizable?: boolean;
	    /** Is this node a source for synchronization */
	    isSynchronizable?: true;
	}
	/**
	 * Describes a node that inherits from another (the base node)
	 * @param arg
	 */
	export function subNode<This extends Node>(arg: SubNodeDecorator<This>): ClassDecoratorFunction<typeof Node>;
	//# sourceMappingURL=sub-node-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/node-decorators/node-extension-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/node-decorators/node-extension-decorator' {
	/** @packageDocumentation @module decorators */
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Extend, Node, NodeExtension, SubNodeExtension1, SubNodeExtension2, SubNodeExtension3, SubNodeExtension4, SubNodeExtension5 } from '@sage/xtrem-core/lib/ts-api/index';
	import { ExternalStorageManagerExtension } from '@sage/xtrem-core/lib/decorators/external-storage-manager';
	import { NodeIndexDecorator } from '@sage/xtrem-core/lib/decorators/node-decorators/node-decorator';
	import { NodeEvents } from '@sage/xtrem-core/lib/decorators/node-decorators/node-events';
	export interface NodeExtensionDecorator<This extends Node> extends NodeEvents<This> {
	    extends: () => typeof Node;
	    indexes?: NodeIndexDecorator<Extend<This>>[];
	    externalStorageManagerExtension?: ExternalStorageManagerExtension<Extend<This>>;
	    /** Class service options */
	    serviceOptions?: () => ServiceOption[];
	    /** Is it a target of a vital reference ? */
	    isVitalReferenceChild?: boolean;
	    /** Is it a target of an association collection ? */
	    isAssociationCollectionChild?: boolean;
	    /** Is it a target of an association reference ? */
	    isAssociationReferenceChild?: boolean;
	    /** node extension can override attachments */
	    hasAttachments?: boolean;
	    /** Is this node a source for synchronization */
	    isSynchronizable?: true;
	    /** Is this node a target for synchronization */
	    isSynchronized?: true;
	}
	/** &#064;decorators.nodeExtension(arg) class extension decorator */
	export function nodeExtension<This extends NodeExtension<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	/** &#064;decorators.subNodeExtension1(arg) class extension decorator */
	export function subNodeExtension1<This extends SubNodeExtension1<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	/** &#064;decorators.subNodeExtension2(arg) class extension decorator */
	export function subNodeExtension2<This extends SubNodeExtension2<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	/** &#064;decorators.subNodeExtension3(arg) class extension decorator */
	export function subNodeExtension3<This extends SubNodeExtension3<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	/** &#064;decorators.subNodeExtension4(arg) class extension decorator */
	export function subNodeExtension4<This extends SubNodeExtension4<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	/** &#064;decorators.subNodeExtension5(arg) class extension decorator */
	export function subNodeExtension5<This extends SubNodeExtension5<Node>>(arg: NodeExtensionDecorator<This>): import("../decorator-utils").ClassDecoratorFunction<any>;
	//# sourceMappingURL=node-extension-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/node-decorators/node-events.d.ts
declare module '@sage/xtrem-core/lib/decorators/node-decorators/node-events' {
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { Extend, Node, NodeQueryFilter, ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	/** Events for &#064;decorators.node decorator */
	export interface NodeEvents<This extends Node = Node> {
	    /** User filter that applies to all queries */
	    getFilters?: (context: Context) => AsyncResponse<NodeQueryFilter<This>[]>;
	    /** compatibility alias for prepareBegin */
	    prepare?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event before individual prepare on properties */
	    prepareBegin?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event before individual prepare on properties */
	    prepareEnd?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event raised after a node is manually created (will not be fired when the node is created from db read) */
	    createEnd?: (this: Extend<This>) => AsyncResponse<void>;
	    /** event before individual control on properties */
	    controlBegin?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event after individual control on properties */
	    controlEnd?: (this: Extend<This>, cx: ValidationContext) => AsyncResponse<void>;
	    /** event before deletion */
	    controlDelete?: (this: Extend<This>, cx: ValidationContext, isCascading: boolean) => AsyncResponse<void>;
	    /** event before save */
	    saveBegin?: (this: Extend<This>) => AsyncResponse<void>;
	    /** event after save */
	    saveEnd?: (this: Extend<This>) => AsyncResponse<void>;
	    /** event before deletion */
	    deleteBegin?: (this: Extend<This>, isCascading: boolean) => AsyncResponse<void>;
	    /** event after deletion */
	    deleteEnd?: (this: Extend<This>, isCascading: boolean) => AsyncResponse<void>;
	}
	export type NodeRuleName = keyof NodeEvents | 'isFrozen';
	//# sourceMappingURL=node-events.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/node-decorators/node-decorator.d.ts
declare module '@sage/xtrem-core/lib/decorators/node-decorators/node-decorator' {
	/** @packageDocumentation @module decorators */
	import { AsyncResponse, UnPromised } from '@sage/xtrem-async-helper';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/index';
	import { Context, StandardOperation } from '@sage/xtrem-core/lib/runtime/index';
	import { Extend, FlatOrderBy, Node, ValidationContext } from '@sage/xtrem-core/lib/ts-api/index';
	import { ClassDecoratorFunction, NodeFilterTag } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { ExternalStorageManager } from '@sage/xtrem-core/lib/decorators/external-storage-manager';
	import { NodeEvents } from '@sage/xtrem-core/lib/decorators/node-decorators/node-events';
	export type NodeStorage = 'sql' | 'json' | 'external';
	export type NotifyOperation = 'created' | 'updated' | 'deleted';
	/**
	 * * low -> read-committed
	 * * medium -> repeatable read
	 * * high -> serializable
	 */
	export type IsolationLevel = 'low' | 'medium' | 'high';
	/**
	 * Isolation levels for node operations
	 */
	export interface IsolationLevels {
	    /** Isolation level for update mutation */
	    create?: IsolationLevel;
	    /** Isolation level for update mutation */
	    update?: IsolationLevel;
	    /** Isolation level for delete mutation */
	    delete?: IsolationLevel;
	}
	/** Node index definition */
	export interface NodeIndexDecorator<T extends Node = Node> {
	    orderBy: FlatOrderBy<T>;
	    isUnique?: boolean;
	    isNaturalKey?: boolean;
	    name?: string;
	}
	export interface NodeUpdateEventArg<This extends Node> {
	    modifiedPropertyNames: string[];
	}
	export type StringOrNumberOrNull = string | number | null;
	export type NodeKey<T extends Node> = {
	    [K in keyof T]?: UnPromised<T[K]> | StringOrNumberOrNull;
	};
	export type NodePropertyName<T extends Node> = Exclude<keyof T & string, '$'>;
	export interface NodePersistHooks<This extends Node> {
	    /** save hook
	     * Saves the node and all its children (collections).
	     *
	     * This hook short-circuits all the SQL save logic (saveXxx events, insert, update events).
	     * It can be used to serialize the node and send it to another service which will persist it.
	     */
	    save?: (this: Extend<This>, cx: ValidationContext) => void;
	    /** delete hook
	     * Deletes the node and all its children (collections).
	     *
	     * This hook short-circuits all the SQL delete logic.
	     * It can be used to send the node key to another service which will delete it.
	     */
	    delete?: (this: Extend<This>, cx: ValidationContext) => void;
	    /** read hook
	     * Reads a node given its key.
	     *
	     * This hook short-circuits all the SQL read logic.
	     * It can be used to read the node from another service which persists it.
	     *
	     * Note: there is no query hook yet, only read. Query is more challenging because we
	     * have to pass paging/filtering/sorting parameters.
	     */
	    read?: (context: Context, key: NodeKey<This>) => Extend<This> | null;
	}
	export interface NodeTableHooks<This extends Node> {
	    /** insert hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    insert?: (this: Extend<This>) => void;
	    /** update hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    update?: (this: Extend<This>, data: Partial<This>, arg: NodeUpdateEventArg<This>) => number;
	    /** delete hook - not called if storage is 'sql'
	     * Mandatory if persistency not handled by framework
	     */
	    delete?: (this: Extend<This>) => number;
	}
	/** Parameter type for &#064;decorators.node decorator */
	export interface NodeDecorator<This extends Node = Node> extends NodeEvents<This> {
	    /** Are the node instances cached. This attribute should only set on nodes that change infrequently */
	    isCached?: true;
	    /** Is there a unique index based on a hash of the contents. Implies that records are immutable (inserted but never updated) */
	    isContentAddressable?: true;
	    /** Package name */
	    package?: string;
	    /** May be used by external storage nodes */
	    tableName?: string;
	    /** Class storage */
	    storage?: NodeStorage;
	    /** data layer */
	    isSetupNode?: boolean;
	    /** node has a vendor property, must also have a naturalKey and be a setup node and the default is true in that case */
	    hasVendorProperty?: boolean;
	    /** node has a layer property */
	    hasLayerProperty?: boolean;
	    /** node can have attachments */
	    hasAttachments?: boolean;
	    /** Indicates whether this node is abstract and is only intended to be accessed through its subclassed */
	    isAbstract?: true;
	    /** Is the node instance frozen (immutable)? */
	    isFrozen?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /** Can the class be read/queried? */
	    canRead?: boolean;
	    /** Can new nodes be created? */
	    canCreate?: boolean;
	    /** Can existing nodes be updated? */
	    canUpdate?: boolean;
	    /** Can nodes be deleted? */
	    canDelete?: boolean;
	    /** Can nodes be duplicated? */
	    canDuplicate?: true;
	    /** Can nodes be updated via a async bulk mutation? */
	    /** Can nodes be deleted via a async bulk mutation? */
	    canBulkDelete?: boolean;
	    /** Are nodes indexed in the search engine */
	    canSearch?: boolean;
	    /** code for access rights (X3 _function_ code) */
	    authorizationCode?: string;
	    /** Do we include the export mutation on this node */
	    canExport?: boolean;
	    isSharedByAllTenants?: boolean;
	    /** published in graphql API? */
	    isPublished?: boolean;
	    /** Class service options */
	    serviceOptions?: () => ServiceOption[];
	    /** Node holding the table definition (if table is shared by several nodes) */
	    tableNode?: () => typeof Node;
	    /** Indexes */
	    indexes?: NodeIndexDecorator<This>[];
	    externalStorageManager?: ExternalStorageManager<This>;
	    /** key property names */
	    keyPropertyNames?: (keyof This)[];
	    /** Returns whether the BulkDelete function can be used on this Node */
	    canDeleteMany?: boolean;
	    /** Is it a target of a vital reference ? */
	    isVitalReferenceChild?: boolean;
	    /** Is it a target of a vital collection ? */
	    isVitalCollectionChild?: boolean;
	    /** Is it a target of an association collection ? */
	    isAssociationCollectionChild?: boolean;
	    /** Is it a target of an association reference ? */
	    isAssociationReferenceChild?: boolean;
	    /** List of notification operations to trigger */
	    notifies?: NotifyOperation[];
	    /**
	     * Indicates whether the node is from the platform. These nodes can't be extended
	     */
	    isPlatformNode?: boolean;
	    /**
	     * Indicates whether a platform node is included in the tenant export. The common use case is to not export them
	     */
	    isPlatformNodeExportable?: boolean;
	    /**
	     * Indicates whether a node is skipped when we extract the layers
	     */
	    isSkippedByLayerExtract?: boolean;
	    /** Isolation level for CRUD mutations */
	    isolationLevels?: IsolationLevels;
	    /**
	     * Indicates if the property should be cleared to its default value when we do a reset
	     */
	    isClearedByReset?: boolean | ((this: Extend<This>) => AsyncResponse<boolean>);
	    /**
	     * Does node provide an access rights node (site, legislation, ...).
	     * When this is set we will filter the query but the corresponding allowed codes
	     * Only site is implemented today
	     */
	    provides?: NodeFilterTag[];
	    /**
	     * Stores the list of operations that require admin privileges.
	     */
	    adminOperations?: 'all' | 'allMutations' | (keyof Node | StandardOperation)[];
	    /** Can this node be customized with customFields */
	    isCustomizable?: boolean;
	    /** Is this node a source for synchronization */
	    isSynchronizable?: true;
	    /** Is this node a target for synchronization */
	    isSynchronized?: true;
	    /** Can this node be transformed and used in interop queries or mutations */
	    isInterop?: true;
	    /** Queue name for this node */
	    queue?: string;
	    /** Do non-nullable references to this node default to the found record if lookup returns one record */
	    defaultsToSingleMatch?: boolean;
	    /** Do not allow a read operation when user has only lookup access
	     * The default is to allow the read operation, but only access to lookup access fields
	     * In certain cases we do not want to allow direct read on a node, for example the User node
	     */
	    denyReadOnLookupOnlyAccess?: boolean;
	}
	/** &#064;decorators.node(arg) class decorator */
	export function node<This extends Node>(arg: NodeDecorator<This>): ClassDecoratorFunction<typeof Node>;
	//# sourceMappingURL=node-decorator.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/decorators/node-decorators/index.d.ts
declare module '@sage/xtrem-core/lib/decorators/node-decorators/index' {
	export * from '@sage/xtrem-core/lib/decorators/node-decorators/node-decorator';
	export * from '@sage/xtrem-core/lib/decorators/node-decorators/node-extension-decorator';
	export * from '@sage/xtrem-core/lib/decorators/node-decorators/sub-node-decorator';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/collections/sql-collection.d.ts
declare module '@sage/xtrem-core/lib/collections/sql-collection' {
	/** @packageDocumentation @module runtime */
	import { AsyncResponse } from '@sage/xtrem-async-helper';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	export interface SqlAggregateOptions<NodeT extends Node = Node> {
	    where?: (node: NodeT) => AsyncResponse<boolean>;
	    sum: (node: NodeT) => AsyncResponse<number>;
	}
	export interface SqlFindAndMapOptions<NodeT extends Node = Node, ResultT = any> {
	    matching: (node: NodeT) => AsyncResponse<boolean>;
	    ifFound: (node: NodeT) => AsyncResponse<ResultT>;
	}
	//# sourceMappingURL=sql-collection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/collections/mutable-collection.d.ts
declare module '@sage/xtrem-core/lib/collections/mutable-collection' {
	import { Node, NodeCreateData } from '@sage/xtrem-core/lib/ts-api/index';
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/base-collection';
	export class MutableCollection extends BaseCollection {
	    get isVitalCollectionChild(): boolean;
	    get isAssociationChild(): boolean;
	    get hasSortValue(): boolean;
	    reset(): Promise<void>;
	    fill(array: NodeCreateData<Node>[]): Promise<void>;
	    insert(i: number, data: NodeCreateData<Node>): Promise<void>;
	    append(data: NodeCreateData<Node>): Promise<void>;
	    delete(start: number, deleteCount?: number): Promise<void>;
	    /**
	     * Force the lazy-loading of the collection in the old.state of the sourceNode
	     * This function is mainly invoked before an item is deleted from the collection (so that node.$.old.collection is valid)
	     */
	    private _forceLazyloadingForSourceOld;
	    /**
	     * Find the key of the oldState from the oldMap
	     * @param dataWithKey
	     * @param oldMap
	     * @returns
	     */
	    private findOldTokenFromData;
	    isValid(): boolean;
	}
	//# sourceMappingURL=mutable-collection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/collections/index.d.ts
declare module '@sage/xtrem-core/lib/collections/index' {
	export * from '@sage/xtrem-core/lib/collections/base-collection';
	export * from '@sage/xtrem-core/lib/collections/immutable-collection';
	export * from '@sage/xtrem-core/lib/collections/mutable-collection';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/collections/immutable-collection.d.ts
declare module '@sage/xtrem-core/lib/collections/immutable-collection' {
	import { BaseCollection } from '@sage/xtrem-core/lib/collections/base-collection';
	export class ImmutableCollection extends BaseCollection {
	    private getCurrentTargetFactoryTick;
	}
	//# sourceMappingURL=immutable-collection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/collections/base-collection.d.ts
declare module '@sage/xtrem-core/lib/collections/base-collection' {
	/** @packageDocumentation @module runtime */
	import { AnyValue, AsyncArray, AsyncReader } from '@sage/xtrem-async-helper';
	import { AsyncResponse } from '@sage/xtrem-shared';
	import { CollectionProperty } from '@sage/xtrem-core/lib/properties/index';
	import { Collection, Node, NodeCreateData, NodeQueryFilter, NodeQueryOptions, SqlWhereInterface } from '@sage/xtrem-core/lib/ts-api/index';
	export interface CollectionCreateOptions {
	    nodes?: Node[];
	}
	export abstract class BaseCollection extends AsyncArray<Node> implements Collection<Node> {
	    sourceNode: Node;
	    readonly property: CollectionProperty;
	    get joinValues(): AsyncResponse<NodeQueryFilter<Node>>;
	    get name(): string;
	    private combineFilters;
	    withReader<R extends AnyValue>(body: (reader: AsyncReader<Node>) => R): Promise<R>;
	    join(sep?: string): Promise<string>;
	    get fullName(): string;
	    /**
	     * indicates if the the collection's nodes are loaded
	     */
	    get isLoaded(): boolean;
	    get length(): Promise<number>;
	    reset(): Promise<void>;
	    fill(array: NodeCreateData<Node>[]): Promise<void>;
	    insert(i: number, data: NodeCreateData<Node>): Promise<void>;
	    append(data: NodeCreateData<Node>): Promise<void>;
	    delete(start: number, deleteCount?: number): Promise<void>;
	    query(options: NodeQueryOptions): AsyncArray<Node>;
	    where(condition?: (node: Node) => AsyncResponse<boolean>): SqlWhereInterface<Node>;
	    takeOne(condition: (node: Node) => AsyncResponse<boolean>): Promise<Node | null>;
	}
	//# sourceMappingURL=base-collection.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/cache/memory-cache.d.ts
declare module '@sage/xtrem-core/lib/cache/memory-cache' {
	/// <reference types="@sage/xtrem-log" />
	/** @ignore */ /** */
	import { AnyValue } from '@sage/xtrem-async-helper';
	import { ProfilerCallback } from '@sage/xtrem-shared';
	import { StringProperty } from '@sage/xtrem-core/lib/properties/index';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { ContextVault } from '@sage/xtrem-core/lib/runtime/context-vault';
	import { GlobalCacheOptions } from '@sage/xtrem-core/lib/cache/global-cache';
	export const logger: import("@sage/xtrem-log").Logger;
	enum MemoryCacheTypeEnum {
	    context = 0,
	    global = 1
	}
	export type MemoryCacheType = keyof typeof MemoryCacheTypeEnum;
	export class MemoryCache {
	    private _invalidatingTokenMap;
	    private _values;
	    constructor(tenantId: string, type: MemoryCacheType);
	    getCounters(): MemoryCacheCounters;
	    fetchValue<T extends AnyValue>(category: string, key: string): T | undefined;
	    storeValue<T extends AnyValue>(category: string, key: string, item: {
	        value: T;
	        invalidatingTokens?: string[];
	        storedEncryptedProperties?: StringProperty[];
	    }, options: GlobalCacheOptions<T> & {
	        vault?: ContextVault;
	    }): void;
	    /**
	     * Add a token to `this.#MemoryCache`.
	     *
	     * This is called after a query has been run, to associate the query's `{ category, key }` pair with the token
	     * (the name of a table which was joined by the query).
	     */
	    private addInvalidatingToken;
	    /**
	     * Removes the cache entries for queries that joined one of the table names of a node factory (one of the tokens
	     * of a category).
	     *
	     * This is called when we invalidate a node factory (a category) after records have been inserted/updated/deleted
	     * in the factory's table (or in one of its tables if the factory is part of an inheritance tree).
	     *
	     * This is also called when we receive an `invalidateCategoryCache` broadcast event from another container.
	     * In this case, the database change was done in a different container but we can use the same logic
	     * to update our cache.
	     */
	    invalidateCategory(context: Context, category: string): void;
	    private deleteKey;
	    purge(now: number, maxCost: number): void;
	    showCounters(): ProfilerCallback;
	}
	export {};
	//# sourceMappingURL=memory-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/cache/index.d.ts
declare module '@sage/xtrem-core/lib/cache/index' {
	export * from '@sage/xtrem-core/lib/cache/global-cache';
	export { MemoryCache } from '@sage/xtrem-core/lib/cache/memory-cache';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/cache/global-cache.d.ts
declare module '@sage/xtrem-core/lib/cache/global-cache' {
	/// <reference types="@sage/xtrem-log" />
	/** @ignore */ /** */
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	/** Global cache module
	 * To use:
	 *
	 *      const cachedValue = application.globalCache.getValue<MyType>(
	 *          context,
	 *          {
	 *              category: myCategory,
	 *              key: myKey,
	 *              getValue: getValueCallback,
	 *              cacheInMemory: true,
	 *              ttlInSeconds: 5 * 60,
	 *           }
	 *      );
	 *
	 * If the key is not in the cache, `getValueCallback` will be invoked to obtain the value.
	 * The value will then be cached, according to the provided options
	 * (here, the value will be cached for 5 minutes in memory and database).
	 *
	 *
	 *  `getValueCallback` has the following signature: `() => { value: MyType, invalidatingTokens?: string[] }`
	 *  where `value` is the value and invalidatingTokens is an optional list of tokens that may invalidate the cached result.
	 *
	 * `MyType` can usually be omitted. It will be inferred from `getValue`.
	 */
	export const logger: import("@sage/xtrem-log").Logger;
	export type GetValueCallback<T extends AnyValue> = () => AsyncResponse<{
	    value: T;
	    invalidatingTokens?: string[];
	}>;
	export interface GlobalCacheOptions<T extends AnyValue> {
	    category: string;
	    key: string;
	    getValue: GetValueCallback<T>;
	    /** should the value be written to the context cache? */
	    isolateInContext?: boolean;
	    /** should the value be written to the in-memory cache? */
	    cacheInMemory?: boolean;
	    /** The TTL of the value (value will never expire if TTL is not set) */
	    ttlInSeconds: number;
	}
	//# sourceMappingURL=global-cache.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/aws/s3-manager.d.ts
declare module '@sage/xtrem-core/lib/aws/s3-manager' {
	import { Application } from '@sage/xtrem-core/lib/application/index';
	type S3Configuration = {
	    bucket: string;
	    folder: string;
	    s3Key?: string;
	    /**
	     * Returns the full folder (S3 prefix) to be used for this configuration
	     * When not set, the folder will be used
	     */
	    getFullFolder?: (app: Application) => string;
	};
	const s3Configurations: {
	    /**
	     * The S3 bucket used to store the reference database backups (the backups used for the generation of SQL files)
	     */
	    forSqlFiles: S3Configuration;
	    /**
	     * The S3 bucket used to store cluster-cu backups
	     * Used to restore a backup of cluster-cu, from the begining of the month
	     */
	    clusterCuBackup: S3Configuration;
	    /**
	     * The S3 bucket used to store cluster-ci backups
	     * Used to restore a backup of cluster-ci, after the last successful upgrade
	     */
	    clusterCiBackup: S3Configuration;
	    /**
	     * The S3 bucket used to store cluster-ci/sdmo backups
	     * Used to restore a backup of cluster-ci/sdmo, after the last successful upgrade
	     */
	    clusterCiSdmo: S3Configuration;
	    /**
	     * Cluster reference
	     */
	    clusterReference: S3Configuration;
	    /**
	     * Cluster release (dev)
	     */
	    clusterDevRelease: S3Configuration;
	    /**
	     * Cluster release (qa)
	     */
	    clusterQaRelease: S3Configuration;
	    /**
	     * Glossary
	     * To regenerate the S3 backup : Use https://sage-liveservices.visualstudio.com/X3%20XTREM/_build?definitionId=2311
	     *    - Name of cluster to dump : glossary
	     *    - Env of cluster to dump : dev-eu
	     *    - withDate : unchecked
	     *    - suffix : latestWorking
	     */
	    glossary: S3Configuration;
	    /**
	     * Showcase
	     * To regenerate the S3 backup : Use https://sage-liveservices.visualstudio.com/X3%20XTREM/_build?definitionId=2311
	     *    - Name of cluster to dump : showcase
	     *    - Env of cluster to dump : dev-eu
	     *    - withDate : unchecked
	     *    - suffix : latestWorking
	     */
	    showcase: S3Configuration;
	    /**
	     * Shopfloor
	     */
	    shopfloor: S3Configuration;
	    /**
	     * X3 Connector
	     */
	    x3_connector: S3Configuration;
	};
	export type S3ConfigurationType = keyof typeof s3Configurations;
	export abstract class S3Manager {
	    private static _postgreSqlTools;
	    /**
	     * Dump the schema of an application to a S3 bucket (and returns the S3 URI of the written object)
	     * @param app the application to dump the schema from
	     */
	    static dumpSchemaToS3Bucket(app: Application): Promise<string>;
	    /**
	     * Returns the full folder (S3 prefix) to be used for a given S3 configuration
	     */
	    private static _getFullS3Folder;
	    /**
	     * Resolve the version of the backup to be used to generate a new SQL file
	     * @param app
	     * @param version
	     * @returns
	     */
	    private static _resolveVersionToRestoreForSqlFiles;
	    /**
	     * Raise an error when a specific version is not part of the available backups used to generate SQL files
	     * @param app
	     * @param version
	     * @param versions
	     */
	    private static _raiseErrorVersionNotFoundForSqlFile;
	    /**
	     * Restore a schema version from a S3 bucket.
	     * If the version is 'latest', the latest available dump for the application will be restored
	     * @param app the application to restore the schema for
	     * @param versionOrS3Uri either a version to restore, or a full S3 URI of the backup to restore
	     * @param s3ConfigurationType the type of the S3 configuration to restore from
	     * @param options.checkSingleSchema if true, will raise an error if there are more than 2 schemas in the database
	     */
	    static restoreSchemaFromS3Bucket(app: Application, versionOrS3Uri: string, s3ConfigurationType?: S3ConfigurationType, options?: {
	        checkSingleSchema: boolean;
	    }): Promise<void>;
	    private static _listSchemas;
	    /**
	     * Upload a local db dump to a S3 bucket and returns the S3 URL of the written object
	     * @param localFolder the local folder that contains the file to copy
	     * @param filename the name of the file to copy
	     * @param dumpKey the key to use to store the dump into S3
	     */
	    static uploadDumpToS3(app: Application, localFolder: string, filename: string, dumpKey: string): Promise<string>;
	    /**
	     * Upload a local file to a S3 bucket and returns the S3 URL of the written object
	     * @param s3Configuration see s3Configurations
	     * @param localFilename the (full) filename of the local file to copy
	     * @param objectKey the key to use to store the file into S3
	     */
	    private static _uploadLocalFileToS3;
	    /**
	     * Returns whether an objectKey matches a db backup that can be used to generate SQL files for a given application
	     */
	    private static _isBackupForSqlFile;
	    /**
	     * List the versions hosted in the S3 bucket for a given application.
	     * Will only return versions for backups that can be used to generate SQL files.
	     * Will only return the versions with the same major version as the application.
	     * @param app
	     */
	    static getAvailableVersions(app: Application): Promise<string[]>;
	    /**
	     * Extracts the version from a S3 key.
	     * @sage/xtrem-services-main@6.0.13.zip -> 6.0.13
	     *
	     * @param s3Key
	     * @returns
	     */
	    private static _getVersionFromS3Key;
	    /**
	     * Returns the list of backups that can be used to generate SQL files for a given application
	     * @param app
	     * @param bucketName
	     * @returns
	     */
	    private static _listS3BackupsForSqlFile;
	    /**
	     * Download a file from a S3ObjectInfo.
	     * The function will return the filename of the written file (short filename, without the folder)
	     *
	     * @param sourceS3Info the information of the file to download
	     * @param targetLocalFolder the local folder in which the file must be written
	     */
	    private static _downloadDumpFileFromS3ObjectInfo;
	    /**
	     * Download a file from a (S3Key, S3ConfigurationType)
	     * and returns the filename of the written file (short filename, without the folder)
	     *
	     * @param localFolder the local folder in which the file must be written
	     * @param s3Key the key of the file to download
	     * @param s3ConfigurationType the configuration that will be used to compute the prefix of the file to download
	     */
	    private static _downloadDumpFileFromS3Key;
	    private static _tailLogLine;
	    /**
	     * Pipes a readable stream to a writable stream.
	     * Transformations are applied according to the provided mappings.
	     */
	    private static _pipeStreamWithTransformations;
	    private static _pgClientToolCommand;
	    /**
	     * Dumps the current schema (described by the current configuration) to a local dump file.
	     * Note: if the filename is a zip file, the dump will be a valid zip archive.
	     *
	     * Note: the created file will be anonymized: it will contain no schema/user name, they will be replaced with tags:
	     * - schema -> [SCHEMA_NAME]
	     * - user -> [USER_NAME]
	     *
	     * @param folder the folder that contains the dump file
	     * @param filename the name of the dump file
	     */
	    static dumpSchemaToFile(folder: string, filename: string, schemaName: string): Promise<void>;
	    /**
	     * Returns the mappings that should be applied to a sql file before it get restored
	     * @param schemaName
	     * @param dumpFullFilename
	     * @param sqlCfg
	     */
	    private static _getMappingsForDumpFiles;
	    /**
	     * Restore a schema from a dump file
	     * @param tempFolder the 'temp' folder where to create the 'sql.mapped.dump' file
	     * @param dumpFullFilename the FULL filename of the 'sql.dump' file
	     * @param schemaName
	     */
	    static restoreFromDumpFile(folder: string, dumpFullFilename: string, schemaName: string): Promise<void>;
	    /**
	     * Restore from a zip file, extract the zip and restore the dump file contained
	     * @param tempFolder the 'temp' folder to use to extract the archive
	     * @param archiveFullFilename the FULL filename of the archive
	     */
	    private static _restoreSchemaFromZip;
	    /**
	     * Restore from a gz dump file
	     * @param tempFolder the 'temp' folder to use
	     * @param dumpFullFilename the FULL filename of the dump to restore
	     */
	    private static _restoreSchemaFromBackup;
	    /**
	     * Process the table of content of a postgres dump.
	     * Mainly : some entries related to extensions will be filtered and the content will be parsed to retrieve the name of schemas
	     */
	    private static _processTableOfContentsForRestoration;
	    /**
	     * Drops a bunch of schemas (if they exist) before restoring a dump
	     */
	    private static _dropSchemasBeforeRestoration;
	    /**
	     * Restores the current schema (described by the current configuration) from a local dump file.
	     * Note: if the filename is a zip file, it will be extracted first.
	     *
	     * @param tempFolder the 'temp' folder where the archive will be extracted
	     * @param fullFilename the full filename of the dump file
	     */
	    private static _restoreSchemaFromFile;
	    /** Generic asynchronous handler for child process stdout, stderr and close event listeners */
	    private static _childProcessHandler;
	    private static _normalizeApplicationName;
	}
	export {};
	//# sourceMappingURL=s3-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/aws/s3-helper.d.ts
declare module '@sage/xtrem-core/lib/aws/s3-helper' {
	import { Datetime } from '@sage/xtrem-date-time';
	import { S3Bucket } from '@sage/xtrem-core/lib/aws/s3-bucket';
	export type S3ObjectInfo = {
	    bucketName: string;
	    folder: string;
	    key: string;
	    lastModified?: Datetime;
	    eTag?: string;
	    size?: number;
	    storageClass?: string;
	};
	export abstract class S3Helper {
	    /**
	     * Ensures that the provided S3Bucket is compatible with S3 infos
	     * @param s3Bucket
	     * @param s3Infos
	     */
	    private static _checkS3Bucket;
	    /**
	     * Upload a local file to a S3 bucket and returns the S3 URI of the written object
	     * @param sourceFilename the local filename of the file to copy
	     * @param targetS3Info the bucket/folder/key of the object to write
	     * @param s3Bucket the (optional) S3 bucket to use (to optimize chained calls)
	     */
	    static upload(sourceFilename: string, targetS3Info: S3ObjectInfo, s3Bucket?: S3Bucket): Promise<string>;
	    /**
	     * Download a file from a S3 bucket
	     * @param sourceS3Info the bucket/folder/key of the object to copy
	     * @param targetFilename the local file to write
	     * @param s3Bucket the (optional) S3 bucket to use (to optimize chained calls)
	     */
	    static download(sourceS3Info: S3ObjectInfo, targetFilename: string, s3Bucket?: S3Bucket): Promise<void>;
	    /**
	     * Parse a S3 URI with the following format : s3://bucketName/xxx/yyy/key
	     * @param s3Uri
	     */
	    static parseS3Uri(s3Uri: string): S3ObjectInfo;
	    /**
	     * Builds a valid S3 URI
	     * @param s3
	     */
	    static buildS3Uri(s3: S3ObjectInfo): string;
	    /**
	     * Returns whether an object exists in a bucket
	     * @param s3 the information about the object
	     * @param s3Bucket the (optional) S3 bucket to use (to optimize chained calls)
	     */
	    static objectExists(s3: S3ObjectInfo): Promise<boolean>;
	    /**
	     * List all objects present in a bucket: this function supports AWS S3 pagination mechanism
	     * @param s3 the information about the objects
	     * @param s3Bucket the S3 bucket to use
	     * @param params the parameters to use
	     */
	    private static _listObjectsV2;
	    /**
	     * List objects present in a bucket
	     * @param s3 the information about the objects
	     */
	    static listObjects(s3: S3ObjectInfo): Promise<S3ObjectInfo[]>;
	}
	//# sourceMappingURL=s3-helper.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/aws/s3-bucket.d.ts
declare module '@sage/xtrem-core/lib/aws/s3-bucket' {
	import { PutObjectCommandInput, PutObjectCommandOutput } from '@aws-sdk/client-s3';
	export type WithoutBucket<T> = Omit<T, 'Bucket'>;
	export class S3Bucket {
	    readonly bucketName: string;
	    constructor(bucketName: string);
	    /**
	     * Returns the region to use
	     * @param bucketName if set, will return the region specific for this bucket (from configuration)
	     * @returns
	     */
	    static getRegion(bucketName?: string): string;
	    private _addBucket;
	    private _tryWait;
	    /**
	     * Streams a readableStream to S3
	     *
	     * @example
	     * const res = await myBucket.putObject({
	     *              Key: the_key_of_the_S3_object,
	     *              Body: readStream,
	     *          });
	     */
	    putObject(request: WithoutBucket<PutObjectCommandInput>): Promise<PutObjectCommandOutput>;
	    private _writeObjectToStream;
	}
	//# sourceMappingURL=s3-bucket.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/aws/index.d.ts
declare module '@sage/xtrem-core/lib/aws/index' {
	export * from '@sage/xtrem-core/lib/aws/aws-helper';
	export * from '@sage/xtrem-core/lib/aws/s3-bucket';
	export * from '@sage/xtrem-core/lib/aws/s3-helper';
	export * from '@sage/xtrem-core/lib/aws/s3-manager';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/aws/aws-helper.d.ts
declare module '@sage/xtrem-core/lib/aws/aws-helper' {
	import { Maybe } from '@sage/xtrem-shared';
	export function getRegion(fallbackRegion?: string): Maybe<string>;
	//# sourceMappingURL=aws-helper.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/archive/index.d.ts
declare module '@sage/xtrem-core/lib/archive/index' {
	export * from '@sage/xtrem-core/lib/archive/compress';
	export * from '@sage/xtrem-core/lib/archive/decompress';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/archive/decompress.d.ts
declare module '@sage/xtrem-core/lib/archive/decompress' {
	/**
	 * Helper to decompress zip archives (only zip archives are supported by extract-zip).
	 * Uses 'extract-zip' npm module https://www.npmjs.com/package/extract-zip
	 */
	export abstract class Decompress {
	    /**
	     * Decompress a zip archive to a local folder (this folder must already exist) and returns the RELATIVE path
	     * of the extracted files (relative to the provided targetPath)
	     * @param archiveFilename the path of the zip archive to extract
	     * @param targetPath the local folder where the extracted files should be written (this folder must exist)
	     */
	    static decompressZipToFolder(archiveFilename: string, targetPath: string): Promise<string[]>;
	}
	//# sourceMappingURL=decompress.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/archive/compress.d.ts
declare module '@sage/xtrem-core/lib/archive/compress' {
	/// <reference types="node" />
	/// <reference types="node" />
	import { Writable } from 'stream';
	import { ZlibOptions } from 'zlib';
	export interface ZipOptions {
	    comment?: String;
	    forceLocalTime?: boolean;
	    forceZip64?: boolean;
	    store?: boolean;
	    zlib?: ZlibOptions;
	}
	export abstract class Compress {
	    private static _createArchiver;
	    static zipDirectory(sourceDir: string, targetZip: string, options?: ZipOptions): Promise<void>;
	    static zipDirectoryToStream(sourceDir: string, output: Writable, options?: ZipOptions): Promise<void>;
	    static zipFile(fullpath: string, filename: string, outFilename: string, options?: any): Promise<void>;
	}
	//# sourceMappingURL=compress.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/unhandled-error-monitor.d.ts
declare module '@sage/xtrem-core/lib/application/unhandled-error-monitor' {
	export class UnhandledErrorMonitor {
	    private _started;
	    private _threshold;
	    private readonly _interval;
	    private _unhandledRejection;
	    private _uncaughtException;
	    unhandledRejection(reason: any, p: Promise<any>): void;
	    uncaughtException(err: Error): void;
	    start(seconds: number | undefined, threshold: number | undefined): void;
	}
	export const unhandledErrorMonitor: UnhandledErrorMonitor;
	//# sourceMappingURL=unhandled-error-monitor.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/service-option.d.ts
declare module '@sage/xtrem-core/lib/application/service-option' {
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	export type ServiceOptionStatus = 'workInProgress' | 'experimental' | 'released';
	export interface ServiceOptionArg {
	    readonly __filename: string;
	    name?: string;
	    code?: string;
	    status: ServiceOptionStatus;
	    description?: string;
	    isSubscribable?: boolean;
	    isHidden: boolean;
	    activates?: () => ServiceOption[];
	    isActiveByDefault?: true;
	    onEnabled?: (context: Context) => Promise<void>;
	    onDisabled?: (context: Context) => Promise<void>;
	}
	export class ServiceOption {
	    readonly name: string;
	    readonly code?: string;
	    readonly status: ServiceOptionStatus;
	    readonly description?: string;
	    readonly isSubscribable: boolean;
	    isHidden: boolean;
	    readonly activates?: () => ServiceOption[];
	    readonly isActiveByDefault: boolean;
	    onEnabled?: (context: Context) => Promise<void>;
	    onDisabled?: (context: Context) => Promise<void>;
	    constructor(arg: ServiceOptionArg);
	    setPackageName(name: string): void;
	    get packageName(): string;
	    getLocalizedTitleKey(): string;
	}
	//# sourceMappingURL=service-option.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/service-option-manager.d.ts
declare module '@sage/xtrem-core/lib/application/service-option-manager' {
	import { AsyncResponse, Dict } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { ServiceOption, ServiceOptionStatus } from '@sage/xtrem-core/lib/application/service-option';
	/**
	 * Base class for service option managers
	 */
	export abstract class ServiceOptionManager {
	    readonly application: Application;
	    constructor(application: Application);
	    /** Returns a toposorted array of all the application's service options */
	    protected get sortedServiceOptions(): ServiceOption[];
	    /** Returns the service options indexed by name */
	    get serviceOptionsByName(): Dict<ServiceOption>;
	    /** Returns whether a service option status is enabled or not by the config file */
	    static isServiceOptionStatusEnabled(status: ServiceOptionStatus): boolean;
	    /**
	     * Returns whether a service option is enabled or not.
	     * Enabled means enabled by configuration and by tenant.
	     * @param context the context
	     * @param ServiceOption the service option
	     */
	    abstract isServiceOptionEnabled(context: Context, serviceOption: ServiceOption): AsyncResponse<boolean>;
	    /**
	     * Gets the array of enabled service options
	     * @param context: the context
	     */
	    abstract getEnabledServiceOptions(context: Context): Promise<ServiceOption[]>;
	    /** Low-level method to set and persist the isActive state of a service option */
	    abstract setServiceOptionActiveState(context: Context, serviceOption: ServiceOption, isActive: boolean): Promise<void>;
	    /** Activates a single service option */
	    private activateServiceOption;
	    /** Get the array of service options that activate a given option */
	    private static getActivatingActiveOptions;
	    /** Deactivates a single service option */
	    private deactivateServiceOption;
	    /** Activates an array of service options */
	    activateServiceOptions(context: Context, serviceOptions: ServiceOption[]): Promise<ServiceOption[]>;
	    /** Deactivates an array of service options */
	    deactivateServiceOptions(context: Context, serviceOptions: ServiceOption[]): Promise<void>;
	    /** Activates or deactivates a service option (and its dependencies) */
	    setServiceOptionActive(context: Context, serviceOption: ServiceOption, isActive: boolean): Promise<void>;
	    /**
	     * Creates missing service options (existing in the code but not in the database) and update existing ones (existing both in code and in db).
	     */
	    createOrUpdateServiceOptions(_context: Context): Promise<void>;
	    /**
	     * Deletes the obsolete service options (existing in the database but not in the code).
	     */
	    deleteObsoleteServiceOptions(_context: Context): Promise<void>;
	    /**
	     * Creates or upgrades the service option states of a tenant (the context's tenant).
	     * Called at the end of schema creation and upgrade.
	     */
	    createOrUpgradeServiceOptionStates(_context: Context, _serviceOptionActiveFlags?: Dict<boolean>): Promise<void>;
	}
	//# sourceMappingURL=service-option-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/service-option-manager-stub.d.ts
declare module '@sage/xtrem-core/lib/application/service-option-manager-stub' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/service-option';
	import { ServiceOptionManager } from '@sage/xtrem-core/lib/application/service-option-manager';
	/**
	 * Service option manager stub used by xtrem-core unit tests.
	 * It manages the service options and their active state in-memory, with a simple array of active service options.
	 */
	export class ServiceOptionManagerStub extends ServiceOptionManager {
	    isServiceOptionEnabled(_context: Context, serviceOption: ServiceOption): boolean;
	    setServiceOptionActiveState(_context: Context, serviceOption: ServiceOption, isActive: boolean): Promise<void>;
	    getEnabledServiceOptions(): Promise<ServiceOption[]>;
	}
	//# sourceMappingURL=service-option-manager-stub.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/printing-manager.d.ts
declare module '@sage/xtrem-core/lib/application/printing-manager' {
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	export interface PrintingManager {
	    getListPrintingAssignmentWizardUrl(context: Context): Promise<string>;
	    getListPrintingWizardUrl(context: Context): Promise<string>;
	    getRecordPrintingAssignmentUrl(context: Context): Promise<string>;
	    getRecordPrintingWizardUrl(context: Context): Promise<string>;
	}
	//# sourceMappingURL=printing-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/package.d.ts
declare module '@sage/xtrem-core/lib/application/package' {
	/** @packageDocumentation @module runtime */
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Dict, RootMenuItem, SubMenuItem } from '@sage/xtrem-shared';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/decorator-utils';
	import { NotificationTopic } from '@sage/xtrem-core/lib/interop/index';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { ExternalEnumDecorator, ExternalNodeDecorator, ExternalNodeExtensionDecorator, Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { Activity } from '@sage/xtrem-core/lib/ts-api/activity';
	import { ActivityExtension } from '@sage/xtrem-core/lib/ts-api/activity-extension';
	import { DataType, DataTypeOptions, EnumDataType } from '@sage/xtrem-core/lib/types/index';
	import { WorkflowStepInterface } from '@sage/xtrem-core/lib/workflow/workflow-step-descriptor';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/service-option';
	export interface PackageApi {
	    nodes?: Dict<any>;
	    nodeExtensions?: Dict<any>;
	    enums?: Dict<any>;
	    enumExtensions?: Dict<any>;
	    serviceOptions?: Dict<ServiceOption>;
	    menuItems?: Dict<SubMenuItem | RootMenuItem>;
	    activities?: Dict<Activity>;
	    activityExtensions?: Dict<ActivityExtension>;
	    dataTypes?: Dict<DataType<AnyValue, DataTypeOptions>>;
	    notificationTopics?: Dict<NotificationTopic>;
	    workflowSteps?: Dict<WorkflowStepInterface>;
	    startService?: (application: Application) => AsyncResponse<void>;
	}
	export interface PackageCreateOptions {
	    buildDir?: string;
	    api?: PackageApi;
	    isAddOn?: boolean;
	}
	export interface XtremOptions {
	    options?: string[];
	    isHidden?: boolean;
	    isReleased?: boolean;
	    sqlSchemaVersion?: string;
	    /**
	     * Marker for packages that should be inactive by default.
	     * We use a negative marker here as the default is to be active by default and we want to mark the exceptions.
	     */
	    isInactiveByDefault?: boolean;
	    /**
	     * Can the nodes in this package be extended ?
	     */
	    isSealed?: boolean;
	    /** Is the package the main package of an application? */
	    isMain?: boolean;
	    /** The app name. Must be set in the main package */
	    appName?: string;
	    /**
	     * Is the package a platform package (one of the platform/system packages)
	     */
	    isPlatform?: boolean;
	    /**
	     * Is the package a service with its own queue.
	     */
	    isService?: boolean;
	    /**
	     * The package is a service or add-on or has the hasListeners xtrem attribute supplied as true in the package.json
	     */
	    hasListeners?: boolean;
	    /** The default SQS queue name for this package */
	    queue?: string;
	    isFrontEndApp?: boolean;
	}
	/**
	 * @disabled_internal
	 */
	export interface PackageJsonAbout {
	    name: string;
	    version: string;
	    author: string;
	    license: string;
	    description: string;
	    buildStamp?: string;
	    appName?: string;
	}
	/**
	 * @disabled_internal
	 */
	export interface PackageJsonFile extends PackageJsonAbout {
	    dependencies: Dict<string>;
	    peerDependencies: Dict<string>;
	    devDependencies: Dict<string>;
	    /**
	     * Xtrem internal attributes.
	     * Every package that contains nodes must have this attribute, even declared as an empty object {}
	     */
	    xtrem?: XtremOptions;
	    xtremPlugin?: boolean;
	    main: string;
	    isMainUnitTest: boolean;
	}
	export function getPackageName(packageJson: PackageJsonFile): string;
	export function getPackageQueueName(packageJson: PackageJsonFile): string;
	export class Package {
	    readonly application: Application;
	    options: PackageCreateOptions;
	    private buildDir;
	    private _dir;
	    get dir(): string;
	    api: PackageApi;
	    private _packageJson;
	    factories: NodeFactory[];
	    _nodeExtensions: StaticThis<Node>[];
	    constructor(application: Application, options: PackageCreateOptions);
	    get isSealed(): boolean;
	    /**
	     * @disabled_internal
	     * indicate if the package is hidden (technical) or not. Hidden packages cannot be deactivated
	     */
	    get isHidden(): boolean;
	    /**
	     * Indicate if the package should be active by default.
	     */
	    get isActiveByDefault(): boolean;
	    /**
	     * indicate if the package is released.
	     */
	    get isReleased(): boolean;
	    /**
	     * indicate if the package is released.
	     */
	    get sqlSchemaVersion(): string | undefined;
	    /**
	     * indicate if the package is a main package.
	     */
	    get isMain(): boolean;
	    /**
	     * Is the packages a service which handles SQS notifications and/or messages.
	     * Only service packages have SQS queues.
	     */
	    get isService(): boolean;
	    /**
	     * Is the packages from a third party extension
	     */
	    get isAddOn(): boolean;
	    /**
	     * Indicates if the package can have listeners registered
	     */
	    get hasListeners(): boolean;
	    get queue(): string;
	    get dependencies(): Dict<string>;
	    get directDependencies(): Package[];
	    get apiDependencies(): string[];
	    /** Returns a list of all the dependencies of the current package, and their dependencies, etc.
	     * @param app: application object used to retrieve the full package list.
	     */
	    get allDependencies(): Package[];
	    private checkXtremAttribute;
	    get packageJson(): PackageJsonFile;
	    get name(): string;
	    get version(): string;
	    get packageName(): string;
	    static getPackageJson(dir: string): PackageJsonFile;
	    get xtremOptions(): XtremOptions;
	    /** Require the code of the Application and loads the application api attribute. */
	    loadDecorators(): void;
	    /**
	     * Returns the list of nodeExtensions created by the package
	     */
	    get nodeExtensions(): StaticThis<Node>[];
	    get activities(): Dict<Activity>;
	    get activitiesExtensions(): Dict<ActivityExtension>;
	    get serviceOptions(): Dict<ServiceOption>;
	    static decoratorFromFactory(factory: NodeFactory): ExternalNodeDecorator;
	    getNodeDecorators(): ExternalNodeDecorator[];
	    getEnumDescriptors(): ExternalEnumDecorator[];
	    private enumDataTypes;
	    getEnumDataTypes(): EnumDataType[];
	    getExtensionDecorators(): ExternalNodeExtensionDecorator[];
	    getLocalizedTitleKey(): string;
	}
	export abstract class XtremAboutHelper {
	}
	export class PackageValidationContext {
	    warnings: Set<String>;
	}
	//# sourceMappingURL=package.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/package-manager.d.ts
declare module '@sage/xtrem-core/lib/application/package-manager' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { Package } from '@sage/xtrem-core/lib/application/package';
	/**
	 * Base class for service option managers
	 */
	export abstract class PackageManager {
	    readonly application: Application;
	    constructor(application: Application);
	    findPackageByName(name: string): Package;
	    getActivePackageNames(_context: Context): Promise<string[]>;
	    abstract getCurrentVersion(_pack: Package, _context?: Context): Promise<string | undefined>;
	    abstract validatePackageVersions(): Promise<void>;
	    /**
	     * Create the SQL schema (if needed) and all the tables
	     */
	    abstract createSqlSchemaAndTables(): Promise<boolean>;
	    /**
	     * Make sure the schema for the application exists (and create it if needed)
	     */
	    abstract ensureSchemaExists(): Promise<void>;
	    createOrUpgradePackageAllocations(_context: Context, _activePackageNames?: string[]): Promise<void>;
	}
	//# sourceMappingURL=package-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/package-manager-stub.d.ts
declare module '@sage/xtrem-core/lib/application/package-manager-stub' {
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	import { Package } from '@sage/xtrem-core/lib/application/package';
	import { PackageManager } from '@sage/xtrem-core/lib/application/package-manager';
	export class PackageManagerStub extends PackageManager {
	    getCurrentVersion(_pack: Package, _context?: Context): Promise<string>;
	    validatePackageVersions(): Promise<void>;
	    createSqlSchemaAndTables(): Promise<boolean>;
	    ensureSchemaExists(): Promise<void>;
	}
	//# sourceMappingURL=package-manager-stub.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/package-loader.d.ts
declare module '@sage/xtrem-core/lib/application/package-loader' {
	import { Dict } from '@sage/xtrem-shared';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	import { Package, PackageCreateOptions, PackageJsonFile } from '@sage/xtrem-core/lib/application/package';
	export class PackageLoader {
	    private application;
	    readonly packagesByName: Dict<Package>;
	    constructor(application: Application);
	    getPackageFileOfDependency(packageName: string, dir: string): PackageJsonFile | undefined;
	    /**
	     * Returns whether a package contains some nodes and must be taken into account when compunting dependencies
	     * @param packageName
	     * @param dir
	     */
	    isPackageWithNodes(packageName: string, packageJson: PackageJsonFile | undefined): boolean;
	    private static getDependencyBuildDir;
	    /** Checks if there are any name collisions between enums and nodes */
	    private static checkForNameCollisions;
	    private _verifyPackage;
	    createPackage(options: PackageCreateOptions): Package;
	    /**
	     * Scan package dependencies and load application packages
	     * @param dir
	     * @param knownPaths
	     * @param processedPackages
	     * @param packageValidationContext
	     * @param options
	     * @returns
	     */
	    private scanPackage;
	    /**
	     * Create add-on packages of application
	     */
	    private createAddOnPackages;
	    private createFactories;
	}
	//# sourceMappingURL=package-loader.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/notification-manager.d.ts
declare module '@sage/xtrem-core/lib/application/notification-manager' {
	import { InitialNotification, Notification, PromisifyProperties } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	export interface NotificationManager {
	    getUserNotifications(context: Context): Promise<Array<PromisifyProperties<Notification>>>;
	    markRead(context: Context, _id: string): Promise<boolean>;
	    markUnread(context: Context, _id: string): Promise<boolean>;
	    markAllRead(context: Context): Promise<boolean>;
	    delete(context: Context, _id: string): Promise<boolean>;
	    dispatchUserNotification(context: Context, notification?: InitialNotification): Promise<void>;
	}
	export class NotificationManagerStub implements NotificationManager {
	    getUserNotifications: () => Promise<Array<PromisifyProperties<Notification>>>;
	    markRead: () => Promise<boolean>;
	    markUnread: () => Promise<boolean>;
	    markAllRead: () => Promise<boolean>;
	    delete: () => Promise<boolean>;
	    dispatchUserNotification: () => Promise<void>;
	}
	//# sourceMappingURL=notification-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/node-factories-manager.d.ts
declare module '@sage/xtrem-core/lib/application/node-factories-manager' {
	import { Application } from '@sage/xtrem-core/lib/application/application';
	export class NodeFactoriesManager {
	    private application;
	    private _allFactoriesByName;
	    private _allFactoriesByTableName;
	    constructor(application: Application);
	    /** Checks if there are any name collisions between nodes and enums */
	    private checkForNameCollisions;
	    /** Creates a NodeFactory instance out of a node. */
	    private getOrCreateNodeFactory;
	    private createNonSubNodes;
	    private createSubNodes;
	    private static setOperationsDefiningPackage;
	    /** Add the extensions decorators brought by the current application to its dependencies' node factories. */
	    private addExtensionDecorators;
	    private initFactories;
	    private completeFactories;
	    registerListeners(): void;
	}
	//# sourceMappingURL=node-factories-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/index.d.ts
declare module '@sage/xtrem-core/lib/application/index' {
	export * from '@sage/xtrem-core/lib/application/application';
	export * from '@sage/xtrem-core/lib/application/application-create-sql-schema';
	export * from '@sage/xtrem-core/lib/application/application-manager';
	export * from '@sage/xtrem-core/lib/application/attachment-manager';
	export * from '@sage/xtrem-core/lib/application/client-settings-manager';
	export * from '@sage/xtrem-core/lib/application/csv-checksum-manager';
	export * from '@sage/xtrem-core/lib/application/dashboard-manager';
	export * from '@sage/xtrem-core/lib/application/graceful-shutdown';
	export * from '@sage/xtrem-core/lib/application/hot-upgrade-manager';
	export * from '@sage/xtrem-core/lib/application/notification-manager';
	export * from '@sage/xtrem-core/lib/application/package';
	export * from '@sage/xtrem-core/lib/application/printing-manager';
	export * from '@sage/xtrem-core/lib/application/service-option';
	export * from '@sage/xtrem-core/lib/application/unhandled-error-monitor';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/hot-upgrade-manager.d.ts
declare module '@sage/xtrem-core/lib/application/hot-upgrade-manager' {
	import { Application } from '@sage/xtrem-core/lib/application/application';
	/**
	 * Should metrics files be generated for the upgrade ?
	 * local:only on local, s3: local + S3
	 */
	export type UpgradeMetricsType = 'local' | 's3';
	/**
	 * Manager for hot-upgrades
	 */
	export interface HotUpgradeManager {
	    /**
	     * Executes the hot upgrade of an application.
	     * Can only be used on a released application
	     * @metrics should metrics be generated when replaying SQL files ?
	     */
	    executeHotUpgrade(application: Application, metrics?: UpgradeMetricsType): Promise<void>;
	}
	/**
	 * A mock for HoyUpgradeManager: should only be used for unit-tests
	 */
	export class HotUpgradeManagerStub implements HotUpgradeManager {
	    /**
	     * Executes the hot upgrade of an application.
	     * Can only be used on a released application
	     */
	    executeHotUpgrade(_application: Application, _metrics?: UpgradeMetricsType): Promise<void>;
	}
	//# sourceMappingURL=hot-upgrade-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/graceful-shutdown.d.ts
declare module '@sage/xtrem-core/lib/application/graceful-shutdown' {
	/// <reference types="node" />
	import EventEmitter = require('events');
	export const gracefulShutdown: EventEmitter<[never]>;
	//# sourceMappingURL=graceful-shutdown.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/dashboard-manager.d.ts
declare module '@sage/xtrem-core/lib/application/dashboard-manager' {
	import { Dashboard, DashboardItem, Dict } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/index';
	export interface DashboardManager {
	    getSelectedDashboard(context: Context, group?: string): Promise<Dashboard | null>;
	    setSelectedDashboard(context: Context, selectedDashboardId: string, group?: string): Promise<Dashboard>;
	    updateDashboardItemSettings(context: Context, dashboardItemId: string, settings: Object): Promise<void>;
	    updateDashboardLayout(context: Context, dashboardItemId: string, layout: Dashboard): Promise<Dashboard>;
	    addDashboardItem(context: Context, dashboardId: string, item: Partial<DashboardItem>): Promise<void>;
	    getDashboardList(context: Context, group?: string): Promise<Dict<string>>;
	    createDashboard(context: Context, group?: string): Promise<Dashboard>;
	    cloneDashboard(context: Context, dashboardId: string): Promise<Dashboard>;
	    deleteDashboard(context: Context, dashboardItemId: string): Promise<void>;
	    getFactoryDashboardList(context: Context, group?: string): Promise<Dashboard[]>;
	    getWidgetCategory(context: Context, widget: {
	        _id: string;
	        id: string;
	    }): Promise<{
	        key: string;
	        title: string;
	    }>;
	    getWidgetCategories(context: Context): Promise<[{
	        key: string;
	        title: string;
	    }] | []>;
	    canEditDashboards(context: Context): Promise<boolean>;
	}
	export class DashboardManagerStub implements DashboardManager {
	    getWidgetCategory: () => Promise<{
	        key: string;
	        title: string;
	    }>;
	    getWidgetCategories: () => Promise<[{
	        key: string;
	        title: string;
	    }] | []>;
	    getSelectedDashboard: () => Promise<Dashboard | null>;
	    setSelectedDashboard: () => Promise<Dashboard>;
	    updateDashboardItemSettings: () => Promise<void>;
	    updateDashboardLayout: () => Promise<Dashboard>;
	    addDashboardItem: () => Promise<void>;
	    getDashboardList: () => Promise<Dict<string>>;
	    createDashboard: () => Promise<Dashboard>;
	    cloneDashboard: () => Promise<Dashboard>;
	    deleteDashboard: () => Promise<void>;
	    getFactoryDashboardList: () => Promise<Dashboard[]>;
	    canEditDashboards: () => Promise<boolean>;
	}
	//# sourceMappingURL=dashboard-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/csv-checksum-manager.d.ts
declare module '@sage/xtrem-core/lib/application/csv-checksum-manager' {
	import { AsyncResponse } from '@sage/xtrem-shared';
	import { Context } from '@sage/xtrem-core/lib/runtime/context';
	/**
	 * Management of CSV's checksum.
	 * Every time a CSV file is loaded, its checksum is stored (sys_csv_checksum table). This allow
	 * the system to skip the next loading of the same CSV file, if it was not changed.
	 */
	export interface CsvChecksumManager {
	    /**
	     * Return the checksum of the last successfully loaded Csv for a specific factory
	     */
	    getLastAppliedChecksum(context: Context, factoryName: string): AsyncResponse<string | undefined>;
	    /**
	     * Store the checksum of the last successfully loaded Csv for a specific factory
	     */
	    setLastAppliedChecksum(context: Context, factoryName: string, checksum: string): AsyncResponse<void>;
	    /**
	     * Compute the checksum of the content of a CSV file
	     */
	    computeChecksum(csvContent: string): string;
	}
	/**
	 * A mock for TenantManager: should only be used for unit-tests
	 */
	export class CsvChecksumManagerStub implements CsvChecksumManager {
	    /**
	     * Return the checksum of the last successfully loaded Csv for a specific factory
	     */
	    getLastAppliedChecksum(_context: Context, _factoryName: string): string | undefined;
	    /**
	     * Store the checksum of the last successfully loaded Csv for a specific factory
	     */
	    setLastAppliedChecksum(_context: Context, _factoryName: string, _checksum: string): void;
	    /**
	     * Compute the checksum of the content of a CSV file
	     */
	    computeChecksum(_csvContent: string): string;
	}
	//# sourceMappingURL=csv-checksum-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/client-settings-manager.d.ts
declare module '@sage/xtrem-core/lib/application/client-settings-manager' {
	import type { Context } from '@sage/xtrem-core/lib/runtime/context';
	export interface ClientUserSettings {
	    _id: string | number;
	    title: Promise<string>;
	    elementId: Promise<string>;
	    description?: Promise<string>;
	    content?: Promise<string>;
	    isSelected?: Promise<boolean>;
	}
	export interface ClientSettings {
	    title: string;
	    description: string;
	    content: string;
	}
	export interface ClientSettingsManager {
	    getActiveClientSettingsForArtifact(context: Context, artifactId: string): Promise<ClientUserSettings[]>;
	    getVariantsForElement(context: Context, artifactId: string, elementId: string): Promise<ClientUserSettings[]>;
	    createClientSetting(context: Context, artifactId: string, elementId: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
	    updateClientSetting(context: Context, _id: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
	    selectClientSetting(context: Context, artifactId: string, elementId: string, _id: string): Promise<ClientUserSettings>;
	    resetClientSettings(context: Context): Promise<boolean>;
	}
	export class ClientSettingsManagerStub implements ClientSettingsManager {
	    resetClientSettings(): Promise<boolean>;
	    createClientSetting(): Promise<ClientUserSettings>;
	    getActiveClientSettingsForArtifact(): Promise<ClientUserSettings[]>;
	    getVariantsForElement(): Promise<ClientUserSettings[]>;
	    updateClientSetting(): Promise<ClientUserSettings>;
	    selectClientSetting(): Promise<ClientUserSettings>;
	}
	//# sourceMappingURL=client-settings-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/attachment-manager.d.ts
declare module '@sage/xtrem-core/lib/application/attachment-manager' {
	import { Datetime, Reference, StaticThis } from '@sage/xtrem-core/lib/index';
	import { Node } from '@sage/xtrem-core/index';
	type AttachmentStatus = 'created' | 'uploaded' | 'uploadFailed' | 'verified' | 'rejected';
	export interface AttachmentData {
	    _id: string | number;
	    filename: string;
	    mimeType: string;
	    lastModified: Datetime | null;
	    contentLength: number;
	    status: AttachmentStatus;
	}
	export interface AttachmentAssociationData {
	    _id?: string | number;
	    sourceNodeName: string;
	    sourceNodeId: string;
	    attachment: AttachmentData;
	    isProtected: boolean;
	    title: string;
	    description: string;
	}
	export interface InternalAttachmentAssociationData {
	    _id?: string | number;
	    sourceNodeName: Promise<string>;
	    sourceNodeId: Promise<string | number>;
	    attachment: Reference<Node>;
	    isProtected: Promise<boolean>;
	    title: Promise<string>;
	    description: Promise<string>;
	}
	/**
	 * Management of attachment.
	 */
	export interface AttachmentManager<NodeT extends Node = Node> {
	    getAttachmentNode(): StaticThis<NodeT>;
	}
	export {};
	//# sourceMappingURL=attachment-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/application.d.ts
declare module '@sage/xtrem-core/lib/application/application' {
	/// <reference types="node" />
	/// <reference types="node" />
	/** @packageDocumentation @module runtime */
	import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
	import { Dict, integer } from '@sage/xtrem-shared';
	import { GraphQLSchema } from 'graphql';
	import * as http from 'http';
	import { StaticThis } from '@sage/xtrem-core/lib/decorators/index';
	import { NotificationTopic } from '@sage/xtrem-core/lib/interop/index';
	import { Context, ContextOptions, CreateAdminUserOptions, UserData } from '@sage/xtrem-core/lib/runtime/context';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Node } from '@sage/xtrem-core/lib/ts-api/index';
	import { Activity } from '@sage/xtrem-core/lib/ts-api/activity';
	import { DataType, DataTypeOptions } from '@sage/xtrem-core/lib/types/index';
	import { WorkflowManagerInterface } from '@sage/xtrem-core/lib/workflow/workflow-manager-interface';
	import { ActivityManager } from '@sage/xtrem-core/lib/application/activity-manager';
	import { ClientSettingsManager } from '@sage/xtrem-core/lib/application/client-settings-manager';
	import { CsvChecksumManager } from '@sage/xtrem-core/lib/application/csv-checksum-manager';
	import { HotUpgradeManager } from '@sage/xtrem-core/lib/application/hot-upgrade-manager';
	import { NodeFactoriesManager } from '@sage/xtrem-core/lib/application/node-factories-manager';
	import { NotificationManager } from '@sage/xtrem-core/lib/application/notification-manager';
	import { Package, PackageCreateOptions, PackageJsonAbout, PackageJsonFile } from '@sage/xtrem-core/lib/application/package';
	import { PackageManager } from '@sage/xtrem-core/lib/application/package-manager';
	import { ServiceOption } from '@sage/xtrem-core/lib/application/service-option';
	import { ServiceOptionManager } from '@sage/xtrem-core/lib/application/service-option-manager';
	import './unhandled-error-monitor';
	import EventEmitter = require('events');
	export interface Dependency {
	    name: string;
	    version: string;
	}
	/**
	 * Type of application:
	 *                          +---------+-------+------+----------+-----+
	 *                          | service | batch | test | dev-tool | job |
	 * +------------------------+---------+-------+------+----------+-----+
	 * | graphQL API            |    X    |   -   |   X  |    -     |  -  |
	 * +------------------------+---------+-------+------+----------+-----+
	 * | system broadcasts      |    X    |   X   |   X  |    -     |  X  |
	 * +------------------------+---------+-------+------+----------+-----+
	 * | applicative queues     |  in dev |   X   |   X  |    -     |  -  |
	 * +------------------------+---------+-------+------+----------+-----+
	 */
	export type ApplicationType = 
	/**
	 * example: pnpm run start
	 */
	'service'
	/**
	 * example: xtrem test, ....
	 */
	 | 'test'
	/**
	 * example: xtrem compile, ....
	 */
	 | 'dev-tool'
	/**
	 * example: xtrem manage, schema, tenant, ....
	 */
	 | 'admin-tool'
	/**
	 * example: upgrade operations, ...
	 */
	 | 'job';
	export interface ApplicationCreateOptions extends PackageCreateOptions {
	    applicationType?: ApplicationType;
	    schemaName?: string;
	    testApplicationDir?: string;
	    startOptions?: ApplicationStartServicesOptions;
	}
	export interface ApplicationConstructorOptions extends ApplicationCreateOptions {
	    schemaName: string;
	}
	export const allowedStartChannels: readonly ["graphql", "listeners", "routing"];
	export type StartChannel = (typeof allowedStartChannels)[number];
	export interface ApplicationStartServicesOptions {
	    services: string[];
	    channels: StartChannel[];
	    webSockets?: string[];
	    /**
	     * Names of queues to explicitly start
	     * If not set, all the queues will be started
	     */
	    queues?: string[];
	}
	type WithContextFunction = <T extends AnyValue | void>(tenantId: string | null, body: (context: Context) => AsyncResponse<T>, options?: ContextOptions) => Promise<T>;
	export interface WithContext {
	    withCommittedContext: WithContextFunction;
	    withUncommittedContext: WithContextFunction;
	    withReadonlyContext: WithContextFunction;
	}
	export class Application {
	    readonly options: ApplicationConstructorOptions;
	    readonly mainPackage: Package;
	    private _rootAbout;
	    private _about;
	    private readonly packageLoader;
	    readonly factoriesManager: NodeFactoriesManager;
	    readonly activityManager: ActivityManager;
	    readonly serviceOptionManager: ServiceOptionManager;
	    readonly packageManager: PackageManager;
	    readonly notificationManager: NotificationManager;
	    readonly clientSettingsManager: ClientSettingsManager;
	    readonly workflowManager: WorkflowManagerInterface;
	    /** TODO: make private again */
	    _sqlPackageFactories: NodeFactory[];
	    private _pluginDependencies;
	    static readonly emitter: EventEmitter<[never]>;
	    readonly nodeAndEnumNames: Dict<'node' | 'enum'>;
	    readonly dataTypes: Dict<DataType<AnyValue, DataTypeOptions>>;
	    readonly notificationTopics: Dict<NotificationTopic>;
	    private graphqlSchemaFunnel;
	    private graphqlSchemas;
	    readonly requestFunnel: import("@sage/xtrem-async-helper").Funnel;
	    private static hasInstance;
	    /** The external http server, set when the application is started with 'graphql' inside `startOptions.channels` */
	    graphqlHttpServer?: http.Server;
	    /**
	     * Returns the test nodes API if the application is run from a test/fixtures directory
	     * that contains a test-application.ts file.
	     * Returns an empty object otherwise.
	     */
	    private tryLoadTestApi;
	    registerDataType(pack: Package, name: string, dataType: DataType<AnyValue, DataTypeOptions>): void;
	    private registerDefaultReferenceDataType;
	    registerNotificationTopic(pack: Package, name: string, topic: NotificationTopic): void;
	    findNotificationTopic(name: string): NotificationTopic;
	    registerMiscArtifacts(): void;
	    /**
	     * Returns the manager in charge of hot-upgrades
	     */
	    get hotUpgradeManager(): HotUpgradeManager;
	    get isReady(): boolean;
	    setReady(): void;
	    /**
	     * The manager in charge of the checksums of loaded CSV files
	     */
	    get csvChecksumManager(): CsvChecksumManager;
	    get applicationType(): ApplicationType | undefined;
	    /**
	     * Get the add-on package paths
	     */
	    get addOnPackagePaths(): string[];
	    get schemaName(): string;
	    get activities(): Dict<Activity>;
	    get serviceOptionsByName(): Dict<ServiceOption>;
	    findServiceOption(name: string): ServiceOption;
	    /**
	     * List of packages started in the current container.
	     */
	    private _servicePackagesStarted?;
	    private _startOptions;
	    get startOptions(): ApplicationStartServicesOptions;
	    get servicePackagesStarted(): Package[];
	    /**
	     * emit events to start listeners
	     * @param otherTopics  topics to emit other than the standard `listen` and `ready`, used for unit tests.
	     */
	    startListeners(otherTopics?: string[]): void;
	    /**
	     * Limits the length of an SQS queue name to 75 characters, 80 with the .fifo extension.
	     * If the name is already 75 characters or less, it is returned as is.
	     * If the name is longer than 75 characters, it is truncated and appended with "---" in the middle.
	     * @param name - The original queue name.
	     * @returns The modified queue name.
	     */
	    static limitSqsQueueName(name: string): string;
	    /**
	     * Generates the raw SQS queue name based on the provided name.
	     *
	     * For unit tests, the queue name will be the package name with the routing queue name appended.
	     * In multi-app mode, the queue name is prefixed with the app name if it is not already prefixed.
	     *
	     * @param name - The name used to generate the queue name.
	     * @returns The generated raw SQS queue name.
	     */
	    private rawSqsQueueName;
	    /**
	     * Returns the SQS queue name for the given name.
	     * @param name - The name of the queue.
	     * @returns The SQS queue name.
	     */
	    sqsQueueName(name: string): string;
	    getPluginDependencies(): Dict<string>;
	    /** @disabled_internal */
	    /**
	     * Returns the factories that have their own table in the database.
	     * The returned factories are sorted so that referenced factories
	     * are always before the factories that reference them with non nullable references.
	     */
	    getSqlPackageFactories(): NodeFactory[];
	    get name(): string;
	    /**
	     * Returns the short name of an application without the sage prefix
	     * for instance, will return 'xtrem-services-main' for the @sage/xtrem-services-main application
	     */
	    get shortName(): string;
	    get packageName(): string;
	    get dir(): string;
	    get tmpDir(): string;
	    get version(): string;
	    get about(): PackageJsonAbout;
	    get rootAbout(): PackageJsonAbout;
	    checkIfPluginPackage(depPackageContent: PackageJsonFile | null): void;
	    /**
	     * Validate all Activities loaded from packages
	     */
	    validateActivities(): void;
	    getPackages(): Package[];
	    get packagesByName(): Dict<Package>;
	    findPackage(name: string): Package;
	    /**
	     * Gets all platform packages required by the application packages
	     */
	    getPlatformPackages(): Dependency[];
	    getAllFactories(): NodeFactory[];
	    /** @disabled_internal */
	    getFactoryByName(name: string): NodeFactory;
	    /** @disabled_internal */
	    tryToGetFactoryByName(name: string): NodeFactory | undefined;
	    /** @disabled_internal */
	    getFactoryByConstructor(nodeConstructor: StaticThis<Node>): NodeFactory;
	    getFactoryByTableName(name: string): NodeFactory;
	    tryGetFactoryByTableName(name: string): NodeFactory | undefined;
	    findFactoriesUsingDatatype(dataType: DataType<AnyValue, unknown>): NodeFactory[];
	    /**
	     * Checks if a record is used in another node references
	     * @param id _id of the record to be checked in other references
	     * @param context current context
	     * @param className className of the node of _id
	     * @returns Promise
	     */
	    isRecordUsed(id: number, context: Context, className: string): Promise<boolean>;
	    getAllNodes(): (typeof Node)[];
	    isNodePublished(node: {
	        new (): Node;
	    }): boolean;
	    /** @disabled_internal */
	    getAllSortedFactories(): NodeFactory[];
	    /**
	     * Create the database schema, used in the cli as well platform tests
	     */
	    static dropDbSchema(schemaName: string): Promise<void>;
	    /**
	     * Rename a schema
	     */
	    static renameSchema(oldName: string, newName: string): Promise<void>;
	    /**
	     * Create the database schema, used in the cli as well platform tests
	     */
	    static createDbSchema(schemaName: string): Promise<void>;
	    createAdminUser(tenantId: string, data: UserData, options?: CreateAdminUserOptions): Promise<void>;
	    getGraphQLSchema(context?: Context): Promise<GraphQLSchema>;
	    getPackageOfNodeConstructor(node: {
	        new (): Node;
	    }): Package;
	    /**
	     * Create a context bound to a specific tenant. This context will be committed
	
	    * @param tenantId when set to null, the context can only be used to access to sharedTables or run custom SQL commands
	     */
	    withCommittedContext<T extends AnyValue | void>(tenantId: string | null, body: (context: Context) => AsyncResponse<T>, options?: ContextOptions): Promise<T>;
	    /**
	     * Create a context bound to a specific tenant. This context will not be committed
	     *
	     * @param tenantId when set to null, the context can only be used to access to sharedTables or run custom SQL commands
	     */
	    withUncommittedContext<T extends AnyValue | void>(tenantId: string | null, body: (context: Context) => AsyncResponse<T>, options?: ContextOptions): Promise<T>;
	    /**
	     * Create a context bound to a specific tenant. This context will be in read-only mode
	     * @param tenantId when set to null, the context can only be used to access to sharedTables or run custom SQL commands
	     */
	    withReadonlyContext<T extends AnyValue | void>(tenantId: string | null, body: (context: Context) => AsyncResponse<T>, options?: ContextOptions): Promise<T>;
	    /**
	     * Gets a root frame for calling with*Context functions
	     */
	    get asRoot(): WithContext;
	    /**
	     * Create a context to perform DDL operations
	     */
	    createContextForDdl<T extends AnyValue | void>(body: (context: Context) => AsyncResponse<T>, options?: ContextOptions): Promise<T>;
	    private initFactoryCacheLogs;
	    clearGlobalCache(): void;
	    invalidateGlobalCache(context: Context): Promise<void>;
	    /** Used by xtrem-cop to verify that getValue / computeValue are correctly set` */
	    verifySqlConversions(): Promise<integer>;
	}
	export function main(body: () => AsyncResponse<void>): void;
	export {};
	//# sourceMappingURL=application.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/application-manager.d.ts
declare module '@sage/xtrem-core/lib/application/application-manager' {
	import { Application, ApplicationStartServicesOptions, ApplicationType } from '@sage/xtrem-core/lib/application/application';
	export abstract class ApplicationManager {
	    private static applicationCache;
	    static getBuildDir(dir: string): string;
	    /**
	     * Returns the default schema name that will be used for applications
	     * Note: this schema name can be overriden by using the XTREM_SCHEMA_NAME environment variable
	     */
	    static getDefaultServiceSchemaName(): string;
	    private static getSchemaName;
	    /**
	     */
	    static getApplication(dir: string, options?: {
	        applicationType?: ApplicationType;
	        startOptions?: ApplicationStartServicesOptions;
	    }): Promise<Application>;
	}
	//# sourceMappingURL=application-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/application-create-sql-schema.d.ts
declare module '@sage/xtrem-core/lib/application/application-create-sql-schema' {
	import { Context, NodeFactory } from '@sage/xtrem-core/lib/runtime/index';
	import { ForeignKey } from '@sage/xtrem-core/lib/sql/schema/index';
	export abstract class ApplicationCreateSqlSchema {
	    static createTables(context: Context, factoriesToAddForeignKeys: NodeFactory[]): Promise<void>;
	    static addForeignKeys(context: Context, sortedFactoryList: NodeFactory[]): Promise<Map<NodeFactory, ForeignKey[]>>;
	}
	//# sourceMappingURL=application-create-sql-schema.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-core/build/lib/application/activity-manager.d.ts
declare module '@sage/xtrem-core/lib/application/activity-manager' {
	import { Dict } from '@sage/xtrem-shared';
	import { NodeFactory } from '@sage/xtrem-core/lib/runtime/node-factory';
	import { Activity } from '@sage/xtrem-core/lib/ts-api/activity';
	import { Application } from '@sage/xtrem-core/lib/application/application';
	export class ActivityManager {
	    private application;
	    private _activities;
	    constructor(application: Application);
	    /**
	     * Get the activities for the application
	     */
	    getActivities(): Dict<Activity>;
	    isNodeAccessControlled(nodeName: string): boolean;
	    /**
	     * Check the if the permission is allowed for the factory passed
	     */
	    static checkOperation(operation: string, factory: NodeFactory, options?: {
	        throws?: boolean;
	    }): boolean;
	    /**
	     * Fill each activity with all its derived and inherited grants
	     */
	    private fillGrants;
	    /**
	     * Flatten the activity permissions to a structure like
	     * SalesOrder { read: [{read:{ SaleOrderLine }, lookup:{ SaleOrderLine }}]}
	     */
	    private flattenPermissions;
	    /** Resolve activity permissions into a fully resolved flattened permission  list */
	    resolvePermissions(): void;
	}
	//# sourceMappingURL=activity-manager.d.ts.map
}
declare module '@sage/xtrem-core' {
	export * from '@sage/xtrem-core/index';
}
