/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RecordPaging=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),runtime_1=require("../runtime"),system_properties_1=require("../runtime/system-properties"),ts_api_1=require("../ts-api"),types_1=require("../types");class RecordPaging{static composeComparators(e,r){return async(t,a)=>{const n=await e(t,a);if(0!==n)return n;return r(t,a)}}static async compileOrderBy(e,r,t,a){let out=()=>0;return await(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).forEach(async(n,i)=>{const o=t[n];let s;const p=r.findProperty(n,{includeSystemProperties:true});if(-1===o||1===o)s=async(r,t)=>{if(r===t)return 0;if(null==r)return null==t?0:-o;if(null==t)return o;const n=await a(e,p,r),i=await a(e,p,t);return(0,runtime_1.valueComparator)(n,i,e.locales)*o};else{if(!p.isForeignNodeProperty())throw new Error(`Invalid orderBy property: ${n}`);const r=await RecordPaging.compileOrderBy(e,p.targetFactory,o,a);s=(e,t)=>r(e[n],t[n])}if(0===i)out=s;else out=RecordPaging.composeComparators(out,s)}),out}static converter(e){const pfalse=()=>false,ptrue=()=>true,valueToArray=e=>{if(Array.isArray(e))return e;return[e]},reTest=e=>r=>"string"==typeof r&&e.test(r),not=e=>r=>!e(r),or=e=>{if(0===e.length)return pfalse;if(1===e.length)return e[0];return r=>e.some(e=>e(r))},and=e=>{if(0===e.length)return ptrue;if(1===e.length)return e[0];return r=>e.every(e=>e(r))},compose=(e,r)=>t=>e(r(t)),deref=e=>r=>{if(null==r)return;const t=r[e];return"function"==typeof t?t():t},r={_eq:r=>t=>0===(0,runtime_1.valueComparator)(t,r,e),_ne:r=>t=>0!==(0,runtime_1.valueComparator)(t,r,e),_gt:r=>t=>(0,runtime_1.valueComparator)(t,r,e)>0,_gte:r=>t=>(0,runtime_1.valueComparator)(t,r,e)>=0,_lt:r=>t=>(0,runtime_1.valueComparator)(t,r,e)<0,_lte:r=>t=>(0,runtime_1.valueComparator)(t,r,e)<=0,_in:r=>t=>valueToArray(r).some(r=>0===(0,runtime_1.valueComparator)(r,t,e)),_nin:r=>t=>valueToArray(r).every(r=>0!==(0,runtime_1.valueComparator)(r,t,e)),_and:e=>and(valueToArray(e).map(cvt)),_or:e=>or(valueToArray(e).map(cvt)),_nor:e=>not(or(valueToArray(e).map(cvt))),_not:e=>not(cvt(e)),_exists:e=>r=>("string"==typeof e||"number"==typeof e)&&null!=r&&"object"==typeof r&&e in r,_type:e=>r=>typeof r===e,_mod:e=>r=>Array.isArray(e)&&"number"==typeof e[0]&&"number"==typeof r&&r%e[0]===e[1],_regex:(e,r)=>{if("string"!=typeof e)throw new xtrem_shared_1.LogicError("invalid regex type:"+typeof e);const t=new RegExp(e,r._options||"");return e=>"string"==typeof e&&t.test(e)}},walk=e=>{const r=e.indexOf(".");if(r>=0)return compose(walk(e.substring(r+1)),walk(e.substring(0,r)));return deref(e)},isQuantifiedBy=(e,r)=>r in e,quantifiedFilter=(e,r,t)=>{const a=cvt((0,lodash_1.omit)(e,r));return r=>{let n=0;if(Array.isArray(r))n=r.filter(a).length;return t(n,e)}},isFilterObject=e=>null!=e&&"object"==typeof e,cvt=e=>{if(e instanceof RegExp)return reTest(e);if(isFilterObject(e)&&isQuantifiedBy(e,"_atLeast"))return quantifiedFilter(e,"_atLeast",(e,r)=>e>=r._atLeast);if(isFilterObject(e)&&isQuantifiedBy(e,"_atMost"))return quantifiedFilter(e,"_atMost",(e,r)=>e<=r._atMost);if(isFilterObject(e)&&isQuantifiedBy(e,"_none"))return quantifiedFilter(e,"_none",(e,r)=>r._none?0===e:0!==e);if(isFilterObject(e)&&isQuantifiedBy(e,"_every"))return cvt({_not:{...(0,lodash_1.omit)(e,"_every")},_none:e&&e._every});if(e&&(0,runtime_1.isCompound)(e))return and(Object.keys(e).map(t=>{const a=e[t];if("_options"===t)return ptrue;if("_"===t[0]&&"_id"!==t&&"_sortValue"!==t){if(!r[t])throw new xtrem_shared_1.LogicError(`bad operator: ${t}`);return r[t](a,e)}return compose(cvt(a),walk(t))}));return r._eq(e)};return cvt}static fillData(e,r,t,a,n){const fill=async(a,n,i)=>{let o={...n};if(i&&"object"==typeof i)await(0,xtrem_async_helper_1.asyncArray)(Object.keys(i)).forEach(async s=>{const p=a.properties.find(e=>e.name===s),l=i[s];if(l){let a=o[s];if(p){if(p.isForeignNodeProperty()&&a&&"object"==typeof l){const{targetFactory:r}=p;if(a=await t(e,p,n),Array.isArray(a))o[s]=await(0,xtrem_async_helper_1.asyncArray)(a).map(e=>fill(r,e,l)).toArray();else if("object"==typeof a)o[s]=await fill(r,a,l)}}else if(Array.isArray(l))await(0,xtrem_async_helper_1.asyncArray)(l).forEach(async e=>{o=await fill(r,o,e)});else if("object"==typeof l)o=await fill(r,o,l)}});return o};return(0,xtrem_async_helper_1.asyncArray)(a).map(e=>fill(r,e,n)).toArray()}static async applyFilter(e,r,t,a,n,i){const o=RecordPaging.parseFilter(e,r,n),s=RecordPaging.converter(i)(o),p=(await this.fillData(e,r,t,a,o)).filter(e=>s(e)).map(e=>e._id);return a.filter(e=>p.includes(e._id))}static async applyOrderBy(e,r,t,a,n){const i=t.map((e,r)=>({...e,$$index:r})),o=await this.fillData(e,r,n,i,a);return(await(0,xtrem_async_helper_1.asyncArray)(o).sort(async(t,i)=>(await RecordPaging.compileOrderBy(e,r,a,n))(t,i)).toArray()).map(e=>t[e.$$index])}static applyPagingOperation(e,r,t,a,n,i,o){const s=n.map((e,r)=>{const t=[];for(let e=0;e<r;e+=1)t.push({[n[e].path.join(".")]:{_eq:i[e].value}});let a;if(e.direction>0)a="before"===o?"_lt":"_gt";else a="before"===o?"_gt":"_lt";return t.push({[n[r].path.join(".")]:{[a]:i[r].value}}),1===t.length?t[0]:{_and:t}}),p=1===s.length?s[0]:{_or:s};return RecordPaging.applyFilter(e,r,t,a,p)}static convertFilter(e,r,t,a=[],n){if(!t)return t;if(Array.isArray(t)){if(0===t.length)return[];const i=t.map((t,i)=>RecordPaging.convertFilter(e,r,t,[...a,String(i)],n)).filter(e=>void 0!==e);return 0===i.length?void 0:i}if(n?.isForeignNodeProperty()){if("string"==typeof t||"number"==typeof t)return{_id:t};if(t instanceof ts_api_1.Node)return{_id:t._id}}if(n?.isDateProperty()&&"string"==typeof t)return xtrem_date_time_1.DateValue.parse(t);if((0,runtime_1.isCompound)(t))return Object.keys(t).reduce((i,o)=>{const s=t[o];if("_"===o[0]){const t=r.properties.find(e=>e.name===o&&e.isSystemProperty)||system_properties_1.SystemProperties.getSystemProperties(r).find(e=>e.name===o);return i[o]=RecordPaging.convertFilter(e,r,s,[...a,o],t||n),i}const p=r.findProperty(o);if(p.isReferenceProperty()&&s&&(0,runtime_1.isCompound)(s)||p.isCollectionProperty()||p.isReferenceArrayProperty()){const{targetFactory:r}=p;return i[o]=RecordPaging.convertFilter(e,r,s,[...a,o],p),i}return i[o]=RecordPaging.convertFilter(e,r,s,[...a,o],p),i},{});return t}static parseFilter(e,r,t){if(!t)return t;return RecordPaging.convertFilter(e,r,t)}static async applyPagingOptions(e,r,t,a,n){let i=t,o=i.length;if(!n)return Promise.resolve({items:i,totalCount:o});if(n.last){if(n.first)throw new Error("first cannot be supplied with last.");if(n.after)throw new Error("after cannot be supplied with last.")}else if(n.before)throw new Error("before cannot be supplied without last.");if(n.filter)i=await RecordPaging.applyFilter(r,e,a,i,n.filter,r.locales),o=i.length;let s=[];if("external"!==e.storage)s=e.parseOrderBy(r,n.orderBy);else s=e.externalStorageManager?e.externalStorageManager.parseOrderBy(r,n.orderBy).map(r=>{const t=e.findProperty(r.property.name);return{...r,property:t}}):[];if(0!==s.length&&n.orderBy)i=await RecordPaging.applyOrderBy(r,e,i,n.orderBy,a);const getCursorValue=r=>{if("external"===e.storage){if(!e.externalStorageManager)throw new Error(`${e.name}: External storage manager is not defined`);return e.externalStorageManager.parseCursor(s,r).map(r=>({property:e.findProperty(r.property.name),value:r.value}))}return(0,types_1.parseCursor)(s.map(e=>e.property),r)};if(null!=n.after)i=await RecordPaging.applyPagingOperation(r,e,a,i,s,getCursorValue(n.after),"after");if(null!=n.before)i=await RecordPaging.applyPagingOperation(r,e,a,i,s,getCursorValue(n.before),"before");if(null!=n.first&&0!==n.first)i=i.slice(0,n.first);if(null!=n.last&&0!==n.last)i=i.slice(-n.last);return{items:i,totalCount:o}}}exports.RecordPaging=RecordPaging;
//# sourceMappingURL=record-paging.js.map