/**
 * Default list of characters to preserve from the original string when randomizing the string
 */
export declare const defaultPreserveList = "'\\ \"@!#$%^&*()-=_+,.?<>/|:;{}[]\u00AB\u00BB\u00BA\u00AA~\u20AC\u00A8\u00A3\u00A7";
/**
 * Randomize a string to have a similar structure as the original by replacing each character with a random
 * character of the same type (uppercase, lowercase or digit) and preserving a specific list of characters.
 * Other characters from the original, like non ASCII Unicode characters are not supported at this stage and
 * will be replaced with random lowercase letters.
 *
 * Because we translate the byte value to a number using the modulus of the required range, the random characters
 * will have a slight bias, so do not use this for any security related functions.
 *
 * Please see here for more information:
 * https://codeql.github.com/codeql-query-help/javascript/js-biased-cryptographic-random/
 *
 * @param original String to use as a structure template
 * @returns Randomized string
 */
export declare function unsafeRandomizeCharacters(original: string, preserveList?: string): string;
/**
 * Randomize a URL
 *
 * @returns URL that satisfies the URL regex
 */
export declare function randomizeUrl(original: string): string;
/**
 * Performs a loose comparison of strings.
 * Characters are considered equal when they belong to the same class (digit, lowercase letter, uppercase letter, etc.)
 */
export declare function compareAnonymizedStrings(strOriginalIn: string, strCompare: string, preserveList?: string): boolean;
//# sourceMappingURL=anonymize.d.ts.map