/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TextStream=void 0;const xss_1=require("../security/xss"),mime_type_helper_1=require("./mime-type-helper"),stream_1=require("./stream");class TextStream extends stream_1.Stream{#e;#t=false;constructor(e,t){if(super(),this.value=e,t&&!mime_type_helper_1.MimeTypeHelper.isValidMimeType(t))throw new Error(`Invalid content type: ${t}`);this.#e=t}static fromString(e,t){return new TextStream(e,t)}static fromSanitizedString(e,t){const r=new TextStream(e,t);return r.#t=true,r}static fromJsonObject(e){return new TextStream(JSON.stringify(e),"application/json")}static isTextStream(e){return e instanceof TextStream}static{this.empty=new TextStream("")}async verifyContentType(){if(!this.#e||!this.#t)this.#t=true,this.#e=await mime_type_helper_1.MimeTypeHelper.guessFromString(this.value,this.#e)}get contentType(){return(async()=>(await this.verifyContentType(),this.#e))()}async sanitized(){if(mime_type_helper_1.MimeTypeHelper.matchPatterns(await this.contentType,"*/html")){const e=this.value?.replace(/style="([^"]+)"/g,(e,t)=>`style="${t.trim()}"`),t=await(0,xss_1.htmlSanitizer)(e,{throwIfModified:true});return TextStream.fromSanitizedString(t,await this.contentType)}return this}toString(){return this.value}compareTo(e){if(null==e)return 1;if(!(e instanceof TextStream))throw new Error(`invalid arg passed to TextStream compare: ${e}`);if(this.value===e.value)return 0;if(this.value<e.value)return-1;if(this.value>e.value)return 1;return 0}}exports.TextStream=TextStream;
//# sourceMappingURL=text-stream.js.map