/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MimeTypeHelper=void 0;const xtrem_file_type_1=require("@sage/xtrem-file-type"),matcher=require("matcher"),mimeTypes=require("mime-types"),sass=require("sass"),xmlTagRegex=/<\/?[a-z][^><]*?>/,xmlDtdRegex=/<!(doctype|entity|element) /i,htmlHeaderRegex=/^(?:<!--[^><]*?-->[\s\n\r]*)*<(!DOCTYPE html|html|head|body)\b/i,cssRegex=/[^{;}\s][^{;}]*(\{[^{}]*\})?/g;class MimeTypeHelper{static async getMimeType(e){const t=await xtrem_file_type_1.FileType.fileTypeFromBuffer(e);return t?.mime}static isValidMimeType(e){return"application/graphql"===e||false!==mimeTypes.extension(e)}static async guessFromString(e,t){if(!e)return"text/plain";try{return JSON.parse(e),"application/json"}catch(e){}const r=await MimeTypeHelper.getMimeType(Buffer.from(e));if(!r||"text/plain"===r){if(htmlHeaderRegex.test(e))return"text/html";if(xmlDtdRegex.test(e))return"application/xml";if(xmlTagRegex.test(e)){if(t&&["text/xml","application/xml"].includes(t))return"application/xml";if("text/csv"===t)return"text/csv";if((!t||"text/css"===t)&&cssRegex.test(e))try{return sass.compileString(e),"text/css"}catch(e){}return"text/html"}}return r||"text/plain"}static async guessFromBuffer(e){const t=await MimeTypeHelper.getMimeType(e);if(t)return t;try{const t=e.toString("utf8");if(/^<svg( |>)/.test(t.trim()))return"image/svg+xml"}catch(e){}return"application/octet-stream"}static isValid(e,t){if(!t)return true;return t.some(t=>!!e.match(t))}static matchPatterns(e,t){return matcher(e,t).length>0}}exports.MimeTypeHelper=MimeTypeHelper;
//# sourceMappingURL=mime-type-helper.js.map