/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.EnumDataType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),_=require("lodash"),fsp=require("path"),data_type_1=require("./data-type");function upperFirst(e){return e[0].toUpperCase()+e.substring(1)}class EnumDataType extends data_type_1.DataType{constructor(e){super("enum",e),this.options=e,this._values={},this._extendedMemberInfo={},this._values=_.pickBy(this.enum,_.isNumber)}get enum(){return this.options.enum}get filename(){return this.options.filename}get instanceValues(){return this._values}get enumValues(){if(!this.rootDataType)return this._values;return this.rootDataType._values}async controlValue(e,t,a){if(Array.isArray(a))return void await(0,xtrem_async_helper_1.asyncArray)(a).forEach(async a=>{await this.controlValue(e,t,a)});if(await super.controlValue(e,t,a),null!=a&&null==this.enumValues[a])t.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`${a} is not in the accepted domain of values for enum ${this.enumFullName()}.`)}numberValue(e){return this.enumValues[e]??-1}stringValue(e){const t=_.invert(this.enumValues)[e];if(!t)throw new Error(`${this.enumName()}: Invalid key value, ${e}`);return t}validateMemberValue(e){if(e&&null==this.enumValues[e])throw new Error(`${this.enumName()}: Invalid member value, ${e}`)}getLocalizedValue(e,t){this.validateMemberValue(t);const a=this.rootDataType?._extendedMemberInfo?.[t]?.enumFullName??this.enumFullName();return e.localizeEnumMember(a,t)}getLocalizedValues(e){return this.values.map(t=>this.getLocalizedValue(e,String(t)))}enumName(){const e=upperFirst(_.camelCase(fsp.basename(this.filename).replace(/\.(js|ts|jsbz?)$/,"")));return/[A-Z]/.test(e[0])?e:`E${e}`}get packageName(){if(this._packageName)return this._packageName;const e=(e=>{const t="package.json";let a=e;for(;;){const e=fsp.join(a,t);if(fs.existsSync(e))return JSON.parse(fs.readFileSync(e,"utf8")).name;if(e===t)return"";const r=fsp.join(a,"..");if(r===a)return"";a=r}})(fsp.parse(this.filename).dir);if(!e)throw new Error(`${this.filename}: scoped package not found`);return this._packageName=e,this._packageName}enumFullName(){return`${this.packageName}/${this.enumName()}`}get values(){return Object.keys(this.enumValues)}compareValues(e,t){if(null==e)return null==t?0:-1;if(e===t)return 0;return("string"==typeof e?this.numberValue(e):e)<("string"==typeof t?this.numberValue(t):t||-1)?-1:1}getEnumType(){return{values:this.values.reduce((e,t)=>{const a=String(t);return e[a]=this.numberValue(a),e},{}),name:`${_.snakeCase(this.enumName())}_enum`}}get baseDataType(){return this.options.extends}get rootDataType(){return this.baseDataType?.rootDataType??this.baseDataType}mergeExtension(){if(!this.rootDataType)return;this.rootDataType._values=_.merge(this.rootDataType._values,this._values),Object.keys(this.instanceValues).forEach(e=>{if(this.rootDataType)this.rootDataType._extendedMemberInfo[e]={enumFullName:this.enumFullName()}})}getLocalizedTitleKey(){if(!this.name&&!process.cwd().includes("xtrem-core"))throw new Error("Data type name is missing");if(!this.pack&&!process.cwd().includes("xtrem-core"))throw new Error("Data type package name is missing");return`${this.pack}/data_types__${_.snakeCase((this.name||"").replace(/[d,D]ata[t,T]ype/,"")).replace(/[.-]/g,"_")}_enum__name`}getMetaData(e){const t=super.getMetaData(e),a=this.enumName();return{...t,type:"enum",isDefault:false,values:this.values.map(t=>{if(null==t)return{value:"",title:""};if(e.context)return{value:t,title:this.getLocalizedValue(e.context,t)};return{value:t,title:e.localize?.((0,xtrem_i18n_1.enumNameToStringKey)(a,t),t)??t}}),enumName:a}}}exports.EnumDataType=EnumDataType;
//# sourceMappingURL=enum-data-type.js.map