/** @packageDocumentation @module runtime */
import { AsyncResponse } from '@sage/xtrem-async-helper';
import { DateValue } from '@sage/xtrem-date-time';
import { BusinessRuleError, ValidationSeverity } from '@sage/xtrem-shared';
import { Diagnose } from './diagnose';
import { Node } from './node';
interface ForSeverity {
    if: <T>(arg: T) => {
        is: ContextValidators<T>;
    };
    add: (message: string) => void;
    addLocalized: (key: string, template: string, data?: object | any[]) => void;
    withMessage: (key: string, template: string, data?: () => AsyncResponse<object | any[]>) => ForSeverity;
}
interface Expect<T> {
    to: {
        be: ContextValidators<T>;
    };
    withMessage: (key: string, template: string, data?: () => AsyncResponse<object | any[]>) => Expect<T>;
}
interface LocalizedMessage {
    key: string;
    template: string;
    data?: () => AsyncResponse<object | any[]>;
}
interface ValidatorsEqual<T> {
    to: (v2: T) => AsyncResponse<boolean>;
}
interface ValidatorsComparison<T> {
    than: (v2: T) => AsyncResponse<boolean>;
}
interface ValidatorsAt<T> {
    least: (v2: T) => AsyncResponse<boolean>;
    most: (v2: T) => AsyncResponse<boolean>;
}
export declare class ContextValidators<T> {
    private readonly messageContext;
    private readonly arg;
    private readonly negated;
    private get context();
    private get severity();
    get not(): ContextValidators<T>;
    empty(this: ContextValidators<string | null>): Promise<boolean>;
    get equal(): ValidatorsEqual<T>;
    get greater(): ValidatorsComparison<T>;
    get less(): ValidatorsComparison<T>;
    get at(): ValidatorsAt<T>;
    in(this: ContextValidators<T>, set: T[]): Promise<boolean>;
    true(this: ContextValidators<boolean>): Promise<boolean>;
    false(this: ContextValidators<boolean>): Promise<boolean>;
    matching(this: ContextValidators<string | null>, re: RegExp): Promise<boolean>;
    zero(this: ContextValidators<number | null>): Promise<boolean>;
    positive(this: ContextValidators<number | null>): Promise<boolean>;
    negative(this: ContextValidators<number | null>): Promise<boolean>;
    before(this: ContextValidators<DateValue | null>, v2: DateValue): Promise<boolean>;
    after(this: ContextValidators<DateValue | null>, v2: DateValue): Promise<boolean>;
}
export declare class ValidationContext {
    node: Node;
    path: string[];
    localize(key: string, template: string, data?: object | any[]): string;
    addDiagnose(severity: ValidationSeverity, message: string): void;
    addError(message: string): void;
    addWarning(message: string): void;
    addInfo(message: string): void;
    get severity(): ValidationSeverity;
    at(...keys: string[]): ValidationContext;
    get info(): ForSeverity;
    get warn(): ForSeverity;
    get error(): ForSeverity;
    get throw(): ForSeverity;
    forExpect<T>(arg: T, localizedMessage?: LocalizedMessage): Expect<T>;
    expect<T>(arg: T): Expect<T>;
}
interface Diagnoses {
    diagnoses: Diagnose[];
    code: string;
}
export declare class ValidationError extends BusinessRuleError {
    readonly node: Node;
    /** This attribute will be used to propagate this diagnoses to the GraphQL response */
    extensions: Diagnoses;
    constructor(node: Node, message?: string, innerError?: Error);
}
export type Validator<This extends Node, ValT = void> = (this: This, cx: ValidationContext, val: ValT) => AsyncResponse<ValT extends never ? never : void>;
export {};
//# sourceMappingURL=validation.d.ts.map