/** @packageDocumentation @module runtime */
import { Node } from './node';
export type DummmyKeys = '_dummy' | '_dummy1' | '_dummy2' | '_dummy3' | '_dummy4' | '_dummy5';
export type ExtensionMembers<T> = Omit<T, DummmyKeys>;
export declare abstract class NodeExtensionBase extends Node {
    constructor();
}
/**
 * Base class for node extensions.
 */
export declare abstract class NodeExtension<Base extends Node> extends NodeExtensionBase {
    protected _dummy: Base;
    protected static _extensionDepth: number;
}
/**
 * Base class for extensions of sub-node classes at the first level of a subclass hierarchy.
 * For example, extending Mammal in an Animal -> Mammal hierachy
 */
export declare abstract class SubNodeExtension1<Base extends Node> extends NodeExtensionBase {
    protected _dummy1: Base;
    protected static _extensionDepth: number;
}
/**
 * Base class for extensions of sub-node classes at the second level of a subclass hierarchy.
 * For example, extending Dog in an Animal -> Mammal -> Dog hierachy
 */
export declare abstract class SubNodeExtension2<Base extends Node> extends NodeExtensionBase {
    protected _dummy2: Base;
    protected static _extensionDepth: number;
}
/**
 * Base class for extensions of sub-node classes at the third level of a subclass hierarchy.
 * For example, extending CompanionDog in an Animal -> Mammal -> Dog -> CompanionDog hierachy
 */
export declare abstract class SubNodeExtension3<Base extends Node> extends NodeExtensionBase {
    protected _dummy3: Base;
    protected static _extensionDepth: number;
}
/**
 * Base class for extensions of sub-node classes at the fourth level of a subclass hierarchy.
 * For example, extending Spaniel in an Animal -> Mammal -> Dog -> CompanionDog -> Spaniel hierachy
 */
export declare abstract class SubNodeExtension4<Base extends Node> extends NodeExtensionBase {
    protected _dummy4: Base;
    protected static _extensionDepth: number;
}
/**
 * Base class for extensions of sub-node classes at the fith level of a subclass hierarchy.
 * For example, extending CavalierKingCharles in an Animal -> Mammal -> Dog -> CompanionDog -> Spaniel -> CavalierKingCharles hierachy
 */
export declare abstract class SubNodeExtension5<Base extends Node> extends NodeExtensionBase {
    protected _dummy5: Base;
    protected static _extensionDepth: number;
}
/**
 * Maximum depth of subclassing currently allowed.
 */
export declare const maxNodeSubclassingDepth = 5;
export type Extend<This extends Node | null> = This extends NodeExtension<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension1<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension2<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension3<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension4<infer Base> ? ExtensionMembers<This & Base> & This : This extends SubNodeExtension5<infer Base> ? ExtensionMembers<This & Base> & This : This;
//# sourceMappingURL=node-extension.d.ts.map