import { Dict } from '@sage/xtrem-shared';
import { StaticThis } from '../decorators';
import { Activity, BaseActivityDefinition, OperationGrant, PermissionGrant } from './activity';
import { Node } from './node';
export interface ActivityExtensionDefinition extends BaseActivityDefinition {
    extends: Activity;
    __filename: string;
}
export declare class ActivityExtension {
    private readonly definition;
    constructor(definition: ActivityExtensionDefinition);
    get extends(): Activity;
    get description(): string;
    get node(): StaticThis<Node>;
    get permissions(): string[];
    get operationGrants(): Dict<OperationGrant[]> | undefined;
    get permissionGrants(): Dict<PermissionGrant[]> | undefined;
    get filename(): string;
}
//# sourceMappingURL=activity-extension.d.ts.map