/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.mockPlugins=exports.AxiosPlugin=exports.Mocker=exports.Plugin=void 0;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),_=require("lodash"),fsp=require("path");class Plugin{constructor(e,t,s){this.name=e,this.path=t,this.scenario=s}mock(){throw new Error("Must implement mock!")}}exports.Plugin=Plugin;class Mocker{static{this.plugins=new Map}static addPlugin(e){Mocker.plugins.set(e.name,e)}static async withMocks(e,t=[]){if(0===t.length)return e();t.forEach(e=>{Mocker.addPlugin(e)});try{return await e()}finally{Mocker.plugins.clear()}}static get(e,t){return Mocker.plugins.get(e)?.mock()||t(e)}}exports.Mocker=Mocker;const locateFirstDiff=(e,t)=>{let s=1,i=1;for(let r=0;r<e.length;r+=1){if(e[r]!==t[r])return{line:s,column:i};if("\n"===e[r])s+=1,i=1;else i+=1}return{line:s,column:i}};function deepDiff(e,t){if("object"!=typeof e||"object"!=typeof t)return[];return _.reduce(e,(e,s,i)=>{const r=t[i];return _.isEqual(s,r)?e:e.concat({key:i,actual:s,expected:r},deepDiff(s,r))},[])}class AxiosPlugin extends Plugin{constructor(){super(...arguments),this.arrayCounter=0}mock(){return e=>{if(e.headers?.Authorization)delete e.headers.Authorization;const t=`${fsp.join(this.path,this.scenario)}.json`;if(null==this.entries){chai_1.assert.isTrue(fs.existsSync(t),`Couldn't find mandatory '${t}' file.`);const e=fs.readFileSync(t,"utf8");chai_1.assert.isDefined(e,`Couldn't read '${t}'.`);const s=(0,xtrem_shared_1.safeJsonParse)(e);chai_1.assert.exists(s,`'${t}' is not a valid JSON file.`),this.entries=!Array.isArray(s)?[s]:s}chai_1.assert.isAtMost(this.arrayCounter,this.entries.length-1,`'${t}' not all requests are a provided.`);const s=this.entries[this.arrayCounter];chai_1.assert.exists(s.request,`'${t}' must contain a 'request' key'.`),chai_1.assert.exists(s.response,`'${t}' must contain a 'response' key'.`);const i=JSON.parse(JSON.stringify(e)),r=s.request;try{chai_1.assert.deepEqual(i,r)}catch(n){const a=fsp.join(this.path,"tmp"),o=JSON.stringify({...s,request:i},null,4),c=JSON.stringify({...s,request:r},null,4),{line:u,column:l}=locateFirstDiff(o,c),f=`${xtrem_date_time_1.Datetime.now(true).toString()}-${_.snakeCase(this.scenario)}`;fs.mkdirSync(a,{recursive:true}),fs.writeFileSync(fsp.join(a,`${f}-actual.json`),o,"utf8"),fs.writeFileSync(fsp.join(a,`${f}-expected.json`),c,"utf8");const h=deepDiff(e,r),p=h.slice(-1)[0],d=`AXIOS MOCKER FAILED\n- Mock file: ${t}.\n- Details in ${a}/${f}-{actual,expected}.json files.\n- Diff starts at line ${u}, column ${l}\nin ${h.map(e=>e.key).join(".")}`;throw fs.writeFileSync(fsp.join(a,`${f}-actual-diff-value.txt`),JSON.stringify(p.actual),"utf8"),fs.writeFileSync(fsp.join(a,`${f}-expected-diff-value.txt`),JSON.stringify(p.expected),"utf8"),new xtrem_shared_1.LogicError(d)}return this.arrayCounter+=1,s.response}}}exports.AxiosPlugin=AxiosPlugin,exports.mockPlugins={axios:AxiosPlugin};
//# sourceMappingURL=mocker.js.map