import { Application } from '../../application';
import { Context, TenantInfo, TenantManager } from '../../runtime/context';
/**
 * A mock for TenantManager: should only be used for unit-tests
 */
declare class TenantManagerMock implements TenantManager {
    private _tenantId;
    private _additionalTenants;
    set additionalTenants(tenants: TenantInfo[]);
    ensureTenantExists(context: Context, options: {
        customer: {
            id: string;
            name: string;
        };
        tenant: {
            id: string;
            name: string;
        };
    }): Promise<void>;
    listTenantsIds(): string[];
    getTenantsInfo(context: Context, tenantId?: string): TenantInfo[];
    initializeManager(context: Context): void;
    deleteTenant(application: Application, tenantId: string): Promise<void>;
}
export declare const tenantManagerMock: TenantManagerMock;
export {};
//# sourceMappingURL=tenant-manager-mock.d.ts.map