import { Dict } from '@sage/xtrem-shared';
import { ServiceOption } from '../../application';
import { AccessRightsManager, UserInfo } from '../../runtime';
import { Node } from '../../ts-api';
export declare const serviceOptionsMock: Dict<ServiceOption>;
export declare class TestUser extends Node {
    readonly email: Promise<string>;
    readonly isFirstAdminUser: Promise<boolean>;
    readonly firstName: Promise<string>;
    readonly lastName: Promise<string>;
    readonly isActive: Promise<boolean>;
    readonly displayName: Promise<string>;
    readonly isAdministrator: Promise<boolean>;
    readonly isDemoPersona: Promise<boolean>;
    readonly isApiUser: Promise<boolean>;
    toUserInfo(): Promise<UserInfo>;
}
export declare class TestActivity extends Node {
    readonly name: Promise<string>;
}
/**
 * A mock for AccessRightsManager: should only be used for unit-tests
 */
export declare const accessRightsManagerMock: AccessRightsManager;
//# sourceMappingURL=access-rights-manager-mock.d.ts.map