import { ClientArtifactUsedLiterals, LocalizedLiteral } from '@sage/xtrem-i18n';
import { MetaCustomFieldsArray, MetaCustomizableNodesArray } from '@sage/xtrem-shared';
import { AccessBinding, NodeAccessBindingStatus } from '../../graphql/security/access-bindings';
import { ExportTemplate } from '../../runtime/core-hooks';
import { TextStream } from '../../types';
export interface ClientArtifactMetadata extends MetaPackArtifact {
    className: string;
    md5?: string;
}
interface PackageArtifact {
    key: string;
    packageName: string;
    content: TextStream;
    artifactFilePath: string;
}
export interface ApplicationArtifact extends ClientArtifactMetadata, PackageArtifact {
    extensions?: string[];
    plugins?: string[];
    menuItem?: string;
    priority?: number;
    strings?: LocalizedLiteral[];
}
export interface JsPackArtifact extends PackageArtifact {
    className: string;
    plugins?: string[];
    menuItem?: string;
    priority?: number;
    literals?: ClientArtifactUsedLiterals;
    type?: string;
}
export interface MetaPackArtifact {
    title?: string;
    authorizationCode?: string;
    pageAccess?: AccessBinding;
    pageNode?: string;
    extensionAccess?: AccessBinding;
    category?: string;
    group?: string;
    categoryLabel?: string;
    type?: string;
    extends?: string;
    plugins?: string[];
    fragments?: string[];
    menuItem?: string;
    parentMenuItem?: string;
    priority?: number;
    listIcon?: string;
    description?: string;
    duplicateBindings?: string[];
    literals?: ClientArtifactUsedLiterals;
    nodes?: string[];
}
export interface MetaCustomFields {
    customizableNodesWizard?: MetaCustomizableNodesArray;
    customizableNodes?: MetaCustomizableNodesArray;
    customFields?: MetaCustomFieldsArray;
}
export declare enum ClientArtifactType {
    pages = "pages",
    widgets = "widgets",
    stickers = "stickers",
    strings = "strings",
    pageExtensions = "page-extensions",
    pageFragments = "page-fragments"
}
export interface NodeAccess {
    node: string;
    bindings: NodeAccessBindingStatus[];
}
export interface PageArtifact {
    pageNode?: string;
    pageAccess?: AccessBinding;
    authorizationCode?: string;
    exportTemplates?: ExportTemplate[];
}
export type ArtifactType = ApplicationArtifact | PageArtifact | null;
export {};
//# sourceMappingURL=client-service.d.ts.map