import { ColumnDefinition, SqlCreateTableOptions } from '@sage/xtrem-postgres';
import { ParseColumnDefinitionResult, PostgreSqlColumnType, PostgreSqlTypes, PostgreSqlTypesToXtrem, XtremToPostgreSqlType } from '../sql-context/types';
export declare const xtremToPostgreSql: XtremToPostgreSqlType;
export declare const postgreSqlToXtrem: PostgreSqlTypesToXtrem;
/**
 * Returns the storage size needed to store a string in encrypted mode
 * (encrypted strings are longer than decrypted string)
 */
export declare function getEncryptedStringStorageSize(maxLength: number): number;
/**
 * Returns the SQL default value to apply to non nullable self references
 * currval(pg_get_serial_sequence('<schemaName>.<rootTablename>'::text, '_id'::text)::regclass)
 */
export declare function getSqlCurrvalOfIdSequence(rootTableFullName: string): string;
/**
 * Get the SQL clause (WITHOUT the 'DEFAULT' keyword) to apply to a column to create it's default value.
 * Will return undefined if the column does not need any SQL default value.
 * @param tableName
 * @param column
 * @param type
 * @returns
 */
export declare function getColumnSqlDefaultClause(column: ColumnDefinition, type?: PostgreSqlColumnType): string | undefined;
/**
 * Parses a columnDefinition into easy to use informations
 * @param tableName
 * @param column
 * @param options
 * @returns
 */
export declare function parseColumnDefinition(schemaName: string, tableName: string, column: ColumnDefinition, options?: SqlCreateTableOptions): ParseColumnDefinitionResult;
export declare function getPostgreSqlType(colDef: ColumnDefinition): PostgreSqlColumnType;
export declare function getColumnDefaultValue(columnType: PostgreSqlTypes): any;
//# sourceMappingURL=types-conversion.d.ts.map