/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.createFunctions=void 0;const core_hooks_1=require("../../runtime/core-hooks");async function createFunctions(n,e){await e(`\n${getSqlToCreateGetConfig(n)}\n${getSqlToCreateDropTriggers(n)}\n${getSqlToCreateDropNotifyFunctions(n)}\n${getSqlToCreateInsertTable(n)}\n${getSqlToCreateInsertSharedTable(n)}\n${getSqlToCreateUpdateTable(n)}\n${getSqlToCreateUpdateSharedTable(n)}\n${getSqlToSetSyncTick(n)}\n${getSqlToCreateSignedInt32(n)}\n${getSqlToCreateImul(n)}\n${getSqlToCreateZeroFillShift(n)}\n${getSqlToCreateNanoId(n)}\n${core_hooks_1.CoreHooks.auditManager.getTriggerFunctionsSql(n)}\n`)}exports.createFunctions=createFunctions;const getSqlToCreateGetConfig=n=>`\nCREATE OR REPLACE FUNCTION ${n}.get_config(setting_name varchar)\nRETURNS varchar AS\n$$\ndeclare\n    setting_value varchar;\nBEGIN\n    SELECT current_setting(setting_name) into setting_value;\n    RETURN setting_value;\nEXCEPTION\n    WHEN OTHERS THEN\n    RETURN '';\nEND;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateInsertTable=n=>`\nCREATE OR REPLACE FUNCTION ${n}.insert_table()\nRETURNS TRIGGER\nAS\n$$\n    DECLARE\n        USER_ID VARCHAR;\n    BEGIN\n        SELECT ${n}.get_config('xtrem.transaction_user_id') INTO USER_ID;\n        IF (USER_ID != '') THEN\n            NEW._create_user :=  CAST(USER_ID AS INT8);\n            NEW._update_user :=  CAST(USER_ID AS INT8);\n        END IF;\n        IF (NEW._create_stamp IS NULL) THEN\n            NEW._create_stamp := NOW();\n        END IF;\n        IF (NEW._update_stamp IS NULL) THEN\n            NEW._update_stamp := NOW();\n        END IF;\n        IF (NEW._update_tick IS NULL) THEN\n            NEW._update_tick := 1;\n        END IF;\n\n        RETURN NEW;\n    END;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateInsertSharedTable=n=>`\nCREATE OR REPLACE FUNCTION ${n}.insert_shared_table()\nRETURNS TRIGGER\nAS\n$$\n    BEGIN\n        IF (NEW._create_stamp IS NULL) THEN\n            NEW._create_stamp := NOW();\n        END IF;\n        IF (NEW._update_stamp IS NULL) THEN\n            NEW._update_stamp := NOW();\n        END IF;\n        IF (NEW._update_tick IS NULL) THEN\n            NEW._update_tick := 1;\n        END IF;\n\n        RETURN NEW;\n    END;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateUpdateTable=n=>`\nCREATE OR REPLACE FUNCTION ${n}.update_table()\nRETURNS TRIGGER\nAS\n$$\n    DECLARE\n        USER_ID VARCHAR;\n    BEGIN\n        SELECT ${n}.get_config('xtrem.transaction_user_id') INTO USER_ID;\n        IF (USER_ID != '') THEN\n            NEW._update_user :=  CAST(USER_ID AS INT8);\n        END IF;\n        NEW._update_stamp := NOW();\n        NEW._update_tick := OLD._update_tick + 1;\n\n        RETURN NEW;\n    END;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateUpdateSharedTable=n=>`\nCREATE OR REPLACE FUNCTION ${n}.update_shared_table()\nRETURNS TRIGGER\nAS\n$$\n    BEGIN\n        NEW._update_stamp := NOW();\n        NEW._update_tick := OLD._update_tick + 1;\n\n        RETURN NEW;\n    END;\n$$\nLANGUAGE plpgsql;\n`,getSqlToSetSyncTick=n=>`\nCREATE OR REPLACE FUNCTION ${n}.set_sync_tick()\nRETURNS TRIGGER\nAS\n$$\n    BEGIN\n        NEW._sync_tick :=  pg_current_xact_id();\n        RETURN NEW;\n    END;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateDropTriggers=n=>`\nCREATE OR REPLACE FUNCTION ${n}.drop_triggers(schema_name varchar, name_filter varchar DEFAULT '') RETURNS integer AS\n$$\nDECLARE\n    triggerRecord RECORD;\n    record_count integer;\nbegin\n\trecord_count = 0;\n    FOR triggerRecord IN\n    \tSELECT trigger_name, event_object_table\n    \tFROM information_schema.triggers\n    \tWHERE trigger_schema = schema_name AND (name_filter = '' OR event_object_table = name_filter)\n\tLOOP\n\t\trecord_count = record_count + 1;\n        EXECUTE 'DROP TRIGGER ' || triggerRecord.trigger_name || ' ON ' || schema_name || '."' || triggerRecord.event_object_table || '";';\n    END LOOP;\n\n    RETURN record_count;\nEND;\n$$ LANGUAGE plpgsql;\n`,getSqlToCreateDropNotifyFunctions=n=>`\nCREATE OR REPLACE FUNCTION ${n}.drop_notify_functions(schema_name varchar, name_filter varchar DEFAULT '') RETURNS integer AS\n$$\nDECLARE\n    triggerRecord RECORD;\n    record_count integer;\nBEGIN\n    record_count = 0;\n    FOR triggerRecord IN\n    SELECT routine_name\n    FROM information_schema.routines\n    WHERE specific_schema = schema_name and routine_name IN (name_filter || '_notify_deleted', name_filter || '_notify_created', name_filter || '_notify_updated')\n    LOOP\n        record_count = record_count + 1;\n        EXECUTE 'DROP FUNCTION ' || schema_name || '.' || triggerRecord.routine_name || ';';\n    END LOOP;\n\n    RETURN record_count;\nEND;\n$$ LANGUAGE plpgsql;\n`,getSqlToCreateSignedInt32=n=>`\nCREATE OR REPLACE FUNCTION ${n}.signedInt32(a bigint)\nRETURNS bigint AS\n$$\nDECLARE\nBEGIN\n\t-- Convert to 32 bit signed (if leftmost bit is 1, it's a negative number)\n  \tIF (a > 2^31) THEN\n    \tRETURN a - (2^32)::bigint;\n  \tEND IF;\n  \tRETURN a;\nEND;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateImul=n=>`\nCREATE OR REPLACE FUNCTION ${n}.imul(a bigint, b bigint)\nRETURNS bigint AS\n$$\nDECLARE\n    aHi bigint;\n    aLo bigint;\n    bHi bigint;\n    bLo bigint;\n    res bigint;\nBEGIN\n    aHi = ${n}.zeroFillShift(a, 16) & 65535;\n    aLo = a & 65535;\n    bHi = ${n}.zeroFillShift(b, 16) & 65535;\n    bLo = b & 65535;\n    res = ((aLo * bLo) + ${n}.zeroFillShift(((aHi * bLo + aLo * bHi) << 16) % (2^32)::bigint, 0)) | 0;\n    RETURN ${n}.signedInt32(res);\nEND;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateZeroFillShift=n=>`\nCREATE OR REPLACE FUNCTION ${n}.zeroFillShift(a bigint, b int)\nRETURNS bigint AS\n$$\nDECLARE\n  \tres bigint;\nBEGIN\n\tIF (a < 0) THEN\n\t\tres = a + 2^32;\n\tELSE\n\t\tres = a;\n\tEND IF;\n\tres = res >> b;\n\tRETURN res;\nEND;\n$$\nLANGUAGE plpgsql;\n`,getSqlToCreateNanoId=n=>`\nCREATE OR REPLACE FUNCTION ${n}.nanoid("size" int4 DEFAULT 21)\n    RETURNS text\n    LANGUAGE plpgsql\n    STABLE\n    AS\n    $$\n    DECLARE\n        id text := '';\n        i int := 0;\n        urlAlphabet char(64) := 'ModuleSymbhasOwnPr-0123456789ABCDEFGHNRVfgctiUvz_KqYTJkLxpZXIjQW';\n        bytes bytea;\n        byte int;\n        pos int;\n    BEGIN\n        SELECT gen_random_bytes(size) INTO bytes;\n    WHILE i < size LOOP\n        byte := get_byte(bytes, i);\n        pos := (byte & 63) + 1; -- + 1 because substr starts at 1\n        id := id || substr(urlAlphabet, pos, 1);\n        i = i + 1;\n    END LOOP;\n    RETURN id;\n    END\n    $$\n    ;\n `;
//# sourceMappingURL=functions.js.map