import { SchemaSqlContext } from '.';
import { Application } from '../../application';
/**
 * Options for fixing a sequence
 */
interface FixAutoIncrementSequenceOptions {
    /**
     * Max value that we have inserted
     */
    newMaxValue?: number;
}
export declare class SequenceSqlContext extends SchemaSqlContext {
    readonly tableName: string;
    /** @disabled_internal */
    constructor(application: Application, tableName: string);
    private getSequenceName;
    private alterSequence;
    nextSequence(columnName: string): Promise<number>;
    private getNextSequence;
    private getNextSequenceByColumnName;
    /**
     * Fix the sequence used by an auto-increment column
     * @param column The auto-increment
     * @param options
     */
    fixAutoIncrementSequence(tenantId: string | null, column: string, options?: FixAutoIncrementSequenceOptions): Promise<void>;
    /**
     * Fix the sequences of the bound table
     * @param columns list of auto-increment columns
     * @param options
     */
    fixAutoIncrementSequences(tenantId: string | null, columns: string[], options?: FixAutoIncrementSequenceOptions): Promise<void>;
    private dropSequence;
    /**
     * Drop the sequence used by an auto-increment column
     * @param column The auto-increment
     * @param options
     */
    dropAutoIncrementSequence(column: string): Promise<void>;
    /**
     * Fix the sequences of the bound table
     * @param columns list of auto-increment columns
     * @param options
     */
    dropAutoIncrementSequences(columns: string[]): Promise<void>;
}
export {};
//# sourceMappingURL=sequence-sql-context.d.ts.map