/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ReadTableSqlContext=exports.readTablesForSchema=exports.readTableSchemas=exports.readTableSchema=exports.isSystemColumn=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_postgres_1=require("@sage/xtrem-postgres"),loggers_1=require("../../runtime/loggers"),utils_1=require("../schema/utils"),types_conversion_1=require("../statements/types-conversion"),schema_sql_context_1=require("./schema-sql-context");function isSystemColumn(e){return["_tenant_id","_custom_data","_create_stamp","_create_user","_id","_source_id","_update_stamp","_update_tick","_update_user","_layer","_vendor"].includes(e)}function readTableSchema(e,a,t){return new ReadTableSqlContext(e.application).readSchema(a,t)}function readTableSchemas(e,a,t){return new ReadTableSqlContext(e.application).readTableDefinitions(a,t)}function readTablesForSchema(e){return new ReadTableSqlContext(e.application).readTablesForSchema()}exports.isSystemColumn=isSystemColumn,exports.readTableSchema=readTableSchema,exports.readTableSchemas=readTableSchemas,exports.readTablesForSchema=readTablesForSchema;class ReadTableSqlContext extends schema_sql_context_1.SchemaSqlContext{async readSchema(e,a={skipSequences:true,skipColumns:true,skipForeignKeys:true,skipSecurity:true}){return(await this.readTableDefinitions([e],a))[e]}_getOrInitTableDef(e,a){let t=e[a];if(null==t)t={schemaName:this.schemaName,tableName:a,columns:[],indexes:[],foreignKeys:[],triggers:[]},e[a]=t;return t}async readTablesForSchema(){const e=[],a="SELECT t.table_name\n                FROM information_schema.tables t\n                WHERE t.table_schema = $1",t={schemaName:this.schemaName};return await this.withConnection(async n=>{await this.createReader(n,a,ReadTableSqlContext._transformSqlArgs(t),{logLevel:"debug"}).forEach(a=>{e.push(a.table_name)})}),e}async readTableDefinitions(e,a={}){const t={};e.forEach(e=>this._getOrInitTableDef(t,e));const n={schemaName:this.schemaName};if(e.length)n.tableNames=e;if(!a.skipColumns){const s=Date.now();loggers_1.loggers.upgrade.debug(()=>`Loading columns for tables ${e}`),await this.fillColumnInfos(t,n,!!a.getComments),loggers_1.loggers.upgrade.debug(()=>`Loaded columns for tables ${e} in ${Date.now()-s} ms`)}if(!a.skipIndexes){const a=Date.now();loggers_1.loggers.upgrade.debug(()=>`Loading indexes for tables ${e}`),await this.fillIndexInfos(t,n),loggers_1.loggers.upgrade.debug(()=>`Loaded indexes for tables ${e} in ${Date.now()-a} ms`)}if(!a.skipForeignKeys){const s=Date.now();loggers_1.loggers.upgrade.debug(()=>`Loading FKs for tables ${e}`),await this._fillForeignKeyInfo(t,n,!!a.getComments),loggers_1.loggers.upgrade.debug(()=>`Loaded FKs for tables ${e} in ${Date.now()-s} ms`)}if(new Set(a.includes).has("triggers")){const a=Date.now();loggers_1.loggers.upgrade.debug(()=>`Loading triggers for tables ${e}`),await this.fillTableTriggers(t,n),loggers_1.loggers.upgrade.debug(()=>`Loaded triggers for tables ${e} in ${Date.now()-a} ms`)}if(a.getComments)await this._fillComments(Object.values(t));return t}async _fillComments(e){await this.withConnection(a=>(0,xtrem_async_helper_1.asyncArray)(Object.values(e)).forEach(async e=>{const t=`SELECT obj_description('${e.schemaName}.${e.tableName}'::regclass);`,n=(await this.execute(a,t))[0];if(n&&n.obj_description)e.comment=JSON.parse(n.obj_description)}))}_fillUpColumnDefinitionForEnums(e,a){switch(a.enumDataType={name:e.udt_name,values:{}},e.data_type){case"USER-DEFINED":a.type="enum";break;case"ARRAY":a.type="enumArray";break;default:throw new Error(`Unmanaged enum related type. column=${e.column_name}, data_type=${e.data_type}, enumType=${e.udt_name}`)}}_sqlRowToColumnDefinition(e){const a={name:e.column_name,isNullable:"NO"!==e.is_nullable};if(e.column_default===(0,types_conversion_1.getSqlCurrvalOfIdSequence)(`${this.schemaName}.${e.table_name}`))a.isSelfReference=true;if(null!=e.col_comment)a.comment=JSON.parse(e.col_comment);if(e.column_default)if(/^nextval\(/.test(e.column_default))a.isAutoIncrement=true,a.default=null;else if("''::character varying"===e.column_default)a.default="";else a.default=e.column_default;else a.default=null;switch(e.udt_name){case"int4":a.type="short";break;case"_int8":a.type="ARRAY"===e.data_type?"integerArray":"integer";break;case"varchar":case"string":a.type="string",a.maxLength=parseInt(e.character_maximum_length,10);break;case"numeric":a.type="decimal",a.precision=parseInt(e.numeric_precision,10),a.scale=parseInt(e.numeric_scale,10);break;default:if(e.udt_name?.endsWith("_enum"))return this._fillUpColumnDefinitionForEnums(e,a),a;if(e.udt_name?.toUpperCase().startsWith("TIMESTAMPTZ"))e.udt_name=`${e.udt_name}(${e.datetime_precision})`;if(a.type=types_conversion_1.postgreSqlToXtrem[e.udt_name.toUpperCase()]?.name,null==a.type)throw new Error(`Unmanaged column type. column=${e.column_name}, data_type=${e.data_type}, udt_name=${e.udt_name}`)}return a}async fillColumnInfos(e,a,t){const n=`SELECT c.table_name, c.udt_name, c.column_name, c.data_type, c.character_maximum_length, c.numeric_precision,\n                c.numeric_scale, c.datetime_precision, c.is_nullable, c.column_default ${t?", pg_catalog.col_description(format('%s.%s',c.table_schema,c.table_name)::regclass::oid,c.ordinal_position) col_comment":""}\n                FROM information_schema.columns c\n                WHERE c.table_schema = $1 ${a.tableNames?" AND c.table_name = ANY($2::TEXT[])":""}\n                ORDER BY c.table_name, c.ordinal_position`;await this.withConnection(async t=>{const buildColumn=e=>{const a=this._sqlRowToColumnDefinition(e);return a.isSystem=isSystemColumn(a.name),a};await this.createReader(t,n,ReadTableSqlContext._transformSqlArgs(a),{logLevel:"debug"}).forEach(a=>{const t=a.table_name;this._getOrInitTableDef(e,t).columns.push(buildColumn(a))})})}static _transformSqlArgs(e){const a=[e.schemaName];if(e.tableNames)a.push(e.tableNames);return a}async fillIndexInfos(e,a){const t=`SELECT c.tablename table_name, c.indexname index_name, c.indexdef index_def FROM pg_indexes c\n                          WHERE c.schemaname = $1 ${a.tableNames?" AND c.tablename = ANY($2::TEXT[])":""}\n                          ORDER BY c.tablename, c.indexname;`;await this.withConnection(n=>this.createReader(n,t,ReadTableSqlContext._transformSqlArgs(a),{logLevel:"debug"}).forEach(a=>{const t=a.table_name,n=this._getOrInitTableDef(e,t),s=a.index_name,r=a.index_def,o=(0,utils_1.parseIndexDefinition)(s,r);if(s.toUpperCase().endsWith("_PK"))n.primaryKey={columns:o.map(e=>e.name)};else n.indexes.push({name:a.index_name,isUnique:r.includes("CREATE UNIQUE INDEX"),columns:o})}))}async _fillForeignKeyInfo(e,a,t){const n=`\n        SELECT\n            pgc.relname AS table_name,\n            pgcf.relname AS fk_table_name,\n            r.conname AS constraint_name,\n            pg_catalog.pg_get_constraintdef(r.oid, true) AS fk_def\n            ${t?", obj_description(r.oid) fk_comment":""}\n        FROM pg_catalog.pg_constraint r\n        JOIN pg_catalog.pg_class pgcf ON pgcf.oid = r.confrelid\n        JOIN pg_catalog.pg_class pgc ON pgc.oid = r.conrelid\n        WHERE r.contype='f' AND r.connamespace = $1::regnamespace ${a.tableNames?"AND pgc.relname = ANY($2::TEXT[])":""}\n        ORDER BY table_name, constraint_name;`;await this.withConnection(t=>this.createReader(t,n,ReadTableSqlContext._transformSqlArgs(a),{logLevel:"debug"}).forEach(a=>{const t=this._getOrInitTableDef(e,a.table_name),n=(0,xtrem_postgres_1.parseForeignKeyDefinition)(a.fk_def),s={name:a.constraint_name,targetTable:a.fk_table_name,columnNames:n.sourceColumns,targetColumnNames:n.targetColumns,onDeleteBehaviour:n.onDeleteBehaviour,isDeferrable:n.isDeferrable};if(a.fk_comment)s.comment=JSON.parse(a.fk_comment);t.foreignKeys.push(s)}))}async fillTableTriggers(e,a){const t=`\n                SELECT event_object_table, trigger_name, action_timing, event_manipulation, action_statement\n                FROM information_schema.triggers\n                WHERE event_object_schema = $1\n                ${a.tableNames?"AND event_object_table = ANY($2::TEXT[])":""}\n                ORDER BY event_object_table, trigger_name, action_timing, event_manipulation`;await this.withConnection(async n=>{let s;const r={"DELETE+INSERT":"DELETE OR INSERT","INSERT+UPDATE":"INSERT OR UPDATE","DELETE OR INSERT+UPDATE":"DELETE OR INSERT OR UPDATE"};await this.createReader(n,t,ReadTableSqlContext._transformSqlArgs(a),{logLevel:"debug"}).forEach(a=>{const t=a.event_object_table,n=this._getOrInitTableDef(e,t);n.triggers=n.triggers||[];const o=a.action_statement,i=o.match(/^EXECUTE (?:PROCEDURE|FUNCTION) ([0-9a-zA-Z_.]+)\((.*)\)$/),l=i?i[1]:o,c=i?i[2]:"",m={name:a.trigger_name,when:a.action_timing,event:a.event_manipulation,functionName:l,functionParameters:c};if(s&&s.name===m.name&&s.when===m.when&&s.functionName===m.functionName){const e=`${s.event}+${m.event}`,a=r[e];if(null==a)throw new Error(`Unsupported trigger transition: ${e} on trigger ${n.tableName}.${m.name}`);return void(s.event=a)}n.triggers.push(m),s=m})})}}exports.ReadTableSqlContext=ReadTableSqlContext;
//# sourceMappingURL=read-table-sql-context.js.map