import { EnumType } from '../../types';
import { SchemaSqlContext } from './schema-sql-context';
export declare class EnumSqlContext extends SchemaSqlContext {
    /**
     * create new enum datatypes
     */
    createEnumTypes(types: EnumType[]): Promise<void>;
    /**
     * create a new enum datatype
     */
    private createEnumTypeSql;
    /**
     * get list of all enum types in the schema
     */
    listAllEnumTypes(): Promise<{
        enumTypeName: string;
        enumValues: string;
    }[]>;
    /**
     * get in which table and column enum type is used.
     * @returns
     */
    listEnumTypesUsage(enumTypeName?: string): Promise<{
        enumTypeName: string;
        tableName: string;
        columnName: string;
    }[]>;
    enumTypeExists(typeName: string): Promise<boolean>;
    /**
     *
     * @param options
     *  restrict: Refuse to drop the type if any objects depend on it. This is the default.
     *  cascade: Automatically drop objects that depend on the type (such as table columns, functions, and operators), and in turn all objects that depend on those objects (see Section 5.14).
     */
    dropEnum(typeName: string, options?: {
        cascade?: boolean;
        restrict?: boolean;
    }): Promise<void>;
    /**
     * rename attribute value of an enum type
     * @param options
     */
    renameEnumAttributes(typeName: string, options: {
        oldValue: string;
        newValue: string;
    }): Promise<void>;
    /**
     * add attribute to an existing enum type
     * @param options
     */
    addAttributesToEnum(typeName: string, options: {
        newValue: string;
        position?: {
            after?: string;
            before?: string;
        };
    }): Promise<void>;
    /**
     * rename enum type name
     * @param newTypeName
     */
    renameEnumType(typeName: string, newTypeName: string): Promise<void>;
    /**
     * Drop enum attribute
     * https://stackoverflow.com/questions/25811017/how-to-delete-an-enum-type-value-in-postgres
     
     * @param options
     */
    dropEnumAttributes(typeName: string, attributesToRemove: {
        memberName: string;
        replacement: string | null;
    }[]): Promise<void>;
    /**
     * get enum attributes values
     */
    getEnumAttributes(typeName: string): Promise<string>;
    static getEnumCoalesceFunctionName(enumName: string): string;
    private doesEnumCoalesceFunctionExist;
    static getSqlToCreateEnumCoalesceFunction(schemaName: string, enumName: string, paramEnumName?: string): string;
    static getSqlToDropEnumCoalesceFunction(schemaName: string, enumName: string, paramEnumName?: string): string;
}
//# sourceMappingURL=enum-sql-context.d.ts.map