/** @ignore */ /** */
import { ColumnJsonComment } from '@sage/xtrem-postgres';
import { ColumnTypeName } from '@sage/xtrem-shared';
import { TypeName } from '../../decorators';
import { Property } from '../../properties';
import { Table } from './table';
/** @disabled_internal */
export declare class Column {
    readonly property: Property;
    constructor(property: Property);
    get isSystem(): boolean;
    get table(): Table;
    /** Property name */
    get propertyName(): string;
    /** Column name - may be different from property name */
    get columnName(): string;
    /** Column type - may be different from property type */
    get type(): TypeName;
    /**
     * Returns whether this column should be lazy loaded
     */
    get shouldLazyLoad(): boolean;
    /** Is property value nullable ? (must not be used for string properties : use isNotEmpty instead for strings) */
    get isNullable(): boolean;
    /** Is property value an encrypted string ? (only applies to string properties) */
    get isEncryptedString(): boolean;
    getColumnType(): ColumnTypeName;
    columnError(message: string): Error;
    /**
     * Returns the JSON comment that must be put on the column (in the database)
     */
    getJsonComment(): ColumnJsonComment;
    /**
     * The SQL default of this column
     */
    get default(): string | undefined | null;
    /**
     * Is this column set to be auto incremented
     */
    get isAutoIncrement(): boolean;
    /**
     * The SQL default of this column
     */
    get excludeFromInsertIfNull(): boolean;
    /**
     * The column is a system column that is only on the table but not on the factory
     */
    get isInternalSystemProperty(): boolean;
}
//# sourceMappingURL=column.d.ts.map