/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PubSub=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),lodash_1=require("lodash"),container_manager_1=require("../../runtime/container-manager"),loggers_1=require("../../runtime/loggers"),subscriber_1=require("./subscriber"),logger=loggers_1.loggers.pubsub;class PubSub{static get subscriber(){return(async()=>{const e=xtrem_config_1.ConfigManager.current.storage;if(e.managedExternal)return;return await subscriber_1.NotificationSubscriptionManager.getSubscriber(e)})()}static getChannelName(e){if(!/^[\w _-]+$/.test(e))throw new Error(`Invalid character(s) in topic, only alphabets, numbers, _, - and spaces are allowed, ${e}`);return(0,lodash_1.snakeCase)(e)}static async publish(e,n,r,a){if(!e.isWritable)throw new Error(`Cannot publish using a context that is not writable: ${n}`);const t=container_manager_1.ContainerManager.containerId,i={data:JSON.stringify(r),containerId:t,excludeSelf:!!a?.excludeSelf},s=PubSub.getChannelName(n);logger.verbose(()=>`Sending notification: channel ${s}, container ${t}, ${JSON.stringify(i)}`);const c=JSON.stringify(i).replace(/'/g,"''");await e.executeSql(`NOTIFY ${s}, '${c}';`,[])}static async subscribe(e,n){const r=PubSub.getChannelName(e),a=await this.subscriber,t=container_manager_1.ContainerManager.containerId;if(!a)return;a.notifications.on(r,e=>{if(e.excludeSelf&&e.containerId===t)return;(async()=>{logger.verbose(()=>`Processing notification: channel ${r}, container ${t}, ${JSON.stringify(e)}`),await n(JSON.parse(e.data),t),logger.verbose(()=>`Completed processing notification: channel ${r}, container ${t}, ${JSON.stringify(e)}`)})().catch(e=>{logger.error(()=>`Error while processing notification: channel ${r}, container ${t}, ${e.stack}`)})});const i=a.listenTo(r);if(!i)logger.warn(`Already subscribed to channel ${r}, container ${t}`);else await i,logger.info(`Subscribed to channel ${r}, containerId ${t}`)}static async isSubscribed(e){const n=await this.subscriber;return!!n&&n.getSubscribedChannels().includes(PubSub.getChannelName(e))}static async unsubscribeChannel(e){const n=await this.subscriber;if(!n)return;const r=n.unlisten(e),a=container_manager_1.ContainerManager.containerId;if(!r)logger.warn(`WARNING: was not subscribed to channel ${e}, container ${a}`);else await r,logger.info(`Unsubscribed from channel ${e}, container ${a}`);n.notifications.removeAllListeners(e)}static async unsubscribe(e){if(!await this.subscriber)return;const n=PubSub.getChannelName(e);await PubSub.unsubscribeChannel(n)}static async unsubscribeAll(){const e=await this.subscriber;if(!e)return;const n=e.getSubscribedChannels();await(0,xtrem_async_helper_1.asyncArray)(n).forEach(e=>PubSub.unsubscribeChannel(e))}}exports.PubSub=PubSub;
//# sourceMappingURL=pubsub.js.map