/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlNaturalKeyUtils=void 0;const sql_context_1=require("../sql-context");class SqlNaturalKeyUtils{static getSqlQueryPartsWithNaturalKeys(e,t,a,l={}){const s=l.aliases||{},n=l.joins||[],o=l.args||[];return{columns:a.map(a=>({aliased:`${this._getAliasedColumnForSqlQuery({schemaName:e,aliases:s,args:o,joins:n,table:t,tableAlias:l.tableAlias,columnName:a,doNotUseArgsForConstructors:!!l.doNotUseArgsForConstructors})} AS ${sql_context_1.SqlContext.escape(a)}`,unaliased:sql_context_1.SqlContext.escape(a)})),aliases:s,joins:n,args:o}}static _getAliasedColumnForSqlQuery(e){const t=e.firstTable||e.table,a=e.tableAlias||"t0",getOrCreateTableAlias=(t,l)=>{let s=e.aliases[t.name];if(s)return s;s=`t${Object.keys(e.aliases).length+1}`,e.aliases[t.name]=s;const n=l(s);if(t.isSharedByAllTenants)e.joins.push(n);else e.joins.push(`${n} AND ${s}._tenant_id=${a}._tenant_id`);return s},l=e.table.columnsByColumnName[e.columnName];if(null==l){if(null==e.table.baseTable)throw new Error(`Could not find column ${e.columnName} from the table ${t.name}`);const l=e.table.baseTable,s=getOrCreateTableAlias(l,t=>{let s;if(e.doNotUseArgsForConstructors)s=e.table.factory.name;else e.args.push(e.table.factory.name),s=`$${e.args.length}`;return` LEFT JOIN ${e.schemaName}.${l.name} ${t} ON ${t}._id=${a}._id AND ${t}._constructor=${s}`});return this._getAliasedColumnForSqlQuery({...e,firstTable:t,table:l,tableAlias:s})}const s=l.property;if(!s)throw new Error(`The column ${e.table.name}.${e.columnName} is not bound to any property`);if(s.isReferenceProperty()){const l=s.targetFactory;if(!l.naturalKey||0===l.naturalKey.length)throw new Error(`The node ${l.name} has no natural key but is referenced in the natural key of the node ${e.table.factory.name}`);const n=l.table,o=getOrCreateTableAlias(n,t=>` LEFT JOIN ${e.schemaName}.${n.name} ${t} ON ${t}._id=${a}.${sql_context_1.SqlContext.escape(e.columnName)}`);return l.naturalKey.map(a=>{const s=l.propertiesByName[a];if(null==s.columnName)throw new Error(`No column bound to ${l.name}.${a}`);return this._getAliasedColumnForSqlQuery({...e,firstTable:t,table:n,tableAlias:o,columnName:s.columnName})}).join(" || '|' || ")}const n=sql_context_1.SqlContext.escape(l.columnName);return`${a}.${n}`}}exports.SqlNaturalKeyUtils=SqlNaturalKeyUtils;
//# sourceMappingURL=sql-natural-key-utils.js.map