/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlInsert=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),lodash=require("lodash"),custom_metrics_1=require("../../metrics/prometheus/custom-metrics"),lazy_loaded_marker_1=require("../../node-state/lazy-loaded-marker"),properties_1=require("../../properties"),runtime_1=require("../../runtime"),core_hooks_1=require("../../runtime/core-hooks"),loggers_1=require("../../runtime/loggers"),sql_context_1=require("../sql-context"),schema_sql_context_1=require("../sql-context/schema-sql-context"),sql_context_2=require("../sql-context/sql-context"),sql_converter_1=require("./sql-converter"),sql_util_1=require("./sql-util"),sqlLogger=loggers_1.loggers.sql;class SqlInsert{constructor(e){this.table=e}get factory(){return this.table.factory}static{this.auditColumnNames=["_create_user","_create_stamp","_update_user","_update_stamp","_update_tick"]}isColumnSkipped(e,t,r){if(e.excludeFromInsertIfNull&&null===t)return true;if(e.property.isRequired&&null==t)throw new Error(`Cannot insert null value in column ${this.table.name}.${e.columnName}`);if(t===lazy_loaded_marker_1.lazyLoadedMarker)return true;if(e.property instanceof properties_1.ReferenceProperty&&e.property.isSelfReference&&t<0&&t===r.selfId)return true;if(!r.preserveAuditColumns&&this.table.databaseComputedColumnNames.includes(e.columnName))return true;if("_id"===e.propertyName&&t<0)return true;if("_sortValue"===e.propertyName&&!t)return true;return false}fixAndFilterColumns(e,t,r){return this.table.columns.filter(s=>{if(s.property.isLocalized)sql_util_1.SqlUtil.setLocalizedValue(e,t,s.property.name,"insert");const a=t[s.property.name];if(Array.isArray(a)&&!(s.property.isArrayProperty()||s.property.isJsonProperty()))throw s.columnError("unexpected array");const n=!this.isColumnSkipped(s,a,r);if(t[s.propertyName]=a??null,s.property.isReferenceProperty()&&s.property.isSelfReference&&Number.isFinite(a)&&Number(a)<0)t[s.propertyName]=r.selfId;return n})}async prepareRow(e,t,r={}){let s={...t};if(null==s._id||0===s._id)s._id=e.allocateTransientId();let a={};if(this.factory.propertiesByName._sortValue&&null==s._sortValue&&"number"==typeof s._id&&s._id>0)s._sortValue=100*s._id;let n=r.constructorName;if(this.factory.isAbstract){if(!n)throw new Error(`'constructor' is missing, cannot insert into '${this.table.name}'`);s._constructor=n}else{if(n)throw new Error(`No 'constructor' should be provided for table '${this.table.name}', constructor was '${n}'`);n=this.factory.name}const o=this.table.baseTable;if(o){const t=this.table.columns.filter(e=>{if("_id"===e.propertyName)return true;return!e.property.isInherited}).reduce((e,t)=>(e[t.propertyName]=true,e),{}),i={},l={};if(Object.keys(s).forEach(e=>{if(t[e])i[e]=s[e];else l[e]=s[e]}),s._id&&"number"==typeof s._id&&s._id>0)l._id=s._id;l._sourceId=i._sourceId,a={...a,...await new SqlInsert(o).insert(e,l,{...r,constructorName:n})},s={...i,...a}}const i=this.fixAndFilterColumns(e,s,{selfId:s._id,preserveAuditColumns:!!r.preserveAuditColumns}),l=s.email===runtime_1.rootUserEmail&&this.factory.name===core_hooks_1.CoreHooks.sysManager.getUserNode().name;return{row:s,allNewKeys:a,isRootUserInsert:l,insertedColumns:i}}getReturningColumnNames(e){return this.table.columns.filter(t=>t.isAutoIncrement||e.processLocalizedTextAsJson&&t.property.isLocalized).map(e=>e.columnName)}getInsertInfo(e,t){const r=[],s=[],a=e.context.schemaName,n=this.getReturningColumnNames(e.context),o=[];if(t.insertedColumns.forEach(t=>{s.push(sql_context_2.SqlContext.escape(t.columnName)),r.push(sql_util_1.SqlUtil.pushColumnArg(e,t))}),t.isRootUserInsert)["_create_user","_update_user"].forEach(t=>{s.push(t),r.push((0,sql_context_1.getSqlCurrvalOfIdSequence)(this.table.getFullTableName(e.context)))});const i=o.filter(e=>"autofix"===e.category);if(i.length>0)if(loggers_1.loggers.sql.warn(`${a}.${this.table.name} has autofixed ${i.length} lines`),loggers_1.loggers.sql.isActive("debug"))i.forEach(e=>loggers_1.loggers.sql.debug(()=>e.message));let l;if(t.useUpsert){if(!this.factory.naturalKey)throw new Error(`Upsert mode can only be used on factories with a natural key (factory was ${this.factory.fullName})`);if(l=this.factory.naturalKey.map(e=>this.factory.propertiesByName[e].requiredColumnName),!this.table.isSharedByAllTenants)l.unshift("_tenant_id")}const u=e.sqlParameters;return{schemaName:a,columnNames:s,sqlParameters:u,parameterNames:r,returningColumns:n,upsertKeyColumns:l}}getUpsertFunctionSql(e,t,r){return`CREATE OR REPLACE FUNCTION ${e}.upsert(${t.map(t=>`${e}.${this.table.name}.${t}%TYPE`).join(",")}) RETURNS JSON AS\n        $$\n            DECLARE ret RECORD;\n            err_message TEXT;\n            err_detail TEXT;\n        BEGIN\n        ${r} into ret;\n        RETURN row_to_json(ret);\n        RETURN JSON;\n        EXCEPTION\n            WHEN unique_violation THEN\n                -- duplicate key on another unique index than the one that was used in the ON CONFLICT(...) clause\n\n                -- capture the error message/detail\n                GET STACKED DIAGNOSTICS\n                    err_message = MESSAGE_TEXT,\n                    err_detail = PG_EXCEPTION_DETAIL;\n                SELECT column1 as _err_message, TRUE as _upsert_failed, err_detail as _err_detail FROM (VALUES(err_message)) AS T INTO ret;\n                RETURN row_to_json(ret);\n            WHEN OTHERS THEN RAISE;\n        END $$ LANGUAGE plpgsql;`}getInsertSql(e,t){if(!e.returningColumns)e.returningColumns=[];const r=e.upsertKeyColumns||["_tenant_id","_id"],s=this.table.databaseComputedColumnNames,a=lodash.uniq([...s,...e.returningColumns||[]]),n=[];if(n.push(`INSERT INTO ${e.schemaName}.${this.table.name}\n`),n.push(`(${e.columnNames.join(",")})\n`),n.push(`VALUES (${e.parameterNames.join(",")})`),t.onConflictDoNothing)n.push("\nON CONFLICT DO NOTHING");else if(t.useUpsert){const s=[],a=[],o=[...r,"_create_stamp","_create_user","_update_user",...t.upsertColumnsToIgnore||[]];e.columnNames.forEach((t,r)=>{if(o.includes(t));else s.push(t),a.push(e.parameterNames[r])});const i=r.map(e=>{const t=this.table.columnsByColumnName[e];if(!t)throw new Error(`Table ${this.table.name}: column ${e} does not exist`);if(!t.isNullable)return sql_context_2.SqlContext.escape(e);return`COALESCE (${sql_context_2.SqlContext.escape(e)}, 0)`}).join();n.push(`\nON CONFLICT (${i}) DO UPDATE SET (${s}) = (${a})`)}if(a.length)n.push(`\nRETURNING ${a.join(",")}`);const o=e.schemaName,i=e.columnNames;let l="",u=n.join("");if(t.useUpsert)l=this.getUpsertFunctionSql(o,i,u),u=`SELECT ${o}.upsert(${e.parameterNames.join(",")});`;return{sql:u,sqlParameters:e.sqlParameters,upsertFunctionSql:l}}static async dropUpsertSqlFunction(e){await new schema_sql_context_1.SchemaSqlContext(e.application).executeSqlStatement({sql:`DROP FUNCTION IF EXISTS ${e.schemaName}.upsert;`}),e.sqlFunctionCache.queryWithIgnoredErrors=""}static async _createUpsertSqlFunction(e,t){if(e.sqlFunctionCache.queryWithIgnoredErrors===t)return;await SqlInsert.dropUpsertSqlFunction(e),await new schema_sql_context_1.SchemaSqlContext(e.application).executeSqlStatement({sql:t}),e.sqlFunctionCache.queryWithIgnoredErrors=t}async _executeUpsertSqlFunction(e,t,r){try{await SqlInsert._createUpsertSqlFunction(e,t.upsertFunctionSql);const s=await custom_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"upsert"},()=>e.executeSql(t.sql,r));return s[0].upsert}catch(e){throw sqlLogger.error(`Upsert failed into table ${this.table.name}.\nSQL: ${t.sql.replace(/\n/g,"\n\t")}\nparameters: ${r}`),e}}upsertConflictErrorMessage(e,t,r,s){return`Could not upsert into ${e.schemaName}.${this.table.name} because of key conflicts\nmessage: ${t._err_message}\ndetails: ${t._err_detail}\nsql: ${r.upsertFunctionSql}\nvalues: \n\t - ${r.sqlParameters.map((e,t)=>`${e.valuePath}: ${s[t]}`).join("\n\t - ")}\n                `}async fetchIdFromNaturalKey(e,t){const r=this.factory.isContentAddressable?["_valuesHash"]:this.factory.naturalKey;if(!r)throw new xtrem_shared_1.LogicError(`${this.factory.name} cannot fetch _id: natural key missing`);const s=new sql_converter_1.SqlConverter(e,this.factory),a=[],n=[],o=[];if(!this.factory.isSharedByAllTenants)a.push(s.addSqlParameter({valuePath:t._tenantId?"values._tenantId":"context.tenantId",type:"string"})),n.push("_tenant_id"),o.push(false);r.forEach(e=>{const t=this.factory.findProperty(e),r=t.isReferenceProperty()?t.targetFactory.name:void 0;a.push(s.addSqlParameter({valuePath:`values.${e}`,type:t.type,factoryName:r})),n.push(t.columnName),o.push(t.isNullable)});const i=n.map((e,t)=>`(${e} = ${a[t]}${o[t]?` OR (${e} IS NULL AND ${a[t]} IS NULL)`:""})`).join(" AND "),l=`SELECT _id FROM ${this.table.getFullTableName(e)} WHERE ${i}`,u=await sql_converter_1.SqlConverter.getParameterValues(e,s.sqlParameters,{values:t}),c=await custom_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"select"},()=>e.executeSql(l,u));if(1!==c.length)throw new xtrem_shared_1.LogicError(`${this.factory.name} cannot fetch _id: no match with natural key`);return c[0]._id}async insertValues(e,t,r,s){const{sql:a,sqlParameters:n}=r;let o;const i=await sql_converter_1.SqlConverter.getParameterValues(e,n,{values:t});if(s.useUpsert){if(o=await this._executeUpsertSqlFunction(e,r,i),o._upsert_failed){const t=this.upsertConflictErrorMessage(e,o,r,i);if(s.ignoreUpsertErrors)return sqlLogger.error(t),{};throw new Error(t)}if(o._create_stamp)o._create_stamp=new Date(`${o._create_stamp}Z`);if(o._update_stamp)o._update_stamp=new Date(`${o._update_stamp}Z`)}else{const r=e.transaction.connection;try{o=await custom_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"insert"},()=>e.sqlPool.execute(r,a,i))}catch(e){throw sqlLogger.error(`Insert failed into table ${this.table.name}.\nSQL: ${a.replace(/\n/g,"\n\t")}\nparameters: ${i}`),e}if(0===o.updateCount){if(!a.includes("ON CONFLICT DO NOTHING"))throw new xtrem_shared_1.LogicError("unexpected updateCount 0");o._id=await this.fetchIdFromNaturalKey(e,t)}}if(delete o.updateCount,o&&Object.keys(o).length)sql_context_2.SqlContext.logger.verbose(()=>`Returning values: ${JSON.stringify(o)}`);return o}getCacheKey(e,t){return{kind:t.useUpsert?"upsert":"insert",schemaName:e.schemaName,factoryName:this.factory.name,options:{...t,insertedColumns:t.insertedColumns.map(e=>e.columnName),locale:e.currentLocale,locales:e.locales,processLocalizedTextAsJson:e.processLocalizedTextAsJson}}}async insert(e,t,r={}){try{const{row:s,allNewKeys:a,isRootUserInsert:n,insertedColumns:o}=await this.prepareRow(e,t,r),i={...r,isRootUserInsert:n,insertedColumns:o},l=this.factory.application.sqlStatementCache.fetch({getKeyData:()=>this.getCacheKey(e,i),buildStatement:()=>{const t=new sql_converter_1.SqlConverter(e,this.factory),s=this.getInsertInfo(t,i);return this.getInsertSql(s,r)}}),u=await this.insertValues(e,s,l,{useUpsert:!!r.useUpsert,ignoreUpsertErrors:!!r.ignoreUpsertErrors});return{...a,...u}}finally{if(e.testMode)this.table.markAsModifiedForTests()}}getMetadataInsertInfo(e,t,r){const s=[],a=[],n={};if(t.columns.forEach(t=>{let o=lodash.camelCase(t.name);if(t.name.startsWith("_"))o=`_${o}`;n[o]=true,r[o]=r[o]??null,a.push(sql_context_2.SqlContext.escape(t.name)),s.push(e.addSqlParameter({valuePath:`values.${o}`,type:t.isEncrypted?"encryptedString":t.type}))}),!n._updateTick)if(a.push(sql_context_2.SqlContext.escape("_update_tick")),s.push(e.addSqlParameter({valuePath:"values._updateTick",type:"integer"})),!r._updateTick)r._updateTick=1;if(r._tenantId&&!n._tenantId)a.push(sql_context_2.SqlContext.escape("_tenant_id")),s.push(e.addSqlParameter({valuePath:"values._tenantId",type:"string"}));const o=this.getReturningColumnNames(e.context),i=e.context.schemaName,l=e.sqlParameters,u=t.naturalKeyColumns;return{schemaName:i,columnNames:a,sqlParameters:l,parameterNames:s,returningColumns:o,upsertKeyColumns:u}}insertWithMetadata(e,t,r,s){const a=this.factory.application.sqlStatementCache.fetch({getKeyData:()=>this.getCacheKey(e,s),buildStatement:()=>{const a=new sql_converter_1.SqlConverter(e,this.factory),n=this.getMetadataInsertInfo(a,t,r);return this.getInsertSql(n,s)}});return this.insertValues(e,r,a,{useUpsert:!!s.useUpsert,ignoreUpsertErrors:!!s.ignoreUpsertErrors})}async insertFromSqlFile(e,t,r={}){const{row:s,allNewKeys:a,isRootUserInsert:n,insertedColumns:o}=await this.prepareRow(e,t,r);if(r.metadata)return{...a,...await this.insertWithMetadata(e,r.metadata,s,{...r,isRootUserInsert:n,insertedColumns:o})};return this.insert(e,t,r)}}exports.SqlInsert=SqlInsert;
//# sourceMappingURL=sql-insert.js.map