/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.garbageCollectContentAddressableTables=exports.garbageCollectContentAddressableTable=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),loggers_1=require("../../runtime/loggers");function getGcFunctionName(e){return`pg_temp.gc_${e}`}function getCreateGcFunctionSql(e,t){return`\n    CREATE OR REPLACE FUNCTION ${getGcFunctionName(t)}() RETURNS INT8 AS $$\n    DECLARE\n        r RECORD;\n        deleted INT8;\n        total INT8;\n        done INT8;\n    BEGIN\n        total = (SELECT COUNT(*) FROM ${e}.${t});\n        deleted = 0;\n        done = 0;\n        FOR r IN\n            SELECT _id FROM ${e}.${t}\n        LOOP\n            BEGIN\n                DELETE FROM ${e}.${t} WHERE _id = r._id;\n                deleted = deleted + 1;\n                RAISE NOTICE '${t} table gc: deleted %', r._id;\n            EXCEPTION WHEN foreign_key_violation THEN NULL;\n            done = done + 1;\n            IF MOD(done, 1000) = 0 OR done = total THEN\n                RAISE INFO '${t} table gc: % processed % out of %', CONCAT(ROUND(100 * done / total), '%'), done, total;\n            END IF;\n            END;\n        END LOOP;\n        return deleted;\n    END $$ LANGUAGE plpgsql;\n    `}async function garbageCollectContentAddressableTable(e,t){const n=t.tableName;if(!n)throw t.logicError("no table name");const a=getCreateGcFunctionSql(e.application.schemaName,n);await e.executeSql(a,[]);const l=getGcFunctionName(n);return e.executeSql(`SELECT FROM ${l}()`,[])}async function garbageCollectContentAddressableTables(e){await(0,xtrem_async_helper_1.asyncArray)(e.application.getAllSortedFactories().filter(e=>e.isContentAddressable)).forEach(async t=>{const n=await e.runInWritableContext(e=>garbageCollectContentAddressableTable(e,t));loggers_1.loggers.application.info(`${t.tableName}: ${n} records purged by GC`)})}exports.garbageCollectContentAddressableTable=garbageCollectContentAddressableTable,exports.garbageCollectContentAddressableTables=garbageCollectContentAddressableTables;
//# sourceMappingURL=gc-content-addressable-tables.js.map