/// <reference types="node" />
/// <reference types="node" />
import { ServerConfig } from '@sage/xtrem-shared';
import { Request } from 'express';
import * as https from 'node:https';
import * as tls from 'tls';
export interface InternalServerConfig extends ServerConfig {
    sslShallowCopy?: tls.TlsOptions;
}
export declare function initTlsLayer(): void;
export declare function loadExtraConfig(): Promise<void>;
export declare function registerTlsChangeListener(server: tls.Server, configPath: string, name: string): void;
export declare function getInteropHttpsAgent(): https.Agent | null;
export declare function getTlsConfig(): tls.ConnectionOptions;
export declare function getPeerCertificate(req: Request): tls.PeerCertificate | null;
//# sourceMappingURL=tls.d.ts.map