/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getServerUrl=exports.retry=exports.randomString=exports.defaultAlphabet=exports.getLanguageFromLocale=exports.convertDataKey=exports.getDefaultableReferenceProperties=exports.sortFactories=exports.getFactoryDependsOn=exports.tenantCondition=exports.isCompound=exports.isScalar=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_toposort_1=require("@sage/xtrem-toposort"),lodash=require("lodash"),sql_1=require("../sql"),index_1=require("../types/index"),loggers_1=require("./loggers");function isScalar(e){if(!e)return true;if(xtrem_decimal_1.Decimal.isDecimal(e))return true;if(xtrem_date_time_1.Datetime.isDatetime(e))return true;if(xtrem_date_time_1.DateValue.isDate(e))return true;if(xtrem_date_time_1.DateRange.isDateRange(e))return true;if(xtrem_date_time_1.DatetimeRange.isDatetimeRange(e))return true;if(xtrem_date_time_1.IntegerRange.isIntegerRange(e))return true;if(xtrem_date_time_1.DecimalRange.isDecimalRange(e))return true;if(e instanceof index_1.Uuid)return true;return"object"!=typeof e}function isCompound(e){return!isScalar(e)}function tenantCondition(e,t,r,n){const{context:a}=e;if(!t.isSharedByAllTenants&&null==a.tenantId&&!a.unsafeApplyToAllTenants)throw new Error("Invalid null tenantId");const o=r?`${r}.`:"",s=[...n];if(!t.isSharedByAllTenants&&null!=a.tenantId)s.push(`${o}_tenant_id = ${e.addSqlParameter({valuePath:"context.tenantId",type:"string"})}`);return sql_1.SqlConverter.and(s)}function getFactoryDependsOn(e,t){const r=[],addPolymorphicDependencies=e=>{if(!r.includes(e.name))r.push(e.name);if(e.isAbstract)t.filter(t=>t.baseFactory===e).forEach(e=>addPolymorphicDependencies(e))};e.properties.filter(e=>e.isStored).forEach(t=>{if(t.isReferenceProperty()&&t.isToposortDependency)addPolymorphicDependencies(t.targetFactory);if(t.dependsOn)t.dependsOn.forEach(t=>{("string"==typeof t?[t]:Object.keys(t)).forEach(t=>{const r=e.findProperty(t);if(r.isReferenceProperty()&&r.isToposortDependency&&!r.isVital)addPolymorphicDependencies(r.targetFactory)})})});const n=e.baseFactory;if(n)r.push(n.name);return r}function sortFactories(e){const t=new Map;e.filter(e=>e.baseFactory).forEach(t=>{let r=t.baseFactory;for(;r&&!e.includes(r);)e.push(r),r=r.baseFactory});const r=e.map(r=>{const n=getFactoryDependsOn(r,e);return t.set(r.name,r),{name:r.name,dependsOn:n}});let n=(0,xtrem_toposort_1.topoSort)(r).map(e=>t.get(e.name)),a=false;if(["SysTenant","SysCustomer"].forEach(e=>{const t=n.find(t=>t.name===e);if(t)n.unshift(t),a=true}),a)n=lodash.uniq(n);return n}function isDefaultableReferenceProperty(e,t){return e.isStored&&e.isReferenceProperty()&&(e.isNullable||e.isSelfReference)&&(!t||t.includes(e.name))}function getDefaultableReferenceProperties(e,t){return e.properties.filter(e=>isDefaultableReferenceProperty(e,t))}function convertDataKey(e,t){let conversionFunction=e=>e;switch(t){case"camelCase":conversionFunction=lodash.camelCase;break;case"snakeCase":conversionFunction=lodash.snakeCase}return e.map(e=>{const t={};return Object.keys(e).forEach(r=>{const n=r.startsWith("_")?`_${conversionFunction(r)}`:"$layer"===r?r:conversionFunction(r);t[n]=e[r]}),t})}function getLanguageFromLocale(e){if("base"===e)return"en";const t=e.split("-")[0];if(!t||t.length>2)throw Error(`Locale ${e} not supported`);return t}function randomString(e=100,t=exports.defaultAlphabet){return[...Array(Math.floor(e*Math.random())+1)].map(()=>t[Math.floor(Math.random()*t.length)]).join("")}async function retry(e,t={maxTries:3,delayBeforeRetry:1e3}){const{maxTries:r,delayBeforeRetry:n}=t,a=Math.max(r,1),o=[];for(let r=1;r<=a;r+=1)try{return await e()}catch(e){loggers_1.loggers.application.error(()=>`Retry ${r}/${a} [${t.message??""}]: ${1===r?e.stack:e.message}`);let s=e?.response?.data?.error||e.message||e;if("string"!=typeof s)s=JSON.stringify(s);if(!o.includes(s))o.push(s);if(t.onError)t.onError(e);await new Promise(e=>{setTimeout(e,n)})}const s=10;if(o.length>s)loggers_1.loggers.application.error(()=>`Retry as more than ${s} errors types. The combined error has been truncated.`);throw new xtrem_shared_1.SystemError(o.slice(0,s).join("\n\n"))}function getServerUrl(e,t){const r=xtrem_config_1.ConfigManager.current,n=r.apps?.[r.app||""]?.appUrl||`http://localhost:${r.server?.port||"8240"}`,a=r.security?.redirectUrl||n,o=new URL(a);if(o.pathname=e,t)o.search=t.toString();return o.href}exports.isScalar=isScalar,exports.isCompound=isCompound,exports.tenantCondition=tenantCondition,exports.getFactoryDependsOn=getFactoryDependsOn,exports.sortFactories=sortFactories,exports.getDefaultableReferenceProperties=getDefaultableReferenceProperties,exports.convertDataKey=convertDataKey,exports.getLanguageFromLocale=getLanguageFromLocale,exports.defaultAlphabet=' !"#$%&()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_abcdefghijklmnopqrstuvwxyz{|}~',exports.randomString=randomString,exports.retry=retry,exports.getServerUrl=getServerUrl;
//# sourceMappingURL=utils.js.map