/** @ignore */ /** */
import { AnyRecord, AnyValue, AsyncReader, AsyncResponse } from '@sage/xtrem-async-helper';
import { SqlCreateTableOptions } from '@sage/xtrem-postgres';
import { Dict, LogicError, SystemError } from '@sage/xtrem-shared';
import { Application, ServiceOption } from '../application';
import { Package, PackageValidationContext } from '../application/package';
import { BaseCollection } from '../collections/base-collection';
import { Decorated, ExternalStorageManager, IsolationLevel, IsolationLevels, MessageListener, NodeKey, NodeStorage, NotificationListener, NotifyOperation, PlainOperationDecorator, PropertyFilterTag, StaticThis, StringOrNumberOrNull } from '../decorators';
import { NodeFilterTag } from '../decorators/decorator-utils';
import { NodeEvents, NodeRuleName } from '../decorators/node-decorators/node-events';
import { NodeState } from '../node-state';
import { ForeignNodeProperty, ReferenceProperty, StringProperty } from '../properties';
import { Property } from '../properties/property';
import { DropTableOptions } from '../sql';
import { OrderByClause, SqlQuery } from '../sql/mapper';
import { Column, ForeignKey, Table } from '../sql/schema';
import { AnyFilterObject, Node, NodeQueryFilter, NodeQueryOptions, OrderBy } from '../ts-api';
import { NodeSelector } from '../ts-api/node-select-types';
import { Context, NodeDeleteOptions, StandardOperation } from './context';
import { ErrorParameters, FactoryDecorators, FactoryLinkedList, FactoryNodeDecorator, FindPropertyOptions, NodeIndex, ReferringProperty } from './node-factory-types';
import { PropertyDecorator } from './property';
/** @disabled_internal */
export declare class NodeFactory {
    #private;
    nodeConstructor: typeof Node;
    /**
     * Cached value for the natural key
     * 'null' means the cache is not computed yet
     */
    private _naturalKey;
    readonly nodeDecorator: FactoryNodeDecorator;
    private decoratorWarnings;
    properties: Property[];
    /**
     * The list of properties that will be lazy-loaded, i.e. not loaded when loading the node but only when explicitly read from the code.
     */
    lazyLoadedProperties: Property[];
    storedEncryptedProperties: StringProperty[];
    mutableProperties: ForeignNodeProperty[];
    propertiesByName: Dict<Property>;
    keyProperties: Property[];
    mutations: PlainOperationDecorator[];
    queries: PlainOperationDecorator[];
    notificationListeners: NotificationListener[];
    messageListeners: MessageListener[];
    events: NodeEvents<Node>;
    private _table;
    initialized: boolean;
    publishedSystemProperties: Dict<Property>;
    publishedInputSystemProperties: string[];
    referringProperties: ReferringProperty[];
    dependsOn?: string[];
    storage?: NodeStorage;
    indexes?: NodeIndex[];
    impactingServiceOptions: string[];
    decorators: FactoryDecorators;
    extensions?: any[];
    private _extendedVitalFactories?;
    private readonly _package;
    private readonly _taggedProperties;
    private _baseFactory;
    private _subFactories;
    private staticMethods;
    private nonStaticMethods;
    constructor(pack: Package, clas: StaticThis<Node>, decorators: FactoryDecorators);
    private registerEvents;
    private cloneDecoratorsAttributes;
    private verifyNaturalKey;
    /**
     * Raise an error if a factory has multiple unique indexes
     */
    private ensureNoMultipleUniqueIndexes;
    private verifyIndex;
    invalidateCache(context: Context): Promise<void>;
    get defaultOrderByClauses(): OrderByClause[];
    get table(): Table;
    set table(table: Table);
    get externalStorageManager(): ExternalStorageManager<Node> | undefined;
    get serviceOptions(): ServiceOption[];
    get isAbstract(): boolean;
    /**
     * Returns whether the factory is the root factory of a hierarchy.
     * It will return false when the factory does not belong to a hierarchy (not a base factory)
     */
    get isRootAbstractFactory(): boolean;
    get isVitalReferenceChild(): boolean;
    get isVitalCollectionChild(): boolean;
    get isAssociationCollectionChild(): boolean;
    get isVitalChild(): boolean;
    get isAssociationChild(): boolean;
    get isPublished(): boolean;
    get isCached(): boolean;
    get canRead(): boolean;
    get canCreate(): boolean;
    get canUpdate(): boolean;
    get canDelete(): boolean;
    get canDuplicate(): boolean;
    get notifies(): NotifyOperation[];
    get canAudit(): boolean;
    /**
     * Can the node be duplicated,
     * eventually because one of its vital ancestors can be duplicated,
     * or because one of its subclasses can be duplicated
     */
    get canBeDuplicated(): boolean;
    get canBulkDelete(): boolean;
    get canDeleteMany(): boolean;
    /**
     * Can this node be exported?
     */
    get canExport(): boolean;
    get isSetupNode(): boolean;
    get hasVendorProperty(): boolean;
    get hasAttachments(): boolean;
    get hasLookupAccess(): boolean;
    get isPlatformNode(): boolean;
    get isPlatformNodeExportable(): boolean;
    get isSkippedByLayerExtract(): boolean;
    get isContentAddressable(): boolean;
    get keyPropertyNames(): string[];
    /**
     * Returns a consolidated list of unique indexes of the factory of the state.
     * The primary key will always be the first entry in the list (_id for services but may be a composite for X3)
     */
    get uniqueKeyProperties(): string[][];
    get vitalParentProperty(): ReferenceProperty;
    get associationParentProperties(): ReferenceProperty[];
    get vitalParentFactory(): NodeFactory;
    /**
     * Is the factory a vital child, were the parent node is a setup node
     */
    get isSetupNodeVitalChild(): boolean;
    get isClearedByReset(): boolean | undefined | ((this: Node) => AsyncResponse<boolean>);
    private _retrieveNaturalKey;
    /**
     * Returns the natural key for the factory
     * Note: the natural key decorator may come from the factory itself, from its baseFactory or from a vital parent.
     */
    get naturalKey(): string[] | undefined;
    get delegatedProperties(): Property[];
    get vitalProperties(): ForeignNodeProperty[];
    get prepareBegin(): NodeEvents['prepareBegin'];
    get prepareEnd(): NodeEvents['prepareEnd'];
    /**
     * If `this` is abstract, returns the concrete factories that extend `this`.
     * Otherwise returns `[this]`, as `this` is a concrete factory.
     */
    getConcreteFactories(result?: NodeFactory[]): NodeFactory[];
    isSubNodeOf(name: string): boolean;
    isAssignableTo(factory: NodeFactory): boolean;
    isEnabledByServiceOptions(context: Context): Promise<boolean>;
    private getInternalSystemProperties;
    private addProperty;
    createMainNodeProperties(definingPackage: Package): void;
    addExtensionDecorator(extension: any): void;
    private createProperties;
    private getExtensionDepth;
    private checkExtensionDepth;
    /**
     * Returns the package that defines an extension
     */
    static getExtensionPackage(extension: any): Package;
    /** Merge all the extension decorators.*/
    mergeExtensions(pack: Package): void;
    /** Merge static and non static methods from an extension. */
    mergeExtensionMethods(extension: typeof Decorated): void;
    /** Merge static and non static methods from superNode into subNode. */
    mergeSubNodeMethods(extension: typeof Decorated): void;
    /** Merge static and non static methods. */
    private mergeMethods;
    private mergeOperationKind;
    private mergeOperations;
    private mergeListeners;
    /** Merge the superNode's header characteristics into the subNode. */
    private mergeSubNodeHeader;
    private mergeExtensionHeader;
    private subclassDepth;
    checkSubclassDepth(): void;
    /** - add to the current subNode the queries, mutations, attributes and methods
     * brought by the superclasses. */
    mergeSubNodes(): void;
    createSuperNodeProperties(definingPackage: Package): void;
    createSubNodeProperties(definingPackage: Package): void;
    createSubNodeOverrides(): void;
    private verifyIsContentsAddressable;
    private verifyIsSynchronizable;
    private verifyIsSynchronized;
    private verifyDefaultsToSingleMatch;
    verify(): void;
    /**
     * Verify a factory with isVitalChild decorator
     */
    private _verifyVitalChildFactory;
    /**
     * Verify a factory with isClearByReset decorator
     */
    private _verifyClearedByResetFactory;
    /**
     * return the indexes defined (not inherited) by this factory.
     */
    getSelfIndexes(): NodeIndex[];
    verifyJoins(): void;
    /**
     * Verifies that the table is compliant with the factory definition
     */
    verifyTable(context: Context, options?: {
        doNotRecurseOnReferences?: boolean;
        factoryLinkedList?: FactoryLinkedList;
        foreignFactories?: NodeFactory[];
        compareToSqlSchema?: boolean;
    }): Promise<void>;
    computeDependencyIndex(): void;
    setSubFactories(): void;
    private fillVitalProperties;
    private fillDelegatedProperties;
    private fillMutableProperties;
    get strictMutableProperties(): ForeignNodeProperty[];
    addUpdateActionProperty(): void;
    complement(packageValidationContext?: PackageValidationContext): void;
    private complementFactoryIndexes;
    private addSystemProperties;
    private computePropagationPaths;
    private createNewTableColumns;
    get defaultOrderBy(): OrderBy<Node>;
    get package(): Package;
    get application(): Application;
    get name(): string;
    get fullName(): string;
    get baseFactory(): NodeFactory | undefined;
    get rootFactory(): NodeFactory;
    get rootCollectionFactory(): NodeFactory | undefined;
    get rootVendorFactory(): NodeFactory | undefined;
    get isSharedByAllTenants(): boolean;
    get tableName(): string | undefined;
    get fullTableName(): string | undefined;
    resolveReferenceId(context: Context, value: StringOrNumberOrNull | Node): Promise<number | null>;
    /**
     * Get all node factories in the vital tree of a given node factory, including itself
     */
    getVitalTree(): NodeFactory[];
    /**
     * Returns all the table names in the factory's hierarchy tree, from the root to the leaves.
     */
    getAllTableNames(): string[];
    get authorizationCode(): string | undefined;
    getIsolationLevel(key: keyof IsolationLevels): IsolationLevel;
    get provides(): NodeFilterTag[] | undefined;
    /**
     * Returns the list of sub-classing factories
     */
    get subFactories(): NodeFactory[];
    private checkDecorators;
    private checkExternalDecorator;
    private checkIncompatibleAttributes;
    private setTaggedProperty;
    getTaggedProperty(tag: PropertyFilterTag): Property | undefined;
    private findReverseProperty;
    private warnDecorator;
    private checkPropagatesTo;
    private addPropagatePaths;
    systemError(message: string): SystemError;
    authorizationError(context: Context, params: ErrorParameters): SystemError;
    logicError(message: string, innerError?: Error): LogicError;
    propertySystemError(property: PropertyDecorator | Property, message: string): SystemError;
    checkCanMutate(context: Context, verb: string): void;
    checkCanCreate(context: Context): void;
    checkCanDelete(context: Context): void;
    checkCanUpdate(context: Context): void;
    checkCanDeleteMany(context: Context): void;
    addPropertyAccessors(property: Property): void;
    getAllIndexes(): NodeIndex[];
    getKeyValues(context: Context, data: AnyRecord, options?: {
        allocateTransient: boolean;
        isTransient?: boolean;
        isOnlyForDefaultValues?: boolean;
        isOnlyForDuplicate?: boolean;
        writable?: boolean;
        isOnlyForLookup?: boolean;
        collection?: BaseCollection;
    }): Dict<AnyValue>;
    getLocalizedTitleKey(): string;
    getLocalizedTitle(context: Context): string;
    delete(context: Context, key: AnyRecord): Promise<void>;
    deleteMany(context: Context, keyOrFilter: NodeQueryFilter<Node>, options?: NodeDeleteOptions): Promise<number>;
    query(context: Context, options?: NodeQueryOptions): Promise<AsyncReader<Node>>;
    private getAllowedAccessCodes;
    private getPropertyFilter;
    private getNodeFilter;
    getAccessRightsFilter(context: Context): Promise<AnyFilterObject | undefined>;
    /**
     * Lazy load the value of some properties.
     * This function should only be used when a node has already been loaded but some of its
     * properties were not loaded (mainly stream properties)
     * @param idValue the '_id' of the record we want to lazy load the properties for.
     * @param properties the list of property to load
     * @returns
     */
    createLazyLoadedValueQuery(context: Context, idValue: number, properties: Property[]): Promise<SqlQuery>;
    createNodeQuery(context: Context, options: NodeQueryOptions, selector?: NodeSelector<Node>): Promise<SqlQuery>;
    queryCount(context: Context, options: NodeQueryOptions): Promise<number>;
    exists(context: Context, key: NodeKey<Node>): Promise<boolean>;
    /**
     * Returns a token that uniquely identifies a Node (based on its PK) WITHIN ITS FACTORY.
     * @param values
     */
    getToken(values: Dict<AnyValue>): string;
    findProperty(name: string, options?: FindPropertyOptions): Property;
    parseOrderBy(context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
    getValuesHash(values: Dict<AnyValue>): string;
    getTableColumns(): Column[];
    private static getOnDeleteBehavior;
    /**
     * Creates a foreignKey
     */
    createForeignKey(referenceFactory: NodeFactory, property: ReferenceProperty, isBase?: boolean): ForeignKey | null;
    getForeignKeys(): ForeignKey[];
    private makeTable;
    missingClassDecorator(memberName: keyof FactoryNodeDecorator): SystemError;
    missingPropertyDecorator(propertyName: string, memberName: keyof PropertyDecorator): SystemError;
    getNodeSchemaDescription(): string;
    /**
     * Fixes the sequences for the list of provided factories
     * @param application
     * @param factories the list of factories to process (will process all the factories if not provided)
     * @returns the factories where the sequences were fixed
     */
    static fixSequences(application: Application, tenantId: string | null): Promise<NodeFactory[]>;
    /**
     * Fix the sequences of the table of the factory
     */
    fixAutoIncrementSequences(tenantId: string | null): Promise<void>;
    ensureTableExists(context: Context, options?: SqlCreateTableOptions): Promise<void>;
    ensureAllTableColumnsExists(context: Context): Promise<void>;
    dropTable(context: Context, options?: DropTableOptions): Promise<void>;
    /**
     * Walk the value for the natural key of the factory, parsing the _id  filter value to a filter object consisting of
     * the natural key properties.
     * Example:
     *  MainFactory natural key: [code, reference]
     *  ReferenceFactory natural key: [code, innerReference]
     *  InnerRefenceFactory natural key: [code]
     *  Therefore the value can be passed as follows: '#mainCode|referenceCode|innerReferenceCode'
     *  This will resolve to {code:'mainCode',reference:{code:'referenceCode',innerReference:{code:'innerReferenceCode'}}}
     * @param value
     * @param path
     * @returns
     */
    private resolveKeyFilter;
    /**
     * Parse the node id passed returning an object value representing the a filter.
     * If the factory has a natural key then the value can be passed as a string starting with a #.
     * For the the # values we walk and resolve the factories natural key and recursively of any reference factories.
     * @param val can be passed in as a number or string beginning with #.
     * @returns
     */
    parseNodeId(val: string | number | undefined): Dict<AnyValue>;
    /**
     * Returns the natural key string value for the given data.
     * If a property value is an object and a reference property, it recursively calls the target factory's getNaturalKeyStringValue method.
     * @param data - The data object containing the property values.
     * @returns The natural key string value.
     * @throws LogicError - If the factory does not have a natural key.
     */
    getNaturalKeyStringValue(context: Context, data: Dict<AnyValue>): Promise<string>;
    /**
     * Returns the natural key value for the given node instance.
     * If a property is a reference property, it recursively calls the target factory's getNaturalKeyValueFromNode method.
     * @param node - The node instance.
     * @returns The natural key as an object.
     * @throws LogicError - If the factory does not have a natural key.
     */
    getNaturalKeyValueFromNode(node: Node): Promise<AnyRecord>;
    /**
     * Walks the natural key properties and returns the length of the natural key.
     * If a property is a reference property, it recursively calls the target factory's getNaturalKeyValueLength method.
     * This will get us the true length of the natural key value that will be concatenated with `|`
     * @returns The natural key length.
     * @throws LogicError - If the factory does not have a natural key.
     */
    getNaturalKeyValueLength(): number;
    /**
     * Retrieves the reverse vital property associated with this node factory.
     * A reverse vital property is a property that references this node factory as its target.
     *
     * @returns The reverse vital property, or undefined if it doesn't exist.
     * @throws An error if the vital parent property doesn't have a unique child property with the same name as this factory.
     */
    getReverseVitalProperty(): Property | undefined;
    /**
     * Returns the list of operations that require admin privileges.
     */
    get adminOperations(): string | (keyof Node | StandardOperation)[] | undefined;
    /** Can this node be customized with customFields
     * In the case of sub nodes, if a value is set for the isCustomizable decorator on the sub node,
     * it will override the value set on the base node, otherwise, if no value set on the sub node,
     * the value of the base node will be inherited
     */
    get isCustomizable(): boolean;
    /** Is this node a synchronization source */
    get isSynchronizable(): boolean;
    /** Is this node a synchronization target */
    get isSynchronized(): boolean;
    get defaultsToSingleMatch(): boolean;
    get denyReadOnLookupOnlyAccess(): boolean;
    executeRule<ResultT extends AnyValue>(state: NodeState, ruleName: NodeRuleName, ...args: AnyValue[]): Promise<ResultT>;
}
export { FactoryDecorators };
//# sourceMappingURL=node-factory.d.ts.map