/** @ignore */ /** */
import { Dict } from '@sage/xtrem-shared';
import { Parameter, PlainOperationDecorator, TypeName } from '../decorators';
import { Property } from '../properties';
import { NodeFactory } from './node-factory';
import { NodeIndex } from './node-factory-types';
export declare function sameIndexProperties(index1: NodeIndex, index2: NodeIndex): boolean;
export declare function arraysAreEqual(a: any[], b: any[]): boolean;
export declare function getSchemaDescription(name: string, code: string | undefined): string;
export declare function getPropertySchemaDescription(property: Property): string;
/**
 * Ensures that a setup factory does not have more than one unique index.
 */
export declare function ensureNoMultipleUniqueIndexes(factory: NodeFactory): void;
export type FriendlyParameter = (Omit<Omit<Omit<Omit<Parameter, 'node'>, 'dataType'>, 'item'>, 'properties'> & {
    node?: string;
    dataType?: string;
    item?: FriendlyParameter;
    properties?: Dict<FriendlyParameter>;
}) | TypeName;
export declare function friendlyOperationSignature(operation: PlainOperationDecorator): {
    parameters: FriendlyParameter[];
    return: FriendlyParameter;
};
//# sourceMappingURL=node-factory-utils.d.ts.map