import { AnyValue } from '@sage/xtrem-async-helper';
import { GetValueCallback } from '../cache/global-cache';
import { Context } from './context';
import { NodeFactory } from './node-factory';
export declare class NodeFactoryCache {
    #private;
    readonly factory: NodeFactory;
    constructor(factory: NodeFactory);
    get cacheCategory(): string;
    /** fetches data through the cache */
    fetch<T extends AnyValue>(context: Context, options: {
        getKey: () => string;
        getValue: GetValueCallback<T>;
        isolateInContext: boolean;
    }): Promise<T>;
    /**
     * Invalidates the factory's category in the cache.
     * This is called when records are inserted, updated and deleted in the factory's table
     */
    invalidate(context: Context): Promise<void>;
    /** Returns the performance counters for the factory's cache */
    get counters(): NodeFactoryCacheCounters & {
        totalQueries: number;
        totalMisses: number;
        totalHitRate: string;
        fetchHitRate: string;
    };
    postToNewRelic(): void;
    get performanceSummary(): string;
    incrementCountQueryCounter(): void;
    incrementIgnoredCounter(): void;
}
//# sourceMappingURL=node-factory-cache.d.ts.map