/** @packageDocumentation @module runtime */
import { Config, DeploymentMode } from '@sage/xtrem-shared';
export { DeploymentMode };
export declare class ConfigurationService {
    private readonly config;
    constructor(config: Config);
    /** deployment mode: allows applicative code to test if code is executing in production or development mode  */
    get deploymentMode(): DeploymentMode;
    /** return the configuration data for a given package
     * @param name: the name of the package. For example '@sage/x3-sales'
     * @param defaultValue: the default value if there is no data in the config file.
     */
    getPackageConfig<T, DefT extends T | undefined = T | undefined>(name: string, defaultValue?: DefT): DefT;
    /** return the visible name of the product */
    getProductName(): string;
}
//# sourceMappingURL=configuration-service.d.ts.map