/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TextStreamProperty=exports.BinaryStreamProperty=exports.StreamProperty=void 0;const xtrem_config_1=require("@sage/xtrem-config"),types_1=require("../types"),property_1=require("./property");class StreamProperty extends property_1.Property{constructor(e,r,t){super(e,r,t),this._decorator=r}get shouldLazyLoad(){if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return false;return!this._decorator.noLazyLoad}}exports.StreamProperty=StreamProperty;class BinaryStreamProperty extends StreamProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return e instanceof types_1.BinaryStream}needsTypeConversion(e){return"string"==typeof e}mapInputValue(e){return types_1.BinaryStream.fromBuffer(Buffer.from(e,"base64"))}get dataType(){return super.dataType}}exports.BinaryStreamProperty=BinaryStreamProperty;class TextStreamProperty extends StreamProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return e instanceof types_1.TextStream}needsTypeConversion(e){return"string"==typeof e}mapInputValue(e){return new types_1.TextStream(e)}verify(){if(super.verify(),this.isNullable)throw this.systemError("A textStream property cannot be nullable")}get dataType(){return super.dataType||types_1.TextStreamDataType.default}}exports.TextStreamProperty=TextStreamProperty;
//# sourceMappingURL=stream-property.js.map