import { AnyValue } from '@sage/xtrem-async-helper';
import { Package } from '../application';
import { BinaryStreamPropertyDecorator, StreamPropertyDecorator, TextStreamPropertyDecorator } from '../decorators';
import { NodeFactory } from '../runtime';
import { BinaryStreamDataType, TextStreamDataType } from '../types';
import { Property } from './property';
export declare abstract class StreamProperty extends Property {
    protected _decorator: StreamPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: StreamPropertyDecorator, definingPackage: Package);
    /**
     * Returns whether this property should be lazy loaded
     */
    get shouldLazyLoad(): boolean;
}
export declare class BinaryStreamProperty extends StreamProperty {
    protected _decorator: BinaryStreamPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: BinaryStreamPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
    get dataType(): BinaryStreamDataType;
}
export declare class TextStreamProperty extends StreamProperty {
    protected _decorator: TextStreamPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: TextStreamPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
    verify(): void;
    get dataType(): TextStreamDataType;
}
//# sourceMappingURL=stream-property.d.ts.map