/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DecimalRangeProperty=exports.IntegerRangeProperty=exports.DecimalProperty=exports.DoubleProperty=exports.FloatProperty=exports.ShortProperty=exports.IntegerArrayProperty=exports.IntegerProperty=exports.NumberProperty=void 0;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),_=require("lodash"),property_1=require("./property"),util_1=require("./util");class NumberProperty extends property_1.Property{constructor(e,r,t){super(e,r,t),this._decorator=r}get isNotZero(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isNotZero;return!!this._decorator.isNotZero}}exports.NumberProperty=NumberProperty;const isValueConvertibleToInteger=e=>"string"==typeof e&&/^[+-]?\d+$/.test(e);class IntegerProperty extends NumberProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return _.isInteger(e)||"_id"===this.name&&"string"==typeof e}needsTypeConversion(e){return isValueConvertibleToInteger(e)}mapInputValue(e){return parseInt(e,10)}}exports.IntegerProperty=IntegerProperty;class IntegerArrayProperty extends property_1.Property{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return Array.isArray(e)&&e.every(e=>_.isInteger(e))}needsTypeConversion(e){return(0,util_1.isArrayOfStrings)(e)&&(0,util_1.stringToArrayOfStrings)(e).every(e=>isValueConvertibleToInteger(e))}mapInputValue(e){return(0,util_1.stringToArrayOfStrings)(e).map(e=>parseInt(e,10))}}exports.IntegerArrayProperty=IntegerArrayProperty;class ShortProperty extends NumberProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return _.isInteger(e)}needsTypeConversion(e){return isValueConvertibleToInteger(e)}mapInputValue(e){return parseInt(e,10)}}exports.ShortProperty=ShortProperty;class FloatProperty extends NumberProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return"number"==typeof e}}exports.FloatProperty=FloatProperty;class DoubleProperty extends NumberProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return"number"==typeof e}}exports.DoubleProperty=DoubleProperty;class DecimalProperty extends NumberProperty{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return"number"==typeof e||xtrem_decimal_1.Decimal.isDecimal(e)}needsTypeConversion(e){return"string"==typeof e&&/^[+-]?([0-9]+\.?[0-9]*|\.[0-9]+)$/.test(e)}mapInputValue(e){return xtrem_decimal_1.Decimal.make(e)}}exports.DecimalProperty=DecimalProperty;class IntegerRangeProperty extends property_1.Property{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return e instanceof xtrem_date_time_1.IntegerRange}}exports.IntegerRangeProperty=IntegerRangeProperty;class DecimalRangeProperty extends property_1.Property{constructor(e,r,t){super(e,r,t),this._decorator=r}isValueTypeValid(e){return e instanceof xtrem_date_time_1.DecimalRange}}exports.DecimalRangeProperty=DecimalRangeProperty;
//# sourceMappingURL=numeric-property.js.map